/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.Range;
import Ace2.SAMTagFilter;
import Ace2.TumorNormal;
import Ace2.dbSNPQuery;
import htsjdk.samtools.SAMRecord;
import java.util.ArrayList;
import java.util.HashSet;

public class SNPConfig {
    int READ_FLUSH_INTERVAL = 1000;
    float MIN_SCORE = 0.0f;
    int MIN_QUALITY = 10;
    float MIN_MINOR_ALLELE_FREQUENCY = 0.05f;
    int MIN_ALT_ALLELE_COUNT = 3;
    int MIN_COVERAGE = 4;
    int MIN_ALT_ALLELE_COUNT_FOR_FILTER_ENABLE = this.MIN_ALT_ALLELE_COUNT * 2;
    int MIN_ALT_READS_WITH_FLANKING_SEQUENCE = 1;
    int MIN_ALT_READS_WITH_FLANKING_SEQUENCE_WINDOW = 10;
    int MIN_UNIQUE_READ_NAMES_FOR_ALT_ALLELE = 1;
    boolean REPORT_ALT_ALLELE_SAM_TAGS = false;
    boolean ENABLE_MISMAPPED_DELETION_FILTER = true;
    int MISMAPPED_DELETION_MIN_DISTANCE_FROM_END = 10;
    boolean ENABLE_FAST_TARGET_REFSEQ = false;
    int FAST_TARGET_REFSEQ_FLANK = 500;
    boolean ENABLE_MATE_PAIR_DISAGREEMENT_FILTER = true;
    boolean ENABLE_END_MISMATCH_FILTER = true;
    int[][] END_MISMATCH_FILTER_WINDOWS = new int[][]{{10, 3}, {6, 2}};
    int MIN_FLANKING_QUALITY = 15;
    int MIN_FLANKING_QUALITY_WINDOW = 5;
    int MIN_UNIQUE_START_POSITIONS_FOR_ALT_ALLELE = 2;
    boolean REPORT_RESULTS = true;
    boolean CHECK_GENOME_VERSION = true;
    String DBSNP_BLOB_FILE = "/h1/edmonsom/dbsnp_binary_v2.blob";
    boolean STREAMING_MODE = true;
    int READ_PING_INTERVAL = 1000000;
    boolean LIMIT_READ_TRACKING = false;
    int READ_TRACKING_LIMIT = -1;
    int READ_TRACKING_LIMIT_TRIGGER = -1;
    int READ_TRACKING_LIMIT_BUCKET_EXEMPTION = 10;
    boolean DEBUG_SNP_MEMORY_USAGE = false;
    int REPORT_DECIMAL_ROUNDING = 3;
    static int TCGA_SAMPLE_FIELD_COUNT = 4;
    static int QUERY_START_BASE = 1;
    boolean AUTODETECT_ILLUMINA_QUALITY_2_RUNS = true;
    int ILLUMINA_QUALITY_2_READ_SCAN_COUNT = 10000;
    int ILLUMINA_QUALITY_2_MIN_RUN_LENGTH = 15;
    boolean ILLUMINA_QUALITY_2_HEADER_CHECKED = false;
    boolean ILLUMINA_QUALITY_2_HEADER_PASSED = false;
    boolean ILLUMINA_QUALITY_2_RUN_MODE = false;
    boolean AVERAGE_INSERTION_QUALITY = false;
    boolean SKIP_NT_QUALITY_CHECKS_FOR_HIGH_MAPQ_INDELS = false;
    int HIGH_MAPQ_INDEL_MIN_LENGTH = -1;
    int HIGH_MAPQ_INDEL_MIN_MAPQ = -1;
    ArrayList<String> SNP_SEARCH_CHR_LIST = null;
    boolean SKIP_RANDOM_REFERENCE_SEQUENCES = true;
    Range SNP_SEARCH_RANGE = null;
    boolean ENABLE_MISMAP_FILTER = true;
    float MISMAP_BASE_FREQUENCY_THRESHOLD = 0.5f;
    boolean ENABLE_READ_REPORT = false;
    String READ_REPORT_FILENAME = null;
    HashSet<String> READ_REPORT_TAGS = null;
    SAMTagFilter sam_tag_filter = null;
    boolean SKIP_NONPRIMARY_ALIGNMENTS = true;
    int MIN_MAPPING_QUALITY = 1;
    boolean ENABLE_MISMATCH_FILTER = true;
    int MISMATCH_FILTER_MAX_HQ_MISMATCH_COUNT = 3;
    int MISMATCH_FILTER_MIN_HIGH_QUALITY = 15;
    boolean ENABLE_MISMATCH_FILTER_HQ_XTU = false;
    int MISMATCH_FILTER_MAX_HQ_MISMATCH_COUNT_XTU = 0;
    int MISMATCH_FILTER_MAX_LQ_MISMATCH_COUNT = 6;
    int MISMATCH_FILTER_MIN_LOW_QUALITY = 3;
    float MISMATCH_FILTER_LQ_WINDOW = 0.0f;
    boolean MISMATCH_FILTER_FORGIVE_DBSNP_MATCHES = true;
    dbSNPQuery snp_query;
    boolean ENABLE_BROAD_BASE_TRACKING = true;
    int BROAD_BASE_TRACKING_MIN_QUALITY = 15;
    boolean USE_TREEMAP = false;
    boolean STRAND_SKEW_FILTER_ENABLE = true;
    int STRAND_SKEW_CALL_MIN_STRAND_COVERAGE = 10;
    int STRAND_SKEW_CALL_MIN_VARIANT_COUNT = 3;
    int STRAND_SKEW_FILTER_MIN_STRAND_COVERAGE = 20;
    int STRAND_SKEW_FILTER_MIN_VARIANT_COUNT = 6;
    double STRAND_SKEW_FILTER_MIN_STRAND_PERCENT_TO_CONSIDER_SKEWED = 0.95f;
    boolean ENABLE_POLY_X_RUN_MASK_INDEL = true;
    int POLY_X_RUN_INDEL_MAX_LENGTH = 1;
    boolean ENABLE_POLY_X_RUN_MASK_SNP = true;
    int POLY_X_MIN_RUN_LENGTH = 8;
    boolean MINOR_ALLELE_MODE = false;
    boolean FISHERS_EXACT_STRAND_BIAS_ENABLE = false;
    double FISHERS_EXACT_STRAND_BIAS_CUTOFF = 0.1f;
    TumorNormal FISHERS_EXACT_DATA_TYPE = TumorNormal.UNKNOWN;
    boolean IGNORE_MISMATCHES_IN_FIRST_READ_BASE = false;
    boolean IGNORE_MISMATCHES_IN_LAST_READ_BASE = false;
    boolean ALLOW_OPTICAL_DUPLICATES = false;
    boolean DUPLICATE_LIMITER_ENABLED = false;
    boolean DUPLICATE_LIMITER_OPTICAL_ONLY = true;
    int DUPLICATE_LIMITER_MAX;
    boolean AUTOTUNE = false;
    boolean MERGE_EQUIVALENT_INDELS = false;
    boolean MERGE_EQUIVALENT_INDELS_VERBOSE = false;
    int EQUIVALENT_INDEL_MAX_DISTANCE = 50;

    public int get_mismatch_filter_max_hq_mismatch_count(SAMRecord sr) {
        int hq_max = this.MISMATCH_FILTER_MAX_HQ_MISMATCH_COUNT;
        if (this.ENABLE_MISMATCH_FILTER_HQ_XTU) {
            for (SAMRecord.SAMTagAndValue tav : sr.getAttributes()) {
                if (!tav.tag.toString().equals("XT") || !tav.value.toString().equals("U")) continue;
                hq_max = this.MISMATCH_FILTER_MAX_HQ_MISMATCH_COUNT_XTU;
            }
        }
        if (this.AUTOTUNE) {
            double max = hq_max * sr.getReadLength();
            hq_max = (int)Math.round(max /= 100.0);
        }
        return hq_max;
    }

    public int get_mismatch_filter_max_lq_mismatch_count(SAMRecord sr) {
        int lq_max = this.MISMATCH_FILTER_MAX_LQ_MISMATCH_COUNT;
        if (this.AUTOTUNE) {
            double max = lq_max * sr.getReadLength();
            lq_max = (int)Math.round(max /= 100.0);
        }
        return lq_max;
    }
}

