/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.Counter;
import Funk.LogicalComparator;
import Funk.NumberComparator;
import Funk.StringComparatorEQ;
import Funk.StringComparatorEQSet;
import Funk.StringComparatorNE;
import Funk.StringComparatorNESet;
import htsjdk.samtools.SAMRecord;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMTagFilter {
    private HashMap<String, LogicalComparator> required_tags;
    private static String SET_DELIMITER = "/";
    private boolean all_tags_required;

    public SAMTagFilter(boolean all_tags_required) {
        this.all_tags_required = all_tags_required;
    }

    public HashMap<String, LogicalComparator> parse(String s) {
        this.required_tags = new HashMap();
        String[] pairs = s.split(",");
        Pattern p = Pattern.compile("^(\\w\\w)(<=|!=|>=|=|<|>)(.*)", 2);
        for (int li = 0; li < pairs.length; ++li) {
            Matcher m = p.matcher(pairs[li]);
            if (m.find()) {
                String tag_name = m.group(1);
                String tag_operator = m.group(2);
                String tag_value = m.group(3);
                LogicalComparator lc = null;
                try {
                    Double d = Double.parseDouble(tag_value);
                    lc = NumberComparator.get_comparator(tag_operator, d);
                    System.err.println("value=" + d + " comp=" + lc);
                }
                catch (NumberFormatException e) {
                    if (tag_operator.equals("=")) {
                        lc = tag_value.indexOf(SET_DELIMITER) != -1 ? new StringComparatorEQSet(tag_value.split(SET_DELIMITER)) : new StringComparatorEQ(tag_value);
                    }
                    if (tag_operator.equals("!=")) {
                        lc = tag_value.indexOf(SET_DELIMITER) != -1 ? new StringComparatorNESet(tag_value.split(SET_DELIMITER)) : new StringComparatorNE(tag_value);
                    }
                    System.err.println("ERROR: string operators may only be = or !=");
                    System.exit(1);
                }
                if (lc == null) {
                    System.err.println("ERROR: no SAM tag comparator");
                    System.exit(1);
                    continue;
                }
                this.required_tags.put(tag_name, lc);
                continue;
            }
            System.err.println("ERROR: -require-tags format is TAG=VALUE[,TAG=VALUE...] where operators are <,<=,=,>=,>");
            System.exit(1);
        }
        return this.required_tags;
    }

    public boolean check(SAMRecord sr, Counter counter) {
        HashSet<String> ok_tags = new HashSet<String>();
        boolean failed = false;
        for (SAMRecord.SAMTagAndValue tav : sr.getAttributes()) {
            if (!this.required_tags.containsKey(tav.tag)) continue;
            LogicalComparator lc = this.required_tags.get(tav.tag);
            if (lc.compare(tav.value)) {
                ok_tags.add(tav.tag);
                continue;
            }
            if (counter != null) {
                counter.increment("tag " + tav.tag);
            }
            failed = true;
        }
        return !failed && (!this.all_tags_required || ok_tags.size() == this.required_tags.size());
    }
}

