/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.File;

public class SAMHeaderReport {
    public void report(String filename, SamReader reader) {
        SAMFileHeader sfh = reader.getFileHeader();
        SAMSequenceDictionary dict = sfh.getSequenceDictionary();
        for (SAMSequenceRecord ssr : dict.getSequences()) {
            System.err.println("sequence=" + ssr.getSequenceName() + " length=" + ssr.getSequenceLength() + " assembly=" + ssr.getAssembly());
        }
        for (SAMProgramRecord rec : sfh.getProgramRecords()) {
            System.out.println("file=" + filename + "|" + "program_name=" + rec.getProgramName() + "|" + "version=" + rec.getProgramVersion() + "|" + "program_group_id=" + rec.getProgramGroupId() + "|" + "command_line=" + rec.getCommandLine());
        }
    }

    public static void main(String[] argv) {
        try {
            SAMHeaderReport shi = new SAMHeaderReport();
            String filename = argv[0];
            SamReader reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(new File(filename));
            shi.report(filename, reader);
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
        }
    }
}

