/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.WorkingFile;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reporter {
    private ArrayList<String> headers = new ArrayList();
    private HashMap<String, Boolean> hl = new HashMap();
    private boolean headers_printed = false;
    private String delimiter = "\t";
    private HashMap<String, String> row;
    private BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(System.out));
    private WorkingFile wf = null;
    private boolean VERBOSE = true;
    private boolean VERBOSE_DF = true;

    public Reporter() {
        this.reset_row();
    }

    public void set_output_filename(String fn) throws IOException {
        if (fn.equals("-")) {
            this.wf = null;
            this.bw = new BufferedWriter(new OutputStreamWriter(System.out));
        } else {
            this.wf = new WorkingFile(fn);
            this.bw = new BufferedWriter(new OutputStreamWriter(this.wf.getPrintStream()));
        }
    }

    public void set_headers(ArrayList<String> headers) {
        this.headers = headers;
        this.hl = new HashMap();
        for (String h : headers) {
            this.hl.put(h, true);
        }
    }

    public void add_header(String h) {
        this.headers.add(h);
        this.hl.put(h, true);
    }

    public void reset_row() {
        this.row = new HashMap();
    }

    public String get_value(String k) {
        return this.row.get(k);
    }

    public void set_value(String k, String v) {
        if (this.hl.containsKey(k)) {
            this.row.put(k, v);
        } else {
            System.err.println("ERROR, invalid column " + k);
        }
    }

    public void end_row() throws IOException {
        int count = 0;
        if (!this.headers_printed) {
            for (String header : this.headers) {
                if (count++ > 0) {
                    this.bw.write(this.delimiter);
                }
                this.bw.write(header);
            }
            this.bw.newLine();
            this.headers_printed = true;
        }
        count = 0;
        for (String h : this.headers) {
            String v = this.row.get(h);
            if (v == null) {
                v = "";
            }
            if (count++ > 0) {
                this.bw.write(this.delimiter);
            }
            this.bw.write(v);
        }
        this.bw.newLine();
        this.reset_row();
    }

    public void close() throws IOException {
        if (this.VERBOSE && this.wf != null) {
            PrintStream ps = this.wf.getPrintStream();
            boolean error = ps.checkError();
            System.err.println("DEBUG: PrintStream checkError(): " + error);
        }
        this.bw.close();
        if (this.wf != null) {
            this.wf.finish();
            if (this.VERBOSE) {
                this.debug_file(this.wf, "temp_output_file", false);
                this.debug_file(this.wf.get_file(), "final_output_file", true);
            }
        }
    }

    private void debug_file(File f, String label, boolean do_df) {
        try {
            System.err.print("DEBUG: " + label + ": " + "abs=" + f.getAbsoluteFile() + " " + "canonical=" + f.getCanonicalFile() + " " + "exists?: " + f.exists() + " ");
            if (f.exists()) {
                System.err.print("size=" + f.length());
            }
            System.err.println("");
            if (do_df && this.VERBOSE_DF) {
                String cmd = null;
                String df = this.find_binary("df");
                if (df == null) {
                    System.err.println("ERROR: can't find df!");
                } else {
                    cmd = f.exists() ? df + " " + f.getAbsoluteFile() : df + " " + f;
                    this.exec_command(cmd);
                }
                String ls = this.find_binary("ls");
                if (ls == null) {
                    System.err.println("ERROR: can't find ls!");
                } else if (f.exists()) {
                    File dir = f.getAbsoluteFile().getParentFile();
                    if (dir == null) {
                        System.err.println("ERROR: no parent");
                    } else {
                        cmd = ls + " -la " + dir.getAbsoluteFile();
                        this.exec_command(cmd);
                    }
                } else {
                    System.err.println("ERROR: can't run ls (need parent)");
                }
            }
        }
        catch (IOException e) {
            System.err.println("ERROR: " + e);
        }
    }

    private String find_binary(String name) {
        String result = null;
        ArrayList<String> locs = new ArrayList<String>();
        locs.add("/bin/" + name);
        locs.add("/usr/bin/" + name);
        locs.add("c:/cygwin/bin/" + name + ".exe");
        for (String loc : locs) {
            File exe = new File(loc);
            if (!exe.exists()) continue;
            result = exe.toString();
            break;
        }
        return result;
    }

    private void exec_command(String cmd) {
        System.err.println("DEBUG: executing " + cmd);
        try {
            String line;
            Runtime rt = Runtime.getRuntime();
            Process p = rt.exec(cmd);
            InputStream in = p.getInputStream();
            BufferedInputStream buf = new BufferedInputStream(in);
            InputStreamReader inread = new InputStreamReader(buf);
            BufferedReader bufferedreader = new BufferedReader(inread);
            while ((line = bufferedreader.readLine()) != null) {
                System.err.println(line);
            }
        }
        catch (IOException e) {
            System.err.println("ERROR during exec: " + e);
        }
    }
}

