/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.Range;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeMasker {
    private ArrayList<Range> ranges_to_mask;
    private byte[] raw;
    private byte[] masked;
    private int offset;
    private int masked_bases;
    public static final byte TRIM_CHAR = 35;

    public RangeMasker(ArrayList<Range> ranges_to_mask, byte[] raw) {
        this.ranges_to_mask = ranges_to_mask;
        this.raw = raw;
        this.masked = null;
        this.masked_bases = 0;
        this.offset = 0;
    }

    public void set_offset(int i) {
        this.offset = i;
    }

    public void mask(int start, int end) {
        for (Range r : this.ranges_to_mask) {
            if (r.end < start || r.start > end) continue;
            if (this.masked == null) {
                this.masked = (byte[])this.raw.clone();
            }
            int tend = r.end + this.offset;
            for (int i = r.start + this.offset; i <= tend; ++i) {
                if (i < 0) {
                    System.err.println("ERROR: mask i=" + i);
                    return;
                }
                this.masked[i] = 35;
                ++this.masked_bases;
            }
        }
    }

    public void mask() {
        this.mask(0, this.raw.length);
    }

    public byte[] get_masked_sequence() {
        return this.masked;
    }

    public byte[] get_trimmed_sequence() {
        byte[] result = null;
        if (this.masked != null) {
            result = new byte[this.masked.length - this.masked_bases];
            int ti = 0;
            for (int i = 0; i < this.masked.length; ++i) {
                if (this.masked[i] == 35) continue;
                result[ti++] = this.masked[i];
            }
        }
        return result;
    }

    public byte[] trim_byte_array(byte[] input) {
        byte[] result = null;
        if (input.length == this.raw.length) {
            result = new byte[this.raw.length - this.masked_bases];
            int ti = 0;
            for (int i = 0; i < this.masked.length; ++i) {
                if (this.masked[i] == 35) continue;
                result[ti++] = input[i];
            }
        } else {
            System.err.println("ERROR: can't trim, array length mismatch");
        }
        return result;
    }

    public int get_masked_base_count() {
        return this.masked_bases;
    }
}

