/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Funk.Str;
import java.util.Enumeration;
import java.util.Hashtable;

public class PaddedNucleotideSearch {
    private String source;
    private String stripped;
    private Hashtable hits;

    PaddedNucleotideSearch(String str) {
        this.source = str.toLowerCase();
        this.stripped = Str.unpadded(this.source);
    }

    public Enumeration find(String str) {
        str = str.toLowerCase();
        this.hits = new Hashtable();
        this.find_it(str);
        this.find_it(Str.reverse_complement(str));
        return this.hits.keys();
    }

    public Enumeration get_matches() {
        return this.hits.keys();
    }

    public int get_end(int start) {
        Integer key = new Integer(start);
        if (this.hits.containsKey(key)) {
            return (Integer)this.hits.get(key);
        }
        return 0;
    }

    private void find_it(String str) {
        int i2;
        int index = 0;
        while ((i2 = this.stripped.indexOf(str, index)) > -1) {
            this.unpadded_to_padded(str, i2);
            index = i2 + 1;
        }
    }

    private void unpadded_to_padded(String str, int offset) {
        int i = 0;
        int len = this.source.length();
        int need = offset;
        int left = 0;
        int end = 0;
        int start = 0;
        for (i = 0; i < len; ++i) {
            char c = this.source.charAt(i);
            if (c == '*' || --need > 0) continue;
            if (need == -1) {
                start = i;
                left = str.length() - 1;
                continue;
            }
            if (--left != 0) continue;
            end = i;
            break;
        }
        this.hits.put(new Integer(start), new Integer(end));
    }

    public static void main(String[] argv) {
        PaddedNucleotideSearch pnc = new PaddedNucleotideSearch("AAGGA*ATT**CGGC*ACG*AGG*CCT*CGTCGACG*CCG*GACGAAAGACACGG*GCC*TGATTCGTCGAGTCT*C*ACTGAGCCTTA*GTC*GTCGGCAG*GTCCCAGGCG*C*GAAGTT*TCTCGGC*CT*GGA*GGAGGGGGTCGCGC*GAAGTCCAGATGCAG*GCGGGGAAGCCATC**CTCTATTCCTA*TTTCCGAAGCTCCTGCTCATGGA*GAGTTCGAATTGC*TCTGGCCTTGA*AAGGCATCGAC*TACGAGAC");
        pnc.find("CGCCTGC");
    }
}

