/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.AceViewerConfig;
import Ace2.Assembly;
import Ace2.AssemblySequence;
import Ace2.PadMap;
import Ace2.Range;
import Ace2.RangeMasker;
import Ace2.SAMAssembly;
import Ace2.SAMConsensusMapping;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class IntronCompressor {
    AceViewerConfig config;
    Assembly assembly;
    ArrayList<Range> ranges_to_trim;
    PadMap pm_raw;
    public static int KEEP_NT = 12;
    static int MIN_SPAN_TO_TRIM = KEEP_NT * 2;
    private static final int V_NULL = 0;
    private static final int V_USABLE = 1;
    private static final int V_UNUSABLE = -1;

    public IntronCompressor(AceViewerConfig config, Assembly assembly) {
        this.config = config;
        this.assembly = assembly;
        this.setup();
    }

    private void setup() {
        this.identify_trim_regions();
        this.trim_assembly_reads();
        this.trim_reference_sequence();
    }

    private void identify_trim_regions() {
        int ci;
        int left = this.assembly.get_leftmost();
        int right = this.assembly.get_rightmost();
        int[] tracker = new int[right + 1];
        Arrays.fill(tracker, 0);
        for (AssemblySequence as : this.assembly.get_sequences()) {
            SAMConsensusMapping scm = (SAMConsensusMapping)as;
            int start = scm.get_asm_start();
            int end = scm.get_asm_end();
            byte[] buf = scm.get_sequence_buffer();
            ci = start;
            for (int i = 0; i < buf.length && ci < tracker.length; ++ci, ++i) {
                if (buf[i] == 62 || buf[i] == 60) {
                    if (tracker[ci] != 0) continue;
                    tracker[ci] = 1;
                    continue;
                }
                tracker[ci] = -1;
            }
        }
        ArrayList<Range> ranges = new ArrayList<Range>();
        Range current = null;
        for (ci = 0; ci <= right; ++ci) {
            if (tracker[ci] == 1) {
                if (current == null) {
                    current = new Range();
                    ranges.add(current);
                    current.start = ci;
                }
                current.end = ci;
                continue;
            }
            current = null;
        }
        this.ranges_to_trim = new ArrayList();
        int half_keep = KEEP_NT / 2;
        for (Range r : ranges) {
            if (r.size() < MIN_SPAN_TO_TRIM) continue;
            Range r2 = new Range();
            r2.start = r.start + half_keep;
            r2.end = r.end - half_keep;
            this.ranges_to_trim.add(r2);
        }
    }

    public boolean is_completely_trimmed(int start, int end, boolean padded) {
        if (!padded) {
            PadMap pm = this.config.assembly.get_padmap();
            start = pm.in_unpadded_range(start) ? pm.get_unpadded_to_padded(start) : start;
            end = pm.in_unpadded_range(end) ? pm.get_unpadded_to_padded(end) : end;
        }
        boolean result = false;
        for (Range r : this.ranges_to_trim) {
            if (start < r.start || end > r.end) continue;
            result = true;
            break;
        }
        return result;
    }

    public int get_trimmed_to_untrimmed_shift(int pos) {
        boolean VERBOSE = false;
        int shift = 0;
        if (VERBOSE) {
            System.err.println("start: " + pos);
        }
        for (Range r : this.ranges_to_trim) {
            if (VERBOSE) {
                System.err.println("  pos=" + pos + " r=" + r);
            }
            if (r.start > pos) {
                if (!VERBOSE) break;
                System.err.println("  stop");
                break;
            }
            if (r.end < pos) {
                if (VERBOSE) {
                    System.err.println("  add before");
                }
                shift += r.size();
                pos += r.size();
                continue;
            }
            if (pos < r.start || pos > r.end) continue;
            if (VERBOSE) {
                System.err.println("  add inside");
            }
            shift += r.size();
            pos += r.size();
        }
        if (VERBOSE) {
            System.err.println("shift=" + shift);
        }
        return shift;
    }

    public int get_start_shift(int start, boolean include_interior) {
        int shift_needed = 0;
        for (Range r : this.ranges_to_trim) {
            if (r.end < start) {
                shift_needed += r.size();
                continue;
            }
            if (!include_interior || start < r.start || start > r.end) continue;
            shift_needed += r.size();
        }
        return shift_needed;
    }

    private void trim_assembly_reads() {
        for (AssemblySequence as : this.assembly.get_sequences()) {
            int shift_needed;
            SAMConsensusMapping scm = (SAMConsensusMapping)as;
            RangeMasker rm = new RangeMasker(this.ranges_to_trim, scm.get_sequence_buffer());
            rm.set_offset(-as.get_asm_start());
            rm.mask(as.get_asm_start(), as.get_asm_end());
            byte[] trimmed = rm.get_trimmed_sequence();
            if (trimmed != null) {
                scm.set_sequence_buffer(trimmed);
                scm.set_quality_buffer(rm.trim_byte_array(scm.get_quality_buffer()));
                scm.apply_end_shift(-rm.get_masked_base_count());
            }
            if ((shift_needed = this.get_start_shift(as.get_asm_start(), false)) <= 0) continue;
            scm.apply_alignment_shift(-shift_needed);
        }
    }

    public void trim_reference_sequence() {
        int i;
        char[] cons = this.assembly.get_consensus_sequence();
        char[] masked = (char[])cons.clone();
        int offset = -1;
        int masked_bases = 0;
        for (Range r : this.ranges_to_trim) {
            int start = r.start + offset;
            int end = r.end + offset;
            for (int i2 = start; i2 <= end; ++i2) {
                masked[i2] = 35;
                ++masked_bases;
            }
        }
        char[] trimmed = new char[masked.length - masked_bases];
        int ti = 0;
        int trimmed_bases = 0;
        this.config.intron_trim_sites = new HashMap();
        for (int i3 = 0; i3 < masked.length; ++i3) {
            if (masked[i3] == '#') {
                ++trimmed_bases;
                continue;
            }
            if (trimmed_bases > 0) {
                this.config.intron_trim_sites.put(ti + 1, trimmed_bases);
            }
            trimmed[ti++] = masked[i3];
            trimmed_bases = 0;
        }
        this.pm_raw = this.assembly.get_padmap();
        SAMAssembly sasm = (SAMAssembly)this.assembly;
        sasm.set_consensus_sequence(trimmed);
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < trimmed.length; ++i) {
            char c = trimmed[i];
            if (c == '*') continue;
            sb.append(c);
        }
        char[] unpadded_c = sb.toString().toCharArray();
        byte[] unpadded_b = new byte[unpadded_c.length];
        for (i = 0; i < unpadded_c.length; ++i) {
            unpadded_b[i] = (byte)unpadded_c[i];
        }
        this.config.target_sequence = unpadded_b;
        sasm.reset_padmap();
    }

    public PadMap get_raw_padmap() {
        return this.pm_raw;
    }
}

