/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.FAIIndexRecord;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FASTAFileTools {
    private long fa_ptr_id;
    private FAIIndexRecord index;

    public FAIIndexRecord detect_record_properties(RandomAccessFile raf) throws IOException {
        this.index = new FAIIndexRecord();
        this.fa_ptr_id = raf.getFilePointer();
        String id_line = raf.readLine();
        if (id_line.indexOf(">") == 0) {
            this.index.file_sequence_offset = raf.getFilePointer();
            String first_sequence_line = raf.readLine();
            long ptr_second = raf.getFilePointer();
            this.index.bytes_per_line = (int)(ptr_second - this.index.file_sequence_offset);
            this.index.nt_per_line = first_sequence_line.length();
            long flen = raf.length();
            long body_size = flen - this.index.file_sequence_offset;
            long lines = body_size / (long)this.index.bytes_per_line;
            int line_overhead = this.index.get_line_overhead();
            long leftover = body_size % (long)this.index.bytes_per_line;
            if (leftover > 0L) {
                leftover -= (long)line_overhead;
            }
            this.index.sequence_length = (int)(lines * (long)this.index.nt_per_line + leftover);
        } else {
            System.err.println("ERROR: expected FASTA ID line, got " + id_line);
        }
        return this.index;
    }

    public FAIIndexRecord get_index_info() {
        return this.index;
    }

    public byte[] get_region(RandomAccessFile raf, int start_base, int length) throws IOException {
        byte[] results = null;
        if (start_base > this.index.sequence_length) {
            System.err.println("ERROR: start base past end of sequence");
        } else if (start_base < 1) {
            System.err.println("ERROR: start base must be at least 1");
        } else {
            String line;
            int overflow = start_base + length - 1 - this.index.sequence_length;
            if (overflow > 0) {
                System.err.println("WARNING: requested region past end of sequence");
                length -= overflow;
            }
            int needed = length;
            int base_index = start_base - 1;
            int start_line_num = base_index / this.index.nt_per_line;
            int start_line_index = base_index % this.index.nt_per_line;
            long start_ptr = this.index.file_sequence_offset + (long)(start_line_num * this.index.bytes_per_line) + (long)start_line_index;
            raf.seek(start_ptr);
            results = new byte[length];
            int buf_ptr = 0;
            while ((line = raf.readLine()) != null) {
                char[] chars = line.toCharArray();
                int i = 0;
                while (i < chars.length && needed > 0) {
                    results[buf_ptr++] = (byte)chars[i++];
                    --needed;
                }
                if (needed > 0) continue;
                break;
            }
        }
        return results;
    }

    public byte[] get_all(RandomAccessFile raf) throws IOException {
        int needed;
        byte[] results = new byte[needed];
        int buf_ptr = 0;
        raf.seek(this.index.file_sequence_offset);
        for (needed = this.index.sequence_length; needed > 0; needed -= this.index.nt_per_line) {
            try {
                int read = needed < this.index.bytes_per_line ? needed : this.index.bytes_per_line;
                raf.readFully(results, buf_ptr, read);
                buf_ptr += this.index.nt_per_line;
                continue;
            }
            catch (EOFException ex) {
                break;
            }
        }
        return results;
    }

    public void set_index(FAIIndexRecord index) {
        this.index = index;
    }
}

