/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.Ace;
import Ace2.AcePanel;
import Ace2.AceViewerConfig;
import Ace2.Alignment;
import Ace2.Assembly;
import Ace2.AssemblyCanvas;
import Ace2.AssemblySequence;
import Ace2.BambinoProperties;
import Ace2.ColorIntensifier;
import Ace2.ColorParser;
import Ace2.ErrorReporter;
import Ace2.FASTADirectory;
import Ace2.FASTAIndexedFAI;
import Ace2.FASTAQualityReader;
import Ace2.JDBCCache;
import Ace2.Launcher;
import Ace2.MarkupReader;
import Ace2.NIB;
import Ace2.PadMap;
import Ace2.RefGene;
import Ace2.SAMAssembly;
import Ace2.SAMRegion;
import Ace2.SAMResource;
import Ace2.SAMResourceTags;
import Ace2.SAMTagFilter;
import Ace2.SAMUtils;
import Ace2.SNP;
import Ace2.SNPList;
import Ace2.SampleNamingConvention;
import Ace2.TumorNormalStatusDialog;
import Ace2.TwoBitFile;
import Funk.Gr;
import Funk.LookAndFeeler;
import Funk.Str;
import IsoView.RegionParser;
import TCGA.URLLauncher;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class AceViewer
extends JFrame
implements WindowListener,
ActionListener,
KeyListener {
    public boolean standalone = false;
    private AcePanel ap;
    private JMenuItem m_find;
    private JMenuItem m_primers;
    private JMenuItem m_blast;
    private JMenuItem m_tn;
    private ButtonGroup view_by = new ButtonGroup();
    private ButtonGroup font_size = new ButtonGroup();
    private AceViewerConfig config = new AceViewerConfig();

    public AceViewer(AceViewerConfig config) {
        this.config = config;
        if (config.LOCAL_FILE_MODE && config.EXIT_ON_CLOSE) {
            this.setDefaultCloseOperation(3);
        }
        this.ap = new AcePanel(config);
        this.setup();
    }

    void setup() {
        LookAndFeeler.set_native_lookandfeel();
        if (this.config.title != null) {
            this.setTitle(this.config.title);
        } else if (this.ap.filename == null) {
            this.setTitle("alignment viewer");
        } else {
            this.setTitle(Str.basename(this.ap.filename));
        }
        this.addWindowListener(this);
        this.addKeyListener(this);
        JMenuBar mb = new JMenuBar();
        this.setJMenuBar(mb);
        JMenu m = new JMenu("Tools");
        this.m_find = new JMenuItem("Find...");
        m.add(this.m_find);
        this.m_find.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.m_find.addActionListener(this);
        JMenu jm = new JMenu("Show sequence IDs...");
        m.add(jm);
        JMenuItem jmi = new JMenuItem("Aligned to visible region");
        jmi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AceViewer.this.show_sequence_ids(false);
            }
        });
        jm.add(jmi);
        jmi = new JMenuItem("Visible only");
        jmi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AceViewer.this.show_sequence_ids(true);
            }
        });
        jm.add(jmi);
        jm.add(new JSeparator());
        jmi = new JMenuItem("Count aligned reads");
        jmi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AceViewer.this.count_sequence_ids();
            }
        });
        jmi.setAccelerator(KeyStroke.getKeyStroke(67, 8));
        jm.add(jmi);
        this.m_tn = new JMenuItem("Set tumor/normal status...");
        this.m_tn.addActionListener(this);
        m.add(this.m_tn);
        mb.add(m);
        m = new JMenu("View");
        AbstractButton j = null;
        JMenu sm = new JMenu("Display sequences...");
        m.add(sm);
        String[] labels = new String[]{"sort by name", "sort by alignment position"};
        ItemListener il_view_by = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JCheckBoxMenuItem i = (JCheckBoxMenuItem)e.getItem();
                ((AceViewer)AceViewer.this).config.assembly.set_display_by_position(i.getText().equals("sort by alignment position"));
                AceViewer.this.repaint();
            }
        };
        for (int i = 0; i < labels.length; ++i) {
            j = new JCheckBoxMenuItem(labels[i]);
            sm.add((JMenuItem)j);
            j.addItemListener(il_view_by);
            this.view_by.add(j);
        }
        j.setSelected(true);
        sm.add(new JSeparator());
        jmi = new JCheckBoxMenuItem("Hide optical/PCR duplicates");
        jmi.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JCheckBoxMenuItem i = (JCheckBoxMenuItem)e.getItem();
                ((AceViewer)AceViewer.this).config.HIDE_OPTICAL_PCR_DUPLICATES = i.isSelected();
                AceViewer.this.ap.get_canvas().repaint();
            }
        });
        jmi.setAccelerator(KeyStroke.getKeyStroke(72, 8));
        jmi.setSelected(true);
        sm.add(jmi);
        jmi = new JCheckBoxMenuItem("Hide skip-only alignments");
        jmi.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JCheckBoxMenuItem i = (JCheckBoxMenuItem)e.getItem();
                ((AceViewer)AceViewer.this).config.HIDE_SKIP_ONLY_ALIGNMENTS = i.isSelected();
                AceViewer.this.ap.get_canvas().repaint();
            }
        });
        jmi.setAccelerator(KeyStroke.getKeyStroke(83, 8));
        sm.add(jmi);
        jmi = new JCheckBoxMenuItem("Shade sequence IDs by mapping quality");
        jmi.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JCheckBoxMenuItem i = (JCheckBoxMenuItem)e.getItem();
                ((AceViewer)AceViewer.this).config.SHADE_SEQUENCE_IDENTIFIERS_BY_MAPQ = i.isSelected();
                AceViewer.this.ap.get_canvas().repaint();
            }
        });
        jmi.setSelected(this.config.SHADE_SEQUENCE_IDENTIFIERS_BY_MAPQ);
        sm.add(jmi);
        JMenu sm2 = new JMenu("SNP/indel browsing...");
        sm.add(sm2);
        jmi = new JCheckBoxMenuItem("only display reads aligned at SNP site");
        jmi.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JCheckBoxMenuItem i = (JCheckBoxMenuItem)e.getItem();
                ((AceViewer)AceViewer.this).config.CLAMP_SNP_VIEW = i.isSelected();
                AceViewer.this.ap.get_canvas().repaint();
            }
        });
        jmi.setSelected(this.config.CLAMP_SNP_VIEW);
        jmi.setAccelerator(KeyStroke.getKeyStroke(68, 8));
        sm2.add(jmi);
        jmi = new JCheckBoxMenuItem("only display non-reference reads aligned at SNP site");
        jmi.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JCheckBoxMenuItem i = (JCheckBoxMenuItem)e.getItem();
                ((AceViewer)AceViewer.this).config.CLAMP_SNP_VIEW_NONREFERENCE = i.isSelected();
                AceViewer.this.ap.get_canvas().repaint();
            }
        });
        jmi.setSelected(this.config.CLAMP_SNP_VIEW_NONREFERENCE);
        jmi.setMnemonic(82);
        jmi.setAccelerator(KeyStroke.getKeyStroke(82, 8));
        sm2.add(jmi);
        jmi = new JMenuItem("Set minimum mapping quality for display...");
        jmi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String value = JOptionPane.showInputDialog("Minimum mapping quality required for read display:", (Object)((AceViewer)AceViewer.this).config.MINIMUM_MAPQ_FOR_DISPLAY);
                try {
                    ((AceViewer)AceViewer.this).config.MINIMUM_MAPQ_FOR_DISPLAY = Integer.parseInt(Str.trim_whitespace(value));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                AceViewer.this.ap.get_canvas().repaint();
            }
        });
        sm.add(jmi);
        sm = new JMenu("Font size...");
        ItemListener il_font = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JCheckBoxMenuItem i = (JCheckBoxMenuItem)e.getItem();
                AceViewer.this.ap.set_font_size(Integer.parseInt(i.getText()));
            }
        };
        for (int i = 8; i <= 14; i += 2) {
            j = new JCheckBoxMenuItem(Integer.toString(i));
            sm.add((JMenuItem)j);
            this.font_size.add(j);
            j.addItemListener(il_font);
        }
        j.setSelected(true);
        m.add(sm);
        mb.add(m);
        m = new JMenu("Help");
        jmi = this.add_menuitem(m, "Documentation", 72, KeyStroke.getKeyStroke(112, 0));
        jmi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                URLLauncher.launch_modified_url("/goldenPath/bamview/documentation/index.html", "bamview_docs");
            }
        });
        jmi = new JMenuItem("Short read alignment viewer index");
        m.add(jmi);
        jmi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                URLLauncher.launch_modified_url("/cgi-bin/bamview", "bamview");
            }
        });
        jmi = new JMenuItem("Cancer Genome Workbench");
        m.add(jmi);
        jmi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                URLLauncher.launch_modified_url("https://cgwb.nci.nih.gov/", "cgwb");
            }
        });
        m.add(new JSeparator());
        jmi = new JMenuItem("About");
        m.add(jmi);
        jmi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, AceViewer.get_version_string(), "About", 1);
            }
        });
        mb.add(m);
        this.setLayout(new BorderLayout());
        this.add("Center", this.ap);
        this.pack();
        Gr.respectful_resize(this, 0.98, 0.9);
        this.setVisible(true);
        if (this.config.start_unpadded_offset != 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    block6: {
                        PadMap pm;
                        AcePanel ap;
                        while (true) {
                            ap = AceViewer.this.get_acepanel();
                            Assembly asm = ap.get_assembly();
                            pm = null;
                            if (asm.is_loaded()) {
                                if (asm.alignment_is_built()) {
                                    pm = asm.get_padmap();
                                }
                                if (asm.has_error()) {
                                    System.err.println("error, breaking. msg=" + asm.get_error_message());
                                    ap.get_canvas().repaint();
                                    break block6;
                                }
                            }
                            if (pm != null) break;
                            System.err.println("waiting for PadMap...");
                            try {
                                Thread.sleep(200L);
                            }
                            catch (InterruptedException e) {}
                        }
                        int upo = ((AceViewer)AceViewer.this).config.start_unpadded_offset - ((AceViewer)AceViewer.this).config.ruler_start;
                        int po = pm.get_unpadded_to_padded(upo);
                        SNPList sl = new SNPList();
                        sl.addElement(new SNP(po, 0.0));
                        ((AceViewer)AceViewer.this).config.assembly.set_snps(sl);
                        ap.get_canvas().center_on(po);
                        ap.get_canvas().repaint();
                    }
                }
            });
        }
        this.ap.get_canvas().requestFocusInWindow();
        Gr.anchor(this, "nw");
    }

    public static void main(String[] argv) {
        block119: {
            try {
                LookAndFeeler.set_native_lookandfeel();
                AceViewer av = null;
                MarkupReader mr = null;
                AceViewerConfig avc = new AceViewerConfig();
                String quality_url = null;
                String markup_url = null;
                boolean compress_mode = false;
                avc.region = new SAMRegion();
                URLLauncher.set_url("https://cgwb.nci.nih.gov/cgi-bin/bamview");
                String contig = null;
                SNPList sl = null;
                String ace_url = null;
                for (int i = 0; i < argv.length; ++i) {
                    if (!argv[i].substring(0, 1).equals("-")) continue;
                    if (argv[i].equals("-contig")) {
                        contig = "Contig" + argv[++i];
                        continue;
                    }
                    if (argv[i].equals("-compress")) {
                        compress_mode = true;
                        continue;
                    }
                    if (argv[i].equals("-generate-consensus")) {
                        avc.GENERATE_CONSENSUS = true;
                        continue;
                    }
                    if (argv[i].equals("-poffset")) {
                        avc.start_padded_offset = Integer.parseInt(argv[++i]);
                        continue;
                    }
                    if (argv[i].equals("-uoffset")) {
                        avc.start_unpadded_offset = Integer.parseInt(argv[++i]);
                        continue;
                    }
                    if (argv[i].equals("-offset")) {
                        sl = new SNPList();
                        sl.addElement(new SNP(Integer.parseInt(argv[++i]), 1.0));
                        continue;
                    }
                    if (argv[i].equals("-offsets")) {
                        sl = new SNPList();
                        StringTokenizer st = new StringTokenizer(argv[++i], ",");
                        while (st.hasMoreTokens()) {
                            sl.addElement(new SNP(Integer.parseInt(st.nextToken()), 1.0));
                        }
                        continue;
                    }
                    if (argv[i].equals("-compress-introns")) {
                        avc.COMPRESS_INTRONS = true;
                        continue;
                    }
                    if (argv[i].equals("-no-quality-paint")) {
                        avc.ENABLE_QUALITY_PAINT = false;
                        continue;
                    }
                    if (argv[i].equals("-disable-mismap-filter")) {
                        avc.snp_config.ENABLE_MISMAP_FILTER = false;
                        continue;
                    }
                    if (argv[i].equals("-require-tags")) {
                        if (avc.sam_tag_filter != null) {
                            System.err.println("ERROR: only one of -require-tags and -optional-tags may be specified");
                            System.exit(1);
                        }
                        avc.sam_tag_filter = new SAMTagFilter(true);
                        avc.sam_tag_filter.parse(argv[++i]);
                        continue;
                    }
                    if (argv[i].equals("-optional-tags")) {
                        if (avc.sam_tag_filter != null) {
                            System.err.println("ERROR: only one of -require-tags and -optional-tags may be specified");
                            System.exit(1);
                        }
                        avc.sam_tag_filter = new SAMTagFilter(false);
                        avc.sam_tag_filter.parse(argv[++i]);
                        continue;
                    }
                    if (argv[i].equals("-convention")) {
                        SampleNamingConvention.import_convention(argv[++i]);
                        continue;
                    }
                    if (argv[i].equals("-min-display-mapq") || argv[i].equals("-min-mapq")) {
                        avc.MINIMUM_MAPQ_FOR_DISPLAY = Integer.parseInt(argv[++i]);
                        continue;
                    }
                    if (argv[i].equals("-mapq-id-shade")) {
                        avc.SHADE_SEQUENCE_IDENTIFIERS_BY_MAPQ = true;
                        continue;
                    }
                    if (argv[i].equals("-mapq-id-min-intensity")) {
                        Float intensity;
                        if ((intensity = Float.valueOf(Float.parseFloat(argv[++i]))).floatValue() >= 0.0f && intensity.floatValue() <= 1.0f) {
                            ColorIntensifier.MINIMUM_INTENSITY_PERCENT = intensity.floatValue();
                            continue;
                        }
                        System.err.println("-mapq-id-min-intensity must be a fractional value between 0 and 1");
                        System.exit(1);
                        continue;
                    }
                    if (argv[i].equals("-no-db")) {
                        avc.ENABLE_JDBC = false;
                        continue;
                    }
                    if (argv[i].equals("-db-server")) {
                        JDBCCache.UCSC_DB_SERVER = argv[++i];
                        continue;
                    }
                    if (argv[i].equals("-db-database")) {
                        JDBCCache.UCSC_DB_DATABASE = argv[++i];
                        continue;
                    }
                    if (argv[i].equals("-db-user")) {
                        JDBCCache.UCSC_DB_USERNAME = argv[++i];
                        continue;
                    }
                    if (argv[i].equals("-db-password")) {
                        JDBCCache.UCSC_DB_PASSWORD = argv[++i];
                        continue;
                    }
                    if (argv[i].equals("-db-cache-flush")) {
                        System.err.println("flushing JDBC cache");
                        JDBCCache cache = new JDBCCache();
                        cache.flush_cache();
                        continue;
                    }
                    if (argv[i].equals("-no")) continue;
                    if (argv[i].equals("-consensus-label")) {
                        avc.CONSENSUS_TAG = argv[++i];
                        continue;
                    }
                    if (argv[i].equals("-drag-scale")) {
                        avc.DRAG_SCALE_FACTOR = Integer.parseInt(argv[++i]);
                        continue;
                    }
                    if (argv[i].equals("-drag-button")) {
                        int button;
                        if ((button = Integer.parseInt(argv[++i])) == 1) {
                            avc.DRAG_BUTTON_MASK = 16;
                            continue;
                        }
                        if (button == 2) {
                            avc.DRAG_BUTTON_MASK = 8;
                            continue;
                        }
                        if (button == 3) {
                            avc.DRAG_BUTTON_MASK = 4;
                            continue;
                        }
                        System.err.println("invalid button");
                        continue;
                    }
                    if (argv[i].equals("-title")) {
                        avc.title = argv[++i];
                        continue;
                    }
                    if (argv[i].equals("-ruler-start")) {
                        avc.ruler_start = Integer.parseInt(argv[++i]);
                        continue;
                    }
                    if (argv[i].equals("-no-snp")) {
                        AcePanel.set_snp_info(false);
                        continue;
                    }
                    if (argv[i].equals("-homepage")) {
                        URLLauncher.set_url(argv[++i]);
                        continue;
                    }
                    if (argv[i].equals("-url")) {
                        ace_url = argv[++i];
                        continue;
                    }
                    if (argv[i].equals("-qurl")) {
                        quality_url = argv[++i];
                        continue;
                    }
                    if (argv[i].equals("-murl")) {
                        markup_url = argv[++i];
                        continue;
                    }
                    if (argv[i].equals("-tv")) {
                        avc.ENABLE_TRACE_VIEWER = true;
                        continue;
                    }
                    if (argv[i].equals("-no-duplicates")) {
                        avc.LOAD_OPTICAL_PCR_DUPLICATES = false;
                        continue;
                    }
                    if (argv[i].equals("-ace")) {
                        ace_url = AceViewer.localfile_to_url(argv[++i]);
                        continue;
                    }
                    if (argv[i].equals("-qual")) {
                        quality_url = AceViewer.localfile_to_url(argv[++i]);
                        continue;
                    }
                    if (argv[i].equals("-markup")) {
                        markup_url = AceViewer.localfile_to_url(argv[++i]);
                        continue;
                    }
                    if (argv[i].equals("-fixed-font")) {
                        avc.FIXED_FONT_TYPEFACE = argv[++i];
                        continue;
                    }
                    if (argv[i].equals("-var-font")) {
                        avc.VARIABLE_FONT_TYPEFACE = argv[++i];
                        continue;
                    }
                    if (argv[i].equals("-fixed-font")) {
                        avc.ENABLE_VARIABLE_WIDTH_FONTS = false;
                        continue;
                    }
                    if (argv[i].equals("-restrict")) {
                        SAMResource.add_restrict_string(argv[++i]);
                        continue;
                    }
                    if (argv[i].equals("-restrict-no")) {
                        SAMResource.add_negative_restrict_string(argv[++i]);
                        continue;
                    }
                    if (argv[i].equals("-overlap")) {
                        SAMResource.set_restrict_overlap(Integer.parseInt(argv[++i]));
                        continue;
                    }
                    if (argv[i].equals("-restrict-f")) {
                        SAMResource.set_restrict_fr(true);
                        continue;
                    }
                    if (argv[i].equals("-restrict-r")) {
                        SAMResource.set_restrict_fr(false);
                        continue;
                    }
                    if (argv[i].equals("-name")) {
                        avc.region.tname = new String(argv[++i]);
                        continue;
                    }
                    if (argv[i].equals("-start")) {
                        avc.region.range.start = Integer.parseInt(argv[++i]);
                        continue;
                    }
                    if (argv[i].equals("-nib")) {
                        NIB.DEFAULT_NIB_DIR = new String(argv[++i]);
                        avc.reference_sequence = new NIB();
                        continue;
                    }
                    if (argv[i].equals("-trace-dir")) {
                        avc.CHROMAT_DIR = new String(argv[++i]);
                        File dir = new File(avc.CHROMAT_DIR);
                        if (dir.exists() && dir.isDirectory()) continue;
                        System.err.println("ERROR: " + avc.CHROMAT_DIR + " is not a directory");
                        System.exit(1);
                        continue;
                    }
                    if (argv[i].equals("-fasta")) {
                        String thing;
                        File f;
                        if ((f = new File(thing = argv[++i])).isFile()) {
                            avc.reference_sequence = new FASTAIndexedFAI(thing);
                            continue;
                        }
                        if (f.isDirectory()) {
                            avc.reference_sequence = new FASTADirectory(thing);
                            continue;
                        }
                        System.err.println("ERROR: not a file/directory: " + thing);
                        continue;
                    }
                    if (argv[i].equals("-2bit")) {
                        avc.reference_sequence = new TwoBitFile(argv[++i]);
                        continue;
                    }
                    if (argv[i].equals("-jz")) {
                        avc.snp_config.MIN_QUALITY = 15;
                        avc.snp_config.MIN_ALT_ALLELE_COUNT = 2;
                        avc.snp_config.MIN_MINOR_ALLELE_FREQUENCY = 0.0f;
                        continue;
                    }
                    if (argv[i].equals("-query-window")) {
                        avc.DEFAULT_INITIAL_VIEW_NT = Integer.parseInt(argv[++i]);
                        continue;
                    }
                    if (argv[i].equals("-center")) {
                        avc.center = Integer.parseInt(argv[++i]);
                        continue;
                    }
                    if (argv[i].equals("-center-overlap-only")) {
                        avc.CENTER_BASE_QUERY_ONLY = true;
                        continue;
                    }
                    if (argv[i].equals("-end")) {
                        avc.region.range.end = Integer.parseInt(argv[++i]);
                        continue;
                    }
                    if (argv[i].equals("-sam") || argv[i].equals("-bam") || argv[i].equals("-cram")) {
                        String thing;
                        URL u;
                        SAMResource sr = new SAMResource();
                        if ((u = AceViewer.generate_url(thing = argv[++i])) != null) {
                            sr.url = u;
                        } else {
                            File f = new File(thing);
                            if (f.exists()) {
                                sr.file = f;
                                avc.LOCAL_FILE_MODE = true;
                            } else {
                                System.err.println("ERROR: file not found: " + thing);
                                System.exit(1);
                            }
                        }
                        sr.detect_sample_id();
                        avc.sams.add(sr);
                        continue;
                    }
                    if (argv[i].equals("-color")) {
                        String cname = new String(argv[++i]);
                        ColorParser cp = new ColorParser(cname);
                        Color c = cp.get_color();
                        System.err.println("color name=" + cname + " result=" + c);
                        int size = avc.sams.size();
                        if (size > 0) {
                            SAMResource sr = avc.sams.get(size - 1);
                            sr.custom_color = c;
                            continue;
                        }
                        System.err.println("ERROR: -color must be specified after -bam");
                        System.exit(1);
                        continue;
                    }
                    if (argv[i].equals("-sample")) {
                        if (avc.sams.size() > 0) {
                            avc.sams.get(avc.sams.size() - 1).import_data(SAMResourceTags.SAM_SAMPLE, argv[++i]);
                            continue;
                        }
                        System.err.println("ERROR: must specify -sample after -bam");
                        System.exit(1);
                        continue;
                    }
                    if (argv[i].equals("-tn")) {
                        if (avc.sams.size() > 0) {
                            SAMResource sr = avc.sams.get(avc.sams.size() - 1);
                            sr.set_tumor_normal(argv[++i]);
                            continue;
                        }
                        System.err.println("ERROR: -tn must be specified after -sam");
                        continue;
                    }
                    if (argv[i].equals("-verbose-refgene")) {
                        RefGene.VERBOSE = true;
                        continue;
                    }
                    if (argv[i].equals("-version")) {
                        AceViewer.print_version();
                        System.exit(0);
                        continue;
                    }
                    if (argv[i].equals("-uc-reference")) {
                        avc.UPPERCASE_REFERENCE_SEQUENCE = true;
                        continue;
                    }
                    if (argv[i].equals("-dump-fonts")) {
                        AceViewer.dump_fonts();
                        System.exit(0);
                        continue;
                    }
                    if (argv[i].equals("-color-background") || argv[i].equals("-color-sequence") || argv[i].equals("-color-softclip") || argv[i].equals("-color-border") || argv[i].equals("-color-label") || argv[i].equals("-color-summary-background") || argv[i].equals("-color-reference") || argv[i].equals("-color-ruler")) {
                        AceViewer.color_setup(argv[i], argv[++i]);
                        continue;
                    }
                    if (argv[i].equals("-blat-db")) {
                        avc.BLAT_GENOME = new String(argv[++i]);
                        continue;
                    }
                    if (argv[i].equals("-indels-only")) {
                        avc.DEFAULT_VIEW_INDELS_ONLY = true;
                        continue;
                    }
                    if (argv[i].equals("-restrict-skip-size")) {
                        int skip_size;
                        block118: {
                            String thing = argv[++i];
                            skip_size = -1;
                            try {
                                skip_size = Integer.parseInt(thing);
                            }
                            catch (NumberFormatException e) {
                                RegionParser rp = new RegionParser();
                                if (!rp.parse_junction(thing)) break block118;
                                skip_size = rp.end - rp.start - 1;
                                avc.region.range.start = rp.start - 1000;
                                avc.region.range.end = rp.end + 1000;
                                System.err.println("setting view based on junction to " + avc.region.range.start + "-" + avc.region.range.end);
                            }
                        }
                        if (skip_size == -1) {
                            System.err.println("ERROR: -restrict-skip-size must specify either an integer or a junction");
                            System.exit(1);
                            continue;
                        }
                        System.err.println("filtering reads to skip size " + skip_size);
                        SAMResource.set_skip_size(skip_size);
                        continue;
                    }
                    if (argv[i].equals("-require-indel")) {
                        SAMResource.set_require_indel(true);
                        continue;
                    }
                    if (argv[i].equals("-require-indel-type")) {
                        SAMResource.set_require_indel_type(argv[++i]);
                        continue;
                    }
                    if (argv[i].equals("-require-indel-length")) {
                        SAMResource.set_require_indel_length(Integer.parseInt(argv[++i]));
                        continue;
                    }
                    if (argv[i].equals("-ignore-perfect")) {
                        SAMResource.set_ignore_perfect(true);
                        continue;
                    }
                    System.out.println("ERROR: unknown command-line argument " + argv[i]);
                    System.exit(1);
                }
                if (avc.center > 0) {
                    int FLANK = avc.DEFAULT_INITIAL_VIEW_NT / 2;
                    int start = avc.center - FLANK;
                    int end = avc.center + FLANK;
                    if (start < 1) {
                        start = 1;
                    }
                    avc.start_unpadded_offset = avc.center;
                    avc.region.range.start = start;
                    avc.region.range.end = end;
                }
                if (markup_url != null) {
                    try {
                        mr = new MarkupReader(AceViewer.url_to_br(markup_url, compress_mode), avc, false);
                        avc.ENABLE_JDBC = false;
                    }
                    catch (Exception e) {
                        System.err.println("URL error: " + e);
                    }
                }
                if (mr == null && ace_url == null && avc.sams.size() == 0) {
                    new Launcher(avc);
                    break block119;
                }
                if (ace_url != null) {
                    try {
                        URL u = new URL(ace_url);
                        avc.title = u.getPath();
                        DataInputStream dis = AceViewer.url_to_dis(ace_url, compress_mode);
                        Ace ace = new Ace(dis);
                        avc.assembly = new Alignment(ace, avc);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.err.println("ace URL error: " + e);
                    }
                } else if (avc.sams.size() > 0) {
                    if (avc.reference_sequence == null && avc.target_sequence == null) {
                        System.err.println("Note: no reference sequence specified, generating consensus sequence.");
                        avc.GENERATE_CONSENSUS = true;
                    }
                    for (SAMResource sr : avc.sams) {
                        sr.reference_sequence = avc.reference_sequence;
                    }
                    if (!avc.LOAD_OPTICAL_PCR_DUPLICATES) {
                        for (SAMResource sr : avc.sams) {
                            sr.set_load_duplicates(false);
                        }
                    }
                    if (mr == null) {
                        avc.region_default_setup();
                    }
                    SAMUtils.sam_config_setup(avc, avc.region);
                    if (avc.target_sequence == null) {
                        System.err.println("ERROR: no reference sequence specified");
                        System.exit(1);
                    }
                    try {
                        avc.assembly = new SAMAssembly(avc, true);
                    }
                    catch (Throwable t) {
                        new Funk.ErrorReporter(t);
                    }
                } else {
                    System.err.println("No alignment specified!");
                    System.exit(1);
                }
                av = new AceViewer(avc);
                if (av == null) {
                    System.out.println("Usage: AceViewer acefile [contig] [offset]");
                    System.exit(1);
                    break block119;
                }
                if (quality_url != null) {
                    try {
                        avc.fq = new FASTAQualityReader(AceViewer.url_to_br(quality_url, compress_mode), av, true);
                    }
                    catch (Exception e) {
                        System.err.println("URL error: " + e);
                    }
                }
                av.standalone = true;
            }
            catch (Throwable t) {
                System.out.println("ERROR:" + t);
                t.printStackTrace();
                new ErrorReporter(t);
            }
        }
    }

    public void die() {
        this.setVisible(false);
        this.dispose();
    }

    public void set_postgres(boolean status) {
        this.ap.set_postgres(status);
    }

    protected void finalize() {
        System.out.println("finalize!");
        if (this.standalone) {
            System.exit(1);
        } else {
            this.die();
        }
    }

    public void windowActivated(WindowEvent we) {
    }

    public void windowClosed(WindowEvent we) {
    }

    public void windowClosing(WindowEvent we) {
        this.die();
    }

    public void windowDeactivated(WindowEvent we) {
    }

    public void windowDeiconified(WindowEvent we) {
    }

    public void windowIconified(WindowEvent we) {
    }

    public void windowOpened(WindowEvent we) {
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src.equals(this.m_find)) {
            this.ap.find();
        } else if (src.equals(this.m_tn)) {
            new TumorNormalStatusDialog((JFrame)Gr.getFrame(this), this.config.sams);
            this.repaint();
        }
    }

    public AcePanel get_acepanel() {
        return this.ap;
    }

    private static DataInputStream url_to_dis(String url_string, boolean compressed) throws IOException, MalformedURLException {
        URL url = new URL(url_string);
        if (url_string.endsWith(".gz")) {
            compressed = true;
        }
        System.err.println("url=" + url + " compression=" + compressed);
        InputStream is = url.openStream();
        if (compressed) {
            is = new GZIPInputStream(is);
        }
        return new DataInputStream(new BufferedInputStream(is));
    }

    private static BufferedReader url_to_br(String url_string, boolean compressed) throws IOException, MalformedURLException {
        URL url = new URL(url_string);
        if (url_string.endsWith(".gz")) {
            compressed = true;
        }
        System.err.println("url=" + url + " compression=" + compressed);
        InputStream is = url.openStream();
        if (compressed) {
            is = new GZIPInputStream(is);
        }
        return new BufferedReader(new InputStreamReader(is));
    }

    public AceViewerConfig get_config() {
        return this.config;
    }

    private static String localfile_to_url(String s) {
        String result = null;
        try {
            File f = new File(s);
            result = "file://localhost/" + f.getCanonicalFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void keyPressed(KeyEvent ke) {
        System.err.println("PRESS:" + ke);
    }

    public void keyReleased(KeyEvent ke) {
    }

    public void keyTyped(KeyEvent ke) {
    }

    public static URL generate_url_OLD(String s) {
        URL u = null;
        try {
            u = new URL(s);
        }
        catch (MalformedURLException e) {
            try {
                u = new URL(AceViewer.localfile_to_url(s));
            }
            catch (Exception e2) {
                e2.printStackTrace();
                System.exit(1);
            }
        }
        return u;
    }

    public static URL generate_url(String s) {
        URL u = null;
        try {
            u = new URL(s);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return u;
    }

    public void show_sequence_ids(boolean visible_only) {
        AssemblyCanvas canvas = this.ap.get_canvas();
        ArrayList<AssemblySequence> seqs = visible_only ? canvas.get_visible_sequences() : canvas.get_aligned_sequences();
        StringBuffer sb = new StringBuffer();
        for (AssemblySequence as : seqs) {
            sb.append(as.get_name() + "\n");
        }
        JFrame jf = new JFrame();
        jf.setTitle("Sequence IDs (note: suffix is generated)");
        jf.add("Center", new JScrollPane(new JTextArea(sb.toString())));
        jf.pack();
        jf.setVisible(true);
    }

    private JMenuItem add_menuitem(JMenu m, String label, int mnemonic, KeyStroke accelerator) {
        JMenuItem mi = new JMenuItem(label, mnemonic);
        if (accelerator != null) {
            mi.setAccelerator(accelerator);
        }
        m.add(mi);
        mi.addActionListener(this);
        return mi;
    }

    private static void dump_fonts() {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        ArrayList<String> names = new ArrayList<String>();
        for (String fname : e.getAvailableFontFamilyNames()) {
            names.add(fname);
        }
        Collections.sort(names);
        for (String fname : names) {
            Font f = new Font(fname, 0, 12);
            System.out.println(fname);
        }
    }

    public static void print_version() {
        System.err.println(AceViewer.get_version_string());
    }

    public static String get_version_string() {
        BambinoProperties bp = new BambinoProperties();
        return "Bambino version " + AceViewerConfig.VERSION + "." + bp.get_build_number() + " (" + bp.get_build_date() + ")";
    }

    private static void color_setup(String arg, String cspec) {
        ColorParser cp = new ColorParser(cspec);
        Color c = cp.get_color();
        if (c == null) {
            System.err.println("ERROR: unknown color " + cspec);
            System.exit(1);
        }
        if (c != null) {
            if (arg.equals("-color-background")) {
                AssemblyCanvas.BACKGROUND_COLOR = c;
            } else if (arg.equals("-color-sequence")) {
                AssemblyCanvas.SEQUENCE_COLOR = c;
            } else if (arg.equals("-color-softclip")) {
                AssemblyCanvas.TRIMMED_COLOR = c;
            } else if (arg.equals("-color-border")) {
                AssemblyCanvas.BORDER_COLOR = c;
            } else if (arg.equals("-color-label")) {
                AssemblyCanvas.SEQID_COLOR = c;
            } else if (arg.equals("-color-summary-background")) {
                AssemblyCanvas.SUMMARY_PANEL_BACKGROUND_COLOR = c;
            } else if (arg.equals("-color-reference")) {
                AssemblyCanvas.CONSENSUS_COLOR = c;
            } else if (arg.equals("-color-ruler")) {
                AssemblyCanvas.RULER_COLOR = c;
            } else {
                System.err.println("ERROR: unhandled color type " + cspec);
            }
        }
    }

    public void count_sequence_ids() {
        AssemblyCanvas canvas = this.ap.get_canvas();
        ArrayList<AssemblySequence> seqs = canvas.get_aligned_sequences();
        HashSet<String> reads_cooked = new HashSet<String>();
        HashSet<String> reads_raw = new HashSet<String>();
        StringBuffer sb = new StringBuffer();
        for (AssemblySequence as : seqs) {
            String id_cooked = as.get_name();
            String id_raw = id_cooked.substring(0, id_cooked.lastIndexOf(46));
            reads_cooked.add(id_cooked);
            reads_raw.add(id_raw);
        }
        sb.append("aligned read count: " + reads_cooked.size() + "\n");
        sb.append("unique fragment names: " + reads_raw.size() + "\n");
        JFrame jf = new JFrame();
        jf.setTitle("Sequence counts (generated suffixes removed)");
        jf.add("Center", new JScrollPane(new JTextArea(sb.toString())));
        jf.pack();
        jf.setVisible(true);
    }
}

