/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

public class AceSequence
implements Cloneable {
    String name;
    public String sequence;
    public boolean is_contig;
    public boolean complemented;
    public int asm_start_padded;
    public int asm_end_padded;
    int clip_start_padded;
    int clip_end_padded;
    String description;

    AceSequence(String s) {
        this.name = s;
        this.complemented = false;
    }

    public void reverse_complement() {
        StringBuffer seq = new StringBuffer(this.sequence);
        StringBuffer rc = seq.reverse();
        this.complemented = !this.complemented;
        int len = rc.length();
        for (int i = 0; i < len; ++i) {
            char c;
            switch (rc.charAt(i)) {
                case 'a': {
                    c = 't';
                    break;
                }
                case 'A': {
                    c = 'T';
                    break;
                }
                case 'c': {
                    c = 'g';
                    break;
                }
                case 'C': {
                    c = 'G';
                    break;
                }
                case 'g': {
                    c = 'c';
                    break;
                }
                case 'G': {
                    c = 'C';
                    break;
                }
                case 't': {
                    c = 'a';
                    break;
                }
                case 'T': {
                    c = 'A';
                    break;
                }
                case '*': {
                    c = '*';
                    break;
                }
                case 'n': {
                    c = 'n';
                    break;
                }
                case 'N': {
                    c = 'N';
                    break;
                }
                case 'x': {
                    c = 'x';
                    break;
                }
                case 'X': {
                    c = 'X';
                    break;
                }
                default: {
                    c = rc.charAt(i);
                    System.out.println("reverse: warning, don't know how to rc " + c);
                }
            }
            rc.setCharAt(i, c);
        }
        this.sequence = rc.toString();
    }

    public StringBuffer unpadded_sequence() {
        StringBuffer result = new StringBuffer();
        int length = this.sequence.length();
        for (int i = 0; i < length; ++i) {
            char c = this.sequence.charAt(i);
            if (c == '*') continue;
            result.append(c);
        }
        return result;
    }

    public void get_visible_sequence(char[] buf, int csv) {
        int max;
        int end_index;
        int start_index;
        int chunk_size = buf.length;
        for (int i = 0; i < chunk_size; ++i) {
            buf[i] = 32;
        }
        int leading_pads = this.asm_start_padded - csv;
        if (leading_pads < 0) {
            leading_pads = 0;
        }
        if ((start_index = csv - this.asm_start_padded) < 0) {
            start_index = 0;
        }
        if ((end_index = start_index + (chunk_size - leading_pads)) > (max = this.sequence.length())) {
            end_index = max;
        }
        this.sequence.getChars(start_index, end_index, buf, leading_pads);
    }

    public char get_base(int consensus_pos) {
        int i = this.consensus_to_index(consensus_pos);
        if (i > -1) {
            return this.sequence.charAt(i);
        }
        return ' ';
    }

    public int consensus_to_index(int consensus_pos) {
        int i = consensus_pos - this.asm_start_padded;
        if (i < 0 || i >= this.sequence.length()) {
            return -1;
        }
        return i;
    }
}

