# Updates IMEI/IMSI on Bluestacks 5.10 / Hyper-V / 64 bit / Android Pie 

## Make a backup of your BlueStacks folder before using it! 

### You must root your BlueStacks instances! 

#### pip install bluestackspatcher

```python
from bluestackspatcher import BlueStacksPatcher
bstackpatcher = BlueStacksPatcher(
    adb_path="C:\\Users\\Gamer\\AppData\\Local\\Android\\Sdk\\platform-tools\\adb.exe",
    bluestacks_config=r"C:\ProgramData\BlueStacks_nxt\bluestacks.conf",
    hdplayer=r"C:\Program Files\BlueStacks_nxt\HD-Player.exe",
)
bstackpatcher.connect_to_all_bluestacks_devices(timeout=3) # Always connect to all devices before you do any action, the master instance will always be ignored

a, b = bstackpatcher.update_imei_imsi_when_p_running_more_than_x_seconds(
    seconds=200, # The IMEI/IMSI will be updated if a BlueStacks instance is running more than 200 seconds
    locale="pt-BR",
    country="BR",
    countrycode="076", # https://wits.worldbank.org/wits/wits/witshelp/content/codes/country_codes.htm
    ignore=("Pie64_3",), # The name of the instances you want to be left alone
    min_threads_open=85, # On my PC, BlueStacks can be considered ready, if it has more than 85 threads running, you might need to adjust this number
    timeoutsearch=5, # time for psutil to scan the processes
    sleeptime=0.1, # sleep time for psutil
    timeoutstart=25, # if the instance is not ready after 25 seconds, it will be killed
)
print(a)
print(b)

a, b = bstackpatcher.get_new_imei_imsi(
    locale="pt-BR",
    country="BR",
    countrycode="076",
    ignore=("Pie64_3", "Pie64_4"),
    min_threads_open=85,
    timeoutsearch=5,
    sleeptime=0.1,
    timeoutstart=25,
)
print(a)
print(b)

r"""
  adb_port       imei       imsi       sims dalvik.vm.appimageformat dalvik.vm.dex2oat-Xms dalvik.vm.dex2oat-Xmx dalvik.vm.dex2oat-minidebuginfo dalvik.vm.dexopt.secondary dalvik.vm.heapgrowthlimit dalvik.vm.heapmaxfree dalvik.vm.heapminfree dalvik.vm.heapsize dalvik.vm.heapstartsize dalvik.vm.heaptargetutilization dalvik.vm.image-dex2oat-Xms dalvik.vm.image-dex2oat-Xmx dalvik.vm.isa.arm.features dalvik.vm.isa.arm.variant dalvik.vm.isa.arm64.features dalvik.vm.isa.arm64.variant dalvik.vm.isa.x86.features dalvik.vm.isa.x86.variant dalvik.vm.isa.x86_64.features dalvik.vm.isa.x86_64.variant dalvik.vm.lockprof.threshold dalvik.vm.stack-trace-dir dalvik.vm.usejit dalvik.vm.usejitprofiles debug.atrace.tags.enableflags debug.force_rtl dev.bootcomplete gsm.current.phone-type gsm.network.type gsm.operator.alpha gsm.operator.iso-country gsm.operator.isroaming gsm.operator.numeric gsm.sim.operator.alpha gsm.sim.operator.iso-country gsm.sim.operator.numeric gsm.sim.state gsm.version.baseband gsm.version.ril-impl hwservicemanager.ready init.svc.adbd init.svc.airplane_mode init.svc.audioserver init.svc.bindmount init.svc.bootanim init.svc.bstsvcmgrtest init.svc.cameraserver init.svc.drm init.svc.gatekeeperd init.svc.healthd init.svc.hidl_memory init.svc.hwservicemanager init.svc.incidentd init.svc.installd init.svc.keystore init.svc.lmkd init.svc.logd init.svc.logd-reinit init.svc.mdnsd init.svc.media init.svc.mediadrm init.svc.mediaextractor init.svc.mediametrics init.svc.mountsf init.svc.netd init.svc.proper_shutdown init.svc.ril-daemon init.svc.servicemanager init.svc.storaged init.svc.surfaceflinger init.svc.thermalservice init.svc.tombstoned init.svc.ueventd init.svc.usbd init.svc.vendor.audio-hal-2-0 init.svc.vendor.camera-provider-2-4 init.svc.vendor.cas-hal-1-0 init.svc.vendor.configstore-hal init.svc.vendor.dumpstate-1-0 init.svc.vendor.gnss_service init.svc.vendor.light-hal-2-0 init.svc.vendor.media.omx init.svc.vendor.memtrack-hal-1-0 init.svc.vendor.power-hal-1-0 init.svc.vndservicemanager init.svc.vold init.svc.wificond init.svc.zygote init.svc.zygote_secondary keyguard.no_require_sim log.tag.stats_log logd.logpersistd.enable media.sf.extractor-plugin media.sf.hwaccel media.sf.omx-plugin net.bt.name net.dns1   net.dns2 net.qtaguid_enabled net.tcp.default_init_rwnd persist.netd.stable_secret persist.rtc_local_time persist.sys.boot.reason persist.sys.cleardata persist.sys.dalvik.vm.lib.2 persist.sys.gps.lpp persist.sys.locale persist.sys.strictmode.disable persist.sys.strictmode.visual persist.sys.timezone persist.sys.usb.config persist.sys.webview.vmsize pm.dexopt.ab-ota pm.dexopt.bg-dexopt pm.dexopt.boot pm.dexopt.first-boot pm.dexopt.inactive pm.dexopt.install pm.dexopt.priv-apps-oob pm.dexopt.priv-apps-oob-list pm.dexopt.shared ro.actionable_compatible_property.enabled ro.alarm.volume.adjustable ro.allow.mock.location ro.arch ro.art.hiddenapi.warning ro.baseband ro.bionic.ld.warning ro.board.platform ro.boot.hardware ro.boot.serialno ro.boot.verifiedbootstate ro.bootimage.build.date ro.bootimage.build.date.utc ro.bootimage.build.fingerprint ro.bootloader ro.bootmode ro.boottime.init ro.boottime.init.cold_boot_wait ro.boottime.init.mount_all.default ro.boottime.init.selinux ro.build.characteristics ro.build.date ro.build.date.utc ro.build.description ro.build.display.id ro.build.fingerprint ro.build.flavor ro.build.host ro.build.id ro.build.product ro.build.tags ro.build.type ro.build.user ro.build.version.all_codenames ro.build.version.base_os ro.build.version.codename ro.build.version.incremental ro.build.version.min_supported_target_sdk ro.build.version.preview_sdk ro.build.version.release ro.build.version.sdk ro.build.version.security_patch ro.carrier ro.com.android.dataroaming ro.com.google.acsa ro.com.google.locationfeatures ro.config.alarm_alert ro.config.notification_sound ro.crypto.state ro.dalvik.vm.isa.arm ro.dalvik.vm.isa.arm64 ro.dalvik.vm.native.bridge ro.debuggable ro.device_owner ro.hardware ro.logd.size.stats ro.opengles.version ro.persistent_properties.ready ro.product.board ro.product.brand ro.product.cpu.abi ro.product.cpu.abilist ro.product.cpu.abilist32 ro.product.cpu.abilist64 ro.product.device ro.product.locale ro.product.manufacturer ro.product.model ro.product.name ro.product.vendor.brand ro.product.vendor.device ro.product.vendor.manufacturer ro.product.vendor.model ro.product.vendor.name ro.property_service.version ro.revision ro.ril.gprsclass ro.ril.hsxpa ro.runtime.firstboot ro.secure ro.serialno ro.sf.lcd_density ro.treble.enabled ro.vendor.build.date ro.vendor.build.date.utc ro.vendor.build.fingerprint ro.vendor.build.security_patch ro.vendor.product.cpu.abilist ro.vendor.product.cpu.abilist32 ro.vendor.product.cpu.abilist64 ro.vndk.version ro.wifi.channels  ro.zygote security.perf_harden selinux.restorecon_recursive service.bootanim.exit service.sf.present_timestamp sys.boot_completed sys.rescue_boot_count sys.retaildemo.enabled sys.sysctl.extra_free_kbytes sys.sysctl.tcp_def_init_rwnd sys.uidcpupower sys.usb.config sys.usb.configfs sys.user.0.ce_available tombstoned.max_tombstone_count vold.has_adoptable vold.has_quota vold.has_reserved vold.post_fs_data_done
0    57084  822791...  310410...  895505...        lz4                      64m                  512m                  true                            true                       256m                        8m                  512k                  384m                16m                    0.75                             64m                         64m                     default                    generic                   default                      generic                     default                     x86_64                   default                        x86_64                          500                    /data/anr                      true             true                        0                             0               1                1                    LTE         Claro BR                 br                    false                  72405             Claro BR                     br                        72405                    READY       1.0.0.0            Qualco...                 true                running       stopped                running              stopped            stopped           running                running               running      running              running          running              running                   running            running           running           running       running       stopped              running        running        running           running                 running               stopped          running       stopped                  running             running                 running           running                 running                 running             running          stopped       running                       running                             running                     running                         running                       running                      running                       running                   running                          running                       running                    running       running           running         running                      true                       I              true               libffm...                         1        libffm...             Android   1.1.1.1  100.12...          0                  60                 532:62...                          1              shutdo...                   false             libart.so                           0               pt-BR                  1                              0                     Americ...             none,adb              235258696                  speed-...        speed-...             extract        extract               verify          speed-...             false                     ALL                        speed             true                                      true                          1                 x86          1                  unknown           1               sdm660              qcom        1g6a72...            green                 Fri Fe...               167600...                   motoro...                        unknown       unknown        1815               34                               3                                 88                 nosdcard                Wed Ma...     158511...         payton...            payton...           motoro...            payton...          Build2     PPR1.1...   payton...        releas...          user         build           REL                                                     REL                   6736742                           17                                         0                            9                       28            2019-0...                         unknown       true                       true                  1                      Alarm_...             OnTheH...                    unsupp...             x86               x86_64               libnb.so                          1         false            qcom         64K             196608                true                         sdm660         motorola           x86_64          x86_64...              x86,ar...                x86_64...                payton...             en-US          motorola                 moto x4        payton_fi        motorola               payton...                 motorola                        moto x4               payton_fi                      2                           0          10                1    167850...                   0  1g6a72...         240             false         Fri Fe...            167600...                motoro...                   2019-0...                      x86_64...                     x86,ar...                          x86_64                              28                        zygote...          1            /data/...                            1                     1                            1                  1                     0                  16875                           60                                          mtp              0             true                      50                              1                  0              0                 1            
1    59251  788760...  310410...  895505...        lz4                      64m                  512m                  true                            true                       256m                        8m                  512k                  384m                16m                    0.75                             64m                         64m                     default                    generic                   default                      generic                     default                     x86_64                   default                        x86_64                          500                    /data/anr                      true             true                        0                             0               1                1                    LTE         Claro BR                 br                    false                  72405             Claro BR                     br                        72405                    READY       1.0.0.0            Samsun...                 true                running       stopped                running              stopped            stopped           running                running               running      running              running          running              running                   running            running           running           running       running       stopped              running        running        running           running                 running               stopped          running       stopped                  running             running                 running           running                 running                 running             running          stopped       running                       running                             running                     running                         running                       running                      running                       running                   running                          running                       running                    running       running           running         running                      true                       I              true               libffm...                         1        libffm...             Android   1.1.1.1  100.12...          0                  60                 6afd:9...                          1              shutdo...                   false             libart.so                           0               pt-BR                  1                              0                     Americ...             none,adb              235258696                  speed-...        speed-...             extract        extract               verify          speed-...             false                     ALL                        speed             true                                      true                          1                 x86          1                  unknown           1              exynos5         exynos...        bgagc1...            green                 Fri Fe...               167600...                   samsun...                        unknown       unknown        1279               13                               2                                 81                 nosdcard                Wed Ma...     158511...         d2sxx-...            d2sxx-...           samsun...            d2sxx-...          Build2     PPR1.1...         d2s        releas...          user         build           REL                                                     REL                   6736742                           17                                         0                            9                       28            2019-0...                         unknown       true                       true                  1                      Alarm_...             OnTheH...                    unsupp...             x86               x86_64               libnb.so                          1         false       exynos...         64K             196608                true                      univer...          samsung           x86_64          x86_64...              x86,ar...                x86_64...                      d2s             en-US           samsung                SM-N975F            d2sxx         samsung                     d2s                  samsung                       SM-N975F                   d2sxx                      2                           0          10                1    167850...                   0  bgagc1...         240             false         Fri Fe...            167600...                samsun...                   2019-0...                      x86_64...                     x86,ar...                          x86_64                              28                        zygote...          1            /data/...                            1                     1                            1                  1                     0                  16875                           60                                          mtp              0             true                      50                              1                  0              0                 1            
2    59270  728290...  310410...  895505...        lz4                      64m                  512m                  true                            true                       256m                        8m                  512k                  384m                16m                    0.75                             64m                         64m                     default                    generic                   default                      generic                     default                     x86_64                   default                        x86_64                          500                    /data/anr                      true             true                        0                             0               1                1                    LTE         Claro BR                 br                    false                  72405             Claro BR                     br                        72405                    READY       1.0.0.0            Samsun...                 true                running       stopped                running              stopped            stopped           running                running               running      running              running          running              running                   running            running           running           running       running       stopped              running        running        running           running                 running               stopped          running       stopped                  running             running                 running           running                 running                 running             running          stopped       running                       running                             running                     running                         running                       running                      running                       running                   running                          running                       running                    running       running           running         running                      true                       I              true               libffm...                         1        libffm...             Android   1.1.1.1  100.12...          0                  60                 13de:a...                          1              shutdo...                   false             libart.so                           0               pt-BR                  1                              0                     Americ...             none,adb              235258696                  speed-...        speed-...             extract        extract               verify          speed-...             false                     ALL                        speed             true                                      true                          1                 x86          1                  unknown           1              exynos8         exynos...        2a8e6g...            green                 Fri Fe...               167600...                   samsun...                        unknown       unknown        1436               33                               3                                 95                 nosdcard                Wed Ma...     158511...         z3qksx...            z3qksx...           samsun...            z3qksx...          Build2     PPR1.1...         z3q        releas...          user         build           REL                                                     REL                   6736742                           17                                         0                            9                       28            2019-0...                         unknown       true                       true                  1                      Alarm_...             OnTheH...                    unsupp...             x86               x86_64               libnb.so                          1         false       exynos...         64K             196608                true                      univer...          samsung           x86_64          x86_64...              x86,ar...                x86_64...                      z3q             en-US           samsung                SM-G988N           z3qksx         samsung                     z3q                  samsung                       SM-G988N                  z3qksx                      2                           0          10                1    167850...                   0  2a8e6g...         240             false         Fri Fe...            167600...                samsun...                   2019-0...                      x86_64...                     x86,ar...                          x86_64                              28                        zygote...          1            /data/...                            1                     1                            1                  1                     0                  16875                           60                                          mtp              0             true                      50                              1                  0              0                 1            
3    59282  267083...  302720...  895505...        lz4                      64m                  512m                  true                            true                       256m                        8m                  512k                  384m                16m                    0.75                             64m                         64m                     default                    generic                   default                      generic                     default                     x86_64                   default                        x86_64                          500                    /data/anr                      true             true                        0                             0               1                1                    LTE         Claro BR                 br                    false                  72405             Claro BR                     br                        72405                    READY       1.0.0.0            Qualco...                 true                running       stopped                running              stopped            stopped           running                running               running      running              running          running              running                   running            running           running           running       running       stopped              running        running        running           running                 running               stopped          running       stopped                  running             running                 running           running                 running                 running             running          stopped       running                       running                             running                     running                         running                       running                      running                       running                   running                          running                       running                    running       running           running         running                      true                       I              true               libffm...                         1        libffm...             Android   1.1.1.1  100.12...          0                  60                 6a7e:2...                          1              shutdo...                   false             libart.so                           0               pt-BR                  1                              0                     Americ...             none,adb              235258696                  speed-...        speed-...             extract        extract               verify          speed-...             false                     ALL                        speed             true                                      true                          1                 x86          1                  unknown           1                 kona              qcom        7g82d1...            green                 Fri Fe...               167600...                   OnePlu...                        unknown       unknown        1434               23                               2                                 87                 nosdcard                Wed Ma...     158511...         OnePlu...            KB2001...           OnePlu...            OnePlu...          Build2     RP1A.2...   OnePlus8T        releas...          user         build           REL                                                     REL                 211221...                           17                                         0                            9                       28            2021-1...                         unknown       true                       true                  1                      Alarm_...             OnTheH...                    unsupp...             x86               x86_64               libnb.so                          1         false            qcom         64K             196608                true                           kona          OnePlus           x86_64          x86_64...              x86,ar...                x86_64...                OnePlus8T             en-US           OnePlus                  KB2001        OnePlu...         OnePlus               OnePlus8T                  OnePlus                         KB2001               OnePlu...                      2                           0          10                1    167850...                   0  7g82d1...         240             false         Fri Fe...            167600...                OnePlu...                   2021-1...                      x86_64...                     x86,ar...                          x86_64                              28                        zygote...          1            /data/...                            1                     1                            1                  1                     0                  16875                           60                                          mtp              0             true                      50                              1                  0              0                 1            
4    59298  828239...  302720...  895505...        lz4                      64m                  512m                  true                            true                       256m                        8m                  512k                  384m                16m                    0.75                             64m                         64m                     default                    generic                   default                      generic                     default                     x86_64                   default                        x86_64                          500                    /data/anr                      true             true                        0                             0               1                1                    LTE         Claro BR                 br                    false                  72405             Claro BR                     br                        72405                    READY       1.0.0.0            Samsun...                 true                running       stopped                running              stopped            stopped           running                running               running      running              running          running              running                   running            running           running           running       running       stopped              running        running        running           running                 running               stopped          running       stopped                  running             running                 running           running                 running                 running             running          stopped       running                       running                             running                     running                         running                       running                      running                       running                   running                          running                       running                    running       running           running         running                      true                       I              true               libffm...                         1        libffm...             Android   1.1.1.1  100.12...          0                  60                 3a50:9...                          1              shutdo...                   false             libart.so                           0               pt-BR                  1                              0                     Americ...             none,adb              235258696                  speed-...        speed-...             extract        extract               verify          speed-...             false                     ALL                        speed             true                                      true                          1                 x86          1                  unknown           1                 kona              qcom        c7aabg...            green                 Fri Fe...               167600...                   samsun...                        unknown       unknown        1353               13                               3                                 96                 nosdcard                Wed Ma...     158511...         SCG02-...            SCG02-...           samsun...            y2qkdi...          Build2     PPR1.1...       SCG02        releas...          user         build           REL                                                     REL                   6736742                           17                                         0                            9                       28            2019-0...                         unknown       true                       true                  1                      Alarm_...             OnTheH...                    unsupp...             x86               x86_64               libnb.so                          1         false            qcom         64K             196608                true                           kona          samsung           x86_64          x86_64...              x86,ar...                x86_64...                    SCG02             en-US           samsung                   SCG02        SCG02_...         samsung                   SCG02                  samsung                          SCG02               SCG02_...                      2                           0          10                1    167850...                   0  c7aabg...         240             false         Fri Fe...            167600...                samsun...                   2019-0...                      x86_64...                     x86,ar...                          x86_64                              28                        zygote...          1            /data/...                            1                     1                            1                  1                     0                  16875                           60                                          mtp              0             true                      50                              1                  0              0                 1            
5    59311  979786...  234101...  895505...        lz4                      64m                  512m                  true                            true                       256m                        8m                  512k                  384m                16m                    0.75                             64m                         64m                     default                    generic                   default                      generic                     default                     x86_64                   default                        x86_64                          500                    /data/anr                      true             true                        0                             0               1                1                    LTE         Claro BR                 br                    false                  72405             Claro BR                     br                        72405                    READY       1.0.0.0            Samsun...                 true                running       stopped                running              stopped            stopped           running                running               running      running              running          running              running                   running            running           running           running       running       stopped              running        running        running           running                 running               stopped          running       stopped                  running             running                 running           running                 running                 running             running          stopped       running                       running                             running                     running                         running                       running                      running                       running                   running                          running                       running                    running       running           running         running                      true                       I              true               libffm...                         1        libffm...             Android   1.1.1.1  100.12...          0                  60                 6345:8...                          1              shutdo...                   false             libart.so                           0               pt-BR                  1                              0                     Americ...             none,adb              235258696                  speed-...        speed-...             extract        extract               verify          speed-...             false                     ALL                        speed             true                                      true                          1                 x86          1                  unknown           1              exynos5         samsun...        6f39c6...            green                 Fri Fe...               167600...                   samsun...                        unknown       unknown        1625               23                               3                                 84                 nosdcard                Wed Ma...     158511...         star2l...            star2l...           samsun...            star2l...          Build2     PPR1.1...    star2lte        releas...          user         build           REL                                                     REL                   6736742                           17                                         0                            9                       28            2019-0...                         unknown       true                       true                  1                      Alarm_...             OnTheH...                    unsupp...             x86               x86_64               libnb.so                          1         false       samsun...         64K             196608                true                      univer...          samsung           x86_64          x86_64...              x86,ar...                x86_64...                 star2lte             en-US           samsung                SM-G965F        star2l...         samsung                star2lte                  samsung                       SM-G965F               star2l...                      2                           0          10                1    167850...                   0  6f39c6...         240             false         Fri Fe...            167600...                samsun...                   2019-0...                      x86_64...                     x86,ar...                          x86_64                              28                        zygote...          1            /data/...                            1                     1                            1                  1                     0                  16875                           60                                          mtp              0             true                      50                              1                  0              0                 1            
6    59326  859917...  234103...  895505...        lz4                      64m                  512m                  true                            true                       256m                        8m                  512k                  384m                16m                    0.75                             64m                         64m                     default                    generic                   default                      generic                     default                     x86_64                   default                        x86_64                          500                    /data/anr                      true             true                        0                             0               1                1                    LTE         Claro BR                 br                    false                  72405             Claro BR                     br                        72405                    READY       1.0.0.0            Qualco...                 true                running       stopped                running              stopped            stopped           running                running               running      running              running          running              running                   running            running           running           running       running       stopped              running        running        running           running                 running               stopped          running       stopped                  running             running                 running           running                 running                 running             running          stopped       running                       running                             running                     running                         running                       running                      running                       running                   running                          running                       running                    running       running           running         running                      true                       I              true               libffm...                         1        libffm...             Android   1.1.1.1  100.12...          0                  60                 43c7:d...                          1              shutdo...                   false             libart.so                           0               pt-BR                  1                              0                     Americ...             none,adb              235258696                  speed-...        speed-...             extract        extract               verify          speed-...             false                     ALL                        speed             true                                      true                          1                 x86          1                  unknown           1              msm8996              qcom        99g726...            green                 Fri Fe...               167600...                   OnePlu...                        unknown       unknown        1993               13                               3                                 94                 nosdcard                Wed Ma...     158511...         OnePlu...            OnePlu...           OnePlu...            OnePlu...          Build2     PPR1.1...    OnePlus3        releas...          user         build           REL                                                     REL                   6736742                           17                                         0                            9                       28            2019-0...                         unknown       true                       true                  1                      Alarm_...             OnTheH...                    unsupp...             x86               x86_64               libnb.so                          1         false            qcom         64K             196608                true                      QC_Ref...          OnePlus           x86_64          x86_64...              x86,ar...                x86_64...                OnePlus3T             en-US           OnePlus               ONEPLU...         OnePlus3         OnePlus               OnePlus3T                  OnePlus                      ONEPLU...                OnePlus3                      2                           0          10                1    167850...                   0  99g726...         240             false         Fri Fe...            167600...                OnePlu...                   2019-0...                      x86_64...                     x86,ar...                          x86_64                              28                        zygote...          1            /data/...                            1                     1                            1                  1                     0                  16875                           60                                          mtp              0             true                      50                              1                  0              0                 1            
7    59341  222170...  302720...  895505...        lz4                      64m                  512m                  true                            true                       256m                        8m                  512k                  384m                16m                    0.75                             64m                         64m                     default                    generic                   default                      generic                     default                     x86_64                   default                        x86_64                          500                    /data/anr                      true             true                        0                             0               1                1                    LTE         Claro BR                 br                    false                  72405             Claro BR                     br                        72405                    READY       1.0.0.0            Samsun...                 true                running       stopped                running              stopped            stopped           running                running               running      running              running          running              running                   running            running           running           running       running       stopped              running        running        running           running                 running               stopped          running       stopped                  running             running                 running           running                 running                 running             running          stopped       running                       running                             running                     running                         running                       running                      running                       running                   running                          running                       running                    running       running           running         running                      true                       I              true               libffm...                         1        libffm...             Android   1.1.1.1  100.12...          0                  60                 290a:7...                          1              shutdo...                   false             libart.so                           0               pt-BR                  1                              0                     Americ...             none,adb              235258696                  speed-...        speed-...             extract        extract               verify          speed-...             false                     ALL                        speed             true                                      true                          1                 x86          1                  unknown           1                 kona              qcom        ef7455...            green                 Fri Fe...               167600...                   samsun...                        unknown       unknown        2149               15                               3                                115                 nosdcard                Wed Ma...     158511...         SCG02-...            SCG02-...           samsun...            y2qkdi...          Build2     PPR1.1...       SCG02        releas...          user         build           REL                                                     REL                   6736742                           17                                         0                            9                       28            2019-0...                         unknown       true                       true                  1                      Alarm_...             OnTheH...                    unsupp...             x86               x86_64               libnb.so                          1         false            qcom         64K             196608                true                           kona          samsung           x86_64          x86_64...              x86,ar...                x86_64...                    SCG02             en-US           samsung                   SCG02        SCG02_...         samsung                   SCG02                  samsung                          SCG02               SCG02_...                      2                           0          10                1    167850...                   0  ef7455...         240             false         Fri Fe...            167600...                samsun...                   2019-0...                      x86_64...                     x86,ar...                          x86_64                              28                        zygote...          1            /data/...                            1                     1                            1                  1                     0                  16875                           60                                          mtp              0             true                      50                              1                  0              0                 1            
8    59355  780789...  310410...  895505...        lz4                      64m                  512m                  true                            true                       256m                        8m                  512k                  384m                16m                    0.75                             64m                         64m                     default                    generic                   default                      generic                     default                     x86_64                   default                        x86_64                          500                    /data/anr                      true             true                        0                             0               1                1                    LTE         Claro BR                 br                    false                  72405             Claro BR                     br                        72405                    READY       1.0.0.0            Samsun...                 true                running       stopped                running              stopped            stopped           running                running               running      running              running          running              running                   running            running           running           running       running       stopped              running        running        running           running                 running               stopped          running       stopped                  running             running                 running           running                 running                 running             running          stopped       running                       running                             running                     running                         running                       running                      running                       running                   running                          running                       running                    running       running           running         running                      true                       I              true               libffm...                         1        libffm...             Android   1.1.1.1  100.12...          0                  60                 b4d4:d...                          1              shutdo...                   false             libart.so                           0               pt-BR                  1                              0                     Americ...             none,adb              235258696                  speed-...        speed-...             extract        extract               verify          speed-...             false                     ALL                        speed             true                                      true                          1                 x86          1                  unknown           1              exynos5         exynos...        173934...            green                 Fri Fe...               167600...                   samsun...                        unknown       unknown        1911                3                               3                                112                 nosdcard                Wed Ma...     158511...         beyond...            beyond...           samsun...            beyond...          Build2     PPR1.1...   beyond...        releas...          user         build           REL                                                     REL                   6736742                           17                                         0                            9                       28            2019-0...                         unknown       true                       true                  1                      Alarm_...             OnTheH...                    unsupp...             x86               x86_64               libnb.so                          1         false       exynos...         64K             196608                true                      univer...          samsung           x86_64          x86_64...              x86,ar...                x86_64...                  beyond2             en-US           samsung                SM-G975F        beyond...         samsung                 beyond2                  samsung                       SM-G975F               beyond...                      2                           0          10                1    167850...                   0  173934...         240             false         Fri Fe...            167600...                samsun...                   2019-0...                      x86_64...                     x86,ar...                          x86_64                              28                        zygote...          1            /data/...                            1                     1                            1                  1                     0                  16875                           60                                          mtp              0             true                      50                              1                  0              0                 1            
9    59375  049217...  440205...  895505...        lz4                      64m                  512m                  true                            true                       256m                        8m                  512k                  384m                16m                    0.75                             64m                         64m                     default                    generic                   default                      generic                     default                     x86_64                   default                        x86_64                          500                    /data/anr                      true             true                        0                             0               1                1                    LTE         Claro BR                 br                    false                  72405             Claro BR                     br                        72405                    READY       1.0.0.0            Samsun...                 true                running       stopped                running              stopped            stopped           running                running               running      running              running          running              running                   running            running           running           running       running       stopped              running        running        running           running                 running               stopped          running       stopped                  running             running                 running           running                 running                 running             running          stopped       running                       running                             running                     running                         running                       running                      running                       running                   running                          running                       running                    running       running           running         running                      true                       I              true               libffm...                         1        libffm...             Android   1.1.1.1  100.12...          0                  60                 d031:d...                          1              shutdo...                   false             libart.so                           0               pt-BR                  1                              0                     Americ...             none,adb              235258696                  speed-...        speed-...             extract        extract               verify          speed-...             false                     ALL                        speed             true                                      true                          1                 x86          1                  unknown           1              exynos8         exynos...        f81a8e...            green                 Fri Fe...               167600...                   samsun...                        unknown       unknown        1310               13                               3                                 92                 nosdcard                Wed Ma...     158511...         z3qksx...            z3qksx...           samsun...            z3qksx...          Build2     PPR1.1...         z3q        releas...          user         build           REL                                                     REL                   6736742                           17                                         0                            9                       28            2019-0...                         unknown       true                       true                  1                      Alarm_...             OnTheH...                    unsupp...             x86               x86_64               libnb.so                          1         false       exynos...         64K             196608                true                      univer...          samsung           x86_64          x86_64...              x86,ar...                x86_64...                      z3q             en-US           samsung                SM-G988N           z3qksx         samsung                     z3q                  samsung                       SM-G988N                  z3qksx                      2                           0          10                1    167850...                   0  f81a8e...         240             false         Fri Fe...            167600...                samsun...                   2019-0...                      x86_64...                     x86,ar...                          x86_64                              28                        zygote...          1            /data/...                            1                     1                            1                  1                     0                  16875                           60                                          mtp              0             true                      50                              1                  0              0                 1            
  adb_port       imei       imsi       sims dalvik.vm.appimageformat dalvik.vm.dex2oat-Xms dalvik.vm.dex2oat-Xmx dalvik.vm.dex2oat-minidebuginfo dalvik.vm.dexopt.secondary dalvik.vm.heapgrowthlimit dalvik.vm.heapmaxfree dalvik.vm.heapminfree dalvik.vm.heapsize dalvik.vm.heapstartsize dalvik.vm.heaptargetutilization dalvik.vm.image-dex2oat-Xms dalvik.vm.image-dex2oat-Xmx dalvik.vm.isa.arm.features dalvik.vm.isa.arm.variant dalvik.vm.isa.arm64.features dalvik.vm.isa.arm64.variant dalvik.vm.isa.x86.features dalvik.vm.isa.x86.variant dalvik.vm.isa.x86_64.features dalvik.vm.isa.x86_64.variant dalvik.vm.lockprof.threshold dalvik.vm.stack-trace-dir dalvik.vm.usejit dalvik.vm.usejitprofiles debug.atrace.tags.enableflags debug.force_rtl dev.bootcomplete gsm.current.phone-type gsm.network.type gsm.operator.alpha gsm.operator.iso-country gsm.operator.isroaming gsm.operator.numeric gsm.sim.operator.alpha gsm.sim.operator.iso-country gsm.sim.operator.numeric gsm.sim.state gsm.version.baseband gsm.version.ril-impl hwservicemanager.ready init.svc.adbd init.svc.airplane_mode init.svc.audioserver init.svc.bindmount init.svc.bootanim init.svc.bstsvcmgrtest init.svc.cameraserver init.svc.drm init.svc.gatekeeperd init.svc.healthd init.svc.hidl_memory init.svc.hwservicemanager init.svc.incidentd init.svc.installd init.svc.keystore init.svc.lmkd init.svc.logd init.svc.logd-reinit init.svc.mdnsd init.svc.media init.svc.mediadrm init.svc.mediaextractor init.svc.mediametrics init.svc.mountsf init.svc.netd init.svc.proper_shutdown init.svc.ril-daemon init.svc.servicemanager init.svc.storaged init.svc.surfaceflinger init.svc.thermalservice init.svc.tombstoned init.svc.ueventd init.svc.usbd init.svc.vendor.audio-hal-2-0 init.svc.vendor.camera-provider-2-4 init.svc.vendor.cas-hal-1-0 init.svc.vendor.configstore-hal init.svc.vendor.dumpstate-1-0 init.svc.vendor.gnss_service init.svc.vendor.light-hal-2-0 init.svc.vendor.media.omx init.svc.vendor.memtrack-hal-1-0 init.svc.vendor.power-hal-1-0 init.svc.vndservicemanager init.svc.vold init.svc.wificond init.svc.zygote init.svc.zygote_secondary keyguard.no_require_sim log.tag.stats_log logd.logpersistd.enable media.sf.extractor-plugin media.sf.hwaccel media.sf.omx-plugin net.bt.name net.dns1   net.dns2 net.qtaguid_enabled net.tcp.default_init_rwnd persist.netd.stable_secret persist.rtc_local_time persist.sys.boot.reason persist.sys.cleardata persist.sys.dalvik.vm.lib.2 persist.sys.gps.lpp persist.sys.locale persist.sys.strictmode.disable persist.sys.strictmode.visual persist.sys.timezone persist.sys.usb.config persist.sys.webview.vmsize pm.dexopt.ab-ota pm.dexopt.bg-dexopt pm.dexopt.boot pm.dexopt.first-boot pm.dexopt.inactive pm.dexopt.install pm.dexopt.priv-apps-oob pm.dexopt.priv-apps-oob-list pm.dexopt.shared ro.actionable_compatible_property.enabled ro.alarm.volume.adjustable ro.allow.mock.location ro.arch ro.art.hiddenapi.warning ro.baseband ro.bionic.ld.warning ro.board.platform ro.boot.hardware ro.boot.serialno ro.boot.verifiedbootstate ro.bootimage.build.date ro.bootimage.build.date.utc ro.bootimage.build.fingerprint ro.bootloader ro.bootmode ro.boottime.init ro.boottime.init.cold_boot_wait ro.boottime.init.mount_all.default ro.boottime.init.selinux ro.build.characteristics ro.build.date ro.build.date.utc ro.build.description ro.build.display.id ro.build.fingerprint ro.build.flavor ro.build.host ro.build.id ro.build.product ro.build.tags ro.build.type ro.build.user ro.build.version.all_codenames ro.build.version.base_os ro.build.version.codename ro.build.version.incremental ro.build.version.min_supported_target_sdk ro.build.version.preview_sdk ro.build.version.release ro.build.version.sdk ro.build.version.security_patch ro.carrier ro.com.android.dataroaming ro.com.google.acsa ro.com.google.locationfeatures ro.config.alarm_alert ro.config.notification_sound ro.crypto.state ro.dalvik.vm.isa.arm ro.dalvik.vm.isa.arm64 ro.dalvik.vm.native.bridge ro.debuggable ro.device_owner ro.hardware ro.logd.size.stats ro.opengles.version ro.persistent_properties.ready ro.product.board ro.product.brand ro.product.cpu.abi ro.product.cpu.abilist ro.product.cpu.abilist32 ro.product.cpu.abilist64 ro.product.device ro.product.locale ro.product.manufacturer ro.product.model ro.product.name ro.product.vendor.brand ro.product.vendor.device ro.product.vendor.manufacturer ro.product.vendor.model ro.product.vendor.name ro.property_service.version ro.revision ro.ril.gprsclass ro.ril.hsxpa ro.runtime.firstboot ro.secure ro.serialno ro.sf.lcd_density ro.treble.enabled ro.vendor.build.date ro.vendor.build.date.utc ro.vendor.build.fingerprint ro.vendor.build.security_patch ro.vendor.product.cpu.abilist ro.vendor.product.cpu.abilist32 ro.vendor.product.cpu.abilist64 ro.vndk.version ro.wifi.channels  ro.zygote security.perf_harden selinux.restorecon_recursive service.bootanim.exit service.sf.present_timestamp sys.boot_completed sys.rescue_boot_count sys.retaildemo.enabled sys.sysctl.extra_free_kbytes sys.sysctl.tcp_def_init_rwnd sys.uidcpupower sys.usb.config sys.usb.configfs sys.user.0.ce_available tombstoned.max_tombstone_count vold.has_adoptable vold.has_quota vold.has_reserved vold.post_fs_data_done
0    57084  822791...  310410...  895505...        lz4                      64m                  512m                  true                            true                       256m                        8m                  512k                  384m                16m                    0.75                             64m                         64m                     default                    generic                   default                      generic                     default                     x86_64                   default                        x86_64                          500                    /data/anr                      true             true                        0                             0               1                1                    LTE         Claro BR                 br                    false                  72405             Claro BR                     br                        72405                    READY       1.0.0.0            Qualco...                 true                running       stopped                running              stopped            stopped           running                running               running      running              running          running              running                   running            running           running           running       running       stopped              running        running        running           running                 running               stopped          running       stopped                  running             running                 running           running                 running                 running             running          stopped       running                       running                             running                     running                         running                       running                      running                       running                   running                          running                       running                    running       running           running         running                      true                       I              true               libffm...                         1        libffm...             Android   1.1.1.1  100.12...          0                  60                 532:62...                          1              shutdo...                   false             libart.so                           0               pt-BR                  1                              0                     Americ...             none,adb              235258696                  speed-...        speed-...             extract        extract               verify          speed-...             false                     ALL                        speed             true                                      true                          1                 x86          1                  unknown           1               sdm660              qcom        1g6a72...            green                 Fri Fe...               167600...                   motoro...                        unknown       unknown        1815               34                               3                                 88                 nosdcard                Wed Ma...     158511...         payton...            payton...           motoro...            payton...          Build2     PPR1.1...   payton...        releas...          user         build           REL                                                     REL                   6736742                           17                                         0                            9                       28            2019-0...                         unknown       true                       true                  1                      Alarm_...             OnTheH...                    unsupp...             x86               x86_64               libnb.so                          1         false            qcom         64K             196608                true                         sdm660         motorola           x86_64          x86_64...              x86,ar...                x86_64...                payton...             en-US          motorola                 moto x4        payton_fi        motorola               payton...                 motorola                        moto x4               payton_fi                      2                           0          10                1    167850...                   0  1g6a72...         240             false         Fri Fe...            167600...                motoro...                   2019-0...                      x86_64...                     x86,ar...                          x86_64                              28                        zygote...          1            /data/...                            1                     1                            1                  1                     0                  16875                           60                                          mtp              0             true                      50                              1                  0              0                 1            
1    59375  049217...  440205...  895505...        lz4                      64m                  512m                  true                            true                       256m                        8m                  512k                  384m                16m                    0.75                             64m                         64m                     default                    generic                   default                      generic                     default                     x86_64                   default                        x86_64                          500                    /data/anr                      true             true                        0                             0               1                1                    LTE         Claro BR                 br                    false                  72405             Claro BR                     br                        72405                    READY       1.0.0.0            Samsun...                 true                running       stopped                running              stopped            stopped           running                running               running      running              running          running              running                   running            running           running           running       running       stopped              running        running        running           running                 running               stopped          running       stopped                  running             running                 running           running                 running                 running             running          stopped       running                       running                             running                     running                         running                       running                      running                       running                   running                          running                       running                    running       running           running         running                      true                       I              true               libffm...                         1        libffm...             Android   1.1.1.1  100.12...          0                  60                 d031:d...                          1              shutdo...                   false             libart.so                           0               pt-BR                  1                              0                     Americ...             none,adb              235258696                  speed-...        speed-...             extract        extract               verify          speed-...             false                     ALL                        speed             true                                      true                          1                 x86          1                  unknown           1              exynos8         exynos...        f81a8e...            green                 Fri Fe...               167600...                   samsun...                        unknown       unknown        1310               13                               3                                 92                 nosdcard                Wed Ma...     158511...         z3qksx...            z3qksx...           samsun...            z3qksx...          Build2     PPR1.1...         z3q        releas...          user         build           REL                                                     REL                   6736742                           17                                         0                            9                       28            2019-0...                         unknown       true                       true                  1                      Alarm_...             OnTheH...                    unsupp...             x86               x86_64               libnb.so                          1         false       exynos...         64K             196608                true                      univer...          samsung           x86_64          x86_64...              x86,ar...                x86_64...                      z3q             en-US           samsung                SM-G988N           z3qksx         samsung                     z3q                  samsung                       SM-G988N                  z3qksx                      2                           0          10                1    167850...                   0  f81a8e...         240             false         Fri Fe...            167600...                samsun...                   2019-0...                      x86_64...                     x86,ar...                          x86_64                              28                        zygote...          1            /data/...                            1                     1                            1                  1                     0                  16875                           60                                          mtp              0             true                      50                              1                  0              0                 1            
2    60644  568627...  724053...  895505...        lz4                      64m                  512m                  true                            true                       256m                        8m                  512k                  384m                16m                    0.75                             64m                         64m                     default                    generic                   default                      generic                     default                     x86_64                   default                        x86_64                          500                    /data/anr                      true             true                        0                             0               1                1                    LTE         Claro BR                 br                    false                  72405             Claro BR                     br                        72405                    READY       1.0.0.0            Samsun...                 true                running       stopped                running              stopped            stopped           running                running               running      running              running          running              running                   running            running           running           running       running       stopped              running        running        running           running                 running               stopped          running       stopped                  running             running                 running           running                 running                 running             running          stopped       running                       running                             running                     running                         running                       running                      running                       running                   running                          running                       running                    running       running           running         running                      true                       I              true               libffm...                         1        libffm...             Android   1.1.1.1  100.12...          0                  60                 13de:a...                          1              shutdo...                   false             libart.so                           0               pt-BR                  1                              0                     Americ...             none,adb              235258696                  speed-...        speed-...             extract        extract               verify          speed-...             false                     ALL                        speed             true                                      true                          1                 x86          1                  unknown           1                 kona              qcom        82f8e7...            green                 Fri Fe...               167600...                   samsun...                        unknown       unknown        1302               33                               2                                 89                 nosdcard                Wed Ma...     158511...         SCG02-...            SCG02-...           samsun...            y2qkdi...          Build2     PPR1.1...       SCG02        releas...          user         build           REL                                                     REL                   6736742                           17                                         0                            9                       28            2019-0...                         unknown       true                       true                  1                      Alarm_...             OnTheH...                    unsupp...             x86               x86_64               libnb.so                          1         false            qcom         64K             196608                true                           kona          samsung           x86_64          x86_64...              x86,ar...                x86_64...                    SCG02             en-US           samsung                   SCG02        SCG02_...         samsung                   SCG02                  samsung                          SCG02               SCG02_...                      2                           0          10                1    167850...                   0  82f8e7...         240             false         Fri Fe...            167600...                samsun...                   2019-0...                      x86_64...                     x86,ar...                          x86_64                              28                        zygote...          1            /data/...                            1                     1                            1                  1                     0                  16875                           60                                          mtp              0             true                      50                              1                  0              0                 1            
3    60656  821516...  724053...  895505...        lz4                      64m                  512m                  true                            true                       256m                        8m                  512k                  384m                16m                    0.75                             64m                         64m                     default                    generic                   default                      generic                     default                     x86_64                   default                        x86_64                          500                    /data/anr                      true             true                        0                             0               1                1                    LTE         Claro BR                 br                    false                  72405             Claro BR                     br                        72405                    READY       1.0.0.0            Samsun...                 true                running       stopped                running              stopped            stopped           running                running               running      running              running          running              running                   running            running           running           running       running       stopped              running        running        running           running                 running               stopped          running       stopped                  running             running                 running           running                 running                 running             running          stopped       running                       running                             running                     running                         running                       running                      running                       running                   running                          running                       running                    running       running           running         running                      true                       I              true               libffm...                         1        libffm...             Android   1.1.1.1  100.12...          0                  60                 3a50:9...                          1              shutdo...                   false             libart.so                           0               pt-BR                  1                              0                     Americ...             none,adb              235258696                  speed-...        speed-...             extract        extract               verify          speed-...             false                     ALL                        speed             true                                      true                          1                 x86          1                  unknown           1               SM8150            SM8150        e5a6d9...            green                 Fri Fe...               167600...                   samsun...                        unknown       unknown        1304               23                               3                                 94                 nosdcard                Wed Ma...     158511...         r3qxx-...            r3qxx-...           samsun...            r3qxx-...          Build2     PPR1.1...         r3q        releas...          user         build           REL                                                     REL                   6736742                           17                                         0                            9                       28            2019-0...                         unknown       true                       true                  1                      Alarm_...             OnTheH...                    unsupp...             x86               x86_64               libnb.so                          1         false          SM8150         64K             196608                true                         SM8150          samsung           x86_64          x86_64...              x86,ar...                x86_64...                      r3q             en-US           samsung                SM-A908N            r3qxx         samsung                     r3q                  samsung                       SM-A908N                   r3qxx                      2                           0          10                1    167850...                   0  e5a6d9...         240             false         Fri Fe...            167600...                samsun...                   2019-0...                      x86_64...                     x86,ar...                          x86_64                              28                        zygote...          1            /data/...                            1                     1                            1                  1                     0                  16875                           60                                          mtp              0             true                      50                              1                  0              0                 1            
4    60673  918927...  310260...  895505...        lz4                      64m                  512m                  true                            true                       256m                        8m                  512k                  384m                16m                    0.75                             64m                         64m                     default                    generic                   default                      generic                     default                     x86_64                   default                        x86_64                          500                    /data/anr                      true             true                        0                             0               1                1                    LTE         Claro BR                 br                    false                  72405             Claro BR                     br                        72405                    READY       1.0.0.0            LGESta...                 true                running       stopped                running              stopped            stopped           running                running               running      running              running          running              running                   running            running           running           running       running       stopped              running        running        running           running                 running               stopped          running       stopped                  running             running                 running           running                 running                 running             running          stopped       running                       running                             running                     running                         running                       running                      running                       running                   running                          running                       running                    running       running           running         running                      true                       I              true               libffm...                         1        libffm...             Android   1.1.1.1  100.12...          0                  60                 6345:8...                          1              shutdo...                   false             libart.so                           0               pt-BR                  1                              0                     Americ...             none,adb              235258696                  speed-...        speed-...             extract        extract               verify          speed-...             false                     ALL                        speed             true                                      true                          1                 x86          1                  unknown           1              msm8998           msm8998        9gb124...            green                 Fri Fe...               167600...                   LGE/jo...                        unknown       unknown        1589               23                               2                                 84                 nosdcard                Wed Ma...     158511...         joan_k...            joan_k...           LGE/jo...            joan_k...          Build2     PPR1.1...        joan        releas...          user         build           REL                                                     REL                   6736742                           17                                         0                            9                       28            2019-0...                         unknown       true                       true                  1                      Alarm_...             OnTheH...                    unsupp...             x86               x86_64               libnb.so                          1         false         msm8998         64K             196608                true                      univer...              LGE           x86_64          x86_64...              x86,ar...                x86_64...                     joan             en-US               LGE                 LG-H930        joan_k...             LGE                    joan                      LGE                        LG-H930               joan_k...                      2                           0          10                1    167850...                   0  9gb124...         240             false         Fri Fe...            167600...                LGE/jo...                   2019-0...                      x86_64...                     x86,ar...                          x86_64                              28                        zygote...          1            /data/...                            1                     1                            1                  1                     0                  16875                           60                                          mtp              0             true                      50                              1                  0              0                 1            
5    60687  380292...  234109...  895505...        lz4                      64m                  512m                  true                            true                       256m                        8m                  512k                  384m                16m                    0.75                             64m                         64m                     default                    generic                   default                      generic                     default                     x86_64                   default                        x86_64                          500                    /data/anr                      true             true                        0                             0               1                1                    LTE         Claro BR                 br                    false                  72405             Claro BR                     br                        72405                    READY       1.0.0.0            Qualco...                 true                running       stopped                running              stopped            stopped           running                running               running      running              running          running              running                   running            running           running           running       running       stopped              running        running        running           running                 running               stopped          running       stopped                  running             running                 running           running                 running                 running             running          stopped       running                       running                             running                     running                         running                       running                      running                       running                   running                          running                       running                    running       running           running         running                      true                       I              true               libffm...                         1        libffm...             Android   1.1.1.1  100.12...          0                  60                 43c7:d...                          1              shutdo...                   false             libart.so                           0               pt-BR                  1                              0                     Americ...             none,adb              235258696                  speed-...        speed-...             extract        extract               verify          speed-...             false                     ALL                        speed             true                                      true                          1                 x86          1                  unknown           1              msmnile              qcom        cdc1c1...            green                 Fri Fe...               167600...                   asus/W...                        unknown       unknown        2388               23                               3                                 87                 nosdcard                Wed Ma...     158511...         WW_I00...            WW_I00...           asus/W...            WW_I00...          Build2     PPR1.1...     ZS660KL        releas...          user         build           REL                                                     REL                   6736742                           17                                         0                            9                       28            2019-0...                         unknown       true                       true                  1                      Alarm_...             OnTheH...                    unsupp...             x86               x86_64               libnb.so                          1         false            qcom         64K             196608                true                        msmnile             asus           x86_64          x86_64...              x86,ar...                x86_64...                ASUS_I...             en-US              asus               ASUS_Z...         WW_I001D            asus               ASUS_I...                     asus                      ASUS_Z...                WW_I001D                      2                           0          10                1    167850...                   0  cdc1c1...         240             false         Fri Fe...            167600...                asus/W...                   2019-0...                      x86_64...                     x86,ar...                          x86_64                              28                        zygote...          1            /data/...                            1                     1                            1                  1                     0                  16875                           60                                          mtp              0             true                      50                              1                  0              0                 1            
6    60705  223388...  302720...  895505...        lz4                      64m                  512m                  true                            true                       256m                        8m                  512k                  384m                16m                    0.75                             64m                         64m                     default                    generic                   default                      generic                     default                     x86_64                   default                        x86_64                          500                    /data/anr                      true             true                        0                             0               1                1                    LTE         Claro BR                 br                    false                  72405             Claro BR                     br                        72405                    READY       1.0.0.0            Samsun...                 true                running       stopped                running              stopped            stopped           running                running               running      running              running          running              running                   running            running           running           running       running       stopped              running        running        running           running                 running               stopped          running       stopped                  running             running                 running           running                 running                 running             running          stopped       running                       running                             running                     running                         running                       running                      running                       running                   running                          running                       running                    running       running           running         running                      true                       I              true               libffm...                         1        libffm...             Android   1.1.1.1  100.12...          0                  60                 290a:7...                          1              shutdo...                   false             libart.so                           0               pt-BR                  1                              0                     Americ...             none,adb              235258696                  speed-...        speed-...             extract        extract               verify          speed-...             false                     ALL                        speed             true                                      true                          1                 x86          1                  unknown           1              exynos5            SDM730        42a797...            green                 Fri Fe...               167600...                   samsun...                        unknown       unknown        1619               13                               3                                 91                 nosdcard                Wed Ma...     158511...         a80lte...            a80lte...           samsun...            a80lte...          Build2     PPR1.1...      a80lte        releas...          user         build           REL                                                     REL                   6736742                           17                                         0                            9                       28            2019-0...                         unknown       true                       true                  1                      Alarm_...             OnTheH...                    unsupp...             x86               x86_64               libnb.so                          1         false          SDM730         64K             196608                true                         SDM730          samsung           x86_64          x86_64...              x86,ar...                x86_64...                   a80lte             en-US           samsung                SM-A805N         a80ltexx         samsung                  a80lte                  samsung                       SM-A805N                a80ltexx                      2                           0          10                1    167850...                   0  42a797...         240             false         Fri Fe...            167600...                samsun...                   2019-0...                      x86_64...                     x86,ar...                          x86_64                              28                        zygote...          1            /data/...                            1                     1                            1                  1                     0                  16875                           60                                          mtp              0             true                      50                              1                  0              0                 1            
7    60721  870795...  440207...  895505...        lz4                      64m                  512m                  true                            true                       256m                        8m                  512k                  384m                16m                    0.75                             64m                         64m                     default                    generic                   default                      generic                     default                     x86_64                   default                        x86_64                          500                    /data/anr                      true             true                        0                             0               1                1                    LTE         Claro BR                 br                    false                  72405             Claro BR                     br                        72405                    READY       1.0.0.0            Samsun...                 true                running       stopped                running              stopped            stopped           running                running               running      running              running          running              running                   running            running           running           running       running       stopped              running        running        running           running                 running               stopped          running       stopped                  running             running                 running           running                 running                 running             running          stopped       running                       running                             running                     running                         running                       running                      running                       running                   running                          running                       running                    running       running           running         running                      true                       I              true               libffm...                         1        libffm...             Android   1.1.1.1  100.12...          0                  60                 b4d4:d...                          1              shutdo...                   false             libart.so                           0               pt-BR                  1                              0                     Americ...             none,adb              235258696                  speed-...        speed-...             extract        extract               verify          speed-...             false                     ALL                        speed             true                                      true                          1                 x86          1                  unknown           1              exynos5         exynos...        6c2218...            green                 Fri Fe...               167600...                   samsun...                        unknown       unknown        2432               14                               3                                 91                 nosdcard                Wed Ma...     158511...         beyond...            beyond...           samsun...            beyond...          Build2     PPR1.1...   beyond...        releas...          user         build           REL                                                     REL                   6736742                           17                                         0                            9                       28            2019-0...                         unknown       true                       true                  1                      Alarm_...             OnTheH...                    unsupp...             x86               x86_64               libnb.so                          1         false       exynos...         64K             196608                true                      univer...          samsung           x86_64          x86_64...              x86,ar...                x86_64...                  beyond2             en-US           samsung                SM-G975F        beyond...         samsung                 beyond2                  samsung                       SM-G975F               beyond...                      2                           0          10                1    167850...                   0  6c2218...         240             false         Fri Fe...            167600...                samsun...                   2019-0...                      x86_64...                     x86,ar...                          x86_64                              28                        zygote...          1            /data/...                            1                     1                            1                  1                     0                  16875                           60                                          mtp              0             true                      50                              1                  0              0                 1            
8    60743  702249...  440102...  895505...        lz4                      64m                  512m                  true                            true                       256m                        8m                  512k                  384m                16m                    0.75                             64m                         64m                     default                    generic                   default                      generic                     default                     x86_64                   default                        x86_64                          500                    /data/anr                      true             true                        0                             0               1                1                    LTE         Claro BR                 br                    false                  72405             Claro BR                     br                        72405                    READY       1.0.0.0            Qualco...                 true                running       stopped                running              stopped            stopped           running                running               running      running              running          running              running                   running            running           running           running       running       stopped              running        running        running           running                 running               stopped          running       stopped                  running             running                 running           running                 running                 running             running          stopped       running                       running                             running                     running                         running                       running                      running                       running                   running                          running                       running                    running       running           running         running                      true                       I              true               libffm...                         1        libffm...             Android   1.1.1.1  100.12...          0                  60                 6afd:9...                          1              shutdo...                   false             libart.so                           0               pt-BR                  1                              0                     Americ...             none,adb              235258696                  speed-...        speed-...             extract        extract               verify          speed-...             false                     ALL                        speed             true                                      true                          1                 x86          1                  unknown           1              msm8998              qcom        bd68fe...            green                 Fri Fe...               167600...                   OnePlu...                        unknown       unknown        1798               19                               3                                 94                 nosdcard                Wed Ma...     158511...         OnePlu...            OnePlu...           OnePlu...            OnePlu...          Build2     PPR1.1...    OnePlus5        releas...          user         build           REL                                                     REL                   6736742                           17                                         0                            9                       28            2019-0...                         unknown       true                       true                  1                      Alarm_...             OnTheH...                    unsupp...             x86               x86_64               libnb.so                          1         false            qcom         64K             196608                true                        msm8998          OnePlus           x86_64          x86_64...              x86,ar...                x86_64...                 OnePlus5             en-US           OnePlus               ONEPLU...         OnePlus5         OnePlus                OnePlus5                  OnePlus                      ONEPLU...                OnePlus5                      2                           0          10                1    167850...                   0  bd68fe...         240             false         Fri Fe...            167600...                OnePlu...                   2019-0...                      x86_64...                     x86,ar...                          x86_64                              28                        zygote...          1            /data/...                            1                     1                            1                  1                     0                  16875                           60                                          mtp              0             true                      50                              1                  0              0                 1            


"""

namerunningbst, cmdlinerunningbst = bstackpatcher.get_all_running_bluestacks_instances()
print(cmdlinerunningbst)
print(namerunningbst)
"""
['start "" "C:\\Program Files\\BlueStacks_nxt\\HD-Player.exe" --instance Pie64_5', 'start "" "C:\\Program Files\\BlueStacks_nxt\\HD-Player.exe" --instance Pie64_6', 'start "" "C:\\Program Files\\BlueStacks_nxt\\HD-Player.exe" --instance Pie64_8', 'start "" "C:\\Program Files\\BlueStacks_nxt\\HD-Player.exe" --instance Pie64_3', 'start "" "C:\\Program Files\\BlueStacks_nxt\\HD-Player.exe" --instance Pie64_4', 'start "" "C:\\Program Files\\BlueStacks_nxt\\HD-Player.exe" --instance Pie64_2', 'start "" "C:\\Program Files\\BlueStacks_nxt\\HD-Player.exe" --instance Pie64_7']
['Pie64_5', 'Pie64_6', 'Pie64_8', 'Pie64_3', 'Pie64_4', 'Pie64_2', 'Pie64_7']
"""
#
namekilled, cmdlinekilled = bstackpatcher.kill_running_bluestacks_instances(
    ignore=("Pie64_9", "Pie64_3", "Pie64_1", "Pie64_6", "Pie64_10")
)
r"""
namekilled
Out[5]: ['Pie64_5', 'Pie64_8', 'Pie64_4', 'Pie64_2', 'Pie64_7']
cmdlinekilled
Out[6]: 
['start "" "C:\\Program Files\\BlueStacks_nxt\\HD-Player.exe" --instance Pie64_5',
 'start "" "C:\\Program Files\\BlueStacks_nxt\\HD-Player.exe" --instance Pie64_8',
 'start "" "C:\\Program Files\\BlueStacks_nxt\\HD-Player.exe" --instance Pie64_4',
 'start "" "C:\\Program Files\\BlueStacks_nxt\\HD-Player.exe" --instance Pie64_2',
 'start "" "C:\\Program Files\\BlueStacks_nxt\\HD-Player.exe" --instance Pie64_7']

"""

dfstarted = bstackpatcher.start_bluestacks_instances(
    instances=("Pie64_8", "Pie64_4"),
    min_threads_open=85,
    timeoutsearch=3,
    sleeptime=0.1,
    timeoutstart=25,
)

dfnewinst = bstackpatcher.start_all_offline_instances(
    min_threads_open=85,
    timeoutsearch=5,
    sleeptime=0.1,
    timeoutstart=25,
)
print(dfnewinst)

offins = bstackpatcher.get_all_offline_instances()
nameinstalled, cmdinstalled = bstackpatcher.get_all_installed_bluestacks_instances()

devi = bstackpatcher.get_device_information()

```
