# Generated by Django 3.0.10 on 2020-10-19 18:01

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('invoices', '0001_initial'),
        ('customers', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='ServiceCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Category name')),
            ],
            options={
                'verbose_name': 'Service category',
                'verbose_name_plural': 'Service categories',
            },
        ),
        migrations.CreateModel(
            name='ServiceItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, db_index=True, max_length=255, verbose_name='Service name')),
                ('code', models.CharField(blank=True, db_index=True, max_length=255, verbose_name='Code')),
                ('price', models.FloatField(verbose_name='Price')),
                ('category', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='items', to='services.ServiceCategory', verbose_name='Category')),
            ],
            options={
                'verbose_name': 'Service item',
                'verbose_name_plural': 'Service items',
                'ordering': ('code',),
            },
        ),
        migrations.CreateModel(
            name='Service',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('qty', models.IntegerField(default=1, verbose_name='Quantity')),
                ('price', models.FloatField(verbose_name='Price')),
                ('customer', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='services', to='customers.Customer', verbose_name='Customer')),
                ('item', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='services.ServiceItem', verbose_name='Service item')),
                ('sale', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='services', to='invoices.Sale', verbose_name='Sale')),
            ],
            options={
                'verbose_name': 'Service',
                'verbose_name_plural': 'Service',
            },
        ),
    ]
