# coding: utf-8

"""
    AYLIEN News API

    The AYLIEN News API is the most powerful way of sourcing, searching and syndicating analyzed and enriched news content. It is accessed by sending HTTP requests to our server, which returns information to your client.   # noqa: E501

    The version of the OpenAPI document: 3.0
    Contact: support@aylien.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from aylien_news_api.configuration import Configuration


class Entity(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'indices': 'list[list[int]]',
        'links': 'EntityLinks',
        'score': 'float',
        'text': 'str',
        'types': 'list[str]'
    }

    attribute_map = {
        'indices': 'indices',
        'links': 'links',
        'score': 'score',
        'text': 'text',
        'types': 'types'
    }

    def __init__(self, indices=None, links=None, score=None, text=None, types=None, local_vars_configuration=None):  # noqa: E501
        """Entity - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._indices = None
        self._links = None
        self._score = None
        self._text = None
        self._types = None
        self.discriminator = None

        if indices is not None:
            self.indices = indices
        if links is not None:
            self.links = links
        if score is not None:
            self.score = score
        if text is not None:
            self.text = text
        if types is not None:
            self.types = types

    @property
    def indices(self):
        """Gets the indices of this Entity.  # noqa: E501

        The indices of the entity text  # noqa: E501

        :return: The indices of this Entity.  # noqa: E501
        :rtype: list[list[int]]
        """
        return self._indices

    @indices.setter
    def indices(self, indices):
        """Sets the indices of this Entity.

        The indices of the entity text  # noqa: E501

        :param indices: The indices of this Entity.  # noqa: E501
        :type indices: list[list[int]]
        """

        self._indices = indices

    @property
    def links(self):
        """Gets the links of this Entity.  # noqa: E501


        :return: The links of this Entity.  # noqa: E501
        :rtype: EntityLinks
        """
        return self._links

    @links.setter
    def links(self, links):
        """Sets the links of this Entity.


        :param links: The links of this Entity.  # noqa: E501
        :type links: EntityLinks
        """

        self._links = links

    @property
    def score(self):
        """Gets the score of this Entity.  # noqa: E501

        The entity score  # noqa: E501

        :return: The score of this Entity.  # noqa: E501
        :rtype: float
        """
        return self._score

    @score.setter
    def score(self, score):
        """Sets the score of this Entity.

        The entity score  # noqa: E501

        :param score: The score of this Entity.  # noqa: E501
        :type score: float
        """
        if (self.local_vars_configuration.client_side_validation and
                score is not None and score > 1):  # noqa: E501
            raise ValueError("Invalid value for `score`, must be a value less than or equal to `1`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                score is not None and score < 0):  # noqa: E501
            raise ValueError("Invalid value for `score`, must be a value greater than or equal to `0`")  # noqa: E501

        self._score = score

    @property
    def text(self):
        """Gets the text of this Entity.  # noqa: E501

        The entity text  # noqa: E501

        :return: The text of this Entity.  # noqa: E501
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """Sets the text of this Entity.

        The entity text  # noqa: E501

        :param text: The text of this Entity.  # noqa: E501
        :type text: str
        """

        self._text = text

    @property
    def types(self):
        """Gets the types of this Entity.  # noqa: E501

        An array of the dbpedia types  # noqa: E501

        :return: The types of this Entity.  # noqa: E501
        :rtype: list[str]
        """
        return self._types

    @types.setter
    def types(self, types):
        """Sets the types of this Entity.

        An array of the dbpedia types  # noqa: E501

        :param types: The types of this Entity.  # noqa: E501
        :type types: list[str]
        """

        self._types = types

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Entity):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Entity):
            return True

        return self.to_dict() != other.to_dict()
