# Generated by Django 3.0.10 on 2020-10-09 07:43
import django.db.models.deletion
import swapper
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        swapper.dependency("pychance_sections", "Section"),
        swapper.dependency("pychance_sections", "Content"),
        swapper.dependency("pychance_sections", "SectionContent"),
    ]

    operations = [
        migrations.CreateModel(
            name="Content",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(blank=True, max_length=255, verbose_name="name")),
                ("redirect_url", models.URLField(blank=True, null=True, verbose_name="redirect url")),
                ("content_url", models.URLField(blank=True, null=True, verbose_name="content url")),
            ],
            options={
                "swappable": swapper.swappable_setting("pychance_sections", "Content"),
            },
        ),
        migrations.CreateModel(
            name="Section",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(blank=True, max_length=255)),
                (
                    "location",
                    models.PositiveSmallIntegerField(
                        blank=True, choices=[(1, "top")], null=True, verbose_name="location"
                    ),
                ),
                (
                    "type",
                    models.PositiveSmallIntegerField(
                        blank=True, choices=[(1, "banner"), (2, "slider")], null=True, verbose_name="type"
                    ),
                ),
            ],
            options={
                "swappable": swapper.swappable_setting("pychance_sections", "Section"),
            },
        ),
        migrations.CreateModel(
            name="SectionContent",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("order", models.PositiveSmallIntegerField(default=0, verbose_name="order")),
                (
                    "content",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="content_list",
                        to=swapper.get_model_name("pychance_sections", "Content"),
                    ),
                ),
                (
                    "section",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="content_list",
                        to=swapper.get_model_name("pychance_sections", "Section"),
                    ),
                ),
            ],
            options={
                "swappable": swapper.swappable_setting("pychance_sections", "SectionContent"),
            },
        ),
    ]
