# coding: utf-8

"""
    data.world API

    # data.world in a nutshell  data.world is a productive, secure platform for modern data teamwork.  We bring together your data practitioners, subject matter experts, and other stakeholders by removing costly barriers to data discovery, comprehension, integration, and sharing.   Everything your team needs to quickly understand and use data stays with it.   Social features and integrations encourage collaborators to ask and answer questions, share discoveries, and coordinate closely while still using their preferred tools.  Our focus on interoperability helps you enhance your own data with data from any source, including our vast and growing library of free public datasets.   Sophisticated permissions, auditing features, and more make it easy to manage who views your data and what they do with it.  # Conventions  ## Authentication  All data.world API calls require an API token.   OAuth2 is the preferred and most secure method for authenticating users of your data.world applications. Visit our [oauth documentation](https://apidocs.data.world/toolkit/oauth) for additional information. Alternatively, you can obtain a token for _personal use or testing_ by navigating to your profile settings, under the Advanced tab ([https://data.world/settings/advanced](https://data.world/settings/advanced)).  Authentication must be provided in API requests via the `Authorization` header. For example, for a user whose API token is `my_api_token`, the request header should be `Authorization: Bearer my_api_token` (note the `Bearer` prefix).  ## Content type   By default, `application/json` is the content type used in request and response bodies. Exceptions are noted in respective endpoint documentation.  ## HTTPS only   Our APIs can only be accessed via HTTPS.  # Interested in building data.world apps?  Check out our [developer portal](https://apidocs.data.world) for tips on how to get started, tutorials, and to interact with the API endpoints right within your browser.

    OpenAPI spec version: 0.21.0
    Contact: help@data.world
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class SearchHydrations(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'agents': 'dict(str, AgentHydrationDto)',
        'catalog_concepts': 'dict(str, CatalogConceptHydrationDto)',
        'catalogs': 'dict(str, CatalogHydrationDto)',
        'catalog_analysis': 'dict(str, CatalogAnalysisHydrationDto)',
        'catalog_business_terms': 'dict(str, CatalogBusinessTermHydrationDto)',
        'catalog_tables': 'dict(str, CatalogTableHydrationDto)',
        'catalog_columns': 'dict(str, CatalogColumnHydrationDto)',
        'datasets': 'dict(str, DatasetHydrationDto)',
        'insights': 'dict(str, InsightHydrationDto)'
    }

    attribute_map = {
        'agents': 'agents',
        'catalog_concepts': 'catalogConcepts',
        'catalogs': 'catalogs',
        'catalog_analysis': 'catalogAnalysis',
        'catalog_business_terms': 'catalogBusinessTerms',
        'catalog_tables': 'catalogTables',
        'catalog_columns': 'catalogColumns',
        'datasets': 'datasets',
        'insights': 'insights'
    }

    def __init__(self, agents=None, catalog_concepts=None, catalogs=None, catalog_analysis=None, catalog_business_terms=None, catalog_tables=None, catalog_columns=None, datasets=None, insights=None):
        """
        SearchHydrations - a model defined in Swagger
        """

        self._agents = None
        self._catalog_concepts = None
        self._catalogs = None
        self._catalog_analysis = None
        self._catalog_business_terms = None
        self._catalog_tables = None
        self._catalog_columns = None
        self._datasets = None
        self._insights = None

        if agents is not None:
          self.agents = agents
        if catalog_concepts is not None:
          self.catalog_concepts = catalog_concepts
        if catalogs is not None:
          self.catalogs = catalogs
        if catalog_analysis is not None:
          self.catalog_analysis = catalog_analysis
        if catalog_business_terms is not None:
          self.catalog_business_terms = catalog_business_terms
        if catalog_tables is not None:
          self.catalog_tables = catalog_tables
        if catalog_columns is not None:
          self.catalog_columns = catalog_columns
        if datasets is not None:
          self.datasets = datasets
        if insights is not None:
          self.insights = insights

    @property
    def agents(self):
        """
        Gets the agents of this SearchHydrations.

        :return: The agents of this SearchHydrations.
        :rtype: dict(str, AgentHydrationDto)
        """
        return self._agents

    @agents.setter
    def agents(self, agents):
        """
        Sets the agents of this SearchHydrations.

        :param agents: The agents of this SearchHydrations.
        :type: dict(str, AgentHydrationDto)
        """

        self._agents = agents

    @property
    def catalog_concepts(self):
        """
        Gets the catalog_concepts of this SearchHydrations.

        :return: The catalog_concepts of this SearchHydrations.
        :rtype: dict(str, CatalogConceptHydrationDto)
        """
        return self._catalog_concepts

    @catalog_concepts.setter
    def catalog_concepts(self, catalog_concepts):
        """
        Sets the catalog_concepts of this SearchHydrations.

        :param catalog_concepts: The catalog_concepts of this SearchHydrations.
        :type: dict(str, CatalogConceptHydrationDto)
        """

        self._catalog_concepts = catalog_concepts

    @property
    def catalogs(self):
        """
        Gets the catalogs of this SearchHydrations.

        :return: The catalogs of this SearchHydrations.
        :rtype: dict(str, CatalogHydrationDto)
        """
        return self._catalogs

    @catalogs.setter
    def catalogs(self, catalogs):
        """
        Sets the catalogs of this SearchHydrations.

        :param catalogs: The catalogs of this SearchHydrations.
        :type: dict(str, CatalogHydrationDto)
        """

        self._catalogs = catalogs

    @property
    def catalog_analysis(self):
        """
        Gets the catalog_analysis of this SearchHydrations.

        :return: The catalog_analysis of this SearchHydrations.
        :rtype: dict(str, CatalogAnalysisHydrationDto)
        """
        return self._catalog_analysis

    @catalog_analysis.setter
    def catalog_analysis(self, catalog_analysis):
        """
        Sets the catalog_analysis of this SearchHydrations.

        :param catalog_analysis: The catalog_analysis of this SearchHydrations.
        :type: dict(str, CatalogAnalysisHydrationDto)
        """

        self._catalog_analysis = catalog_analysis

    @property
    def catalog_business_terms(self):
        """
        Gets the catalog_business_terms of this SearchHydrations.

        :return: The catalog_business_terms of this SearchHydrations.
        :rtype: dict(str, CatalogBusinessTermHydrationDto)
        """
        return self._catalog_business_terms

    @catalog_business_terms.setter
    def catalog_business_terms(self, catalog_business_terms):
        """
        Sets the catalog_business_terms of this SearchHydrations.

        :param catalog_business_terms: The catalog_business_terms of this SearchHydrations.
        :type: dict(str, CatalogBusinessTermHydrationDto)
        """

        self._catalog_business_terms = catalog_business_terms

    @property
    def catalog_tables(self):
        """
        Gets the catalog_tables of this SearchHydrations.

        :return: The catalog_tables of this SearchHydrations.
        :rtype: dict(str, CatalogTableHydrationDto)
        """
        return self._catalog_tables

    @catalog_tables.setter
    def catalog_tables(self, catalog_tables):
        """
        Sets the catalog_tables of this SearchHydrations.

        :param catalog_tables: The catalog_tables of this SearchHydrations.
        :type: dict(str, CatalogTableHydrationDto)
        """

        self._catalog_tables = catalog_tables

    @property
    def catalog_columns(self):
        """
        Gets the catalog_columns of this SearchHydrations.

        :return: The catalog_columns of this SearchHydrations.
        :rtype: dict(str, CatalogColumnHydrationDto)
        """
        return self._catalog_columns

    @catalog_columns.setter
    def catalog_columns(self, catalog_columns):
        """
        Sets the catalog_columns of this SearchHydrations.

        :param catalog_columns: The catalog_columns of this SearchHydrations.
        :type: dict(str, CatalogColumnHydrationDto)
        """

        self._catalog_columns = catalog_columns

    @property
    def datasets(self):
        """
        Gets the datasets of this SearchHydrations.

        :return: The datasets of this SearchHydrations.
        :rtype: dict(str, DatasetHydrationDto)
        """
        return self._datasets

    @datasets.setter
    def datasets(self, datasets):
        """
        Sets the datasets of this SearchHydrations.

        :param datasets: The datasets of this SearchHydrations.
        :type: dict(str, DatasetHydrationDto)
        """

        self._datasets = datasets

    @property
    def insights(self):
        """
        Gets the insights of this SearchHydrations.

        :return: The insights of this SearchHydrations.
        :rtype: dict(str, InsightHydrationDto)
        """
        return self._insights

    @insights.setter
    def insights(self, insights):
        """
        Sets the insights of this SearchHydrations.

        :param insights: The insights of this SearchHydrations.
        :type: dict(str, InsightHydrationDto)
        """

        self._insights = insights

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, SearchHydrations):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
