# coding: utf-8

"""
    data.world API

    # data.world in a nutshell  data.world is a productive, secure platform for modern data teamwork.  We bring together your data practitioners, subject matter experts, and other stakeholders by removing costly barriers to data discovery, comprehension, integration, and sharing.   Everything your team needs to quickly understand and use data stays with it.   Social features and integrations encourage collaborators to ask and answer questions, share discoveries, and coordinate closely while still using their preferred tools.  Our focus on interoperability helps you enhance your own data with data from any source, including our vast and growing library of free public datasets.   Sophisticated permissions, auditing features, and more make it easy to manage who views your data and what they do with it.  # Conventions  ## Authentication  All data.world API calls require an API token.   OAuth2 is the preferred and most secure method for authenticating users of your data.world applications. Visit our [oauth documentation](https://apidocs.data.world/toolkit/oauth) for additional information. Alternatively, you can obtain a token for _personal use or testing_ by navigating to your profile settings, under the Advanced tab ([https://data.world/settings/advanced](https://data.world/settings/advanced)).  Authentication must be provided in API requests via the `Authorization` header. For example, for a user whose API token is `my_api_token`, the request header should be `Authorization: Bearer my_api_token` (note the `Bearer` prefix).  ## Content type   By default, `application/json` is the content type used in request and response bodies. Exceptions are noted in respective endpoint documentation.  ## HTTPS only   Our APIs can only be accessed via HTTPS.  # Interested in building data.world apps?  Check out our [developer portal](https://apidocs.data.world) for tips on how to get started, tutorials, and to interact with the API endpoints right within your browser.

    OpenAPI spec version: 0.21.0
    Contact: help@data.world
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ProjectSummaryResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'access_level': 'str',
        'created': 'str',
        'files': 'list[FileSummaryResponse]',
        'id': 'str',
        'license': 'str',
        'linked_datasets': 'list[LinkedDatasetSummaryResponse]',
        'objective': 'str',
        'owner': 'str',
        'status': 'str',
        'summary': 'str',
        'tags': 'list[str]',
        'title': 'str',
        'updated': 'str',
        'version': 'str',
        'visibility': 'str'
    }

    attribute_map = {
        'access_level': 'accessLevel',
        'created': 'created',
        'files': 'files',
        'id': 'id',
        'license': 'license',
        'linked_datasets': 'linkedDatasets',
        'objective': 'objective',
        'owner': 'owner',
        'status': 'status',
        'summary': 'summary',
        'tags': 'tags',
        'title': 'title',
        'updated': 'updated',
        'version': 'version',
        'visibility': 'visibility'
    }

    def __init__(self, access_level=None, created=None, files=None, id=None, license=None, linked_datasets=None, objective=None, owner=None, status=None, summary=None, tags=None, title=None, updated=None, version=None, visibility=None):
        """
        ProjectSummaryResponse - a model defined in Swagger
        """

        self._access_level = None
        self._created = None
        self._files = None
        self._id = None
        self._license = None
        self._linked_datasets = None
        self._objective = None
        self._owner = None
        self._status = None
        self._summary = None
        self._tags = None
        self._title = None
        self._updated = None
        self._version = None
        self._visibility = None

        self.access_level = access_level
        self.created = created
        if files is not None:
          self.files = files
        self.id = id
        if license is not None:
          self.license = license
        if linked_datasets is not None:
          self.linked_datasets = linked_datasets
        if objective is not None:
          self.objective = objective
        self.owner = owner
        self.status = status
        if summary is not None:
          self.summary = summary
        if tags is not None:
          self.tags = tags
        self.title = title
        self.updated = updated
        self.version = version
        self.visibility = visibility

    @property
    def access_level(self):
        """
        Gets the access_level of this ProjectSummaryResponse.

        :return: The access_level of this ProjectSummaryResponse.
        :rtype: str
        """
        return self._access_level

    @access_level.setter
    def access_level(self, access_level):
        """
        Sets the access_level of this ProjectSummaryResponse.

        :param access_level: The access_level of this ProjectSummaryResponse.
        :type: str
        """
        if access_level is None:
            raise ValueError("Invalid value for `access_level`, must not be `None`")

        self._access_level = access_level

    @property
    def created(self):
        """
        Gets the created of this ProjectSummaryResponse.

        :return: The created of this ProjectSummaryResponse.
        :rtype: str
        """
        return self._created

    @created.setter
    def created(self, created):
        """
        Sets the created of this ProjectSummaryResponse.

        :param created: The created of this ProjectSummaryResponse.
        :type: str
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")

        self._created = created

    @property
    def files(self):
        """
        Gets the files of this ProjectSummaryResponse.

        :return: The files of this ProjectSummaryResponse.
        :rtype: list[FileSummaryResponse]
        """
        return self._files

    @files.setter
    def files(self, files):
        """
        Sets the files of this ProjectSummaryResponse.

        :param files: The files of this ProjectSummaryResponse.
        :type: list[FileSummaryResponse]
        """

        self._files = files

    @property
    def id(self):
        """
        Gets the id of this ProjectSummaryResponse.

        :return: The id of this ProjectSummaryResponse.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ProjectSummaryResponse.

        :param id: The id of this ProjectSummaryResponse.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")

        self._id = id

    @property
    def license(self):
        """
        Gets the license of this ProjectSummaryResponse.

        :return: The license of this ProjectSummaryResponse.
        :rtype: str
        """
        return self._license

    @license.setter
    def license(self, license):
        """
        Sets the license of this ProjectSummaryResponse.

        :param license: The license of this ProjectSummaryResponse.
        :type: str
        """

        self._license = license

    @property
    def linked_datasets(self):
        """
        Gets the linked_datasets of this ProjectSummaryResponse.

        :return: The linked_datasets of this ProjectSummaryResponse.
        :rtype: list[LinkedDatasetSummaryResponse]
        """
        return self._linked_datasets

    @linked_datasets.setter
    def linked_datasets(self, linked_datasets):
        """
        Sets the linked_datasets of this ProjectSummaryResponse.

        :param linked_datasets: The linked_datasets of this ProjectSummaryResponse.
        :type: list[LinkedDatasetSummaryResponse]
        """

        self._linked_datasets = linked_datasets

    @property
    def objective(self):
        """
        Gets the objective of this ProjectSummaryResponse.

        :return: The objective of this ProjectSummaryResponse.
        :rtype: str
        """
        return self._objective

    @objective.setter
    def objective(self, objective):
        """
        Sets the objective of this ProjectSummaryResponse.

        :param objective: The objective of this ProjectSummaryResponse.
        :type: str
        """

        self._objective = objective

    @property
    def owner(self):
        """
        Gets the owner of this ProjectSummaryResponse.

        :return: The owner of this ProjectSummaryResponse.
        :rtype: str
        """
        return self._owner

    @owner.setter
    def owner(self, owner):
        """
        Sets the owner of this ProjectSummaryResponse.

        :param owner: The owner of this ProjectSummaryResponse.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")

        self._owner = owner

    @property
    def status(self):
        """
        Gets the status of this ProjectSummaryResponse.
        Processing status of project. This status can be checked periodically after changes are made to the project to determine the status of asynchronous processing.  * `NEW`: Just created. Not yet processed. * `INPROGRESS`: Currently being processed. * `LOADED`: Successfully processed. * `SYSTEMERROR`: Error state due to processing failure.

        :return: The status of this ProjectSummaryResponse.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this ProjectSummaryResponse.
        Processing status of project. This status can be checked periodically after changes are made to the project to determine the status of asynchronous processing.  * `NEW`: Just created. Not yet processed. * `INPROGRESS`: Currently being processed. * `LOADED`: Successfully processed. * `SYSTEMERROR`: Error state due to processing failure.

        :param status: The status of this ProjectSummaryResponse.
        :type: str
        """
        if status is None:
            raise ValueError("Invalid value for `status`, must not be `None`")

        self._status = status

    @property
    def summary(self):
        """
        Gets the summary of this ProjectSummaryResponse.

        :return: The summary of this ProjectSummaryResponse.
        :rtype: str
        """
        return self._summary

    @summary.setter
    def summary(self, summary):
        """
        Sets the summary of this ProjectSummaryResponse.

        :param summary: The summary of this ProjectSummaryResponse.
        :type: str
        """

        self._summary = summary

    @property
    def tags(self):
        """
        Gets the tags of this ProjectSummaryResponse.

        :return: The tags of this ProjectSummaryResponse.
        :rtype: list[str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this ProjectSummaryResponse.

        :param tags: The tags of this ProjectSummaryResponse.
        :type: list[str]
        """

        self._tags = tags

    @property
    def title(self):
        """
        Gets the title of this ProjectSummaryResponse.

        :return: The title of this ProjectSummaryResponse.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this ProjectSummaryResponse.

        :param title: The title of this ProjectSummaryResponse.
        :type: str
        """
        if title is None:
            raise ValueError("Invalid value for `title`, must not be `None`")

        self._title = title

    @property
    def updated(self):
        """
        Gets the updated of this ProjectSummaryResponse.

        :return: The updated of this ProjectSummaryResponse.
        :rtype: str
        """
        return self._updated

    @updated.setter
    def updated(self, updated):
        """
        Sets the updated of this ProjectSummaryResponse.

        :param updated: The updated of this ProjectSummaryResponse.
        :type: str
        """
        if updated is None:
            raise ValueError("Invalid value for `updated`, must not be `None`")

        self._updated = updated

    @property
    def version(self):
        """
        Gets the version of this ProjectSummaryResponse.
        Project version

        :return: The version of this ProjectSummaryResponse.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this ProjectSummaryResponse.
        Project version

        :param version: The version of this ProjectSummaryResponse.
        :type: str
        """
        if version is None:
            raise ValueError("Invalid value for `version`, must not be `None`")

        self._version = version

    @property
    def visibility(self):
        """
        Gets the visibility of this ProjectSummaryResponse.

        :return: The visibility of this ProjectSummaryResponse.
        :rtype: str
        """
        return self._visibility

    @visibility.setter
    def visibility(self, visibility):
        """
        Sets the visibility of this ProjectSummaryResponse.

        :param visibility: The visibility of this ProjectSummaryResponse.
        :type: str
        """
        if visibility is None:
            raise ValueError("Invalid value for `visibility`, must not be `None`")

        self._visibility = visibility

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ProjectSummaryResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
