# coding: utf-8

"""
    data.world API

    # data.world in a nutshell  data.world is a productive, secure platform for modern data teamwork.  We bring together your data practitioners, subject matter experts, and other stakeholders by removing costly barriers to data discovery, comprehension, integration, and sharing.   Everything your team needs to quickly understand and use data stays with it.   Social features and integrations encourage collaborators to ask and answer questions, share discoveries, and coordinate closely while still using their preferred tools.  Our focus on interoperability helps you enhance your own data with data from any source, including our vast and growing library of free public datasets.   Sophisticated permissions, auditing features, and more make it easy to manage who views your data and what they do with it.  # Conventions  ## Authentication  All data.world API calls require an API token.   OAuth2 is the preferred and most secure method for authenticating users of your data.world applications. Visit our [oauth documentation](https://apidocs.data.world/toolkit/oauth) for additional information. Alternatively, you can obtain a token for _personal use or testing_ by navigating to your profile settings, under the Advanced tab ([https://data.world/settings/advanced](https://data.world/settings/advanced)).  Authentication must be provided in API requests via the `Authorization` header. For example, for a user whose API token is `my_api_token`, the request header should be `Authorization: Bearer my_api_token` (note the `Bearer` prefix).  ## Content type   By default, `application/json` is the content type used in request and response bodies. Exceptions are noted in respective endpoint documentation.  ## HTTPS only   Our APIs can only be accessed via HTTPS.  # Interested in building data.world apps?  Check out our [developer portal](https://apidocs.data.world) for tips on how to get started, tutorials, and to interact with the API endpoints right within your browser.

    OpenAPI spec version: 0.21.0
    Contact: help@data.world
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class FileSourceSummaryResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'authorization': 'WebAuthorization',
        'credentials': 'WebCredentials',
        'expand_archive': 'bool',
        'last_sync_failure': 'str',
        'last_sync_start': 'str',
        'last_sync_success': 'str',
        'method': 'str',
        'oauth_token': 'OauthTokenReference',
        'request_entity': 'str',
        'request_headers': 'dict(str, str)',
        'sync_status': 'str',
        'sync_summary': 'str',
        'url': 'str'
    }

    attribute_map = {
        'authorization': 'authorization',
        'credentials': 'credentials',
        'expand_archive': 'expandArchive',
        'last_sync_failure': 'lastSyncFailure',
        'last_sync_start': 'lastSyncStart',
        'last_sync_success': 'lastSyncSuccess',
        'method': 'method',
        'oauth_token': 'oauthToken',
        'request_entity': 'requestEntity',
        'request_headers': 'requestHeaders',
        'sync_status': 'syncStatus',
        'sync_summary': 'syncSummary',
        'url': 'url'
    }

    def __init__(self, authorization=None, credentials=None, expand_archive=False, last_sync_failure=None, last_sync_start=None, last_sync_success=None, method=None, oauth_token=None, request_entity=None, request_headers=None, sync_status=None, sync_summary=None, url=None):
        """
        FileSourceSummaryResponse - a model defined in Swagger
        """

        self._authorization = None
        self._credentials = None
        self._expand_archive = None
        self._last_sync_failure = None
        self._last_sync_start = None
        self._last_sync_success = None
        self._method = None
        self._oauth_token = None
        self._request_entity = None
        self._request_headers = None
        self._sync_status = None
        self._sync_summary = None
        self._url = None

        if authorization is not None:
          self.authorization = authorization
        if credentials is not None:
          self.credentials = credentials
        if expand_archive is not None:
          self.expand_archive = expand_archive
        if last_sync_failure is not None:
          self.last_sync_failure = last_sync_failure
        if last_sync_start is not None:
          self.last_sync_start = last_sync_start
        if last_sync_success is not None:
          self.last_sync_success = last_sync_success
        if method is not None:
          self.method = method
        if oauth_token is not None:
          self.oauth_token = oauth_token
        if request_entity is not None:
          self.request_entity = request_entity
        if request_headers is not None:
          self.request_headers = request_headers
        self.sync_status = sync_status
        if sync_summary is not None:
          self.sync_summary = sync_summary
        if url is not None:
          self.url = url

    @property
    def authorization(self):
        """
        Gets the authorization of this FileSourceSummaryResponse.

        :return: The authorization of this FileSourceSummaryResponse.
        :rtype: WebAuthorization
        """
        return self._authorization

    @authorization.setter
    def authorization(self, authorization):
        """
        Sets the authorization of this FileSourceSummaryResponse.

        :param authorization: The authorization of this FileSourceSummaryResponse.
        :type: WebAuthorization
        """

        self._authorization = authorization

    @property
    def credentials(self):
        """
        Gets the credentials of this FileSourceSummaryResponse.

        :return: The credentials of this FileSourceSummaryResponse.
        :rtype: WebCredentials
        """
        return self._credentials

    @credentials.setter
    def credentials(self, credentials):
        """
        Sets the credentials of this FileSourceSummaryResponse.

        :param credentials: The credentials of this FileSourceSummaryResponse.
        :type: WebCredentials
        """

        self._credentials = credentials

    @property
    def expand_archive(self):
        """
        Gets the expand_archive of this FileSourceSummaryResponse.

        :return: The expand_archive of this FileSourceSummaryResponse.
        :rtype: bool
        """
        return self._expand_archive

    @expand_archive.setter
    def expand_archive(self, expand_archive):
        """
        Sets the expand_archive of this FileSourceSummaryResponse.

        :param expand_archive: The expand_archive of this FileSourceSummaryResponse.
        :type: bool
        """

        self._expand_archive = expand_archive

    @property
    def last_sync_failure(self):
        """
        Gets the last_sync_failure of this FileSourceSummaryResponse.
        Date and time when synchronization last failed.

        :return: The last_sync_failure of this FileSourceSummaryResponse.
        :rtype: str
        """
        return self._last_sync_failure

    @last_sync_failure.setter
    def last_sync_failure(self, last_sync_failure):
        """
        Sets the last_sync_failure of this FileSourceSummaryResponse.
        Date and time when synchronization last failed.

        :param last_sync_failure: The last_sync_failure of this FileSourceSummaryResponse.
        :type: str
        """

        self._last_sync_failure = last_sync_failure

    @property
    def last_sync_start(self):
        """
        Gets the last_sync_start of this FileSourceSummaryResponse.
        Date and time when synchronization last started.

        :return: The last_sync_start of this FileSourceSummaryResponse.
        :rtype: str
        """
        return self._last_sync_start

    @last_sync_start.setter
    def last_sync_start(self, last_sync_start):
        """
        Sets the last_sync_start of this FileSourceSummaryResponse.
        Date and time when synchronization last started.

        :param last_sync_start: The last_sync_start of this FileSourceSummaryResponse.
        :type: str
        """

        self._last_sync_start = last_sync_start

    @property
    def last_sync_success(self):
        """
        Gets the last_sync_success of this FileSourceSummaryResponse.
        Date and time when synchronization last finished successfully.

        :return: The last_sync_success of this FileSourceSummaryResponse.
        :rtype: str
        """
        return self._last_sync_success

    @last_sync_success.setter
    def last_sync_success(self, last_sync_success):
        """
        Sets the last_sync_success of this FileSourceSummaryResponse.
        Date and time when synchronization last finished successfully.

        :param last_sync_success: The last_sync_success of this FileSourceSummaryResponse.
        :type: str
        """

        self._last_sync_success = last_sync_success

    @property
    def method(self):
        """
        Gets the method of this FileSourceSummaryResponse.

        :return: The method of this FileSourceSummaryResponse.
        :rtype: str
        """
        return self._method

    @method.setter
    def method(self, method):
        """
        Sets the method of this FileSourceSummaryResponse.

        :param method: The method of this FileSourceSummaryResponse.
        :type: str
        """

        self._method = method

    @property
    def oauth_token(self):
        """
        Gets the oauth_token of this FileSourceSummaryResponse.

        :return: The oauth_token of this FileSourceSummaryResponse.
        :rtype: OauthTokenReference
        """
        return self._oauth_token

    @oauth_token.setter
    def oauth_token(self, oauth_token):
        """
        Sets the oauth_token of this FileSourceSummaryResponse.

        :param oauth_token: The oauth_token of this FileSourceSummaryResponse.
        :type: OauthTokenReference
        """

        self._oauth_token = oauth_token

    @property
    def request_entity(self):
        """
        Gets the request_entity of this FileSourceSummaryResponse.

        :return: The request_entity of this FileSourceSummaryResponse.
        :rtype: str
        """
        return self._request_entity

    @request_entity.setter
    def request_entity(self, request_entity):
        """
        Sets the request_entity of this FileSourceSummaryResponse.

        :param request_entity: The request_entity of this FileSourceSummaryResponse.
        :type: str
        """

        self._request_entity = request_entity

    @property
    def request_headers(self):
        """
        Gets the request_headers of this FileSourceSummaryResponse.
        A map of custom HTTP header name/value pairs to pass with the request.  If a `requestEntity` string is specified, this must contain a `Content-Type` header.

        :return: The request_headers of this FileSourceSummaryResponse.
        :rtype: dict(str, str)
        """
        return self._request_headers

    @request_headers.setter
    def request_headers(self, request_headers):
        """
        Sets the request_headers of this FileSourceSummaryResponse.
        A map of custom HTTP header name/value pairs to pass with the request.  If a `requestEntity` string is specified, this must contain a `Content-Type` header.

        :param request_headers: The request_headers of this FileSourceSummaryResponse.
        :type: dict(str, str)
        """

        self._request_headers = request_headers

    @property
    def sync_status(self):
        """
        Gets the sync_status of this FileSourceSummaryResponse.
        Synchronization status of the file.  This status can be checked periodically after changes are made to the dataset to determine the status of asynchronous syncronization.  * `NEW`: Just created. Not yet synchronized. * `INPROGRESS`: Currently being synchronized. * `LOADED`: Successfully synchronized. * `SYSTEMERROR`: Error state due to synchronization failure.

        :return: The sync_status of this FileSourceSummaryResponse.
        :rtype: str
        """
        return self._sync_status

    @sync_status.setter
    def sync_status(self, sync_status):
        """
        Sets the sync_status of this FileSourceSummaryResponse.
        Synchronization status of the file.  This status can be checked periodically after changes are made to the dataset to determine the status of asynchronous syncronization.  * `NEW`: Just created. Not yet synchronized. * `INPROGRESS`: Currently being synchronized. * `LOADED`: Successfully synchronized. * `SYSTEMERROR`: Error state due to synchronization failure.

        :param sync_status: The sync_status of this FileSourceSummaryResponse.
        :type: str
        """
        if sync_status is None:
            raise ValueError("Invalid value for `sync_status`, must not be `None`")

        self._sync_status = sync_status

    @property
    def sync_summary(self):
        """
        Gets the sync_summary of this FileSourceSummaryResponse.
        Human-readable message detailing status of last failed sync.

        :return: The sync_summary of this FileSourceSummaryResponse.
        :rtype: str
        """
        return self._sync_summary

    @sync_summary.setter
    def sync_summary(self, sync_summary):
        """
        Sets the sync_summary of this FileSourceSummaryResponse.
        Human-readable message detailing status of last failed sync.

        :param sync_summary: The sync_summary of this FileSourceSummaryResponse.
        :type: str
        """

        self._sync_summary = sync_summary

    @property
    def url(self):
        """
        Gets the url of this FileSourceSummaryResponse.
        Source URL of file. Must be an http, https, or stream URL.

        :return: The url of this FileSourceSummaryResponse.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this FileSourceSummaryResponse.
        Source URL of file. Must be an http, https, or stream URL.

        :param url: The url of this FileSourceSummaryResponse.
        :type: str
        """

        self._url = url

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, FileSourceSummaryResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
