# coding: utf-8

"""
    data.world API

    # data.world in a nutshell  data.world is a productive, secure platform for modern data teamwork.  We bring together your data practitioners, subject matter experts, and other stakeholders by removing costly barriers to data discovery, comprehension, integration, and sharing.   Everything your team needs to quickly understand and use data stays with it.   Social features and integrations encourage collaborators to ask and answer questions, share discoveries, and coordinate closely while still using their preferred tools.  Our focus on interoperability helps you enhance your own data with data from any source, including our vast and growing library of free public datasets.   Sophisticated permissions, auditing features, and more make it easy to manage who views your data and what they do with it.  # Conventions  ## Authentication  All data.world API calls require an API token.   OAuth2 is the preferred and most secure method for authenticating users of your data.world applications. Visit our [oauth documentation](https://apidocs.data.world/toolkit/oauth) for additional information. Alternatively, you can obtain a token for _personal use or testing_ by navigating to your profile settings, under the Advanced tab ([https://data.world/settings/advanced](https://data.world/settings/advanced)).  Authentication must be provided in API requests via the `Authorization` header. For example, for a user whose API token is `my_api_token`, the request header should be `Authorization: Bearer my_api_token` (note the `Bearer` prefix).  ## Content type   By default, `application/json` is the content type used in request and response bodies. Exceptions are noted in respective endpoint documentation.  ## HTTPS only   Our APIs can only be accessed via HTTPS.  # Interested in building data.world apps?  Check out our [developer portal](https://apidocs.data.world) for tips on how to get started, tutorials, and to interact with the API endpoints right within your browser.

    OpenAPI spec version: 0.21.0
    Contact: help@data.world
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class DatabaseDbo(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'environment': 'str',
        'type': 'str',
        'server': 'str',
        'port': 'int',
        'catalog': 'str',
        'schema': 'str',
        'created': 'datetime',
        'updated': 'datetime'
    }

    attribute_map = {
        'id': 'id',
        'environment': 'environment',
        'type': 'type',
        'server': 'server',
        'port': 'port',
        'catalog': 'catalog',
        'schema': 'schema',
        'created': 'created',
        'updated': 'updated'
    }

    def __init__(self, id=None, environment=None, type=None, server=None, port=None, catalog=None, schema=None, created=None, updated=None):
        """
        DatabaseDbo - a model defined in Swagger
        """

        self._id = None
        self._environment = None
        self._type = None
        self._server = None
        self._port = None
        self._catalog = None
        self._schema = None
        self._created = None
        self._updated = None

        if id is not None:
          self.id = id
        if environment is not None:
          self.environment = environment
        if type is not None:
          self.type = type
        if server is not None:
          self.server = server
        if port is not None:
          self.port = port
        if catalog is not None:
          self.catalog = catalog
        if schema is not None:
          self.schema = schema
        if created is not None:
          self.created = created
        if updated is not None:
          self.updated = updated

    @property
    def id(self):
        """
        Gets the id of this DatabaseDbo.

        :return: The id of this DatabaseDbo.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DatabaseDbo.

        :param id: The id of this DatabaseDbo.
        :type: str
        """

        self._id = id

    @property
    def environment(self):
        """
        Gets the environment of this DatabaseDbo.

        :return: The environment of this DatabaseDbo.
        :rtype: str
        """
        return self._environment

    @environment.setter
    def environment(self, environment):
        """
        Sets the environment of this DatabaseDbo.

        :param environment: The environment of this DatabaseDbo.
        :type: str
        """

        self._environment = environment

    @property
    def type(self):
        """
        Gets the type of this DatabaseDbo.

        :return: The type of this DatabaseDbo.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this DatabaseDbo.

        :param type: The type of this DatabaseDbo.
        :type: str
        """

        self._type = type

    @property
    def server(self):
        """
        Gets the server of this DatabaseDbo.

        :return: The server of this DatabaseDbo.
        :rtype: str
        """
        return self._server

    @server.setter
    def server(self, server):
        """
        Sets the server of this DatabaseDbo.

        :param server: The server of this DatabaseDbo.
        :type: str
        """

        self._server = server

    @property
    def port(self):
        """
        Gets the port of this DatabaseDbo.

        :return: The port of this DatabaseDbo.
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """
        Sets the port of this DatabaseDbo.

        :param port: The port of this DatabaseDbo.
        :type: int
        """

        self._port = port

    @property
    def catalog(self):
        """
        Gets the catalog of this DatabaseDbo.

        :return: The catalog of this DatabaseDbo.
        :rtype: str
        """
        return self._catalog

    @catalog.setter
    def catalog(self, catalog):
        """
        Sets the catalog of this DatabaseDbo.

        :param catalog: The catalog of this DatabaseDbo.
        :type: str
        """

        self._catalog = catalog

    @property
    def schema(self):
        """
        Gets the schema of this DatabaseDbo.

        :return: The schema of this DatabaseDbo.
        :rtype: str
        """
        return self._schema

    @schema.setter
    def schema(self, schema):
        """
        Sets the schema of this DatabaseDbo.

        :param schema: The schema of this DatabaseDbo.
        :type: str
        """

        self._schema = schema

    @property
    def created(self):
        """
        Gets the created of this DatabaseDbo.

        :return: The created of this DatabaseDbo.
        :rtype: datetime
        """
        return self._created

    @created.setter
    def created(self, created):
        """
        Sets the created of this DatabaseDbo.

        :param created: The created of this DatabaseDbo.
        :type: datetime
        """

        self._created = created

    @property
    def updated(self):
        """
        Gets the updated of this DatabaseDbo.

        :return: The updated of this DatabaseDbo.
        :rtype: datetime
        """
        return self._updated

    @updated.setter
    def updated(self, updated):
        """
        Sets the updated of this DatabaseDbo.

        :param updated: The updated of this DatabaseDbo.
        :type: datetime
        """

        self._updated = updated

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, DatabaseDbo):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
