# coding: utf-8

"""
    data.world API

    # data.world in a nutshell  data.world is a productive, secure platform for modern data teamwork.  We bring together your data practitioners, subject matter experts, and other stakeholders by removing costly barriers to data discovery, comprehension, integration, and sharing.   Everything your team needs to quickly understand and use data stays with it.   Social features and integrations encourage collaborators to ask and answer questions, share discoveries, and coordinate closely while still using their preferred tools.  Our focus on interoperability helps you enhance your own data with data from any source, including our vast and growing library of free public datasets.   Sophisticated permissions, auditing features, and more make it easy to manage who views your data and what they do with it.  # Conventions  ## Authentication  All data.world API calls require an API token.   OAuth2 is the preferred and most secure method for authenticating users of your data.world applications. Visit our [oauth documentation](https://apidocs.data.world/toolkit/oauth) for additional information. Alternatively, you can obtain a token for _personal use or testing_ by navigating to your profile settings, under the Advanced tab ([https://data.world/settings/advanced](https://data.world/settings/advanced)).  Authentication must be provided in API requests via the `Authorization` header. For example, for a user whose API token is `my_api_token`, the request header should be `Authorization: Bearer my_api_token` (note the `Bearer` prefix).  ## Content type   By default, `application/json` is the content type used in request and response bodies. Exceptions are noted in respective endpoint documentation.  ## HTTPS only   Our APIs can only be accessed via HTTPS.  # Interested in building data.world apps?  Check out our [developer portal](https://apidocs.data.world) for tips on how to get started, tutorials, and to interact with the API endpoints right within your browser.

    OpenAPI spec version: 0.21.0
    Contact: help@data.world
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class CatalogConceptHydrationDto(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'agentid': 'str',
        'alt_label': 'str',
        'concept_hierarchy': 'list[ConceptEntry]',
        'created_by': 'AgentHydrationDto',
        'iri': 'str',
        'pref_label': 'str',
        'type': 'str',
        'updated': 'datetime'
    }

    attribute_map = {
        'agentid': 'agentid',
        'alt_label': 'altLabel',
        'concept_hierarchy': 'conceptHierarchy',
        'created_by': 'createdBy',
        'iri': 'iri',
        'pref_label': 'prefLabel',
        'type': 'type',
        'updated': 'updated'
    }

    def __init__(self, agentid=None, alt_label=None, concept_hierarchy=None, created_by=None, iri=None, pref_label=None, type=None, updated=None):
        """
        CatalogConceptHydrationDto - a model defined in Swagger
        """

        self._agentid = None
        self._alt_label = None
        self._concept_hierarchy = None
        self._created_by = None
        self._iri = None
        self._pref_label = None
        self._type = None
        self._updated = None

        if agentid is not None:
          self.agentid = agentid
        if alt_label is not None:
          self.alt_label = alt_label
        if concept_hierarchy is not None:
          self.concept_hierarchy = concept_hierarchy
        if created_by is not None:
          self.created_by = created_by
        if iri is not None:
          self.iri = iri
        if pref_label is not None:
          self.pref_label = pref_label
        if type is not None:
          self.type = type
        if updated is not None:
          self.updated = updated

    @property
    def agentid(self):
        """
        Gets the agentid of this CatalogConceptHydrationDto.

        :return: The agentid of this CatalogConceptHydrationDto.
        :rtype: str
        """
        return self._agentid

    @agentid.setter
    def agentid(self, agentid):
        """
        Sets the agentid of this CatalogConceptHydrationDto.

        :param agentid: The agentid of this CatalogConceptHydrationDto.
        :type: str
        """

        self._agentid = agentid

    @property
    def alt_label(self):
        """
        Gets the alt_label of this CatalogConceptHydrationDto.

        :return: The alt_label of this CatalogConceptHydrationDto.
        :rtype: str
        """
        return self._alt_label

    @alt_label.setter
    def alt_label(self, alt_label):
        """
        Sets the alt_label of this CatalogConceptHydrationDto.

        :param alt_label: The alt_label of this CatalogConceptHydrationDto.
        :type: str
        """

        self._alt_label = alt_label

    @property
    def concept_hierarchy(self):
        """
        Gets the concept_hierarchy of this CatalogConceptHydrationDto.

        :return: The concept_hierarchy of this CatalogConceptHydrationDto.
        :rtype: list[ConceptEntry]
        """
        return self._concept_hierarchy

    @concept_hierarchy.setter
    def concept_hierarchy(self, concept_hierarchy):
        """
        Sets the concept_hierarchy of this CatalogConceptHydrationDto.

        :param concept_hierarchy: The concept_hierarchy of this CatalogConceptHydrationDto.
        :type: list[ConceptEntry]
        """

        self._concept_hierarchy = concept_hierarchy

    @property
    def created_by(self):
        """
        Gets the created_by of this CatalogConceptHydrationDto.

        :return: The created_by of this CatalogConceptHydrationDto.
        :rtype: AgentHydrationDto
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """
        Sets the created_by of this CatalogConceptHydrationDto.

        :param created_by: The created_by of this CatalogConceptHydrationDto.
        :type: AgentHydrationDto
        """

        self._created_by = created_by

    @property
    def iri(self):
        """
        Gets the iri of this CatalogConceptHydrationDto.

        :return: The iri of this CatalogConceptHydrationDto.
        :rtype: str
        """
        return self._iri

    @iri.setter
    def iri(self, iri):
        """
        Sets the iri of this CatalogConceptHydrationDto.

        :param iri: The iri of this CatalogConceptHydrationDto.
        :type: str
        """

        self._iri = iri

    @property
    def pref_label(self):
        """
        Gets the pref_label of this CatalogConceptHydrationDto.

        :return: The pref_label of this CatalogConceptHydrationDto.
        :rtype: str
        """
        return self._pref_label

    @pref_label.setter
    def pref_label(self, pref_label):
        """
        Sets the pref_label of this CatalogConceptHydrationDto.

        :param pref_label: The pref_label of this CatalogConceptHydrationDto.
        :type: str
        """

        self._pref_label = pref_label

    @property
    def type(self):
        """
        Gets the type of this CatalogConceptHydrationDto.

        :return: The type of this CatalogConceptHydrationDto.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this CatalogConceptHydrationDto.

        :param type: The type of this CatalogConceptHydrationDto.
        :type: str
        """

        self._type = type

    @property
    def updated(self):
        """
        Gets the updated of this CatalogConceptHydrationDto.

        :return: The updated of this CatalogConceptHydrationDto.
        :rtype: datetime
        """
        return self._updated

    @updated.setter
    def updated(self, updated):
        """
        Sets the updated of this CatalogConceptHydrationDto.

        :param updated: The updated of this CatalogConceptHydrationDto.
        :type: datetime
        """

        self._updated = updated

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, CatalogConceptHydrationDto):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
