# coding: utf-8

"""
    data.world API

    # data.world in a nutshell  data.world is a productive, secure platform for modern data teamwork.  We bring together your data practitioners, subject matter experts, and other stakeholders by removing costly barriers to data discovery, comprehension, integration, and sharing.   Everything your team needs to quickly understand and use data stays with it.   Social features and integrations encourage collaborators to ask and answer questions, share discoveries, and coordinate closely while still using their preferred tools.  Our focus on interoperability helps you enhance your own data with data from any source, including our vast and growing library of free public datasets.   Sophisticated permissions, auditing features, and more make it easy to manage who views your data and what they do with it.  # Conventions  ## Authentication  All data.world API calls require an API token.   OAuth2 is the preferred and most secure method for authenticating users of your data.world applications. Visit our [oauth documentation](https://apidocs.data.world/toolkit/oauth) for additional information. Alternatively, you can obtain a token for _personal use or testing_ by navigating to your profile settings, under the Advanced tab ([https://data.world/settings/advanced](https://data.world/settings/advanced)).  Authentication must be provided in API requests via the `Authorization` header. For example, for a user whose API token is `my_api_token`, the request header should be `Authorization: Bearer my_api_token` (note the `Bearer` prefix).  ## Content type   By default, `application/json` is the content type used in request and response bodies. Exceptions are noted in respective endpoint documentation.  ## HTTPS only   Our APIs can only be accessed via HTTPS.  # Interested in building data.world apps?  Check out our [developer portal](https://apidocs.data.world) for tips on how to get started, tutorials, and to interact with the API endpoints right within your browser.

    OpenAPI spec version: 0.21.0
    Contact: help@data.world
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class CatalogBusinessTermHydrationDto(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'abstract_': 'str',
        'agentid': 'str',
        'asset_status': 'AssetStatus',
        'business_termid': 'str',
        'catalogs': 'list[CatalogId]',
        'created_by': 'AgentHydrationDto',
        'description': 'str',
        'entry_type_hierarchy': 'list[EntryType]',
        'entry_type_label': 'str',
        'referent': 'str',
        'title': 'str',
        'type': 'str',
        'updated': 'datetime'
    }

    attribute_map = {
        'abstract_': 'abstract_',
        'agentid': 'agentid',
        'asset_status': 'assetStatus',
        'business_termid': 'businessTermid',
        'catalogs': 'catalogs',
        'created_by': 'createdBy',
        'description': 'description',
        'entry_type_hierarchy': 'entryTypeHierarchy',
        'entry_type_label': 'entryTypeLabel',
        'referent': 'referent',
        'title': 'title',
        'type': 'type',
        'updated': 'updated'
    }

    def __init__(self, abstract_=None, agentid=None, asset_status=None, business_termid=None, catalogs=None, created_by=None, description=None, entry_type_hierarchy=None, entry_type_label=None, referent=None, title=None, type=None, updated=None):
        """
        CatalogBusinessTermHydrationDto - a model defined in Swagger
        """

        self._abstract_ = None
        self._agentid = None
        self._asset_status = None
        self._business_termid = None
        self._catalogs = None
        self._created_by = None
        self._description = None
        self._entry_type_hierarchy = None
        self._entry_type_label = None
        self._referent = None
        self._title = None
        self._type = None
        self._updated = None

        if abstract_ is not None:
          self.abstract_ = abstract_
        if agentid is not None:
          self.agentid = agentid
        if asset_status is not None:
          self.asset_status = asset_status
        if business_termid is not None:
          self.business_termid = business_termid
        if catalogs is not None:
          self.catalogs = catalogs
        if created_by is not None:
          self.created_by = created_by
        if description is not None:
          self.description = description
        if entry_type_hierarchy is not None:
          self.entry_type_hierarchy = entry_type_hierarchy
        if entry_type_label is not None:
          self.entry_type_label = entry_type_label
        if referent is not None:
          self.referent = referent
        if title is not None:
          self.title = title
        if type is not None:
          self.type = type
        if updated is not None:
          self.updated = updated

    @property
    def abstract_(self):
        """
        Gets the abstract_ of this CatalogBusinessTermHydrationDto.

        :return: The abstract_ of this CatalogBusinessTermHydrationDto.
        :rtype: str
        """
        return self._abstract_

    @abstract_.setter
    def abstract_(self, abstract_):
        """
        Sets the abstract_ of this CatalogBusinessTermHydrationDto.

        :param abstract_: The abstract_ of this CatalogBusinessTermHydrationDto.
        :type: str
        """

        self._abstract_ = abstract_

    @property
    def agentid(self):
        """
        Gets the agentid of this CatalogBusinessTermHydrationDto.

        :return: The agentid of this CatalogBusinessTermHydrationDto.
        :rtype: str
        """
        return self._agentid

    @agentid.setter
    def agentid(self, agentid):
        """
        Sets the agentid of this CatalogBusinessTermHydrationDto.

        :param agentid: The agentid of this CatalogBusinessTermHydrationDto.
        :type: str
        """

        self._agentid = agentid

    @property
    def asset_status(self):
        """
        Gets the asset_status of this CatalogBusinessTermHydrationDto.

        :return: The asset_status of this CatalogBusinessTermHydrationDto.
        :rtype: AssetStatus
        """
        return self._asset_status

    @asset_status.setter
    def asset_status(self, asset_status):
        """
        Sets the asset_status of this CatalogBusinessTermHydrationDto.

        :param asset_status: The asset_status of this CatalogBusinessTermHydrationDto.
        :type: AssetStatus
        """

        self._asset_status = asset_status

    @property
    def business_termid(self):
        """
        Gets the business_termid of this CatalogBusinessTermHydrationDto.

        :return: The business_termid of this CatalogBusinessTermHydrationDto.
        :rtype: str
        """
        return self._business_termid

    @business_termid.setter
    def business_termid(self, business_termid):
        """
        Sets the business_termid of this CatalogBusinessTermHydrationDto.

        :param business_termid: The business_termid of this CatalogBusinessTermHydrationDto.
        :type: str
        """

        self._business_termid = business_termid

    @property
    def catalogs(self):
        """
        Gets the catalogs of this CatalogBusinessTermHydrationDto.

        :return: The catalogs of this CatalogBusinessTermHydrationDto.
        :rtype: list[CatalogId]
        """
        return self._catalogs

    @catalogs.setter
    def catalogs(self, catalogs):
        """
        Sets the catalogs of this CatalogBusinessTermHydrationDto.

        :param catalogs: The catalogs of this CatalogBusinessTermHydrationDto.
        :type: list[CatalogId]
        """

        self._catalogs = catalogs

    @property
    def created_by(self):
        """
        Gets the created_by of this CatalogBusinessTermHydrationDto.

        :return: The created_by of this CatalogBusinessTermHydrationDto.
        :rtype: AgentHydrationDto
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """
        Sets the created_by of this CatalogBusinessTermHydrationDto.

        :param created_by: The created_by of this CatalogBusinessTermHydrationDto.
        :type: AgentHydrationDto
        """

        self._created_by = created_by

    @property
    def description(self):
        """
        Gets the description of this CatalogBusinessTermHydrationDto.

        :return: The description of this CatalogBusinessTermHydrationDto.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CatalogBusinessTermHydrationDto.

        :param description: The description of this CatalogBusinessTermHydrationDto.
        :type: str
        """

        self._description = description

    @property
    def entry_type_hierarchy(self):
        """
        Gets the entry_type_hierarchy of this CatalogBusinessTermHydrationDto.

        :return: The entry_type_hierarchy of this CatalogBusinessTermHydrationDto.
        :rtype: list[EntryType]
        """
        return self._entry_type_hierarchy

    @entry_type_hierarchy.setter
    def entry_type_hierarchy(self, entry_type_hierarchy):
        """
        Sets the entry_type_hierarchy of this CatalogBusinessTermHydrationDto.

        :param entry_type_hierarchy: The entry_type_hierarchy of this CatalogBusinessTermHydrationDto.
        :type: list[EntryType]
        """

        self._entry_type_hierarchy = entry_type_hierarchy

    @property
    def entry_type_label(self):
        """
        Gets the entry_type_label of this CatalogBusinessTermHydrationDto.

        :return: The entry_type_label of this CatalogBusinessTermHydrationDto.
        :rtype: str
        """
        return self._entry_type_label

    @entry_type_label.setter
    def entry_type_label(self, entry_type_label):
        """
        Sets the entry_type_label of this CatalogBusinessTermHydrationDto.

        :param entry_type_label: The entry_type_label of this CatalogBusinessTermHydrationDto.
        :type: str
        """

        self._entry_type_label = entry_type_label

    @property
    def referent(self):
        """
        Gets the referent of this CatalogBusinessTermHydrationDto.

        :return: The referent of this CatalogBusinessTermHydrationDto.
        :rtype: str
        """
        return self._referent

    @referent.setter
    def referent(self, referent):
        """
        Sets the referent of this CatalogBusinessTermHydrationDto.

        :param referent: The referent of this CatalogBusinessTermHydrationDto.
        :type: str
        """

        self._referent = referent

    @property
    def title(self):
        """
        Gets the title of this CatalogBusinessTermHydrationDto.

        :return: The title of this CatalogBusinessTermHydrationDto.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this CatalogBusinessTermHydrationDto.

        :param title: The title of this CatalogBusinessTermHydrationDto.
        :type: str
        """

        self._title = title

    @property
    def type(self):
        """
        Gets the type of this CatalogBusinessTermHydrationDto.

        :return: The type of this CatalogBusinessTermHydrationDto.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this CatalogBusinessTermHydrationDto.

        :param type: The type of this CatalogBusinessTermHydrationDto.
        :type: str
        """

        self._type = type

    @property
    def updated(self):
        """
        Gets the updated of this CatalogBusinessTermHydrationDto.

        :return: The updated of this CatalogBusinessTermHydrationDto.
        :rtype: datetime
        """
        return self._updated

    @updated.setter
    def updated(self, updated):
        """
        Sets the updated of this CatalogBusinessTermHydrationDto.

        :param updated: The updated of this CatalogBusinessTermHydrationDto.
        :type: datetime
        """

        self._updated = updated

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, CatalogBusinessTermHydrationDto):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
