# coding: utf-8

"""
    data.world API

    # data.world in a nutshell  data.world is a productive, secure platform for modern data teamwork.  We bring together your data practitioners, subject matter experts, and other stakeholders by removing costly barriers to data discovery, comprehension, integration, and sharing.   Everything your team needs to quickly understand and use data stays with it.   Social features and integrations encourage collaborators to ask and answer questions, share discoveries, and coordinate closely while still using their preferred tools.  Our focus on interoperability helps you enhance your own data with data from any source, including our vast and growing library of free public datasets.   Sophisticated permissions, auditing features, and more make it easy to manage who views your data and what they do with it.  # Conventions  ## Authentication  All data.world API calls require an API token.   OAuth2 is the preferred and most secure method for authenticating users of your data.world applications. Visit our [oauth documentation](https://apidocs.data.world/toolkit/oauth) for additional information. Alternatively, you can obtain a token for _personal use or testing_ by navigating to your profile settings, under the Advanced tab ([https://data.world/settings/advanced](https://data.world/settings/advanced)).  Authentication must be provided in API requests via the `Authorization` header. For example, for a user whose API token is `my_api_token`, the request header should be `Authorization: Bearer my_api_token` (note the `Bearer` prefix).  ## Content type   By default, `application/json` is the content type used in request and response bodies. Exceptions are noted in respective endpoint documentation.  ## HTTPS only   Our APIs can only be accessed via HTTPS.  # Interested in building data.world apps?  Check out our [developer portal](https://apidocs.data.world) for tips on how to get started, tutorials, and to interact with the API endpoints right within your browser.

    OpenAPI spec version: 0.21.0
    Contact: help@data.world
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

# import models into model package
from .agent_hydration_dto import AgentHydrationDto
from .analysis_image import AnalysisImage
from .asset_status import AssetStatus
from .catalog_analysis_hydration_dto import CatalogAnalysisHydrationDto
from .catalog_analysis_request import CatalogAnalysisRequest
from .catalog_business_term_hydration_dto import CatalogBusinessTermHydrationDto
from .catalog_column_hydration_dto import CatalogColumnHydrationDto
from .catalog_column_request import CatalogColumnRequest
from .catalog_concept_hydration_dto import CatalogConceptHydrationDto
from .catalog_glossary_request import CatalogGlossaryRequest
from .catalog_hydration_dto import CatalogHydrationDto
from .catalog_id import CatalogId
from .catalog_request import CatalogRequest
from .catalog_table_hydration_dto import CatalogTableHydrationDto
from .catalog_table_request import CatalogTableRequest
from .concept_entry import ConceptEntry
from .connection_dto import ConnectionDto
from .create_dataset_response import CreateDatasetResponse
from .create_insight_response import CreateInsightResponse
from .create_project_response import CreateProjectResponse
from .create_query_request import CreateQueryRequest
from .create_response import CreateResponse
from .custom_dataset_or_project_metadata_request import CustomDatasetOrProjectMetadataRequest
from .database_credentials import DatabaseCredentials
from .database_dbo import DatabaseDbo
from .database_source_reference import DatabaseSourceReference
from .dataset_create_request import DatasetCreateRequest
from .dataset_hydration_dto import DatasetHydrationDto
from .dataset_identifier import DatasetIdentifier
from .dataset_patch_request import DatasetPatchRequest
from .dataset_put_request import DatasetPutRequest
from .dataset_summary_response import DatasetSummaryResponse
from .doi import Doi
from .edit_activities_result_dto import EditActivitiesResultDto
from .entry_type import EntryType
from .error_message import ErrorMessage
from .file_batch_update_request import FileBatchUpdateRequest
from .file_create_or_update_request import FileCreateOrUpdateRequest
from .file_create_request import FileCreateRequest
from .file_source_create_or_update_request import FileSourceCreateOrUpdateRequest
from .file_source_create_request import FileSourceCreateRequest
from .file_source_summary_response import FileSourceSummaryResponse
from .file_summary_response import FileSummaryResponse
from .insight_body import InsightBody
from .insight_create_request import InsightCreateRequest
from .insight_hydration_dto import InsightHydrationDto
from .insight_patch_request import InsightPatchRequest
from .insight_put_request import InsightPutRequest
from .insight_summary_response import InsightSummaryResponse
from .instant import Instant
from .json_node import JsonNode
from .linked_dataset_create_or_update_request import LinkedDatasetCreateOrUpdateRequest
from .linked_dataset_summary_response import LinkedDatasetSummaryResponse
from .metadata_resource_dto import MetadataResourceDto
from .oauth_token_reference import OauthTokenReference
from .paginated_connection_results import PaginatedConnectionResults
from .paginated_dataset_results import PaginatedDatasetResults
from .paginated_insight_results import PaginatedInsightResults
from .paginated_metadata_resource_results import PaginatedMetadataResourceResults
from .paginated_project_results import PaginatedProjectResults
from .paginated_query_results import PaginatedQueryResults
from .paginated_search_results_dto import PaginatedSearchResultsDto
from .paginated_subscription_results import PaginatedSubscriptionResults
from .project_create_request import ProjectCreateRequest
from .project_patch_request import ProjectPatchRequest
from .project_put_request import ProjectPutRequest
from .project_summary_response import ProjectSummaryResponse
from .query_parameter import QueryParameter
from .query_put_request import QueryPutRequest
from .query_summary_response import QuerySummaryResponse
from .range import Range
from .rdf_term import RdfTerm
from .relationship_create_or_delete_request import RelationshipCreateOrDeleteRequest
from .relationship_get_request import RelationshipGetRequest
from .relationship_get_table_request import RelationshipGetTableRequest
from .resource_relationship_dto import ResourceRelationshipDto
from .saved_query_execution_request import SavedQueryExecutionRequest
from .search_facet_result import SearchFacetResult
from .search_hydrations import SearchHydrations
from .search_request import SearchRequest
from .simple_search_request import SimpleSearchRequest
from .single_table_metadata_spec import SingleTableMetadataSpec
from .source_id import SourceId
from .sql_query_request import SqlQueryRequest
from .ssh_tunnel import SshTunnel
from .stream_schema import StreamSchema
from .stream_schema_patch_request import StreamSchemaPatchRequest
from .streams_resource import StreamsResource
from .subscription import Subscription
from .subscription_api_links import SubscriptionApiLinks
from .subscription_create_request import SubscriptionCreateRequest
from .subscription_links import SubscriptionLinks
from .success_message import SuccessMessage
from .table_batch_update_request import TableBatchUpdateRequest
from .table_create_or_update_request import TableCreateOrUpdateRequest
from .table_id import TableId
from .table_source_create_or_update_request import TableSourceCreateOrUpdateRequest
from .tag import Tag
from .user_data_response import UserDataResponse
from .user_identifier import UserIdentifier
from .web_authorization import WebAuthorization
from .web_credentials import WebCredentials
