# coding: utf-8

"""
    data.world API

    # data.world in a nutshell  data.world is a productive, secure platform for modern data teamwork.  We bring together your data practitioners, subject matter experts, and other stakeholders by removing costly barriers to data discovery, comprehension, integration, and sharing.   Everything your team needs to quickly understand and use data stays with it.   Social features and integrations encourage collaborators to ask and answer questions, share discoveries, and coordinate closely while still using their preferred tools.  Our focus on interoperability helps you enhance your own data with data from any source, including our vast and growing library of free public datasets.   Sophisticated permissions, auditing features, and more make it easy to manage who views your data and what they do with it.  # Conventions  ## Authentication  All data.world API calls require an API token.   OAuth2 is the preferred and most secure method for authenticating users of your data.world applications. Visit our [oauth documentation](https://apidocs.data.world/toolkit/oauth) for additional information. Alternatively, you can obtain a token for _personal use or testing_ by navigating to your profile settings, under the Advanced tab ([https://data.world/settings/advanced](https://data.world/settings/advanced)).  Authentication must be provided in API requests via the `Authorization` header. For example, for a user whose API token is `my_api_token`, the request header should be `Authorization: Bearer my_api_token` (note the `Bearer` prefix).  ## Content type   By default, `application/json` is the content type used in request and response bodies. Exceptions are noted in respective endpoint documentation.  ## HTTPS only   Our APIs can only be accessed via HTTPS.  # Interested in building data.world apps?  Check out our [developer portal](https://apidocs.data.world) for tips on how to get started, tutorials, and to interact with the API endpoints right within your browser.

    OpenAPI spec version: 0.21.0
    Contact: help@data.world
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class MetadatadataApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def create_catalog_column(self, owner, sourceid, tableid, body, **kwargs):
        """
        Create a Column
        Create a Column.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_catalog_column(owner, sourceid, tableid, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str owner: id of the user or organization (required)
        :param str sourceid: database source id (required)
        :param str tableid: (required)
        :param CatalogColumnRequest body: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_catalog_column_with_http_info(owner, sourceid, tableid, body, **kwargs)
        else:
            (data) = self.create_catalog_column_with_http_info(owner, sourceid, tableid, body, **kwargs)
            return data

    def create_catalog_column_with_http_info(self, owner, sourceid, tableid, body, **kwargs):
        """
        Create a Column
        Create a Column.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_catalog_column_with_http_info(owner, sourceid, tableid, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str owner: id of the user or organization (required)
        :param str sourceid: database source id (required)
        :param str tableid: (required)
        :param CatalogColumnRequest body: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'sourceid', 'tableid', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_catalog_column" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params) or (params['owner'] is None):
            raise ValueError("Missing the required parameter `owner` when calling `create_catalog_column`")
        # verify the required parameter 'sourceid' is set
        if ('sourceid' not in params) or (params['sourceid'] is None):
            raise ValueError("Missing the required parameter `sourceid` when calling `create_catalog_column`")
        # verify the required parameter 'tableid' is set
        if ('tableid' not in params) or (params['tableid'] is None):
            raise ValueError("Missing the required parameter `tableid` when calling `create_catalog_column`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_catalog_column`")


        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']
        if 'sourceid' in params:
            path_params['sourceid'] = params['sourceid']
        if 'tableid' in params:
            path_params['tableid'] = params['tableid']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['oauth']

        return self.api_client.call_api('/metadata/data/sources/{owner}/{sourceid}/tables/{tableid}/columns', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CreateResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_catalog_table(self, owner, sourceid, body, **kwargs):
        """
        Create a new table metadata
        Create a new table metadata.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_catalog_table(owner, sourceid, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str owner: id of the user or organization (required)
        :param str sourceid: database source id (required)
        :param CatalogTableRequest body: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_catalog_table_with_http_info(owner, sourceid, body, **kwargs)
        else:
            (data) = self.create_catalog_table_with_http_info(owner, sourceid, body, **kwargs)
            return data

    def create_catalog_table_with_http_info(self, owner, sourceid, body, **kwargs):
        """
        Create a new table metadata
        Create a new table metadata.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_catalog_table_with_http_info(owner, sourceid, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str owner: id of the user or organization (required)
        :param str sourceid: database source id (required)
        :param CatalogTableRequest body: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'sourceid', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_catalog_table" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params) or (params['owner'] is None):
            raise ValueError("Missing the required parameter `owner` when calling `create_catalog_table`")
        # verify the required parameter 'sourceid' is set
        if ('sourceid' not in params) or (params['sourceid'] is None):
            raise ValueError("Missing the required parameter `sourceid` when calling `create_catalog_table`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_catalog_table`")


        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']
        if 'sourceid' in params:
            path_params['sourceid'] = params['sourceid']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['oauth']

        return self.api_client.call_api('/metadata/data/sources/{owner}/{sourceid}/tables', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CreateResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_catalog_column(self, owner, sourceid, tableid, columnid, **kwargs):
        """
        Delete a Column
        Delete a Column.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_catalog_column(owner, sourceid, tableid, columnid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str owner: id of the user or organization (required)
        :param str sourceid: database source id (required)
        :param str tableid: (required)
        :param str columnid: (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_catalog_column_with_http_info(owner, sourceid, tableid, columnid, **kwargs)
        else:
            (data) = self.delete_catalog_column_with_http_info(owner, sourceid, tableid, columnid, **kwargs)
            return data

    def delete_catalog_column_with_http_info(self, owner, sourceid, tableid, columnid, **kwargs):
        """
        Delete a Column
        Delete a Column.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_catalog_column_with_http_info(owner, sourceid, tableid, columnid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str owner: id of the user or organization (required)
        :param str sourceid: database source id (required)
        :param str tableid: (required)
        :param str columnid: (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'sourceid', 'tableid', 'columnid']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_catalog_column" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params) or (params['owner'] is None):
            raise ValueError("Missing the required parameter `owner` when calling `delete_catalog_column`")
        # verify the required parameter 'sourceid' is set
        if ('sourceid' not in params) or (params['sourceid'] is None):
            raise ValueError("Missing the required parameter `sourceid` when calling `delete_catalog_column`")
        # verify the required parameter 'tableid' is set
        if ('tableid' not in params) or (params['tableid'] is None):
            raise ValueError("Missing the required parameter `tableid` when calling `delete_catalog_column`")
        # verify the required parameter 'columnid' is set
        if ('columnid' not in params) or (params['columnid'] is None):
            raise ValueError("Missing the required parameter `columnid` when calling `delete_catalog_column`")


        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']
        if 'sourceid' in params:
            path_params['sourceid'] = params['sourceid']
        if 'tableid' in params:
            path_params['tableid'] = params['tableid']
        if 'columnid' in params:
            path_params['columnid'] = params['columnid']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['oauth']

        return self.api_client.call_api('/metadata/data/sources/{owner}/{sourceid}/tables/{tableid}/columns/{columnid}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SuccessMessage',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_catalog_table(self, owner, sourceid, tableid, **kwargs):
        """
        Delete a table
        Delete a table.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_catalog_table(owner, sourceid, tableid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str owner: id of the user or organization (required)
        :param str sourceid: database source id (required)
        :param str tableid: (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_catalog_table_with_http_info(owner, sourceid, tableid, **kwargs)
        else:
            (data) = self.delete_catalog_table_with_http_info(owner, sourceid, tableid, **kwargs)
            return data

    def delete_catalog_table_with_http_info(self, owner, sourceid, tableid, **kwargs):
        """
        Delete a table
        Delete a table.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_catalog_table_with_http_info(owner, sourceid, tableid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str owner: id of the user or organization (required)
        :param str sourceid: database source id (required)
        :param str tableid: (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'sourceid', 'tableid']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_catalog_table" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params) or (params['owner'] is None):
            raise ValueError("Missing the required parameter `owner` when calling `delete_catalog_table`")
        # verify the required parameter 'sourceid' is set
        if ('sourceid' not in params) or (params['sourceid'] is None):
            raise ValueError("Missing the required parameter `sourceid` when calling `delete_catalog_table`")
        # verify the required parameter 'tableid' is set
        if ('tableid' not in params) or (params['tableid'] is None):
            raise ValueError("Missing the required parameter `tableid` when calling `delete_catalog_table`")


        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']
        if 'sourceid' in params:
            path_params['sourceid'] = params['sourceid']
        if 'tableid' in params:
            path_params['tableid'] = params['tableid']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['oauth']

        return self.api_client.call_api('/metadata/data/sources/{owner}/{sourceid}/tables/{tableid}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SuccessMessage',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_database(self, owner, sourceid, **kwargs):
        """
        Get an individual datasource metadata
        Get an individual datasource metadata
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_database(owner, sourceid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str owner: id of the user or organization (required)
        :param str sourceid: database source id (required)
        :return: DatabaseDbo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_database_with_http_info(owner, sourceid, **kwargs)
        else:
            (data) = self.get_database_with_http_info(owner, sourceid, **kwargs)
            return data

    def get_database_with_http_info(self, owner, sourceid, **kwargs):
        """
        Get an individual datasource metadata
        Get an individual datasource metadata
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_database_with_http_info(owner, sourceid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str owner: id of the user or organization (required)
        :param str sourceid: database source id (required)
        :return: DatabaseDbo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'sourceid']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_database" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params) or (params['owner'] is None):
            raise ValueError("Missing the required parameter `owner` when calling `get_database`")
        # verify the required parameter 'sourceid' is set
        if ('sourceid' not in params) or (params['sourceid'] is None):
            raise ValueError("Missing the required parameter `sourceid` when calling `get_database`")


        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']
        if 'sourceid' in params:
            path_params['sourceid'] = params['sourceid']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['oauth']

        return self.api_client.call_api('/metadata/data/sources/{owner}/{sourceid}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DatabaseDbo',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_databases(self, owner, **kwargs):
        """
        Get datasources by owner.
        Get datasources by owner.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_databases(owner, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str owner: id of the user or organization (required)
        :param str size:
        :param str _from:
        :param str sort:
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_databases_with_http_info(owner, **kwargs)
        else:
            (data) = self.get_databases_with_http_info(owner, **kwargs)
            return data

    def get_databases_with_http_info(self, owner, **kwargs):
        """
        Get datasources by owner.
        Get datasources by owner.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_databases_with_http_info(owner, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str owner: id of the user or organization (required)
        :param str size:
        :param str _from:
        :param str sort:
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'size', '_from', 'sort']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_databases" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params) or (params['owner'] is None):
            raise ValueError("Missing the required parameter `owner` when calling `get_databases`")


        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']

        query_params = []
        if 'size' in params:
            query_params.append(('size', params['size']))
        if '_from' in params:
            query_params.append(('from', params['_from']))
        if 'sort' in params:
            query_params.append(('sort', params['sort']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['oauth']

        return self.api_client.call_api('/metadata/data/sources/{owner}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[object]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_table(self, owner, sourceid, tableid, **kwargs):
        """
        Get an individual table metadata
        Get an individual table metadata
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_table(owner, sourceid, tableid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str owner: id of the user or organization (required)
        :param str sourceid: database source id (required)
        :param str tableid: (required)
        :return: MetadataResourceDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_table_with_http_info(owner, sourceid, tableid, **kwargs)
        else:
            (data) = self.get_table_with_http_info(owner, sourceid, tableid, **kwargs)
            return data

    def get_table_with_http_info(self, owner, sourceid, tableid, **kwargs):
        """
        Get an individual table metadata
        Get an individual table metadata
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_table_with_http_info(owner, sourceid, tableid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str owner: id of the user or organization (required)
        :param str sourceid: database source id (required)
        :param str tableid: (required)
        :return: MetadataResourceDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'sourceid', 'tableid']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_table" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params) or (params['owner'] is None):
            raise ValueError("Missing the required parameter `owner` when calling `get_table`")
        # verify the required parameter 'sourceid' is set
        if ('sourceid' not in params) or (params['sourceid'] is None):
            raise ValueError("Missing the required parameter `sourceid` when calling `get_table`")
        # verify the required parameter 'tableid' is set
        if ('tableid' not in params) or (params['tableid'] is None):
            raise ValueError("Missing the required parameter `tableid` when calling `get_table`")


        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']
        if 'sourceid' in params:
            path_params['sourceid'] = params['sourceid']
        if 'tableid' in params:
            path_params['tableid'] = params['tableid']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['oauth']

        return self.api_client.call_api('/metadata/data/sources/{owner}/{sourceid}/tables/{tableid}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='MetadataResourceDto',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_table_column(self, owner, sourceid, tableid, columnid, **kwargs):
        """
        Get an individual column metadata
        Get an individual column metadata
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_table_column(owner, sourceid, tableid, columnid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str owner: id of the user or organization (required)
        :param str sourceid: database source id (required)
        :param str tableid: (required)
        :param str columnid: (required)
        :return: MetadataResourceDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_table_column_with_http_info(owner, sourceid, tableid, columnid, **kwargs)
        else:
            (data) = self.get_table_column_with_http_info(owner, sourceid, tableid, columnid, **kwargs)
            return data

    def get_table_column_with_http_info(self, owner, sourceid, tableid, columnid, **kwargs):
        """
        Get an individual column metadata
        Get an individual column metadata
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_table_column_with_http_info(owner, sourceid, tableid, columnid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str owner: id of the user or organization (required)
        :param str sourceid: database source id (required)
        :param str tableid: (required)
        :param str columnid: (required)
        :return: MetadataResourceDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'sourceid', 'tableid', 'columnid']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_table_column" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params) or (params['owner'] is None):
            raise ValueError("Missing the required parameter `owner` when calling `get_table_column`")
        # verify the required parameter 'sourceid' is set
        if ('sourceid' not in params) or (params['sourceid'] is None):
            raise ValueError("Missing the required parameter `sourceid` when calling `get_table_column`")
        # verify the required parameter 'tableid' is set
        if ('tableid' not in params) or (params['tableid'] is None):
            raise ValueError("Missing the required parameter `tableid` when calling `get_table_column`")
        # verify the required parameter 'columnid' is set
        if ('columnid' not in params) or (params['columnid'] is None):
            raise ValueError("Missing the required parameter `columnid` when calling `get_table_column`")


        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']
        if 'sourceid' in params:
            path_params['sourceid'] = params['sourceid']
        if 'tableid' in params:
            path_params['tableid'] = params['tableid']
        if 'columnid' in params:
            path_params['columnid'] = params['columnid']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['oauth']

        return self.api_client.call_api('/metadata/data/sources/{owner}/{sourceid}/tables/{tableid}/columns/{columnid}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='MetadataResourceDto',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_table_columns(self, owner, sourceid, tableid, **kwargs):
        """
        Get columns for a given table
        Get columns for a given table
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_table_columns(owner, sourceid, tableid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str owner: id of the user or organization (required)
        :param str sourceid: database source id (required)
        :param str tableid: (required)
        :param str size:
        :param str _from:
        :param str sort:
        :return: PaginatedMetadataResourceResults
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_table_columns_with_http_info(owner, sourceid, tableid, **kwargs)
        else:
            (data) = self.get_table_columns_with_http_info(owner, sourceid, tableid, **kwargs)
            return data

    def get_table_columns_with_http_info(self, owner, sourceid, tableid, **kwargs):
        """
        Get columns for a given table
        Get columns for a given table
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_table_columns_with_http_info(owner, sourceid, tableid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str owner: id of the user or organization (required)
        :param str sourceid: database source id (required)
        :param str tableid: (required)
        :param str size:
        :param str _from:
        :param str sort:
        :return: PaginatedMetadataResourceResults
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'sourceid', 'tableid', 'size', '_from', 'sort']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_table_columns" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params) or (params['owner'] is None):
            raise ValueError("Missing the required parameter `owner` when calling `get_table_columns`")
        # verify the required parameter 'sourceid' is set
        if ('sourceid' not in params) or (params['sourceid'] is None):
            raise ValueError("Missing the required parameter `sourceid` when calling `get_table_columns`")
        # verify the required parameter 'tableid' is set
        if ('tableid' not in params) or (params['tableid'] is None):
            raise ValueError("Missing the required parameter `tableid` when calling `get_table_columns`")


        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']
        if 'sourceid' in params:
            path_params['sourceid'] = params['sourceid']
        if 'tableid' in params:
            path_params['tableid'] = params['tableid']

        query_params = []
        if 'size' in params:
            query_params.append(('size', params['size']))
        if '_from' in params:
            query_params.append(('from', params['_from']))
        if 'sort' in params:
            query_params.append(('sort', params['sort']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['oauth']

        return self.api_client.call_api('/metadata/data/sources/{owner}/{sourceid}/tables/{tableid}/columns', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PaginatedMetadataResourceResults',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_tables(self, owner, sourceid, **kwargs):
        """
        Get tables for a data source
        Get tables for a data source
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_tables(owner, sourceid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str owner: id of the user or organization (required)
        :param str sourceid: database source id (required)
        :param str typelabel:
        :param str typeiri:
        :param str size:
        :param str _from:
        :param str sort:
        :return: PaginatedMetadataResourceResults
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_tables_with_http_info(owner, sourceid, **kwargs)
        else:
            (data) = self.get_tables_with_http_info(owner, sourceid, **kwargs)
            return data

    def get_tables_with_http_info(self, owner, sourceid, **kwargs):
        """
        Get tables for a data source
        Get tables for a data source
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_tables_with_http_info(owner, sourceid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str owner: id of the user or organization (required)
        :param str sourceid: database source id (required)
        :param str typelabel:
        :param str typeiri:
        :param str size:
        :param str _from:
        :param str sort:
        :return: PaginatedMetadataResourceResults
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'sourceid', 'typelabel', 'typeiri', 'size', '_from', 'sort']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tables" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params) or (params['owner'] is None):
            raise ValueError("Missing the required parameter `owner` when calling `get_tables`")
        # verify the required parameter 'sourceid' is set
        if ('sourceid' not in params) or (params['sourceid'] is None):
            raise ValueError("Missing the required parameter `sourceid` when calling `get_tables`")


        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']
        if 'sourceid' in params:
            path_params['sourceid'] = params['sourceid']

        query_params = []
        if 'typelabel' in params:
            query_params.append(('typelabel', params['typelabel']))
        if 'typeiri' in params:
            query_params.append(('typeiri', params['typeiri']))
        if 'size' in params:
            query_params.append(('size', params['size']))
        if '_from' in params:
            query_params.append(('from', params['_from']))
        if 'sort' in params:
            query_params.append(('sort', params['sort']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['oauth']

        return self.api_client.call_api('/metadata/data/sources/{owner}/{sourceid}/tables', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PaginatedMetadataResourceResults',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def patch_catalog_column(self, owner, sourceid, tableid, columnid, body, **kwargs):
        """
        Update an existing Column
        Update an existing Column.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_catalog_column(owner, sourceid, tableid, columnid, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str owner: id of the user or organization (required)
        :param str sourceid: database source id (required)
        :param str tableid: (required)
        :param str columnid: (required)
        :param CatalogColumnRequest body: (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.patch_catalog_column_with_http_info(owner, sourceid, tableid, columnid, body, **kwargs)
        else:
            (data) = self.patch_catalog_column_with_http_info(owner, sourceid, tableid, columnid, body, **kwargs)
            return data

    def patch_catalog_column_with_http_info(self, owner, sourceid, tableid, columnid, body, **kwargs):
        """
        Update an existing Column
        Update an existing Column.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_catalog_column_with_http_info(owner, sourceid, tableid, columnid, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str owner: id of the user or organization (required)
        :param str sourceid: database source id (required)
        :param str tableid: (required)
        :param str columnid: (required)
        :param CatalogColumnRequest body: (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'sourceid', 'tableid', 'columnid', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_catalog_column" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params) or (params['owner'] is None):
            raise ValueError("Missing the required parameter `owner` when calling `patch_catalog_column`")
        # verify the required parameter 'sourceid' is set
        if ('sourceid' not in params) or (params['sourceid'] is None):
            raise ValueError("Missing the required parameter `sourceid` when calling `patch_catalog_column`")
        # verify the required parameter 'tableid' is set
        if ('tableid' not in params) or (params['tableid'] is None):
            raise ValueError("Missing the required parameter `tableid` when calling `patch_catalog_column`")
        # verify the required parameter 'columnid' is set
        if ('columnid' not in params) or (params['columnid'] is None):
            raise ValueError("Missing the required parameter `columnid` when calling `patch_catalog_column`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_catalog_column`")


        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']
        if 'sourceid' in params:
            path_params['sourceid'] = params['sourceid']
        if 'tableid' in params:
            path_params['tableid'] = params['tableid']
        if 'columnid' in params:
            path_params['columnid'] = params['columnid']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['oauth']

        return self.api_client.call_api('/metadata/data/sources/{owner}/{sourceid}/tables/{tableid}/columns/{columnid}', 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SuccessMessage',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def patch_catalog_table(self, owner, sourceid, tableid, body, **kwargs):
        """
        Update an existing table
        Update an existing table.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_catalog_table(owner, sourceid, tableid, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str owner: id of the user or organization (required)
        :param str sourceid: database source id (required)
        :param str tableid: (required)
        :param CatalogTableRequest body: (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.patch_catalog_table_with_http_info(owner, sourceid, tableid, body, **kwargs)
        else:
            (data) = self.patch_catalog_table_with_http_info(owner, sourceid, tableid, body, **kwargs)
            return data

    def patch_catalog_table_with_http_info(self, owner, sourceid, tableid, body, **kwargs):
        """
        Update an existing table
        Update an existing table.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_catalog_table_with_http_info(owner, sourceid, tableid, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str owner: id of the user or organization (required)
        :param str sourceid: database source id (required)
        :param str tableid: (required)
        :param CatalogTableRequest body: (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'sourceid', 'tableid', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_catalog_table" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params) or (params['owner'] is None):
            raise ValueError("Missing the required parameter `owner` when calling `patch_catalog_table`")
        # verify the required parameter 'sourceid' is set
        if ('sourceid' not in params) or (params['sourceid'] is None):
            raise ValueError("Missing the required parameter `sourceid` when calling `patch_catalog_table`")
        # verify the required parameter 'tableid' is set
        if ('tableid' not in params) or (params['tableid'] is None):
            raise ValueError("Missing the required parameter `tableid` when calling `patch_catalog_table`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_catalog_table`")


        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']
        if 'sourceid' in params:
            path_params['sourceid'] = params['sourceid']
        if 'tableid' in params:
            path_params['tableid'] = params['tableid']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['oauth']

        return self.api_client.call_api('/metadata/data/sources/{owner}/{sourceid}/tables/{tableid}', 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SuccessMessage',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def replace_catalog_column(self, owner, sourceid, tableid, columnid, body, **kwargs):
        """
        Replace an existing column
        Replace an existing column
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_catalog_column(owner, sourceid, tableid, columnid, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str owner: id of the user or organization (required)
        :param str sourceid: database source id (required)
        :param str tableid: (required)
        :param str columnid: (required)
        :param CatalogColumnRequest body: (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.replace_catalog_column_with_http_info(owner, sourceid, tableid, columnid, body, **kwargs)
        else:
            (data) = self.replace_catalog_column_with_http_info(owner, sourceid, tableid, columnid, body, **kwargs)
            return data

    def replace_catalog_column_with_http_info(self, owner, sourceid, tableid, columnid, body, **kwargs):
        """
        Replace an existing column
        Replace an existing column
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_catalog_column_with_http_info(owner, sourceid, tableid, columnid, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str owner: id of the user or organization (required)
        :param str sourceid: database source id (required)
        :param str tableid: (required)
        :param str columnid: (required)
        :param CatalogColumnRequest body: (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'sourceid', 'tableid', 'columnid', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_catalog_column" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params) or (params['owner'] is None):
            raise ValueError("Missing the required parameter `owner` when calling `replace_catalog_column`")
        # verify the required parameter 'sourceid' is set
        if ('sourceid' not in params) or (params['sourceid'] is None):
            raise ValueError("Missing the required parameter `sourceid` when calling `replace_catalog_column`")
        # verify the required parameter 'tableid' is set
        if ('tableid' not in params) or (params['tableid'] is None):
            raise ValueError("Missing the required parameter `tableid` when calling `replace_catalog_column`")
        # verify the required parameter 'columnid' is set
        if ('columnid' not in params) or (params['columnid'] is None):
            raise ValueError("Missing the required parameter `columnid` when calling `replace_catalog_column`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_catalog_column`")


        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']
        if 'sourceid' in params:
            path_params['sourceid'] = params['sourceid']
        if 'tableid' in params:
            path_params['tableid'] = params['tableid']
        if 'columnid' in params:
            path_params['columnid'] = params['columnid']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['oauth']

        return self.api_client.call_api('/metadata/data/sources/{owner}/{sourceid}/tables/{tableid}/columns/{columnid}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SuccessMessage',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def replace_catalog_table(self, owner, sourceid, tableid, body, **kwargs):
        """
        Replace an existing table
        Replace an existing table
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_catalog_table(owner, sourceid, tableid, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str owner: id of the user or organization (required)
        :param str sourceid: database source id (required)
        :param str tableid: (required)
        :param CatalogTableRequest body: (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.replace_catalog_table_with_http_info(owner, sourceid, tableid, body, **kwargs)
        else:
            (data) = self.replace_catalog_table_with_http_info(owner, sourceid, tableid, body, **kwargs)
            return data

    def replace_catalog_table_with_http_info(self, owner, sourceid, tableid, body, **kwargs):
        """
        Replace an existing table
        Replace an existing table
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_catalog_table_with_http_info(owner, sourceid, tableid, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str owner: id of the user or organization (required)
        :param str sourceid: database source id (required)
        :param str tableid: (required)
        :param CatalogTableRequest body: (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'sourceid', 'tableid', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_catalog_table" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params) or (params['owner'] is None):
            raise ValueError("Missing the required parameter `owner` when calling `replace_catalog_table`")
        # verify the required parameter 'sourceid' is set
        if ('sourceid' not in params) or (params['sourceid'] is None):
            raise ValueError("Missing the required parameter `sourceid` when calling `replace_catalog_table`")
        # verify the required parameter 'tableid' is set
        if ('tableid' not in params) or (params['tableid'] is None):
            raise ValueError("Missing the required parameter `tableid` when calling `replace_catalog_table`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_catalog_table`")


        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']
        if 'sourceid' in params:
            path_params['sourceid'] = params['sourceid']
        if 'tableid' in params:
            path_params['tableid'] = params['tableid']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['oauth']

        return self.api_client.call_api('/metadata/data/sources/{owner}/{sourceid}/tables/{tableid}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SuccessMessage',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
