# coding: utf-8

"""
    data.world API

    # data.world in a nutshell  data.world is a productive, secure platform for modern data teamwork.  We bring together your data practitioners, subject matter experts, and other stakeholders by removing costly barriers to data discovery, comprehension, integration, and sharing.   Everything your team needs to quickly understand and use data stays with it.   Social features and integrations encourage collaborators to ask and answer questions, share discoveries, and coordinate closely while still using their preferred tools.  Our focus on interoperability helps you enhance your own data with data from any source, including our vast and growing library of free public datasets.   Sophisticated permissions, auditing features, and more make it easy to manage who views your data and what they do with it.  # Conventions  ## Authentication  All data.world API calls require an API token.   OAuth2 is the preferred and most secure method for authenticating users of your data.world applications. Visit our [oauth documentation](https://apidocs.data.world/toolkit/oauth) for additional information. Alternatively, you can obtain a token for _personal use or testing_ by navigating to your profile settings, under the Advanced tab ([https://data.world/settings/advanced](https://data.world/settings/advanced)).  Authentication must be provided in API requests via the `Authorization` header. For example, for a user whose API token is `my_api_token`, the request header should be `Authorization: Bearer my_api_token` (note the `Bearer` prefix).  ## Content type   By default, `application/json` is the content type used in request and response bodies. Exceptions are noted in respective endpoint documentation.  ## HTTPS only   Our APIs can only be accessed via HTTPS.  # Interested in building data.world apps?  Check out our [developer portal](https://apidocs.data.world) for tips on how to get started, tutorials, and to interact with the API endpoints right within your browser.

    OpenAPI spec version: 0.21.0
    Contact: help@data.world
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class InsightsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def create_insight(self, project_owner, project_id, **kwargs):
        """
        Create an insight
        Create a new insight.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_insight(project_owner, project_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_owner: User name and unique identifier of the creator of a project. For example, in the URL: [https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs](https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs), `government` is the unique identifier of the owner. (required)
        :param str project_id: Project unique identifier. For example, in the URL: [https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs](https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs), `how-to-add-depth-to-your-data-with-the-us-census-acs` is the unique identifier of the owner. (required)
        :param InsightCreateRequest body:
        :return: CreateInsightResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_insight_with_http_info(project_owner, project_id, **kwargs)
        else:
            (data) = self.create_insight_with_http_info(project_owner, project_id, **kwargs)
            return data

    def create_insight_with_http_info(self, project_owner, project_id, **kwargs):
        """
        Create an insight
        Create a new insight.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_insight_with_http_info(project_owner, project_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_owner: User name and unique identifier of the creator of a project. For example, in the URL: [https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs](https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs), `government` is the unique identifier of the owner. (required)
        :param str project_id: Project unique identifier. For example, in the URL: [https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs](https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs), `how-to-add-depth-to-your-data-with-the-us-census-acs` is the unique identifier of the owner. (required)
        :param InsightCreateRequest body:
        :return: CreateInsightResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_owner', 'project_id', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_insight" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_owner' is set
        if ('project_owner' not in params) or (params['project_owner'] is None):
            raise ValueError("Missing the required parameter `project_owner` when calling `create_insight`")
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params) or (params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `create_insight`")

        if 'project_owner' in params and not re.search('[a-z0-9](?:-(?!-)|[a-z0-9])+[a-z0-9]', params['project_owner']):
            raise ValueError("Invalid value for parameter `project_owner` when calling `create_insight`, must conform to the pattern `/[a-z0-9](?:-(?!-)|[a-z0-9])+[a-z0-9]/`")
        if 'project_id' in params and not re.search('[a-z0-9](?:-(?!-)|[a-z0-9])+[a-z0-9]', params['project_id']):
            raise ValueError("Invalid value for parameter `project_id` when calling `create_insight`, must conform to the pattern `/[a-z0-9](?:-(?!-)|[a-z0-9])+[a-z0-9]/`")

        collection_formats = {}

        path_params = {}
        if 'project_owner' in params:
            path_params['projectOwner'] = params['project_owner']
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['oauth']

        return self.api_client.call_api('/insights/{projectOwner}/{projectId}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CreateInsightResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_insight(self, project_owner, project_id, id, **kwargs):
        """
        Delete an insight
        Delete an insight.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_insight(project_owner, project_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_owner: User name and unique identifier of the creator of a project. For example, in the URL: [https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs](https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs), `government` is the unique identifier of the owner. (required)
        :param str project_id: Project unique identifier. For example, in the URL: [https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs](https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs), `how-to-add-depth-to-your-data-with-the-us-census-acs` is the unique identifier of the owner. (required)
        :param str id: Insight unique identifier. (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_insight_with_http_info(project_owner, project_id, id, **kwargs)
        else:
            (data) = self.delete_insight_with_http_info(project_owner, project_id, id, **kwargs)
            return data

    def delete_insight_with_http_info(self, project_owner, project_id, id, **kwargs):
        """
        Delete an insight
        Delete an insight.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_insight_with_http_info(project_owner, project_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_owner: User name and unique identifier of the creator of a project. For example, in the URL: [https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs](https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs), `government` is the unique identifier of the owner. (required)
        :param str project_id: Project unique identifier. For example, in the URL: [https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs](https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs), `how-to-add-depth-to-your-data-with-the-us-census-acs` is the unique identifier of the owner. (required)
        :param str id: Insight unique identifier. (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_owner', 'project_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_insight" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_owner' is set
        if ('project_owner' not in params) or (params['project_owner'] is None):
            raise ValueError("Missing the required parameter `project_owner` when calling `delete_insight`")
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params) or (params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `delete_insight`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_insight`")

        if 'project_owner' in params and not re.search('[a-z0-9](?:-(?!-)|[a-z0-9])+[a-z0-9]', params['project_owner']):
            raise ValueError("Invalid value for parameter `project_owner` when calling `delete_insight`, must conform to the pattern `/[a-z0-9](?:-(?!-)|[a-z0-9])+[a-z0-9]/`")
        if 'project_id' in params and not re.search('[a-z0-9](?:-(?!-)|[a-z0-9])+[a-z0-9]', params['project_id']):
            raise ValueError("Invalid value for parameter `project_id` when calling `delete_insight`, must conform to the pattern `/[a-z0-9](?:-(?!-)|[a-z0-9])+[a-z0-9]/`")

        collection_formats = {}

        path_params = {}
        if 'project_owner' in params:
            path_params['projectOwner'] = params['project_owner']
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['oauth']

        return self.api_client.call_api('/insights/{projectOwner}/{projectId}/{id}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SuccessMessage',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_insight(self, project_owner, project_id, id, **kwargs):
        """
        Retrieve an insight
        Retrieve an insight.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_insight(project_owner, project_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_owner: User name and unique identifier of the creator of a project. For example, in the URL: [https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs](https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs), `government` is the unique identifier of the owner. (required)
        :param str project_id: Project unique identifier. For example, in the URL: [https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs](https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs), `how-to-add-depth-to-your-data-with-the-us-census-acs` is the unique identifier of the owner. (required)
        :param str id: Insight unique identifier. (required)
        :return: InsightSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_insight_with_http_info(project_owner, project_id, id, **kwargs)
        else:
            (data) = self.get_insight_with_http_info(project_owner, project_id, id, **kwargs)
            return data

    def get_insight_with_http_info(self, project_owner, project_id, id, **kwargs):
        """
        Retrieve an insight
        Retrieve an insight.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_insight_with_http_info(project_owner, project_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_owner: User name and unique identifier of the creator of a project. For example, in the URL: [https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs](https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs), `government` is the unique identifier of the owner. (required)
        :param str project_id: Project unique identifier. For example, in the URL: [https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs](https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs), `how-to-add-depth-to-your-data-with-the-us-census-acs` is the unique identifier of the owner. (required)
        :param str id: Insight unique identifier. (required)
        :return: InsightSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_owner', 'project_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_insight" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_owner' is set
        if ('project_owner' not in params) or (params['project_owner'] is None):
            raise ValueError("Missing the required parameter `project_owner` when calling `get_insight`")
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params) or (params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `get_insight`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_insight`")

        if 'project_owner' in params and not re.search('[a-z0-9](?:-(?!-)|[a-z0-9])+[a-z0-9]', params['project_owner']):
            raise ValueError("Invalid value for parameter `project_owner` when calling `get_insight`, must conform to the pattern `/[a-z0-9](?:-(?!-)|[a-z0-9])+[a-z0-9]/`")
        if 'project_id' in params and not re.search('[a-z0-9](?:-(?!-)|[a-z0-9])+[a-z0-9]', params['project_id']):
            raise ValueError("Invalid value for parameter `project_id` when calling `get_insight`, must conform to the pattern `/[a-z0-9](?:-(?!-)|[a-z0-9])+[a-z0-9]/`")

        collection_formats = {}

        path_params = {}
        if 'project_owner' in params:
            path_params['projectOwner'] = params['project_owner']
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['oauth']

        return self.api_client.call_api('/insights/{projectOwner}/{projectId}/{id}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='InsightSummaryResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_insight_by_version(self, project_owner, project_id, id, version_id, **kwargs):
        """
        Retrieve an insight version
        Retrieve an insight version.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_insight_by_version(project_owner, project_id, id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_owner: User name and unique identifier of the creator of a project. For example, in the URL: [https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs](https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs), `government` is the unique identifier of the owner. (required)
        :param str project_id: Project unique identifier. For example, in the URL: [https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs](https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs), `how-to-add-depth-to-your-data-with-the-us-census-acs` is the unique identifier of the owner. (required)
        :param str id: Insight unique identifier. (required)
        :param str version_id: Version unique identifier. (required)
        :return: InsightSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_insight_by_version_with_http_info(project_owner, project_id, id, version_id, **kwargs)
        else:
            (data) = self.get_insight_by_version_with_http_info(project_owner, project_id, id, version_id, **kwargs)
            return data

    def get_insight_by_version_with_http_info(self, project_owner, project_id, id, version_id, **kwargs):
        """
        Retrieve an insight version
        Retrieve an insight version.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_insight_by_version_with_http_info(project_owner, project_id, id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_owner: User name and unique identifier of the creator of a project. For example, in the URL: [https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs](https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs), `government` is the unique identifier of the owner. (required)
        :param str project_id: Project unique identifier. For example, in the URL: [https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs](https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs), `how-to-add-depth-to-your-data-with-the-us-census-acs` is the unique identifier of the owner. (required)
        :param str id: Insight unique identifier. (required)
        :param str version_id: Version unique identifier. (required)
        :return: InsightSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_owner', 'project_id', 'id', 'version_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_insight_by_version" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_owner' is set
        if ('project_owner' not in params) or (params['project_owner'] is None):
            raise ValueError("Missing the required parameter `project_owner` when calling `get_insight_by_version`")
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params) or (params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `get_insight_by_version`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_insight_by_version`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `get_insight_by_version`")

        if 'project_owner' in params and not re.search('[a-z0-9](?:-(?!-)|[a-z0-9])+[a-z0-9]', params['project_owner']):
            raise ValueError("Invalid value for parameter `project_owner` when calling `get_insight_by_version`, must conform to the pattern `/[a-z0-9](?:-(?!-)|[a-z0-9])+[a-z0-9]/`")
        if 'project_id' in params and not re.search('[a-z0-9](?:-(?!-)|[a-z0-9])+[a-z0-9]', params['project_id']):
            raise ValueError("Invalid value for parameter `project_id` when calling `get_insight_by_version`, must conform to the pattern `/[a-z0-9](?:-(?!-)|[a-z0-9])+[a-z0-9]/`")

        collection_formats = {}

        path_params = {}
        if 'project_owner' in params:
            path_params['projectOwner'] = params['project_owner']
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']
        if 'id' in params:
            path_params['id'] = params['id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['oauth']

        return self.api_client.call_api('/insights/{projectOwner}/{projectId}/{id}/v/{versionId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='InsightSummaryResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_insights_for_project(self, project_owner, project_id, **kwargs):
        """
        List insights
        List insights associated with a project.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_insights_for_project(project_owner, project_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_owner: User name and unique identifier of the creator of a project. For example, in the URL: [https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs](https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs), `government` is the unique identifier of the owner. (required)
        :param str project_id: Project unique identifier. For example, in the URL: [https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs](https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs), `how-to-add-depth-to-your-data-with-the-us-census-acs` is the unique identifier of the owner. (required)
        :param str limit: Maximum number of items to include in a page of results.
        :param str next: Token from previous result page to be used when requesting a subsequent page.
        :return: PaginatedInsightResults
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_insights_for_project_with_http_info(project_owner, project_id, **kwargs)
        else:
            (data) = self.get_insights_for_project_with_http_info(project_owner, project_id, **kwargs)
            return data

    def get_insights_for_project_with_http_info(self, project_owner, project_id, **kwargs):
        """
        List insights
        List insights associated with a project.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_insights_for_project_with_http_info(project_owner, project_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_owner: User name and unique identifier of the creator of a project. For example, in the URL: [https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs](https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs), `government` is the unique identifier of the owner. (required)
        :param str project_id: Project unique identifier. For example, in the URL: [https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs](https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs), `how-to-add-depth-to-your-data-with-the-us-census-acs` is the unique identifier of the owner. (required)
        :param str limit: Maximum number of items to include in a page of results.
        :param str next: Token from previous result page to be used when requesting a subsequent page.
        :return: PaginatedInsightResults
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_owner', 'project_id', 'limit', 'next']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_insights_for_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_owner' is set
        if ('project_owner' not in params) or (params['project_owner'] is None):
            raise ValueError("Missing the required parameter `project_owner` when calling `get_insights_for_project`")
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params) or (params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `get_insights_for_project`")

        if 'project_owner' in params and not re.search('[a-z0-9](?:-(?!-)|[a-z0-9])+[a-z0-9]', params['project_owner']):
            raise ValueError("Invalid value for parameter `project_owner` when calling `get_insights_for_project`, must conform to the pattern `/[a-z0-9](?:-(?!-)|[a-z0-9])+[a-z0-9]/`")
        if 'project_id' in params and not re.search('[a-z0-9](?:-(?!-)|[a-z0-9])+[a-z0-9]', params['project_id']):
            raise ValueError("Invalid value for parameter `project_id` when calling `get_insights_for_project`, must conform to the pattern `/[a-z0-9](?:-(?!-)|[a-z0-9])+[a-z0-9]/`")

        collection_formats = {}

        path_params = {}
        if 'project_owner' in params:
            path_params['projectOwner'] = params['project_owner']
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'next' in params:
            query_params.append(('next', params['next']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['oauth']

        return self.api_client.call_api('/insights/{projectOwner}/{projectId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PaginatedInsightResults',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def replace_insight(self, project_owner, project_id, id, **kwargs):
        """
        Replace an insight
        Replace an insight.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_insight(project_owner, project_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_owner: User name and unique identifier of the creator of a project. For example, in the URL: [https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs](https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs), `government` is the unique identifier of the owner. (required)
        :param str project_id: Project unique identifier. For example, in the URL: [https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs](https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs), `how-to-add-depth-to-your-data-with-the-us-census-acs` is the unique identifier of the owner. (required)
        :param str id: Insight unique identifier. (required)
        :param InsightPutRequest body:
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.replace_insight_with_http_info(project_owner, project_id, id, **kwargs)
        else:
            (data) = self.replace_insight_with_http_info(project_owner, project_id, id, **kwargs)
            return data

    def replace_insight_with_http_info(self, project_owner, project_id, id, **kwargs):
        """
        Replace an insight
        Replace an insight.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_insight_with_http_info(project_owner, project_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_owner: User name and unique identifier of the creator of a project. For example, in the URL: [https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs](https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs), `government` is the unique identifier of the owner. (required)
        :param str project_id: Project unique identifier. For example, in the URL: [https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs](https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs), `how-to-add-depth-to-your-data-with-the-us-census-acs` is the unique identifier of the owner. (required)
        :param str id: Insight unique identifier. (required)
        :param InsightPutRequest body:
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_owner', 'project_id', 'id', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_insight" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_owner' is set
        if ('project_owner' not in params) or (params['project_owner'] is None):
            raise ValueError("Missing the required parameter `project_owner` when calling `replace_insight`")
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params) or (params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `replace_insight`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `replace_insight`")

        if 'project_owner' in params and not re.search('[a-z0-9](?:-(?!-)|[a-z0-9])+[a-z0-9]', params['project_owner']):
            raise ValueError("Invalid value for parameter `project_owner` when calling `replace_insight`, must conform to the pattern `/[a-z0-9](?:-(?!-)|[a-z0-9])+[a-z0-9]/`")
        if 'project_id' in params and not re.search('[a-z0-9](?:-(?!-)|[a-z0-9])+[a-z0-9]', params['project_id']):
            raise ValueError("Invalid value for parameter `project_id` when calling `replace_insight`, must conform to the pattern `/[a-z0-9](?:-(?!-)|[a-z0-9])+[a-z0-9]/`")

        collection_formats = {}

        path_params = {}
        if 'project_owner' in params:
            path_params['projectOwner'] = params['project_owner']
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['oauth']

        return self.api_client.call_api('/insights/{projectOwner}/{projectId}/{id}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SuccessMessage',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_insight(self, project_owner, project_id, id, **kwargs):
        """
        Update an insight
        Update an insight. Note that only elements included in the request will be updated. All omitted elements will remain untouched.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_insight(project_owner, project_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_owner: User name and unique identifier of the creator of a project. For example, in the URL: [https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs](https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs), `government` is the unique identifier of the owner. (required)
        :param str project_id: Project unique identifier. For example, in the URL: [https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs](https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs), `how-to-add-depth-to-your-data-with-the-us-census-acs` is the unique identifier of the owner. (required)
        :param str id: Insight unique identifier. (required)
        :param InsightPatchRequest body:
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_insight_with_http_info(project_owner, project_id, id, **kwargs)
        else:
            (data) = self.update_insight_with_http_info(project_owner, project_id, id, **kwargs)
            return data

    def update_insight_with_http_info(self, project_owner, project_id, id, **kwargs):
        """
        Update an insight
        Update an insight. Note that only elements included in the request will be updated. All omitted elements will remain untouched.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_insight_with_http_info(project_owner, project_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_owner: User name and unique identifier of the creator of a project. For example, in the URL: [https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs](https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs), `government` is the unique identifier of the owner. (required)
        :param str project_id: Project unique identifier. For example, in the URL: [https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs](https://data.world/government/how-to-add-depth-to-your-data-with-the-us-census-acs), `how-to-add-depth-to-your-data-with-the-us-census-acs` is the unique identifier of the owner. (required)
        :param str id: Insight unique identifier. (required)
        :param InsightPatchRequest body:
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_owner', 'project_id', 'id', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_insight" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_owner' is set
        if ('project_owner' not in params) or (params['project_owner'] is None):
            raise ValueError("Missing the required parameter `project_owner` when calling `update_insight`")
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params) or (params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `update_insight`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_insight`")

        if 'project_owner' in params and not re.search('[a-z0-9](?:-(?!-)|[a-z0-9])+[a-z0-9]', params['project_owner']):
            raise ValueError("Invalid value for parameter `project_owner` when calling `update_insight`, must conform to the pattern `/[a-z0-9](?:-(?!-)|[a-z0-9])+[a-z0-9]/`")
        if 'project_id' in params and not re.search('[a-z0-9](?:-(?!-)|[a-z0-9])+[a-z0-9]', params['project_id']):
            raise ValueError("Invalid value for parameter `project_id` when calling `update_insight`, must conform to the pattern `/[a-z0-9](?:-(?!-)|[a-z0-9])+[a-z0-9]/`")

        collection_formats = {}

        path_params = {}
        if 'project_owner' in params:
            path_params['projectOwner'] = params['project_owner']
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['oauth']

        return self.api_client.call_api('/insights/{projectOwner}/{projectId}/{id}', 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SuccessMessage',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
