# Destacks Powertables

Link: [github.com/destacks/powertables](https://github.com/destacks/powertables)

## About

Destacks Powertables is a sortable filter table implementation for the Django web
framework.

## Project State

This project is in the early stages and might be subject to breaking changes until it
reaches its 1.0-release.

## License

This project is licensed under dual Free Software (AGPL v3+) and commercial license. If
you want to obtain a commercial license, please write to: info@destacks.com

If you want to read the AGPL license text, please look at the file `LICENSE.AGPL.txt` in
the root folder of this project.

## Versions

The source code in the Free Software AGPL v3+ and commercial license is the same and
does not differ concerning its features. Just the licensing is different; this will
never change.

## Installation

1. Install the app from PyPI:

   ```bash
   pip install django-powertables
   ```

2. Add the `powertables` app to your `INSTALLED_APPS` list:

   ```python
   INSTALLED_APPS = [
       # ...
       "powertables",
   ]
   ```

## Usage

Please look at the example project in the `example` folder on how to use this project.

## Contributing

If you contribute to this project, you agree that we have the right to license your
contribution under the AGPL v3+, a commercial license, and eventually later release it
into the public domain.

## Supporting the Community

Five percent of all gross revenue of this project will be donated to the Django Software
Foundation (later, we might add more projects and organizations).

## Future-Proofing

If this project reaches its EOL and will not be continued in any other form (that keeps
the intent of the terms in this readme), we will release all source code into the public
domain.

## Changes

We might adjust or clarify some text concerning the terms of this project, but only
under the condition that the original intent is kept.

## Merging of Code

This project might be merged with other projects by us in the future, but only if the
conditions of the above sections are kept in the merged project.

## Extraction of Code

Parts of this project might be extracted and used in other projects by us in the future,
but only if the conditions of the above sections are kept in the other projects.

## Affiliation (or lack thereof)

This project is independent and not endorsed by or affiliated with the Django Software
Foundation. Django is a registered trademark of the Django Software Foundation.

## Outlook

Destacks Powertables might be extended to be used with other frameworks and programming
languages in the future.
