Markdown documentation created by [pyLODE](http://github.com/rdflib/pyLODE) 

# ISO19115-1 CI_RoleCode Codelist
### A taxonomy

## Metadata
* **URI**
  * `http://linked.data.gov.au/def/iso19115-1/RoleCode`
* **Publisher(s)**
  * [Geological Survey of Queensland](http://linked.data.gov.au/org/gsq)
* **Creators(s)**
  * International Organization for Standardization
* **Created**
  * 2019-09-18
* **Modified**
  * 2020-01-10
* **Source**
  * [https://standards.iso.org/iso/19115/resources/Codelists/gml/CI_RoleCode.xml](https://standards.iso.org/iso/19115/resources/Codelists/gml/CI_RoleCode.xml)

* **Taxonomy RDF**
  * RDF ([iso19115-1-RoleCodes.ttl](turtle))
### Description
<p>A SKOS version of the ISO 19115-1 CI_RoleCode Codelist.
    These roles are the roles of parties (Agents) with respect to datasets (Entities). They are taken from the international standard ISO19115-1:2014 Geographic information - Metadata - Part 1: Fundamentals.
    From ISO19115-1:2014, Table B.16.1 - Responsible party information on page 91 lists properties of the CI_Responsibility class which is 'information about the party and their role'. The 'role' property, indicating a value from the CI_RoleCode codelist - the source of this vocabulary - is described as the 'function performed by the responsible party'.</p>


## Table of Contents
1. [Object Concepts](#concepts)
1. [Namespaces](#namespaces)
1. [Legend](#legend)


## Overview

**Figure 1:** Ontology overview
## Concepts
* [Author](http://linked.data.gov.au/def/iso19115-1/RoleCode/author)
* [Co-author](http://linked.data.gov.au/def/iso19115-1/RoleCode/coAuthor)
* [Collaborator](http://linked.data.gov.au/def/iso19115-1/RoleCode/collaborator)
* [Contributor](http://linked.data.gov.au/def/iso19115-1/RoleCode/contributor)
* [Custodian](http://linked.data.gov.au/def/iso19115-1/RoleCode/custodian)
* [Distributor](http://linked.data.gov.au/def/iso19115-1/RoleCode/distributor)
* [Editor](http://linked.data.gov.au/def/iso19115-1/RoleCode/editor)
* [Funder](http://linked.data.gov.au/def/iso19115-1/RoleCode/funder)
* [Mediator](http://linked.data.gov.au/def/iso19115-1/RoleCode/mediator)
* [Originator](http://linked.data.gov.au/def/iso19115-1/RoleCode/originator)
* [Owner](http://linked.data.gov.au/def/iso19115-1/RoleCode/owner)
* [Point Of Contact](http://linked.data.gov.au/def/iso19115-1/RoleCode/pointOfContact)
* [Principal Investigator](http://linked.data.gov.au/def/iso19115-1/RoleCode/principalInvestigator)
* [Processor](http://linked.data.gov.au/def/iso19115-1/RoleCode/processor)
* [Publisher](http://linked.data.gov.au/def/iso19115-1/RoleCode/publisher)
* [Resource Provider](http://linked.data.gov.au/def/iso19115-1/RoleCode/resourceProvider)
* [Rights Holder](http://linked.data.gov.au/def/iso19115-1/RoleCode/rightsHolder)
* [Sponsor](http://linked.data.gov.au/def/iso19115-1/RoleCode/sponsor)
* [Stakeholder](http://linked.data.gov.au/def/iso19115-1/RoleCode/stakeholder)
* [User](http://linked.data.gov.au/def/iso19115-1/RoleCode/user)

### Author
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/iso19115-1/RoleCode/author`
Preferred Labels |Author (en)<br />
Definitions |['Party who authored the resource']<br />
### Co-author
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/iso19115-1/RoleCode/coAuthor`
Preferred Labels |Co-author (en)<br />
Definitions |['Party who jointly authors the resource']<br />
### Collaborator
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/iso19115-1/RoleCode/collaborator`
Preferred Labels |Collaborator (en)<br />
Definitions |['Party who assists with the generation of the resource other than the principal investigator']<br />
### Contributor
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/iso19115-1/RoleCode/contributor`
Preferred Labels |Contributor (en)<br />
Definitions |['Party contributing to the resource']<br />
### Custodian
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/iso19115-1/RoleCode/custodian`
Preferred Labels |Custodian (en)<br />
Definitions |['Party that accepts accountability and responsibility for the resource and ensures appropriate care and maintenance of the resource']<br />
### Distributor
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/iso19115-1/RoleCode/distributor`
Preferred Labels |Distributor (en)<br />
Definitions |['Party who distributes the resource']<br />
### Editor
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/iso19115-1/RoleCode/editor`
Preferred Labels |Editor (en)<br />
Definitions |['Party who reviewed or modified the resource to improve the content']<br />
### Funder
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/iso19115-1/RoleCode/funder`
Preferred Labels |Funder (en)<br />
Definitions |['Party providing monetary support for the resource']<br />
### Mediator
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/iso19115-1/RoleCode/mediator`
Preferred Labels |Mediator (en)<br />
Definitions |['A class of entity that mediates access to the resource and for whom the resource is intended or useful']<br />
### Originator
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/iso19115-1/RoleCode/originator`
Preferred Labels |Originator (en)<br />
Definitions |['Party who created the resource']<br />
### Owner
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/iso19115-1/RoleCode/owner`
Preferred Labels |Owner (en)<br />
Definitions |['Party that owns the resource']<br />
### Point Of Contact
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/iso19115-1/RoleCode/pointOfContact`
Preferred Labels |Point Of Contact (en)<br />
Definitions |['Party who can be contacted for acquiring knowledge about or acquisition of the resource']<br />
### Principal Investigator
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/iso19115-1/RoleCode/principalInvestigator`
Preferred Labels |Principal Investigator (en)<br />
Definitions |['Key party responsible for gathering information and conducting research']<br />
### Processor
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/iso19115-1/RoleCode/processor`
Preferred Labels |Processor (en)<br />
Definitions |['Party who has processed the data in a manner such that the resource has been modified']<br />
### Publisher
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/iso19115-1/RoleCode/publisher`
Preferred Labels |Publisher (en)<br />
Definitions |['Party who published the resource']<br />
### Resource Provider
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/iso19115-1/RoleCode/resourceProvider`
Preferred Labels |Resource Provider (en)<br />
Definitions |['Party that supplies the resource']<br />
### Rights Holder
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/iso19115-1/RoleCode/rightsHolder`
Preferred Labels |Rights Holder (en)<br />
Definitions |['Party owning or managing rights over the resource']<br />
### Sponsor
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/iso19115-1/RoleCode/sponsor`
Preferred Labels |Sponsor (en)<br />
Definitions |['Party who speaks for the resource']<br />
### Stakeholder
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/iso19115-1/RoleCode/stakeholder`
Preferred Labels |Stakeholder (en)<br />
Definitions |['Party who has an interest in the resource or the use of the resource']<br />
### User
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/iso19115-1/RoleCode/user`
Preferred Labels |User (en)<br />
Definitions |['Party who uses the resource']<br />

## Namespaces
* **dct**
  * `http://purl.org/dc/terms/`
* **owl**
  * `http://www.w3.org/2002/07/owl#`
* **rdf**
  * `http://www.w3.org/1999/02/22-rdf-syntax-ns#`
* **rdfs**
  * `http://www.w3.org/2000/01/rdf-schema#`
* **sdo**
  * `https://schema.org/`
* **skos**
  * `http://www.w3.org/2004/02/skos/core#`
* **xsd**
  * `http://www.w3.org/2001/XMLSchema#`

## Legend
* Collections: cl
* Concepts: cp