Markdown documentation created by [pyLODE](http://github.com/rdflib/pyLODE) 

# Earth Science Data Category
### A taxonomy

## Metadata
* **URI**
  * `http://linked.data.gov.au/def/earth-science-data-category`
* **Publisher(s)**
  * [Geological Survey of Queensland](http://linked.data.gov.au/org/gsq)
* **Creators(s)**
  * [Geological Survey of Queensland](http://linked.data.gov.au/org/gsq)
* **Created**
  * 2019-09-06T08:17:57
* **Modified**
  * 2019-09-11T08:46:46
* **Source**
  * Modified from the Fields of Research vocabulary from the Australian and New Zealand Standard Research Classification (ANZSRC). Relevant earth science categories have been extracted and augmented with narrower terms relevant for industry and research institutions.

* **Taxonomy RDF**
  * RDF ([earth-science-data-category.ttl](turtle))
### Description
<p>A classification that facilitates identification of the Fields of Research, or topics, to which a dataset, activity, or entity pertain.</p>


## Table of Contents
1. [Object Concepts](#concepts)
1. [Namespaces](#namespaces)
1. [Legend](#legend)


## Overview

**Figure 1:** Ontology overview
## Concepts
* [Airborne Spectral](http://linked.data.gov.au/def/earth-science-data-category/airborne-spectral)
* [Atmospheric Sciences](http://linked.data.gov.au/def/earth-science-data-category/atmospheric-sciences)
* [Atmospheric Sciences](http://linked.data.gov.au/def/earth-science-data-category/atmospheric-sciences)
* [Basin Analysis](http://linked.data.gov.au/def/earth-science-data-category/basin-analysis)
* [Biological Sciences](http://linked.data.gov.au/def/earth-science-data-category/biological-sciences)
	* [Ecology](http://linked.data.gov.au/def/earth-science-data-category/ecology)
* [Biological Sciences](http://linked.data.gov.au/def/earth-science-data-category/biological-sciences)
	* [Ecology](http://linked.data.gov.au/def/earth-science-data-category/ecology)
* [Core Spectral](http://linked.data.gov.au/def/earth-science-data-category/core-spectral)
* [Demography](http://linked.data.gov.au/def/earth-science-data-category/demography)
* [Demography](http://linked.data.gov.au/def/earth-science-data-category/demography)
* [Ecology](http://linked.data.gov.au/def/earth-science-data-category/ecology)
* [Electrical and Electromagnetic Methods in Geophysics](http://linked.data.gov.au/def/earth-science-data-category/electrical-and-electromagnetic-methods-in-geophysics)
	* [Electrical Geophysics](http://linked.data.gov.au/def/earth-science-data-category/electrical-geophysics)
* [Electrical Geophysics](http://linked.data.gov.au/def/earth-science-data-category/electrical-geophysics)
* [Engineering](http://linked.data.gov.au/def/earth-science-data-category/engineering)
	* [Environmental Engineering](http://linked.data.gov.au/def/earth-science-data-category/environmental-engineering)
	* [Geomechanics and Resources Geotechnical Engineering](http://linked.data.gov.au/def/earth-science-data-category/geomechanics-and-resources-geotechnical-engineering)
* [Engineering](http://linked.data.gov.au/def/earth-science-data-category/engineering)
	* [Environmental Engineering](http://linked.data.gov.au/def/earth-science-data-category/environmental-engineering)
	* [Geomechanics and Resources Geotechnical Engineering](http://linked.data.gov.au/def/earth-science-data-category/geomechanics-and-resources-geotechnical-engineering)
* [Environmental Engineering](http://linked.data.gov.au/def/earth-science-data-category/environmental-engineering)
* [Environmental Sciences](http://linked.data.gov.au/def/earth-science-data-category/environmental-sciences)
* [Environmental Sciences](http://linked.data.gov.au/def/earth-science-data-category/environmental-sciences)
* [Extract Geochemistry](http://linked.data.gov.au/def/earth-science-data-category/extract-geochemistry)
* [Extraterrestrial Geology](http://linked.data.gov.au/def/earth-science-data-category/extraterrestrial-geology)
* [Geochemistry](http://linked.data.gov.au/def/earth-science-data-category/geochemistry)
	* [Extract Geochemistry](http://linked.data.gov.au/def/earth-science-data-category/extract-geochemistry)
	* [Geochemistry Not Elsewhere Classified](http://linked.data.gov.au/def/earth-science-data-category/geochemistry-not-elsewhere-classified)
	* [Inorganic Geochemistry](http://linked.data.gov.au/def/earth-science-data-category/inorganic-geochemistry)
	* [Isotope Geochemistry](http://linked.data.gov.au/def/earth-science-data-category/isotope-geochemistry)
	* [Organic Geochemistry](http://linked.data.gov.au/def/earth-science-data-category/organic-geochemistry)
* [Geochemistry Not Elsewhere Classified](http://linked.data.gov.au/def/earth-science-data-category/geochemistry-not-elsewhere-classified)
* [Geochronology](http://linked.data.gov.au/def/earth-science-data-category/geochronology)
* [Geodynamics](http://linked.data.gov.au/def/earth-science-data-category/geodynamics)
* [Geology](http://linked.data.gov.au/def/earth-science-data-category/geology)
	* [Basin Analysis](http://linked.data.gov.au/def/earth-science-data-category/basin-analysis)
	* [Extraterrestrial Geology](http://linked.data.gov.au/def/earth-science-data-category/extraterrestrial-geology)
	* [Geochronology](http://linked.data.gov.au/def/earth-science-data-category/geochronology)
	* [Geology Not Elsewhere Classified](http://linked.data.gov.au/def/earth-science-data-category/geology-not-elsewhere-classified)
	* [Geomechanics](http://linked.data.gov.au/def/earth-science-data-category/geomechanics)
	* [Marine Geoscience](http://linked.data.gov.au/def/earth-science-data-category/marine-geoscience)
	* [Mineralogy and Crystallography](http://linked.data.gov.au/def/earth-science-data-category/mineralogy-and-crystallography)
	* [Palaeontology](http://linked.data.gov.au/def/earth-science-data-category/palaeontology)
		* [Ichnology](http://linked.data.gov.au/def/earth-science-data-category/ichnology)
		* [Invertebrate Palaeontology](http://linked.data.gov.au/def/earth-science-data-category/invertebrate-palaeontology)
		* [Palaeobotany](http://linked.data.gov.au/def/earth-science-data-category/palaeobotany)
		* [Palynology](http://linked.data.gov.au/def/earth-science-data-category/palynology)
		* [Vertebrate Palaeontology](http://linked.data.gov.au/def/earth-science-data-category/vertebrate-palaeontology)
	* [Petroleum and Coal Geology](http://linked.data.gov.au/def/earth-science-data-category/petroleum-and-coal-geology)
		* [Reservoir Geology](http://linked.data.gov.au/def/earth-science-data-category/reservoir-geology)
	* [Petrology](http://linked.data.gov.au/def/earth-science-data-category/petrology)
		* [Igneous and Metamorphic Petrology](http://linked.data.gov.au/def/earth-science-data-category/igneous-and-metamorphic-petrology)
		* [Organic Petrology](http://linked.data.gov.au/def/earth-science-data-category/organic-petrology)
		* [Sedimentary Petrology](http://linked.data.gov.au/def/earth-science-data-category/sedimentary-petrology)
	* [Resource Geology](http://linked.data.gov.au/def/earth-science-data-category/resource-geology)
		* [Hydrocarbon Occurrences](http://linked.data.gov.au/def/earth-science-data-category/hydrocarbon-occurrences)
		* [Mineral Occurrences](http://linked.data.gov.au/def/earth-science-data-category/mineral-occurrences)
		* [Quarry Resources](http://linked.data.gov.au/def/earth-science-data-category/quarry-resources)
	* [Sedimentology](http://linked.data.gov.au/def/earth-science-data-category/sedimentology)
	* [Stratigraphy](http://linked.data.gov.au/def/earth-science-data-category/stratigraphy)
	* [Structural Geology](http://linked.data.gov.au/def/earth-science-data-category/structural-geology)
	* [Tectonics](http://linked.data.gov.au/def/earth-science-data-category/tectonics)
	* [Volcanology](http://linked.data.gov.au/def/earth-science-data-category/volcanology)
* [Geology Not Elsewhere Classified](http://linked.data.gov.au/def/earth-science-data-category/geology-not-elsewhere-classified)
* [Geomechanics](http://linked.data.gov.au/def/earth-science-data-category/geomechanics)
* [Geomechanics and Resources Geotechnical Engineering](http://linked.data.gov.au/def/earth-science-data-category/geomechanics-and-resources-geotechnical-engineering)
* [Geomorphology And Regolith And Landscape Evolution](http://linked.data.gov.au/def/earth-science-data-category/geomorphology-and-regolith-and-landscape-evolution)
* [Geophysical Fluid Dynamics](http://linked.data.gov.au/def/earth-science-data-category/geophysical-fluid-dynamics)
* [Geophysics](http://linked.data.gov.au/def/earth-science-data-category/geophysics)
	* [Electrical and Electromagnetic Methods in Geophysics](http://linked.data.gov.au/def/earth-science-data-category/electrical-and-electromagnetic-methods-in-geophysics)
		* [Electrical Geophysics](http://linked.data.gov.au/def/earth-science-data-category/electrical-geophysics)
	* [Geodynamics](http://linked.data.gov.au/def/earth-science-data-category/geodynamics)
	* [Geophysical Fluid Dynamics](http://linked.data.gov.au/def/earth-science-data-category/geophysical-fluid-dynamics)
	* [Geophysics Not Elsewhere Classified](http://linked.data.gov.au/def/earth-science-data-category/geophysics-not-elsewhere-classified)
	* [Geothermics and Radiometrics](http://linked.data.gov.au/def/earth-science-data-category/geothermics-and-radiometrics)
	* [Gravity](http://linked.data.gov.au/def/earth-science-data-category/gravity)
	* [Magnetics](http://linked.data.gov.au/def/earth-science-data-category/magnetics)
	* [Petrophysics](http://linked.data.gov.au/def/earth-science-data-category/petrophysics)
	* [Seismology and Seismic Exploration](http://linked.data.gov.au/def/earth-science-data-category/seismology-and-seismic-exploration)
		* [Seismic Surveys](http://linked.data.gov.au/def/earth-science-data-category/seismic-surveys)
			* [Passive Seismic](http://linked.data.gov.au/def/earth-science-data-category/passive-seismic)
	* [Spectral Imaging](http://linked.data.gov.au/def/earth-science-data-category/spectral-imaging)
		* [Airborne Spectral](http://linked.data.gov.au/def/earth-science-data-category/airborne-spectral)
		* [Core Spectral](http://linked.data.gov.au/def/earth-science-data-category/core-spectral)
		* [Satellite Spectral](http://linked.data.gov.au/def/earth-science-data-category/satellite-spectral)
* [Geophysics Not Elsewhere Classified](http://linked.data.gov.au/def/earth-science-data-category/geophysics-not-elsewhere-classified)
* [Geothermics and Radiometrics](http://linked.data.gov.au/def/earth-science-data-category/geothermics-and-radiometrics)
* [Glaciology](http://linked.data.gov.au/def/earth-science-data-category/glaciology)
* [Gravity](http://linked.data.gov.au/def/earth-science-data-category/gravity)
* [Hydrocarbon Occurrences](http://linked.data.gov.au/def/earth-science-data-category/hydrocarbon-occurrences)
* [Hydrogeochemistry](http://linked.data.gov.au/def/earth-science-data-category/hydrogeochemistry)
* [Hydrogeology](http://linked.data.gov.au/def/earth-science-data-category/hydrogeology)
* [Ichnology](http://linked.data.gov.au/def/earth-science-data-category/ichnology)
* [Igneous and Metamorphic Petrology](http://linked.data.gov.au/def/earth-science-data-category/igneous-and-metamorphic-petrology)
* [Inorganic Geochemistry](http://linked.data.gov.au/def/earth-science-data-category/inorganic-geochemistry)
* [Invertebrate Palaeontology](http://linked.data.gov.au/def/earth-science-data-category/invertebrate-palaeontology)
* [Isotope Geochemistry](http://linked.data.gov.au/def/earth-science-data-category/isotope-geochemistry)
* [Magnetics](http://linked.data.gov.au/def/earth-science-data-category/magnetics)
* [Marine Geoscience](http://linked.data.gov.au/def/earth-science-data-category/marine-geoscience)
* [Mineral Occurrences](http://linked.data.gov.au/def/earth-science-data-category/mineral-occurrences)
* [Mineralogy and Crystallography](http://linked.data.gov.au/def/earth-science-data-category/mineralogy-and-crystallography)
* [Natural Hazards](http://linked.data.gov.au/def/earth-science-data-category/natural-hazards)
* [Organic Geochemistry](http://linked.data.gov.au/def/earth-science-data-category/organic-geochemistry)
* [Organic Petrology](http://linked.data.gov.au/def/earth-science-data-category/organic-petrology)
* [Palaeobotany](http://linked.data.gov.au/def/earth-science-data-category/palaeobotany)
* [Palaeoclimatology](http://linked.data.gov.au/def/earth-science-data-category/palaeoclimatology)
* [Palaeontology](http://linked.data.gov.au/def/earth-science-data-category/palaeontology)
	* [Ichnology](http://linked.data.gov.au/def/earth-science-data-category/ichnology)
	* [Invertebrate Palaeontology](http://linked.data.gov.au/def/earth-science-data-category/invertebrate-palaeontology)
	* [Palaeobotany](http://linked.data.gov.au/def/earth-science-data-category/palaeobotany)
	* [Palynology](http://linked.data.gov.au/def/earth-science-data-category/palynology)
	* [Vertebrate Palaeontology](http://linked.data.gov.au/def/earth-science-data-category/vertebrate-palaeontology)
* [Palynology](http://linked.data.gov.au/def/earth-science-data-category/palynology)
* [Passive Seismic](http://linked.data.gov.au/def/earth-science-data-category/passive-seismic)
* [Petroleum and Coal Geology](http://linked.data.gov.au/def/earth-science-data-category/petroleum-and-coal-geology)
	* [Reservoir Geology](http://linked.data.gov.au/def/earth-science-data-category/reservoir-geology)
* [Petrology](http://linked.data.gov.au/def/earth-science-data-category/petrology)
	* [Igneous and Metamorphic Petrology](http://linked.data.gov.au/def/earth-science-data-category/igneous-and-metamorphic-petrology)
	* [Organic Petrology](http://linked.data.gov.au/def/earth-science-data-category/organic-petrology)
	* [Sedimentary Petrology](http://linked.data.gov.au/def/earth-science-data-category/sedimentary-petrology)
* [Petrophysics](http://linked.data.gov.au/def/earth-science-data-category/petrophysics)
* [Physical Geography](http://linked.data.gov.au/def/earth-science-data-category/physical-geography)
	* [Geomorphology And Regolith And Landscape Evolution](http://linked.data.gov.au/def/earth-science-data-category/geomorphology-and-regolith-and-landscape-evolution)
	* [Glaciology](http://linked.data.gov.au/def/earth-science-data-category/glaciology)
	* [Hydrogeology](http://linked.data.gov.au/def/earth-science-data-category/hydrogeology)
	* [Natural Hazards](http://linked.data.gov.au/def/earth-science-data-category/natural-hazards)
	* [Palaeoclimatology](http://linked.data.gov.au/def/earth-science-data-category/palaeoclimatology)
	* [Physical Geography And Environmental Geoscience Not Elsewhere Classified](http://linked.data.gov.au/def/earth-science-data-category/physical-geography-and-environmental-geoscience-not-elsewhere-classified)
	* [Quaternary Environments](http://linked.data.gov.au/def/earth-science-data-category/quaternary-environments)
	* [Surface Processes](http://linked.data.gov.au/def/earth-science-data-category/surface-processes)
	* [Surfacewater Hydrology](http://linked.data.gov.au/def/earth-science-data-category/surfacewater-hydrology)
* [Physical Geography And Environmental Geoscience Not Elsewhere Classified](http://linked.data.gov.au/def/earth-science-data-category/physical-geography-and-environmental-geoscience-not-elsewhere-classified)
* [Quarry Resources](http://linked.data.gov.au/def/earth-science-data-category/quarry-resources)
* [Quaternary Environments](http://linked.data.gov.au/def/earth-science-data-category/quaternary-environments)
* [Reservoir Geology](http://linked.data.gov.au/def/earth-science-data-category/reservoir-geology)
* [Resource Geology](http://linked.data.gov.au/def/earth-science-data-category/resource-geology)
	* [Hydrocarbon Occurrences](http://linked.data.gov.au/def/earth-science-data-category/hydrocarbon-occurrences)
	* [Mineral Occurrences](http://linked.data.gov.au/def/earth-science-data-category/mineral-occurrences)
	* [Quarry Resources](http://linked.data.gov.au/def/earth-science-data-category/quarry-resources)
* [Satellite Spectral](http://linked.data.gov.au/def/earth-science-data-category/satellite-spectral)
* [Sedimentary Petrology](http://linked.data.gov.au/def/earth-science-data-category/sedimentary-petrology)
* [Sedimentology](http://linked.data.gov.au/def/earth-science-data-category/sedimentology)
* [Seismic Surveys](http://linked.data.gov.au/def/earth-science-data-category/seismic-surveys)
	* [Passive Seismic](http://linked.data.gov.au/def/earth-science-data-category/passive-seismic)
* [Seismology and Seismic Exploration](http://linked.data.gov.au/def/earth-science-data-category/seismology-and-seismic-exploration)
	* [Seismic Surveys](http://linked.data.gov.au/def/earth-science-data-category/seismic-surveys)
		* [Passive Seismic](http://linked.data.gov.au/def/earth-science-data-category/passive-seismic)
* [Spectral Imaging](http://linked.data.gov.au/def/earth-science-data-category/spectral-imaging)
	* [Airborne Spectral](http://linked.data.gov.au/def/earth-science-data-category/airborne-spectral)
	* [Core Spectral](http://linked.data.gov.au/def/earth-science-data-category/core-spectral)
	* [Satellite Spectral](http://linked.data.gov.au/def/earth-science-data-category/satellite-spectral)
* [Stratigraphy](http://linked.data.gov.au/def/earth-science-data-category/stratigraphy)
* [Structural Geology](http://linked.data.gov.au/def/earth-science-data-category/structural-geology)
* [Surface Processes](http://linked.data.gov.au/def/earth-science-data-category/surface-processes)
* [Surfacewater Hydrology](http://linked.data.gov.au/def/earth-science-data-category/surfacewater-hydrology)
* [Tectonics](http://linked.data.gov.au/def/earth-science-data-category/tectonics)
* [Vertebrate Palaeontology](http://linked.data.gov.au/def/earth-science-data-category/vertebrate-palaeontology)
* [Volcanology](http://linked.data.gov.au/def/earth-science-data-category/volcanology)

### Airborne Spectral
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/airborne-spectral`
Preferred Labels |Airborne Spectral (en)<br />
Definitions |['Remotely sensed spectral imaging obtained from an airborne platform.']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/spectral-imaging](http://linked.data.gov.au/def/earth-science-data-category/spectral-imaging) (cp)<br />
### Atmospheric Sciences
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/atmospheric-sciences`
Preferred Labels |Atmospheric Sciences (en)<br />
Definitions |["The study of the Earth's atmosphere and its various inner-working physical processes."]<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/0401](http://purl.org/au-research/vocabulary/anzsrc-for/2008/0401) (cp)<br />
### Basin Analysis
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/basin-analysis`
Preferred Labels |Basin Analysis (en)<br />
Alternate Labels |sedimentary basin analysis<br />
Definitions |['a geologic method by which the history of a sedimentary basin is revealed, by analyzing the sediment fill itself. Aspects of the sediment, namely its composition, primary structures, and internal architecture, can be synthesized into a history of the basin fill. Source:Wikipedia']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geology](http://linked.data.gov.au/def/earth-science-data-category/geology) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040301](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040301) (cp)<br />
### Biological Sciences
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/biological-sciences`
Preferred Labels |Biological Sciences (en)<br />
Definitions |['The natural science that studies life and living organisms, including their physical structure, chemical processes, molecular interactions, physiological mechanisms, development and evolution.']<br />
Narrower Concepts |[http://linked.data.gov.au/def/earth-science-data-category/ecology](http://linked.data.gov.au/def/earth-science-data-category/ecology) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/06](http://purl.org/au-research/vocabulary/anzsrc-for/2008/06) (cp)<br />
### Core Spectral
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/core-spectral`
Preferred Labels |Core Spectral (en)<br />
Definitions |['Spectral imaging (typically hyperspectral) of rock samples such as core.']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/spectral-imaging](http://linked.data.gov.au/def/earth-science-data-category/spectral-imaging) (cp)<br />
### Demography
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/demography`
Preferred Labels |Demography (en)<br />
Definitions |['The statistical study of populations, especially human beings.']<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/1603](http://purl.org/au-research/vocabulary/anzsrc-for/2008/1603) (cp)<br />
### Ecology
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/ecology`
Preferred Labels |Ecology (en)<br />
Definitions |['A branch of biology concerning interactions among organisms and their biophysical environment, which includes both biotic and abiotic components.']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/biological-sciences](http://linked.data.gov.au/def/earth-science-data-category/biological-sciences) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/0602](http://purl.org/au-research/vocabulary/anzsrc-for/2008/0602) (cp)<br />
### Electrical and Electromagnetic Methods in Geophysics
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/electrical-and-electromagnetic-methods-in-geophysics`
Preferred Labels |Electrical and Electromagnetic Methods in Geophysics (en)<br />
Definitions |['Geophysical methods based on electrical and electromagnetic phenomena that respond to the electrical properties of the subsurface. Source: Cambridge.org']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geophysics](http://linked.data.gov.au/def/earth-science-data-category/geophysics) (cp)<br />
Narrower Concepts |[http://linked.data.gov.au/def/earth-science-data-category/electrical-geophysics](http://linked.data.gov.au/def/earth-science-data-category/electrical-geophysics) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040401](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040401) (cp)<br />
### Electrical Geophysics
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/electrical-geophysics`
Preferred Labels |Electrical Geophysics (en)<br />
Definitions |['There are a variety of different electrical methods that used to image different electrical properties of the subsurface. The Resistivity technique is used to determine the resistivity of subsurface materials, the Induced Polarization (IP) technique is used to measure the decay of voltage in the ground, and the Self Potential (SP) technique looks for natural voltage sources underground. Source: Dept. Energy and Mining, Gov. of S.A.']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/electrical-and-electromagnetic-methods-in-geophysics](http://linked.data.gov.au/def/earth-science-data-category/electrical-and-electromagnetic-methods-in-geophysics) (cp)<br />
### Engineering
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/engineering`
Preferred Labels |Engineering (en)<br />
Definitions |['The use of scientific principles to design and build machines, structures, and other items, including bridges, tunnels, roads, vehicles, and buildings.']<br />
Narrower Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geomechanics-and-resources-geotechnical-engineering](http://linked.data.gov.au/def/earth-science-data-category/geomechanics-and-resources-geotechnical-engineering) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/environmental-engineering](http://linked.data.gov.au/def/earth-science-data-category/environmental-engineering) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/09](http://purl.org/au-research/vocabulary/anzsrc-for/2008/09) (cp)<br />
### Environmental Engineering
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/environmental-engineering`
Preferred Labels |Environmental Engineering (en)<br />
Definitions |['A professional engineering discipline that takes from broad scientific topics like chemistry, biology, ecology, geology, hydraulics, hydrology, microbiology, and mathematics to create solutions that will protect and also improve the health of living organisms and improve the quality of the environment. Source:Wikipedia']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/engineering](http://linked.data.gov.au/def/earth-science-data-category/engineering) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/0907](http://purl.org/au-research/vocabulary/anzsrc-for/2008/0907) (cp)<br />
### Environmental Sciences
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/environmental-sciences`
Preferred Labels |Environmental Sciences (en)<br />
Definitions |['an interdisciplinary academic field that integrates physical, biological and information sciences to the study of the environment, and the solution of environmental problems.']<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/05](http://purl.org/au-research/vocabulary/anzsrc-for/2008/05) (cp)<br />
### Extract Geochemistry
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/extract-geochemistry`
Preferred Labels |Extract Geochemistry (en)<br />
Definitions |['Analysis of the chemical and physical properties of products extracted from rocks in the subsurface.']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geochemistry](http://linked.data.gov.au/def/earth-science-data-category/geochemistry) (cp)<br />
### Extraterrestrial Geology
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/extraterrestrial-geology`
Preferred Labels |Extraterrestrial Geology (en)<br />
Alternate Labels |exogeology<br />astrogeology<br />planetary geology<br />
Definitions |['A planetary science discipline concerned with the geology of the celestial bodies such as the planets and their moons, asteroids, comets, and meteorites. Source: Wikipedia']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geology](http://linked.data.gov.au/def/earth-science-data-category/geology) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040302](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040302) (cp)<br />
### Geochemistry
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/geochemistry`
Preferred Labels |Geochemistry (en)<br />
Definitions |['The study of the chemistry of the Earth and within solid bodies of the solar system, including the distribution, circulation and abundance of elements (and their ions and isotopes), molecules, minerals, rocks and fluids. Source Schulmberger Oilfield Glossary']<br />
Narrower Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geochemistry-not-elsewhere-classified](http://linked.data.gov.au/def/earth-science-data-category/geochemistry-not-elsewhere-classified) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/isotope-geochemistry](http://linked.data.gov.au/def/earth-science-data-category/isotope-geochemistry) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/extract-geochemistry](http://linked.data.gov.au/def/earth-science-data-category/extract-geochemistry) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/organic-geochemistry](http://linked.data.gov.au/def/earth-science-data-category/organic-geochemistry) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/inorganic-geochemistry](http://linked.data.gov.au/def/earth-science-data-category/inorganic-geochemistry) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/0402](http://purl.org/au-research/vocabulary/anzsrc-for/2008/0402) (cp)<br />
### Geochemistry Not Elsewhere Classified
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/geochemistry-not-elsewhere-classified`
Preferred Labels |Geochemistry Not Elsewhere Classified (en)<br />
Definitions |['Geochemical data and information not otherwise described by other sub-categories of geochemistry.']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geochemistry](http://linked.data.gov.au/def/earth-science-data-category/geochemistry) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040299](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040299) (cp)<br />
### Geochronology
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/geochronology`
Preferred Labels |Geochronology (en)<br />
Definitions |["The study of the relative or absolute age of rocks, minerals and fossils. Absolute age is the measurement of age in years, but 'absolute' ages typically have some amount of error and are inexact. Relative age, in contrast, is the approximate age of rocks, fossils or minerals made by determining the age of the material relative to other surrounding material. Source: Schlumberger Oilfield Glossary"]<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geology](http://linked.data.gov.au/def/earth-science-data-category/geology) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040303](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040303) (cp)<br />
### Geodynamics
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/geodynamics`
Preferred Labels |Geodynamics (en)<br />
Definitions |['A subfield of geophysics dealing with dynamics of the Earth. It applies physics, chemistry and mathematics to the understanding of how mantle convection leads to plate tectonics and geologic phenomena such as seafloor spreading, mountain building, volcanoes, earthquakes, faulting and so on. It also attempts to probe the internal activity by measuring magnetic fields, gravity, and seismic waves, as well as the mineralogy of rocks and their isotopic composition. Source: Wikipedia']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geophysics](http://linked.data.gov.au/def/earth-science-data-category/geophysics) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040402](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040402) (cp)<br />
### Geology
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/geology`
Preferred Labels |Geology (en)<br />
Definitions |['An earth science concerned with the solid Earth, the rocks of which it is composed, and the processes by which they change over time. Geology can also include the study of the solid features of any terrestrial planet or natural satellite such as Mars or the Moon. Modern geology significantly overlaps all other earth sciences, including hydrology and the atmospheric sciences, and so is treated as one major aspect of integrated earth system science and planetary science. Source: Wikipedia']<br />
Narrower Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geochronology](http://linked.data.gov.au/def/earth-science-data-category/geochronology) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/marine-geoscience](http://linked.data.gov.au/def/earth-science-data-category/marine-geoscience) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/mineralogy-and-crystallography](http://linked.data.gov.au/def/earth-science-data-category/mineralogy-and-crystallography) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/structural-geology](http://linked.data.gov.au/def/earth-science-data-category/structural-geology) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/stratigraphy](http://linked.data.gov.au/def/earth-science-data-category/stratigraphy) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/petroleum-and-coal-geology](http://linked.data.gov.au/def/earth-science-data-category/petroleum-and-coal-geology) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/geomechanics](http://linked.data.gov.au/def/earth-science-data-category/geomechanics) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/geology-not-elsewhere-classified](http://linked.data.gov.au/def/earth-science-data-category/geology-not-elsewhere-classified) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/volcanology](http://linked.data.gov.au/def/earth-science-data-category/volcanology) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/petrology](http://linked.data.gov.au/def/earth-science-data-category/petrology) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/tectonics](http://linked.data.gov.au/def/earth-science-data-category/tectonics) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/basin-analysis](http://linked.data.gov.au/def/earth-science-data-category/basin-analysis) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/sedimentology](http://linked.data.gov.au/def/earth-science-data-category/sedimentology) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/extraterrestrial-geology](http://linked.data.gov.au/def/earth-science-data-category/extraterrestrial-geology) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/resource-geology](http://linked.data.gov.au/def/earth-science-data-category/resource-geology) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/palaeontology](http://linked.data.gov.au/def/earth-science-data-category/palaeontology) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/0403](http://purl.org/au-research/vocabulary/anzsrc-for/2008/0403) (cp)<br />
### Geology Not Elsewhere Classified
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/geology-not-elsewhere-classified`
Preferred Labels |Geology Not Elsewhere Classified (en)<br />
Definitions |['Geological data and information not otherwise described by other sub-categories of geochemistry.']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geology](http://linked.data.gov.au/def/earth-science-data-category/geology) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040399](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040399) (cp)<br />
### Geomechanics
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/geomechanics`
Preferred Labels |Geomechanics (en)<br />
Definitions |['The geologic specialty that deals with understanding how rocks, stresses, pressures, and temperatures interact. Source: Schlumberger Oilfield Glossary']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geology](http://linked.data.gov.au/def/earth-science-data-category/geology) (cp)<br />
### Geomechanics and Resources Geotechnical Engineering
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/geomechanics-and-resources-geotechnical-engineering`
Preferred Labels |Geomechanics and Resources Geotechnical Engineering (en)<br />
Definitions |["The application of scientific methods and engineering principles to the acquisition, interpretation, and use of knowledge of materials of the Earth's crust and earth materials for the solution of engineering problems and the design of engineering works. Source:Wikipedia"]<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/engineering](http://linked.data.gov.au/def/earth-science-data-category/engineering) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/091402](http://purl.org/au-research/vocabulary/anzsrc-for/2008/091402) (cp)<br />
### Geomorphology And Regolith And Landscape Evolution
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/geomorphology-and-regolith-and-landscape-evolution`
Preferred Labels |Geomorphology And Regolith And Landscape Evolution (en)<br />
Definitions |["The scientific study of the origin and evolution of topographic and bathymetric features created by physical, chemical or biological processes operating at or near the Earth's surface. Source: Wikipedia"]<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/physical-geography](http://linked.data.gov.au/def/earth-science-data-category/physical-geography) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040601](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040601) (cp)<br />
### Geophysical Fluid Dynamics
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/geophysical-fluid-dynamics`
Preferred Labels |Geophysical Fluid Dynamics (en)<br />
Definitions |['The fluid dynamics of naturally occurring flows, such as lava flows, oceans, and planetary atmospheres, on Earth and other planets. Souce: Wikipedia']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geophysics](http://linked.data.gov.au/def/earth-science-data-category/geophysics) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040403](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040403) (cp)<br />
### Geophysics
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/geophysics`
Preferred Labels |Geophysics (en)<br />
Definitions |['The study of the physics of the Earth, especially its electrical, gravitational and magnetic fields and propagation of elastic (seismic) waves within it. Source: Schlumberger Oilfield Glossary']<br />
Narrower Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geothermics-and-radiometrics](http://linked.data.gov.au/def/earth-science-data-category/geothermics-and-radiometrics) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/electrical-and-electromagnetic-methods-in-geophysics](http://linked.data.gov.au/def/earth-science-data-category/electrical-and-electromagnetic-methods-in-geophysics) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/gravity](http://linked.data.gov.au/def/earth-science-data-category/gravity) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/spectral-imaging](http://linked.data.gov.au/def/earth-science-data-category/spectral-imaging) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/seismology-and-seismic-exploration](http://linked.data.gov.au/def/earth-science-data-category/seismology-and-seismic-exploration) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/magnetics](http://linked.data.gov.au/def/earth-science-data-category/magnetics) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/petrophysics](http://linked.data.gov.au/def/earth-science-data-category/petrophysics) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/geophysical-fluid-dynamics](http://linked.data.gov.au/def/earth-science-data-category/geophysical-fluid-dynamics) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/geodynamics](http://linked.data.gov.au/def/earth-science-data-category/geodynamics) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/geophysics-not-elsewhere-classified](http://linked.data.gov.au/def/earth-science-data-category/geophysics-not-elsewhere-classified) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/0404](http://purl.org/au-research/vocabulary/anzsrc-for/2008/0404) (cp)<br />
### Geophysics Not Elsewhere Classified
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/geophysics-not-elsewhere-classified`
Preferred Labels |Geophysics Not Elsewhere Classified (en)<br />
Definitions |['Geophysical data and information not otherwise described by other sub-categories of geochemistry.']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geophysics](http://linked.data.gov.au/def/earth-science-data-category/geophysics) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040499](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040499) (cp)<br />
### Geothermics and Radiometrics
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/geothermics-and-radiometrics`
Preferred Labels |Geothermics and Radiometrics (en)<br />
Definitions |['The study of heatflow and radioactive activity within the Earth.']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geophysics](http://linked.data.gov.au/def/earth-science-data-category/geophysics) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040404](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040404) (cp)<br />
### Glaciology
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/glaciology`
Preferred Labels |Glaciology (en)<br />
Definitions |['The scientific study of glaciers, or more generally ice and natural phenomena that involve ice. Source: Wikipedia']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/physical-geography](http://linked.data.gov.au/def/earth-science-data-category/physical-geography) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040602](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040602) (cp)<br />
### Gravity
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/gravity`
Preferred Labels |Gravity (en)<br />
Definitions |['A versatile geophysical technique used to detect and identify subsurface bodies and anomalies within the Earth. It is based on the density changes of rock bodies and their effect on the acceleration of gravity. Source: SEG wiki']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geophysics](http://linked.data.gov.au/def/earth-science-data-category/geophysics) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040405](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040405) (cp)<br />
### Hydrocarbon Occurrences
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/hydrocarbon-occurrences`
Preferred Labels |Hydrocarbon Occurrences (en)<br />
Definitions |['The quantification of the physical properties, chemical properties, volumes, systems of accumulation (i.e. plays and prospects), and limitations to development of hydrocarbon accumulations.']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/resource-geology](http://linked.data.gov.au/def/earth-science-data-category/resource-geology) (cp)<br />
### Hydrogeochemistry
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/hydrogeochemistry`
Preferred Labels |Hydrogeochemistry (en)<br />
Definitions |["The science that uses the tools and principles of chemistry to explain the mechanisms behind major geological systems such as the Earth's crust and its oceans."]<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/Geochemistry](http://linked.data.gov.au/def/earth-science-data-category/Geochemistry) (cp)<br />
### Hydrogeology
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/hydrogeology`
Preferred Labels |Hydrogeology (en)<br />
Definitions |["The area of geology that deals with the distribution and movement of groundwater in the soil and rocks of the Earth's crust (commonly in aquifers). Source: SEG wiki"]<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/physical-geography](http://linked.data.gov.au/def/earth-science-data-category/physical-geography) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040603](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040603) (cp)<br />
### Ichnology
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/ichnology`
Preferred Labels |Ichnology (en)<br />
Definitions |['The branch of paleontology concerned with the study of fossilized tracks, trails, burrows, borings, or other trace fossils as evidence of the occurrence or behavior of the organisms that produced them. Source: dictionary.com']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/palaeontology](http://linked.data.gov.au/def/earth-science-data-category/palaeontology) (cp)<br />
### Igneous and Metamorphic Petrology
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/igneous-and-metamorphic-petrology`
Preferred Labels |Igneous and Metamorphic Petrology (en)<br />
Definitions |['The branch of petrology that describes the composition and texture of igneous and metamorphic rocks. Igneous and metamorphic petrology are commonly categorized together because they both contain heavy use of chemistry, chemical methods, and phase diagrams. Source: Wikipedia']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/petrology](http://linked.data.gov.au/def/earth-science-data-category/petrology) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040304](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040304) (cp)<br />
### Inorganic Geochemistry
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/inorganic-geochemistry`
Preferred Labels |Inorganic Geochemistry (en)<br />
Definitions |['The study of the chemistry of inorganic rocks, minerals, and other earth materials that are not currently or once living.']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geochemistry](http://linked.data.gov.au/def/earth-science-data-category/geochemistry) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040202](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040202) (cp)<br />
### Invertebrate Palaeontology
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/invertebrate-palaeontology`
Preferred Labels |Invertebrate Palaeontology (en)<br />
Definitions |['Invertebrate paleontology deals with invertebrate fossils such as molluscs, arthropods, annelid worms and echinoderms. Source: Wikipedia']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/palaeontology](http://linked.data.gov.au/def/earth-science-data-category/palaeontology) (cp)<br />
### Isotope Geochemistry
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/isotope-geochemistry`
Preferred Labels |Isotope Geochemistry (en)<br />
Definitions |["The determination of the relative and absolute concentrations of the elements and their isotopes in the Earth and on Earth's surface. Source: Kendall, Carol; Caldwell, Eric A. (1998). 'Chapter 2: Fundamentals of Isotope Geochemistry'. In Kendall, C.; McDonnell, J. J. (eds.). Isotope Tracers in Catchment Hydrology. Amsterdam: Elsevier Science. pp. 51-86."]<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geochemistry](http://linked.data.gov.au/def/earth-science-data-category/geochemistry) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040203](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040203) (cp)<br />
### Magnetics
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/magnetics`
Preferred Labels |Magnetics (en)<br />
Definitions |['Magnetic surveys are a geophysical method to image anomalies in the magnetic field of the earth caused by source bodies within the sub-surface. Source: SEG wiki']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geophysics](http://linked.data.gov.au/def/earth-science-data-category/geophysics) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040406](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040406) (cp)<br />
### Marine Geoscience
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/marine-geoscience`
Preferred Labels |Marine Geoscience (en)<br />
Alternate Labels |marine geology<br />geological oceanography<br />
Definitions |['The study of the history and structure of the ocean floor. It involves geophysical, geochemical, sedimentological and paleontological investigations of the ocean floor and coastal zone. Source: Wikipedia']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geology](http://linked.data.gov.au/def/earth-science-data-category/geology) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040305](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040305) (cp)<br />
### Mineral Occurrences
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/mineral-occurrences`
Preferred Labels |Mineral Occurrences (en)<br />
Definitions |['The quantification of the physical properties, chemical properties, volumes, systems of accumulation (e.g. ore body charictarization), and limitations to development of mineral occurences.']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/resource-geology](http://linked.data.gov.au/def/earth-science-data-category/resource-geology) (cp)<br />
### Mineralogy and Crystallography
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/mineralogy-and-crystallography`
Preferred Labels |Mineralogy and Crystallography (en)<br />
Definitions |['The scientific study of the chemistry, crystal structure, and physical (including optical) properties of minerals and mineralized artifacts. Source: Wikipedia']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geology](http://linked.data.gov.au/def/earth-science-data-category/geology) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040306](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040306) (cp)<br />
### Natural Hazards
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/natural-hazards`
Preferred Labels |Natural Hazards (en)<br />
Definitions |['The study of natural phenomena that might have a negative effect on humans or the environment. Specifically geophysical hazards encompassing geological and meteorological phenomena such as earthquakes, volcanic eruptions, wildfires, cyclonic storms, floods, droughts, avalanches and landslides. Source: Wikipedia']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/physical-geography](http://linked.data.gov.au/def/earth-science-data-category/physical-geography) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040604](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040604) (cp)<br />
### Organic Geochemistry
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/organic-geochemistry`
Preferred Labels |Organic Geochemistry (en)<br />
Definitions |['The study of the role of processes and compounds that are derived from living or once-living organisms. Source: Killops, Stephen D.; Killops, Vanessa J. (2013). Introduction to Organic Geochemistry. John Wiley & Sons.']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geochemistry](http://linked.data.gov.au/def/earth-science-data-category/geochemistry) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040204](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040204) (cp)<br />
### Organic Petrology
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/organic-petrology`
Preferred Labels |Organic Petrology (en)<br />
Definitions |["Organic petrology involves the study of organic matter (OM) in rocks including its origin and thermal maturity due to burial within the earth's crust. Source: CSIRO"]<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/petrology](http://linked.data.gov.au/def/earth-science-data-category/petrology) (cp)<br />
### Palaeobotany
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/palaeobotany`
Preferred Labels |Palaeobotany (en)<br />
Definitions |['Paleobotany studies fossil plants, algae, and fungi. Source: Wikipedia']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/palaeontology](http://linked.data.gov.au/def/earth-science-data-category/palaeontology) (cp)<br />
### Palaeoclimatology
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/palaeoclimatology`
Preferred Labels |Palaeoclimatology (en)<br />
Definitions |["The study of changes in climate taken on the scale of the entire history of Earth. It uses a variety of proxy methods from the Earth and life sciences to obtain data previously preserved within rocks, sediments, ice sheets, tree rings, corals, shells, and microfossils to determine the past states of the Earth's various climate regions and its atmospheric system. Source: Wikipedia"]<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/physical-geography](http://linked.data.gov.au/def/earth-science-data-category/physical-geography) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040605](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040605) (cp)<br />
### Palaeontology
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/palaeontology`
Preferred Labels |Palaeontology (en)<br />
Definitions |['The study of fossilized, or preserved, remnants of plant and animal life. Changes in the Earth through time can be documented by observing changes in the fossils in successive strata and the environments in which they formed or were preserved. Fossils can also be compared with their extant relatives to assess evolutionary changes. Correlations of strata can be aided by studying their fossil content, a discipline called biostratigraphy. Source: Schlumberger Oilfield Glossary']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geology](http://linked.data.gov.au/def/earth-science-data-category/geology) (cp)<br />
Narrower Concepts |[http://linked.data.gov.au/def/earth-science-data-category/vertebrate-palaeontology](http://linked.data.gov.au/def/earth-science-data-category/vertebrate-palaeontology) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/ichnology](http://linked.data.gov.au/def/earth-science-data-category/ichnology) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/palaeobotany](http://linked.data.gov.au/def/earth-science-data-category/palaeobotany) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/palynology](http://linked.data.gov.au/def/earth-science-data-category/palynology) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/invertebrate-palaeontology](http://linked.data.gov.au/def/earth-science-data-category/invertebrate-palaeontology) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040308](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040308) (cp)<br />
### Palynology
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/palynology`
Preferred Labels |Palynology (en)<br />
Definitions |['Palynology, the study of pollen and spores produced by land plants and protists, straddles paleontology and botany, as it deals with both living and fossil organisms. Source: Wikipedia']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/palaeontology](http://linked.data.gov.au/def/earth-science-data-category/palaeontology) (cp)<br />
### Passive Seismic
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/passive-seismic`
Preferred Labels |Passive Seismic (en)<br />
Definitions |['The detection of natural low frequency earth movements, commonly with the purpose of discerning geological structures and locating underground oil, gas, or other resources. Source: Wikipedia']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/seismic-surveys](http://linked.data.gov.au/def/earth-science-data-category/seismic-surveys) (cp)<br />
### Petroleum and Coal Geology
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/petroleum-and-coal-geology`
Preferred Labels |Petroleum and Coal Geology (en)<br />
Alternate Labels |fossil-fuel geology<br />petroleum and coal geology<br />fossil fuel geology<br />
Definitions |['The branch of geology that studies the processes of fossil fuel formation (coal, oil and gas).']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geology](http://linked.data.gov.au/def/earth-science-data-category/geology) (cp)<br />
Narrower Concepts |[http://linked.data.gov.au/def/earth-science-data-category/reservoir-geology](http://linked.data.gov.au/def/earth-science-data-category/reservoir-geology) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040309](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040309) (cp)<br />
### Petrology
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/petrology`
Preferred Labels |Petrology (en)<br />
Definitions |['The branch of geology that studies rocks and the conditions under which they form. Sometimes synonymous with lithology that studies the macroscopic hand-sample or outcrop-scale description of rocks. Source: Wikipedia']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geology](http://linked.data.gov.au/def/earth-science-data-category/geology) (cp)<br />
Narrower Concepts |[http://linked.data.gov.au/def/earth-science-data-category/sedimentary-petrology](http://linked.data.gov.au/def/earth-science-data-category/sedimentary-petrology) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/organic-petrology](http://linked.data.gov.au/def/earth-science-data-category/organic-petrology) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/igneous-and-metamorphic-petrology](http://linked.data.gov.au/def/earth-science-data-category/igneous-and-metamorphic-petrology) (cp)<br />
### Petrophysics
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/petrophysics`
Preferred Labels |Petrophysics (en)<br />
Definitions |['Petrophysics is the study of physical and chemical rock properties and their interactions with fluids. A major application of petrophysics is in studying reservoirs for the hydrocarbon industry. Source: Wikipedia']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geophysics](http://linked.data.gov.au/def/earth-science-data-category/geophysics) (cp)<br />
### Physical Geography
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/physical-geography`
Preferred Labels |Physical Geography (en)<br />
Definitions |['The branch of geography dealing with natural features. Source: dictionary.com']<br />
Narrower Concepts |[http://linked.data.gov.au/def/earth-science-data-category/palaeoclimatology](http://linked.data.gov.au/def/earth-science-data-category/palaeoclimatology) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/quaternary-environments](http://linked.data.gov.au/def/earth-science-data-category/quaternary-environments) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/surfacewater-hydrology](http://linked.data.gov.au/def/earth-science-data-category/surfacewater-hydrology) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/geomorphology-and-regolith-and-landscape-evolution](http://linked.data.gov.au/def/earth-science-data-category/geomorphology-and-regolith-and-landscape-evolution) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/hydrogeology](http://linked.data.gov.au/def/earth-science-data-category/hydrogeology) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/surface-processes](http://linked.data.gov.au/def/earth-science-data-category/surface-processes) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/physical-geography-and-environmental-geoscience-not-elsewhere-classified](http://linked.data.gov.au/def/earth-science-data-category/physical-geography-and-environmental-geoscience-not-elsewhere-classified) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/glaciology](http://linked.data.gov.au/def/earth-science-data-category/glaciology) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/natural-hazards](http://linked.data.gov.au/def/earth-science-data-category/natural-hazards) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/0406](http://purl.org/au-research/vocabulary/anzsrc-for/2008/0406) (cp)<br />
### Physical Geography And Environmental Geoscience Not Elsewhere Classified
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/physical-geography-and-environmental-geoscience-not-elsewhere-classified`
Preferred Labels |Physical Geography And Environmental Geoscience Not Elsewhere Classified (en)<br />
Definitions |['Physical geographical and environmental science data and information not otherwise described by other sub-categories of geochemistry.']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/physical-geography](http://linked.data.gov.au/def/earth-science-data-category/physical-geography) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040699](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040699) (cp)<br />
### Quarry Resources
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/quarry-resources`
Preferred Labels |Quarry Resources (en)<br />
Alternate Labels |Quarries, Sand, and Gravel Resources<br />
Definitions |['The quantification of the physical properties, chemical properties, volumes, and limitations to development of quarry product accumulations. Quarry resources include, but may not be limited to, hardrock, sand and gravel.']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/resource-geology](http://linked.data.gov.au/def/earth-science-data-category/resource-geology) (cp)<br />
### Quaternary Environments
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/quaternary-environments`
Preferred Labels |Quaternary Environments (en)<br />
Alternate Labels |quaternary geology<br />
Definitions |['The branch of geology that study developments from 2.6 million years ago onwards. In particular Quaternary geology study the process and deposits that developed during the quaternary, a period characterized by glacial-interglacial cycles. Source: Wikipedia']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/physical-geography](http://linked.data.gov.au/def/earth-science-data-category/physical-geography) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040606](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040606) (cp)<br />
### Reservoir Geology
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/reservoir-geology`
Preferred Labels |Reservoir Geology (en)<br />
Definitions |['The study of subsurface rock formations that contain hydrocarbon accumulations. In particular quantification of reservoir properities such as porosity, permeability, fluid saturations, and fluid contacts.']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/petroleum-and-coal-geology](http://linked.data.gov.au/def/earth-science-data-category/petroleum-and-coal-geology) (cp)<br />
### Resource Geology
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/resource-geology`
Preferred Labels |Resource Geology (en)<br />
Definitions |['The study of geology in the context of economic development and the quantification of resource potential of accumulations such as hydrocarbons, mineral ore bodies, and coal deposits.']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geology](http://linked.data.gov.au/def/earth-science-data-category/geology) (cp)<br />
Narrower Concepts |[http://linked.data.gov.au/def/earth-science-data-category/mineral-occurrences](http://linked.data.gov.au/def/earth-science-data-category/mineral-occurrences) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/hydrocarbon-occurrences](http://linked.data.gov.au/def/earth-science-data-category/hydrocarbon-occurrences) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/quarry-resources](http://linked.data.gov.au/def/earth-science-data-category/quarry-resources) (cp)<br />
### Satellite Spectral
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/satellite-spectral`
Preferred Labels |Satellite Spectral (en)<br />
Definitions |['Remotely sensed spectral imaging obtained from a platform in orbit outside the atmosphere of Earth.']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/spectral-imaging](http://linked.data.gov.au/def/earth-science-data-category/spectral-imaging) (cp)<br />
### Sedimentary Petrology
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/sedimentary-petrology`
Preferred Labels |Sedimentary Petrology (en)<br />
Definitions |['The study of the composition, characteristics, and origin of sediments and sedimentary rocks. Source: AGI']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/petrology](http://linked.data.gov.au/def/earth-science-data-category/petrology) (cp)<br />
### Sedimentology
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/sedimentology`
Preferred Labels |Sedimentology (en)<br />
Definitions |['The scientific study of sedimentary rocks and of the processes by which they were formed; the description, classification, origin, and interpretation of sediments. Source: AGI']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geology](http://linked.data.gov.au/def/earth-science-data-category/geology) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040310](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040310) (cp)<br />
### Seismic Surveys
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/seismic-surveys`
Preferred Labels |Seismic Surveys (en)<br />
Definitions |["The acquisition, processing, and analysis of seismic data sets measured and recorded with reference to a particular area of the Earth's surface, to evaluate the subsurface."]<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/seismology-and-seismic-exploration](http://linked.data.gov.au/def/earth-science-data-category/seismology-and-seismic-exploration) (cp)<br />
Narrower Concepts |[http://linked.data.gov.au/def/earth-science-data-category/passive-seismic](http://linked.data.gov.au/def/earth-science-data-category/passive-seismic) (cp)<br />
### Seismology and Seismic Exploration
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/seismology-and-seismic-exploration`
Preferred Labels |Seismology and Seismic Exploration (en)<br />
Definitions |["The scientific study of earthquakes and the propagation of elastic waves through the Earth or through other planet-like bodies. The field also includes studies of earthquake environmental effects such as tsunamis as well as diverse seismic sources such as volcanic, tectonic, oceanic, atmospheric, and artificial processes such as explosions. Seismic exploration is a method of exploration geophysics that uses the principles of seismology to estimate the properties of the Earth's subsurface from artificially generated seismic waves. Source: Wikipedia"]<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geophysics](http://linked.data.gov.au/def/earth-science-data-category/geophysics) (cp)<br />
Narrower Concepts |[http://linked.data.gov.au/def/earth-science-data-category/seismic-surveys](http://linked.data.gov.au/def/earth-science-data-category/seismic-surveys) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040407](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040407) (cp)<br />
### Spectral Imaging
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/spectral-imaging`
Preferred Labels |Spectral Imaging (en)<br />
Definitions |['Spectral imaging is imaging that uses multiple bands across the electromagnetic spectrum.']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geophysics](http://linked.data.gov.au/def/earth-science-data-category/geophysics) (cp)<br />
Narrower Concepts |[http://linked.data.gov.au/def/earth-science-data-category/satellite-spectral](http://linked.data.gov.au/def/earth-science-data-category/satellite-spectral) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/airborne-spectral](http://linked.data.gov.au/def/earth-science-data-category/airborne-spectral) (cp)<br />[http://linked.data.gov.au/def/earth-science-data-category/core-spectral](http://linked.data.gov.au/def/earth-science-data-category/core-spectral) (cp)<br />
### Stratigraphy
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/stratigraphy`
Preferred Labels |Stratigraphy (en)<br />
Definitions |['The study of the history, composition, relative ages and distribution of strata, and the interpretation of strata to elucidate Earth history. The comparison, or correlation, of separated strata can include study of their lithology, fossil content, and relative or absolute age, or lithostratigraphy, biostratigraphy, and chronostratigraphy. Source: Schlumberger Oilfield Glossary']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geology](http://linked.data.gov.au/def/earth-science-data-category/geology) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040311](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040311) (cp)<br />
### Structural Geology
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/structural-geology`
Preferred Labels |Structural Geology (en)<br />
Definitions |['Pertaining to structure, the geometry and spatial arrangement of rocks. The structure or deformation can include many mechanisms, such as folding, faulting and fracturing. Structure can usually be interpreted in terms of the deformation of the crust of the Earth as continents and tectonic plates move and collide. Source: Schlumberger Oilfield Glossary']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geology](http://linked.data.gov.au/def/earth-science-data-category/geology) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040312](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040312) (cp)<br />
### Surface Processes
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/surface-processes`
Preferred Labels |Surface Processes (en)<br />
Definitions |["The study of the processes that form and change the Earth's surface. Source: University of Melbourne"]<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/physical-geography](http://linked.data.gov.au/def/earth-science-data-category/physical-geography) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040607](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040607) (cp)<br />
### Surfacewater Hydrology
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/surfacewater-hydrology`
Preferred Labels |Surfacewater Hydrology (en)<br />
Alternate Labels |Surface-water hydrology<br />
Definitions |['The sub-field of hydrology concerned with above-earth water, in contrast to groundwater hydrology that deals with water below the surface of the Earth. Its applications include rainfall and runoff, the routes that surface water takes (for example through rivers or reservoirs), and the occurrence of floods and droughts. Source: Wikipedia']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/physical-geography](http://linked.data.gov.au/def/earth-science-data-category/physical-geography) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040608](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040608) (cp)<br />
### Tectonics
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/tectonics`
Preferred Labels |Tectonics (en)<br />
Alternate Labels |plate tectonics<br />
Definitions |['Also known as plate tectonics, the unifying geologic theory developed to explain observations that interactions of the brittle plates of the lithosphere with each other and with the softer underlying asthenosphere result in large-scale changes in the Earth. Source: Schlumberger Oilfield Glossary']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geology](http://linked.data.gov.au/def/earth-science-data-category/geology) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040313](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040313) (cp)<br />
### Vertebrate Palaeontology
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/vertebrate-palaeontology`
Preferred Labels |Vertebrate Palaeontology (en)<br />
Definitions |['Vertebrate paleontology concentrates on fossils from the earliest fish to the immediate ancestors of modern mammals. Source: Wikipedia']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/palaeontology](http://linked.data.gov.au/def/earth-science-data-category/palaeontology) (cp)<br />
### Volcanology
Property | Value
--- | ---
URI | `http://linked.data.gov.au/def/earth-science-data-category/volcanology`
Preferred Labels |Volcanology (en)<br />
Alternate Labels |vulcanology<br />
Definitions |['The study of volcanoes, lava, magma, and related geological, geophysical and geochemical phenomena. Source: Wikipedia']<br />
Broader Concepts |[http://linked.data.gov.au/def/earth-science-data-category/geology](http://linked.data.gov.au/def/earth-science-data-category/geology) (cp)<br />
Exact Matches |[http://purl.org/au-research/vocabulary/anzsrc-for/2008/040314](http://purl.org/au-research/vocabulary/anzsrc-for/2008/040314) (cp)<br />

## Namespaces
* **dct**
  * `http://purl.org/dc/terms/`
* **owl**
  * `http://www.w3.org/2002/07/owl#`
* **rdf**
  * `http://www.w3.org/1999/02/22-rdf-syntax-ns#`
* **rdfs**
  * `http://www.w3.org/2000/01/rdf-schema#`
* **sdo**
  * `https://schema.org/`
* **skos**
  * `http://www.w3.org/2004/02/skos/core#`
* **xsd**
  * `http://www.w3.org/2001/XMLSchema#`

## Legend
* Collections: cl
* Concepts: cp