# this file holds a list of CURIES from prefix.cc and some extras

CURIES = {
    "aair": "http://xmlns.notu.be/aair#",
    "aapi": "http://rdf.alchemyapi.com/rdf/v1/s/aapi-schema#",
    "aat": "http://vocab.getty.edu/aat/",
    "abc": "http://www.metadata.net/harmony/ABCSchemaV5Commented.rdf#",
    "abs": "http://abs.270a.info/dataset/",
    "ac": "http://umbel.org/umbel/ac/",
    "acc": "http://purl.org/NET/acc#",
    "acco": "http://purl.org/acco/ns#",
    "accom": "http://purl.org/acco/ns#",
    "acl": "http://www.w3.org/ns/auth/acl#",
    "acm": "http://www.rkbexplorer.com/ontologies/acm#",
    "acrt": "http://privatealpha.com/ontology/certification/1#",
    "act": "http://www.w3.org/2007/rif-builtin-action#",
    "activity": "http://activitystrea.ms/specs/atom/1.0/",
    "ad": "http://schemas.talis.com/2005/address/schema#",
    "add": "http://www.datatourisme.fr/ontology/core/1.0#",
    "address": "http://schemas.talis.com/2005/address/schema#",
    "adf": "http://purl.allotrope.org/ontologies/datapackage#",
    "admin": "http://webns.net/mvcb/",
    "admingeo": "http://data.ordnancesurvey.co.uk/ontology/admingeo/",
    "adms": "http://www.w3.org/ns/adms#",
    "admssw": "http://purl.org/adms/sw/",
    "adr": "https://w3id.org/laas-iot/adream#",
    "aerols": "http://xmlns.com/aerols/0.1/",
    "aers": "http://aers.data2semantics.org/resource/",
    "aersv": "http://aers.data2semantics.org/vocab/",
    "af": "http://purl.org/ontology/af/",
    "affy": "http://www.affymetrix.com/community/publications/affymetrix/tmsplice#",
    "affymetrix": "http://bio2rdf.org/affymetrix_vocabulary:",
    "afm": "http://purl.allotrope.org/ontologies/material/",
    "afn": "http://jena.hpl.hp.com/ARQ/function#",
    "afr": "http://purl.allotrope.org/ontologies/result#",
    "agent": "http://eulersharp.sourceforge.net/2003/03swap/agent#",
    "agents": "http://eulersharp.sourceforge.net/2003/03swap/agent#",
    "agetec": "http://www.agetec.org/",
    "agg": "http://purl.org/twc/health/vocab/aggregate/",
    "agls": "http://www.agls.gov.au/agls/terms/",
    "ago": "http://awesemantic-geo.link/ontology/",
    "agr": "http://promsns.org/def/agr#",
    "agrd": "http://agrinepaldata.com/",
    "agrelon": "http://d-nb.info/standards/elementset/agrelon#",
    "agro": "http://agrinepaldata.com/vocab/",
    "agrovoc": "http://aims.fao.org/aos/agrovoc/",
    "aifb": "http://www.aifb.kit.edu/id/",
    "aigp": "http://swat.cse.lehigh.edu/resources/onto/aigp.owl#",
    "aiiso": "http://purl.org/vocab/aiiso/schema#",
    "aims": "http://aims.fao.org/aos/common/",
    "air": "http://dig.csail.mit.edu/TAMI/2007/amord/air#",
    "airport": "http://www.daml.org/2001/10/html/airport-ont#",
    "airs": "https://raw.githubusercontent.com/airs-linked-data/lov/latest/src/airs_vocabulary.ttl#",
    "aksw": "http://aksw.org/",
    "akt": "http://www.aktors.org/ontology/portal#",
    "aktivesa": "http://sa.aktivespace.org/ontologies/aktivesa#",
    "akts": "http://www.aktors.org/ontology/support#",
    "alchemy": "http://rdf.alchemyapi.com/rdf/v1/s/aapi-schema#",
    "alethio": "http://aleth.io/",
    "algo": "http://securitytoolbox.appspot.com/securityAlgorithms#",
    "ali": "http://www.niso.org/schemas/ali/1.0/",
    "alice": "http://example.org/",
    "allot": "https://w3id.org/akn/ontology/allot#",
    "am": "http://vocab.deri.ie/am#",
    "amalgame": "http://purl.org/vocabularies/amalgame#",
    "aml": "https://w3id.org/i40/aml#",
    "amsl": "http://vocab.ub.uni-leipzig.de/amsl/",
    "amt": "http://academic-meta-tool.xyz/vocab#",
    "anca": "http://users.utcluj.ro/~raluca/rdf_ontologies_ralu/ralu_modified_ontology_pizzas2_0#",
    "aneo": "http://akonadi-project.org/ontologies/aneo#",
    "ann": "http://www.w3.org/2000/10/annotation-ns#",
    "antenne": "https://id.milieuinfo.be/ns/zendantenne#",
    "ao": "http://purl.org/ontology/ao/core#",
    "aos": "http://rdf.muninn-project.org/ontologies/appearances#",
    "aozora": "http://purl.org/net/aozora/",
    "apf": "http://jena.apache.org/ARQ/property#",
    "api": "http://purl.org/linked-data/api/vocab#",
    "apivc": "http://purl.org/linked-data/api/vocab#",
    "app": "http://jmvanel.free.fr/ontology/software_applications.n3#",
    "aprov": "http://purl.org/a-proc#",
    "arch": "http://purl.org/archival/vocab/arch#",
    "archdesc": "http://archdesc.info/archEvent#",
    "arecipe": "http://purl.org/amicroformat/arecipe/",
    "arg": "http://rdfs.org/sioc/argument#",
    "arpfo": "http://vocab.ouls.ox.ac.uk/projectfunding#",
    "art": "http://w3id.org/art/terms/1.0/",
    "article": "http://ogp.me/ns/article#",
    "artstor": "http://simile.mit.edu/2003/10/ontologies/artstor#",
    "as": "https://www.w3.org/ns/activitystreams#",
    "asawoo": "http://liris.cnrs.fr/asawoo/",
    "aseonto": "http://requirement.ase.ru/requirements_ontology#",
    "asgv": "http://aims.fao.org/aos/agrovoc/",
    "asn": "http://purl.org/ASN/schema/core/",
    "ass": "http://uptheasset.org/ontology#",
    "assoc": "https://w3id.org/associations/vocab#",
    "atlas": "http://rdf.ebi.ac.uk/resource/atlas/",
    "atlasterms": "http://rdf.ebi.ac.uk/terms/atlas/",
    "atom": "http://www.w3.org/2005/Atom/",
    "atomix": "http://buzzword.org.uk/rdf/atomix#",
    "atomowl": "http://bblfish.net/work/atom-owl/2006-06-06/#",
    "atomrdf": "http://atomowl.org/ontologies/atomrdf#",
    "audio": "http://purl.org/media/audio#",
    "audit": "http://fedora.info/definitions/v4/audit#",
    "auto": "http://auto.schema.org/",
    "awol": "http://bblfish.net/work/atom-owl/2006-06-06/#",
    "aws": "http://purl.oclc.org/NET/ssnx/meteo/aws#",
    "az": "https://w3id.org/people/az/",
    "b2bo": "http://purl.org/b2bo#",
    "b2rpubchem": "http://bio2rdf.org/ns/ns/ns/pubchem#",
    "b3kat": "http://lod.b3kat.de/title/",
    "babelnet": "http://babelnet.org/2.0/",
    "bag": "http://bag.basisregistraties.overheid.nl/def/bag#",
    "basic": "http://def.seegrid.csiro.au/isotc211/iso19103/2005/basic#",
    "bb": "http://www.snik.eu/ontology/bb/",
    "bbc": "http://www.bbc.co.uk/ontologies/news/",
    "bbccms": "http://www.bbc.co.uk/ontologies/cms/",
    "bbccore": "http://www.bbc.co.uk/ontologies/coreconcepts/",
    "bbcprov": "http://www.bbc.co.uk/ontologies/provenance/",
    "bblfish": "http://bblfish.net/people/henry/card#",
    "bci": "https://w3id.org/BCI-ontology#",
    "bcnbio": "http://datos.bcn.cl/ontologies/bcn-biographies#",
    "bcncon": "http://datos.bcn.cl/ontologies/bcn-congress#",
    "bcngeo": "http://datos.bcn.cl/ontologies/bcn-geographics#",
    "bcnnorms": "http://datos.bcn.cl/ontologies/bcn-norms#",
    "bco": "http://purl.obolibrary.org/obo/bco.owl#",
    "bd": "http://www.bigdata.com/rdf#",
    "bdc": "http://dbpedia.org/resource/Category:",
    "bdd": "https://api.bloomberg.com/eap/catalogs/bbg/fields/",
    "bdo": "http://purl.bdrc.io/ontology/core/",
    "bdr": "http://purl.bdrc.io/resource/",
    "bds": "http://www.bigdata.com/rdf/search#",
    "beer": "http://beer.com/",
    "being": "http://purl.org/ontomedia/ext/common/being#",
    "besluit": "http://data.vlaanderen.be/ns/besluit#",
    "beth": "http://www.google.com/",
    "bevon": "http://rdfs.co/bevon/",
    "bf": "http://id.loc.gov/ontologies/bibframe/",
    "bflc": "http://id.loc.gov/ontologies/bflc/",
    "bfo": "http://www.ifomis.org/bfo/1.1#",
    "bgcat": "http://bg.dbpedia.org/resource/?????????:",
    "bgdbp": "http://bg.dbpedia.org/property/",
    "bgdbr": "http://bg.dbpedia.org/resource/",
    "bgn": "http://bibliograph.net/schemas/",
    "bgt": "http://bgt.basisregistraties.overheid.nl/def/bgt#",
    "bib": "http://zeitkunst.org/bibtex/0.1/bibtex.owl#",
    "bibframe": "http://bibframe.org/vocab/",
    "biblio": "http://purl.org/net/biblio#",
    "bibo": "http://purl.org/ontology/bibo/",
    "bibrm": "http://vocab.ub.uni-leipzig.de/bibrm/",
    "bibtex": "http://purl.oclc.org/NET/nknouf/ns/bibtex#",
    "bif": "http://www.openlinksw.com/schemas/bif#",
    "bihap": "http://bihap.kb.gov.tr/ontology/",
    "bill": "http://www.rdfabout.com/rdf/schema/usbill/",
    "biml": "http://schemas.varigence.com/biml.xsd#",
    "bing": "http://bing.com/schema/media/",
    "bio": "http://purl.org/vocab/bio/0.1/",
    "bio2rdf": "http://bio2rdf.org/",
    "bioc": "http://deductions.github.io/biological-collections.owl.ttl#",
    "biocore": "http://bio2rdf.org/core#",
    "bioentity": "http://bioentity.io/vocab/",
    "biol": "http://purl.org/NET/biol/ns#",
    "biopax": "http://www.biopax.org/release/biopax-level3.owl#",
    "biordf": "http://purl.org/net/biordfmicroarray/ns#",
    "bioskos": "http://eulersharp.sourceforge.net/2003/03swap/bioSKOSSchemes#",
    "biotop": "http://purl.org/biotop/biotop.owl#",
    "biro": "http://purl.org/spar/biro/",
    "bis": "http://bis.270a.info/dataset/",
    "bk": "http://www.provbook.org/ns/#",
    "bl": "http://w3id.org/biolink/vocab/",
    "blt": "http://www.bl.uk/schemas/bibliographic/blterms#",
    "bm": "http://bio2rdf.org/",
    "bmo": "http://collection.britishmuseum.org/id/ontology/",
    "bn": "http://babelnet.org/rdf/",
    "bne": "http://datos.bne.es/resource/",
    "bner": "http://datos.bne.es/resource/",
    "bnf": "http://www.w3.org/2000/10/swap/grammar/bnf#",
    "bob": "http://good.dad/meaning/bob#",
    "book": "http://purl.org/NET/book/vocab#",
    "bookmark": "http://www.w3.org/2002/01/bookmark#",
    "bot": "https://w3id.org/bot#",
    "botany": "http://purl.org/NET/biol/botany#",
    "bp": "http://open-services.net/ns/basicProfile#",
    "bpo": "https://w3id.org/bpo#",
    "br": "http://vocab.deri.ie/br#",
    "brick": "http://brickschema.org/schema/1.0.3/",
    "bridge": "http://purl.org/vocommons/bridge#",
    "brk": "http://brk.basisregistraties.overheid.nl/def/brk#",
    "brt": "http://brt.basisregistraties.overheid.nl/def/top10nl#",
    "bsb": "http://opacplus.bsb-muenchen.de/title/",
    "bsbm": "http://www4.wiwiss.fu-berlin.de/bizer/bsbm/v01/vocabulary/",
    "bsym": "http://bsym.bloomberg.com/sym/",
    "bte": "http://purl.org/twc/vocab/between-the-edges/",
    "bv": "http://purl.org/vocommons/bv#",
    "bwb": "http://doc.metalex.eu/bwb/ontology/",
    "c4dm": "http://purl.org/NET/c4dm/event.owl#",
    "c4n": "http://vocab.deri.ie/c4n#",
    "c4o": "http://purl.org/spar/c4o/",
    "c9d": "http://purl.org/twc/vocab/conversion/",
    "ca": "http://complyadvantage.com/",
    "cal": "http://www.w3.org/2002/12/cal/ical#",
    "call": "http://webofcode.org/wfn/call:",
    "calli": "http://callimachusproject.org/rdf/2009/framework#",
    "camelot": "http://vocab.ox.ac.uk/camelot#",
    "campsite": "http://www.openlinksw.com/campsites/schema#",
    "cao": "http://purl.org/makolab/caont/",
    "caplibacl": "http://schemas.capita-libraries.co.uk/2015/acl/schema#",
    "card": "http://www.ashutosh.com/tests/",
    "care": "http://eulersharp.sourceforge.net/2003/03swap/care#",
    "carfo": "http://purl.org/carfo#",
    "cart": "http://purl.org/net/cartCoord#",
    "category": "http://dbpedia.org/resource/Category:",
    "cb": "http://cbasewrap.ontologycentral.com/vocab#",
    "cbase": "http://ontologycentral.com/2010/05/cb/vocab#",
    "cbim": "http://www.coinsweb.nl/cbim-2.0.rdf#",
    "cbo": "http://comicmeta.org/cbo/",
    "cc": "http://creativecommons.org/ns#",
    "ccard": "http://purl.org/commerce/creditcard#",
    "cco": "http://www.ontologyrepository.com/CommonCoreOntologies/",
    "ccom": "http://purl.org/ontology/cco/mappings#",
    "ccrel": "http://creativecommons.org/ns#",
    "cd": "http://citydata.wu.ac.at/ns#",
    "cdao": "http://purl.obolibrary.org/obo/",
    "cdc": "http://www.contextdatacloud.org/resource/",
    "cdm": "http://publications.europa.eu/ontology/cdm#",
    "cdt": "http://w3id.org/lindt/custom_datatypes#",
    "cdtype": "http://purl.org/cld/cdtype/",
    "centrifuge": "http://purl.org/twc/vocab/centrifuge#",
    "ceo": "http://www.ebusiness-unibw.org/ontologies/consumerelectronics/v1#",
    "cerif": "http://spi-fm.uca.es/neologism/cerif#",
    "cert": "http://www.w3.org/ns/auth/cert#",
    "ceterms": "http://purl.org/ctdl/terms/",
    "cex": "http://purl.org/weso/computex/ontology#",
    "cf": "http://mmisw.org/ont/cf/parameter/",
    "cff": "http://purl.oclc.org/NET/ssnx/cf/cf-feature#",
    "cfp": "http://sw.deri.org/2005/08/conf/cfp.owl#",
    "cgov": "http://reference.data.gov.uk/def/central-government/",
    "changeset": "http://purl.org/vocab/changeset/schema#",
    "chear": "http://hadatac.org/ont/chear#",
    "chebi": "http://bio2rdf.org/chebi:",
    "chembl": "http://rdf.ebi.ac.uk/terms/chembl#",
    "cheminf": "http://www.semanticweb.org/ontologies/cheminf.owl#",
    "chord": "http://purl.org/ontology/chord/",
    "cidoc": "http://erlangen-crm.org/current/",
    "cidoccrm": "http://purl.org/NET/cidoc-crm/core#",
    "cim": "http://iec.ch/TC57/2013/CIM-schema-cim16#",
    "cis": "http://purl.org/NET/cloudisus#",
    "cito": "http://purl.org/spar/cito/",
    "citof": "http://www.essepuntato.it/2013/03/cito-functions#",
    "city": "http://datos.localidata.com/def/City#",
    "cjr": "http://vocab.linkeddata.es/datosabiertos/def/urbanismo-infraestructuras/callejero#",
    "cl": "http://advene.org/ns/cinelab/",
    "clapit": "http://dati.gov.it/onto/clapit/",
    "cld": "http://purl.org/cld/terms/",
    "climb": "http://climb.dataincubator.org/vocabs/climb/",
    "clineva": "http://www.agfa.com/w3c/2009/clinicalEvaluation#",
    "clinic": "http://example.com/clinic#",
    "clinproc": "http://www.agfa.com/w3c/2009/clinicalProcedure#",
    "clirio": "http://clirio.kaerle.com/clirio.owl#",
    "cmd": "http://clarin.eu/cmd#",
    "cmdi": "http://www.clarin.eu/cmd/",
    "cmdm": "http://infra.clarin.eu/cmd/",
    "cmo": "http://purl.org/twc/ontologies/cmo.owl#",
    "cmp": "http://www.ontologydesignpatterns.org/cp/owl/componency.owl#",
    "cnt": "http://www.w3.org/2011/content#",
    "co": "http://rhizomik.net/ontologies/copyrightonto.owl#",
    "cocoon": "https://w3id.org/cocoon/v1.0#",
    "code": "http://telegraphis.net/ontology/measurement/code#",
    "coeus": "http://bioinformatics.ua.pt/coeus/",
    "cogs": "http://vocab.deri.ie/cogs#",
    "coin": "http://purl.org/court/def/2009/coin#",
    "cold": "http://purl.org/configurationontology#",
    "coll": "http://purl.org/co/",
    "com": "http://purl.org/commerce#",
    "comm": "http://vocab.resc.info/communication#",
    "commerce": "http://search.yahoo.com/searchmonkey/commerce/",
    "common": "http://www.w3.org/2007/uwa/context/common.owl#",
    "commons": "http://commons.psi.enakting.org/def/",
    "company": "http://intellimind.io/ns/company#",
    "compass": "http://purl.org/net/compass#",
    "composer": "http://dbpedia.org/ontology/composer/",
    "con": "http://www.w3.org/2000/10/swap/pim/contact#",
    "condition": "http://www.kinjal.com/condition:",
    "conf": "http://richard.cyganiak.de/2007/pubby/config.rdf#",
    "conference": "https://w3id.org/scholarlydata/ontology/conference-ontology.owl#",
    "connard": "https://mail.google.com/mail/u/1/#",
    "conserv": "http://conserv.deri.ie/ontology#",
    "contact": "http://www.w3.org/2000/10/swap/pim/contact#",
    "content": "http://purl.org/rss/1.0/modules/content/",
    "contsem": "http://contsem.unizar.es/def/sector-publico/contratacion#",
    "conv": "http://purl.org/twc/vocab/conversion/",
    "conversion": "http://purl.org/twc/vocab/conversion/",
    "coo": "http://purl.org/coo/ns#",
    "copyright": "http://rhizomik.net/ontologies/copyrightonto.owl#",
    "cordis": "http://cordis.europa.eu/projects/",
    "core": "http://vivoweb.org/ontology/core#",
    "coref": "http://www.rkbexplorer.com/ontologies/coref#",
    "cos": "http://www.inria.fr/acacia/corese#",
    "cosmo": "http://purl.org/ontology/cosmo#",
    "coun": "http://www.daml.org/2001/09/countries/iso-3166-ont#",
    "countries": "http://eulersharp.sourceforge.net/2003/03swap/countries#",
    "courseware": "http://courseware.rkbexplorer.com/ontologies/courseware#",
    "cpa": "http://www.ontologydesignpatterns.org/schemas/cpannotationschema.owl#",
    "cpack": "http://cliopatria.swi-prolog.org/schema/cpack#",
    "cpant": "http://purl.org/NET/cpan-uri/terms#",
    "cpi": "http://www.ebusiness-unibw.org/ontologies/cpi/ns#",
    "cpm": "http://catalogus-professorum.org/cpm/2/",
    "cpov": "http://data.europa.eu/m8g/",
    "cpsv": "http://purl.org/vocab/cpsv#",
    "cpv": "http://purl.org/weso/cpv/",
    "crime": "http://purl.org/vocab/reloc/",
    "crm": "http://www.cidoc-crm.org/cidoc-crm/",
    "crmdig": "http://www.ics.forth.gr/isl/CRMdig/",
    "crminf": "http://www.cidoc-crm.org/cidoc-crm/CRMinf/",
    "crml": "http://semweb.mmlab.be/ns/rml/condition#",
    "cro": "http://rhizomik.net/ontologies/copyrightonto.owl#",
    "crowd": "http://purl.org/crowd/",
    "crsw": "http://courseware.rkbexplorer.com/ontologies/courseware#",
    "crtv": "http://open-services.net/ns/crtv#",
    "crv": "http://purl.org/twc/vocab/datacarver#",
    "crypto": "http://www.w3.org/2000/10/swap/crypto#",
    "cs": "http://purl.org/vocab/changeset/schema#",
    "csdbp": "http://cs.dbpedia.org/",
    "cska": "http://pfclitex.com/",
    "csm": "http://purl.org/csm/1.0#",
    "csp": "http://vocab.deri.ie/csp#",
    "csv": "http://vocab.sindice.net/csv/",
    "csvw": "http://www.w3.org/ns/csvw#",
    "ct": "http://data.linkedct.org/resource/linkedct/",
    "ctag": "http://commontag.org/ns#",
    "ctorg": "http://purl.org/ctic/infraestructuras/organizacion#",
    "ctrl": "https://w3id.org/ibp/CTRLont#",
    "cts2": "http://schema.omg.org/spec/CTS2/1.0/",
    "ctxdesc": "http://www.demcare.eu/ontologies/contextdescriptor.owl#",
    "cube": "http://purl.org/linked-data/cube#",
    "cubeont": "http://ontology.cube.global/",
    "cue": "http://www.clarin.eu/cmdi/cues/display/1.0#",
    "curr": "https://w3id.org/cc#",
    "custom": "http://www.openrdf.org/config/sail/custom#",
    "customer": "http://www.valuelabs.com/",
    "cv": "http://rdfs.org/resume-rdf/",
    "cvbase": "http://purl.org/captsolo/resume-rdf/0.2/base#",
    "cwl": "https://w3id.org/cwl/cwl#",
    "cwlgit": "https://w3id.org/cwl/view/git/",
    "cwlprov": "https://w3id.org/cwl/prov#",
    "cwork": "http://www.bbc.co.uk/ontologies/creativework/",
    "cwrc": "http://sparql.cwrc.ca/ontology/cwrc#",
    "cyc": "http://sw.opencyc.org/concept/",
    "cycann": "http://sw.cyc.com/CycAnnotations_v1#",
    "d0": "http://ontologydesignpatterns.org/ont/wikipedia/d0.owl#",
    "d2d": "http://rdfns.org/d2d/",
    "d2r": "http://sites.wiwiss.fu-berlin.de/suhl/bizer/d2r-server/config.rdf#",
    "d2rq": "http://www.wiwiss.fu-berlin.de/suhl/bizer/D2RQ/0.1#",
    "d3s": "http://vocbench.solidaridad.cloud/taxonomies#",
    "da": "https://www.wowman.org/index.php?id=1&type=get#",
    "dady": "http://purl.org/NET/dady#",
    "daia": "http://purl.org/ontology/daia/",
    "daiaserv": "http://purl.org/ontology/daia/Service/",
    "dailymed": "http://www4.wiwiss.fu-berlin.de/dailymed/resource/dailymed/",
    "daisy": "http://www.daisy.org/z3998/2012/vocab/",
    "daml": "http://www.daml.org/2001/03/daml+oil#",
    "dannet": "http://www.wordnet.dk/owl/instance/2009/03/instances/",
    "dao": "http://purl.org/dao#",
    "daq": "http://purl.org/eis/vocab/daq#",
    "dash": "http://datashapes.org/dash#",
    "data": "http://data.odw.tw/",
    "datacite": "http://purl.org/spar/datacite/",
    "datacron": "http://www.datacron-project.eu/datAcron#",
    "datafaqs": "http://purl.org/twc/vocab/datafaqs#",
    "dataid": "http://dataid.dbpedia.org/ns/core#",
    "date": "http://contextus.net/ontology/ontomedia/misc/date#",
    "datex": "http://vocab.datex.org/terms#",
    "dawgt": "http://www.w3.org/2001/sw/DataAccess/tests/tests-dawg#",
    "days": "http://ontologi.es/days#",
    "dayta": "http://dayta.me/resource#",
    "db": "http://dbpedia.org/",
    "dbc": "http://dbpedia.org/resource/Category:",
    "dbcat": "http://dbpedia.org/resource/Category:",
    "dbfo": "http://dbpedia.org/facts/ontology#",
    "dbkwik": "http://dbkwik.webdatacommons.org/",
    "dblp": "http://dblp.uni-trier.de/rdf/schema-2015-01-26#",
    "dbms": "http://www.openlinksw.com/ontology/dbms-app-ontology#",
    "dbnary": "http://kaiko.getalp.org/dbnary#",
    "dbo": "http://dbpedia.org/ontology/",
    "dbp": "http://dbpedia.org/property/",
    "dbpedia": "http://dbpedia.org/resource/",
    "dbpedia2": "http://dbpedia.org/property/",
    "dbpediaowl": "http://dbpedia.org/ontology/",
    "dbpo": "http://dbpedia.org/ontology/",
    "dbpp": "http://dbpedia.org/property/",
    "dbpprop": "http://dbpedia.org/property/",
    "dbpr": "http://dbpedia.org/resource/",
    "dbprop": "http://dbpedia.org/property/",
    "dbptmpl": "http://dbpedia.org/resource/Template:",
    "dbr": "http://dbpedia.org/resource/",
    "dbrc": "http://dbpedia.org/resource/Category:",
    "dbt": "http://dbpedia.org/resource/Template:",
    "dbtont": "http://dbtropes.org/ont/",
    "dbug": "http://ontologi.es/doap-bugs#",
    "dbyago": "http://dbpedia.org/class/yago/",
    "dc": "http://purl.org/dc/elements/1.1/",
    "dc11": "http://purl.org/dc/elements/1.1/",
    "dcam": "http://purl.org/dc/dcam/",
    "dcap": "http://purl.org/ws-mmi-dc/terms/",
    "dcat": "http://www.w3.org/ns/dcat#",
    "dcatapit": "http://dati.gov.it/onto/dcatapit#",
    "dcatnl": "http://standaarden.overheid.nl/dcatnl/terms/",
    "dce": "http://purl.org/dc/elements/1.1/",
    "dcite": "http://purl.org/spar/datacite/",
    "dcm": "http://dcm.com/",
    "dcmit": "http://purl.org/dc/dcmitype/",
    "dcmitype": "http://purl.org/dc/dcmitype/",
    "dcn": "http://www.w3.org/2007/uwa/context/deliverycontext.owl#",
    "dcndl": "http://ndl.go.jp/dcndl/terms/",
    "dco": "http://info.deepcarbon.net/schema#",
    "dcodata": "http://info.deepcarbon.net/data/schema#",
    "dcodt": "http://info.deepcarbon.net/datatype/schema#",
    "dcoid": "http://dx.deepcarbon.net/",
    "dcosample": "http://info.deepcarbon.net/sample/schema#",
    "dcq": "http://purl.org/dc/qualifiers/1.0/",
    "dcr": "http://www.isocat.org/ns/dcr.rdf#",
    "dcs": "http://ontologi.es/doap-changeset#",
    "dct": "http://purl.org/dc/terms/",
    "dcterm": "http://purl.org/dc/terms/",
    "dcterms": "http://purl.org/dc/terms/",
    "dctype": "http://purl.org/dc/dcmitype/",
    "dctypes": "http://purl.org/dc/dcmitype/",
    "dcx": "http://dublincore.org/dcx/",
    "ddb": "http://www.deutsche-digitale-bibliothek.de/edm/",
    "ddc": "http://purl.org/NET/decimalised#",
    "ddl": "http://purl.org/vocab/riro/ddl#",
    "dead": "http://utpl.edu.ec/sbc/data/",
    "decision": "https://decision-ontology.googlecode.com/svn/trunk/decision.owl#",
    "decl": "http://www.linkedmodel.org/1.0/schema/decl#",
    "decprov": "http://promsns.org/def/decprov#",
    "defns": "http://www.openarchives.org/OAI/2.0/",
    "delta": "http://www.w3.org/2004/delta#",
    "demlab": "http://www.demcare.eu/ontologies/demlab.owl#",
    "deo": "http://purl.org/spar/deo/",
    "deps": "http://ontologi.es/doap-deps#",
    "derecho": "http://purl.org/derecho#",
    "devuan": "https://devuan.net.br/",
    "dgfoaf": "http://west.uni-koblenz.de/ontologies/2010/07/dgfoaf.owl#",
    "dgfr": "http://colin.maudry.com/ontologies/dgfr#",
    "dgtwc": "http://data-gov.tw.rpi.edu/2009/data-gov-twc.rdf#",
    "diag": "http://www.loc.gov/zing/srw/diagnostic/",
    "dicera": "http://semweb.mmlab.be/ns/dicera#",
    "dicom": "http://purl.org/healthcarevocab/v1#",
    "dio": "https://w3id.org/dio#",
    "dir": "http://schemas.talis.com/2005/dir/schema#",
    "dis": "http://stanbol.apache.org/ontology/disambiguation/disambiguation#",
    "disco": "http://rdf-vocabulary.ddialliance.org/discovery#",
    "disease": "http://www.agfa.com/w3c/2009/humanDisorder#",
    "diseasome": "http://www4.wiwiss.fu-berlin.de/diseasome/resource/diseasome/",
    "dita": "http://purl.org/dita/ns#",
    "dive": "http://scubadive.networld.to/dive.rdf#",
    "dk": "http://www.data-knowledge.org/dk/schema/rdf/latest/",
    "dl": "http://ontology.ip.rm.cnr.it/ontologies/DOLCE-Lite#",
    "dm2e": "http://onto.dm2e.eu/schemas/dm2e/",
    "dn": "http://purl.org/datanode/ns/",
    "dnb": "http://d-nb.info/gnd/",
    "dnbt": "http://d-nb.info/standards/elementset/dnb#",
    "dnr": "http://www.dotnetrdf.org/configuration#",
    "doac": "http://ramonantonio.net/doac/0.1/#",
    "doacc": "http://purl.org/net/bel-epa/doacc#",
    "doap": "http://usefulinc.com/ns/doap#",
    "doas": "http://deductions.github.io/doas.owl.ttl#",
    "doc": "http://www.w3.org/2000/10/swap/pim/doc#",
    "docker": "http://www.w3.org/ns/bde/docker/",
    "doclist": "http://www.junkwork.net/xml/DocumentList#",
    "doco": "http://purl.org/spar/doco/",
    "dogont": "http://elite.polito.it/ontologies/dogont.owl#",
    "doi": "https://doi.org/",
    "door": "http://kannel.open.ac.uk/ontology#",
    "dossier": "https://lod.milieuinfo.be/ns/dossier#",
    "dot": "https://w3id.org/dot#",
    "dpc": "http://hospee.org/ontologies/dpc/",
    "dpd": "http://www.kanzaki.com/ns/dpd#",
    "dpl": "http://dbpedialite.org/things/",
    "dpla": "http://dp.la/info/developers/map/",
    "dpn": "http://purl.org/dpn#",
    "dq": "http://def.seegrid.csiro.au/isotc211/iso19115/2003/dataquality#",
    "dqc": "http://semwebquality.org/ontologies/dq-constraints#",
    "dqm": "http://purl.org/dqm-vocabulary/v1/dqm#",
    "dqv": "http://www.w3.org/ns/dqv#",
    "dr": "http://purl.org/swan/2.0/discourse-relationships/",
    "driver": "http://deductions.github.io/drivers.owl.ttl#",
    "drm": "http://vocab.data.gov/def/drm#",
    "drug": "http://www.agfa.com/w3c/2009/drugTherapy#",
    "drugbank": "http://www4.wiwiss.fu-berlin.de/drugbank/resource/drugbank/",
    "ds": "http://purl.org/ctic/dcat#",
    "dsfv": "http://sws.ifi.uio.no/vocab/dsf/henriwi/dsf#",
    "dsn": "http://purl.org/dsnotify/vocab/eventset/",
    "dso": "http://purl.org/ontology/dso#",
    "dsp": "http://purl.org/metainfo/terms/dsp#",
    "dssn": "http://purl.org/net/dssn/",
    "dsv": "http://purl.org/iso25964/DataSet/Versioning#",
    "dsw": "http://purl.org/dsw/",
    "dt": "http://dbpedia.org/datatype/",
    "dto": "http://www.datatourisme.fr/ontology/core/1.0#",
    "dtype": "http://www.linkedmodel.org/schema/dtype#",
    "dul": "http://www.ontologydesignpatterns.org/ont/dul/DUL.owl#",
    "dummy": "http://hello.com/",
    "duv": "http://www.w3.org/ns/duv#",
    "dv": "http://rdf.data-vocabulary.org/#",
    "dvia": "http://data.eurecom.fr/ontology/dvia#",
    "dwc": "http://rs.tdwg.org/dwc/terms/",
    "dwciri": "http://rs.tdwg.org/dwc/iri/",
    "eame": "http://www.semanticweb.org/ontologia_EA#",
    "ean": "http://openean.kaufkauf.net/id/",
    "earl": "http://www.w3.org/ns/earl#",
    "eat": "http://www.eat.rl.ac.uk/#",
    "ebu": "http://semantic.eurobau.com/eurobau-utility.owl#",
    "ebucore": "http://www.ebu.ch/metadata/ontologies/ebucore/ebucore#",
    "ec": "http://eulergui.sourceforge.net/contacts.owl.n3#",
    "ecb": "http://ecb.270a.info/class/1.0/",
    "ecc": "https://ns.eccenca.com/",
    "eccauth": "https://vocab.eccenca.com/auth/",
    "eccdi": "https://vocab.eccenca.com/di/",
    "eccpubsub": "https://vocab.eccenca.com/pubsub/",
    "eccrev": "https://vocab.eccenca.com/revision/",
    "ecgl": "http://schema.geolink.org/",
    "ecglview": "http://schema.geolink.org/view/",
    "eclap": "http://www.eclap.eu/schema/eclap/",
    "eco": "http://www.ebusiness-unibw.org/ontologies/eclass/5.1.4/#",
    "ecoll": "http://purl.org/ceu/eco/1.0#",
    "ecore": "http://www.eclipse.org/emf/2002/Ecore#",
    "ecos": "http://kmm.lboro.ac.uk/ecos/1.0#",
    "ecowlim": "http://ecowlim.tfri.gov.tw/lode/resource/",
    "ecpo": "http://purl.org/ontology/ecpo#",
    "ecrm": "http://erlangen-crm.org/current/",
    "ecs": "http://rdf.ecs.soton.ac.uk/ontology/ecs#",
    "edac": "http://ontology.cybershare.utep.edu/ELSEWeb/elseweb-edac.owl#",
    "edam": "http://edamontology.org/",
    "edg": "http://edg.topbraid.solutions/model/",
    "edgar": "http://edgarwrap.ontologycentral.com/vocab/edgar#",
    "edgarcik": "http://edgarwrap.ontologycentral.com/cik/",
    "edm": "http://www.europeana.eu/schemas/edm/",
    "edr": "https://w3id.org/laas-iot/edr#",
    "eem": "http://purl.org/eem#",
    "eepsa": "https://w3id.org/eepsa#",
    "efd": "http://data.foodanddrinkeurope.eu/ontology#",
    "efo": "http://www.ebi.ac.uk/efo/",
    "efrbroo": "http://erlangen-crm.org/efrbroo/",
    "eg": "http://eulergui.sourceforge.net/engine.owl#",
    "ekaw": "http://data.semanticweb.org/conference/ekaw/2012/complete/",
    "elec": "http://purl.org/ctic/sector-publico/elecciones#",
    "eli": "http://data.europa.eu/eli/ontology#",
    "elod": "http://linkedeconomy.org/ontology#",
    "elog": "http://eulersharp.sourceforge.net/2003/03swap/log-rules#",
    "emergel": "http://purl.org/emergel/core#",
    "emergelm": "http://purl.org/emergel/modules#",
    "emoca": "http://ns.inria.fr/emoca#",
    "emotion": "http://ns.inria.fr/emoca#",
    "emp": "http://purl.org/ctic/empleo/oferta#",
    "employee": "http://www.employee.com/data#",
    "emtr": "http://purl.org/NET/ssnext/electricmeters#",
    "enc": "http://www.w3.org/2001/04/xmlenc#",
    "ends": "http://labs.mondeca.com/vocab/endpointStatus#",
    "enhancer": "http://stanbol.apache.org/ontology/enhancer/enhancer#",
    "ens": "http://models.okkam.org/ENS-core-vocabulary.owl#",
    "ensembl": "http://rdf.ebi.ac.uk/resource/ensembl/",
    "environ": "http://eulersharp.sourceforge.net/2003/03swap/environment#",
    "eol": "http://purl.org/biodiversity/eol/",
    "ep": "http://eprints.org/ontology/",
    "eprints": "http://eprints.org/ontology/",
    "erce": "http://xxefe.de/",
    "ero": "http://purl.obolibrary.org/obo/",
    "es": "http://eulersharp.sourceforge.net/2003/03swap/log-rules#",
    "esadm": "http://vocab.linkeddata.es/datosabiertos/def/sector-publico/territorio#",
    "esair": "http://vocab.linkeddata.es/datosabiertos/def/medio-ambiente/calidad-aire#",
    "esaloj": "http://vocab.linkeddata.es/datosabiertos/def/turismo/alojamiento#",
    "esapar": "http://vocab.linkeddata.es/datosabiertos/def/urbanismo-infraestructuras/aparcamiento#",
    "escjr": "http://vocab.linkeddata.es/datosabiertos/def/urbanismo-infraestructuras/callejero#",
    "esco": "http://data.europa.eu/esco/model#",
    "escom": "http://vocab.linkeddata.es/datosabiertos/def/comercio/tejidoComercial#",
    "esd": "http://def.esd.org.uk/",
    "esdbpr": "http://es.dbpedia.org/resource/",
    "esdir": "http://vocab.linkeddata.es/datosabiertos/def/urbanismo-infraestructuras/direccionPostal#",
    "eseduc": "http://www.purl.org/ontologia/eseduc#",
    "esequip": "http://vocab.linkeddata.es/datosabiertos/def/urbanismo-infraestructuras/equipamiento#",
    "espresup": "http://vocab.linkeddata.es/datosabiertos/def/hacienda/presupuestos#",
    "esproc": "http://vocab.linkeddata.es/datosabiertos/def/sector-publico/procedimientos#",
    "essglobal": "http://purl.org/essglobal/vocab/v1.0/",
    "estatgph": "http://estatwrap.ontologycentral.com/id/nama_aux_gph#",
    "estatwrap": "http://ontologycentral.com/2009/01/eurostat/ns#",
    "estrf": "http://vocab.linkeddata.es/datosabiertos/def/transporte/trafico#",
    "estrn": "http://vocab.linkeddata.es/datosabiertos/def/urbanismo-infraestructuras/transporte#",
    "ethc": "http://ethoinformatics.org/ethocore/",
    "eu": "http://eulersharp.sourceforge.net/2003/03swap/log-rules#",
    "eui": "http://institutions.publicdata.eu/#",
    "eumida": "http://data.kasabi.com/dataset/eumida/terms/",
    "eunis": "http://eunis.eea.europa.eu/rdf/species-schema.rdf#",
    "eurlex": "http://eur-lex.publicdata.eu/ontology/",
    "eurostat": "http://wifo5-04.informatik.uni-mannheim.de/eurostat/resource/eurostat/",
    "eustd": "http://eurostat.linked-statistics.org/data#",
    "euvoc": "http://publications.europa.eu/ontology/euvoc#",
    "ev": "http://www.w3.org/2001/xml-events/",
    "event": "http://purl.org/NET/c4dm/event.owl#",
    "events": "http://eulersharp.sourceforge.net/2003/03swap/event#",
    "evident": "http://purl.org/net/evident#",
    "evopat": "http://ns.aksw.org/Evolution/",
    "evset": "http://dsnotify.org/vocab/eventset/0.1/",
    "ex": "http://example.org/",
    "example": "http://www.example.org/rdf#",
    "exif": "http://www.w3.org/2003/12/exif/ns#",
    "ext": "http://def.seegrid.csiro.au/isotc211/iso19115/2003/extent#",
    "exterms": "http://www.example.org/terms/",
    "eye": "http://jena.hpl.hp.com/Eyeball#",
    "ezcontext": "http://ontologies.ezweb.morfeo-project.org/ezcontext/ns#",
    "eztag": "http://ontologies.ezweb.morfeo-project.org/eztag/ns#",
    "fab": "http://purl.org/fab/ns#",
    "fabio": "http://purl.org/spar/fabio/",
    "factbook": "http://wifo5-04.informatik.uni-mannheim.de/factbook/ns#",
    "faldo": "http://biohackathon.org/resource/faldo#",
    "fam": "http://vocab.fusepool.info/fam#",
    "fao": "http://fao.270a.info/dataset/",
    "faostat": "http://reference.eionet.europa.eu/faostat/schema/",
    "faq": "http://www.openlinksw.com/ontology/faq#",
    "fb": "http://rdf.freebase.com/ns/",
    "fbgeo": "http://rdf.freebase.com/ns/location/geocode/",
    "fc": "http://www.freeclass.eu/freeclass_v1#",
    "fcm": "http://eulersharp.sourceforge.net/2006/02swap/fcm#",
    "fcp": "http://www.newmedialab.at/fcp/",
    "fcs": "http://clarin.eu/fcs/resource#",
    "fct": "http://openlinksw.com/services/facets/1.0/",
    "fd": "http://foodable.co/ns/",
    "fdbp": "http://fr.dbpedia.org/property/",
    "fe": "http://www.ontologydesignpatterns.org/ont/framenet/abox/fe/",
    "fea": "http://vocab.data.gov/def/fea#",
    "fec": "http://www.rdfabout.com/rdf/schema/usfec/",
    "fed": "http://www.openrdf.org/config/sail/federation#",
    "fhir": "http://hl7.org/fhir/",
    "figigii": "http://www.omg.org/spec/FIGI/GlobalInstrumentIdentifiers/",
    "fincaselaw": "http://purl.org/finlex/schema/oikeus/",
    "fingal": "http://vocab.deri.ie/fingal#",
    "finlaw": "http://purl.org/finlex/schema/laki/",
    "fire": "http://tldp.org/HOWTO/XML-RPC-HOWTO/xmlrpc-howto-java.html#",
    "fise": "http://fise.iks-project.eu/ontology/",
    "fl": "http://eulersharp.sourceforge.net/2003/03swap/fl-rules#",
    "flow": "http://www.w3.org/2005/01/wf/flow#",
    "fls": "http://lukasblaho.sk/football_league_schema#",
    "fluidops": "http://www.fluidops.com/",
    "fma": "http://sig.uw.edu/fma#",
    "fn": "http://www.w3.org/2005/xpath-functions#",
    "fnabox": "http://www.ontologydesignpatterns.org/ont/framenet/abox/",
    "fnml": "http://semweb.mmlab.be/ns/fnml#",
    "fno": "http://w3id.org/function/ontology#",
    "fntbox": "http://www.ontologydesignpatterns.org/ont/framenet/tbox/",
    "fo": "http://www.w3.org/1999/XSL/Format#",
    "foaf": "http://xmlns.com/foaf/0.1/",
    "foaffff": "http://gogl.com/",
    "foam": "https://www.koerperfettwaage-tests.de/",
    "fog": "https://w3id.org/fog#",
    "foo": "http://filmontology.org/ontology/1.0/",
    "food": "http://purl.org/foodontology#",
    "form": "http://deductions-software.com/ontologies/forms.owl.ttl#",
    "formats": "http://www.w3.org/ns/formats/",
    "fos": "http://futurios.org/fos/spec/",
    "fowl": "http://www.w3.org/TR/2003/PR-owl-guide-20031209/food#",
    "fp3": "http://vocab.fusepool.info/fp3#",
    "fr": "https://w3id.org/fr/def/core#",
    "frad": "http://iflastandards.info/ns/fr/frad/",
    "frame": "http://www.ontologydesignpatterns.org/ont/framenet/abox/frame/",
    "frapo": "http://purl.org/cerif/frapo/",
    "frappe": "http://streamreasoning.org/ontologies/frappe#",
    "frb": "http://frb.270a.info/dataset/",
    "frbr": "http://purl.org/vocab/frbr/core#",
    "frbrcore": "http://purl.org/vocab/frbr/core#",
    "frbre": "http://purl.org/vocab/frbr/extended#",
    "frbrer": "http://iflastandards.info/ns/fr/frbr/frbrer/",
    "frbroo": "http://iflastandards.info/ns/fr/frbr/frbroo/",
    "fred": "http://www.ontologydesignpatterns.org/ont/fred/domain.owl#",
    "freebase": "http://rdf.freebase.com/ns/",
    "fresnel": "http://www.w3.org/2004/09/fresnel#",
    "frgeo": "http://rdf.insee.fr/geo/",
    "friends": "http://www.openarchives.org/OAI/2.0/friends/",
    "frir": "http://purl.org/twc/ontology/frir.owl#",
    "frsad": "http://iflastandards.info/ns/fr/frsad/",
    "fssp": "http://linkeddata.fssprus.ru/resource/",
    "ftcontent": "http://www.ft.com/ontology/content/",
    "fun": "http://w3id.org/sparql-generate/fn/",
    "func": "http://www.w3.org/2007/rif-builtin-function#",
    "fuseki": "http://jena.apache.org/fuseki#",
    "gadm": "http://gadm.geovocab.org/ontology#",
    "gaf": "http://groundedannotationframework.org/",
    "galaksiya": "http://ontoloji.galaksiya.com/vocab/",
    "game": "http://data.totl.net/game/",
    "gastro": "http://www.ebsemantics.net/gastro#",
    "gawd": "http://gawd.atlantides.org/terms/",
    "gazetteer": "http://data.ordnancesurvey.co.uk/ontology/50kGazetteer/",
    "gbol": "http://gbol.life/0.1#",
    "gbv": "http://purl.org/ontology/gbv/",
    "gc": "http://www.oegov.org/core/owl/gc#",
    "gci": "http://ontology.eil.utoronto.ca/GCI/Foundation/GCI-Foundation.owl#",
    "gcis": "http://data.globalchange.gov/gcis.owl#",
    "gd": "http://rdf.data-vocabulary.org/#",
    "gdc": "https://portal.gdc.cancer.gov/cases/",
    "gdpr": "https://vocab.eccenca.com/gdpr/",
    "gdprov": "https://w3id.org/GDPRov#",
    "gdprtext": "https://w3id.org/GDPRtEXT#",
    "gelo": "http://krauthammerlab.med.yale.edu/ontologies/gelo#",
    "gen": "http://purl.org/gen/0.1#",
    "genab": "http://eulersharp.sourceforge.net/2003/03swap/genomeAbnormality#",
    "genea": "http://www.owl-ontologies.com/generations.owl#",
    "geo": "http://www.w3.org/2003/01/geo/wgs84_pos#",
    "geo7": "https://www.geo7.ch/",
    "geocontext": "http://www.geocontext.org/publ/2013/vocab#",
    "geod": "http://vocab.lenka.no/geo-deling#",
    "geodata": "http://sws.geonames.org/",
    "geoes": "http://geo.linkeddata.es/ontology/",
    "geof": "http://www.opengis.net/def/function/geosparql/",
    "geofla": "http://data.ign.fr/ontologies/geofla#",
    "geographis": "http://telegraphis.net/ontology/geography/geography#",
    "geojson": "http://ld.geojson.org/vocab#",
    "geoloc": "http://deductions.github.io/geoloc.owl.ttl#",
    "geom": "http://data.ign.fr/def/geometrie#",
    "geonames": "http://www.geonames.org/ontology#",
    "geop": "http://aims.fao.org/aos/geopolitical.owl#",
    "geor": "http://www.opengis.net/def/rule/geosparql/",
    "georss": "http://www.georss.org/georss/",
    "geos": "http://www.telegraphis.net/ontology/geography/geography#",
    "geosp": "http://rdf.geospecies.org/ont/geospecies#",
    "geosparql": "http://www.opengis.net/ont/geosparql#",
    "geospecies": "http://rdf.geospecies.org/ont/geospecies#",
    "geovocab": "http://geovocab.org/",
    "geovoid": "http://purl.org/geovocamp/ontology/geovoid/",
    "germplasm": "http://purl.org/germplasm/terms#",
    "gesis": "http://lod.gesis.org/lodpilot/ALLBUS/vocab.rdf#",
    "gf": "http://def.seegrid.csiro.au/isotc211/iso19109/2005/feature#",
    "gfo": "http://www.onto-med.de/ontologies/gfo.owl#",
    "gg": "http://www.gemeentegeschiedenis.nl/gg-schema#",
    "gist": "http://ontologies.semanticarts.com/gist/",
    "giving": "http://ontologi.es/giving#",
    "gl": "http://schema.geolink.org/",
    "gldp": "http://www.w3.org/ns/people#",
    "globalcube": "http://kalmar32.fzi.de/triples/global-cube.ttl#",
    "glview": "http://schema.geolink.org/dev/view/",
    "glycan": "http://purl.jp/bio/12/glyco/glycan#",
    "gm": "http://def.seegrid.csiro.au/isotc211/iso19107/2003/geometry#",
    "gml": "http://www.opengis.net/ont/gml#",
    "gn": "http://www.geonames.org/ontology#",
    "gnd": "http://d-nb.info/gnd/",
    "gndo": "http://d-nb.info/standards/elementset/gnd#",
    "gnm": "http://www.geonames.org/ontology/mappings/",
    "gns": "http://sws.geonames.org/",
    "gnvc": "http://purl.org/gc/",
    "go": "http://purl.org/obo/owl/GO#",
    "goaf": "http://goaf.fr/goaf#",
    "gob": "http://purl.org/ontology/last-fm/",
    "gobierno": "http://www.gobierno.es/gobierno/",
    "goef": "http://purl.org/twc/vocab/goef#",
    "gold": "http://purl.org/linguistics/gold/",
    "gont": "https://gont.ch/",
    "goog": "http://schema.googleapis.com/",
    "gov": "http://gov.genealogy.net/ontology.owl#",
    "govtrackus": "http://www.rdfabout.com/rdf/usgov/geo/us/",
    "govwild": "http://govwild.org/0.6/GWOntology.rdf/",
    "gpml": "http://vocabularies.wikipathways.org/gpml#",
    "gpt": "http://purl.org/vocab/riro/gpt#",
    "gq": "http://genomequest.com/",
    "gr": "http://purl.org/goodrelations/v1#",
    "graffle": "http://purl.org/twc/vocab/vsr/graffle#",
    "granatum": "http://chem.deri.ie/granatum/",
    "graves": "http://rdf.muninn-project.org/ontologies/graves#",
    "grddl": "http://www.w3.org/2003/g/data-view#",
    "greg": "http://kasei.us/about/foaf.xrdf#",
    "grel": "http://semweb.datasciencelab.be/ns/grel#",
    "gridworks": "http://purl.org/net/opmv/types/gridworks#",
    "grs": "http://www.georss.org/georss/",
    "gs1": "http://gs1.org/voc/",
    "gso": "http://www.w3.org/2006/gen/ont#",
    "gsp": "http://www.opengis.net/ont/geosparql#",
    "gt": "https://vocab.eccenca.com/geniustex/",
    "gtfs": "http://vocab.gtfs.org/terms#",
    "gts": "http://resource.geosciml.org/ontology/timescale/gts#",
    "guo": "http://purl.org/hpi/guo#",
    "gv": "http://rdf.data-vocabulary.org/#",
    "gvoi": "http://assemblee-virtuelle.github.io/grands-voisins-v2/gv.owl.ttl#",
    "gvoith": "http://assemblee-virtuelle.github.io/grands-voisins-v2/thesaurus.ttl#",
    "gvp": "http://vocab.getty.edu/ontology#",
    "gxa": "http://www.ebi.ac.uk/gxa/",
    "h2o": "http://def.seegrid.csiro.au/isotc211/iso19150/-2/2012/basic#",
    "h5": "http://buzzword.org.uk/rdf/h5#",
    "ha": "http://sensormeasurement.appspot.com/ont/home/homeActivity#",
    "halyard": "http://merck.github.io/Halyard/ns#",
    "hard": "http://www.w3.org/2007/uwa/context/hardware.owl#",
    "harrisons": "http://harrisons.cc/",
    "hartigprov": "http://purl.org/net/provenance/ns#",
    "hasco": "http://hadatac.org/ont/hasco/",
    "hasneto": "http://hadatac.org/ont/hasneto#",
    "hcard": "http://purl.org/uF/hCard/terms/",
    "hcterms": "http://purl.org/uF/hCard/terms/",
    "hdo": "http://www.samos.gr/ontologies/helpdeskOnto.owl#",
    "health": "http://purl.org/twc/health/vocab/",
    "healthcare": "http://www.agfa.com/w3c/2009/healthCare#",
    "hello": "https://www.youtube.com/user/SuperTellAFriend/featured/",
    "hemogram": "http://www.agfa.com/w3c/2009/hemogram#",
    "hg": "http://www.holygoat.co.uk/owl/redwood/0.1/tags/",
    "hgnc": "http://bio2rdf.org/hgnc:",
    "hico": "http://purl.org/emmedi/hico/",
    "hifm": "http://purl.org/net/hifm/data#",
    "hints2005": "http://purl.org/twc/cabig/model/HINTS2005-1.owl#",
    "hlisting": "http://sindice.com/hlisting/0.1/",
    "hlygt": "http://www.holygoat.co.uk/owl/redwood/0.1/tags/",
    "holding": "http://purl.org/ontology/holding#",
    "hospital": "http://www.agfa.com/w3c/2009/hospital#",
    "hp": "http://purl.org/voc/hp/",
    "hr": "http://iserve.kmi.open.ac.uk/ns/hrests#",
    "htir": "http://www.w3.org/2011/http#",
    "html": "http://izmus.cz/#",
    "hto": "http://project-haystack.org/hto#",
    "http": "http://www.w3.org/2011/http#",
    "httph": "http://www.w3.org/2007/ont/httph#",
    "httpm": "http://www.w3.org/2011/http-methods#",
    "httpvoc": "http://www.w3.org/2006/http#",
    "human": "http://eulersharp.sourceforge.net/2003/03swap/human#",
    "humanbody": "http://eulersharp.sourceforge.net/2003/03swap/humanBody#",
    "huto": "http://ns.inria.fr/huto/",
    "hva": "http://www.ebusiness-unibw.org/ontologies/hva/ontology#",
    "hxl": "http://hxl.humanitarianresponse.info/ns/#",
    "hydra": "http://www.w3.org/ns/hydra/core#",
    "iab": "https://www.iab.com/guidelines/taxonomy/",
    "iana": "http://www.iana.org/assignments/relation/",
    "ianarel": "http://www.iana.org/assignments/relation/",
    "iao": "http://purl.obolibrary.org/obo/iao.owl#",
    "iati": "http://purl.org/collections/iati/",
    "ibis": "http://purl.org/ibis#",
    "ic": "http://imi.go.jp/ns/core/rdf#",
    "ical": "http://www.w3.org/2002/12/cal/ical#",
    "icaltzd": "http://www.w3.org/2002/12/cal/icaltzd#",
    "icane": "http://www.icane.es/opendata/vocab#",
    "id": "http://identifiers.org/",
    "idemo": "http://rdf.insee.fr/def/demo#",
    "identity": "http://purl.org/twc/ontologies/identity.owl#",
    "ideotalex": "http://www.ideotalex.eu/datos/recurso/",
    "ido": "http://purl.obolibrary.org/obo/ido.owl#",
    "ids": "https://w3id.org/idsa/core/",
    "ifc": "http://ifcowl.openbimstandards.org/IFC2X3_Final#",
    "ifcowl": "http://www.buildingsmart-tech.org/ifcOWL/IFC4_ADD2#",
    "igeo": "http://rdf.insee.fr/def/geo#",
    "ignf": "http://data.ign.fr/def/ignf#",
    "iiif": "http://iiif.io/api/image/2#",
    "ilap": "http://data.posccaesar.org/ilap/",
    "im": "http://imgpedia.dcc.uchile.cl/resource/",
    "imas": "https://sparql.crssnky.xyz/imasrdf/URIs/imas-schema.ttl#",
    "imf": "http://imf.270a.info/dataset/",
    "imind": "http://schema.intellimind.ns/symbology#",
    "imm": "http://schemas.microsoft.com/imm/",
    "imo": "http://imgpedia.dcc.uchile.cl/ontology#",
    "imreg": "http://www.w3.org/2004/02/image-regions#",
    "ims": "http://www.imsglobal.org/xsd/imsmd_v1p2/",
    "incident": "http://vocab.resc.info/incident#",
    "infection": "http://www.agfa.com/w3c/2009/infectiousDisorder#",
    "infor": "http://www.ontologydesignpatterns.org/cp/owl/informationrealization.owl#",
    "infosys": "http://www.infosys.com/",
    "inno": "http://purl.org/innovation/ns#",
    "input": "http://volt-name.space/vocab/input#",
    "insdc": "http://ddbj.nig.ac.jp/ontologies/sequence#",
    "interval": "http://reference.data.gov.uk/def/intervals/",
    "intervals": "http://reference.data.gov.uk/def/intervals/",
    "iol": "http://www.ontologydesignpatterns.org/ont/dul/IOLite.owl#",
    "iospress": "http://ld.iospress.nl/rdf/ontology/",
    "iot": "http://www.linkedthings.com/iot/",
    "iotlite": "http://purl.oclc.org/NET/UNIS/fiware/iot-lite#",
    "ioto": "http://www.irit.fr/recherches/MELODI/ontologies/IoT-O#",
    "ipad": "http://www.padinthecity.com/",
    "ipo": "http://purl.org/ipo/core#",
    "ipsv": "http://id.esd.org.uk/list/",
    "ir": "http://www.ontologydesignpatterns.org/cp/owl/informationrealization.owl#",
    "ire": "http://www.ontologydesignpatterns.org/cpont/ire.owl#",
    "iron": "http://purl.org/ontology/iron#",
    "irrl": "http://www.ontologydesignpatterns.org/cp/owl/informationobjectsandrepresentationlanguages.owl#",
    "irstea": "http://ontology.irstea.fr/",
    "irsteaont": "http://ontology.irstea.fr/weather/ontology#",
    "irw": "http://www.ontologydesignpatterns.org/ont/web/irw.owl#",
    "is": "http://purl.org/ontology/is/core#",
    "isaterms": "http://purl.org/isaterms/",
    "isbd": "http://iflastandards.info/ns/isbd/elements/",
    "isbdu": "http://iflastandards.info/ns/isbd/unc/elements/",
    "isi": "http://purl.org/ontology/is/inst/",
    "isidore": "http://www.rechercheisidore.fr/class/",
    "iso": "http://purl.org/iso25964/skos-thes#",
    "iso37120": "http://ontology.eil.utoronto.ca/ISO37120.owl#",
    "isocat": "http://www.isocat.org/datcat/",
    "isothes": "http://purl.org/iso25964/skos-thes#",
    "ispra": "http://dati.isprambiente.it/ontology/core#",
    "isq": "http://purl.org/ontology/is/quality/",
    "ist": "http://purl.org/ontology/is/types/",
    "iswc": "http://annotation.semanticweb.org/2004/iswc#",
    "it": "http://www.influencetracker.com/ontology#",
    "italy": "http://data.kasabi.com/dataset/italy/schema/",
    "itcat": "http://th-brandenburg.de/ns/itcat#",
    "iter": "http://w3id.org/sparql-generate/iter/",
    "itm": "http://spi-fm.uca.es/spdef/models/genericTools/itm/1.0#",
    "its": "http://www.w3.org/2005/11/its/rdf#",
    "itsmo": "http://ontology.it/itsmo/v1#",
    "itsrdf": "http://www.w3.org/2005/11/its/rdf#",
    "ja": "http://jena.hpl.hp.com/2005/11/Assembler#",
    "java": "http://www.w3.org/2007/uwa/context/java.owl#",
    "jdbc": "http://d2rq.org/terms/jdbc/",
    "jerm": "http://jermontology.org/ontology/JERMOntology#",
    "jita": "http://aims.fao.org/aos/jita/",
    "jjd": "http://www.joshuajeeson.com/",
    "jolux": "http://data.legilux.public.lu/resource/ontology/jolux#",
    "jp1": "http://rdf.muninn-project.org/ontologies/jp1/",
    "jpo": "http://rdf.jpostdb.org/ontology/jpost.owl#",
    "jpost": "http://rdf.jpostdb.org/ontology/jpost.owl#",
    "json": "https://www.ecma-international.org/publications/files/ECMA-ST/ECMA-404.pdf#",
    "juso": "http://rdfs.co/juso/",
    "kai": "http://kai.uni-kiel.de/",
    "kb": "http://deductions.sf.net/ontology/knowledge_base.owl#",
    "kbp": "http://tackbp.org/2013/ontology#",
    "kbv": "https://id.kb.se/vocab/",
    "kdo": "http://kdo.render-project.eu/kdo#",
    "kees": "http://linkeddata.center/kees/v1#",
    "kegg": "http://bio2rdf.org/ns/kegg#",
    "keys": "http://purl.org/NET/c4dm/keys.owl#",
    "km4c": "http://www.disit.org/km4city/schema#",
    "kmgeo": "http://km.aifb.kit.edu/services/geo/ontology#",
    "kml": "http://www.opengis.net/kml/2.2#",
    "koly": "http://www.ensias.ma/",
    "kontakt": "http://richard.cyganiak.de/",
    "ksam": "http://kulturarvsdata.se/ksamsok#",
    "kupkb": "http://www.e-lico.eu/data/kupkb/",
    "kw": "http://kwantu.net/kw/",
    "kwijibo": "http://kwijibo.talis.com/",
    "l2sp": "http://www.linked2safety-project.eu/properties/",
    "l4a": "http://labels4all.info/ns/",
    "l4lod": "http://ns.inria.fr/l4lod/v2/",
    "laabs": "http://dbpedia.org/resource/",
    "label": "http://purl.org/net/vocab/2004/03/label#",
    "lang": "http://ontologi.es/lang/core#",
    "language": "http://id.loc.gov/vocabulary/iso639-1/",
    "languages": "http://eulersharp.sourceforge.net/2003/03swap/languages#",
    "laposte": "http://data.lirmm.fr/ontologies/laposte#",
    "lark1": "http://users.utcluj.ro/~raluca/ontology/Ontology1279614123500.owl#",
    "lastfm": "http://purl.org/ontology/last-fm/",
    "latitude": "https://www.w3.org/2006/vcard/ns#latitude#",
    "lawd": "http://lawd.info/ontology/",
    "lblodlg": "http://data.lblod.info/vocabularies/leidinggevenden/",
    "lc": "http://semweb.mmlab.be/ns/linkedconnections#",
    "lcdr": "http://ns.lucid-project.org/revision/",
    "lcsh": "http://id.loc.gov/authorities/subjects/",
    "lctr": "http://data.linkedct.org/vocab/resource/",
    "lcy": "http://purl.org/vocab/lifecycle/schema#",
    "lda": "http://purl.org/linked-data/api/vocab#",
    "ldap": "http://purl.org/net/ldap/",
    "lden": "http://www.linklion.org/lden/",
    "ldl": "https://w3id.org/ldpdl/ns#",
    "ldn": "https://www.w3.org/TR/ldn/#",
    "ldp": "http://www.w3.org/ns/ldp#",
    "ldq": "http://www.linkeddata.es/ontology/ldq#",
    "ldqm": "http://linkeddata.es/resource/ldqm/",
    "ldr": "http://purl.oclc.org/NET/ldr/ns#",
    "ldt": "https://www.w3.org/ns/ldt#",
    "ldvm": "http://linked.opendata.cz/ontology/ldvm/",
    "leak": "http://data.ontotext.com/resource/leak/",
    "leaks": "http://data.ontotext.com/resource/leak/",
    "led": "http://led.kmi.open.ac.uk/term/",
    "legal": "http://www.w3.org/ns/legal#",
    "lemon": "http://lemon-model.net/lemon#",
    "lemonuby": "http://lemon-model.net/lexica/uby/",
    "lex": "http://purl.org/lex#",
    "lexcz": "http://purl.org/lex/cz#",
    "lexicon": "http://www.example.org/lexicon#",
    "lexinfo": "http://www.lexinfo.net/ontology/2.0/lexinfo#",
    "lexvo": "http://lexvo.org/ontology#",
    "lfm": "http://purl.org/ontology/last-fm/",
    "lfn": "http://www.dotnetrdf.org/leviathan#",
    "lfov": "https://w3id.org/legal_form#",
    "lgd": "http://linkedgeodata.org/triplify/",
    "lgdm": "http://linkedgeodata.org/meta/",
    "lgdo": "http://linkedgeodata.org/ontology/",
    "lgdt": "http://linkedgeodata.org/triplify/",
    "lgt": "http://linkedgadget.com/wiki/Property:",
    "lgv": "http://linkedgeodata.org/ontology/",
    "lh": "http://vocab.inf.ed.ac.uk/library/holdings#",
    "lheo": "http://www.conjecto.com/ontology/2015/lheo#",
    "li": "http://def.seegrid.csiro.au/isotc211/iso19115/2003/lineage#",
    "lib": "http://purl.org/library/",
    "library": "http://purl.org/library/",
    "lido": "http://www.lido-schema.org/",
    "life": "http://life.deri.ie/schema/",
    "lifecycle": "http://purl.org/vocab/lifecycle/schema#",
    "like": "http://ontologi.es/like#",
    "lime": "http://www.w3.org/ns/lemon/lime#",
    "limo": "http://www.purl.org/limo-ontology/limo#",
    "limoo": "http://purl.org/LiMo/0.1/",
    "lindt": "https://w3id.org/lindt/voc#",
    "ling": "http://purl.org/voc/ling/",
    "lingvo": "http://www.lingvoj.org/ontology#",
    "lingvoj": "http://www.lingvoj.org/ontology#",
    "link": "http://www.w3.org/2006/link#",
    "linkedct": "http://data.linkedct.org/vocab/",
    "linkedmdb": "http://data.linkedmdb.org/sparql/",
    "linkrel": "https://www.w3.org/ns/iana/link-relations/relation#",
    "lio": "http://purl.org/net/lio#",
    "list": "http://www.w3.org/2000/10/swap/list#",
    "literal": "http://www.essepuntato.it/2010/06/literalreification/",
    "literature": "http://purl.org/net/cnyt-literature#",
    "ljkl": "http://teste.com/",
    "ll": "http://lodlaundromat.org/resource/",
    "llalg": "http://www.linklion.org/algorithm/",
    "lldr": "http://purl.oclc.org/NET/lldr/ns#",
    "llm": "http://lodlaundromat.org/metrics/ontology/",
    "llo": "http://lodlaundromat.org/ontology/",
    "llont": "http://www.linklion.org/ontology#",
    "llr": "http://lodlaundromat.org/resource/",
    "lmdb": "http://data.linkedmdb.org/movie/",
    "lmf": "http://www.lexinfo.net/lmf#",
    "lmm1": "http://www.ontologydesignpatterns.org/ont/lmm/LMM_L1.owl#",
    "lmm2": "http://www.ontologydesignpatterns.org/ont/lmm/LMM_L2.owl#",
    "lmo": "http://linkedmultimedia.org/sparql-mm/ns/2.0.0/ontology#",
    "lmu": "https://w3id.org/laas-iot/lmu#",
    "lmx": "http://www.w3.org/XML/1998/namespace/",
    "ln": "https://w3id.org/ln#",
    "loc": "http://www.w3.org/2007/uwa/context/location.owl#",
    "locah": "http://data.archiveshub.ac.uk/def/",
    "location": "http://sw.deri.org/2006/07/location/loc#",
    "locn": "http://www.w3.org/ns/locn#",
    "locwd": "http://purl.org/locwd/schema#",
    "lod2": "http://lod2.eu/schema/",
    "lodac": "http://lod.ac/ns/lodac#",
    "lode": "http://linkedevents.org/ontology/",
    "lofv": "http://purl.org/legal_form/vocab#",
    "log": "http://www.w3.org/2000/10/swap/log#",
    "logies": "https://data.vlaanderen.be/ns/logies#",
    "lom": "http://ltsc.ieee.org/rdf/lomv1p0/lom#",
    "lomvoc": "http://ltsc.ieee.org/rdf/lomv1p0/vocabulary#",
    "loted": "http://loted.eu/ontology#",
    "lotico": "http://www.lotico.com/resource/",
    "loticoowl": "http://www.lotico.com/ontology/",
    "loupe": "http://ont-loupe.linkeddata.es/def/core/",
    "lovc": "https://w3id.org/lovcube/ns/lovcube#",
    "lp": "http://launchpad.net/rdf/launchpad#",
    "lpeu": "http://purl.org/linkedpolitics/vocabulary/eu/plenary/",
    "lr": "http://linkedrecipes.org/schema/",
    "ls": "http://linkedspending.aksw.org/instance/",
    "lsc": "http://linkedscience.org/lsc/ns#",
    "lsd": "http://linkedwidgets.org/statisticaldata/ontology/",
    "lslife": "http://ontology.cybershare.utep.edu/ELSEWeb/elseweb-lifemapper.owl#",
    "lsmap": "http://ontology.cybershare.utep.edu/ELSEWeb/elseweb-data.owl#",
    "lso": "http://linkedspending.aksw.org/ontology/",
    "lsq": "http://lsq.aksw.org/vocab#",
    "lsqv": "http://lsq.aksw.org/vocab#",
    "lsweb": "http://ontology.cybershare.utep.edu/ELSEWeb/elseweb-data.owl#",
    "lswmo": "http://ontology.cybershare.utep.edu/ELSEWeb/elseweb-modelling.owl#",
    "lswpm": "http://ontology.cybershare.utep.edu/ELSEWeb/elseweb-lifemapper-parameters.owl#",
    "lt": "http://diplomski.nelakolundzija.org/LTontology.rdf#",
    "lu": "http://www.ontologydesignpatterns.org/ont/framenet/abox/lu/",
    "luc": "http://www.ontotext.com/owlim/lucene#",
    "ludo": "http://ns.inria.fr/ludo/v1#",
    "lv": "http://purl.org/lobid/lv#",
    "lvont": "http://lexvo.org/ontology#",
    "lw": "http://linkedwidgets.org/ontologies/",
    "lx": "http://purl.org/NET/lx#",
    "lyon": "http://dbpedia.org/resource/Lyon/",
    "lyou": "http://purl.org/linkingyou/",
    "m3": "http://sensormeasurement.appspot.com/m3#",
    "ma": "http://www.w3.org/ns/ma-ont#",
    "mads": "http://www.loc.gov/mads/rdf/v1#",
    "madsrdf": "http://www.loc.gov/mads/rdf/v1#",
    "maeco": "http://edg.topbraid.solutions/maeco/",
    "maet": "http://edg.topbraid.solutions/taxonomy/macroeconomics/",
    "malignneo": "http://www.agfa.com/w3c/2009/malignantNeoplasm#",
    "mammal": "http://lod.taxonconcept.org/ontology/p01/Mammalia/index.owl#",
    "mandaat": "http://data.vlaanderen.be/ns/mandaat#",
    "marcrel": "http://id.loc.gov/vocabulary/relators/",
    "marcrole": "http://id.loc.gov/vocabulary/relators/",
    "markus": "http://www.markus.com/",
    "marl": "http://www.gsi.dit.upm.es/ontologies/marl/ns#",
    "marshall": "http://sites.google.com/site/xgmaitc/",
    "maso": "http://securitytoolbox.appspot.com/MASO#",
    "master1": "http://idl.u-grenoble3.fr/",
    "math": "http://www.w3.org/2000/10/swap/math#",
    "mb": "http://dbtune.org/musicbrainz/resource/instrument/",
    "mbgd": "http://mbgd.genome.ad.jp/owl/mbgd.owl#",
    "md": "http://www.w3.org/ns/md#",
    "mdi": "http://w3id.org/multidimensional-interface/ontology#",
    "mdont": "http://ont.matchdeck.com/",
    "mds": "http://doc.metalex.eu/id/",
    "meat": "http://example.com/",
    "meb": "http://rdf.myexperiment.org/ontologies/base/",
    "media": "http://search.yahoo.com/searchmonkey/media/",
    "medred": "http://w3id.org/medred/medred#",
    "meeting": "http://www.w3.org/2002/07/meeting#",
    "meetup": "http://www.lotico.com/meetup/",
    "mei": "http://www.music-encoding.org/ns/mei/",
    "mem": "http://mementoweb.org/ns#",
    "memento": "http://mementoweb.org/ns#",
    "memo": "http://ontologies.smile.deri.ie/2009/02/27/memo#",
    "merge": "http://jazz.net/ns/lqe/merge/",
    "mesh": "http://id.nlm.nih.gov/mesh/",
    "meshv": "http://id.nlm.nih.gov/mesh/vocab#",
    "meta": "http://www.openrdf.org/rdf/2009/metadata#",
    "metadata": "http://purl.oreilly.com/ns/meta/",
    "metalex": "http://www.metalex.eu/schema/1.0#",
    "meteo": "http://purl.org/ns/meteo#",
    "mexalgo": "http://mex.aksw.org/mex-algo#",
    "mexcore": "http://mex.aksw.org/mex-core#",
    "mexperf": "http://mex.aksw.org/mex-perf#",
    "mexv": "http://mex.aksw.org/mex-algo#",
    "mf": "http://www.w3.org/2001/sw/DataAccess/tests/tests-manifest#",
    "mged": "http://mged.sourceforge.net/ontologies/MGEDOntology.owl#",
    "mico": "http://www.mico-project.eu/ns/platform/1.0/schema#",
    "mil": "http://rdf.muninn-project.org/ontologies/military#",
    "mime": "https://www.iana.org/assignments/media-types/",
    "minim": "http://purl.org/minim/minim#",
    "mit": "http://purl.org/ontology/mo/mit#",
    "mls": "http://www.w3.org/ns/mls#",
    "mm": "http://linkedmultimedia.org/sparql-mm/ns/2.0.0/function#",
    "mmd": "http://musicbrainz.org/ns/mmd-1.0#",
    "mmf": "http://linkedmultimedia.org/sparql-mm/ns/1.0.0/function#",
    "mml": "http://www.w3.org/1998/Math/MathML/",
    "mmm": "http://www.mico-project.eu/ns/mmm/2.0/schema#",
    "mmo": "http://purl.org/momayo/mmo/",
    "mmoon": "http://mmoon.org/mmoon/",
    "mmt": "http://linkedmultimedia.org/sparql-mm/functions/temporal#",
    "mo": "http://purl.org/ontology/mo/",
    "moac": "http://observedchange.com/moac/ns#",
    "moat": "http://moat-project.org/ns#",
    "mobivoc": "http://schema.mobivoc.org/",
    "moby": "http://www.mygrid.org.uk/mygrid-moby-service#",
    "mocanal": "http://www.semanticweb.org/asow/ontologies/2013/9/untitled-ontology-36#",
    "mod": "http://www.isibang.ac.in/ns/mod#",
    "mods": "http://www.loc.gov/mods/v3#",
    "mohammad": "http://manesht.ir/",
    "money": "http://purl.org/net/rdf-money/",
    "moo": "http://www.movieontology.org/2009/11/09/movieontology.owl#",
    "movie": "http://data.linkedmdb.org/resource/movie/",
    "mp": "http://jicamaro.info/mp#",
    "mpeg7": "http://rhizomik.net/ontologies/2005/03/Mpeg7-2001.owl#",
    "mrel": "http://id.loc.gov/vocabulary/relators/",
    "ms": "http://purl.org/obo/owl/MS#",
    "msm": "http://iserve.kmi.open.ac.uk/ns/msm#",
    "msr": "http://www.telegraphis.net/ontology/measurement/measurement#",
    "mt": "http://www.w3.org/2001/sw/DataAccess/tests/tests-manifest#",
    "mte": "http://nl.ijs.si/ME/owl/",
    "mtecore": "http://purl.org/olia/mte/multext-east.owl#",
    "mtlo": "http://www.ics.forth.gr/isl/MarineTLO/v4/marinetlo.owl#",
    "mu": "http://mu.semte.ch/vocabularies/core/",
    "muldicat": "http://iflastandards.info/ns/muldicat#",
    "munc": "http://ns.inria.fr/munc#",
    "muni": "http://vocab.linkeddata.es/urbanismo-infraestructuras/territorio#",
    "muo": "http://purl.oclc.org/NET/muo/muo#",
    "music": "http://musicontology.com/",
    "musim": "http://purl.org/ontology/similarity/",
    "muto": "http://purl.org/muto/core#",
    "mv": "http://schema.mobivoc.org/",
    "mvco": "http://purl.oclc.org/NET/mvco.owl#",
    "mwapi": "https://www.mediawiki.org/ontology#API/",
    "my": "http://www.mobile.com/model/",
    "mydb": "http://mydb.org/",
    "mygrid": "http://www.mygrid.org.uk/ontology#",
    "myprefix": "http://myprefix.org/",
    "myspace": "http://purl.org/ontology/myspace#",
    "myspo": "http://purl.org/ontology/myspace#",
    "mysql": "http://web-semantics.org/ns/mysql/",
    "name": "http://example.org/name#",
    "namespaces": "https://vg.no/",
    "nao": "http://www.semanticdesktop.org/ontologies/2007/08/15/nao#",
    "nature": "http://deductions.github.io/nature_observation.owl.ttl#",
    "naval": "http://rdf.muninn-project.org/ontologies/naval#",
    "navm": "https://w3id.org/navigation_menu#",
    "ncal": "http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#",
    "ncbigene": "http://identifiers.org/ncbigene/",
    "ncbitaxon": "http://purl.org/obo/owl/NCBITaxon#",
    "ncicp": "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#",
    "ncit": "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#",
    "nco": "http://www.semanticdesktop.org/ontologies/2007/03/22/nco#",
    "ndl": "http://schemas.ogf.org/nml/2013/05/base#",
    "ndnp": "http://chroniclingamerica.loc.gov/terms#",
    "ne": "http://umbel.org/umbel/ne/",
    "neotec": "http://neotec.rc.unesp.br/resource/Neotectonics/",
    "neotecbib": "http://neotec.rc.unesp.br/resource/NeotectonicsBibliography/",
    "nerd": "http://nerd.eurecom.fr/ontology#",
    "net": "http://www.w3.org/2007/uwa/context/network.owl#",
    "newsevents": "http://www.aifb.uni-karlsruhe.de/WBS/uhe/ontologies#",
    "nex": "http://www.nexml.org/2009/",
    "nexif": "http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#",
    "nfo": "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#",
    "ngeo": "http://geovocab.org/geometry#",
    "ngeoi": "http://vocab.lenka.no/geo-deling#",
    "nid3": "http://www.semanticdesktop.org/ontologies/2007/05/10/nid3#",
    "nidm": "http://nidm.nidash.org/",
    "nie": "http://www.semanticdesktop.org/ontologies/2007/01/19/nie#",
    "nif": "http://persistence.uni-leipzig.org/nlp2rdf/ontologies/nif-core#",
    "nih": "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#",
    "nkos": "http://w3id.org/nkos#",
    "nlon": "http://lod.nl.go.kr/ontology/",
    "nmo": "http://nomisma.org/ontology.rdf#",
    "nndsr": "http://semanticdiet.com/schema/usda/nndsr/",
    "no": "http://km.aifb.kit.edu/projects/numbers/number#",
    "nobel": "http://data.nobelprize.org/terms/",
    "nocal": "http://vocab.deri.ie/nocal#",
    "noise": "http://vocab.linkeddata.es/datosabiertos/def/medio-ambiente/contaminacion-acustica#",
    "nosql": "http://purl.org/db/nosql#",
    "np": "http://www.nanopub.org/nschema#",
    "npdv": "http://sws.ifi.uio.no/vocab/npd#",
    "npg": "http://ns.nature.com/terms/",
    "npgd": "http://ns.nature.com/datasets/",
    "npgg": "http://ns.nature.com/graphs/",
    "npgx": "http://ns.nature.com/extensions/",
    "nrl": "http://www.semanticdesktop.org/ontologies/2007/08/15/nrl#",
    "nrv": "http://ns.inria.fr/nrv#",
    "ns1": "http://www.w3.org/1999/xhtml/vocab#",
    "ns2": "http://ogp.me/ns#video:",
    "nsa": "http://multimedialab.elis.ugent.be/organon/ontologies/ninsuna#",
    "nsl": "http://purl.org/ontology/storyline/",
    "nsogi": "http://prefix.cc/nsogi:",
    "nt": "http://ns.inria.fr/nicetag/2010/09/09/voc#",
    "ntag": "http://ns.inria.fr/nicetag/2010/09/09/voc#",
    "number": "http://km.aifb.kit.edu/projects/numbers/number#",
    "numbers": "http://km.aifb.kit.edu/projects/numbers/",
    "nuts": "http://dd.eionet.europa.eu/vocabulary/common/nuts/",
    "nxp": "http://purl.org/nxp/schema/v1/",
    "nxs": "http://www.neclimateus.org/",
    "nyt": "http://data.nytimes.com/",
    "nytimes": "http://data.nytimes.com/elements/",
    "oa": "http://www.w3.org/ns/oa#",
    "oac": "http://www.openannotation.org/ns/",
    "oad": "http://lod.xdams.org/reload/oad/",
    "oae": "http://www.ics.forth.gr/isl/oae/core#",
    "oan": "http://data.lirmm.fr/ontologies/oan/",
    "oarj": "http://opendepot.org/reference/linked/1.0/",
    "oat": "http://openlinksw.com/schemas/oat/",
    "oauth": "http://demiblog.org/vocab/oauth#",
    "oax": "http://www.w3.org/ns/openannotation/extensions/",
    "obeu": "http://data.openbudgets.eu/ontology/",
    "obj": "http://www.openrdf.org/rdf/2009/object#",
    "obo": "http://purl.obolibrary.org/obo/",
    "oboe": "http://ecoinformatics.org/oboe/oboe.1.0/oboe-core.owl#",
    "oboinowl": "http://www.geneontology.org/formats/oboInOwl#",
    "oboro": "http://obofoundry.org/ro/ro.owl#",
    "oboso": "http://purl.org/obo/owl/SO#",
    "obsm": "http://rdf.geospecies.org/methods/observationMethod#",
    "oc": "http://opencoinage.org/rdf/",
    "occ": "http://w3id.org/occ#",
    "occult": "http://data.totl.net/occult/",
    "ocd": "http://dati.camera.it/ocd/",
    "od": "http://purl.org/twc/vocab/opendap#",
    "odapp": "http://vocab.deri.ie/odapp#",
    "odapps": "http://semweb.mmlab.be/ns/odapps#",
    "odbc": "http://www.openlinksw.com/ontology/odbc#",
    "odcs": "http://opendata.cz/infrastructure/odcleanstore/",
    "odf": "http://docs.oasis-open.org/ns/office/1.2/meta/odf#",
    "odo": "http://ocean-data.org/schema/",
    "odp": "http://ontologydesignpatterns.org/",
    "odpart": "http://www.ontologydesignpatterns.org/cp/owl/participation.owl#",
    "odrl": "http://www.w3.org/ns/odrl/2/",
    "odrs": "http://schema.theodi.org/odrs#",
    "odv": "http://reference.data.gov.uk/def/organogram/",
    "odw": "http://odw.tw/",
    "oecc": "http://www.oegov.org/core/owl/cc#",
    "oecd": "http://oecd.270a.info/dataset/",
    "of": "http://owlrep.eu01.aws.af.cm/fridge#",
    "ofrd": "http://purl.org/opdm/refrigerator#",
    "og": "http://ogp.me/ns#",
    "ogbd": "http://www.ogbd.fr/2012/ontologie#",
    "ogc": "http://www.opengis.net/def/",
    "ogdl4m": "https://github.com/martynui/OGDL4M/",
    "ogorg": "http://opengraph.org/schema/",
    "ogp": "http://ogp.me/ns#",
    "oh": "http://semweb.mmlab.be/ns/oh#",
    "oils": "http://lemon-model.net/oils#",
    "oj": "http://ontojob.at/",
    "ok": "http://okkam.org/terms#",
    "okg": "http://openknowledgegraph.org/ontology/",
    "okkam": "http://models.okkam.org/ENS-core-vocabulary#",
    "olac": "http://www.language-archives.org/OLAC/1.0/",
    "olac11": "http://www.language-archives.org/OLAC/1.1/",
    "olad": "http://openlad.org/vocab#",
    "olca": "http://www.lingvoj.org/olca#",
    "olia": "http://purl.org/olia/olia.owl#",
    "oliasystem": "http://purl.org/olia/system.owl#",
    "olo": "http://purl.org/ontology/olo/core#",
    "om": "http://opendata.caceres.es/def/ontomunicipio#",
    "omapi": "http://purl.org/omapi/0.2/#",
    "omb": "http://purl.org/ontomedia/ext/common/being#",
    "omc": "http://purl.org/ontomedia/ext/common/bestiary#",
    "omdoc": "http://omdoc.org/ontology/",
    "ome": "http://purl.org/ontomedia/core/expression#",
    "omg": "https://w3id.org/omg#",
    "oml": "http://def.seegrid.csiro.au/ontology/om/om-lite#",
    "omm": "http://purl.org/ontomedia/core/media#",
    "omn": "http://open-multinet.info/ontology/omn#",
    "omnfed": "http://open-multinet.info/ontology/omn-federation#",
    "omnlife": "http://open-multinet.info/ontology/omn-lifecycle#",
    "omp": "http://purl.org/ontomedia/ext/common/profession#",
    "omt": "http://purl.org/ontomedia/ext/common/trait#",
    "omv": "http://omv.ontoware.org/2005/05/ontology#",
    "onc": "http://www.ics.forth.gr/isl/oncm/core#",
    "ondc": "http://www.semanticweb.org/ontologies/2012/1/Ontology1329913965202.owl#",
    "onisep": "http://rdf.onisep.fr/resource/",
    "onssprel": "http://www.ordnancesurvey.co.uk/ontology/SpatialRelations/v0.2/SpatialRelations.owl#",
    "ont": "http://purl.org/net/ns/ontology-annot#",
    "onto": "http://www.ontotext.com/",
    "ontolex": "http://www.w3.org/ns/lemon/ontolex#",
    "ontology": "http://dbpedia.org/ontology/",
    "ontoneo": "http://purl.obolibrary.org/obo/ontoneo/",
    "ontop": "https://w3id.org/ontop/",
    "ontopic": "http://www.ontologydesignpatterns.org/ont/dul/ontopic.owl#",
    "ontosec": "http://www.semanticweb.org/ontologies/2008/11/OntologySecurity.owl#",
    "onyx": "http://www.gsi.dit.upm.es/ontologies/onyx/ns#",
    "oo": "http://purl.org/openorg/",
    "oop": "http://w3id.org/oop#",
    "op": "http://environment.data.gov.au/def/op#",
    "opa": "https://w3id.org/laas-iot/adream#",
    "open": "http://open.vocab.org/terms/",
    "open311": "http://ontology.eil.utoronto.ca/open311#",
    "opencyc": "http://sw.opencyc.org/concept/",
    "opengov": "http://www.w3.org/opengov#",
    "openlinks": "http://www.openlinksw.com/schemas/virtrdf#",
    "opensearch": "http://a9.com/-/spec/opensearch/1.1/",
    "openskos": "http://openskos.org/xmlns#",
    "oper": "http://sweet.jpl.nasa.gov/2.0/mathOperation.owl#",
    "opl": "http://openlinksw.com/schema/attribution#",
    "oplacl": "http://www.openlinksw.com/ontology/acl#",
    "oplangel": "http://www.openlinksw.com/schemas/angel#",
    "oplbenefit": "http://www.openlinksw.com/ontology/benefits#",
    "oplcb": "http://www.openlinksw.com/schemas/crunchbase#",
    "oplcert": "http://www.openlinksw.com/schemas/cert#",
    "oplecrm": "http://www.openlinksw.com/ontology/ecrm#",
    "oplli": "http://www.openlinksw.com/schemas/linkedin#",
    "opllic": "http://www.openlinksw.com/ontology/licenses#",
    "opllog": "http://www.openlinksw.com/ontology/logging#",
    "oplmkt": "http://www.openlinksw.com/ontology/market#",
    "oplp": "http://www.openlinksw.com/ontology/purchases#",
    "oplprod": "http://www.openlinksw.com/ontology/products#",
    "oplres": "http://www.openlinksw.com/ontology/restrictions#",
    "oplstocks": "http://www.openlinksw.com/ontology/stocks#",
    "oplweb": "http://www.openlinksw.com/schemas/oplweb#",
    "oplwebsrv": "http://www.openlinksw.com/ontology/webservices#",
    "opm": "https://w3id.org/opm#",
    "opmo": "http://openprovenance.org/model/opmo#",
    "opmv": "http://purl.org/net/opmv/ns#",
    "opmw": "http://www.opmw.org/ontology/",
    "opo": "http://online-presence.net/opo/ns#",
    "oprovo": "http://openprovenance.org/ontology#",
    "ops": "http://vocabularies.bridgedb.org/ops#",
    "opus": "http://lsdis.cs.uga.edu/projects/semdis/opus#",
    "opwn": "http://www.ontologyportal.org/WordNet.owl#",
    "or": "http://openresearch.org/vocab/",
    "orca": "http://geni-orca.renci.org/owl/topology.owl#",
    "orcid": "http://orcid.org/",
    "ordf": "http://purl.org/NET/ordf/",
    "ore": "http://www.openarchives.org/ore/terms/",
    "org": "http://www.w3.org/ns/org#",
    "organ": "http://www.univalle.edu.co/ontologies/Organ#",
    "organism": "http://eulersharp.sourceforge.net/2003/03swap/organism#",
    "organiz": "http://eulersharp.sourceforge.net/2003/03swap/organization#",
    "orges": "http://datos.gob.es/def/sector-publico/organizacion#",
    "orgesv2": "http://datos.gob.es/sites/default/files/OntologiaDIR3/orges.owl#",
    "origins": "http://origins.link/",
    "orth": "http://purl.org/net/orth#",
    "os": "http://www.w3.org/2000/10/swap/os#",
    "osadm": "http://data.ordnancesurvey.co.uk/ontology/admingeo/",
    "osag": "http://www.ordnancesurvey.co.uk/ontology/AdministrativeGeography/v2.0/AdministrativeGeography.rdf#",
    "osd": "http://a9.com/-/spec/opensearch/1.1/",
    "osgb": "http://data.ordnancesurvey.co.uk/id/",
    "osgeom": "http://data.ordnancesurvey.co.uk/ontology/geometry/",
    "oslc": "http://open-services.net/ns/core#",
    "oslo": "http://purl.org/oslo/ns/localgov#",
    "osmsemnet": "http://spatial.ucd.ie/2012/08/osmsemnet/",
    "osn": "http://spatial.ucd.ie/lod/osn/",
    "osoc": "http://web-semantics.org/ns/opensocial#",
    "osp": "http://data.lirmm.fr/ontologies/osp#",
    "ospost": "http://data.ordnancesurvey.co.uk/ontology/postcode/",
    "osr": "http://dati.senato.it/osr/",
    "oss": "http://opendata.caceres.es/def/ontosemanasanta#",
    "osspr": "http://data.ordnancesurvey.co.uk/ontology/spatialrelations/",
    "ost": "http://w3id.org/ost/ns#",
    "ostop": "http://www.ordnancesurvey.co.uk/ontology/Topography/v0.1/Topography.owl#",
    "osukdt": "http://www.ordnancesurvey.co.uk/ontology/Datatypes.owl#",
    "ottr": "http://ns.ottr.xyz/templates#",
    "ou": "http://opendata.unex.es/def/ontouniversidad#",
    "out": "http://ontologies.hypios.com/out#",
    "output": "http://volt-name.space/vocab/output#",
    "ov": "http://open.vocab.org/terms/",
    "overheid": "http://standaarden.overheid.nl/owms/",
    "owl": "http://www.w3.org/2002/07/owl#",
    "owl2xml": "http://www.w3.org/2006/12/owl2-xml#",
    "owlim": "http://www.ontotext.com/trree/owlim#",
    "owls": "http://www.daml.org/services/owl-s/1.2/Service.owl#",
    "owlse": "http://www.daml.org/services/owl-s/1.2/generic/Expression.owl#",
    "owltime": "http://www.w3.org/TR/owl-time#",
    "owms": "http://standaarden.overheid.nl/owms/terms/",
    "owsom": "https://onlinesocialmeasures.wordpress.com/",
    "ox": "http://vocab.ox.ac.uk/projectfunding#",
    "oxi": "http://omerxi.com/ontologies/core.owl.ttl#",
    "p20": "http://zbw.eu/beta/p20/vocab/",
    "p3p": "http://www.w3.org/2002/01/p3prdfv1#",
    "paia": "http://purl.org/ontology/paia#",
    "pair": "http://virtual-assembly.org/pair/PAIR_LOD_V3.owl/",
    "pam": "http://prismstandard.org/namespaces/pam/2.0/",
    "pand": "http://bag.basisregistraties.overheid.nl/bag/id/pand/",
    "parl": "https://id.parliament.uk/schema/",
    "part": "http://purl.org/vocab/participation/schema#",
    "particip": "http://purl.org/vocab/participation/schema#",
    "passim": "http://data.lirmm.fr/ontologies/passim#",
    "pat": "http://purl.org/hpi/patchr#",
    "pato": "http://purl.obolibrary.org/obo/",
    "pattern": "http://www.essepuntato.it/2008/12/pattern#",
    "pav": "http://purl.org/pav/",
    "pay": "http://reference.data.gov.uk/def/payment#",
    "payment": "http://reference.data.gov.uk/def/payment#",
    "pbo": "http://purl.org/ontology/pbo/core#",
    "pbody": "http://reference.data.gov.uk/def/public-body/",
    "pc": "http://purl.org/procurement/public-contracts#",
    "pccz": "http://purl.org/procurement/public-contracts-czech#",
    "pcdm": "http://pcdm.org/models#",
    "pcdmuse": "http://pcdm.org/use#",
    "pcdt": "http://purl.org/procurement/public-contracts-datatypes#",
    "pcit": "http://public-contracts.nexacenter.org/id/propertiesRole/",
    "pco": "http://purl.org/procurement/public-contracts#",
    "pdf": "http://ns.adobe.com/pdf/1.3/",
    "pdo": "http://ontologies.smile.deri.ie/pdo#",
    "penis": "http://penis.to/#",
    "penn": "http://purl.org/olia/penn.owl#",
    "pep": "https://w3id.org/pep/",
    "persee": "http://data.persee.fr/ontology/persee_ontology/",
    "person": "http://www.w3.org/ns/person#",
    "pext": "http://www.ontotext.com/proton/protonext#",
    "pf": "http://jena.hpl.hp.com/ARQ/property#",
    "pfeepsa": "https://w3id.org/pfeepsa#",
    "pgterms": "http://www.gutenberg.org/2009/pgterms/",
    "phdd": "http://rdf-vocabulary.ddialliance.org/phdd#",
    "phil": "http://philosurfical.open.ac.uk/ontology/philosurfical.owl#",
    "photoshop": "http://ns.adobe.com/photoshop/1.0/",
    "phss": "http://ns.poundhill.com/phss/1.0/",
    "physics": "http://www.astro.umd.edu/~eshaya/astro-onto/owl/physics.owl#",
    "physo": "http://merlin.phys.uni.lodz.pl/onto/physo/physo.owl#",
    "pic": "http://www.ipaw.info/ns/picaso#",
    "pid": "http://permid.org/ontology/organization/",
    "piero": "http://reactionontology.org/piero/",
    "pim": "http://www.w3.org/ns/pim/space#",
    "pimo": "http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#",
    "ping": "http://purl.org/net/pingback/",
    "pingback": "http://purl.org/net/pingback/",
    "pizza": "http://www.co-ode.org/ontologies/pizza/pizza.owl#",
    "pkgsrc": "http://pkgsrc.co/schema#",
    "pkm": "http://www.ontotext.com/proton/protonkm#",
    "pkmn": "http://pokedex.dataincubator.org/pkm/",
    "place": "http://purl.org/ontology/places/",
    "places": "http://purl.org/ontology/places#",
    "planet": "http://dbpedia.org/",
    "play": "http://uriplay.org/spec/ontology/#",
    "ple": "http://pleiades.stoa.org/places/",
    "plg": "http://parliament.uk/ontologies/legislation/",
    "plink": "http://buzzword.org.uk/rdf/personal-link-types#",
    "plo": "http://purl.org/net/po#",
    "pm": "http://premon.fbk.eu/resource/",
    "pmc": "http://identifiers.org/pmc/",
    "pmd": "http://publishmydata.com/def/dataset#",
    "pmhb": "http://pmhb.org/",
    "pml": "http://provenanceweb.org/ns/pml#",
    "pmlj": "http://inference-web.org/2.0/pml-justification.owl#",
    "pmlp": "http://inference-web.org/2.0/pml-provenance.owl#",
    "pmlr": "http://inference-web.org/2.0/pml-relation.owl#",
    "pmlt": "http://inference-web.org/2.0/pml-trust.owl#",
    "pmo": "http://premon.fbk.eu/ontology/core#",
    "pmofn": "http://premon.fbk.eu/ontology/fn#",
    "pmonb": "http://premon.fbk.eu/ontology/nb#",
    "pmopb": "http://premon.fbk.eu/ontology/pb#",
    "pmovn": "http://premon.fbk.eu/ontology/vn#",
    "pmt": "http://tipsy.googlecode.com/svn/trunk/vocab/pmt#",
    "pna": "http://data.press.net/ontology/asset/",
    "pnc": "http://data.press.net/ontology/classification/",
    "pne": "http://data.press.net/ontology/event/",
    "pni": "http://data.press.net/ontology/identifier/",
    "pns": "http://data.press.net/ontology/stuff/",
    "pnt": "http://data.press.net/ontology/tag/",
    "po": "http://purl.org/ontology/po/",
    "pobo": "http://purl.obolibrary.org/obo/",
    "pod": "https://project-open-data.cio.gov/v1.1/schema/#",
    "poder": "http://poderopedia.com/vocab/",
    "pois": "http://purl.oclc.org/POIS/vcblr#",
    "pol": "http://escience.rpi.edu/ontology/semanteco/2/0/pollution.owl#",
    "politico": "http://www.rdfabout.com/rdf/schema/politico/",
    "pom": "http://maven.apache.org/POM/4.0.0#",
    "pop": "http://wiki.dbpedia.org/",
    "pos": "http://www.w3.org/2003/01/geo/wgs84_pos#",
    "posh": "http://poshrdf.org/ns/posh/",
    "postcode": "http://data.ordnancesurvey.co.uk/id/postcodeunit/",
    "poste": "http://data.lirmm.fr/ontologies/poste#",
    "powder": "http://www.w3.org/2007/05/powder#",
    "pp": "http://peoplesplaces.de/ontology#",
    "ppn": "http://parliament.uk/ontologies/person-name/",
    "ppo": "http://vocab.deri.ie/ppo#",
    "ppr": "http://purl.org/datanode/ppr/ns/",
    "pproc": "http://contsem.unizar.es/def/sector-publico/pproc#",
    "pr": "http://purl.org/ontology/prv/core#",
    "prefix": "http://prefix.cc/",
    "premis": "http://www.loc.gov/premis/rdf/v1#",
    "prf": "http://www.openmobilealliance.org/tech/profiles/UAPROF/ccppschema-20021212#",
    "prism": "http://prismstandard.org/namespaces/basic/2.0/",
    "prism21": "http://prismstandard.org/namespaces/basic/2.1/",
    "prissma": "http://ns.inria.fr/prissma/v1#",
    "prj": "http://purl.org/stuff/project/",
    "pro": "http://purl.org/hpi/patchr#",
    "product": "http://purl.org/commerce/product#",
    "prof": "http://www.w3.org/ns/dx/prof/",
    "profiling": "http://ontologi.es/profiling#",
    "prog": "http://purl.org/prog/",
    "prohow": "https://w3id.org/prohow#",
    "prolog": "http://eulersharp.sourceforge.net/2003/03swap/prolog#",
    "proms": "http://promsns.org/def/proms#",
    "pronom": "http://reference.data.gov.uk/technical-registry/",
    "prop": "http://dbpedia.org/property/",
    "property": "http://fr.dbpedia.org/property/",
    "prot": "http://www.proteinontology.info/po.owl#",
    "protege": "http://protege.stanford.edu/system#",
    "protegedc": "http://protege.stanford.edu/plugins/owl/dc/protege-dc.owl#",
    "protons": "http://proton.semanticweb.org/2005/04/protons#",
    "prov": "http://www.w3.org/ns/prov#",
    "provenir": "http://knoesis.wright.edu/provenir/provenir.owl#",
    "provinsi": "http://provinsi.com/",
    "provoc": "http://ns.inria.fr/provoc/",
    "provone": "http://purl.org/provone#",
    "prv": "http://purl.org/net/provenance/ns#",
    "prviv": "http://purl.org/net/provenance/integrity#",
    "prvr": "http://purl.org/ontology/prv/rules#",
    "prvt": "http://purl.org/net/provenance/types#",
    "prvtypes": "http://purl.org/net/provenance/types#",
    "ps": "https://w3id.org/payswarm#",
    "psh": "http://psh.techlib.cz/skos/",
    "pso": "http://purl.org/spar/pso/",
    "psv": "http://www.wikidata.org/prop/statement/value/",
    "psych": "http://purl.org/vocab/psychometric-profile/",
    "psys": "http://www.ontotext.com/proton/protonsys#",
    "pto": "http://www.productontology.org/id/",
    "ptop": "http://www.ontotext.com/proton/protontop#",
    "ptr": "http://www.w3.org/2009/pointers#",
    "pubmed": "http://bio2rdf.org/pubmed_vocabulary:",
    "puc": "http://purl.org/NET/puc#",
    "puelia": "http://kwijibo.talis.com/vocabs/puelia#",
    "puml": "http://plantuml.com/ontology#",
    "purl": "http://www.purl.org/",
    "push": "http://www.w3.org/2007/uwa/context/push.owl#",
    "pv": "http://ns.inria.fr/provoc#",
    "pvcs": "http://purl.org/twc/vocab/pvcs#",
    "pwo": "http://purl.org/spar/pwo/",
    "qa": "http://www.mit.jyu.fi/ai/TRUST_Ontologies/QA.owl#",
    "qb": "http://purl.org/linked-data/cube#",
    "qb4o": "http://purl.org/olap#",
    "qbe": "http://citydata.wu.ac.at/qb-equations#",
    "qdoslf": "http://foaf.qdos.com/lastfm/schema/",
    "ql": "http://www.w3.org/2004/ql#",
    "qms": "http://data.europa.eu/esco/qms#",
    "qrl": "http://www.aifb.kit.edu/project/ld-retriever/qrl#",
    "qu": "http://purl.oclc.org/NET/ssnx/qu/qu#",
    "quak": "http://dev.w3.org/cvsweb/2000/quacken/vocab#",
    "quantities": "http://eulersharp.sourceforge.net/2003/03swap/quantitiesExtension#",
    "quantity": "http://qudt.org/schema/quantity#",
    "qud": "http://qudt.org/1.1/schema/qudt#",
    "qudt": "http://qudt.org/1.1/schema/qudt#",
    "quty": "http://www.telegraphis.net/ontology/measurement/quantity#",
    "qvoc": "http://mlode.nlp2rdf.org/quranvocab#",
    "r2r": "http://www4.wiwiss.fu-berlin.de/bizer/r2r/",
    "r2rml": "http://www.w3.org/ns/r2rml#",
    "r3d": "http://www.re3data.org/schema/3-0#",
    "r4r": "http://guava.iis.sinica.edu.tw/r4r/",
    "r4ta": "http://ns.inria.fr/ratio4ta/v1#",
    "rad": "http://www.w3.org/ns/rad#",
    "radion": "http://www.w3.org/ns/radion#",
    "rail": "http://ontologi.es/rail/vocab#",
    "ramon": "http://rdfdata.eionet.europa.eu/ramon/ontology/",
    "rankrage": "https://rankrage.de/",
    "rating": "http://www.tvblob.com/ratings/#",
    "raul": "http://vocab.deri.ie/raul#",
    "rda": "http://www.rdaregistry.info/",
    "rdaa": "http://rdaregistry.info/Elements/a/",
    "rdaad": "http://rdaregistry.info/Elements/a/datatype/",
    "rdaar": "http://rdaregistry.info/termList/AspectRatio/",
    "rdabf": "http://rdaregistry.info/termList/bookFormat/",
    "rdabm": "http://rdaregistry.info/termList/RDABaseMaterial/",
    "rdabs": "http://rdaregistry.info/termList/broadcastStand/",
    "rdac": "http://rdaregistry.info/Elements/c/",
    "rdacarrier": "http://rdvocab.info/termList/RDACarrierType/",
    "rdacarx": "http://rdaregistry.info/termList/RDACarrierEU/",
    "rdacc": "http://rdaregistry.info/termList/RDAColourContent/",
    "rdacct": "http://rdaregistry.info/termList/CollTitle/",
    "rdacdt": "http://rdaregistry.info/termList/RDACartoDT/",
    "rdaco": "http://rdaregistry.info/termList/RDAContentType/",
    "rdacontent": "http://rdvocab.info/termList/RDAContentType/",
    "rdacpc": "http://rdaregistry.info/termList/configPlayback/",
    "rdact": "http://rdaregistry.info/termList/RDACarrierType/",
    "rdae": "http://rdaregistry.info/Elements/e/",
    "rdaemm": "http://rdaregistry.info/termList/emulsionMicro/",
    "rdafmn": "http://rdaregistry.info/termList/MusNotation/",
    "rdafnm": "http://rdaregistry.info/termList/FormNoteMus/",
    "rdafnv": "http://rdaregistry.info/termList/noteForm/",
    "rdafr": "http://rdaregistry.info/termList/frequency/",
    "rdafrbr": "http://rdvocab.info/uri/schema/FRBRentitiesRDA/",
    "rdafs": "http://rdaregistry.info/termList/fontSize/",
    "rdaft": "http://rdaregistry.info/termList/fileType/",
    "rdaftn": "http://rdaregistry.info/termList/TacNotation/",
    "rdag1": "http://rdvocab.info/Elements/",
    "rdag2": "http://rdvocab.info/ElementsGr2/",
    "rdag3": "http://rdvocab.info/ElementsGr3/",
    "rdagd": "http://rdaregistry.info/termList/gender/",
    "rdagen": "http://rdaregistry.info/termList/RDAGeneration/",
    "rdagr1": "http://rdvocab.info/Elements/",
    "rdagrp": "http://rdaregistry.info/termList/groovePitch/",
    "rdagw": "http://rdaregistry.info/termList/grooveWidth/",
    "rdai": "http://rdaregistry.info/Elements/i/",
    "rdaill": "http://rdaregistry.info/termList/IllusContent/",
    "rdalay": "http://rdaregistry.info/termList/layout/",
    "rdam": "http://rdaregistry.info/Elements/m/",
    "rdamedia": "http://rdvocab.info/termList/RDAMediaType/",
    "rdami": "http://rdaregistry.info/termList/modeIssue/",
    "rdamt": "http://rdaregistry.info/termList/RDAMediaType/",
    "rdapf": "http://rdaregistry.info/termList/presFormat/",
    "rdapm": "http://rdaregistry.info/termList/RDAproductionMethod/",
    "rdapmt": "http://rdaregistry.info/termList/prodTactile/",
    "rdapo": "http://rdaregistry.info/termList/RDAPolarity/",
    "rdare": "http://rdaregistry.info/termList/RDARegionalEncoding/",
    "rdarel": "http://rdvocab.info/RDARelationshipsWEMI/",
    "rdarel2": "http://metadataregistry.org/uri/schema/RDARelationshipsGR2/",
    "rdarm": "http://registry.info/termList/recMedium/",
    "rdarole": "http://rdvocab.info/roles/",
    "rdarr": "http://rdaregistry.info/termList/RDAReductionRatio/",
    "rdasco": "http://rdaregistry.info/termList/soundCont/",
    "rdasoi": "http://rdaregistry.info/termList/statIdentification/",
    "rdaspc": "http://rdaregistry.info/termList/specPlayback/",
    "rdatc": "http://rdaregistry.info/termList/trackConfig/",
    "rdaterm": "http://rdaregistry.info/termList/RDATerms/",
    "rdatr": "http://rdaregistry.info/termList/typeRec/",
    "rdau": "http://rdaregistry.info/Elements/u/",
    "rdavf": "http://rdaregistry.info/termList/videoFormat/",
    "rdaw": "http://rdaregistry.info/Elements/w/",
    "rdax": "http://rdaregistry.info/Elements/x/",
    "rdaz": "http://rdaregistry.info/Elements/z/",
    "rdb": "http://www.dbs.cs.uni-duesseldorf.de/RDF/relational#",
    "rdf": "http://www.w3.org/1999/02/22-rdf-syntax-ns#",
    "rdf123": "http://rdf123.umbc.edu/ns/",
    "rdfa": "http://www.w3.org/ns/rdfa#",
    "rdfdata": "http://rdf.data-vocabulary.org/rdf.xml#",
    "rdfdf": "http://www.openlinksw.com/virtrdf-data-formats#",
    "rdfg": "http://www.w3.org/2004/03/trix/rdfg-1/",
    "rdfp": "https://w3id.org/rdfp/",
    "rdfs": "http://www.w3.org/2000/01/rdf-schema#",
    "rdfsharp": "https://rdfsharp.codeplex.com/",
    "rdl": "http://data.posccaesar.org/rdl/",
    "rdo": "http://purl.org/rdo/ns#",
    "rdrel": "http://rdvocab.info/RDARelationshipsWEMI/",
    "re": "http://www.w3.org/2000/10/swap/reason#",
    "rec": "http://purl.org/ontology/rec/core#",
    "rec54": "http://www.w3.org/2001/02pd/rec54.rdf#",
    "recipe": "http://linkedrecipes.org/schema/",
    "reco": "http://purl.org/reco#",
    "reegle": "http://reegle.info/schema#",
    "ref": "http://purl.org/vocab/relationship/",
    "refe": "http://orion.tw.rpi.edu/~xgmatwc/refe/",
    "regorg": "http://www.w3.org/ns/regorg#",
    "rei": "http://www.w3.org/2004/06/rei#",
    "rel": "http://purl.org/vocab/relationship/",
    "religion": "http://rdf.muninn-project.org/ontologies/religion#",
    "remetca": "http://www.purl.org/net/remetca#",
    "remus": "http://www.semanticweb.org/ontologies/2010/6/Ontology1279614123500.owl#",
    "rep": "http://www.openrdf.org/config/repository#",
    "req": "http://purl.org/req/",
    "res": "http://dbpedia.org/resource/",
    "resex": "http://resex.rkbexplorer.com/ontologies/resex#",
    "resist": "http://www.rkbexplorer.com/ontologies/resist#",
    "resource": "http://purl.org/vocab/resourcelist/schema#",
    "rev": "http://purl.org/stuff/rev#",
    "reve": "http://data.eurecom.fr/ontology/reve#",
    "rfd": "http://com.intrinsec//ontology#",
    "rgml": "http://purl.org/puninj/2001/05/rgml-schema#",
    "rich": "http://rdf.data-vocabulary.org/",
    "rif": "http://www.w3.org/2007/rif#",
    "rimmf": "http://rimmf.com/vocab/",
    "rlno": "http://rdflivenews.aksw.org/ontology/",
    "rlnr": "http://rdflivenews.aksw.org/resource/",
    "rlog": "http://persistence.uni-leipzig.org/nlp2rdf/ontologies/rlog#",
    "rls": "https://w3id.org/lovcube/ns/relovstats#",
    "rm": "http://jazz.net/ns/rm#",
    "rml": "http://semweb.mmlab.be/ns/rml#",
    "rmo": "http://eatld.et.tu-dresden.de/rmo#",
    "rnews": "http://iptc.org/std/rNews/2011-10-07#",
    "ro": "http://purl.org/wf4ever/ro#",
    "roadmap": "http://mappings.roadmap.org/",
    "roevo": "http://purl.org/wf4ever/roevo#",
    "rofch": "http://rdaregistry.info/termList/rofch/",
    "rofem": "http://rdaregistry.info/termList/rofem/",
    "rofer": "http://rdaregistry.info/termList/rofer/",
    "rofet": "http://rdaregistry.info/termList/rofet/",
    "rofhf": "http://rdaregistry.info/termList/rofhf/",
    "rofid": "http://rdaregistry.info/termList/rofid/",
    "rofim": "http://rdaregistry.info/termList/rofim/",
    "rofin": "http://rdaregistry.info/termList/rofin/",
    "rofit": "http://rdaregistry.info/termList/rofit/",
    "rofrm": "http://rdaregistry.info/termList/rofrm/",
    "rofrr": "http://rdaregistry.info/termList/rofrr/",
    "rofrt": "http://rdaregistry.info/termList/rofrt/",
    "rofsf": "http://rdaregistry.info/termList/rofsf/",
    "rofsm": "http://rdaregistry.info/termList/rofsm/",
    "role": "https://w3id.org/role/",
    "room": "http://vocab.deri.ie/rooms#",
    "rooms": "http://vocab.deri.ie/rooms#",
    "roterms": "http://purl.org/wf4ever/roterms#",
    "rov": "http://www.w3.org/ns/regorg#",
    "rpath": "https://w3id.org/lodsight/rdf-path#",
    "rpubl": "http://rinfo.lagrummet.se/ns/2008/11/rinfo/publ#",
    "rr": "http://www.w3.org/ns/r2rml#",
    "rs": "http://spektrum.ctu.cz/ontologies/radio-spectrum#",
    "rsa": "http://www.w3.org/ns/auth/rsa#",
    "rso": "http://www.researchspace.org/ontology/",
    "rss": "http://purl.org/rss/1.0/",
    "rssynd": "http://web.resource.org/rss/1.0/modules/syndication/",
    "ru": "http://purl.org/imbi/ru-meta.owl#",
    "ruian": "https://data.cssz.cz/ontology/ruian/",
    "rulz": "http://purl.org/NET/rulz#",
    "rut": "http://rdfunit.aksw.org/ns/core#",
    "ruto": "http://rdfunit.aksw.org/ns/core#",
    "rv": "http://wifo-ravensburg.de/semanticweb.rdf#",
    "rvdata": "http://data.rvdata.us/",
    "rvl": "http://purl.org/rvl/",
    "rvz": "http://rdfvizler.dyreriket.xyz/vocabulary/core#",
    "s2s": "http://escience.rpi.edu/ontology/sesf/s2s/4/0/",
    "s3db": "http://www.s3db.org/core#",
    "s3n": "http://w3id.org/s3n/",
    "s4ac": "http://ns.inria.fr/s4ac/v2#",
    "s4bldg": "https://w3id.org/def/saref4bldg#",
    "s4envi": "https://w3id.org/def/saref4envi#",
    "sad": "http://vocab.deri.ie/sad#",
    "saif": "http://wwwiti.cs.uni-magdeburg.de/~srahman/",
    "sail": "http://www.openrdf.org/config/sail#",
    "sakthi": "http://infotech.nitk.ac.in/research-scholars/sakthi-murugan-r/",
    "salad": "https://w3id.org/cwl/salad#",
    "sam": "http://def.seegrid.csiro.au/isotc211/iso19156/2011/sampling#",
    "samfl": "http://def.seegrid.csiro.au/ontology/om/sam-lite#",
    "san": "http://www.irit.fr/recherches/MELODI/ontologies/SAN#",
    "sao": "http://salt.semanticauthoring.org/ontologies/sao#",
    "saref": "https://w3id.org/saref#",
    "saws": "http://purl.org/saws/ontology#",
    "sawsdl": "http://www.w3.org/ns/sawsdl#",
    "saxon": "http://saxon.sf.net/",
    "sbench": "http://swat.cse.lehigh.edu/onto/univ-bench.owl#",
    "sc": "http://purl.org/science/owl/sciencecommons/",
    "scco": "http://rdf.ebi.ac.uk/terms/surechembl#",
    "schema": "http://schema.org/",
    "scholl": "http://menemeneml.com/school#",
    "sci": "http://data.scientology.org/ns/",
    "scip": "http://lod.taxonconcept.org/ontology/sci_people.owl#",
    "sciprov": "http://sweetontology.net/reprSciProvenance/",
    "scms": "http://ns.aksw.org/scms/annotations/",
    "sco": "http://purl.org/ontology/sco#",
    "scor": "http://purl.org/eis/vocab/scor#",
    "scoro": "http://purl.org/spar/scoro/",
    "scot": "http://rdfs.org/scot/ns#",
    "scovo": "http://purl.org/NET/scovo#",
    "scowt": "http://purl.org/weso/ontologies/scowt#",
    "scra": "http://purl.org/net/schemarama#",
    "scsv": "http://purl.org/NET/schema-org-csv#",
    "sct": "http://snomed.info/sct/",
    "scufl2": "http://ns.taverna.org.uk/2010/scufl2#",
    "scv": "http://purl.org/NET/scovo#",
    "sd": "http://www.w3.org/ns/sparql-service-description#",
    "sdgp": "http://stats.data-gov.ie/property/",
    "sdl": "http://purl.org/vocab/riro/sdl#",
    "sdm": "http://standard.k-history.kr/resource/",
    "sdmx": "http://purl.org/linked-data/sdmx#",
    "sdmxa": "http://purl.org/linked-data/sdmx/2009/attribute#",
    "sdmxc": "http://purl.org/linked-data/sdmx/2009/concept#",
    "sdmxcode": "http://purl.org/linked-data/sdmx/2009/code#",
    "sdmxd": "http://purl.org/linked-data/sdmx/2009/dimension#",
    "sdmxdim": "http://purl.org/linked-data/sdmx/2009/dimension#",
    "sdmxm": "http://purl.org/linked-data/sdmx/2009/measure#",
    "sdo": "http://schema.org/",
    "sdshare": "http://www.sdshare.org/2012/extension/",
    "sdt": "http://statisticaldata.linkedwidgets.org/terms/",
    "sdterms": "http://statisticaldata.linkedwidgets.org/terms/",
    "search": "http://sindice.com/vocab/search#",
    "seas": "https://w3id.org/seas/",
    "sec": "https://w3id.org/security#",
    "security": "http://securitytoolbox.appspot.com/securityMain#",
    "sede": "http://eventography.org/sede/0.1/",
    "seeds": "http://deductions.github.io/seeds.owl.ttl#",
    "sem": "http://semanticweb.cs.vu.nl/2009/11/sem/",
    "semio": "http://www.lingvoj.org/semio#",
    "semiot": "http://w3id.org/semiot/ontologies/semiot#",
    "semtweet": "http://semantictweet.com/",
    "seo": "http://sda.tech/SEOontology/SEO/",
    "seokoeln": "http://rankrage.de/",
    "seq": "http://www.ontologydesignpatterns.org/cp/owl/sequence.owl#",
    "service": "http://purl.org/ontology/service#",
    "ses": "http://lod.taxonconcept.org/ses/",
    "sesame": "http://www.openrdf.org/schema/sesame#",
    "session": "http://redfoot.net/2005/session#",
    "set": "http://www.w3.org/2000/10/swap/set#",
    "sf": "http://www.opengis.net/ont/sf#",
    "sfd": "http://semantic-forms.cc:9112/ldp/",
    "sfn": "http://semweb.datasciencelab.be/ns/sfn#",
    "sg": "http://www.springernature.com/scigraph/ontologies/core/",
    "sgfn": "http://w3id.org/sparql-generate/fn/",
    "sgg": "http://www.springernature.com/scigraph/graphs/",
    "sgiter": "http://w3id.org/sparql-generate/iter/",
    "sgv": "http://www.w3.org/TR/SVG/",
    "sh": "http://www.w3.org/ns/shacl#",
    "shacl": "http://www.w3.org/ns/shacl#",
    "shex": "http://www.w3.org/2013/ShEx/ns#",
    "shoah": "http://dati.cdec.it/lod/shoah/",
    "shui": "https://vocab.eccenca.com/shui/",
    "shv": "http://ns.aksw.org/spatialHierarchy/",
    "shw": "http://paul.staroch.name/thesis/SmartHomeWeather.owl#",
    "si": "http://sisteminformasi.com/",
    "sider": "http://www4.wiwiss.fu-berlin.de/sider/resource/sider/",
    "sig": "http://purl.org/signature#",
    "sim": "http://purl.org/ontology/similarity/",
    "sindice": "http://vocab.sindice.net/",
    "sio": "http://semanticscience.org/resource/",
    "sioc": "http://rdfs.org/sioc/ns#",
    "sioca": "http://rdfs.org/sioc/actions#",
    "siocserv": "http://rdfs.org/sioc/services#",
    "sioct": "http://rdfs.org/sioc/types#",
    "sioctypes": "http://rdfs.org/sioc/types#",
    "sirene": "https://sireneld.io/vocab/sirene#",
    "sirext": "https://sireneld.io/vocab/sirext#",
    "sism": "http://purl.oclc.org/NET/sism/0.1/",
    "sit": "http://www.ontologydesignpatterns.org/cp/owl/situation.owl#",
    "site": "http://ns.ontowiki.net/SysOnt/Site/",
    "situ": "http://www.ontologydesignpatterns.org/cp/owl/situation.owl#",
    "skip": "http://skipforward.net/skipforward/resource/",
    "skiresort": "http://www.openlinksw.com/ski_resorts/schema#",
    "skos": "http://www.w3.org/2004/02/skos/core#",
    "skos08": "http://www.w3.org/2008/05/skos#",
    "skosxl": "http://www.w3.org/2008/05/skos-xl#",
    "sl": "http://www.semanlink.net/2001/00/semanlink-schema#",
    "sm": "http://topbraid.org/sparqlmotion#",
    "smartapi": "http://smart-api.io/ontology/1.0/smartapi#",
    "smf": "http://topbraid.org/sparqlmotionfunctions#",
    "smg": "http://ns.cerise-project.nl/energy/def/cim-smartgrid#",
    "smiley": "http://www.smileyontology.com/ns#",
    "sml": "http://topbraid.org/sparqlmotionlib#",
    "smxm": "http://smxm.ga/",
    "snac": "http://socialarchive.iath.virginia.edu/",
    "snarm": "http://rdf.myexperiment.org/ontologies/snarm/",
    "so": "http://purl.org/ontology/symbolic-music/",
    "soap": "http://www.w3.org/2003/05/soap-envelope/",
    "soc": "http://purl.org/net/hdlipcores/ontology/soc#",
    "soch": "http://kulturarvsdata.se/ksamsok#",
    "soft": "http://www.w3.org/2007/uwa/context/software.owl#",
    "solid": "http://www.w3.org/ns/solid/terms#",
    "sor": "http://purl.org/net/soron/",
    "sorg": "http://schema.org/",
    "sosa": "http://www.w3.org/ns/sosa/",
    "sp": "http://spinrdf.org/sp#",
    "space": "http://purl.org/net/schemas/space/",
    "spacerel": "http://data.ordnancesurvey.co.uk/ontology/spatialrelations/",
    "span": "http://www.ifomis.org/bfo/1.1/span#",
    "sparql": "http://www.w3.org/ns/sparql#",
    "spatial": "http://geovocab.org/spatial#",
    "spc": "http://purl.org/ontomedia/core/space#",
    "spcm": "http://spi-fm.uca.es/spdef/models/deployment/spcm/1.0#",
    "spdx": "http://spdx.org/rdf/terms#",
    "spfood": "http://kmi.open.ac.uk/projects/smartproducts/ontologies/food.owl#",
    "spif": "http://spinrdf.org/spif#",
    "spin": "http://spinrdf.org/spin#",
    "spl": "http://spinrdf.org/spl#",
    "sport": "http://www.bbc.co.uk/ontologies/sport/",
    "spt": "http://spitfire-project.eu/ontology/ns/",
    "spv": "http://completeness.inf.unibz.it/sp-vocab#",
    "sql": "http://ns.inria.fr/ast/sql#",
    "sr": "http://www.openrdf.org/config/repository/sail#",
    "sro": "http://salt.semanticauthoring.org/ontologies/sro#",
    "sru": "http://www.loc.gov/zing/srw/",
    "srx": "http://www.w3.org/2005/sparql-results#",
    "ssn": "http://www.w3.org/ns/ssn/",
    "ssno": "http://www.w3.org/ns/ssn/",
    "sso": "http://nlp2rdf.lod2.eu/schema/sso/",
    "ssso": "http://purl.org/ontology/ssso#",
    "st": "http://semweb.mmlab.be/ns/stoptimes#",
    "stac": "http://securitytoolbox.appspot.com/stac#",
    "stanford": "http://purl.org/olia/stanford.owl#",
    "states": "http://www.w3.org/2005/07/aaa#",
    "static": "http://vocab-ld.org/vocab/static-ld#",
    "stats": "http://purl.org/rdfstats/stats#",
    "status": "http://ontologi.es/status#",
    "steel": "http://ontorule-project.eu/resources/steel-30#",
    "step": "http://purl.org/net/step#",
    "sto": "https://w3id.org/i40/sto#",
    "stories": "http://purl.org/ontology/stories/",
    "str": "http://nlp2rdf.lod2.eu/schema/string/",
    "strdf": "http://strdf.di.uoa.gr/ontology#",
    "stream": "http://dbpedia.org/ontology/Stream/",
    "string": "http://www.w3.org/2000/10/swap/string#",
    "studiop": "http://purl.org/resource/pilatesstudio/",
    "sv": "http://schemas.talis.com/2005/service/schema#",
    "svcs": "http://rdfs.org/sioc/services#",
    "sw": "http://linkedwidgets.org/statisticalwidget/ontology/",
    "swanag": "http://purl.org/swan/1.2/agents/",
    "swanci": "http://purl.org/swan/1.2/citations/",
    "swanco": "http://purl.org/swan/1.2/swan-commons/",
    "swande": "http://purl.org/swan/1.2/discourse-elements/",
    "swandr": "http://purl.org/swan/1.2/discourse-relationships/",
    "swanpav": "http://purl.org/swan/1.2/pav/",
    "swanq": "http://purl.org/swan/1.2/qualifiers/",
    "swanqs": "http://purl.org/swan/1.2/qualifiers/",
    "swc": "http://data.semanticweb.org/ns/swc/ontology#",
    "swcomp": "https://github.com/ali1k/ld-reactor/blob/master/vocabulary/index.ttl#",
    "swh": "http://plugin.org.uk/swh-plugins/",
    "swid": "http://semanticweb.org/id/",
    "swivt": "http://semantic-mediawiki.org/swivt/1.0#",
    "swo": "http://www.ebi.ac.uk/swo/",
    "swp": "http://www.w3.org/2004/03/trix/swp-2/",
    "swpatho": "http://swpatho.ag-nbi.de/context/meta.owl#",
    "swperson": "http://data.semanticweb.org/person/",
    "swpm": "http://spi-fm.uca.es/spdef/models/deployment/swpm/1.0#",
    "swpo": "http://sw-portal.deri.org/ontologies/swportal#",
    "swrc": "http://swrc.ontoware.org/ontology#",
    "swrc2": "https://www.cs.vu.nl/~mcaklein/onto/swrc_ext/2005/05#",
    "swrcfe": "http://www.morelab.deusto.es/ontologies/swrcfe#",
    "swrl": "http://www.w3.org/2003/11/swrl#",
    "swrlb": "http://www.w3.org/2003/11/swrlb#",
    "sx": "http://shex.io/ns/shex#",
    "sylld": "http://www.semanticweb.org/syllabus/data/",
    "sysont": "http://ns.ontowiki.net/SysOnt/",
    "system": "http://www.univalle.edu.co/ontologies/System#",
    "tac": "http://ns.bergnet.org/tac/0.1/triple-access-control#",
    "tadirah": "http://tadirah.dariah.eu/vocab/",
    "tag": "http://www.holygoat.co.uk/owl/redwood/0.1/tags/",
    "tags": "http://www.holygoat.co.uk/owl/redwood/0.1/tags/",
    "tao": "http://vocab.deri.ie/tao#",
    "tarot": "http://data.totl.net/tarot/card/",
    "tarql": "http://tarql.github.io/tarql#",
    "task": "http://deductions.github.io/task-management.owl.ttl#",
    "tavprov": "http://ns.taverna.org.uk/2012/tavernaprov/",
    "taxo": "http://purl.org/rss/1.0/modules/taxonomy/",
    "taxon": "http://purl.org/biodiversity/taxon/",
    "tb": "https://w3id.org/timebank#",
    "tblcard": "http://www.w3.org/People/Berners-Lee/card#",
    "tcga": "http://purl.org/tcga/core#",
    "td": "http://www.w3.org/ns/td#",
    "td5": "http://td5.org/#",
    "tdb": "http://jena.hpl.hp.com/2008/tdb#",
    "tddo": "http://databugger.aksw.org/ns/core#",
    "te": "http://www.w3.org/2006/time-entry#",
    "teach": "http://linkedscience.org/teach/ns#",
    "teamwork": "http://topbraid.org/teamwork#",
    "tei": "http://www.tei-c.org/ns/1.0/",
    "telix": "http://purl.org/telix#",
    "telmap": "http://purl.org/telmap/",
    "tests": "http://test2.example.com/",
    "test2": "http://this.invalid/test2#",
    "text": "http://jena.apache.org/text#",
    "tg": "http://www.turnguard.com/turnguard#",
    "tgm": "http://id.loc.gov/vocabulary/graphicMaterials/",
    "tgn": "http://vocab.getty.edu/tgn/",
    "theatre": "http://purl.org/theatre#",
    "theme": "http://voc.odw.tw/theme/",
    "thors": "http://resource.geosciml.org/ontology/timescale/thors#",
    "ti": "http://www.ontologydesignpatterns.org/cp/owl/timeinterval.owl#",
    "tikag": "https://www.tikag.com/",
    "time": "http://www.w3.org/2006/time#",
    "timeline": "http://purl.org/NET/c4dm/timeline.owl#",
    "timex": "http://data.wu.ac.at/ns/timex#",
    "tio": "http://purl.org/tio/ns#",
    "tis": "http://www.ontologydesignpatterns.org/cp/owl/timeindexedsituation.owl#",
    "tisc": "http://observedchange.com/tisc/ns#",
    "tissue": "http://www.univalle.edu.co/ontologies/Tissue#",
    "tix": "http://toptix.com/2010/esro/",
    "tl": "http://purl.org/NET/c4dm/timeline.owl#",
    "tm": "http://def.seegrid.csiro.au/isotc211/iso19108/2002/temporal#",
    "tmo": "http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#",
    "tmpl": "http://purl.org/restdesc/http-template#",
    "toby": "http://tobyinkster.co.uk/#",
    "topo": "http://data.ign.fr/def/topo#",
    "tosh": "http://topbraid.org/tosh#",
    "tp": "http://tour-pedia.org/download/tp.owl#",
    "tr": "http://www.thomsonreuters.com/",
    "trackback": "http://madskills.com/public/xml/rss/module/trackback/",
    "traffic": "http://www.sensormeasurement.appspot.com/ont/transport/traffic#",
    "trait": "http://contextus.net/ontology/ontomedia/ext/common/trait#",
    "transit": "http://vocab.org/transit/terms/",
    "transmed": "http://www.w3.org/2001/sw/hcls/ns/transmed/",
    "travel": "http://www.co-ode.org/roberts/travel.owl#",
    "trig": "http://www.w3.org/2004/03/trix/rdfg-1/",
    "tripfs": "http://purl.org/tripfs/2010/02#",
    "tripfs2": "http://purl.org/tripfs/2010/06#",
    "tsioc": "http://rdfs.org/sioc/types#",
    "tsn": "http://purl.org/net/tsn#",
    "tsnchange": "http://purl.org/net/tsnchange#",
    "ttl": "http://www.w3.org/2008/turtle#",
    "ttla": "https://w3id.org/ttla/",
    "ttp": "http://eample.com/tests#",
    "tui": "http://data.ifs.tuwien.ac.at/study/resource/",
    "turismo": "http://idi.fundacionctic.org/cruzar/turismo#",
    "tvc": "http://www.essepuntato.it/2012/04/tvc/",
    "tw": "http://tw.rpi.edu/schema/",
    "twaapi": "http://purl.org/twc/vocab/aapi-schema#",
    "tx": "http://swtmp.gitlab.io/vocabulary/templates.owl#",
    "txn": "http://lod.taxonconcept.org/ontology/txn.owl#",
    "type": "http://info.deepcarbon.net/schema/type#",
    "tzont": "http://www.w3.org/2006/timezone#",
    "ub": "http://www.lehigh.edu/~zhp2/2004/0401/univ-bench.owl#",
    "ubiq": "http://server.ubiqore.com/ubiq/core#",
    "uby": "http://purl.org/olia/ubyCat.owl#",
    "uc": "http://ucuenca.edu.ec/ontology#",
    "uco": "http://purl.org/uco/ns#",
    "ufmedia": "http://purl.org/microformat/hmedia/",
    "ui": "http://www.w3.org/ns/ui#",
    "uis": "http://uis.270a.info/dataset/",
    "ul": "http://underlay.mit.edu/ns/",
    "ulan": "http://vocab.getty.edu/ulan/",
    "um": "http://intelleo.eu/ontologies/user-model/ns/",
    "umbel": "http://umbel.org/umbel#",
    "umbelrc": "http://umbel.org/umbel/rc/",
    "umls": "http://bioportal.bioontology.org/ontologies/umls/",
    "un": "http://www.w3.org/2007/ont/unit#",
    "undata": "http://citydata.wu.ac.at/Linked-UNData/data/",
    "uneskos": "http://purl.org/voc/uneskos#",
    "uni": "http://purl.org/weso/uni/uni.html#",
    "uniprot": "http://purl.uniprot.org/core/",
    "unit": "http://qudt.org/vocab/unit#",
    "units": "http://eulersharp.sourceforge.net/2003/03swap/units#",
    "unspsc": "http://ontoview.org/schema/unspsc/1#",
    "uom": "http://www.opengis.net/def/uom/OGC/1.0/",
    "up": "http://users.ugent.be/~tdenies/up/",
    "uri": "http://purl.org/NET/uri#",
    "uri4uri": "http://uri4uri.net/vocab#",
    "urn": "http://fliqz.com/",
    "user": "http://schemas.talis.com/2005/user/schema#",
    "usgov": "http://www.rdfabout.com/rdf/schema/usgovt/",
    "uta": "http://uptheasset.org/ontology#",
    "va": "http://code-research.eu/ontology/visual-analytics#",
    "vacseen1": "http://www.semanticweb.org/parthasb/ontologies/2014/6/vacseen1/",
    "vaem": "http://www.linkedmodel.org/schema/vaem#",
    "vag": "http://www.essepuntato.it/2013/10/vagueness/",
    "valueflows": "https://w3id.org/valueflows/",
    "vam": "http://www.metmuseum.org/",
    "vann": "http://purl.org/vocab/vann/",
    "vapour": "http://vapour.sourceforge.net/vocab.rdf#",
    "vartrans": "http://www.w3.org/ns/lemon/vartrans#",
    "vcard": "http://www.w3.org/2006/vcard/ns#",
    "vcard2006": "http://www.w3.org/2006/vcard/ns#",
    "vcardx": "http://buzzword.org.uk/rdf/vcardx#",
    "vdpp": "http://data.lirmm.fr/ontologies/vdpp#",
    "vehma": "http://deductions.github.io/vehicule-management.owl.ttl#",
    "vehman": "http://deductions.github.io/vehicule-management.owl.ttl#",
    "ver": "https://w3id.org/version/ontology#",
    "verb": "https://w3id.org/verb/",
    "vext": "http://ldf.fi/void-ext#",
    "vf": "https://w3id.org/valueflows#",
    "vgo": "http://purl.org/net/VideoGameOntology#",
    "viaf": "http://viaf.org/ontology/1.1/#",
    "video": "http://purl.org/ontology/video#",
    "videogame": "http://purl.org/net/vgo#",
    "vidont": "http://vidont.org/",
    "vin": "http://www.w3.org/TR/2003/PR-owl-guide-20031209/wine#",
    "vir": "http://w3id.org/vir#",
    "visit": "http://purl.org/net/vocab/2004/07/visit#",
    "visko": "http://trust.utep.edu/visko/ontology/visko-operator-v3.owl#",
    "viskoo": "http://trust.utep.edu/visko/ontology/visko-operator-v3.owl#",
    "viskov": "http://trust.utep.edu/visko/ontology/visko-view-v3.owl#",
    "viso": "http://purl.org/viso/",
    "vitro": "http://vitro.mannlib.cornell.edu/ns/vitro/public#",
    "vivo": "http://vivoweb.org/ontology/core#",
    "vmm": "http://spi-fm.uca.es/spdef/models/genericTools/vmm/1.0#",
    "voaf": "http://purl.org/vocommons/voaf#",
    "voag": "http://voag.linkedmodel.org/schema/voag#",
    "voc": "http://voc.odw.tw/",
    "vocab": "http://rdf.ontology2.com/vocab#",
    "vocnet": "http://schema.vocnet.org/",
    "vogd": "http://ogd.ifs.tuwien.ac.at/vienna/geo/",
    "void": "http://rdfs.org/ns/void#",
    "voidex": "http://www.swi-prolog.org/rdf/library/",
    "voidext": "http://rdfs.org/ns/void-ext#",
    "voidp": "http://www.enakting.org/provenance/voidp/",
    "voidwh": "http://www.ics.forth.gr/isl/VoIDWarehouse/VoID_Extension_Schema.owl#",
    "volt": "http://volt-name.space/ontology/",
    "vort": "http://rockets.topbraid.solutions/vort/",
    "vote": "http://www.rdfabout.com/rdf/schema/vote/",
    "vplan": "http://www.ifs.tuwien.ac.at/~miksa/ontologies/VPlan.owl#",
    "vra": "http://simile.mit.edu/2003/10/ontologies/vraCore3#",
    "vrank": "http://purl.org/voc/vrank#",
    "vs": "http://www.w3.org/2003/06/sw-vocab-status/ns#",
    "vsearch": "http://vocab.sti2.at/vsearch#",
    "vso": "http://purl.org/vso/ns#",
    "vsr": "http://purl.org/twc/vocab/vsr#",
    "vss": "http://automotive.eurecom.fr/vsso#",
    "vsso": "http://automotive.eurecom.fr/vsso#",
    "vsto": "http://escience.rpi.edu/ontology/vsto/2/0/vsto.owl#",
    "vstoi": "http://hadatac.org/ont/vstoi#",
    "vsw": "http://verticalsearchworks.com/ontology/",
    "vsws": "http://verticalsearchworks.com/ontology/synset#",
    "vvo": "http://purl.org/vvo/ns#",
    "w3cgeo": "http://www.w3.org/2003/01/geo/wgs84_pos#",
    "w3con": "http://www.w3.org/2000/10/swap/pim/contact#",
    "w3p": "http://prov4j.org/w3p/",
    "w3po": "http://purl.org/provenance/w3p/w3po#",
    "waarde": "https://lod.milieuinfo.be/ns/waarde#",
    "wab": "http://wab.uib.no/cost-a32_philospace/wittgenstein.owl#",
    "wai": "http://purl.org/wai#",
    "wail": "http://www.eyrie.org/~zednenem/2002/wail/",
    "wairole": "http://www.w3.org/2005/01/wai-rdf/GUIRoleTaxonomy#",
    "wao": "http://webtlab.it.uc3m.es/2010/10/WebAppsOntology#",
    "wapp": "http://ns.rww.io/wapp#",
    "water": "http://escience.rpi.edu/ontology/semanteco/2/0/water.owl#",
    "wb": "http://data.worldbank.org/",
    "wbc": "http://worldbank.270a.info/classification/",
    "wbp": "http://worldbank.270a.info/property/",
    "wd": "http://www.wikidata.org/entity/",
    "wde": "http://www.wikidata.org/entity/",
    "wdr": "http://www.w3.org/2007/05/powder#",
    "wdrs": "http://www.w3.org/2007/05/powder-s#",
    "wdt": "http://www.wikidata.org/prop/direct/",
    "wdv": "http://www.wikidata.org/value/",
    "web": "http://www.w3.org/2007/uwa/context/web.owl#",
    "webac": "http://fedora.info/definitions/v4/webac#",
    "webbox": "http://webbox.ecs.soton.ac.uk/ns#",
    "webservice": "http://www.openlinksw.com/ontology/webservices#",
    "webtlab": "http://webtlab.it.uc3m.es/",
    "wf": "http://www.w3.org/2005/01/wf/flow#",
    "wf4ever": "http://purl.org/wf4ever/wf4ever#",
    "wfdesc": "http://purl.org/wf4ever/wfdesc#",
    "wfm": "http://purl.org/net/wf-motifs#",
    "wfn": "http://webofcode.org/wfn/",
    "wfprov": "http://purl.org/wf4ever/wfprov#",
    "wfs": "http://schemas.opengis.net/wfs/",
    "wgs": "http://www.w3.org/2003/01/geo/wgs84_pos#",
    "wgs84": "http://www.w3.org/2003/01/geo/wgs84_pos#",
    "wgspos": "http://www.w3.org/2003/01/geo/wgs84_pos#",
    "whisky": "http://vocab.org/whisky/terms/",
    "who": "http://www.who.int/vocab/ontology#",
    "whois": "http://www.kanzaki.com/ns/whois#",
    "wi": "http://purl.org/ontology/wi/core#",
    "wiki": "http://en.wikipedia.org/wiki/",
    "wikibase": "http://wikiba.se/ontology#",
    "wikidata": "http://www.wikidata.org/entity/",
    "wikim": "http://spi-fm.uca.es/spdef/models/genericTools/wikim/1.0#",
    "wikimedia": "http://upload.wikimedia.org/wikipedia/commons/f/f6/",
    "wikipedia": "http://wikipedia.no/rdf/",
    "wikterms": "http://wiktionary.dbpedia.org/terms/",
    "wimpo": "http://rdfex.org/withImports?uri=",
    "wisski": "http://wiss-ki.eu/",
    "wkd": "http://schema.wolterskluwer.de/",
    "wl": "http://www.wsmo.org/ns/wsmo-lite#",
    "wlo": "http://purl.org/ontology/wo/",
    "wlp": "http://weblab-project.org/core/model/property/processing/",
    "wm": "http://ns.inria.fr/webmarks#",
    "wn": "http://xmlns.com/wordnet/1.6/",
    "wn20": "http://www.w3.org/2006/03/wn/wn20/",
    "wn20schema": "http://www.w3.org/2006/03/wn/wn20/schema/",
    "wn30": "http://purl.org/vocabularies/princeton/wn30/",
    "wn31": "http://wordnet-rdf.princeton.edu/wn31/",
    "wno": "http://wordnet-rdf.princeton.edu/ontology#",
    "wnschema": "http://www.cogsci.princeton.edu/~wn/schema/",
    "wo": "http://purl.org/ontology/wo/",
    "won": "http://purl.org/webofneeds/model#",
    "wordmap": "http://purl.org/net/ns/wordmap#",
    "wordnet": "http://wordnet-rdf.princeton.edu/ontology#",
    "worldbank": "http://worldbank.270a.info/dataset/",
    "wot": "http://xmlns.com/wot/0.1/",
    "wp": "http://vocabularies.wikipathways.org/wp#",
    "wro": "http://purl.org/net/wf4ever/ro#",
    "ws": "http://www.w3.org/ns/pim/space#",
    "wsc": "http://www.openk.org/wscaim.owl#",
    "wscaim": "http://www.openk.org/wscaim.owl#",
    "wsdl": "http://www.w3.org/ns/wsdl-rdf#",
    "wsl": "http://www.wsmo.org/ns/wsmo-lite#",
    "wv": "http://vocab.org/waiver/terms/",
    "xapi": "http://purl.org/xapi/ontology#",
    "xbrli": "http://www.xbrl.org/2003/instance#",
    "xch": "http://oanda2rdf.appspot.com/xch/",
    "xcql": "http://docs.oasis-open.org/ns/search-ws/xcql#",
    "xds": "http://www.w3.org/2001/XMLSchema#",
    "xen": "http://buzzword.org.uk/rdf/xen#",
    "xesam": "http://freedesktop.org/standards/xesam/1.0/core#",
    "xf": "http://www.w3.org/2002/xforms/",
    "xfn": "http://gmpg.org/xfn/11#",
    "xfnv": "http://vocab.sindice.com/xfn#",
    "xforms": "http://www.w3.org/2002/xforms/",
    "xhe": "http://buzzword.org.uk/rdf/xhtml-elements#",
    "xhtml": "http://www.w3.org/1999/xhtml#",
    "xhtmlvocab": "http://www.w3.org/1999/xhtml/vocab/",
    "xhv": "http://www.w3.org/1999/xhtml/vocab#",
    "xkos": "http://rdf-vocabulary.ddialliance.org/xkos#",
    "xl": "http://langegger.at/xlwrap/vocab#",
    "xlime": "http://xlime-project.org/vocab/",
    "xlink": "http://www.w3.org/1999/xlink/",
    "xml": "http://www.w3.org/XML/1998/namespace/",
    "xmls": "http://www.w3.org/2001/XMLSchema#",
    "xmp": "http://ns.adobe.com/xap/1.0/",
    "xrd": "http://docs.oasis-open.org/ns/xri/xrd-1.0#",
    "xro": "http://purl.org/xro/ns#",
    "xs": "http://www.w3.org/2001/XMLSchema#",
    "xsd": "http://www.w3.org/2001/XMLSchema#",
    "xsi": "http://www.w3.org/2001/XMLSchema-instance#",
    "xsl": "http://www.w3.org/1999/XSL/Transform#",
    "xslopm": "http://purl.org/net/opmv/types/xslt#",
    "xt": "http://purl.org/twc/vocab/cross-topix#",
    "xtypes": "http://purl.org/xtypes/",
    "ya": "http://blogs.yandex.ru/schema/foaf/",
    "yaco": "https://www.irit.fr/recherches/MELODI/ontologies/cinema#",
    "yago": "http://yago-knowledge.org/resource/",
    "yd": "https://yodata.io/",
    "year": "http://www.w3.org/year/",
    "yo": "http://yovisto.com/",
    "yoda": "http://purl.org/NET/yoda#",
    "yso": "http://www.yso.fi/onto/yso/",
    "zbwext": "http://zbw.eu/namespaces/zbw-extensions/",
    "zem": "http://s.zemanta.com/ns#",
    "zoology": "http://purl.org/NET/biol/zoology#",
    "zoomaterms": "http://rdf.ebi.ac.uk/vocabulary/zooma/",
    "zr": "http://explain.z3950.org/dtd/2.0/",
}
