# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixVpnUserArgs', 'AviatrixVpnUser']

@pulumi.input_type
class AviatrixVpnUserArgs:
    def __init__(__self__, *,
                 user_name: pulumi.Input[str],
                 dns_name: Optional[pulumi.Input[str]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 manage_user_attachment: Optional[pulumi.Input[bool]] = None,
                 profiles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 saml_endpoint: Optional[pulumi.Input[str]] = None,
                 user_email: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AviatrixVpnUser resource.
        :param pulumi.Input[str] user_name: VPN user name.
        :param pulumi.Input[str] dns_name: FQDN of a DNS based VPN service such as GeoVPN or UDP load balancer.
        :param pulumi.Input[str] gw_name: If ELB is enabled, this will be the name of the ELB, else it will be the name of the Aviatrix VPN gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] profiles: List of profiles for user to attach to.
        :param pulumi.Input[str] saml_endpoint: This is the name of the SAML endpoint to which the user will be associated.
        :param pulumi.Input[str] user_email: VPN User's email.
        :param pulumi.Input[str] vpc_id: VPC Id of Aviatrix VPN gateway.
        """
        pulumi.set(__self__, "user_name", user_name)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if gw_name is not None:
            pulumi.set(__self__, "gw_name", gw_name)
        if manage_user_attachment is not None:
            pulumi.set(__self__, "manage_user_attachment", manage_user_attachment)
        if profiles is not None:
            pulumi.set(__self__, "profiles", profiles)
        if saml_endpoint is not None:
            pulumi.set(__self__, "saml_endpoint", saml_endpoint)
        if user_email is not None:
            pulumi.set(__self__, "user_email", user_email)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Input[str]:
        """
        VPN user name.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        FQDN of a DNS based VPN service such as GeoVPN or UDP load balancer.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> Optional[pulumi.Input[str]]:
        """
        If ELB is enabled, this will be the name of the ELB, else it will be the name of the Aviatrix VPN gateway.
        """
        return pulumi.get(self, "gw_name")

    @gw_name.setter
    def gw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gw_name", value)

    @property
    @pulumi.getter(name="manageUserAttachment")
    def manage_user_attachment(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "manage_user_attachment")

    @manage_user_attachment.setter
    def manage_user_attachment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "manage_user_attachment", value)

    @property
    @pulumi.getter
    def profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of profiles for user to attach to.
        """
        return pulumi.get(self, "profiles")

    @profiles.setter
    def profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "profiles", value)

    @property
    @pulumi.getter(name="samlEndpoint")
    def saml_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        This is the name of the SAML endpoint to which the user will be associated.
        """
        return pulumi.get(self, "saml_endpoint")

    @saml_endpoint.setter
    def saml_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "saml_endpoint", value)

    @property
    @pulumi.getter(name="userEmail")
    def user_email(self) -> Optional[pulumi.Input[str]]:
        """
        VPN User's email.
        """
        return pulumi.get(self, "user_email")

    @user_email.setter
    def user_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_email", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        VPC Id of Aviatrix VPN gateway.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.input_type
class _AviatrixVpnUserState:
    def __init__(__self__, *,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 manage_user_attachment: Optional[pulumi.Input[bool]] = None,
                 profiles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 saml_endpoint: Optional[pulumi.Input[str]] = None,
                 user_email: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixVpnUser resources.
        :param pulumi.Input[str] dns_name: FQDN of a DNS based VPN service such as GeoVPN or UDP load balancer.
        :param pulumi.Input[str] gw_name: If ELB is enabled, this will be the name of the ELB, else it will be the name of the Aviatrix VPN gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] profiles: List of profiles for user to attach to.
        :param pulumi.Input[str] saml_endpoint: This is the name of the SAML endpoint to which the user will be associated.
        :param pulumi.Input[str] user_email: VPN User's email.
        :param pulumi.Input[str] user_name: VPN user name.
        :param pulumi.Input[str] vpc_id: VPC Id of Aviatrix VPN gateway.
        """
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if gw_name is not None:
            pulumi.set(__self__, "gw_name", gw_name)
        if manage_user_attachment is not None:
            pulumi.set(__self__, "manage_user_attachment", manage_user_attachment)
        if profiles is not None:
            pulumi.set(__self__, "profiles", profiles)
        if saml_endpoint is not None:
            pulumi.set(__self__, "saml_endpoint", saml_endpoint)
        if user_email is not None:
            pulumi.set(__self__, "user_email", user_email)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        FQDN of a DNS based VPN service such as GeoVPN or UDP load balancer.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> Optional[pulumi.Input[str]]:
        """
        If ELB is enabled, this will be the name of the ELB, else it will be the name of the Aviatrix VPN gateway.
        """
        return pulumi.get(self, "gw_name")

    @gw_name.setter
    def gw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gw_name", value)

    @property
    @pulumi.getter(name="manageUserAttachment")
    def manage_user_attachment(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "manage_user_attachment")

    @manage_user_attachment.setter
    def manage_user_attachment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "manage_user_attachment", value)

    @property
    @pulumi.getter
    def profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of profiles for user to attach to.
        """
        return pulumi.get(self, "profiles")

    @profiles.setter
    def profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "profiles", value)

    @property
    @pulumi.getter(name="samlEndpoint")
    def saml_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        This is the name of the SAML endpoint to which the user will be associated.
        """
        return pulumi.get(self, "saml_endpoint")

    @saml_endpoint.setter
    def saml_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "saml_endpoint", value)

    @property
    @pulumi.getter(name="userEmail")
    def user_email(self) -> Optional[pulumi.Input[str]]:
        """
        VPN User's email.
        """
        return pulumi.get(self, "user_email")

    @user_email.setter
    def user_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_email", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        VPN user name.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        VPC Id of Aviatrix VPN gateway.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class AviatrixVpnUser(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 manage_user_attachment: Optional[pulumi.Input[bool]] = None,
                 profiles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 saml_endpoint: Optional[pulumi.Input[str]] = None,
                 user_email: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a AviatrixVpnUser resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] dns_name: FQDN of a DNS based VPN service such as GeoVPN or UDP load balancer.
        :param pulumi.Input[str] gw_name: If ELB is enabled, this will be the name of the ELB, else it will be the name of the Aviatrix VPN gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] profiles: List of profiles for user to attach to.
        :param pulumi.Input[str] saml_endpoint: This is the name of the SAML endpoint to which the user will be associated.
        :param pulumi.Input[str] user_email: VPN User's email.
        :param pulumi.Input[str] user_name: VPN user name.
        :param pulumi.Input[str] vpc_id: VPC Id of Aviatrix VPN gateway.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixVpnUserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AviatrixVpnUser resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AviatrixVpnUserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixVpnUserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 manage_user_attachment: Optional[pulumi.Input[bool]] = None,
                 profiles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 saml_endpoint: Optional[pulumi.Input[str]] = None,
                 user_email: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixVpnUserArgs.__new__(AviatrixVpnUserArgs)

            __props__.__dict__["dns_name"] = dns_name
            __props__.__dict__["gw_name"] = gw_name
            __props__.__dict__["manage_user_attachment"] = manage_user_attachment
            __props__.__dict__["profiles"] = profiles
            __props__.__dict__["saml_endpoint"] = saml_endpoint
            __props__.__dict__["user_email"] = user_email
            if user_name is None and not opts.urn:
                raise TypeError("Missing required property 'user_name'")
            __props__.__dict__["user_name"] = user_name
            __props__.__dict__["vpc_id"] = vpc_id
        super(AviatrixVpnUser, __self__).__init__(
            'aviatrix:index/aviatrixVpnUser:AviatrixVpnUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dns_name: Optional[pulumi.Input[str]] = None,
            gw_name: Optional[pulumi.Input[str]] = None,
            manage_user_attachment: Optional[pulumi.Input[bool]] = None,
            profiles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            saml_endpoint: Optional[pulumi.Input[str]] = None,
            user_email: Optional[pulumi.Input[str]] = None,
            user_name: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'AviatrixVpnUser':
        """
        Get an existing AviatrixVpnUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] dns_name: FQDN of a DNS based VPN service such as GeoVPN or UDP load balancer.
        :param pulumi.Input[str] gw_name: If ELB is enabled, this will be the name of the ELB, else it will be the name of the Aviatrix VPN gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] profiles: List of profiles for user to attach to.
        :param pulumi.Input[str] saml_endpoint: This is the name of the SAML endpoint to which the user will be associated.
        :param pulumi.Input[str] user_email: VPN User's email.
        :param pulumi.Input[str] user_name: VPN user name.
        :param pulumi.Input[str] vpc_id: VPC Id of Aviatrix VPN gateway.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixVpnUserState.__new__(_AviatrixVpnUserState)

        __props__.__dict__["dns_name"] = dns_name
        __props__.__dict__["gw_name"] = gw_name
        __props__.__dict__["manage_user_attachment"] = manage_user_attachment
        __props__.__dict__["profiles"] = profiles
        __props__.__dict__["saml_endpoint"] = saml_endpoint
        __props__.__dict__["user_email"] = user_email
        __props__.__dict__["user_name"] = user_name
        __props__.__dict__["vpc_id"] = vpc_id
        return AviatrixVpnUser(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> pulumi.Output[Optional[str]]:
        """
        FQDN of a DNS based VPN service such as GeoVPN or UDP load balancer.
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> pulumi.Output[Optional[str]]:
        """
        If ELB is enabled, this will be the name of the ELB, else it will be the name of the Aviatrix VPN gateway.
        """
        return pulumi.get(self, "gw_name")

    @property
    @pulumi.getter(name="manageUserAttachment")
    def manage_user_attachment(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "manage_user_attachment")

    @property
    @pulumi.getter
    def profiles(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of profiles for user to attach to.
        """
        return pulumi.get(self, "profiles")

    @property
    @pulumi.getter(name="samlEndpoint")
    def saml_endpoint(self) -> pulumi.Output[Optional[str]]:
        """
        This is the name of the SAML endpoint to which the user will be associated.
        """
        return pulumi.get(self, "saml_endpoint")

    @property
    @pulumi.getter(name="userEmail")
    def user_email(self) -> pulumi.Output[Optional[str]]:
        """
        VPN User's email.
        """
        return pulumi.get(self, "user_email")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[str]:
        """
        VPN user name.
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[Optional[str]]:
        """
        VPC Id of Aviatrix VPN gateway.
        """
        return pulumi.get(self, "vpc_id")

