# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixVgwConnArgs', 'AviatrixVgwConn']

@pulumi.input_type
class AviatrixVgwConnArgs:
    def __init__(__self__, *,
                 bgp_local_as_num: pulumi.Input[str],
                 bgp_vgw_account: pulumi.Input[str],
                 bgp_vgw_id: pulumi.Input[str],
                 bgp_vgw_region: pulumi.Input[str],
                 conn_name: pulumi.Input[str],
                 gw_name: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 enable_event_triggered_ha: Optional[pulumi.Input[bool]] = None,
                 enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
                 manual_bgp_advertised_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a AviatrixVgwConn resource.
        :param pulumi.Input[str] bgp_local_as_num: BGP local ASN (Autonomous System Number). Integer between 1-4294967294.
        :param pulumi.Input[str] bgp_vgw_account: Account of AWS's VGW that is used for this connection.
        :param pulumi.Input[str] bgp_vgw_id: Id of AWS's VGW that is used for this connection.
        :param pulumi.Input[str] bgp_vgw_region: Region of AWS's VGW that is used for this connection.
        :param pulumi.Input[str] conn_name: The name of the VGW connection which is going to be created.
        :param pulumi.Input[str] gw_name: Name of the Transit Gateway.
        :param pulumi.Input[str] vpc_id: VPC-ID where the Transit Gateway is located.
        :param pulumi.Input[bool] enable_event_triggered_ha: Enable Event Triggered HA.
        :param pulumi.Input[bool] enable_learned_cidrs_approval: Enable learned CIDR approval for the connection. Requires the transit_gateway's 'learned_cidrs_approval_mode' attribute
               be set to 'connection'. Valid values: true, false. Default value: false. Available as of provider version R2.18+.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] manual_bgp_advertised_cidrs: Configure manual BGP advertised CIDRs for this connection. Available as of provider version R2.18+.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prepend_as_paths: Connection AS Path Prepend customized by specifying AS PATH for a BGP connection.
        """
        pulumi.set(__self__, "bgp_local_as_num", bgp_local_as_num)
        pulumi.set(__self__, "bgp_vgw_account", bgp_vgw_account)
        pulumi.set(__self__, "bgp_vgw_id", bgp_vgw_id)
        pulumi.set(__self__, "bgp_vgw_region", bgp_vgw_region)
        pulumi.set(__self__, "conn_name", conn_name)
        pulumi.set(__self__, "gw_name", gw_name)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if enable_event_triggered_ha is not None:
            pulumi.set(__self__, "enable_event_triggered_ha", enable_event_triggered_ha)
        if enable_learned_cidrs_approval is not None:
            pulumi.set(__self__, "enable_learned_cidrs_approval", enable_learned_cidrs_approval)
        if manual_bgp_advertised_cidrs is not None:
            pulumi.set(__self__, "manual_bgp_advertised_cidrs", manual_bgp_advertised_cidrs)
        if prepend_as_paths is not None:
            pulumi.set(__self__, "prepend_as_paths", prepend_as_paths)

    @property
    @pulumi.getter(name="bgpLocalAsNum")
    def bgp_local_as_num(self) -> pulumi.Input[str]:
        """
        BGP local ASN (Autonomous System Number). Integer between 1-4294967294.
        """
        return pulumi.get(self, "bgp_local_as_num")

    @bgp_local_as_num.setter
    def bgp_local_as_num(self, value: pulumi.Input[str]):
        pulumi.set(self, "bgp_local_as_num", value)

    @property
    @pulumi.getter(name="bgpVgwAccount")
    def bgp_vgw_account(self) -> pulumi.Input[str]:
        """
        Account of AWS's VGW that is used for this connection.
        """
        return pulumi.get(self, "bgp_vgw_account")

    @bgp_vgw_account.setter
    def bgp_vgw_account(self, value: pulumi.Input[str]):
        pulumi.set(self, "bgp_vgw_account", value)

    @property
    @pulumi.getter(name="bgpVgwId")
    def bgp_vgw_id(self) -> pulumi.Input[str]:
        """
        Id of AWS's VGW that is used for this connection.
        """
        return pulumi.get(self, "bgp_vgw_id")

    @bgp_vgw_id.setter
    def bgp_vgw_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "bgp_vgw_id", value)

    @property
    @pulumi.getter(name="bgpVgwRegion")
    def bgp_vgw_region(self) -> pulumi.Input[str]:
        """
        Region of AWS's VGW that is used for this connection.
        """
        return pulumi.get(self, "bgp_vgw_region")

    @bgp_vgw_region.setter
    def bgp_vgw_region(self, value: pulumi.Input[str]):
        pulumi.set(self, "bgp_vgw_region", value)

    @property
    @pulumi.getter(name="connName")
    def conn_name(self) -> pulumi.Input[str]:
        """
        The name of the VGW connection which is going to be created.
        """
        return pulumi.get(self, "conn_name")

    @conn_name.setter
    def conn_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "conn_name", value)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> pulumi.Input[str]:
        """
        Name of the Transit Gateway.
        """
        return pulumi.get(self, "gw_name")

    @gw_name.setter
    def gw_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "gw_name", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        VPC-ID where the Transit Gateway is located.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="enableEventTriggeredHa")
    def enable_event_triggered_ha(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Event Triggered HA.
        """
        return pulumi.get(self, "enable_event_triggered_ha")

    @enable_event_triggered_ha.setter
    def enable_event_triggered_ha(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_event_triggered_ha", value)

    @property
    @pulumi.getter(name="enableLearnedCidrsApproval")
    def enable_learned_cidrs_approval(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable learned CIDR approval for the connection. Requires the transit_gateway's 'learned_cidrs_approval_mode' attribute
        be set to 'connection'. Valid values: true, false. Default value: false. Available as of provider version R2.18+.
        """
        return pulumi.get(self, "enable_learned_cidrs_approval")

    @enable_learned_cidrs_approval.setter
    def enable_learned_cidrs_approval(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_learned_cidrs_approval", value)

    @property
    @pulumi.getter(name="manualBgpAdvertisedCidrs")
    def manual_bgp_advertised_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Configure manual BGP advertised CIDRs for this connection. Available as of provider version R2.18+.
        """
        return pulumi.get(self, "manual_bgp_advertised_cidrs")

    @manual_bgp_advertised_cidrs.setter
    def manual_bgp_advertised_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "manual_bgp_advertised_cidrs", value)

    @property
    @pulumi.getter(name="prependAsPaths")
    def prepend_as_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Connection AS Path Prepend customized by specifying AS PATH for a BGP connection.
        """
        return pulumi.get(self, "prepend_as_paths")

    @prepend_as_paths.setter
    def prepend_as_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "prepend_as_paths", value)


@pulumi.input_type
class _AviatrixVgwConnState:
    def __init__(__self__, *,
                 bgp_local_as_num: Optional[pulumi.Input[str]] = None,
                 bgp_vgw_account: Optional[pulumi.Input[str]] = None,
                 bgp_vgw_id: Optional[pulumi.Input[str]] = None,
                 bgp_vgw_region: Optional[pulumi.Input[str]] = None,
                 conn_name: Optional[pulumi.Input[str]] = None,
                 enable_event_triggered_ha: Optional[pulumi.Input[bool]] = None,
                 enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 manual_bgp_advertised_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixVgwConn resources.
        :param pulumi.Input[str] bgp_local_as_num: BGP local ASN (Autonomous System Number). Integer between 1-4294967294.
        :param pulumi.Input[str] bgp_vgw_account: Account of AWS's VGW that is used for this connection.
        :param pulumi.Input[str] bgp_vgw_id: Id of AWS's VGW that is used for this connection.
        :param pulumi.Input[str] bgp_vgw_region: Region of AWS's VGW that is used for this connection.
        :param pulumi.Input[str] conn_name: The name of the VGW connection which is going to be created.
        :param pulumi.Input[bool] enable_event_triggered_ha: Enable Event Triggered HA.
        :param pulumi.Input[bool] enable_learned_cidrs_approval: Enable learned CIDR approval for the connection. Requires the transit_gateway's 'learned_cidrs_approval_mode' attribute
               be set to 'connection'. Valid values: true, false. Default value: false. Available as of provider version R2.18+.
        :param pulumi.Input[str] gw_name: Name of the Transit Gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] manual_bgp_advertised_cidrs: Configure manual BGP advertised CIDRs for this connection. Available as of provider version R2.18+.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prepend_as_paths: Connection AS Path Prepend customized by specifying AS PATH for a BGP connection.
        :param pulumi.Input[str] vpc_id: VPC-ID where the Transit Gateway is located.
        """
        if bgp_local_as_num is not None:
            pulumi.set(__self__, "bgp_local_as_num", bgp_local_as_num)
        if bgp_vgw_account is not None:
            pulumi.set(__self__, "bgp_vgw_account", bgp_vgw_account)
        if bgp_vgw_id is not None:
            pulumi.set(__self__, "bgp_vgw_id", bgp_vgw_id)
        if bgp_vgw_region is not None:
            pulumi.set(__self__, "bgp_vgw_region", bgp_vgw_region)
        if conn_name is not None:
            pulumi.set(__self__, "conn_name", conn_name)
        if enable_event_triggered_ha is not None:
            pulumi.set(__self__, "enable_event_triggered_ha", enable_event_triggered_ha)
        if enable_learned_cidrs_approval is not None:
            pulumi.set(__self__, "enable_learned_cidrs_approval", enable_learned_cidrs_approval)
        if gw_name is not None:
            pulumi.set(__self__, "gw_name", gw_name)
        if manual_bgp_advertised_cidrs is not None:
            pulumi.set(__self__, "manual_bgp_advertised_cidrs", manual_bgp_advertised_cidrs)
        if prepend_as_paths is not None:
            pulumi.set(__self__, "prepend_as_paths", prepend_as_paths)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="bgpLocalAsNum")
    def bgp_local_as_num(self) -> Optional[pulumi.Input[str]]:
        """
        BGP local ASN (Autonomous System Number). Integer between 1-4294967294.
        """
        return pulumi.get(self, "bgp_local_as_num")

    @bgp_local_as_num.setter
    def bgp_local_as_num(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bgp_local_as_num", value)

    @property
    @pulumi.getter(name="bgpVgwAccount")
    def bgp_vgw_account(self) -> Optional[pulumi.Input[str]]:
        """
        Account of AWS's VGW that is used for this connection.
        """
        return pulumi.get(self, "bgp_vgw_account")

    @bgp_vgw_account.setter
    def bgp_vgw_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bgp_vgw_account", value)

    @property
    @pulumi.getter(name="bgpVgwId")
    def bgp_vgw_id(self) -> Optional[pulumi.Input[str]]:
        """
        Id of AWS's VGW that is used for this connection.
        """
        return pulumi.get(self, "bgp_vgw_id")

    @bgp_vgw_id.setter
    def bgp_vgw_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bgp_vgw_id", value)

    @property
    @pulumi.getter(name="bgpVgwRegion")
    def bgp_vgw_region(self) -> Optional[pulumi.Input[str]]:
        """
        Region of AWS's VGW that is used for this connection.
        """
        return pulumi.get(self, "bgp_vgw_region")

    @bgp_vgw_region.setter
    def bgp_vgw_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bgp_vgw_region", value)

    @property
    @pulumi.getter(name="connName")
    def conn_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the VGW connection which is going to be created.
        """
        return pulumi.get(self, "conn_name")

    @conn_name.setter
    def conn_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "conn_name", value)

    @property
    @pulumi.getter(name="enableEventTriggeredHa")
    def enable_event_triggered_ha(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Event Triggered HA.
        """
        return pulumi.get(self, "enable_event_triggered_ha")

    @enable_event_triggered_ha.setter
    def enable_event_triggered_ha(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_event_triggered_ha", value)

    @property
    @pulumi.getter(name="enableLearnedCidrsApproval")
    def enable_learned_cidrs_approval(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable learned CIDR approval for the connection. Requires the transit_gateway's 'learned_cidrs_approval_mode' attribute
        be set to 'connection'. Valid values: true, false. Default value: false. Available as of provider version R2.18+.
        """
        return pulumi.get(self, "enable_learned_cidrs_approval")

    @enable_learned_cidrs_approval.setter
    def enable_learned_cidrs_approval(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_learned_cidrs_approval", value)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Transit Gateway.
        """
        return pulumi.get(self, "gw_name")

    @gw_name.setter
    def gw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gw_name", value)

    @property
    @pulumi.getter(name="manualBgpAdvertisedCidrs")
    def manual_bgp_advertised_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Configure manual BGP advertised CIDRs for this connection. Available as of provider version R2.18+.
        """
        return pulumi.get(self, "manual_bgp_advertised_cidrs")

    @manual_bgp_advertised_cidrs.setter
    def manual_bgp_advertised_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "manual_bgp_advertised_cidrs", value)

    @property
    @pulumi.getter(name="prependAsPaths")
    def prepend_as_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Connection AS Path Prepend customized by specifying AS PATH for a BGP connection.
        """
        return pulumi.get(self, "prepend_as_paths")

    @prepend_as_paths.setter
    def prepend_as_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "prepend_as_paths", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        VPC-ID where the Transit Gateway is located.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class AviatrixVgwConn(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bgp_local_as_num: Optional[pulumi.Input[str]] = None,
                 bgp_vgw_account: Optional[pulumi.Input[str]] = None,
                 bgp_vgw_id: Optional[pulumi.Input[str]] = None,
                 bgp_vgw_region: Optional[pulumi.Input[str]] = None,
                 conn_name: Optional[pulumi.Input[str]] = None,
                 enable_event_triggered_ha: Optional[pulumi.Input[bool]] = None,
                 enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 manual_bgp_advertised_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a AviatrixVgwConn resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bgp_local_as_num: BGP local ASN (Autonomous System Number). Integer between 1-4294967294.
        :param pulumi.Input[str] bgp_vgw_account: Account of AWS's VGW that is used for this connection.
        :param pulumi.Input[str] bgp_vgw_id: Id of AWS's VGW that is used for this connection.
        :param pulumi.Input[str] bgp_vgw_region: Region of AWS's VGW that is used for this connection.
        :param pulumi.Input[str] conn_name: The name of the VGW connection which is going to be created.
        :param pulumi.Input[bool] enable_event_triggered_ha: Enable Event Triggered HA.
        :param pulumi.Input[bool] enable_learned_cidrs_approval: Enable learned CIDR approval for the connection. Requires the transit_gateway's 'learned_cidrs_approval_mode' attribute
               be set to 'connection'. Valid values: true, false. Default value: false. Available as of provider version R2.18+.
        :param pulumi.Input[str] gw_name: Name of the Transit Gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] manual_bgp_advertised_cidrs: Configure manual BGP advertised CIDRs for this connection. Available as of provider version R2.18+.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prepend_as_paths: Connection AS Path Prepend customized by specifying AS PATH for a BGP connection.
        :param pulumi.Input[str] vpc_id: VPC-ID where the Transit Gateway is located.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixVgwConnArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AviatrixVgwConn resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AviatrixVgwConnArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixVgwConnArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bgp_local_as_num: Optional[pulumi.Input[str]] = None,
                 bgp_vgw_account: Optional[pulumi.Input[str]] = None,
                 bgp_vgw_id: Optional[pulumi.Input[str]] = None,
                 bgp_vgw_region: Optional[pulumi.Input[str]] = None,
                 conn_name: Optional[pulumi.Input[str]] = None,
                 enable_event_triggered_ha: Optional[pulumi.Input[bool]] = None,
                 enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 manual_bgp_advertised_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixVgwConnArgs.__new__(AviatrixVgwConnArgs)

            if bgp_local_as_num is None and not opts.urn:
                raise TypeError("Missing required property 'bgp_local_as_num'")
            __props__.__dict__["bgp_local_as_num"] = bgp_local_as_num
            if bgp_vgw_account is None and not opts.urn:
                raise TypeError("Missing required property 'bgp_vgw_account'")
            __props__.__dict__["bgp_vgw_account"] = bgp_vgw_account
            if bgp_vgw_id is None and not opts.urn:
                raise TypeError("Missing required property 'bgp_vgw_id'")
            __props__.__dict__["bgp_vgw_id"] = bgp_vgw_id
            if bgp_vgw_region is None and not opts.urn:
                raise TypeError("Missing required property 'bgp_vgw_region'")
            __props__.__dict__["bgp_vgw_region"] = bgp_vgw_region
            if conn_name is None and not opts.urn:
                raise TypeError("Missing required property 'conn_name'")
            __props__.__dict__["conn_name"] = conn_name
            __props__.__dict__["enable_event_triggered_ha"] = enable_event_triggered_ha
            __props__.__dict__["enable_learned_cidrs_approval"] = enable_learned_cidrs_approval
            if gw_name is None and not opts.urn:
                raise TypeError("Missing required property 'gw_name'")
            __props__.__dict__["gw_name"] = gw_name
            __props__.__dict__["manual_bgp_advertised_cidrs"] = manual_bgp_advertised_cidrs
            __props__.__dict__["prepend_as_paths"] = prepend_as_paths
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
        super(AviatrixVgwConn, __self__).__init__(
            'aviatrix:index/aviatrixVgwConn:AviatrixVgwConn',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bgp_local_as_num: Optional[pulumi.Input[str]] = None,
            bgp_vgw_account: Optional[pulumi.Input[str]] = None,
            bgp_vgw_id: Optional[pulumi.Input[str]] = None,
            bgp_vgw_region: Optional[pulumi.Input[str]] = None,
            conn_name: Optional[pulumi.Input[str]] = None,
            enable_event_triggered_ha: Optional[pulumi.Input[bool]] = None,
            enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
            gw_name: Optional[pulumi.Input[str]] = None,
            manual_bgp_advertised_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'AviatrixVgwConn':
        """
        Get an existing AviatrixVgwConn resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bgp_local_as_num: BGP local ASN (Autonomous System Number). Integer between 1-4294967294.
        :param pulumi.Input[str] bgp_vgw_account: Account of AWS's VGW that is used for this connection.
        :param pulumi.Input[str] bgp_vgw_id: Id of AWS's VGW that is used for this connection.
        :param pulumi.Input[str] bgp_vgw_region: Region of AWS's VGW that is used for this connection.
        :param pulumi.Input[str] conn_name: The name of the VGW connection which is going to be created.
        :param pulumi.Input[bool] enable_event_triggered_ha: Enable Event Triggered HA.
        :param pulumi.Input[bool] enable_learned_cidrs_approval: Enable learned CIDR approval for the connection. Requires the transit_gateway's 'learned_cidrs_approval_mode' attribute
               be set to 'connection'. Valid values: true, false. Default value: false. Available as of provider version R2.18+.
        :param pulumi.Input[str] gw_name: Name of the Transit Gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] manual_bgp_advertised_cidrs: Configure manual BGP advertised CIDRs for this connection. Available as of provider version R2.18+.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prepend_as_paths: Connection AS Path Prepend customized by specifying AS PATH for a BGP connection.
        :param pulumi.Input[str] vpc_id: VPC-ID where the Transit Gateway is located.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixVgwConnState.__new__(_AviatrixVgwConnState)

        __props__.__dict__["bgp_local_as_num"] = bgp_local_as_num
        __props__.__dict__["bgp_vgw_account"] = bgp_vgw_account
        __props__.__dict__["bgp_vgw_id"] = bgp_vgw_id
        __props__.__dict__["bgp_vgw_region"] = bgp_vgw_region
        __props__.__dict__["conn_name"] = conn_name
        __props__.__dict__["enable_event_triggered_ha"] = enable_event_triggered_ha
        __props__.__dict__["enable_learned_cidrs_approval"] = enable_learned_cidrs_approval
        __props__.__dict__["gw_name"] = gw_name
        __props__.__dict__["manual_bgp_advertised_cidrs"] = manual_bgp_advertised_cidrs
        __props__.__dict__["prepend_as_paths"] = prepend_as_paths
        __props__.__dict__["vpc_id"] = vpc_id
        return AviatrixVgwConn(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bgpLocalAsNum")
    def bgp_local_as_num(self) -> pulumi.Output[str]:
        """
        BGP local ASN (Autonomous System Number). Integer between 1-4294967294.
        """
        return pulumi.get(self, "bgp_local_as_num")

    @property
    @pulumi.getter(name="bgpVgwAccount")
    def bgp_vgw_account(self) -> pulumi.Output[str]:
        """
        Account of AWS's VGW that is used for this connection.
        """
        return pulumi.get(self, "bgp_vgw_account")

    @property
    @pulumi.getter(name="bgpVgwId")
    def bgp_vgw_id(self) -> pulumi.Output[str]:
        """
        Id of AWS's VGW that is used for this connection.
        """
        return pulumi.get(self, "bgp_vgw_id")

    @property
    @pulumi.getter(name="bgpVgwRegion")
    def bgp_vgw_region(self) -> pulumi.Output[str]:
        """
        Region of AWS's VGW that is used for this connection.
        """
        return pulumi.get(self, "bgp_vgw_region")

    @property
    @pulumi.getter(name="connName")
    def conn_name(self) -> pulumi.Output[str]:
        """
        The name of the VGW connection which is going to be created.
        """
        return pulumi.get(self, "conn_name")

    @property
    @pulumi.getter(name="enableEventTriggeredHa")
    def enable_event_triggered_ha(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable Event Triggered HA.
        """
        return pulumi.get(self, "enable_event_triggered_ha")

    @property
    @pulumi.getter(name="enableLearnedCidrsApproval")
    def enable_learned_cidrs_approval(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable learned CIDR approval for the connection. Requires the transit_gateway's 'learned_cidrs_approval_mode' attribute
        be set to 'connection'. Valid values: true, false. Default value: false. Available as of provider version R2.18+.
        """
        return pulumi.get(self, "enable_learned_cidrs_approval")

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> pulumi.Output[str]:
        """
        Name of the Transit Gateway.
        """
        return pulumi.get(self, "gw_name")

    @property
    @pulumi.getter(name="manualBgpAdvertisedCidrs")
    def manual_bgp_advertised_cidrs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Configure manual BGP advertised CIDRs for this connection. Available as of provider version R2.18+.
        """
        return pulumi.get(self, "manual_bgp_advertised_cidrs")

    @property
    @pulumi.getter(name="prependAsPaths")
    def prepend_as_paths(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Connection AS Path Prepend customized by specifying AS PATH for a BGP connection.
        """
        return pulumi.get(self, "prepend_as_paths")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        VPC-ID where the Transit Gateway is located.
        """
        return pulumi.get(self, "vpc_id")

