# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixTransitGatewayPeeringArgs', 'AviatrixTransitGatewayPeering']

@pulumi.input_type
class AviatrixTransitGatewayPeeringArgs:
    def __init__(__self__, *,
                 transit_gateway_name1: pulumi.Input[str],
                 transit_gateway_name2: pulumi.Input[str],
                 enable_insane_mode_encryption_over_internet: Optional[pulumi.Input[bool]] = None,
                 enable_max_performance: Optional[pulumi.Input[bool]] = None,
                 enable_peering_over_private_network: Optional[pulumi.Input[bool]] = None,
                 enable_single_tunnel_mode: Optional[pulumi.Input[bool]] = None,
                 gateway1_excluded_network_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 gateway1_excluded_tgw_connections: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 gateway2_excluded_network_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 gateway2_excluded_tgw_connections: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 prepend_as_path1s: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 prepend_as_path2s: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tunnel_count: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a AviatrixTransitGatewayPeering resource.
        :param pulumi.Input[str] transit_gateway_name1: The first transit gateway name to make a peer pair.
        :param pulumi.Input[str] transit_gateway_name2: The second transit gateway name to make a peer pair.
        :param pulumi.Input[bool] enable_insane_mode_encryption_over_internet: (Optional) Advanced option. Enable Insane Mode Encryption over Internet. Transit gateways must be in Insane Mode.
               Currently, only inter-cloud connections between AWS and Azure are supported. Required with valid `tunnel_count`.
               Conflicts with `enable_peering_over_private_network` and `enable_single_tunnel_mode`. Type: Boolean. Default: false.
               Available as of provider version R2.19+.
        :param pulumi.Input[bool] enable_max_performance: Indicates whether the maximum amount of HPE tunnels will be created. Only valid when the two transit gateways are each
               launched in Insane Mode and in the same cloud type. Available as of provider version R2.22.2+.
        :param pulumi.Input[bool] enable_peering_over_private_network: (Optional) Advanced option. Enable peering over private network. Only appears and applies to when the two Multi-cloud
               Transit Gateways are each launched in Insane Mode and in a different cloud type. Conflicts with
               `enable_insane_mode_encryption_over_internet` and `tunnel_count`. Type: Boolean. Default: false. Available in provider
               version R2.17.1+
        :param pulumi.Input[bool] enable_single_tunnel_mode: (Optional) Advanced option. Enable peering with Single-Tunnel mode. Only appears and applies to when the two Multi-cloud
               Transit Gateways are each launched in Insane Mode and in a different cloud type. Required with
               `enable_peering_over_private_network`. Conflicts with `enable_insane_mode_encryption_over_internet` and `tunnel_count`.
               Type: Boolean. Default: false. Available as of provider version R2.18+.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gateway1_excluded_network_cidrs: List of excluded network CIDRs for the first transit gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gateway1_excluded_tgw_connections: List of excluded TGW connections for the first transit gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gateway2_excluded_network_cidrs: List of excluded network CIDRs for the second transit gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gateway2_excluded_tgw_connections: List of excluded TGW connections for the second transit gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prepend_as_path1s: AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on transit_gateway_name1.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prepend_as_path2s: AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on transit_gateway_name2.
        :param pulumi.Input[int] tunnel_count: (Optional) Advanced option. Number of public tunnels. Required with `enable_insane_mode_encryption_over_internet`.
               Conflicts with `enable_peering_over_private_network` and `enable_single_tunnel_mode`. Type: Integer. Valid Range: 2-20.
               Available as of provider version R2.19+.
        """
        pulumi.set(__self__, "transit_gateway_name1", transit_gateway_name1)
        pulumi.set(__self__, "transit_gateway_name2", transit_gateway_name2)
        if enable_insane_mode_encryption_over_internet is not None:
            pulumi.set(__self__, "enable_insane_mode_encryption_over_internet", enable_insane_mode_encryption_over_internet)
        if enable_max_performance is not None:
            pulumi.set(__self__, "enable_max_performance", enable_max_performance)
        if enable_peering_over_private_network is not None:
            pulumi.set(__self__, "enable_peering_over_private_network", enable_peering_over_private_network)
        if enable_single_tunnel_mode is not None:
            pulumi.set(__self__, "enable_single_tunnel_mode", enable_single_tunnel_mode)
        if gateway1_excluded_network_cidrs is not None:
            pulumi.set(__self__, "gateway1_excluded_network_cidrs", gateway1_excluded_network_cidrs)
        if gateway1_excluded_tgw_connections is not None:
            pulumi.set(__self__, "gateway1_excluded_tgw_connections", gateway1_excluded_tgw_connections)
        if gateway2_excluded_network_cidrs is not None:
            pulumi.set(__self__, "gateway2_excluded_network_cidrs", gateway2_excluded_network_cidrs)
        if gateway2_excluded_tgw_connections is not None:
            pulumi.set(__self__, "gateway2_excluded_tgw_connections", gateway2_excluded_tgw_connections)
        if prepend_as_path1s is not None:
            pulumi.set(__self__, "prepend_as_path1s", prepend_as_path1s)
        if prepend_as_path2s is not None:
            pulumi.set(__self__, "prepend_as_path2s", prepend_as_path2s)
        if tunnel_count is not None:
            pulumi.set(__self__, "tunnel_count", tunnel_count)

    @property
    @pulumi.getter(name="transitGatewayName1")
    def transit_gateway_name1(self) -> pulumi.Input[str]:
        """
        The first transit gateway name to make a peer pair.
        """
        return pulumi.get(self, "transit_gateway_name1")

    @transit_gateway_name1.setter
    def transit_gateway_name1(self, value: pulumi.Input[str]):
        pulumi.set(self, "transit_gateway_name1", value)

    @property
    @pulumi.getter(name="transitGatewayName2")
    def transit_gateway_name2(self) -> pulumi.Input[str]:
        """
        The second transit gateway name to make a peer pair.
        """
        return pulumi.get(self, "transit_gateway_name2")

    @transit_gateway_name2.setter
    def transit_gateway_name2(self, value: pulumi.Input[str]):
        pulumi.set(self, "transit_gateway_name2", value)

    @property
    @pulumi.getter(name="enableInsaneModeEncryptionOverInternet")
    def enable_insane_mode_encryption_over_internet(self) -> Optional[pulumi.Input[bool]]:
        """
        (Optional) Advanced option. Enable Insane Mode Encryption over Internet. Transit gateways must be in Insane Mode.
        Currently, only inter-cloud connections between AWS and Azure are supported. Required with valid `tunnel_count`.
        Conflicts with `enable_peering_over_private_network` and `enable_single_tunnel_mode`. Type: Boolean. Default: false.
        Available as of provider version R2.19+.
        """
        return pulumi.get(self, "enable_insane_mode_encryption_over_internet")

    @enable_insane_mode_encryption_over_internet.setter
    def enable_insane_mode_encryption_over_internet(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_insane_mode_encryption_over_internet", value)

    @property
    @pulumi.getter(name="enableMaxPerformance")
    def enable_max_performance(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the maximum amount of HPE tunnels will be created. Only valid when the two transit gateways are each
        launched in Insane Mode and in the same cloud type. Available as of provider version R2.22.2+.
        """
        return pulumi.get(self, "enable_max_performance")

    @enable_max_performance.setter
    def enable_max_performance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_max_performance", value)

    @property
    @pulumi.getter(name="enablePeeringOverPrivateNetwork")
    def enable_peering_over_private_network(self) -> Optional[pulumi.Input[bool]]:
        """
        (Optional) Advanced option. Enable peering over private network. Only appears and applies to when the two Multi-cloud
        Transit Gateways are each launched in Insane Mode and in a different cloud type. Conflicts with
        `enable_insane_mode_encryption_over_internet` and `tunnel_count`. Type: Boolean. Default: false. Available in provider
        version R2.17.1+
        """
        return pulumi.get(self, "enable_peering_over_private_network")

    @enable_peering_over_private_network.setter
    def enable_peering_over_private_network(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_peering_over_private_network", value)

    @property
    @pulumi.getter(name="enableSingleTunnelMode")
    def enable_single_tunnel_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        (Optional) Advanced option. Enable peering with Single-Tunnel mode. Only appears and applies to when the two Multi-cloud
        Transit Gateways are each launched in Insane Mode and in a different cloud type. Required with
        `enable_peering_over_private_network`. Conflicts with `enable_insane_mode_encryption_over_internet` and `tunnel_count`.
        Type: Boolean. Default: false. Available as of provider version R2.18+.
        """
        return pulumi.get(self, "enable_single_tunnel_mode")

    @enable_single_tunnel_mode.setter
    def enable_single_tunnel_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_single_tunnel_mode", value)

    @property
    @pulumi.getter(name="gateway1ExcludedNetworkCidrs")
    def gateway1_excluded_network_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of excluded network CIDRs for the first transit gateway.
        """
        return pulumi.get(self, "gateway1_excluded_network_cidrs")

    @gateway1_excluded_network_cidrs.setter
    def gateway1_excluded_network_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "gateway1_excluded_network_cidrs", value)

    @property
    @pulumi.getter(name="gateway1ExcludedTgwConnections")
    def gateway1_excluded_tgw_connections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of excluded TGW connections for the first transit gateway.
        """
        return pulumi.get(self, "gateway1_excluded_tgw_connections")

    @gateway1_excluded_tgw_connections.setter
    def gateway1_excluded_tgw_connections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "gateway1_excluded_tgw_connections", value)

    @property
    @pulumi.getter(name="gateway2ExcludedNetworkCidrs")
    def gateway2_excluded_network_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of excluded network CIDRs for the second transit gateway.
        """
        return pulumi.get(self, "gateway2_excluded_network_cidrs")

    @gateway2_excluded_network_cidrs.setter
    def gateway2_excluded_network_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "gateway2_excluded_network_cidrs", value)

    @property
    @pulumi.getter(name="gateway2ExcludedTgwConnections")
    def gateway2_excluded_tgw_connections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of excluded TGW connections for the second transit gateway.
        """
        return pulumi.get(self, "gateway2_excluded_tgw_connections")

    @gateway2_excluded_tgw_connections.setter
    def gateway2_excluded_tgw_connections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "gateway2_excluded_tgw_connections", value)

    @property
    @pulumi.getter(name="prependAsPath1s")
    def prepend_as_path1s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on transit_gateway_name1.
        """
        return pulumi.get(self, "prepend_as_path1s")

    @prepend_as_path1s.setter
    def prepend_as_path1s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "prepend_as_path1s", value)

    @property
    @pulumi.getter(name="prependAsPath2s")
    def prepend_as_path2s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on transit_gateway_name2.
        """
        return pulumi.get(self, "prepend_as_path2s")

    @prepend_as_path2s.setter
    def prepend_as_path2s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "prepend_as_path2s", value)

    @property
    @pulumi.getter(name="tunnelCount")
    def tunnel_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Optional) Advanced option. Number of public tunnels. Required with `enable_insane_mode_encryption_over_internet`.
        Conflicts with `enable_peering_over_private_network` and `enable_single_tunnel_mode`. Type: Integer. Valid Range: 2-20.
        Available as of provider version R2.19+.
        """
        return pulumi.get(self, "tunnel_count")

    @tunnel_count.setter
    def tunnel_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tunnel_count", value)


@pulumi.input_type
class _AviatrixTransitGatewayPeeringState:
    def __init__(__self__, *,
                 enable_insane_mode_encryption_over_internet: Optional[pulumi.Input[bool]] = None,
                 enable_max_performance: Optional[pulumi.Input[bool]] = None,
                 enable_peering_over_private_network: Optional[pulumi.Input[bool]] = None,
                 enable_single_tunnel_mode: Optional[pulumi.Input[bool]] = None,
                 gateway1_excluded_network_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 gateway1_excluded_tgw_connections: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 gateway2_excluded_network_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 gateway2_excluded_tgw_connections: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 prepend_as_path1s: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 prepend_as_path2s: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 transit_gateway_name1: Optional[pulumi.Input[str]] = None,
                 transit_gateway_name2: Optional[pulumi.Input[str]] = None,
                 tunnel_count: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering AviatrixTransitGatewayPeering resources.
        :param pulumi.Input[bool] enable_insane_mode_encryption_over_internet: (Optional) Advanced option. Enable Insane Mode Encryption over Internet. Transit gateways must be in Insane Mode.
               Currently, only inter-cloud connections between AWS and Azure are supported. Required with valid `tunnel_count`.
               Conflicts with `enable_peering_over_private_network` and `enable_single_tunnel_mode`. Type: Boolean. Default: false.
               Available as of provider version R2.19+.
        :param pulumi.Input[bool] enable_max_performance: Indicates whether the maximum amount of HPE tunnels will be created. Only valid when the two transit gateways are each
               launched in Insane Mode and in the same cloud type. Available as of provider version R2.22.2+.
        :param pulumi.Input[bool] enable_peering_over_private_network: (Optional) Advanced option. Enable peering over private network. Only appears and applies to when the two Multi-cloud
               Transit Gateways are each launched in Insane Mode and in a different cloud type. Conflicts with
               `enable_insane_mode_encryption_over_internet` and `tunnel_count`. Type: Boolean. Default: false. Available in provider
               version R2.17.1+
        :param pulumi.Input[bool] enable_single_tunnel_mode: (Optional) Advanced option. Enable peering with Single-Tunnel mode. Only appears and applies to when the two Multi-cloud
               Transit Gateways are each launched in Insane Mode and in a different cloud type. Required with
               `enable_peering_over_private_network`. Conflicts with `enable_insane_mode_encryption_over_internet` and `tunnel_count`.
               Type: Boolean. Default: false. Available as of provider version R2.18+.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gateway1_excluded_network_cidrs: List of excluded network CIDRs for the first transit gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gateway1_excluded_tgw_connections: List of excluded TGW connections for the first transit gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gateway2_excluded_network_cidrs: List of excluded network CIDRs for the second transit gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gateway2_excluded_tgw_connections: List of excluded TGW connections for the second transit gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prepend_as_path1s: AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on transit_gateway_name1.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prepend_as_path2s: AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on transit_gateway_name2.
        :param pulumi.Input[str] transit_gateway_name1: The first transit gateway name to make a peer pair.
        :param pulumi.Input[str] transit_gateway_name2: The second transit gateway name to make a peer pair.
        :param pulumi.Input[int] tunnel_count: (Optional) Advanced option. Number of public tunnels. Required with `enable_insane_mode_encryption_over_internet`.
               Conflicts with `enable_peering_over_private_network` and `enable_single_tunnel_mode`. Type: Integer. Valid Range: 2-20.
               Available as of provider version R2.19+.
        """
        if enable_insane_mode_encryption_over_internet is not None:
            pulumi.set(__self__, "enable_insane_mode_encryption_over_internet", enable_insane_mode_encryption_over_internet)
        if enable_max_performance is not None:
            pulumi.set(__self__, "enable_max_performance", enable_max_performance)
        if enable_peering_over_private_network is not None:
            pulumi.set(__self__, "enable_peering_over_private_network", enable_peering_over_private_network)
        if enable_single_tunnel_mode is not None:
            pulumi.set(__self__, "enable_single_tunnel_mode", enable_single_tunnel_mode)
        if gateway1_excluded_network_cidrs is not None:
            pulumi.set(__self__, "gateway1_excluded_network_cidrs", gateway1_excluded_network_cidrs)
        if gateway1_excluded_tgw_connections is not None:
            pulumi.set(__self__, "gateway1_excluded_tgw_connections", gateway1_excluded_tgw_connections)
        if gateway2_excluded_network_cidrs is not None:
            pulumi.set(__self__, "gateway2_excluded_network_cidrs", gateway2_excluded_network_cidrs)
        if gateway2_excluded_tgw_connections is not None:
            pulumi.set(__self__, "gateway2_excluded_tgw_connections", gateway2_excluded_tgw_connections)
        if prepend_as_path1s is not None:
            pulumi.set(__self__, "prepend_as_path1s", prepend_as_path1s)
        if prepend_as_path2s is not None:
            pulumi.set(__self__, "prepend_as_path2s", prepend_as_path2s)
        if transit_gateway_name1 is not None:
            pulumi.set(__self__, "transit_gateway_name1", transit_gateway_name1)
        if transit_gateway_name2 is not None:
            pulumi.set(__self__, "transit_gateway_name2", transit_gateway_name2)
        if tunnel_count is not None:
            pulumi.set(__self__, "tunnel_count", tunnel_count)

    @property
    @pulumi.getter(name="enableInsaneModeEncryptionOverInternet")
    def enable_insane_mode_encryption_over_internet(self) -> Optional[pulumi.Input[bool]]:
        """
        (Optional) Advanced option. Enable Insane Mode Encryption over Internet. Transit gateways must be in Insane Mode.
        Currently, only inter-cloud connections between AWS and Azure are supported. Required with valid `tunnel_count`.
        Conflicts with `enable_peering_over_private_network` and `enable_single_tunnel_mode`. Type: Boolean. Default: false.
        Available as of provider version R2.19+.
        """
        return pulumi.get(self, "enable_insane_mode_encryption_over_internet")

    @enable_insane_mode_encryption_over_internet.setter
    def enable_insane_mode_encryption_over_internet(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_insane_mode_encryption_over_internet", value)

    @property
    @pulumi.getter(name="enableMaxPerformance")
    def enable_max_performance(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the maximum amount of HPE tunnels will be created. Only valid when the two transit gateways are each
        launched in Insane Mode and in the same cloud type. Available as of provider version R2.22.2+.
        """
        return pulumi.get(self, "enable_max_performance")

    @enable_max_performance.setter
    def enable_max_performance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_max_performance", value)

    @property
    @pulumi.getter(name="enablePeeringOverPrivateNetwork")
    def enable_peering_over_private_network(self) -> Optional[pulumi.Input[bool]]:
        """
        (Optional) Advanced option. Enable peering over private network. Only appears and applies to when the two Multi-cloud
        Transit Gateways are each launched in Insane Mode and in a different cloud type. Conflicts with
        `enable_insane_mode_encryption_over_internet` and `tunnel_count`. Type: Boolean. Default: false. Available in provider
        version R2.17.1+
        """
        return pulumi.get(self, "enable_peering_over_private_network")

    @enable_peering_over_private_network.setter
    def enable_peering_over_private_network(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_peering_over_private_network", value)

    @property
    @pulumi.getter(name="enableSingleTunnelMode")
    def enable_single_tunnel_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        (Optional) Advanced option. Enable peering with Single-Tunnel mode. Only appears and applies to when the two Multi-cloud
        Transit Gateways are each launched in Insane Mode and in a different cloud type. Required with
        `enable_peering_over_private_network`. Conflicts with `enable_insane_mode_encryption_over_internet` and `tunnel_count`.
        Type: Boolean. Default: false. Available as of provider version R2.18+.
        """
        return pulumi.get(self, "enable_single_tunnel_mode")

    @enable_single_tunnel_mode.setter
    def enable_single_tunnel_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_single_tunnel_mode", value)

    @property
    @pulumi.getter(name="gateway1ExcludedNetworkCidrs")
    def gateway1_excluded_network_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of excluded network CIDRs for the first transit gateway.
        """
        return pulumi.get(self, "gateway1_excluded_network_cidrs")

    @gateway1_excluded_network_cidrs.setter
    def gateway1_excluded_network_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "gateway1_excluded_network_cidrs", value)

    @property
    @pulumi.getter(name="gateway1ExcludedTgwConnections")
    def gateway1_excluded_tgw_connections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of excluded TGW connections for the first transit gateway.
        """
        return pulumi.get(self, "gateway1_excluded_tgw_connections")

    @gateway1_excluded_tgw_connections.setter
    def gateway1_excluded_tgw_connections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "gateway1_excluded_tgw_connections", value)

    @property
    @pulumi.getter(name="gateway2ExcludedNetworkCidrs")
    def gateway2_excluded_network_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of excluded network CIDRs for the second transit gateway.
        """
        return pulumi.get(self, "gateway2_excluded_network_cidrs")

    @gateway2_excluded_network_cidrs.setter
    def gateway2_excluded_network_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "gateway2_excluded_network_cidrs", value)

    @property
    @pulumi.getter(name="gateway2ExcludedTgwConnections")
    def gateway2_excluded_tgw_connections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of excluded TGW connections for the second transit gateway.
        """
        return pulumi.get(self, "gateway2_excluded_tgw_connections")

    @gateway2_excluded_tgw_connections.setter
    def gateway2_excluded_tgw_connections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "gateway2_excluded_tgw_connections", value)

    @property
    @pulumi.getter(name="prependAsPath1s")
    def prepend_as_path1s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on transit_gateway_name1.
        """
        return pulumi.get(self, "prepend_as_path1s")

    @prepend_as_path1s.setter
    def prepend_as_path1s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "prepend_as_path1s", value)

    @property
    @pulumi.getter(name="prependAsPath2s")
    def prepend_as_path2s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on transit_gateway_name2.
        """
        return pulumi.get(self, "prepend_as_path2s")

    @prepend_as_path2s.setter
    def prepend_as_path2s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "prepend_as_path2s", value)

    @property
    @pulumi.getter(name="transitGatewayName1")
    def transit_gateway_name1(self) -> Optional[pulumi.Input[str]]:
        """
        The first transit gateway name to make a peer pair.
        """
        return pulumi.get(self, "transit_gateway_name1")

    @transit_gateway_name1.setter
    def transit_gateway_name1(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_gateway_name1", value)

    @property
    @pulumi.getter(name="transitGatewayName2")
    def transit_gateway_name2(self) -> Optional[pulumi.Input[str]]:
        """
        The second transit gateway name to make a peer pair.
        """
        return pulumi.get(self, "transit_gateway_name2")

    @transit_gateway_name2.setter
    def transit_gateway_name2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_gateway_name2", value)

    @property
    @pulumi.getter(name="tunnelCount")
    def tunnel_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Optional) Advanced option. Number of public tunnels. Required with `enable_insane_mode_encryption_over_internet`.
        Conflicts with `enable_peering_over_private_network` and `enable_single_tunnel_mode`. Type: Integer. Valid Range: 2-20.
        Available as of provider version R2.19+.
        """
        return pulumi.get(self, "tunnel_count")

    @tunnel_count.setter
    def tunnel_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tunnel_count", value)


class AviatrixTransitGatewayPeering(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_insane_mode_encryption_over_internet: Optional[pulumi.Input[bool]] = None,
                 enable_max_performance: Optional[pulumi.Input[bool]] = None,
                 enable_peering_over_private_network: Optional[pulumi.Input[bool]] = None,
                 enable_single_tunnel_mode: Optional[pulumi.Input[bool]] = None,
                 gateway1_excluded_network_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 gateway1_excluded_tgw_connections: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 gateway2_excluded_network_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 gateway2_excluded_tgw_connections: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 prepend_as_path1s: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 prepend_as_path2s: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 transit_gateway_name1: Optional[pulumi.Input[str]] = None,
                 transit_gateway_name2: Optional[pulumi.Input[str]] = None,
                 tunnel_count: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Create a AviatrixTransitGatewayPeering resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enable_insane_mode_encryption_over_internet: (Optional) Advanced option. Enable Insane Mode Encryption over Internet. Transit gateways must be in Insane Mode.
               Currently, only inter-cloud connections between AWS and Azure are supported. Required with valid `tunnel_count`.
               Conflicts with `enable_peering_over_private_network` and `enable_single_tunnel_mode`. Type: Boolean. Default: false.
               Available as of provider version R2.19+.
        :param pulumi.Input[bool] enable_max_performance: Indicates whether the maximum amount of HPE tunnels will be created. Only valid when the two transit gateways are each
               launched in Insane Mode and in the same cloud type. Available as of provider version R2.22.2+.
        :param pulumi.Input[bool] enable_peering_over_private_network: (Optional) Advanced option. Enable peering over private network. Only appears and applies to when the two Multi-cloud
               Transit Gateways are each launched in Insane Mode and in a different cloud type. Conflicts with
               `enable_insane_mode_encryption_over_internet` and `tunnel_count`. Type: Boolean. Default: false. Available in provider
               version R2.17.1+
        :param pulumi.Input[bool] enable_single_tunnel_mode: (Optional) Advanced option. Enable peering with Single-Tunnel mode. Only appears and applies to when the two Multi-cloud
               Transit Gateways are each launched in Insane Mode and in a different cloud type. Required with
               `enable_peering_over_private_network`. Conflicts with `enable_insane_mode_encryption_over_internet` and `tunnel_count`.
               Type: Boolean. Default: false. Available as of provider version R2.18+.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gateway1_excluded_network_cidrs: List of excluded network CIDRs for the first transit gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gateway1_excluded_tgw_connections: List of excluded TGW connections for the first transit gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gateway2_excluded_network_cidrs: List of excluded network CIDRs for the second transit gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gateway2_excluded_tgw_connections: List of excluded TGW connections for the second transit gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prepend_as_path1s: AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on transit_gateway_name1.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prepend_as_path2s: AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on transit_gateway_name2.
        :param pulumi.Input[str] transit_gateway_name1: The first transit gateway name to make a peer pair.
        :param pulumi.Input[str] transit_gateway_name2: The second transit gateway name to make a peer pair.
        :param pulumi.Input[int] tunnel_count: (Optional) Advanced option. Number of public tunnels. Required with `enable_insane_mode_encryption_over_internet`.
               Conflicts with `enable_peering_over_private_network` and `enable_single_tunnel_mode`. Type: Integer. Valid Range: 2-20.
               Available as of provider version R2.19+.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixTransitGatewayPeeringArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AviatrixTransitGatewayPeering resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AviatrixTransitGatewayPeeringArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixTransitGatewayPeeringArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_insane_mode_encryption_over_internet: Optional[pulumi.Input[bool]] = None,
                 enable_max_performance: Optional[pulumi.Input[bool]] = None,
                 enable_peering_over_private_network: Optional[pulumi.Input[bool]] = None,
                 enable_single_tunnel_mode: Optional[pulumi.Input[bool]] = None,
                 gateway1_excluded_network_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 gateway1_excluded_tgw_connections: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 gateway2_excluded_network_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 gateway2_excluded_tgw_connections: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 prepend_as_path1s: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 prepend_as_path2s: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 transit_gateway_name1: Optional[pulumi.Input[str]] = None,
                 transit_gateway_name2: Optional[pulumi.Input[str]] = None,
                 tunnel_count: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixTransitGatewayPeeringArgs.__new__(AviatrixTransitGatewayPeeringArgs)

            __props__.__dict__["enable_insane_mode_encryption_over_internet"] = enable_insane_mode_encryption_over_internet
            __props__.__dict__["enable_max_performance"] = enable_max_performance
            __props__.__dict__["enable_peering_over_private_network"] = enable_peering_over_private_network
            __props__.__dict__["enable_single_tunnel_mode"] = enable_single_tunnel_mode
            __props__.__dict__["gateway1_excluded_network_cidrs"] = gateway1_excluded_network_cidrs
            __props__.__dict__["gateway1_excluded_tgw_connections"] = gateway1_excluded_tgw_connections
            __props__.__dict__["gateway2_excluded_network_cidrs"] = gateway2_excluded_network_cidrs
            __props__.__dict__["gateway2_excluded_tgw_connections"] = gateway2_excluded_tgw_connections
            __props__.__dict__["prepend_as_path1s"] = prepend_as_path1s
            __props__.__dict__["prepend_as_path2s"] = prepend_as_path2s
            if transit_gateway_name1 is None and not opts.urn:
                raise TypeError("Missing required property 'transit_gateway_name1'")
            __props__.__dict__["transit_gateway_name1"] = transit_gateway_name1
            if transit_gateway_name2 is None and not opts.urn:
                raise TypeError("Missing required property 'transit_gateway_name2'")
            __props__.__dict__["transit_gateway_name2"] = transit_gateway_name2
            __props__.__dict__["tunnel_count"] = tunnel_count
        super(AviatrixTransitGatewayPeering, __self__).__init__(
            'aviatrix:index/aviatrixTransitGatewayPeering:AviatrixTransitGatewayPeering',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enable_insane_mode_encryption_over_internet: Optional[pulumi.Input[bool]] = None,
            enable_max_performance: Optional[pulumi.Input[bool]] = None,
            enable_peering_over_private_network: Optional[pulumi.Input[bool]] = None,
            enable_single_tunnel_mode: Optional[pulumi.Input[bool]] = None,
            gateway1_excluded_network_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            gateway1_excluded_tgw_connections: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            gateway2_excluded_network_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            gateway2_excluded_tgw_connections: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            prepend_as_path1s: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            prepend_as_path2s: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            transit_gateway_name1: Optional[pulumi.Input[str]] = None,
            transit_gateway_name2: Optional[pulumi.Input[str]] = None,
            tunnel_count: Optional[pulumi.Input[int]] = None) -> 'AviatrixTransitGatewayPeering':
        """
        Get an existing AviatrixTransitGatewayPeering resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enable_insane_mode_encryption_over_internet: (Optional) Advanced option. Enable Insane Mode Encryption over Internet. Transit gateways must be in Insane Mode.
               Currently, only inter-cloud connections between AWS and Azure are supported. Required with valid `tunnel_count`.
               Conflicts with `enable_peering_over_private_network` and `enable_single_tunnel_mode`. Type: Boolean. Default: false.
               Available as of provider version R2.19+.
        :param pulumi.Input[bool] enable_max_performance: Indicates whether the maximum amount of HPE tunnels will be created. Only valid when the two transit gateways are each
               launched in Insane Mode and in the same cloud type. Available as of provider version R2.22.2+.
        :param pulumi.Input[bool] enable_peering_over_private_network: (Optional) Advanced option. Enable peering over private network. Only appears and applies to when the two Multi-cloud
               Transit Gateways are each launched in Insane Mode and in a different cloud type. Conflicts with
               `enable_insane_mode_encryption_over_internet` and `tunnel_count`. Type: Boolean. Default: false. Available in provider
               version R2.17.1+
        :param pulumi.Input[bool] enable_single_tunnel_mode: (Optional) Advanced option. Enable peering with Single-Tunnel mode. Only appears and applies to when the two Multi-cloud
               Transit Gateways are each launched in Insane Mode and in a different cloud type. Required with
               `enable_peering_over_private_network`. Conflicts with `enable_insane_mode_encryption_over_internet` and `tunnel_count`.
               Type: Boolean. Default: false. Available as of provider version R2.18+.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gateway1_excluded_network_cidrs: List of excluded network CIDRs for the first transit gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gateway1_excluded_tgw_connections: List of excluded TGW connections for the first transit gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gateway2_excluded_network_cidrs: List of excluded network CIDRs for the second transit gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gateway2_excluded_tgw_connections: List of excluded TGW connections for the second transit gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prepend_as_path1s: AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on transit_gateway_name1.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prepend_as_path2s: AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on transit_gateway_name2.
        :param pulumi.Input[str] transit_gateway_name1: The first transit gateway name to make a peer pair.
        :param pulumi.Input[str] transit_gateway_name2: The second transit gateway name to make a peer pair.
        :param pulumi.Input[int] tunnel_count: (Optional) Advanced option. Number of public tunnels. Required with `enable_insane_mode_encryption_over_internet`.
               Conflicts with `enable_peering_over_private_network` and `enable_single_tunnel_mode`. Type: Integer. Valid Range: 2-20.
               Available as of provider version R2.19+.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixTransitGatewayPeeringState.__new__(_AviatrixTransitGatewayPeeringState)

        __props__.__dict__["enable_insane_mode_encryption_over_internet"] = enable_insane_mode_encryption_over_internet
        __props__.__dict__["enable_max_performance"] = enable_max_performance
        __props__.__dict__["enable_peering_over_private_network"] = enable_peering_over_private_network
        __props__.__dict__["enable_single_tunnel_mode"] = enable_single_tunnel_mode
        __props__.__dict__["gateway1_excluded_network_cidrs"] = gateway1_excluded_network_cidrs
        __props__.__dict__["gateway1_excluded_tgw_connections"] = gateway1_excluded_tgw_connections
        __props__.__dict__["gateway2_excluded_network_cidrs"] = gateway2_excluded_network_cidrs
        __props__.__dict__["gateway2_excluded_tgw_connections"] = gateway2_excluded_tgw_connections
        __props__.__dict__["prepend_as_path1s"] = prepend_as_path1s
        __props__.__dict__["prepend_as_path2s"] = prepend_as_path2s
        __props__.__dict__["transit_gateway_name1"] = transit_gateway_name1
        __props__.__dict__["transit_gateway_name2"] = transit_gateway_name2
        __props__.__dict__["tunnel_count"] = tunnel_count
        return AviatrixTransitGatewayPeering(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="enableInsaneModeEncryptionOverInternet")
    def enable_insane_mode_encryption_over_internet(self) -> pulumi.Output[Optional[bool]]:
        """
        (Optional) Advanced option. Enable Insane Mode Encryption over Internet. Transit gateways must be in Insane Mode.
        Currently, only inter-cloud connections between AWS and Azure are supported. Required with valid `tunnel_count`.
        Conflicts with `enable_peering_over_private_network` and `enable_single_tunnel_mode`. Type: Boolean. Default: false.
        Available as of provider version R2.19+.
        """
        return pulumi.get(self, "enable_insane_mode_encryption_over_internet")

    @property
    @pulumi.getter(name="enableMaxPerformance")
    def enable_max_performance(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether the maximum amount of HPE tunnels will be created. Only valid when the two transit gateways are each
        launched in Insane Mode and in the same cloud type. Available as of provider version R2.22.2+.
        """
        return pulumi.get(self, "enable_max_performance")

    @property
    @pulumi.getter(name="enablePeeringOverPrivateNetwork")
    def enable_peering_over_private_network(self) -> pulumi.Output[Optional[bool]]:
        """
        (Optional) Advanced option. Enable peering over private network. Only appears and applies to when the two Multi-cloud
        Transit Gateways are each launched in Insane Mode and in a different cloud type. Conflicts with
        `enable_insane_mode_encryption_over_internet` and `tunnel_count`. Type: Boolean. Default: false. Available in provider
        version R2.17.1+
        """
        return pulumi.get(self, "enable_peering_over_private_network")

    @property
    @pulumi.getter(name="enableSingleTunnelMode")
    def enable_single_tunnel_mode(self) -> pulumi.Output[Optional[bool]]:
        """
        (Optional) Advanced option. Enable peering with Single-Tunnel mode. Only appears and applies to when the two Multi-cloud
        Transit Gateways are each launched in Insane Mode and in a different cloud type. Required with
        `enable_peering_over_private_network`. Conflicts with `enable_insane_mode_encryption_over_internet` and `tunnel_count`.
        Type: Boolean. Default: false. Available as of provider version R2.18+.
        """
        return pulumi.get(self, "enable_single_tunnel_mode")

    @property
    @pulumi.getter(name="gateway1ExcludedNetworkCidrs")
    def gateway1_excluded_network_cidrs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of excluded network CIDRs for the first transit gateway.
        """
        return pulumi.get(self, "gateway1_excluded_network_cidrs")

    @property
    @pulumi.getter(name="gateway1ExcludedTgwConnections")
    def gateway1_excluded_tgw_connections(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of excluded TGW connections for the first transit gateway.
        """
        return pulumi.get(self, "gateway1_excluded_tgw_connections")

    @property
    @pulumi.getter(name="gateway2ExcludedNetworkCidrs")
    def gateway2_excluded_network_cidrs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of excluded network CIDRs for the second transit gateway.
        """
        return pulumi.get(self, "gateway2_excluded_network_cidrs")

    @property
    @pulumi.getter(name="gateway2ExcludedTgwConnections")
    def gateway2_excluded_tgw_connections(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of excluded TGW connections for the second transit gateway.
        """
        return pulumi.get(self, "gateway2_excluded_tgw_connections")

    @property
    @pulumi.getter(name="prependAsPath1s")
    def prepend_as_path1s(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on transit_gateway_name1.
        """
        return pulumi.get(self, "prepend_as_path1s")

    @property
    @pulumi.getter(name="prependAsPath2s")
    def prepend_as_path2s(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on transit_gateway_name2.
        """
        return pulumi.get(self, "prepend_as_path2s")

    @property
    @pulumi.getter(name="transitGatewayName1")
    def transit_gateway_name1(self) -> pulumi.Output[str]:
        """
        The first transit gateway name to make a peer pair.
        """
        return pulumi.get(self, "transit_gateway_name1")

    @property
    @pulumi.getter(name="transitGatewayName2")
    def transit_gateway_name2(self) -> pulumi.Output[str]:
        """
        The second transit gateway name to make a peer pair.
        """
        return pulumi.get(self, "transit_gateway_name2")

    @property
    @pulumi.getter(name="tunnelCount")
    def tunnel_count(self) -> pulumi.Output[Optional[int]]:
        """
        (Optional) Advanced option. Number of public tunnels. Required with `enable_insane_mode_encryption_over_internet`.
        Conflicts with `enable_peering_over_private_network` and `enable_single_tunnel_mode`. Type: Integer. Valid Range: 2-20.
        Available as of provider version R2.19+.
        """
        return pulumi.get(self, "tunnel_count")

