# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixSpokeVpcArgs', 'AviatrixSpokeVpc']

@pulumi.input_type
class AviatrixSpokeVpcArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[str],
                 cloud_type: pulumi.Input[int],
                 gw_name: pulumi.Input[str],
                 subnet: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 vpc_reg: pulumi.Input[str],
                 vpc_size: pulumi.Input[str],
                 enable_nat: Optional[pulumi.Input[str]] = None,
                 ha_gw_size: Optional[pulumi.Input[str]] = None,
                 ha_subnet: Optional[pulumi.Input[str]] = None,
                 ha_zone: Optional[pulumi.Input[str]] = None,
                 single_az_ha: Optional[pulumi.Input[str]] = None,
                 tag_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 transit_gw: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AviatrixSpokeVpc resource.
        :param pulumi.Input[str] account_name: This parameter represents the name of a Cloud-Account in Aviatrix controller.
        :param pulumi.Input[int] cloud_type: Type of cloud service provider.
        :param pulumi.Input[str] gw_name: Name of the gateway which is going to be created.
        :param pulumi.Input[str] subnet: Public Subnet Info.
        :param pulumi.Input[str] vpc_id: VPC-ID/VNet-Name of cloud provider.
        :param pulumi.Input[str] vpc_reg: Region of cloud provider.
        :param pulumi.Input[str] vpc_size: Size of the gateway instance.
        :param pulumi.Input[str] enable_nat: Specify whether enabling NAT feature on the gateway or not.
        :param pulumi.Input[str] ha_gw_size: HA Gateway Size.
        :param pulumi.Input[str] ha_subnet: HA Subnet. Required if enabling HA for AWS/Azure.
        :param pulumi.Input[str] ha_zone: HA Zone. Required if enabling HA for GCP.
        :param pulumi.Input[str] single_az_ha: Set to 'enabled' if this feature is desired.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tag_lists: Instance tag of cloud provider.
        :param pulumi.Input[str] transit_gw: Specify the transit Gateway.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "cloud_type", cloud_type)
        pulumi.set(__self__, "gw_name", gw_name)
        pulumi.set(__self__, "subnet", subnet)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vpc_reg", vpc_reg)
        pulumi.set(__self__, "vpc_size", vpc_size)
        if enable_nat is not None:
            pulumi.set(__self__, "enable_nat", enable_nat)
        if ha_gw_size is not None:
            pulumi.set(__self__, "ha_gw_size", ha_gw_size)
        if ha_subnet is not None:
            pulumi.set(__self__, "ha_subnet", ha_subnet)
        if ha_zone is not None:
            pulumi.set(__self__, "ha_zone", ha_zone)
        if single_az_ha is not None:
            pulumi.set(__self__, "single_az_ha", single_az_ha)
        if tag_lists is not None:
            pulumi.set(__self__, "tag_lists", tag_lists)
        if transit_gw is not None:
            pulumi.set(__self__, "transit_gw", transit_gw)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[str]:
        """
        This parameter represents the name of a Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> pulumi.Input[int]:
        """
        Type of cloud service provider.
        """
        return pulumi.get(self, "cloud_type")

    @cloud_type.setter
    def cloud_type(self, value: pulumi.Input[int]):
        pulumi.set(self, "cloud_type", value)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> pulumi.Input[str]:
        """
        Name of the gateway which is going to be created.
        """
        return pulumi.get(self, "gw_name")

    @gw_name.setter
    def gw_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "gw_name", value)

    @property
    @pulumi.getter
    def subnet(self) -> pulumi.Input[str]:
        """
        Public Subnet Info.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        VPC-ID/VNet-Name of cloud provider.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vpcReg")
    def vpc_reg(self) -> pulumi.Input[str]:
        """
        Region of cloud provider.
        """
        return pulumi.get(self, "vpc_reg")

    @vpc_reg.setter
    def vpc_reg(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_reg", value)

    @property
    @pulumi.getter(name="vpcSize")
    def vpc_size(self) -> pulumi.Input[str]:
        """
        Size of the gateway instance.
        """
        return pulumi.get(self, "vpc_size")

    @vpc_size.setter
    def vpc_size(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_size", value)

    @property
    @pulumi.getter(name="enableNat")
    def enable_nat(self) -> Optional[pulumi.Input[str]]:
        """
        Specify whether enabling NAT feature on the gateway or not.
        """
        return pulumi.get(self, "enable_nat")

    @enable_nat.setter
    def enable_nat(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enable_nat", value)

    @property
    @pulumi.getter(name="haGwSize")
    def ha_gw_size(self) -> Optional[pulumi.Input[str]]:
        """
        HA Gateway Size.
        """
        return pulumi.get(self, "ha_gw_size")

    @ha_gw_size.setter
    def ha_gw_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_gw_size", value)

    @property
    @pulumi.getter(name="haSubnet")
    def ha_subnet(self) -> Optional[pulumi.Input[str]]:
        """
        HA Subnet. Required if enabling HA for AWS/Azure.
        """
        return pulumi.get(self, "ha_subnet")

    @ha_subnet.setter
    def ha_subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_subnet", value)

    @property
    @pulumi.getter(name="haZone")
    def ha_zone(self) -> Optional[pulumi.Input[str]]:
        """
        HA Zone. Required if enabling HA for GCP.
        """
        return pulumi.get(self, "ha_zone")

    @ha_zone.setter
    def ha_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_zone", value)

    @property
    @pulumi.getter(name="singleAzHa")
    def single_az_ha(self) -> Optional[pulumi.Input[str]]:
        """
        Set to 'enabled' if this feature is desired.
        """
        return pulumi.get(self, "single_az_ha")

    @single_az_ha.setter
    def single_az_ha(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "single_az_ha", value)

    @property
    @pulumi.getter(name="tagLists")
    def tag_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Instance tag of cloud provider.
        """
        return pulumi.get(self, "tag_lists")

    @tag_lists.setter
    def tag_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tag_lists", value)

    @property
    @pulumi.getter(name="transitGw")
    def transit_gw(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the transit Gateway.
        """
        return pulumi.get(self, "transit_gw")

    @transit_gw.setter
    def transit_gw(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_gw", value)


@pulumi.input_type
class _AviatrixSpokeVpcState:
    def __init__(__self__, *,
                 account_name: Optional[pulumi.Input[str]] = None,
                 cloud_instance_id: Optional[pulumi.Input[str]] = None,
                 cloud_type: Optional[pulumi.Input[int]] = None,
                 enable_nat: Optional[pulumi.Input[str]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 ha_gw_size: Optional[pulumi.Input[str]] = None,
                 ha_subnet: Optional[pulumi.Input[str]] = None,
                 ha_zone: Optional[pulumi.Input[str]] = None,
                 single_az_ha: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 tag_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 transit_gw: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vpc_reg: Optional[pulumi.Input[str]] = None,
                 vpc_size: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixSpokeVpc resources.
        :param pulumi.Input[str] account_name: This parameter represents the name of a Cloud-Account in Aviatrix controller.
        :param pulumi.Input[str] cloud_instance_id: Cloud instance ID.
        :param pulumi.Input[int] cloud_type: Type of cloud service provider.
        :param pulumi.Input[str] enable_nat: Specify whether enabling NAT feature on the gateway or not.
        :param pulumi.Input[str] gw_name: Name of the gateway which is going to be created.
        :param pulumi.Input[str] ha_gw_size: HA Gateway Size.
        :param pulumi.Input[str] ha_subnet: HA Subnet. Required if enabling HA for AWS/Azure.
        :param pulumi.Input[str] ha_zone: HA Zone. Required if enabling HA for GCP.
        :param pulumi.Input[str] single_az_ha: Set to 'enabled' if this feature is desired.
        :param pulumi.Input[str] subnet: Public Subnet Info.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tag_lists: Instance tag of cloud provider.
        :param pulumi.Input[str] transit_gw: Specify the transit Gateway.
        :param pulumi.Input[str] vpc_id: VPC-ID/VNet-Name of cloud provider.
        :param pulumi.Input[str] vpc_reg: Region of cloud provider.
        :param pulumi.Input[str] vpc_size: Size of the gateway instance.
        """
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if cloud_instance_id is not None:
            pulumi.set(__self__, "cloud_instance_id", cloud_instance_id)
        if cloud_type is not None:
            pulumi.set(__self__, "cloud_type", cloud_type)
        if enable_nat is not None:
            pulumi.set(__self__, "enable_nat", enable_nat)
        if gw_name is not None:
            pulumi.set(__self__, "gw_name", gw_name)
        if ha_gw_size is not None:
            pulumi.set(__self__, "ha_gw_size", ha_gw_size)
        if ha_subnet is not None:
            pulumi.set(__self__, "ha_subnet", ha_subnet)
        if ha_zone is not None:
            pulumi.set(__self__, "ha_zone", ha_zone)
        if single_az_ha is not None:
            pulumi.set(__self__, "single_az_ha", single_az_ha)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if tag_lists is not None:
            pulumi.set(__self__, "tag_lists", tag_lists)
        if transit_gw is not None:
            pulumi.set(__self__, "transit_gw", transit_gw)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vpc_reg is not None:
            pulumi.set(__self__, "vpc_reg", vpc_reg)
        if vpc_size is not None:
            pulumi.set(__self__, "vpc_size", vpc_size)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter represents the name of a Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="cloudInstanceId")
    def cloud_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud instance ID.
        """
        return pulumi.get(self, "cloud_instance_id")

    @cloud_instance_id.setter
    def cloud_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_instance_id", value)

    @property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> Optional[pulumi.Input[int]]:
        """
        Type of cloud service provider.
        """
        return pulumi.get(self, "cloud_type")

    @cloud_type.setter
    def cloud_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cloud_type", value)

    @property
    @pulumi.getter(name="enableNat")
    def enable_nat(self) -> Optional[pulumi.Input[str]]:
        """
        Specify whether enabling NAT feature on the gateway or not.
        """
        return pulumi.get(self, "enable_nat")

    @enable_nat.setter
    def enable_nat(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enable_nat", value)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the gateway which is going to be created.
        """
        return pulumi.get(self, "gw_name")

    @gw_name.setter
    def gw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gw_name", value)

    @property
    @pulumi.getter(name="haGwSize")
    def ha_gw_size(self) -> Optional[pulumi.Input[str]]:
        """
        HA Gateway Size.
        """
        return pulumi.get(self, "ha_gw_size")

    @ha_gw_size.setter
    def ha_gw_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_gw_size", value)

    @property
    @pulumi.getter(name="haSubnet")
    def ha_subnet(self) -> Optional[pulumi.Input[str]]:
        """
        HA Subnet. Required if enabling HA for AWS/Azure.
        """
        return pulumi.get(self, "ha_subnet")

    @ha_subnet.setter
    def ha_subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_subnet", value)

    @property
    @pulumi.getter(name="haZone")
    def ha_zone(self) -> Optional[pulumi.Input[str]]:
        """
        HA Zone. Required if enabling HA for GCP.
        """
        return pulumi.get(self, "ha_zone")

    @ha_zone.setter
    def ha_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_zone", value)

    @property
    @pulumi.getter(name="singleAzHa")
    def single_az_ha(self) -> Optional[pulumi.Input[str]]:
        """
        Set to 'enabled' if this feature is desired.
        """
        return pulumi.get(self, "single_az_ha")

    @single_az_ha.setter
    def single_az_ha(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "single_az_ha", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[str]]:
        """
        Public Subnet Info.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter(name="tagLists")
    def tag_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Instance tag of cloud provider.
        """
        return pulumi.get(self, "tag_lists")

    @tag_lists.setter
    def tag_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tag_lists", value)

    @property
    @pulumi.getter(name="transitGw")
    def transit_gw(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the transit Gateway.
        """
        return pulumi.get(self, "transit_gw")

    @transit_gw.setter
    def transit_gw(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_gw", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        VPC-ID/VNet-Name of cloud provider.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vpcReg")
    def vpc_reg(self) -> Optional[pulumi.Input[str]]:
        """
        Region of cloud provider.
        """
        return pulumi.get(self, "vpc_reg")

    @vpc_reg.setter
    def vpc_reg(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_reg", value)

    @property
    @pulumi.getter(name="vpcSize")
    def vpc_size(self) -> Optional[pulumi.Input[str]]:
        """
        Size of the gateway instance.
        """
        return pulumi.get(self, "vpc_size")

    @vpc_size.setter
    def vpc_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_size", value)


class AviatrixSpokeVpc(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 cloud_type: Optional[pulumi.Input[int]] = None,
                 enable_nat: Optional[pulumi.Input[str]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 ha_gw_size: Optional[pulumi.Input[str]] = None,
                 ha_subnet: Optional[pulumi.Input[str]] = None,
                 ha_zone: Optional[pulumi.Input[str]] = None,
                 single_az_ha: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 tag_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 transit_gw: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vpc_reg: Optional[pulumi.Input[str]] = None,
                 vpc_size: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a AviatrixSpokeVpc resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_name: This parameter represents the name of a Cloud-Account in Aviatrix controller.
        :param pulumi.Input[int] cloud_type: Type of cloud service provider.
        :param pulumi.Input[str] enable_nat: Specify whether enabling NAT feature on the gateway or not.
        :param pulumi.Input[str] gw_name: Name of the gateway which is going to be created.
        :param pulumi.Input[str] ha_gw_size: HA Gateway Size.
        :param pulumi.Input[str] ha_subnet: HA Subnet. Required if enabling HA for AWS/Azure.
        :param pulumi.Input[str] ha_zone: HA Zone. Required if enabling HA for GCP.
        :param pulumi.Input[str] single_az_ha: Set to 'enabled' if this feature is desired.
        :param pulumi.Input[str] subnet: Public Subnet Info.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tag_lists: Instance tag of cloud provider.
        :param pulumi.Input[str] transit_gw: Specify the transit Gateway.
        :param pulumi.Input[str] vpc_id: VPC-ID/VNet-Name of cloud provider.
        :param pulumi.Input[str] vpc_reg: Region of cloud provider.
        :param pulumi.Input[str] vpc_size: Size of the gateway instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixSpokeVpcArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AviatrixSpokeVpc resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AviatrixSpokeVpcArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixSpokeVpcArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 cloud_type: Optional[pulumi.Input[int]] = None,
                 enable_nat: Optional[pulumi.Input[str]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 ha_gw_size: Optional[pulumi.Input[str]] = None,
                 ha_subnet: Optional[pulumi.Input[str]] = None,
                 ha_zone: Optional[pulumi.Input[str]] = None,
                 single_az_ha: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 tag_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 transit_gw: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vpc_reg: Optional[pulumi.Input[str]] = None,
                 vpc_size: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixSpokeVpcArgs.__new__(AviatrixSpokeVpcArgs)

            if account_name is None and not opts.urn:
                raise TypeError("Missing required property 'account_name'")
            __props__.__dict__["account_name"] = account_name
            if cloud_type is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_type'")
            __props__.__dict__["cloud_type"] = cloud_type
            __props__.__dict__["enable_nat"] = enable_nat
            if gw_name is None and not opts.urn:
                raise TypeError("Missing required property 'gw_name'")
            __props__.__dict__["gw_name"] = gw_name
            __props__.__dict__["ha_gw_size"] = ha_gw_size
            __props__.__dict__["ha_subnet"] = ha_subnet
            __props__.__dict__["ha_zone"] = ha_zone
            __props__.__dict__["single_az_ha"] = single_az_ha
            if subnet is None and not opts.urn:
                raise TypeError("Missing required property 'subnet'")
            __props__.__dict__["subnet"] = subnet
            __props__.__dict__["tag_lists"] = tag_lists
            __props__.__dict__["transit_gw"] = transit_gw
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            if vpc_reg is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_reg'")
            __props__.__dict__["vpc_reg"] = vpc_reg
            if vpc_size is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_size'")
            __props__.__dict__["vpc_size"] = vpc_size
            __props__.__dict__["cloud_instance_id"] = None
        super(AviatrixSpokeVpc, __self__).__init__(
            'aviatrix:index/aviatrixSpokeVpc:AviatrixSpokeVpc',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_name: Optional[pulumi.Input[str]] = None,
            cloud_instance_id: Optional[pulumi.Input[str]] = None,
            cloud_type: Optional[pulumi.Input[int]] = None,
            enable_nat: Optional[pulumi.Input[str]] = None,
            gw_name: Optional[pulumi.Input[str]] = None,
            ha_gw_size: Optional[pulumi.Input[str]] = None,
            ha_subnet: Optional[pulumi.Input[str]] = None,
            ha_zone: Optional[pulumi.Input[str]] = None,
            single_az_ha: Optional[pulumi.Input[str]] = None,
            subnet: Optional[pulumi.Input[str]] = None,
            tag_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            transit_gw: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            vpc_reg: Optional[pulumi.Input[str]] = None,
            vpc_size: Optional[pulumi.Input[str]] = None) -> 'AviatrixSpokeVpc':
        """
        Get an existing AviatrixSpokeVpc resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_name: This parameter represents the name of a Cloud-Account in Aviatrix controller.
        :param pulumi.Input[str] cloud_instance_id: Cloud instance ID.
        :param pulumi.Input[int] cloud_type: Type of cloud service provider.
        :param pulumi.Input[str] enable_nat: Specify whether enabling NAT feature on the gateway or not.
        :param pulumi.Input[str] gw_name: Name of the gateway which is going to be created.
        :param pulumi.Input[str] ha_gw_size: HA Gateway Size.
        :param pulumi.Input[str] ha_subnet: HA Subnet. Required if enabling HA for AWS/Azure.
        :param pulumi.Input[str] ha_zone: HA Zone. Required if enabling HA for GCP.
        :param pulumi.Input[str] single_az_ha: Set to 'enabled' if this feature is desired.
        :param pulumi.Input[str] subnet: Public Subnet Info.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tag_lists: Instance tag of cloud provider.
        :param pulumi.Input[str] transit_gw: Specify the transit Gateway.
        :param pulumi.Input[str] vpc_id: VPC-ID/VNet-Name of cloud provider.
        :param pulumi.Input[str] vpc_reg: Region of cloud provider.
        :param pulumi.Input[str] vpc_size: Size of the gateway instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixSpokeVpcState.__new__(_AviatrixSpokeVpcState)

        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["cloud_instance_id"] = cloud_instance_id
        __props__.__dict__["cloud_type"] = cloud_type
        __props__.__dict__["enable_nat"] = enable_nat
        __props__.__dict__["gw_name"] = gw_name
        __props__.__dict__["ha_gw_size"] = ha_gw_size
        __props__.__dict__["ha_subnet"] = ha_subnet
        __props__.__dict__["ha_zone"] = ha_zone
        __props__.__dict__["single_az_ha"] = single_az_ha
        __props__.__dict__["subnet"] = subnet
        __props__.__dict__["tag_lists"] = tag_lists
        __props__.__dict__["transit_gw"] = transit_gw
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vpc_reg"] = vpc_reg
        __props__.__dict__["vpc_size"] = vpc_size
        return AviatrixSpokeVpc(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[str]:
        """
        This parameter represents the name of a Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="cloudInstanceId")
    def cloud_instance_id(self) -> pulumi.Output[str]:
        """
        Cloud instance ID.
        """
        return pulumi.get(self, "cloud_instance_id")

    @property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> pulumi.Output[int]:
        """
        Type of cloud service provider.
        """
        return pulumi.get(self, "cloud_type")

    @property
    @pulumi.getter(name="enableNat")
    def enable_nat(self) -> pulumi.Output[Optional[str]]:
        """
        Specify whether enabling NAT feature on the gateway or not.
        """
        return pulumi.get(self, "enable_nat")

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> pulumi.Output[str]:
        """
        Name of the gateway which is going to be created.
        """
        return pulumi.get(self, "gw_name")

    @property
    @pulumi.getter(name="haGwSize")
    def ha_gw_size(self) -> pulumi.Output[Optional[str]]:
        """
        HA Gateway Size.
        """
        return pulumi.get(self, "ha_gw_size")

    @property
    @pulumi.getter(name="haSubnet")
    def ha_subnet(self) -> pulumi.Output[Optional[str]]:
        """
        HA Subnet. Required if enabling HA for AWS/Azure.
        """
        return pulumi.get(self, "ha_subnet")

    @property
    @pulumi.getter(name="haZone")
    def ha_zone(self) -> pulumi.Output[Optional[str]]:
        """
        HA Zone. Required if enabling HA for GCP.
        """
        return pulumi.get(self, "ha_zone")

    @property
    @pulumi.getter(name="singleAzHa")
    def single_az_ha(self) -> pulumi.Output[Optional[str]]:
        """
        Set to 'enabled' if this feature is desired.
        """
        return pulumi.get(self, "single_az_ha")

    @property
    @pulumi.getter
    def subnet(self) -> pulumi.Output[str]:
        """
        Public Subnet Info.
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter(name="tagLists")
    def tag_lists(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Instance tag of cloud provider.
        """
        return pulumi.get(self, "tag_lists")

    @property
    @pulumi.getter(name="transitGw")
    def transit_gw(self) -> pulumi.Output[Optional[str]]:
        """
        Specify the transit Gateway.
        """
        return pulumi.get(self, "transit_gw")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        VPC-ID/VNet-Name of cloud provider.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vpcReg")
    def vpc_reg(self) -> pulumi.Output[str]:
        """
        Region of cloud provider.
        """
        return pulumi.get(self, "vpc_reg")

    @property
    @pulumi.getter(name="vpcSize")
    def vpc_size(self) -> pulumi.Output[str]:
        """
        Size of the gateway instance.
        """
        return pulumi.get(self, "vpc_size")

