# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixSpokeTransitAttachmentArgs', 'AviatrixSpokeTransitAttachment']

@pulumi.input_type
class AviatrixSpokeTransitAttachmentArgs:
    def __init__(__self__, *,
                 spoke_gw_name: pulumi.Input[str],
                 transit_gw_name: pulumi.Input[str],
                 enable_max_performance: Optional[pulumi.Input[bool]] = None,
                 route_tables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 spoke_prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 transit_prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a AviatrixSpokeTransitAttachment resource.
        :param pulumi.Input[str] spoke_gw_name: Name of the spoke gateway to attach to transit network.
        :param pulumi.Input[str] transit_gw_name: Name of the transit gateway to attach the spoke gateway to.
        :param pulumi.Input[bool] enable_max_performance: Indicates whether the maximum amount of HPE tunnels will be created. Only valid when transit and spoke gateways are each
               launched in Insane Mode and in the same cloud type. Available as of provider version R2.22.2+.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] route_tables: Learned routes will be propagated to these route tables.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] spoke_prepend_as_paths: AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on spoke gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] transit_prepend_as_paths: AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on transit gateway.
        """
        pulumi.set(__self__, "spoke_gw_name", spoke_gw_name)
        pulumi.set(__self__, "transit_gw_name", transit_gw_name)
        if enable_max_performance is not None:
            pulumi.set(__self__, "enable_max_performance", enable_max_performance)
        if route_tables is not None:
            pulumi.set(__self__, "route_tables", route_tables)
        if spoke_prepend_as_paths is not None:
            pulumi.set(__self__, "spoke_prepend_as_paths", spoke_prepend_as_paths)
        if transit_prepend_as_paths is not None:
            pulumi.set(__self__, "transit_prepend_as_paths", transit_prepend_as_paths)

    @property
    @pulumi.getter(name="spokeGwName")
    def spoke_gw_name(self) -> pulumi.Input[str]:
        """
        Name of the spoke gateway to attach to transit network.
        """
        return pulumi.get(self, "spoke_gw_name")

    @spoke_gw_name.setter
    def spoke_gw_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "spoke_gw_name", value)

    @property
    @pulumi.getter(name="transitGwName")
    def transit_gw_name(self) -> pulumi.Input[str]:
        """
        Name of the transit gateway to attach the spoke gateway to.
        """
        return pulumi.get(self, "transit_gw_name")

    @transit_gw_name.setter
    def transit_gw_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "transit_gw_name", value)

    @property
    @pulumi.getter(name="enableMaxPerformance")
    def enable_max_performance(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the maximum amount of HPE tunnels will be created. Only valid when transit and spoke gateways are each
        launched in Insane Mode and in the same cloud type. Available as of provider version R2.22.2+.
        """
        return pulumi.get(self, "enable_max_performance")

    @enable_max_performance.setter
    def enable_max_performance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_max_performance", value)

    @property
    @pulumi.getter(name="routeTables")
    def route_tables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Learned routes will be propagated to these route tables.
        """
        return pulumi.get(self, "route_tables")

    @route_tables.setter
    def route_tables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "route_tables", value)

    @property
    @pulumi.getter(name="spokePrependAsPaths")
    def spoke_prepend_as_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on spoke gateway.
        """
        return pulumi.get(self, "spoke_prepend_as_paths")

    @spoke_prepend_as_paths.setter
    def spoke_prepend_as_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "spoke_prepend_as_paths", value)

    @property
    @pulumi.getter(name="transitPrependAsPaths")
    def transit_prepend_as_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on transit gateway.
        """
        return pulumi.get(self, "transit_prepend_as_paths")

    @transit_prepend_as_paths.setter
    def transit_prepend_as_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "transit_prepend_as_paths", value)


@pulumi.input_type
class _AviatrixSpokeTransitAttachmentState:
    def __init__(__self__, *,
                 enable_max_performance: Optional[pulumi.Input[bool]] = None,
                 route_tables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 spoke_bgp_enabled: Optional[pulumi.Input[bool]] = None,
                 spoke_gw_name: Optional[pulumi.Input[str]] = None,
                 spoke_prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 transit_gw_name: Optional[pulumi.Input[str]] = None,
                 transit_prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering AviatrixSpokeTransitAttachment resources.
        :param pulumi.Input[bool] enable_max_performance: Indicates whether the maximum amount of HPE tunnels will be created. Only valid when transit and spoke gateways are each
               launched in Insane Mode and in the same cloud type. Available as of provider version R2.22.2+.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] route_tables: Learned routes will be propagated to these route tables.
        :param pulumi.Input[bool] spoke_bgp_enabled: Indicates whether the spoke gateway is BGP enabled or not.
        :param pulumi.Input[str] spoke_gw_name: Name of the spoke gateway to attach to transit network.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] spoke_prepend_as_paths: AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on spoke gateway.
        :param pulumi.Input[str] transit_gw_name: Name of the transit gateway to attach the spoke gateway to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] transit_prepend_as_paths: AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on transit gateway.
        """
        if enable_max_performance is not None:
            pulumi.set(__self__, "enable_max_performance", enable_max_performance)
        if route_tables is not None:
            pulumi.set(__self__, "route_tables", route_tables)
        if spoke_bgp_enabled is not None:
            pulumi.set(__self__, "spoke_bgp_enabled", spoke_bgp_enabled)
        if spoke_gw_name is not None:
            pulumi.set(__self__, "spoke_gw_name", spoke_gw_name)
        if spoke_prepend_as_paths is not None:
            pulumi.set(__self__, "spoke_prepend_as_paths", spoke_prepend_as_paths)
        if transit_gw_name is not None:
            pulumi.set(__self__, "transit_gw_name", transit_gw_name)
        if transit_prepend_as_paths is not None:
            pulumi.set(__self__, "transit_prepend_as_paths", transit_prepend_as_paths)

    @property
    @pulumi.getter(name="enableMaxPerformance")
    def enable_max_performance(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the maximum amount of HPE tunnels will be created. Only valid when transit and spoke gateways are each
        launched in Insane Mode and in the same cloud type. Available as of provider version R2.22.2+.
        """
        return pulumi.get(self, "enable_max_performance")

    @enable_max_performance.setter
    def enable_max_performance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_max_performance", value)

    @property
    @pulumi.getter(name="routeTables")
    def route_tables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Learned routes will be propagated to these route tables.
        """
        return pulumi.get(self, "route_tables")

    @route_tables.setter
    def route_tables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "route_tables", value)

    @property
    @pulumi.getter(name="spokeBgpEnabled")
    def spoke_bgp_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the spoke gateway is BGP enabled or not.
        """
        return pulumi.get(self, "spoke_bgp_enabled")

    @spoke_bgp_enabled.setter
    def spoke_bgp_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "spoke_bgp_enabled", value)

    @property
    @pulumi.getter(name="spokeGwName")
    def spoke_gw_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the spoke gateway to attach to transit network.
        """
        return pulumi.get(self, "spoke_gw_name")

    @spoke_gw_name.setter
    def spoke_gw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spoke_gw_name", value)

    @property
    @pulumi.getter(name="spokePrependAsPaths")
    def spoke_prepend_as_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on spoke gateway.
        """
        return pulumi.get(self, "spoke_prepend_as_paths")

    @spoke_prepend_as_paths.setter
    def spoke_prepend_as_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "spoke_prepend_as_paths", value)

    @property
    @pulumi.getter(name="transitGwName")
    def transit_gw_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the transit gateway to attach the spoke gateway to.
        """
        return pulumi.get(self, "transit_gw_name")

    @transit_gw_name.setter
    def transit_gw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_gw_name", value)

    @property
    @pulumi.getter(name="transitPrependAsPaths")
    def transit_prepend_as_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on transit gateway.
        """
        return pulumi.get(self, "transit_prepend_as_paths")

    @transit_prepend_as_paths.setter
    def transit_prepend_as_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "transit_prepend_as_paths", value)


class AviatrixSpokeTransitAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_max_performance: Optional[pulumi.Input[bool]] = None,
                 route_tables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 spoke_gw_name: Optional[pulumi.Input[str]] = None,
                 spoke_prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 transit_gw_name: Optional[pulumi.Input[str]] = None,
                 transit_prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Create a AviatrixSpokeTransitAttachment resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enable_max_performance: Indicates whether the maximum amount of HPE tunnels will be created. Only valid when transit and spoke gateways are each
               launched in Insane Mode and in the same cloud type. Available as of provider version R2.22.2+.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] route_tables: Learned routes will be propagated to these route tables.
        :param pulumi.Input[str] spoke_gw_name: Name of the spoke gateway to attach to transit network.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] spoke_prepend_as_paths: AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on spoke gateway.
        :param pulumi.Input[str] transit_gw_name: Name of the transit gateway to attach the spoke gateway to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] transit_prepend_as_paths: AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on transit gateway.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixSpokeTransitAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AviatrixSpokeTransitAttachment resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AviatrixSpokeTransitAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixSpokeTransitAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_max_performance: Optional[pulumi.Input[bool]] = None,
                 route_tables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 spoke_gw_name: Optional[pulumi.Input[str]] = None,
                 spoke_prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 transit_gw_name: Optional[pulumi.Input[str]] = None,
                 transit_prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixSpokeTransitAttachmentArgs.__new__(AviatrixSpokeTransitAttachmentArgs)

            __props__.__dict__["enable_max_performance"] = enable_max_performance
            __props__.__dict__["route_tables"] = route_tables
            if spoke_gw_name is None and not opts.urn:
                raise TypeError("Missing required property 'spoke_gw_name'")
            __props__.__dict__["spoke_gw_name"] = spoke_gw_name
            __props__.__dict__["spoke_prepend_as_paths"] = spoke_prepend_as_paths
            if transit_gw_name is None and not opts.urn:
                raise TypeError("Missing required property 'transit_gw_name'")
            __props__.__dict__["transit_gw_name"] = transit_gw_name
            __props__.__dict__["transit_prepend_as_paths"] = transit_prepend_as_paths
            __props__.__dict__["spoke_bgp_enabled"] = None
        super(AviatrixSpokeTransitAttachment, __self__).__init__(
            'aviatrix:index/aviatrixSpokeTransitAttachment:AviatrixSpokeTransitAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enable_max_performance: Optional[pulumi.Input[bool]] = None,
            route_tables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            spoke_bgp_enabled: Optional[pulumi.Input[bool]] = None,
            spoke_gw_name: Optional[pulumi.Input[str]] = None,
            spoke_prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            transit_gw_name: Optional[pulumi.Input[str]] = None,
            transit_prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'AviatrixSpokeTransitAttachment':
        """
        Get an existing AviatrixSpokeTransitAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enable_max_performance: Indicates whether the maximum amount of HPE tunnels will be created. Only valid when transit and spoke gateways are each
               launched in Insane Mode and in the same cloud type. Available as of provider version R2.22.2+.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] route_tables: Learned routes will be propagated to these route tables.
        :param pulumi.Input[bool] spoke_bgp_enabled: Indicates whether the spoke gateway is BGP enabled or not.
        :param pulumi.Input[str] spoke_gw_name: Name of the spoke gateway to attach to transit network.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] spoke_prepend_as_paths: AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on spoke gateway.
        :param pulumi.Input[str] transit_gw_name: Name of the transit gateway to attach the spoke gateway to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] transit_prepend_as_paths: AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on transit gateway.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixSpokeTransitAttachmentState.__new__(_AviatrixSpokeTransitAttachmentState)

        __props__.__dict__["enable_max_performance"] = enable_max_performance
        __props__.__dict__["route_tables"] = route_tables
        __props__.__dict__["spoke_bgp_enabled"] = spoke_bgp_enabled
        __props__.__dict__["spoke_gw_name"] = spoke_gw_name
        __props__.__dict__["spoke_prepend_as_paths"] = spoke_prepend_as_paths
        __props__.__dict__["transit_gw_name"] = transit_gw_name
        __props__.__dict__["transit_prepend_as_paths"] = transit_prepend_as_paths
        return AviatrixSpokeTransitAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="enableMaxPerformance")
    def enable_max_performance(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether the maximum amount of HPE tunnels will be created. Only valid when transit and spoke gateways are each
        launched in Insane Mode and in the same cloud type. Available as of provider version R2.22.2+.
        """
        return pulumi.get(self, "enable_max_performance")

    @property
    @pulumi.getter(name="routeTables")
    def route_tables(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Learned routes will be propagated to these route tables.
        """
        return pulumi.get(self, "route_tables")

    @property
    @pulumi.getter(name="spokeBgpEnabled")
    def spoke_bgp_enabled(self) -> pulumi.Output[bool]:
        """
        Indicates whether the spoke gateway is BGP enabled or not.
        """
        return pulumi.get(self, "spoke_bgp_enabled")

    @property
    @pulumi.getter(name="spokeGwName")
    def spoke_gw_name(self) -> pulumi.Output[str]:
        """
        Name of the spoke gateway to attach to transit network.
        """
        return pulumi.get(self, "spoke_gw_name")

    @property
    @pulumi.getter(name="spokePrependAsPaths")
    def spoke_prepend_as_paths(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on spoke gateway.
        """
        return pulumi.get(self, "spoke_prepend_as_paths")

    @property
    @pulumi.getter(name="transitGwName")
    def transit_gw_name(self) -> pulumi.Output[str]:
        """
        Name of the transit gateway to attach the spoke gateway to.
        """
        return pulumi.get(self, "transit_gw_name")

    @property
    @pulumi.getter(name="transitPrependAsPaths")
    def transit_prepend_as_paths(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on transit gateway.
        """
        return pulumi.get(self, "transit_prepend_as_paths")

