# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['Aviatrix_spoke_external_device_connArgs', 'Aviatrix_spoke_external_device_conn']

@pulumi.input_type
class Aviatrix_spoke_external_device_connArgs:
    def __init__(__self__, *,
                 connection_name: pulumi.Input[str],
                 gw_name: pulumi.Input[str],
                 remote_gateway_ip: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 approved_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backup_bgp_md5_key: Optional[pulumi.Input[str]] = None,
                 backup_bgp_remote_as_num: Optional[pulumi.Input[str]] = None,
                 backup_direct_connect: Optional[pulumi.Input[bool]] = None,
                 backup_local_tunnel_cidr: Optional[pulumi.Input[str]] = None,
                 backup_pre_shared_key: Optional[pulumi.Input[str]] = None,
                 backup_remote_gateway_ip: Optional[pulumi.Input[str]] = None,
                 backup_remote_tunnel_cidr: Optional[pulumi.Input[str]] = None,
                 bgp_local_as_num: Optional[pulumi.Input[str]] = None,
                 bgp_md5_key: Optional[pulumi.Input[str]] = None,
                 bgp_remote_as_num: Optional[pulumi.Input[str]] = None,
                 connection_type: Optional[pulumi.Input[str]] = None,
                 custom_algorithms: Optional[pulumi.Input[bool]] = None,
                 direct_connect: Optional[pulumi.Input[bool]] = None,
                 enable_event_triggered_ha: Optional[pulumi.Input[bool]] = None,
                 enable_ikev2: Optional[pulumi.Input[bool]] = None,
                 enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
                 ha_enabled: Optional[pulumi.Input[bool]] = None,
                 local_tunnel_cidr: Optional[pulumi.Input[str]] = None,
                 manual_bgp_advertised_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 phase1_authentication: Optional[pulumi.Input[str]] = None,
                 phase1_dh_groups: Optional[pulumi.Input[str]] = None,
                 phase1_encryption: Optional[pulumi.Input[str]] = None,
                 phase1_remote_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 phase2_authentication: Optional[pulumi.Input[str]] = None,
                 phase2_dh_groups: Optional[pulumi.Input[str]] = None,
                 phase2_encryption: Optional[pulumi.Input[str]] = None,
                 pre_shared_key: Optional[pulumi.Input[str]] = None,
                 prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 remote_subnet: Optional[pulumi.Input[str]] = None,
                 remote_tunnel_cidr: Optional[pulumi.Input[str]] = None,
                 tunnel_protocol: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Aviatrix_spoke_external_device_conn resource.
        :param pulumi.Input[str] connection_name: The name of the spoke external device connection which is going to be created.
        :param pulumi.Input[str] gw_name: Name of the BGP Spoke Gateway.
        :param pulumi.Input[str] remote_gateway_ip: Remote Gateway IP.
        :param pulumi.Input[str] vpc_id: ID of the VPC where the BGP Spoke Gateway is located.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] approved_cidrs: Set of approved cidrs. Requires 'enable_learned_cidrs_approval' to be true. Type: Set(String).
        :param pulumi.Input[str] backup_bgp_md5_key: Backup BGP MD5 authentication key.
        :param pulumi.Input[str] backup_bgp_remote_as_num: Backup BGP remote ASN (Autonomous System Number). Integer between 1-4294967294.
        :param pulumi.Input[bool] backup_direct_connect: Backup direct connect for backup external device.
        :param pulumi.Input[str] backup_local_tunnel_cidr: Source CIDR for the tunnel from the backup Aviatrix spoke gateway.
        :param pulumi.Input[str] backup_pre_shared_key: Backup pre shared key.
        :param pulumi.Input[str] backup_remote_gateway_ip: Backup remote gateway IP.
        :param pulumi.Input[str] backup_remote_tunnel_cidr: Destination CIDR for the tunnel to the backup external device.
        :param pulumi.Input[str] bgp_local_as_num: BGP local ASN (Autonomous System Number). Integer between 1-4294967294.
        :param pulumi.Input[str] bgp_md5_key: BGP MD5 authentication key.
        :param pulumi.Input[str] bgp_remote_as_num: BGP remote ASN (Autonomous System Number). Integer between 1-4294967294.
        :param pulumi.Input[str] connection_type: Connection type. Valid values: 'bgp', 'static'. Default value: 'bgp'.
        :param pulumi.Input[bool] custom_algorithms: Switch to enable custom/non-default algorithms for IPSec Authentication/Encryption.
        :param pulumi.Input[bool] direct_connect: Set true for private network infrastructure.
        :param pulumi.Input[bool] enable_event_triggered_ha: Enable Event Triggered HA.
        :param pulumi.Input[bool] enable_ikev2: Set as true if use IKEv2.
        :param pulumi.Input[bool] enable_learned_cidrs_approval: Enable learned CIDR approval for the connection. Only valid with 'connection_type' = 'bgp'. Requires the spoke_gateway's
               'learned_cidrs_approval_mode' attribute be set to 'connection'. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] ha_enabled: Set as true if there are two external devices.
        :param pulumi.Input[str] local_tunnel_cidr: Source CIDR for the tunnel from the Aviatrix spoke gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] manual_bgp_advertised_cidrs: Configure manual BGP advertised CIDRs for this connection. Only valid with 'connection_type' = 'bgp'.
        :param pulumi.Input[str] phase1_authentication: Phase one Authentication. Valid values: 'SHA-1', 'SHA-256', 'SHA-384' and 'SHA-512'.
        :param pulumi.Input[str] phase1_dh_groups: Phase one DH Groups. Valid values: '1', '2', '5', '14', '15', '16', '17', '18', '19', '20' and '21'.
        :param pulumi.Input[str] phase1_encryption: Phase one Encryption. Valid values: '3DES', 'AES-128-CBC', 'AES-192-CBC' and 'AES-256-CBC', 'AES-128-GCM-64',
               'AES-128-GCM-96', 'AES-128-GCM-128', 'AES-256-GCM-64', 'AES-256-GCM-96', and 'AES-256-GCM-128'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] phase1_remote_identifiers: Phase 1 remote identifier of the IPsec tunnel.
        :param pulumi.Input[str] phase2_authentication: Phase two Authentication. Valid values: 'NO-AUTH', 'HMAC-SHA-1', 'HMAC-SHA-256', 'HMAC-SHA-384' and 'HMAC-SHA-512'.
        :param pulumi.Input[str] phase2_dh_groups: Phase two DH Groups. Valid values: '1', '2', '5', '14', '15', '16', '17', '18', '19', '20' and '21'.
        :param pulumi.Input[str] phase2_encryption: Phase two Encryption. Valid values: '3DES', 'AES-128-CBC', 'AES-192-CBC', 'AES-256-CBC', 'AES-128-GCM-64',
               'AES-128-GCM-96', 'AES-128-GCM-128', 'AES-256-GCM-64', 'AES-256-GCM-96', 'AES-256-GCM-128', and 'NULL-ENCR'.
        :param pulumi.Input[str] pre_shared_key: If left blank, the pre-shared key will be auto generated.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prepend_as_paths: Connection AS Path Prepend customized by specifying AS PATH for a BGP connection.
        :param pulumi.Input[str] remote_subnet: Remote CIDRs joined as a string with ','. Required for a 'static' type connection.
        :param pulumi.Input[str] remote_tunnel_cidr: Destination CIDR for the tunnel to the external device.
        :param pulumi.Input[str] tunnel_protocol: Tunnel Protocol. Valid value: 'IPsec'. Default value: 'IPsec'. Case insensitive.
        """
        pulumi.set(__self__, "connection_name", connection_name)
        pulumi.set(__self__, "gw_name", gw_name)
        pulumi.set(__self__, "remote_gateway_ip", remote_gateway_ip)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if approved_cidrs is not None:
            pulumi.set(__self__, "approved_cidrs", approved_cidrs)
        if backup_bgp_md5_key is not None:
            pulumi.set(__self__, "backup_bgp_md5_key", backup_bgp_md5_key)
        if backup_bgp_remote_as_num is not None:
            pulumi.set(__self__, "backup_bgp_remote_as_num", backup_bgp_remote_as_num)
        if backup_direct_connect is not None:
            pulumi.set(__self__, "backup_direct_connect", backup_direct_connect)
        if backup_local_tunnel_cidr is not None:
            pulumi.set(__self__, "backup_local_tunnel_cidr", backup_local_tunnel_cidr)
        if backup_pre_shared_key is not None:
            pulumi.set(__self__, "backup_pre_shared_key", backup_pre_shared_key)
        if backup_remote_gateway_ip is not None:
            pulumi.set(__self__, "backup_remote_gateway_ip", backup_remote_gateway_ip)
        if backup_remote_tunnel_cidr is not None:
            pulumi.set(__self__, "backup_remote_tunnel_cidr", backup_remote_tunnel_cidr)
        if bgp_local_as_num is not None:
            pulumi.set(__self__, "bgp_local_as_num", bgp_local_as_num)
        if bgp_md5_key is not None:
            pulumi.set(__self__, "bgp_md5_key", bgp_md5_key)
        if bgp_remote_as_num is not None:
            pulumi.set(__self__, "bgp_remote_as_num", bgp_remote_as_num)
        if connection_type is not None:
            pulumi.set(__self__, "connection_type", connection_type)
        if custom_algorithms is not None:
            pulumi.set(__self__, "custom_algorithms", custom_algorithms)
        if direct_connect is not None:
            pulumi.set(__self__, "direct_connect", direct_connect)
        if enable_event_triggered_ha is not None:
            pulumi.set(__self__, "enable_event_triggered_ha", enable_event_triggered_ha)
        if enable_ikev2 is not None:
            pulumi.set(__self__, "enable_ikev2", enable_ikev2)
        if enable_learned_cidrs_approval is not None:
            pulumi.set(__self__, "enable_learned_cidrs_approval", enable_learned_cidrs_approval)
        if ha_enabled is not None:
            pulumi.set(__self__, "ha_enabled", ha_enabled)
        if local_tunnel_cidr is not None:
            pulumi.set(__self__, "local_tunnel_cidr", local_tunnel_cidr)
        if manual_bgp_advertised_cidrs is not None:
            pulumi.set(__self__, "manual_bgp_advertised_cidrs", manual_bgp_advertised_cidrs)
        if phase1_authentication is not None:
            pulumi.set(__self__, "phase1_authentication", phase1_authentication)
        if phase1_dh_groups is not None:
            pulumi.set(__self__, "phase1_dh_groups", phase1_dh_groups)
        if phase1_encryption is not None:
            pulumi.set(__self__, "phase1_encryption", phase1_encryption)
        if phase1_remote_identifiers is not None:
            pulumi.set(__self__, "phase1_remote_identifiers", phase1_remote_identifiers)
        if phase2_authentication is not None:
            pulumi.set(__self__, "phase2_authentication", phase2_authentication)
        if phase2_dh_groups is not None:
            pulumi.set(__self__, "phase2_dh_groups", phase2_dh_groups)
        if phase2_encryption is not None:
            pulumi.set(__self__, "phase2_encryption", phase2_encryption)
        if pre_shared_key is not None:
            pulumi.set(__self__, "pre_shared_key", pre_shared_key)
        if prepend_as_paths is not None:
            pulumi.set(__self__, "prepend_as_paths", prepend_as_paths)
        if remote_subnet is not None:
            pulumi.set(__self__, "remote_subnet", remote_subnet)
        if remote_tunnel_cidr is not None:
            pulumi.set(__self__, "remote_tunnel_cidr", remote_tunnel_cidr)
        if tunnel_protocol is not None:
            pulumi.set(__self__, "tunnel_protocol", tunnel_protocol)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> pulumi.Input[str]:
        """
        The name of the spoke external device connection which is going to be created.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_name", value)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> pulumi.Input[str]:
        """
        Name of the BGP Spoke Gateway.
        """
        return pulumi.get(self, "gw_name")

    @gw_name.setter
    def gw_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "gw_name", value)

    @property
    @pulumi.getter(name="remoteGatewayIp")
    def remote_gateway_ip(self) -> pulumi.Input[str]:
        """
        Remote Gateway IP.
        """
        return pulumi.get(self, "remote_gateway_ip")

    @remote_gateway_ip.setter
    def remote_gateway_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "remote_gateway_ip", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        ID of the VPC where the BGP Spoke Gateway is located.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="approvedCidrs")
    def approved_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of approved cidrs. Requires 'enable_learned_cidrs_approval' to be true. Type: Set(String).
        """
        return pulumi.get(self, "approved_cidrs")

    @approved_cidrs.setter
    def approved_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "approved_cidrs", value)

    @property
    @pulumi.getter(name="backupBgpMd5Key")
    def backup_bgp_md5_key(self) -> Optional[pulumi.Input[str]]:
        """
        Backup BGP MD5 authentication key.
        """
        return pulumi.get(self, "backup_bgp_md5_key")

    @backup_bgp_md5_key.setter
    def backup_bgp_md5_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_bgp_md5_key", value)

    @property
    @pulumi.getter(name="backupBgpRemoteAsNum")
    def backup_bgp_remote_as_num(self) -> Optional[pulumi.Input[str]]:
        """
        Backup BGP remote ASN (Autonomous System Number). Integer between 1-4294967294.
        """
        return pulumi.get(self, "backup_bgp_remote_as_num")

    @backup_bgp_remote_as_num.setter
    def backup_bgp_remote_as_num(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_bgp_remote_as_num", value)

    @property
    @pulumi.getter(name="backupDirectConnect")
    def backup_direct_connect(self) -> Optional[pulumi.Input[bool]]:
        """
        Backup direct connect for backup external device.
        """
        return pulumi.get(self, "backup_direct_connect")

    @backup_direct_connect.setter
    def backup_direct_connect(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "backup_direct_connect", value)

    @property
    @pulumi.getter(name="backupLocalTunnelCidr")
    def backup_local_tunnel_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        Source CIDR for the tunnel from the backup Aviatrix spoke gateway.
        """
        return pulumi.get(self, "backup_local_tunnel_cidr")

    @backup_local_tunnel_cidr.setter
    def backup_local_tunnel_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_local_tunnel_cidr", value)

    @property
    @pulumi.getter(name="backupPreSharedKey")
    def backup_pre_shared_key(self) -> Optional[pulumi.Input[str]]:
        """
        Backup pre shared key.
        """
        return pulumi.get(self, "backup_pre_shared_key")

    @backup_pre_shared_key.setter
    def backup_pre_shared_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_pre_shared_key", value)

    @property
    @pulumi.getter(name="backupRemoteGatewayIp")
    def backup_remote_gateway_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Backup remote gateway IP.
        """
        return pulumi.get(self, "backup_remote_gateway_ip")

    @backup_remote_gateway_ip.setter
    def backup_remote_gateway_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_remote_gateway_ip", value)

    @property
    @pulumi.getter(name="backupRemoteTunnelCidr")
    def backup_remote_tunnel_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        Destination CIDR for the tunnel to the backup external device.
        """
        return pulumi.get(self, "backup_remote_tunnel_cidr")

    @backup_remote_tunnel_cidr.setter
    def backup_remote_tunnel_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_remote_tunnel_cidr", value)

    @property
    @pulumi.getter(name="bgpLocalAsNum")
    def bgp_local_as_num(self) -> Optional[pulumi.Input[str]]:
        """
        BGP local ASN (Autonomous System Number). Integer between 1-4294967294.
        """
        return pulumi.get(self, "bgp_local_as_num")

    @bgp_local_as_num.setter
    def bgp_local_as_num(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bgp_local_as_num", value)

    @property
    @pulumi.getter(name="bgpMd5Key")
    def bgp_md5_key(self) -> Optional[pulumi.Input[str]]:
        """
        BGP MD5 authentication key.
        """
        return pulumi.get(self, "bgp_md5_key")

    @bgp_md5_key.setter
    def bgp_md5_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bgp_md5_key", value)

    @property
    @pulumi.getter(name="bgpRemoteAsNum")
    def bgp_remote_as_num(self) -> Optional[pulumi.Input[str]]:
        """
        BGP remote ASN (Autonomous System Number). Integer between 1-4294967294.
        """
        return pulumi.get(self, "bgp_remote_as_num")

    @bgp_remote_as_num.setter
    def bgp_remote_as_num(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bgp_remote_as_num", value)

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[pulumi.Input[str]]:
        """
        Connection type. Valid values: 'bgp', 'static'. Default value: 'bgp'.
        """
        return pulumi.get(self, "connection_type")

    @connection_type.setter
    def connection_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_type", value)

    @property
    @pulumi.getter(name="customAlgorithms")
    def custom_algorithms(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable custom/non-default algorithms for IPSec Authentication/Encryption.
        """
        return pulumi.get(self, "custom_algorithms")

    @custom_algorithms.setter
    def custom_algorithms(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "custom_algorithms", value)

    @property
    @pulumi.getter(name="directConnect")
    def direct_connect(self) -> Optional[pulumi.Input[bool]]:
        """
        Set true for private network infrastructure.
        """
        return pulumi.get(self, "direct_connect")

    @direct_connect.setter
    def direct_connect(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "direct_connect", value)

    @property
    @pulumi.getter(name="enableEventTriggeredHa")
    def enable_event_triggered_ha(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Event Triggered HA.
        """
        return pulumi.get(self, "enable_event_triggered_ha")

    @enable_event_triggered_ha.setter
    def enable_event_triggered_ha(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_event_triggered_ha", value)

    @property
    @pulumi.getter(name="enableIkev2")
    def enable_ikev2(self) -> Optional[pulumi.Input[bool]]:
        """
        Set as true if use IKEv2.
        """
        return pulumi.get(self, "enable_ikev2")

    @enable_ikev2.setter
    def enable_ikev2(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ikev2", value)

    @property
    @pulumi.getter(name="enableLearnedCidrsApproval")
    def enable_learned_cidrs_approval(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable learned CIDR approval for the connection. Only valid with 'connection_type' = 'bgp'. Requires the spoke_gateway's
        'learned_cidrs_approval_mode' attribute be set to 'connection'. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_learned_cidrs_approval")

    @enable_learned_cidrs_approval.setter
    def enable_learned_cidrs_approval(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_learned_cidrs_approval", value)

    @property
    @pulumi.getter(name="haEnabled")
    def ha_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Set as true if there are two external devices.
        """
        return pulumi.get(self, "ha_enabled")

    @ha_enabled.setter
    def ha_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ha_enabled", value)

    @property
    @pulumi.getter(name="localTunnelCidr")
    def local_tunnel_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        Source CIDR for the tunnel from the Aviatrix spoke gateway.
        """
        return pulumi.get(self, "local_tunnel_cidr")

    @local_tunnel_cidr.setter
    def local_tunnel_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_tunnel_cidr", value)

    @property
    @pulumi.getter(name="manualBgpAdvertisedCidrs")
    def manual_bgp_advertised_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Configure manual BGP advertised CIDRs for this connection. Only valid with 'connection_type' = 'bgp'.
        """
        return pulumi.get(self, "manual_bgp_advertised_cidrs")

    @manual_bgp_advertised_cidrs.setter
    def manual_bgp_advertised_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "manual_bgp_advertised_cidrs", value)

    @property
    @pulumi.getter(name="phase1Authentication")
    def phase1_authentication(self) -> Optional[pulumi.Input[str]]:
        """
        Phase one Authentication. Valid values: 'SHA-1', 'SHA-256', 'SHA-384' and 'SHA-512'.
        """
        return pulumi.get(self, "phase1_authentication")

    @phase1_authentication.setter
    def phase1_authentication(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phase1_authentication", value)

    @property
    @pulumi.getter(name="phase1DhGroups")
    def phase1_dh_groups(self) -> Optional[pulumi.Input[str]]:
        """
        Phase one DH Groups. Valid values: '1', '2', '5', '14', '15', '16', '17', '18', '19', '20' and '21'.
        """
        return pulumi.get(self, "phase1_dh_groups")

    @phase1_dh_groups.setter
    def phase1_dh_groups(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phase1_dh_groups", value)

    @property
    @pulumi.getter(name="phase1Encryption")
    def phase1_encryption(self) -> Optional[pulumi.Input[str]]:
        """
        Phase one Encryption. Valid values: '3DES', 'AES-128-CBC', 'AES-192-CBC' and 'AES-256-CBC', 'AES-128-GCM-64',
        'AES-128-GCM-96', 'AES-128-GCM-128', 'AES-256-GCM-64', 'AES-256-GCM-96', and 'AES-256-GCM-128'.
        """
        return pulumi.get(self, "phase1_encryption")

    @phase1_encryption.setter
    def phase1_encryption(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phase1_encryption", value)

    @property
    @pulumi.getter(name="phase1RemoteIdentifiers")
    def phase1_remote_identifiers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Phase 1 remote identifier of the IPsec tunnel.
        """
        return pulumi.get(self, "phase1_remote_identifiers")

    @phase1_remote_identifiers.setter
    def phase1_remote_identifiers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "phase1_remote_identifiers", value)

    @property
    @pulumi.getter(name="phase2Authentication")
    def phase2_authentication(self) -> Optional[pulumi.Input[str]]:
        """
        Phase two Authentication. Valid values: 'NO-AUTH', 'HMAC-SHA-1', 'HMAC-SHA-256', 'HMAC-SHA-384' and 'HMAC-SHA-512'.
        """
        return pulumi.get(self, "phase2_authentication")

    @phase2_authentication.setter
    def phase2_authentication(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phase2_authentication", value)

    @property
    @pulumi.getter(name="phase2DhGroups")
    def phase2_dh_groups(self) -> Optional[pulumi.Input[str]]:
        """
        Phase two DH Groups. Valid values: '1', '2', '5', '14', '15', '16', '17', '18', '19', '20' and '21'.
        """
        return pulumi.get(self, "phase2_dh_groups")

    @phase2_dh_groups.setter
    def phase2_dh_groups(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phase2_dh_groups", value)

    @property
    @pulumi.getter(name="phase2Encryption")
    def phase2_encryption(self) -> Optional[pulumi.Input[str]]:
        """
        Phase two Encryption. Valid values: '3DES', 'AES-128-CBC', 'AES-192-CBC', 'AES-256-CBC', 'AES-128-GCM-64',
        'AES-128-GCM-96', 'AES-128-GCM-128', 'AES-256-GCM-64', 'AES-256-GCM-96', 'AES-256-GCM-128', and 'NULL-ENCR'.
        """
        return pulumi.get(self, "phase2_encryption")

    @phase2_encryption.setter
    def phase2_encryption(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phase2_encryption", value)

    @property
    @pulumi.getter(name="preSharedKey")
    def pre_shared_key(self) -> Optional[pulumi.Input[str]]:
        """
        If left blank, the pre-shared key will be auto generated.
        """
        return pulumi.get(self, "pre_shared_key")

    @pre_shared_key.setter
    def pre_shared_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pre_shared_key", value)

    @property
    @pulumi.getter(name="prependAsPaths")
    def prepend_as_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Connection AS Path Prepend customized by specifying AS PATH for a BGP connection.
        """
        return pulumi.get(self, "prepend_as_paths")

    @prepend_as_paths.setter
    def prepend_as_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "prepend_as_paths", value)

    @property
    @pulumi.getter(name="remoteSubnet")
    def remote_subnet(self) -> Optional[pulumi.Input[str]]:
        """
        Remote CIDRs joined as a string with ','. Required for a 'static' type connection.
        """
        return pulumi.get(self, "remote_subnet")

    @remote_subnet.setter
    def remote_subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_subnet", value)

    @property
    @pulumi.getter(name="remoteTunnelCidr")
    def remote_tunnel_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        Destination CIDR for the tunnel to the external device.
        """
        return pulumi.get(self, "remote_tunnel_cidr")

    @remote_tunnel_cidr.setter
    def remote_tunnel_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_tunnel_cidr", value)

    @property
    @pulumi.getter(name="tunnelProtocol")
    def tunnel_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Tunnel Protocol. Valid value: 'IPsec'. Default value: 'IPsec'. Case insensitive.
        """
        return pulumi.get(self, "tunnel_protocol")

    @tunnel_protocol.setter
    def tunnel_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tunnel_protocol", value)


@pulumi.input_type
class _Aviatrix_spoke_external_device_connState:
    def __init__(__self__, *,
                 approved_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backup_bgp_md5_key: Optional[pulumi.Input[str]] = None,
                 backup_bgp_remote_as_num: Optional[pulumi.Input[str]] = None,
                 backup_direct_connect: Optional[pulumi.Input[bool]] = None,
                 backup_local_tunnel_cidr: Optional[pulumi.Input[str]] = None,
                 backup_pre_shared_key: Optional[pulumi.Input[str]] = None,
                 backup_remote_gateway_ip: Optional[pulumi.Input[str]] = None,
                 backup_remote_tunnel_cidr: Optional[pulumi.Input[str]] = None,
                 bgp_local_as_num: Optional[pulumi.Input[str]] = None,
                 bgp_md5_key: Optional[pulumi.Input[str]] = None,
                 bgp_remote_as_num: Optional[pulumi.Input[str]] = None,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 connection_type: Optional[pulumi.Input[str]] = None,
                 custom_algorithms: Optional[pulumi.Input[bool]] = None,
                 direct_connect: Optional[pulumi.Input[bool]] = None,
                 enable_event_triggered_ha: Optional[pulumi.Input[bool]] = None,
                 enable_ikev2: Optional[pulumi.Input[bool]] = None,
                 enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 ha_enabled: Optional[pulumi.Input[bool]] = None,
                 local_tunnel_cidr: Optional[pulumi.Input[str]] = None,
                 manual_bgp_advertised_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 phase1_authentication: Optional[pulumi.Input[str]] = None,
                 phase1_dh_groups: Optional[pulumi.Input[str]] = None,
                 phase1_encryption: Optional[pulumi.Input[str]] = None,
                 phase1_remote_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 phase2_authentication: Optional[pulumi.Input[str]] = None,
                 phase2_dh_groups: Optional[pulumi.Input[str]] = None,
                 phase2_encryption: Optional[pulumi.Input[str]] = None,
                 pre_shared_key: Optional[pulumi.Input[str]] = None,
                 prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 remote_gateway_ip: Optional[pulumi.Input[str]] = None,
                 remote_subnet: Optional[pulumi.Input[str]] = None,
                 remote_tunnel_cidr: Optional[pulumi.Input[str]] = None,
                 tunnel_protocol: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Aviatrix_spoke_external_device_conn resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] approved_cidrs: Set of approved cidrs. Requires 'enable_learned_cidrs_approval' to be true. Type: Set(String).
        :param pulumi.Input[str] backup_bgp_md5_key: Backup BGP MD5 authentication key.
        :param pulumi.Input[str] backup_bgp_remote_as_num: Backup BGP remote ASN (Autonomous System Number). Integer between 1-4294967294.
        :param pulumi.Input[bool] backup_direct_connect: Backup direct connect for backup external device.
        :param pulumi.Input[str] backup_local_tunnel_cidr: Source CIDR for the tunnel from the backup Aviatrix spoke gateway.
        :param pulumi.Input[str] backup_pre_shared_key: Backup pre shared key.
        :param pulumi.Input[str] backup_remote_gateway_ip: Backup remote gateway IP.
        :param pulumi.Input[str] backup_remote_tunnel_cidr: Destination CIDR for the tunnel to the backup external device.
        :param pulumi.Input[str] bgp_local_as_num: BGP local ASN (Autonomous System Number). Integer between 1-4294967294.
        :param pulumi.Input[str] bgp_md5_key: BGP MD5 authentication key.
        :param pulumi.Input[str] bgp_remote_as_num: BGP remote ASN (Autonomous System Number). Integer between 1-4294967294.
        :param pulumi.Input[str] connection_name: The name of the spoke external device connection which is going to be created.
        :param pulumi.Input[str] connection_type: Connection type. Valid values: 'bgp', 'static'. Default value: 'bgp'.
        :param pulumi.Input[bool] custom_algorithms: Switch to enable custom/non-default algorithms for IPSec Authentication/Encryption.
        :param pulumi.Input[bool] direct_connect: Set true for private network infrastructure.
        :param pulumi.Input[bool] enable_event_triggered_ha: Enable Event Triggered HA.
        :param pulumi.Input[bool] enable_ikev2: Set as true if use IKEv2.
        :param pulumi.Input[bool] enable_learned_cidrs_approval: Enable learned CIDR approval for the connection. Only valid with 'connection_type' = 'bgp'. Requires the spoke_gateway's
               'learned_cidrs_approval_mode' attribute be set to 'connection'. Valid values: true, false. Default value: false.
        :param pulumi.Input[str] gw_name: Name of the BGP Spoke Gateway.
        :param pulumi.Input[bool] ha_enabled: Set as true if there are two external devices.
        :param pulumi.Input[str] local_tunnel_cidr: Source CIDR for the tunnel from the Aviatrix spoke gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] manual_bgp_advertised_cidrs: Configure manual BGP advertised CIDRs for this connection. Only valid with 'connection_type' = 'bgp'.
        :param pulumi.Input[str] phase1_authentication: Phase one Authentication. Valid values: 'SHA-1', 'SHA-256', 'SHA-384' and 'SHA-512'.
        :param pulumi.Input[str] phase1_dh_groups: Phase one DH Groups. Valid values: '1', '2', '5', '14', '15', '16', '17', '18', '19', '20' and '21'.
        :param pulumi.Input[str] phase1_encryption: Phase one Encryption. Valid values: '3DES', 'AES-128-CBC', 'AES-192-CBC' and 'AES-256-CBC', 'AES-128-GCM-64',
               'AES-128-GCM-96', 'AES-128-GCM-128', 'AES-256-GCM-64', 'AES-256-GCM-96', and 'AES-256-GCM-128'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] phase1_remote_identifiers: Phase 1 remote identifier of the IPsec tunnel.
        :param pulumi.Input[str] phase2_authentication: Phase two Authentication. Valid values: 'NO-AUTH', 'HMAC-SHA-1', 'HMAC-SHA-256', 'HMAC-SHA-384' and 'HMAC-SHA-512'.
        :param pulumi.Input[str] phase2_dh_groups: Phase two DH Groups. Valid values: '1', '2', '5', '14', '15', '16', '17', '18', '19', '20' and '21'.
        :param pulumi.Input[str] phase2_encryption: Phase two Encryption. Valid values: '3DES', 'AES-128-CBC', 'AES-192-CBC', 'AES-256-CBC', 'AES-128-GCM-64',
               'AES-128-GCM-96', 'AES-128-GCM-128', 'AES-256-GCM-64', 'AES-256-GCM-96', 'AES-256-GCM-128', and 'NULL-ENCR'.
        :param pulumi.Input[str] pre_shared_key: If left blank, the pre-shared key will be auto generated.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prepend_as_paths: Connection AS Path Prepend customized by specifying AS PATH for a BGP connection.
        :param pulumi.Input[str] remote_gateway_ip: Remote Gateway IP.
        :param pulumi.Input[str] remote_subnet: Remote CIDRs joined as a string with ','. Required for a 'static' type connection.
        :param pulumi.Input[str] remote_tunnel_cidr: Destination CIDR for the tunnel to the external device.
        :param pulumi.Input[str] tunnel_protocol: Tunnel Protocol. Valid value: 'IPsec'. Default value: 'IPsec'. Case insensitive.
        :param pulumi.Input[str] vpc_id: ID of the VPC where the BGP Spoke Gateway is located.
        """
        if approved_cidrs is not None:
            pulumi.set(__self__, "approved_cidrs", approved_cidrs)
        if backup_bgp_md5_key is not None:
            pulumi.set(__self__, "backup_bgp_md5_key", backup_bgp_md5_key)
        if backup_bgp_remote_as_num is not None:
            pulumi.set(__self__, "backup_bgp_remote_as_num", backup_bgp_remote_as_num)
        if backup_direct_connect is not None:
            pulumi.set(__self__, "backup_direct_connect", backup_direct_connect)
        if backup_local_tunnel_cidr is not None:
            pulumi.set(__self__, "backup_local_tunnel_cidr", backup_local_tunnel_cidr)
        if backup_pre_shared_key is not None:
            pulumi.set(__self__, "backup_pre_shared_key", backup_pre_shared_key)
        if backup_remote_gateway_ip is not None:
            pulumi.set(__self__, "backup_remote_gateway_ip", backup_remote_gateway_ip)
        if backup_remote_tunnel_cidr is not None:
            pulumi.set(__self__, "backup_remote_tunnel_cidr", backup_remote_tunnel_cidr)
        if bgp_local_as_num is not None:
            pulumi.set(__self__, "bgp_local_as_num", bgp_local_as_num)
        if bgp_md5_key is not None:
            pulumi.set(__self__, "bgp_md5_key", bgp_md5_key)
        if bgp_remote_as_num is not None:
            pulumi.set(__self__, "bgp_remote_as_num", bgp_remote_as_num)
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)
        if connection_type is not None:
            pulumi.set(__self__, "connection_type", connection_type)
        if custom_algorithms is not None:
            pulumi.set(__self__, "custom_algorithms", custom_algorithms)
        if direct_connect is not None:
            pulumi.set(__self__, "direct_connect", direct_connect)
        if enable_event_triggered_ha is not None:
            pulumi.set(__self__, "enable_event_triggered_ha", enable_event_triggered_ha)
        if enable_ikev2 is not None:
            pulumi.set(__self__, "enable_ikev2", enable_ikev2)
        if enable_learned_cidrs_approval is not None:
            pulumi.set(__self__, "enable_learned_cidrs_approval", enable_learned_cidrs_approval)
        if gw_name is not None:
            pulumi.set(__self__, "gw_name", gw_name)
        if ha_enabled is not None:
            pulumi.set(__self__, "ha_enabled", ha_enabled)
        if local_tunnel_cidr is not None:
            pulumi.set(__self__, "local_tunnel_cidr", local_tunnel_cidr)
        if manual_bgp_advertised_cidrs is not None:
            pulumi.set(__self__, "manual_bgp_advertised_cidrs", manual_bgp_advertised_cidrs)
        if phase1_authentication is not None:
            pulumi.set(__self__, "phase1_authentication", phase1_authentication)
        if phase1_dh_groups is not None:
            pulumi.set(__self__, "phase1_dh_groups", phase1_dh_groups)
        if phase1_encryption is not None:
            pulumi.set(__self__, "phase1_encryption", phase1_encryption)
        if phase1_remote_identifiers is not None:
            pulumi.set(__self__, "phase1_remote_identifiers", phase1_remote_identifiers)
        if phase2_authentication is not None:
            pulumi.set(__self__, "phase2_authentication", phase2_authentication)
        if phase2_dh_groups is not None:
            pulumi.set(__self__, "phase2_dh_groups", phase2_dh_groups)
        if phase2_encryption is not None:
            pulumi.set(__self__, "phase2_encryption", phase2_encryption)
        if pre_shared_key is not None:
            pulumi.set(__self__, "pre_shared_key", pre_shared_key)
        if prepend_as_paths is not None:
            pulumi.set(__self__, "prepend_as_paths", prepend_as_paths)
        if remote_gateway_ip is not None:
            pulumi.set(__self__, "remote_gateway_ip", remote_gateway_ip)
        if remote_subnet is not None:
            pulumi.set(__self__, "remote_subnet", remote_subnet)
        if remote_tunnel_cidr is not None:
            pulumi.set(__self__, "remote_tunnel_cidr", remote_tunnel_cidr)
        if tunnel_protocol is not None:
            pulumi.set(__self__, "tunnel_protocol", tunnel_protocol)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="approvedCidrs")
    def approved_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of approved cidrs. Requires 'enable_learned_cidrs_approval' to be true. Type: Set(String).
        """
        return pulumi.get(self, "approved_cidrs")

    @approved_cidrs.setter
    def approved_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "approved_cidrs", value)

    @property
    @pulumi.getter(name="backupBgpMd5Key")
    def backup_bgp_md5_key(self) -> Optional[pulumi.Input[str]]:
        """
        Backup BGP MD5 authentication key.
        """
        return pulumi.get(self, "backup_bgp_md5_key")

    @backup_bgp_md5_key.setter
    def backup_bgp_md5_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_bgp_md5_key", value)

    @property
    @pulumi.getter(name="backupBgpRemoteAsNum")
    def backup_bgp_remote_as_num(self) -> Optional[pulumi.Input[str]]:
        """
        Backup BGP remote ASN (Autonomous System Number). Integer between 1-4294967294.
        """
        return pulumi.get(self, "backup_bgp_remote_as_num")

    @backup_bgp_remote_as_num.setter
    def backup_bgp_remote_as_num(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_bgp_remote_as_num", value)

    @property
    @pulumi.getter(name="backupDirectConnect")
    def backup_direct_connect(self) -> Optional[pulumi.Input[bool]]:
        """
        Backup direct connect for backup external device.
        """
        return pulumi.get(self, "backup_direct_connect")

    @backup_direct_connect.setter
    def backup_direct_connect(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "backup_direct_connect", value)

    @property
    @pulumi.getter(name="backupLocalTunnelCidr")
    def backup_local_tunnel_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        Source CIDR for the tunnel from the backup Aviatrix spoke gateway.
        """
        return pulumi.get(self, "backup_local_tunnel_cidr")

    @backup_local_tunnel_cidr.setter
    def backup_local_tunnel_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_local_tunnel_cidr", value)

    @property
    @pulumi.getter(name="backupPreSharedKey")
    def backup_pre_shared_key(self) -> Optional[pulumi.Input[str]]:
        """
        Backup pre shared key.
        """
        return pulumi.get(self, "backup_pre_shared_key")

    @backup_pre_shared_key.setter
    def backup_pre_shared_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_pre_shared_key", value)

    @property
    @pulumi.getter(name="backupRemoteGatewayIp")
    def backup_remote_gateway_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Backup remote gateway IP.
        """
        return pulumi.get(self, "backup_remote_gateway_ip")

    @backup_remote_gateway_ip.setter
    def backup_remote_gateway_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_remote_gateway_ip", value)

    @property
    @pulumi.getter(name="backupRemoteTunnelCidr")
    def backup_remote_tunnel_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        Destination CIDR for the tunnel to the backup external device.
        """
        return pulumi.get(self, "backup_remote_tunnel_cidr")

    @backup_remote_tunnel_cidr.setter
    def backup_remote_tunnel_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_remote_tunnel_cidr", value)

    @property
    @pulumi.getter(name="bgpLocalAsNum")
    def bgp_local_as_num(self) -> Optional[pulumi.Input[str]]:
        """
        BGP local ASN (Autonomous System Number). Integer between 1-4294967294.
        """
        return pulumi.get(self, "bgp_local_as_num")

    @bgp_local_as_num.setter
    def bgp_local_as_num(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bgp_local_as_num", value)

    @property
    @pulumi.getter(name="bgpMd5Key")
    def bgp_md5_key(self) -> Optional[pulumi.Input[str]]:
        """
        BGP MD5 authentication key.
        """
        return pulumi.get(self, "bgp_md5_key")

    @bgp_md5_key.setter
    def bgp_md5_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bgp_md5_key", value)

    @property
    @pulumi.getter(name="bgpRemoteAsNum")
    def bgp_remote_as_num(self) -> Optional[pulumi.Input[str]]:
        """
        BGP remote ASN (Autonomous System Number). Integer between 1-4294967294.
        """
        return pulumi.get(self, "bgp_remote_as_num")

    @bgp_remote_as_num.setter
    def bgp_remote_as_num(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bgp_remote_as_num", value)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the spoke external device connection which is going to be created.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_name", value)

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[pulumi.Input[str]]:
        """
        Connection type. Valid values: 'bgp', 'static'. Default value: 'bgp'.
        """
        return pulumi.get(self, "connection_type")

    @connection_type.setter
    def connection_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_type", value)

    @property
    @pulumi.getter(name="customAlgorithms")
    def custom_algorithms(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable custom/non-default algorithms for IPSec Authentication/Encryption.
        """
        return pulumi.get(self, "custom_algorithms")

    @custom_algorithms.setter
    def custom_algorithms(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "custom_algorithms", value)

    @property
    @pulumi.getter(name="directConnect")
    def direct_connect(self) -> Optional[pulumi.Input[bool]]:
        """
        Set true for private network infrastructure.
        """
        return pulumi.get(self, "direct_connect")

    @direct_connect.setter
    def direct_connect(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "direct_connect", value)

    @property
    @pulumi.getter(name="enableEventTriggeredHa")
    def enable_event_triggered_ha(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Event Triggered HA.
        """
        return pulumi.get(self, "enable_event_triggered_ha")

    @enable_event_triggered_ha.setter
    def enable_event_triggered_ha(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_event_triggered_ha", value)

    @property
    @pulumi.getter(name="enableIkev2")
    def enable_ikev2(self) -> Optional[pulumi.Input[bool]]:
        """
        Set as true if use IKEv2.
        """
        return pulumi.get(self, "enable_ikev2")

    @enable_ikev2.setter
    def enable_ikev2(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ikev2", value)

    @property
    @pulumi.getter(name="enableLearnedCidrsApproval")
    def enable_learned_cidrs_approval(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable learned CIDR approval for the connection. Only valid with 'connection_type' = 'bgp'. Requires the spoke_gateway's
        'learned_cidrs_approval_mode' attribute be set to 'connection'. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_learned_cidrs_approval")

    @enable_learned_cidrs_approval.setter
    def enable_learned_cidrs_approval(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_learned_cidrs_approval", value)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the BGP Spoke Gateway.
        """
        return pulumi.get(self, "gw_name")

    @gw_name.setter
    def gw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gw_name", value)

    @property
    @pulumi.getter(name="haEnabled")
    def ha_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Set as true if there are two external devices.
        """
        return pulumi.get(self, "ha_enabled")

    @ha_enabled.setter
    def ha_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ha_enabled", value)

    @property
    @pulumi.getter(name="localTunnelCidr")
    def local_tunnel_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        Source CIDR for the tunnel from the Aviatrix spoke gateway.
        """
        return pulumi.get(self, "local_tunnel_cidr")

    @local_tunnel_cidr.setter
    def local_tunnel_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_tunnel_cidr", value)

    @property
    @pulumi.getter(name="manualBgpAdvertisedCidrs")
    def manual_bgp_advertised_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Configure manual BGP advertised CIDRs for this connection. Only valid with 'connection_type' = 'bgp'.
        """
        return pulumi.get(self, "manual_bgp_advertised_cidrs")

    @manual_bgp_advertised_cidrs.setter
    def manual_bgp_advertised_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "manual_bgp_advertised_cidrs", value)

    @property
    @pulumi.getter(name="phase1Authentication")
    def phase1_authentication(self) -> Optional[pulumi.Input[str]]:
        """
        Phase one Authentication. Valid values: 'SHA-1', 'SHA-256', 'SHA-384' and 'SHA-512'.
        """
        return pulumi.get(self, "phase1_authentication")

    @phase1_authentication.setter
    def phase1_authentication(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phase1_authentication", value)

    @property
    @pulumi.getter(name="phase1DhGroups")
    def phase1_dh_groups(self) -> Optional[pulumi.Input[str]]:
        """
        Phase one DH Groups. Valid values: '1', '2', '5', '14', '15', '16', '17', '18', '19', '20' and '21'.
        """
        return pulumi.get(self, "phase1_dh_groups")

    @phase1_dh_groups.setter
    def phase1_dh_groups(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phase1_dh_groups", value)

    @property
    @pulumi.getter(name="phase1Encryption")
    def phase1_encryption(self) -> Optional[pulumi.Input[str]]:
        """
        Phase one Encryption. Valid values: '3DES', 'AES-128-CBC', 'AES-192-CBC' and 'AES-256-CBC', 'AES-128-GCM-64',
        'AES-128-GCM-96', 'AES-128-GCM-128', 'AES-256-GCM-64', 'AES-256-GCM-96', and 'AES-256-GCM-128'.
        """
        return pulumi.get(self, "phase1_encryption")

    @phase1_encryption.setter
    def phase1_encryption(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phase1_encryption", value)

    @property
    @pulumi.getter(name="phase1RemoteIdentifiers")
    def phase1_remote_identifiers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Phase 1 remote identifier of the IPsec tunnel.
        """
        return pulumi.get(self, "phase1_remote_identifiers")

    @phase1_remote_identifiers.setter
    def phase1_remote_identifiers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "phase1_remote_identifiers", value)

    @property
    @pulumi.getter(name="phase2Authentication")
    def phase2_authentication(self) -> Optional[pulumi.Input[str]]:
        """
        Phase two Authentication. Valid values: 'NO-AUTH', 'HMAC-SHA-1', 'HMAC-SHA-256', 'HMAC-SHA-384' and 'HMAC-SHA-512'.
        """
        return pulumi.get(self, "phase2_authentication")

    @phase2_authentication.setter
    def phase2_authentication(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phase2_authentication", value)

    @property
    @pulumi.getter(name="phase2DhGroups")
    def phase2_dh_groups(self) -> Optional[pulumi.Input[str]]:
        """
        Phase two DH Groups. Valid values: '1', '2', '5', '14', '15', '16', '17', '18', '19', '20' and '21'.
        """
        return pulumi.get(self, "phase2_dh_groups")

    @phase2_dh_groups.setter
    def phase2_dh_groups(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phase2_dh_groups", value)

    @property
    @pulumi.getter(name="phase2Encryption")
    def phase2_encryption(self) -> Optional[pulumi.Input[str]]:
        """
        Phase two Encryption. Valid values: '3DES', 'AES-128-CBC', 'AES-192-CBC', 'AES-256-CBC', 'AES-128-GCM-64',
        'AES-128-GCM-96', 'AES-128-GCM-128', 'AES-256-GCM-64', 'AES-256-GCM-96', 'AES-256-GCM-128', and 'NULL-ENCR'.
        """
        return pulumi.get(self, "phase2_encryption")

    @phase2_encryption.setter
    def phase2_encryption(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phase2_encryption", value)

    @property
    @pulumi.getter(name="preSharedKey")
    def pre_shared_key(self) -> Optional[pulumi.Input[str]]:
        """
        If left blank, the pre-shared key will be auto generated.
        """
        return pulumi.get(self, "pre_shared_key")

    @pre_shared_key.setter
    def pre_shared_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pre_shared_key", value)

    @property
    @pulumi.getter(name="prependAsPaths")
    def prepend_as_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Connection AS Path Prepend customized by specifying AS PATH for a BGP connection.
        """
        return pulumi.get(self, "prepend_as_paths")

    @prepend_as_paths.setter
    def prepend_as_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "prepend_as_paths", value)

    @property
    @pulumi.getter(name="remoteGatewayIp")
    def remote_gateway_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Remote Gateway IP.
        """
        return pulumi.get(self, "remote_gateway_ip")

    @remote_gateway_ip.setter
    def remote_gateway_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_gateway_ip", value)

    @property
    @pulumi.getter(name="remoteSubnet")
    def remote_subnet(self) -> Optional[pulumi.Input[str]]:
        """
        Remote CIDRs joined as a string with ','. Required for a 'static' type connection.
        """
        return pulumi.get(self, "remote_subnet")

    @remote_subnet.setter
    def remote_subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_subnet", value)

    @property
    @pulumi.getter(name="remoteTunnelCidr")
    def remote_tunnel_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        Destination CIDR for the tunnel to the external device.
        """
        return pulumi.get(self, "remote_tunnel_cidr")

    @remote_tunnel_cidr.setter
    def remote_tunnel_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_tunnel_cidr", value)

    @property
    @pulumi.getter(name="tunnelProtocol")
    def tunnel_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Tunnel Protocol. Valid value: 'IPsec'. Default value: 'IPsec'. Case insensitive.
        """
        return pulumi.get(self, "tunnel_protocol")

    @tunnel_protocol.setter
    def tunnel_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tunnel_protocol", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the VPC where the BGP Spoke Gateway is located.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class Aviatrix_spoke_external_device_conn(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approved_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backup_bgp_md5_key: Optional[pulumi.Input[str]] = None,
                 backup_bgp_remote_as_num: Optional[pulumi.Input[str]] = None,
                 backup_direct_connect: Optional[pulumi.Input[bool]] = None,
                 backup_local_tunnel_cidr: Optional[pulumi.Input[str]] = None,
                 backup_pre_shared_key: Optional[pulumi.Input[str]] = None,
                 backup_remote_gateway_ip: Optional[pulumi.Input[str]] = None,
                 backup_remote_tunnel_cidr: Optional[pulumi.Input[str]] = None,
                 bgp_local_as_num: Optional[pulumi.Input[str]] = None,
                 bgp_md5_key: Optional[pulumi.Input[str]] = None,
                 bgp_remote_as_num: Optional[pulumi.Input[str]] = None,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 connection_type: Optional[pulumi.Input[str]] = None,
                 custom_algorithms: Optional[pulumi.Input[bool]] = None,
                 direct_connect: Optional[pulumi.Input[bool]] = None,
                 enable_event_triggered_ha: Optional[pulumi.Input[bool]] = None,
                 enable_ikev2: Optional[pulumi.Input[bool]] = None,
                 enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 ha_enabled: Optional[pulumi.Input[bool]] = None,
                 local_tunnel_cidr: Optional[pulumi.Input[str]] = None,
                 manual_bgp_advertised_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 phase1_authentication: Optional[pulumi.Input[str]] = None,
                 phase1_dh_groups: Optional[pulumi.Input[str]] = None,
                 phase1_encryption: Optional[pulumi.Input[str]] = None,
                 phase1_remote_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 phase2_authentication: Optional[pulumi.Input[str]] = None,
                 phase2_dh_groups: Optional[pulumi.Input[str]] = None,
                 phase2_encryption: Optional[pulumi.Input[str]] = None,
                 pre_shared_key: Optional[pulumi.Input[str]] = None,
                 prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 remote_gateway_ip: Optional[pulumi.Input[str]] = None,
                 remote_subnet: Optional[pulumi.Input[str]] = None,
                 remote_tunnel_cidr: Optional[pulumi.Input[str]] = None,
                 tunnel_protocol: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a Aviatrix_spoke_external_device_conn resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] approved_cidrs: Set of approved cidrs. Requires 'enable_learned_cidrs_approval' to be true. Type: Set(String).
        :param pulumi.Input[str] backup_bgp_md5_key: Backup BGP MD5 authentication key.
        :param pulumi.Input[str] backup_bgp_remote_as_num: Backup BGP remote ASN (Autonomous System Number). Integer between 1-4294967294.
        :param pulumi.Input[bool] backup_direct_connect: Backup direct connect for backup external device.
        :param pulumi.Input[str] backup_local_tunnel_cidr: Source CIDR for the tunnel from the backup Aviatrix spoke gateway.
        :param pulumi.Input[str] backup_pre_shared_key: Backup pre shared key.
        :param pulumi.Input[str] backup_remote_gateway_ip: Backup remote gateway IP.
        :param pulumi.Input[str] backup_remote_tunnel_cidr: Destination CIDR for the tunnel to the backup external device.
        :param pulumi.Input[str] bgp_local_as_num: BGP local ASN (Autonomous System Number). Integer between 1-4294967294.
        :param pulumi.Input[str] bgp_md5_key: BGP MD5 authentication key.
        :param pulumi.Input[str] bgp_remote_as_num: BGP remote ASN (Autonomous System Number). Integer between 1-4294967294.
        :param pulumi.Input[str] connection_name: The name of the spoke external device connection which is going to be created.
        :param pulumi.Input[str] connection_type: Connection type. Valid values: 'bgp', 'static'. Default value: 'bgp'.
        :param pulumi.Input[bool] custom_algorithms: Switch to enable custom/non-default algorithms for IPSec Authentication/Encryption.
        :param pulumi.Input[bool] direct_connect: Set true for private network infrastructure.
        :param pulumi.Input[bool] enable_event_triggered_ha: Enable Event Triggered HA.
        :param pulumi.Input[bool] enable_ikev2: Set as true if use IKEv2.
        :param pulumi.Input[bool] enable_learned_cidrs_approval: Enable learned CIDR approval for the connection. Only valid with 'connection_type' = 'bgp'. Requires the spoke_gateway's
               'learned_cidrs_approval_mode' attribute be set to 'connection'. Valid values: true, false. Default value: false.
        :param pulumi.Input[str] gw_name: Name of the BGP Spoke Gateway.
        :param pulumi.Input[bool] ha_enabled: Set as true if there are two external devices.
        :param pulumi.Input[str] local_tunnel_cidr: Source CIDR for the tunnel from the Aviatrix spoke gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] manual_bgp_advertised_cidrs: Configure manual BGP advertised CIDRs for this connection. Only valid with 'connection_type' = 'bgp'.
        :param pulumi.Input[str] phase1_authentication: Phase one Authentication. Valid values: 'SHA-1', 'SHA-256', 'SHA-384' and 'SHA-512'.
        :param pulumi.Input[str] phase1_dh_groups: Phase one DH Groups. Valid values: '1', '2', '5', '14', '15', '16', '17', '18', '19', '20' and '21'.
        :param pulumi.Input[str] phase1_encryption: Phase one Encryption. Valid values: '3DES', 'AES-128-CBC', 'AES-192-CBC' and 'AES-256-CBC', 'AES-128-GCM-64',
               'AES-128-GCM-96', 'AES-128-GCM-128', 'AES-256-GCM-64', 'AES-256-GCM-96', and 'AES-256-GCM-128'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] phase1_remote_identifiers: Phase 1 remote identifier of the IPsec tunnel.
        :param pulumi.Input[str] phase2_authentication: Phase two Authentication. Valid values: 'NO-AUTH', 'HMAC-SHA-1', 'HMAC-SHA-256', 'HMAC-SHA-384' and 'HMAC-SHA-512'.
        :param pulumi.Input[str] phase2_dh_groups: Phase two DH Groups. Valid values: '1', '2', '5', '14', '15', '16', '17', '18', '19', '20' and '21'.
        :param pulumi.Input[str] phase2_encryption: Phase two Encryption. Valid values: '3DES', 'AES-128-CBC', 'AES-192-CBC', 'AES-256-CBC', 'AES-128-GCM-64',
               'AES-128-GCM-96', 'AES-128-GCM-128', 'AES-256-GCM-64', 'AES-256-GCM-96', 'AES-256-GCM-128', and 'NULL-ENCR'.
        :param pulumi.Input[str] pre_shared_key: If left blank, the pre-shared key will be auto generated.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prepend_as_paths: Connection AS Path Prepend customized by specifying AS PATH for a BGP connection.
        :param pulumi.Input[str] remote_gateway_ip: Remote Gateway IP.
        :param pulumi.Input[str] remote_subnet: Remote CIDRs joined as a string with ','. Required for a 'static' type connection.
        :param pulumi.Input[str] remote_tunnel_cidr: Destination CIDR for the tunnel to the external device.
        :param pulumi.Input[str] tunnel_protocol: Tunnel Protocol. Valid value: 'IPsec'. Default value: 'IPsec'. Case insensitive.
        :param pulumi.Input[str] vpc_id: ID of the VPC where the BGP Spoke Gateway is located.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Aviatrix_spoke_external_device_connArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Aviatrix_spoke_external_device_conn resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param Aviatrix_spoke_external_device_connArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(Aviatrix_spoke_external_device_connArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approved_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backup_bgp_md5_key: Optional[pulumi.Input[str]] = None,
                 backup_bgp_remote_as_num: Optional[pulumi.Input[str]] = None,
                 backup_direct_connect: Optional[pulumi.Input[bool]] = None,
                 backup_local_tunnel_cidr: Optional[pulumi.Input[str]] = None,
                 backup_pre_shared_key: Optional[pulumi.Input[str]] = None,
                 backup_remote_gateway_ip: Optional[pulumi.Input[str]] = None,
                 backup_remote_tunnel_cidr: Optional[pulumi.Input[str]] = None,
                 bgp_local_as_num: Optional[pulumi.Input[str]] = None,
                 bgp_md5_key: Optional[pulumi.Input[str]] = None,
                 bgp_remote_as_num: Optional[pulumi.Input[str]] = None,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 connection_type: Optional[pulumi.Input[str]] = None,
                 custom_algorithms: Optional[pulumi.Input[bool]] = None,
                 direct_connect: Optional[pulumi.Input[bool]] = None,
                 enable_event_triggered_ha: Optional[pulumi.Input[bool]] = None,
                 enable_ikev2: Optional[pulumi.Input[bool]] = None,
                 enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 ha_enabled: Optional[pulumi.Input[bool]] = None,
                 local_tunnel_cidr: Optional[pulumi.Input[str]] = None,
                 manual_bgp_advertised_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 phase1_authentication: Optional[pulumi.Input[str]] = None,
                 phase1_dh_groups: Optional[pulumi.Input[str]] = None,
                 phase1_encryption: Optional[pulumi.Input[str]] = None,
                 phase1_remote_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 phase2_authentication: Optional[pulumi.Input[str]] = None,
                 phase2_dh_groups: Optional[pulumi.Input[str]] = None,
                 phase2_encryption: Optional[pulumi.Input[str]] = None,
                 pre_shared_key: Optional[pulumi.Input[str]] = None,
                 prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 remote_gateway_ip: Optional[pulumi.Input[str]] = None,
                 remote_subnet: Optional[pulumi.Input[str]] = None,
                 remote_tunnel_cidr: Optional[pulumi.Input[str]] = None,
                 tunnel_protocol: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = Aviatrix_spoke_external_device_connArgs.__new__(Aviatrix_spoke_external_device_connArgs)

            __props__.__dict__["approved_cidrs"] = approved_cidrs
            __props__.__dict__["backup_bgp_md5_key"] = backup_bgp_md5_key
            __props__.__dict__["backup_bgp_remote_as_num"] = backup_bgp_remote_as_num
            __props__.__dict__["backup_direct_connect"] = backup_direct_connect
            __props__.__dict__["backup_local_tunnel_cidr"] = backup_local_tunnel_cidr
            __props__.__dict__["backup_pre_shared_key"] = backup_pre_shared_key
            __props__.__dict__["backup_remote_gateway_ip"] = backup_remote_gateway_ip
            __props__.__dict__["backup_remote_tunnel_cidr"] = backup_remote_tunnel_cidr
            __props__.__dict__["bgp_local_as_num"] = bgp_local_as_num
            __props__.__dict__["bgp_md5_key"] = bgp_md5_key
            __props__.__dict__["bgp_remote_as_num"] = bgp_remote_as_num
            if connection_name is None and not opts.urn:
                raise TypeError("Missing required property 'connection_name'")
            __props__.__dict__["connection_name"] = connection_name
            __props__.__dict__["connection_type"] = connection_type
            __props__.__dict__["custom_algorithms"] = custom_algorithms
            __props__.__dict__["direct_connect"] = direct_connect
            __props__.__dict__["enable_event_triggered_ha"] = enable_event_triggered_ha
            __props__.__dict__["enable_ikev2"] = enable_ikev2
            __props__.__dict__["enable_learned_cidrs_approval"] = enable_learned_cidrs_approval
            if gw_name is None and not opts.urn:
                raise TypeError("Missing required property 'gw_name'")
            __props__.__dict__["gw_name"] = gw_name
            __props__.__dict__["ha_enabled"] = ha_enabled
            __props__.__dict__["local_tunnel_cidr"] = local_tunnel_cidr
            __props__.__dict__["manual_bgp_advertised_cidrs"] = manual_bgp_advertised_cidrs
            __props__.__dict__["phase1_authentication"] = phase1_authentication
            __props__.__dict__["phase1_dh_groups"] = phase1_dh_groups
            __props__.__dict__["phase1_encryption"] = phase1_encryption
            __props__.__dict__["phase1_remote_identifiers"] = phase1_remote_identifiers
            __props__.__dict__["phase2_authentication"] = phase2_authentication
            __props__.__dict__["phase2_dh_groups"] = phase2_dh_groups
            __props__.__dict__["phase2_encryption"] = phase2_encryption
            __props__.__dict__["pre_shared_key"] = pre_shared_key
            __props__.__dict__["prepend_as_paths"] = prepend_as_paths
            if remote_gateway_ip is None and not opts.urn:
                raise TypeError("Missing required property 'remote_gateway_ip'")
            __props__.__dict__["remote_gateway_ip"] = remote_gateway_ip
            __props__.__dict__["remote_subnet"] = remote_subnet
            __props__.__dict__["remote_tunnel_cidr"] = remote_tunnel_cidr
            __props__.__dict__["tunnel_protocol"] = tunnel_protocol
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
        super(Aviatrix_spoke_external_device_conn, __self__).__init__(
            'aviatrix:index/aviatrix_spoke_external_device_conn:aviatrix_spoke_external_device_conn',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            approved_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            backup_bgp_md5_key: Optional[pulumi.Input[str]] = None,
            backup_bgp_remote_as_num: Optional[pulumi.Input[str]] = None,
            backup_direct_connect: Optional[pulumi.Input[bool]] = None,
            backup_local_tunnel_cidr: Optional[pulumi.Input[str]] = None,
            backup_pre_shared_key: Optional[pulumi.Input[str]] = None,
            backup_remote_gateway_ip: Optional[pulumi.Input[str]] = None,
            backup_remote_tunnel_cidr: Optional[pulumi.Input[str]] = None,
            bgp_local_as_num: Optional[pulumi.Input[str]] = None,
            bgp_md5_key: Optional[pulumi.Input[str]] = None,
            bgp_remote_as_num: Optional[pulumi.Input[str]] = None,
            connection_name: Optional[pulumi.Input[str]] = None,
            connection_type: Optional[pulumi.Input[str]] = None,
            custom_algorithms: Optional[pulumi.Input[bool]] = None,
            direct_connect: Optional[pulumi.Input[bool]] = None,
            enable_event_triggered_ha: Optional[pulumi.Input[bool]] = None,
            enable_ikev2: Optional[pulumi.Input[bool]] = None,
            enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
            gw_name: Optional[pulumi.Input[str]] = None,
            ha_enabled: Optional[pulumi.Input[bool]] = None,
            local_tunnel_cidr: Optional[pulumi.Input[str]] = None,
            manual_bgp_advertised_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            phase1_authentication: Optional[pulumi.Input[str]] = None,
            phase1_dh_groups: Optional[pulumi.Input[str]] = None,
            phase1_encryption: Optional[pulumi.Input[str]] = None,
            phase1_remote_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            phase2_authentication: Optional[pulumi.Input[str]] = None,
            phase2_dh_groups: Optional[pulumi.Input[str]] = None,
            phase2_encryption: Optional[pulumi.Input[str]] = None,
            pre_shared_key: Optional[pulumi.Input[str]] = None,
            prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            remote_gateway_ip: Optional[pulumi.Input[str]] = None,
            remote_subnet: Optional[pulumi.Input[str]] = None,
            remote_tunnel_cidr: Optional[pulumi.Input[str]] = None,
            tunnel_protocol: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'Aviatrix_spoke_external_device_conn':
        """
        Get an existing Aviatrix_spoke_external_device_conn resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] approved_cidrs: Set of approved cidrs. Requires 'enable_learned_cidrs_approval' to be true. Type: Set(String).
        :param pulumi.Input[str] backup_bgp_md5_key: Backup BGP MD5 authentication key.
        :param pulumi.Input[str] backup_bgp_remote_as_num: Backup BGP remote ASN (Autonomous System Number). Integer between 1-4294967294.
        :param pulumi.Input[bool] backup_direct_connect: Backup direct connect for backup external device.
        :param pulumi.Input[str] backup_local_tunnel_cidr: Source CIDR for the tunnel from the backup Aviatrix spoke gateway.
        :param pulumi.Input[str] backup_pre_shared_key: Backup pre shared key.
        :param pulumi.Input[str] backup_remote_gateway_ip: Backup remote gateway IP.
        :param pulumi.Input[str] backup_remote_tunnel_cidr: Destination CIDR for the tunnel to the backup external device.
        :param pulumi.Input[str] bgp_local_as_num: BGP local ASN (Autonomous System Number). Integer between 1-4294967294.
        :param pulumi.Input[str] bgp_md5_key: BGP MD5 authentication key.
        :param pulumi.Input[str] bgp_remote_as_num: BGP remote ASN (Autonomous System Number). Integer between 1-4294967294.
        :param pulumi.Input[str] connection_name: The name of the spoke external device connection which is going to be created.
        :param pulumi.Input[str] connection_type: Connection type. Valid values: 'bgp', 'static'. Default value: 'bgp'.
        :param pulumi.Input[bool] custom_algorithms: Switch to enable custom/non-default algorithms for IPSec Authentication/Encryption.
        :param pulumi.Input[bool] direct_connect: Set true for private network infrastructure.
        :param pulumi.Input[bool] enable_event_triggered_ha: Enable Event Triggered HA.
        :param pulumi.Input[bool] enable_ikev2: Set as true if use IKEv2.
        :param pulumi.Input[bool] enable_learned_cidrs_approval: Enable learned CIDR approval for the connection. Only valid with 'connection_type' = 'bgp'. Requires the spoke_gateway's
               'learned_cidrs_approval_mode' attribute be set to 'connection'. Valid values: true, false. Default value: false.
        :param pulumi.Input[str] gw_name: Name of the BGP Spoke Gateway.
        :param pulumi.Input[bool] ha_enabled: Set as true if there are two external devices.
        :param pulumi.Input[str] local_tunnel_cidr: Source CIDR for the tunnel from the Aviatrix spoke gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] manual_bgp_advertised_cidrs: Configure manual BGP advertised CIDRs for this connection. Only valid with 'connection_type' = 'bgp'.
        :param pulumi.Input[str] phase1_authentication: Phase one Authentication. Valid values: 'SHA-1', 'SHA-256', 'SHA-384' and 'SHA-512'.
        :param pulumi.Input[str] phase1_dh_groups: Phase one DH Groups. Valid values: '1', '2', '5', '14', '15', '16', '17', '18', '19', '20' and '21'.
        :param pulumi.Input[str] phase1_encryption: Phase one Encryption. Valid values: '3DES', 'AES-128-CBC', 'AES-192-CBC' and 'AES-256-CBC', 'AES-128-GCM-64',
               'AES-128-GCM-96', 'AES-128-GCM-128', 'AES-256-GCM-64', 'AES-256-GCM-96', and 'AES-256-GCM-128'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] phase1_remote_identifiers: Phase 1 remote identifier of the IPsec tunnel.
        :param pulumi.Input[str] phase2_authentication: Phase two Authentication. Valid values: 'NO-AUTH', 'HMAC-SHA-1', 'HMAC-SHA-256', 'HMAC-SHA-384' and 'HMAC-SHA-512'.
        :param pulumi.Input[str] phase2_dh_groups: Phase two DH Groups. Valid values: '1', '2', '5', '14', '15', '16', '17', '18', '19', '20' and '21'.
        :param pulumi.Input[str] phase2_encryption: Phase two Encryption. Valid values: '3DES', 'AES-128-CBC', 'AES-192-CBC', 'AES-256-CBC', 'AES-128-GCM-64',
               'AES-128-GCM-96', 'AES-128-GCM-128', 'AES-256-GCM-64', 'AES-256-GCM-96', 'AES-256-GCM-128', and 'NULL-ENCR'.
        :param pulumi.Input[str] pre_shared_key: If left blank, the pre-shared key will be auto generated.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prepend_as_paths: Connection AS Path Prepend customized by specifying AS PATH for a BGP connection.
        :param pulumi.Input[str] remote_gateway_ip: Remote Gateway IP.
        :param pulumi.Input[str] remote_subnet: Remote CIDRs joined as a string with ','. Required for a 'static' type connection.
        :param pulumi.Input[str] remote_tunnel_cidr: Destination CIDR for the tunnel to the external device.
        :param pulumi.Input[str] tunnel_protocol: Tunnel Protocol. Valid value: 'IPsec'. Default value: 'IPsec'. Case insensitive.
        :param pulumi.Input[str] vpc_id: ID of the VPC where the BGP Spoke Gateway is located.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _Aviatrix_spoke_external_device_connState.__new__(_Aviatrix_spoke_external_device_connState)

        __props__.__dict__["approved_cidrs"] = approved_cidrs
        __props__.__dict__["backup_bgp_md5_key"] = backup_bgp_md5_key
        __props__.__dict__["backup_bgp_remote_as_num"] = backup_bgp_remote_as_num
        __props__.__dict__["backup_direct_connect"] = backup_direct_connect
        __props__.__dict__["backup_local_tunnel_cidr"] = backup_local_tunnel_cidr
        __props__.__dict__["backup_pre_shared_key"] = backup_pre_shared_key
        __props__.__dict__["backup_remote_gateway_ip"] = backup_remote_gateway_ip
        __props__.__dict__["backup_remote_tunnel_cidr"] = backup_remote_tunnel_cidr
        __props__.__dict__["bgp_local_as_num"] = bgp_local_as_num
        __props__.__dict__["bgp_md5_key"] = bgp_md5_key
        __props__.__dict__["bgp_remote_as_num"] = bgp_remote_as_num
        __props__.__dict__["connection_name"] = connection_name
        __props__.__dict__["connection_type"] = connection_type
        __props__.__dict__["custom_algorithms"] = custom_algorithms
        __props__.__dict__["direct_connect"] = direct_connect
        __props__.__dict__["enable_event_triggered_ha"] = enable_event_triggered_ha
        __props__.__dict__["enable_ikev2"] = enable_ikev2
        __props__.__dict__["enable_learned_cidrs_approval"] = enable_learned_cidrs_approval
        __props__.__dict__["gw_name"] = gw_name
        __props__.__dict__["ha_enabled"] = ha_enabled
        __props__.__dict__["local_tunnel_cidr"] = local_tunnel_cidr
        __props__.__dict__["manual_bgp_advertised_cidrs"] = manual_bgp_advertised_cidrs
        __props__.__dict__["phase1_authentication"] = phase1_authentication
        __props__.__dict__["phase1_dh_groups"] = phase1_dh_groups
        __props__.__dict__["phase1_encryption"] = phase1_encryption
        __props__.__dict__["phase1_remote_identifiers"] = phase1_remote_identifiers
        __props__.__dict__["phase2_authentication"] = phase2_authentication
        __props__.__dict__["phase2_dh_groups"] = phase2_dh_groups
        __props__.__dict__["phase2_encryption"] = phase2_encryption
        __props__.__dict__["pre_shared_key"] = pre_shared_key
        __props__.__dict__["prepend_as_paths"] = prepend_as_paths
        __props__.__dict__["remote_gateway_ip"] = remote_gateway_ip
        __props__.__dict__["remote_subnet"] = remote_subnet
        __props__.__dict__["remote_tunnel_cidr"] = remote_tunnel_cidr
        __props__.__dict__["tunnel_protocol"] = tunnel_protocol
        __props__.__dict__["vpc_id"] = vpc_id
        return Aviatrix_spoke_external_device_conn(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="approvedCidrs")
    def approved_cidrs(self) -> pulumi.Output[Sequence[str]]:
        """
        Set of approved cidrs. Requires 'enable_learned_cidrs_approval' to be true. Type: Set(String).
        """
        return pulumi.get(self, "approved_cidrs")

    @property
    @pulumi.getter(name="backupBgpMd5Key")
    def backup_bgp_md5_key(self) -> pulumi.Output[Optional[str]]:
        """
        Backup BGP MD5 authentication key.
        """
        return pulumi.get(self, "backup_bgp_md5_key")

    @property
    @pulumi.getter(name="backupBgpRemoteAsNum")
    def backup_bgp_remote_as_num(self) -> pulumi.Output[Optional[str]]:
        """
        Backup BGP remote ASN (Autonomous System Number). Integer between 1-4294967294.
        """
        return pulumi.get(self, "backup_bgp_remote_as_num")

    @property
    @pulumi.getter(name="backupDirectConnect")
    def backup_direct_connect(self) -> pulumi.Output[Optional[bool]]:
        """
        Backup direct connect for backup external device.
        """
        return pulumi.get(self, "backup_direct_connect")

    @property
    @pulumi.getter(name="backupLocalTunnelCidr")
    def backup_local_tunnel_cidr(self) -> pulumi.Output[str]:
        """
        Source CIDR for the tunnel from the backup Aviatrix spoke gateway.
        """
        return pulumi.get(self, "backup_local_tunnel_cidr")

    @property
    @pulumi.getter(name="backupPreSharedKey")
    def backup_pre_shared_key(self) -> pulumi.Output[Optional[str]]:
        """
        Backup pre shared key.
        """
        return pulumi.get(self, "backup_pre_shared_key")

    @property
    @pulumi.getter(name="backupRemoteGatewayIp")
    def backup_remote_gateway_ip(self) -> pulumi.Output[Optional[str]]:
        """
        Backup remote gateway IP.
        """
        return pulumi.get(self, "backup_remote_gateway_ip")

    @property
    @pulumi.getter(name="backupRemoteTunnelCidr")
    def backup_remote_tunnel_cidr(self) -> pulumi.Output[str]:
        """
        Destination CIDR for the tunnel to the backup external device.
        """
        return pulumi.get(self, "backup_remote_tunnel_cidr")

    @property
    @pulumi.getter(name="bgpLocalAsNum")
    def bgp_local_as_num(self) -> pulumi.Output[Optional[str]]:
        """
        BGP local ASN (Autonomous System Number). Integer between 1-4294967294.
        """
        return pulumi.get(self, "bgp_local_as_num")

    @property
    @pulumi.getter(name="bgpMd5Key")
    def bgp_md5_key(self) -> pulumi.Output[Optional[str]]:
        """
        BGP MD5 authentication key.
        """
        return pulumi.get(self, "bgp_md5_key")

    @property
    @pulumi.getter(name="bgpRemoteAsNum")
    def bgp_remote_as_num(self) -> pulumi.Output[Optional[str]]:
        """
        BGP remote ASN (Autonomous System Number). Integer between 1-4294967294.
        """
        return pulumi.get(self, "bgp_remote_as_num")

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> pulumi.Output[str]:
        """
        The name of the spoke external device connection which is going to be created.
        """
        return pulumi.get(self, "connection_name")

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> pulumi.Output[Optional[str]]:
        """
        Connection type. Valid values: 'bgp', 'static'. Default value: 'bgp'.
        """
        return pulumi.get(self, "connection_type")

    @property
    @pulumi.getter(name="customAlgorithms")
    def custom_algorithms(self) -> pulumi.Output[Optional[bool]]:
        """
        Switch to enable custom/non-default algorithms for IPSec Authentication/Encryption.
        """
        return pulumi.get(self, "custom_algorithms")

    @property
    @pulumi.getter(name="directConnect")
    def direct_connect(self) -> pulumi.Output[Optional[bool]]:
        """
        Set true for private network infrastructure.
        """
        return pulumi.get(self, "direct_connect")

    @property
    @pulumi.getter(name="enableEventTriggeredHa")
    def enable_event_triggered_ha(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable Event Triggered HA.
        """
        return pulumi.get(self, "enable_event_triggered_ha")

    @property
    @pulumi.getter(name="enableIkev2")
    def enable_ikev2(self) -> pulumi.Output[Optional[bool]]:
        """
        Set as true if use IKEv2.
        """
        return pulumi.get(self, "enable_ikev2")

    @property
    @pulumi.getter(name="enableLearnedCidrsApproval")
    def enable_learned_cidrs_approval(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable learned CIDR approval for the connection. Only valid with 'connection_type' = 'bgp'. Requires the spoke_gateway's
        'learned_cidrs_approval_mode' attribute be set to 'connection'. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_learned_cidrs_approval")

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> pulumi.Output[str]:
        """
        Name of the BGP Spoke Gateway.
        """
        return pulumi.get(self, "gw_name")

    @property
    @pulumi.getter(name="haEnabled")
    def ha_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Set as true if there are two external devices.
        """
        return pulumi.get(self, "ha_enabled")

    @property
    @pulumi.getter(name="localTunnelCidr")
    def local_tunnel_cidr(self) -> pulumi.Output[str]:
        """
        Source CIDR for the tunnel from the Aviatrix spoke gateway.
        """
        return pulumi.get(self, "local_tunnel_cidr")

    @property
    @pulumi.getter(name="manualBgpAdvertisedCidrs")
    def manual_bgp_advertised_cidrs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Configure manual BGP advertised CIDRs for this connection. Only valid with 'connection_type' = 'bgp'.
        """
        return pulumi.get(self, "manual_bgp_advertised_cidrs")

    @property
    @pulumi.getter(name="phase1Authentication")
    def phase1_authentication(self) -> pulumi.Output[Optional[str]]:
        """
        Phase one Authentication. Valid values: 'SHA-1', 'SHA-256', 'SHA-384' and 'SHA-512'.
        """
        return pulumi.get(self, "phase1_authentication")

    @property
    @pulumi.getter(name="phase1DhGroups")
    def phase1_dh_groups(self) -> pulumi.Output[Optional[str]]:
        """
        Phase one DH Groups. Valid values: '1', '2', '5', '14', '15', '16', '17', '18', '19', '20' and '21'.
        """
        return pulumi.get(self, "phase1_dh_groups")

    @property
    @pulumi.getter(name="phase1Encryption")
    def phase1_encryption(self) -> pulumi.Output[Optional[str]]:
        """
        Phase one Encryption. Valid values: '3DES', 'AES-128-CBC', 'AES-192-CBC' and 'AES-256-CBC', 'AES-128-GCM-64',
        'AES-128-GCM-96', 'AES-128-GCM-128', 'AES-256-GCM-64', 'AES-256-GCM-96', and 'AES-256-GCM-128'.
        """
        return pulumi.get(self, "phase1_encryption")

    @property
    @pulumi.getter(name="phase1RemoteIdentifiers")
    def phase1_remote_identifiers(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Phase 1 remote identifier of the IPsec tunnel.
        """
        return pulumi.get(self, "phase1_remote_identifiers")

    @property
    @pulumi.getter(name="phase2Authentication")
    def phase2_authentication(self) -> pulumi.Output[Optional[str]]:
        """
        Phase two Authentication. Valid values: 'NO-AUTH', 'HMAC-SHA-1', 'HMAC-SHA-256', 'HMAC-SHA-384' and 'HMAC-SHA-512'.
        """
        return pulumi.get(self, "phase2_authentication")

    @property
    @pulumi.getter(name="phase2DhGroups")
    def phase2_dh_groups(self) -> pulumi.Output[Optional[str]]:
        """
        Phase two DH Groups. Valid values: '1', '2', '5', '14', '15', '16', '17', '18', '19', '20' and '21'.
        """
        return pulumi.get(self, "phase2_dh_groups")

    @property
    @pulumi.getter(name="phase2Encryption")
    def phase2_encryption(self) -> pulumi.Output[Optional[str]]:
        """
        Phase two Encryption. Valid values: '3DES', 'AES-128-CBC', 'AES-192-CBC', 'AES-256-CBC', 'AES-128-GCM-64',
        'AES-128-GCM-96', 'AES-128-GCM-128', 'AES-256-GCM-64', 'AES-256-GCM-96', 'AES-256-GCM-128', and 'NULL-ENCR'.
        """
        return pulumi.get(self, "phase2_encryption")

    @property
    @pulumi.getter(name="preSharedKey")
    def pre_shared_key(self) -> pulumi.Output[Optional[str]]:
        """
        If left blank, the pre-shared key will be auto generated.
        """
        return pulumi.get(self, "pre_shared_key")

    @property
    @pulumi.getter(name="prependAsPaths")
    def prepend_as_paths(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Connection AS Path Prepend customized by specifying AS PATH for a BGP connection.
        """
        return pulumi.get(self, "prepend_as_paths")

    @property
    @pulumi.getter(name="remoteGatewayIp")
    def remote_gateway_ip(self) -> pulumi.Output[str]:
        """
        Remote Gateway IP.
        """
        return pulumi.get(self, "remote_gateway_ip")

    @property
    @pulumi.getter(name="remoteSubnet")
    def remote_subnet(self) -> pulumi.Output[Optional[str]]:
        """
        Remote CIDRs joined as a string with ','. Required for a 'static' type connection.
        """
        return pulumi.get(self, "remote_subnet")

    @property
    @pulumi.getter(name="remoteTunnelCidr")
    def remote_tunnel_cidr(self) -> pulumi.Output[str]:
        """
        Destination CIDR for the tunnel to the external device.
        """
        return pulumi.get(self, "remote_tunnel_cidr")

    @property
    @pulumi.getter(name="tunnelProtocol")
    def tunnel_protocol(self) -> pulumi.Output[Optional[str]]:
        """
        Tunnel Protocol. Valid value: 'IPsec'. Default value: 'IPsec'. Case insensitive.
        """
        return pulumi.get(self, "tunnel_protocol")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        ID of the VPC where the BGP Spoke Gateway is located.
        """
        return pulumi.get(self, "vpc_id")

