# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixRemoteSyslogArgs', 'AviatrixRemoteSyslog']

@pulumi.input_type
class AviatrixRemoteSyslogArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[int],
                 server: pulumi.Input[str],
                 ca_certificate_file: Optional[pulumi.Input[str]] = None,
                 excluded_gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 index: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_key_file: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 public_certificate_file: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AviatrixRemoteSyslog resource.
        :param pulumi.Input[int] port: Listening port of the remote syslog server.
        :param pulumi.Input[str] server: FQDN or IP address of the remote syslog server.
        :param pulumi.Input[str] ca_certificate_file: CA certificate file.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excluded_gateways: List of excluded gateways.
        :param pulumi.Input[int] index: A total of 10 profiles from index 0 to 9 are supported for remote syslog, while index 9 is reserved for CoPilot.
        :param pulumi.Input[str] name: Profile name.
        :param pulumi.Input[str] private_key_file: Private key of the controller that pairs with the public certificate.
        :param pulumi.Input[str] protocol: TCP or UDP (TCP by default).
        :param pulumi.Input[str] public_certificate_file: Public certificate of the controller signed by the same CA.
        :param pulumi.Input[str] template: Useful when forwarding to 3rd party servers like Datadog or Sumo
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server", server)
        if ca_certificate_file is not None:
            pulumi.set(__self__, "ca_certificate_file", ca_certificate_file)
        if excluded_gateways is not None:
            pulumi.set(__self__, "excluded_gateways", excluded_gateways)
        if index is not None:
            pulumi.set(__self__, "index", index)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_key_file is not None:
            pulumi.set(__self__, "private_key_file", private_key_file)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if public_certificate_file is not None:
            pulumi.set(__self__, "public_certificate_file", public_certificate_file)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        Listening port of the remote syslog server.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def server(self) -> pulumi.Input[str]:
        """
        FQDN or IP address of the remote syslog server.
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: pulumi.Input[str]):
        pulumi.set(self, "server", value)

    @property
    @pulumi.getter(name="caCertificateFile")
    def ca_certificate_file(self) -> Optional[pulumi.Input[str]]:
        """
        CA certificate file.
        """
        return pulumi.get(self, "ca_certificate_file")

    @ca_certificate_file.setter
    def ca_certificate_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_certificate_file", value)

    @property
    @pulumi.getter(name="excludedGateways")
    def excluded_gateways(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of excluded gateways.
        """
        return pulumi.get(self, "excluded_gateways")

    @excluded_gateways.setter
    def excluded_gateways(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excluded_gateways", value)

    @property
    @pulumi.getter
    def index(self) -> Optional[pulumi.Input[int]]:
        """
        A total of 10 profiles from index 0 to 9 are supported for remote syslog, while index 9 is reserved for CoPilot.
        """
        return pulumi.get(self, "index")

    @index.setter
    def index(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "index", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Profile name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateKeyFile")
    def private_key_file(self) -> Optional[pulumi.Input[str]]:
        """
        Private key of the controller that pairs with the public certificate.
        """
        return pulumi.get(self, "private_key_file")

    @private_key_file.setter
    def private_key_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key_file", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        TCP or UDP (TCP by default).
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="publicCertificateFile")
    def public_certificate_file(self) -> Optional[pulumi.Input[str]]:
        """
        Public certificate of the controller signed by the same CA.
        """
        return pulumi.get(self, "public_certificate_file")

    @public_certificate_file.setter
    def public_certificate_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_certificate_file", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input[str]]:
        """
        Useful when forwarding to 3rd party servers like Datadog or Sumo
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template", value)


@pulumi.input_type
class _AviatrixRemoteSyslogState:
    def __init__(__self__, *,
                 ca_certificate_file: Optional[pulumi.Input[str]] = None,
                 excluded_gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 index: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notls: Optional[pulumi.Input[bool]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 private_key_file: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 public_certificate_file: Optional[pulumi.Input[str]] = None,
                 server: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixRemoteSyslog resources.
        :param pulumi.Input[str] ca_certificate_file: CA certificate file.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excluded_gateways: List of excluded gateways.
        :param pulumi.Input[int] index: A total of 10 profiles from index 0 to 9 are supported for remote syslog, while index 9 is reserved for CoPilot.
        :param pulumi.Input[str] name: Profile name.
        :param pulumi.Input[bool] notls: True if not protected by TLS.
        :param pulumi.Input[int] port: Listening port of the remote syslog server.
        :param pulumi.Input[str] private_key_file: Private key of the controller that pairs with the public certificate.
        :param pulumi.Input[str] protocol: TCP or UDP (TCP by default).
        :param pulumi.Input[str] public_certificate_file: Public certificate of the controller signed by the same CA.
        :param pulumi.Input[str] server: FQDN or IP address of the remote syslog server.
        :param pulumi.Input[str] status: Enabled or not.
        :param pulumi.Input[str] template: Useful when forwarding to 3rd party servers like Datadog or Sumo
        """
        if ca_certificate_file is not None:
            pulumi.set(__self__, "ca_certificate_file", ca_certificate_file)
        if excluded_gateways is not None:
            pulumi.set(__self__, "excluded_gateways", excluded_gateways)
        if index is not None:
            pulumi.set(__self__, "index", index)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notls is not None:
            pulumi.set(__self__, "notls", notls)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if private_key_file is not None:
            pulumi.set(__self__, "private_key_file", private_key_file)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if public_certificate_file is not None:
            pulumi.set(__self__, "public_certificate_file", public_certificate_file)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @property
    @pulumi.getter(name="caCertificateFile")
    def ca_certificate_file(self) -> Optional[pulumi.Input[str]]:
        """
        CA certificate file.
        """
        return pulumi.get(self, "ca_certificate_file")

    @ca_certificate_file.setter
    def ca_certificate_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_certificate_file", value)

    @property
    @pulumi.getter(name="excludedGateways")
    def excluded_gateways(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of excluded gateways.
        """
        return pulumi.get(self, "excluded_gateways")

    @excluded_gateways.setter
    def excluded_gateways(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excluded_gateways", value)

    @property
    @pulumi.getter
    def index(self) -> Optional[pulumi.Input[int]]:
        """
        A total of 10 profiles from index 0 to 9 are supported for remote syslog, while index 9 is reserved for CoPilot.
        """
        return pulumi.get(self, "index")

    @index.setter
    def index(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "index", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Profile name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def notls(self) -> Optional[pulumi.Input[bool]]:
        """
        True if not protected by TLS.
        """
        return pulumi.get(self, "notls")

    @notls.setter
    def notls(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "notls", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Listening port of the remote syslog server.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="privateKeyFile")
    def private_key_file(self) -> Optional[pulumi.Input[str]]:
        """
        Private key of the controller that pairs with the public certificate.
        """
        return pulumi.get(self, "private_key_file")

    @private_key_file.setter
    def private_key_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key_file", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        TCP or UDP (TCP by default).
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="publicCertificateFile")
    def public_certificate_file(self) -> Optional[pulumi.Input[str]]:
        """
        Public certificate of the controller signed by the same CA.
        """
        return pulumi.get(self, "public_certificate_file")

    @public_certificate_file.setter
    def public_certificate_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_certificate_file", value)

    @property
    @pulumi.getter
    def server(self) -> Optional[pulumi.Input[str]]:
        """
        FQDN or IP address of the remote syslog server.
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Enabled or not.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input[str]]:
        """
        Useful when forwarding to 3rd party servers like Datadog or Sumo
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template", value)


class AviatrixRemoteSyslog(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ca_certificate_file: Optional[pulumi.Input[str]] = None,
                 excluded_gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 index: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 private_key_file: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 public_certificate_file: Optional[pulumi.Input[str]] = None,
                 server: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a AviatrixRemoteSyslog resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ca_certificate_file: CA certificate file.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excluded_gateways: List of excluded gateways.
        :param pulumi.Input[int] index: A total of 10 profiles from index 0 to 9 are supported for remote syslog, while index 9 is reserved for CoPilot.
        :param pulumi.Input[str] name: Profile name.
        :param pulumi.Input[int] port: Listening port of the remote syslog server.
        :param pulumi.Input[str] private_key_file: Private key of the controller that pairs with the public certificate.
        :param pulumi.Input[str] protocol: TCP or UDP (TCP by default).
        :param pulumi.Input[str] public_certificate_file: Public certificate of the controller signed by the same CA.
        :param pulumi.Input[str] server: FQDN or IP address of the remote syslog server.
        :param pulumi.Input[str] template: Useful when forwarding to 3rd party servers like Datadog or Sumo
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixRemoteSyslogArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AviatrixRemoteSyslog resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AviatrixRemoteSyslogArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixRemoteSyslogArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ca_certificate_file: Optional[pulumi.Input[str]] = None,
                 excluded_gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 index: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 private_key_file: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 public_certificate_file: Optional[pulumi.Input[str]] = None,
                 server: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixRemoteSyslogArgs.__new__(AviatrixRemoteSyslogArgs)

            __props__.__dict__["ca_certificate_file"] = ca_certificate_file
            __props__.__dict__["excluded_gateways"] = excluded_gateways
            __props__.__dict__["index"] = index
            __props__.__dict__["name"] = name
            if port is None and not opts.urn:
                raise TypeError("Missing required property 'port'")
            __props__.__dict__["port"] = port
            __props__.__dict__["private_key_file"] = private_key_file
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["public_certificate_file"] = public_certificate_file
            if server is None and not opts.urn:
                raise TypeError("Missing required property 'server'")
            __props__.__dict__["server"] = server
            __props__.__dict__["template"] = template
            __props__.__dict__["notls"] = None
            __props__.__dict__["status"] = None
        super(AviatrixRemoteSyslog, __self__).__init__(
            'aviatrix:index/aviatrixRemoteSyslog:AviatrixRemoteSyslog',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ca_certificate_file: Optional[pulumi.Input[str]] = None,
            excluded_gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            index: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            notls: Optional[pulumi.Input[bool]] = None,
            port: Optional[pulumi.Input[int]] = None,
            private_key_file: Optional[pulumi.Input[str]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            public_certificate_file: Optional[pulumi.Input[str]] = None,
            server: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            template: Optional[pulumi.Input[str]] = None) -> 'AviatrixRemoteSyslog':
        """
        Get an existing AviatrixRemoteSyslog resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ca_certificate_file: CA certificate file.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excluded_gateways: List of excluded gateways.
        :param pulumi.Input[int] index: A total of 10 profiles from index 0 to 9 are supported for remote syslog, while index 9 is reserved for CoPilot.
        :param pulumi.Input[str] name: Profile name.
        :param pulumi.Input[bool] notls: True if not protected by TLS.
        :param pulumi.Input[int] port: Listening port of the remote syslog server.
        :param pulumi.Input[str] private_key_file: Private key of the controller that pairs with the public certificate.
        :param pulumi.Input[str] protocol: TCP or UDP (TCP by default).
        :param pulumi.Input[str] public_certificate_file: Public certificate of the controller signed by the same CA.
        :param pulumi.Input[str] server: FQDN or IP address of the remote syslog server.
        :param pulumi.Input[str] status: Enabled or not.
        :param pulumi.Input[str] template: Useful when forwarding to 3rd party servers like Datadog or Sumo
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixRemoteSyslogState.__new__(_AviatrixRemoteSyslogState)

        __props__.__dict__["ca_certificate_file"] = ca_certificate_file
        __props__.__dict__["excluded_gateways"] = excluded_gateways
        __props__.__dict__["index"] = index
        __props__.__dict__["name"] = name
        __props__.__dict__["notls"] = notls
        __props__.__dict__["port"] = port
        __props__.__dict__["private_key_file"] = private_key_file
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["public_certificate_file"] = public_certificate_file
        __props__.__dict__["server"] = server
        __props__.__dict__["status"] = status
        __props__.__dict__["template"] = template
        return AviatrixRemoteSyslog(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="caCertificateFile")
    def ca_certificate_file(self) -> pulumi.Output[Optional[str]]:
        """
        CA certificate file.
        """
        return pulumi.get(self, "ca_certificate_file")

    @property
    @pulumi.getter(name="excludedGateways")
    def excluded_gateways(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of excluded gateways.
        """
        return pulumi.get(self, "excluded_gateways")

    @property
    @pulumi.getter
    def index(self) -> pulumi.Output[Optional[int]]:
        """
        A total of 10 profiles from index 0 to 9 are supported for remote syslog, while index 9 is reserved for CoPilot.
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Profile name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def notls(self) -> pulumi.Output[bool]:
        """
        True if not protected by TLS.
        """
        return pulumi.get(self, "notls")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        Listening port of the remote syslog server.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="privateKeyFile")
    def private_key_file(self) -> pulumi.Output[Optional[str]]:
        """
        Private key of the controller that pairs with the public certificate.
        """
        return pulumi.get(self, "private_key_file")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[Optional[str]]:
        """
        TCP or UDP (TCP by default).
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="publicCertificateFile")
    def public_certificate_file(self) -> pulumi.Output[Optional[str]]:
        """
        Public certificate of the controller signed by the same CA.
        """
        return pulumi.get(self, "public_certificate_file")

    @property
    @pulumi.getter
    def server(self) -> pulumi.Output[str]:
        """
        FQDN or IP address of the remote syslog server.
        """
        return pulumi.get(self, "server")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Enabled or not.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def template(self) -> pulumi.Output[Optional[str]]:
        """
        Useful when forwarding to 3rd party servers like Datadog or Sumo
        """
        return pulumi.get(self, "template")

