# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixGatewayArgs', 'AviatrixGateway']

@pulumi.input_type
class AviatrixGatewayArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[str],
                 cloud_type: pulumi.Input[int],
                 gw_name: pulumi.Input[str],
                 gw_size: pulumi.Input[str],
                 subnet: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 vpc_reg: pulumi.Input[str],
                 additional_cidrs: Optional[pulumi.Input[str]] = None,
                 additional_cidrs_designated_gateway: Optional[pulumi.Input[str]] = None,
                 allocate_new_eip: Optional[pulumi.Input[bool]] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 azure_eip_name_resource_group: Optional[pulumi.Input[str]] = None,
                 customer_managed_keys: Optional[pulumi.Input[str]] = None,
                 duo_api_hostname: Optional[pulumi.Input[str]] = None,
                 duo_integration_key: Optional[pulumi.Input[str]] = None,
                 duo_push_mode: Optional[pulumi.Input[str]] = None,
                 duo_secret_key: Optional[pulumi.Input[str]] = None,
                 eip: Optional[pulumi.Input[str]] = None,
                 elb_name: Optional[pulumi.Input[str]] = None,
                 enable_designated_gateway: Optional[pulumi.Input[bool]] = None,
                 enable_elb: Optional[pulumi.Input[bool]] = None,
                 enable_encrypt_volume: Optional[pulumi.Input[bool]] = None,
                 enable_jumbo_frame: Optional[pulumi.Input[bool]] = None,
                 enable_ldap: Optional[pulumi.Input[bool]] = None,
                 enable_monitor_gateway_subnets: Optional[pulumi.Input[bool]] = None,
                 enable_public_subnet_filtering: Optional[pulumi.Input[bool]] = None,
                 enable_spot_instance: Optional[pulumi.Input[bool]] = None,
                 enable_vpc_dns_server: Optional[pulumi.Input[bool]] = None,
                 enable_vpn_nat: Optional[pulumi.Input[bool]] = None,
                 fault_domain: Optional[pulumi.Input[str]] = None,
                 fqdn_lan_cidr: Optional[pulumi.Input[str]] = None,
                 fqdn_lan_vpc_id: Optional[pulumi.Input[str]] = None,
                 idle_timeout: Optional[pulumi.Input[int]] = None,
                 image_version: Optional[pulumi.Input[str]] = None,
                 insane_mode: Optional[pulumi.Input[bool]] = None,
                 insane_mode_az: Optional[pulumi.Input[str]] = None,
                 ldap_base_dn: Optional[pulumi.Input[str]] = None,
                 ldap_bind_dn: Optional[pulumi.Input[str]] = None,
                 ldap_password: Optional[pulumi.Input[str]] = None,
                 ldap_server: Optional[pulumi.Input[str]] = None,
                 ldap_username_attribute: Optional[pulumi.Input[str]] = None,
                 max_vpn_conn: Optional[pulumi.Input[str]] = None,
                 monitor_exclude_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name_servers: Optional[pulumi.Input[str]] = None,
                 okta_token: Optional[pulumi.Input[str]] = None,
                 okta_url: Optional[pulumi.Input[str]] = None,
                 okta_username_suffix: Optional[pulumi.Input[str]] = None,
                 otp_mode: Optional[pulumi.Input[str]] = None,
                 peering_ha_availability_domain: Optional[pulumi.Input[str]] = None,
                 peering_ha_azure_eip_name_resource_group: Optional[pulumi.Input[str]] = None,
                 peering_ha_eip: Optional[pulumi.Input[str]] = None,
                 peering_ha_fault_domain: Optional[pulumi.Input[str]] = None,
                 peering_ha_gw_size: Optional[pulumi.Input[str]] = None,
                 peering_ha_image_version: Optional[pulumi.Input[str]] = None,
                 peering_ha_insane_mode_az: Optional[pulumi.Input[str]] = None,
                 peering_ha_software_version: Optional[pulumi.Input[str]] = None,
                 peering_ha_subnet: Optional[pulumi.Input[str]] = None,
                 peering_ha_zone: Optional[pulumi.Input[str]] = None,
                 public_subnet_filtering_guard_duty_enforced: Optional[pulumi.Input[bool]] = None,
                 public_subnet_filtering_ha_route_tables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 public_subnet_filtering_route_tables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 renegotiation_interval: Optional[pulumi.Input[int]] = None,
                 rx_queue_size: Optional[pulumi.Input[str]] = None,
                 saml_enabled: Optional[pulumi.Input[bool]] = None,
                 search_domains: Optional[pulumi.Input[str]] = None,
                 single_az_ha: Optional[pulumi.Input[bool]] = None,
                 single_ip_snat: Optional[pulumi.Input[bool]] = None,
                 software_version: Optional[pulumi.Input[str]] = None,
                 split_tunnel: Optional[pulumi.Input[bool]] = None,
                 spot_price: Optional[pulumi.Input[str]] = None,
                 tag_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tunnel_detection_time: Optional[pulumi.Input[int]] = None,
                 vpn_access: Optional[pulumi.Input[bool]] = None,
                 vpn_cidr: Optional[pulumi.Input[str]] = None,
                 vpn_protocol: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AviatrixGateway resource.
        :param pulumi.Input[str] account_name: Account name. This account will be used to launch Aviatrix gateway.
        :param pulumi.Input[int] cloud_type: Type of cloud service provider.
        :param pulumi.Input[str] gw_name: Aviatrix gateway unique name.
        :param pulumi.Input[str] gw_size: Size of Gateway Instance.
        :param pulumi.Input[str] subnet: A VPC Network address range selected from one of the available network ranges.
        :param pulumi.Input[str] vpc_id: ID of legacy VPC/Vnet to be connected.
        :param pulumi.Input[str] vpc_reg: Region where this gateway will be launched.
        :param pulumi.Input[str] additional_cidrs: A list of destination CIDR ranges that will also go through the VPN tunnel when Split Tunnel Mode is enabled.
        :param pulumi.Input[str] additional_cidrs_designated_gateway: A list of CIDR ranges separated by comma to configure when 'designated_gateway' feature is enabled.
        :param pulumi.Input[bool] allocate_new_eip: When value is false, reuse an idle address in Elastic IP pool for this gateway. Otherwise, allocate a new Elastic IP and
               use it for this gateway.
        :param pulumi.Input[str] availability_domain: Availability domain for OCI.
        :param pulumi.Input[str] azure_eip_name_resource_group: The name of the public IP address and its resource group in Azure to assign to this Gateway.
        :param pulumi.Input[str] customer_managed_keys: Customer managed key ID.
        :param pulumi.Input[str] duo_api_hostname: API hostname for DUO auth mode.
        :param pulumi.Input[str] duo_integration_key: Integration key for DUO auth mode.
        :param pulumi.Input[str] duo_push_mode: Push mode for DUO auth.
        :param pulumi.Input[str] duo_secret_key: Secret key for DUO auth mode.
        :param pulumi.Input[str] eip: Required when allocate_new_eip is false. It uses specified EIP for this gateway.
        :param pulumi.Input[str] elb_name: A name for the ELB that is created.
        :param pulumi.Input[bool] enable_designated_gateway: Enable 'designated_gateway' feature for Gateway. Valid values: true, false.
        :param pulumi.Input[bool] enable_elb: Specify whether to enable ELB or not.
        :param pulumi.Input[bool] enable_encrypt_volume: Enable encrypt gateway EBS volume. Only supported for AWS provider. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_jumbo_frame: Enable jumbo frame support for Gateway. Valid values: true or false. Default value: true.
        :param pulumi.Input[bool] enable_ldap: Specify whether to enable LDAP or not. Supported values: 'yes' and 'no'.
        :param pulumi.Input[bool] enable_monitor_gateway_subnets: Enable monitor gateway subnets. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_public_subnet_filtering: Create a [Public Subnet Filtering gateway](https://docs.aviatrix.com/HowTos/public_subnet_filtering_faq.html).
        :param pulumi.Input[bool] enable_spot_instance: Enable spot instance. NOT supported for production deployment.
        :param pulumi.Input[bool] enable_vpc_dns_server: Enable vpc_dns_server for Gateway. Valid values: true, false.
        :param pulumi.Input[bool] enable_vpn_nat: This field indicates whether to enable VPN NAT or not. Only supported for VPN gateway. Valid values: true, false.
               Default value: true.
        :param pulumi.Input[str] fault_domain: Fault domain for OCI.
        :param pulumi.Input[str] fqdn_lan_cidr: FQDN gateway lan interface cidr.
        :param pulumi.Input[str] fqdn_lan_vpc_id: LAN VPC ID. Only used for GCP FQDN Gateway.
        :param pulumi.Input[int] idle_timeout: Typed value when modifying idle_timeout. If it's -1, this feature is disabled.
        :param pulumi.Input[str] image_version: image_version can be used to set the desired image version of the gateway. If set, we will attempt to update the gateway
               to the specified version.
        :param pulumi.Input[bool] insane_mode: Enable Insane Mode for Gateway. Valid values: true, false.
        :param pulumi.Input[str] insane_mode_az: AZ of subnet being created for Insane Mode Gateway. Required if insane_mode is set.
        :param pulumi.Input[str] ldap_base_dn: LDAP base DN. Required: Yes if enable_ldap is 'yes'.
        :param pulumi.Input[str] ldap_bind_dn: LDAP bind DN. Required: Yes if enable_ldap is 'yes'.
        :param pulumi.Input[str] ldap_password: LDAP password. Required: Yes if enable_ldap is 'yes'.
        :param pulumi.Input[str] ldap_server: LDAP server address. Required: Yes if enable_ldap is 'yes'.
        :param pulumi.Input[str] ldap_username_attribute: LDAP user attribute. Required: Yes if enable_ldap is 'yes'.
        :param pulumi.Input[str] max_vpn_conn: Maximum connection of VPN access.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] monitor_exclude_lists: A set of monitored instance ids. Only valid when 'enable_monitor_gateway_subnets' = true.
        :param pulumi.Input[str] name_servers: A list of DNS servers used to resolve domain names by a connected VPN user when Split Tunnel Mode is enabled.
        :param pulumi.Input[str] okta_token: Token for Okta auth mode.
        :param pulumi.Input[str] okta_url: URL for Okta auth mode.
        :param pulumi.Input[str] okta_username_suffix: Username suffix for Okta auth mode.
        :param pulumi.Input[str] otp_mode: Two step authentication mode.
        :param pulumi.Input[str] peering_ha_availability_domain: Peering HA availability domain for OCI.
        :param pulumi.Input[str] peering_ha_azure_eip_name_resource_group: The name of the public IP address and its resource group in Azure to assign to the Peering HA Gateway.
        :param pulumi.Input[str] peering_ha_eip: Public IP address that you want assigned to the HA peering instance.
        :param pulumi.Input[str] peering_ha_fault_domain: Peering HA fault domain for OCI.
        :param pulumi.Input[str] peering_ha_gw_size: Peering HA Gateway Size.
        :param pulumi.Input[str] peering_ha_image_version: peering_ha_image_version can be used to set the desired image version of the HA gateway. If set, we will attempt to
               update the gateway to the specified version.
        :param pulumi.Input[str] peering_ha_insane_mode_az: AZ of subnet being created for Insane Mode Peering HA Gateway. Required if insane_mode is set.
        :param pulumi.Input[str] peering_ha_software_version: peering_ha_software_version can be used to set the desired software version of the HA gateway. If set, we will attempt
               to update the gateway to the specified version. If left blank, the gateway software version will continue to be managed
               through the aviatrix_controller_config resource.
        :param pulumi.Input[str] peering_ha_subnet: Public Subnet Information while creating Peering HA Gateway, only subnet is accepted. Required to create peering ha
               gateway if cloud_type = 1 or 8 (AWS or Azure). Optional if cloud_type = 4 (GCP)
        :param pulumi.Input[str] peering_ha_zone: Zone information for creating Peering HA Gateway. Required to create peering ha gateway if cloud_type = 4 (GCP).
               Optional for cloud_type = 8 (Azure).
        :param pulumi.Input[bool] public_subnet_filtering_guard_duty_enforced: Whether to enforce Guard Duty IP blocking. Required when `enable_public_subnet_filtering` attribute is true. Valid
               values: true or false. Default value: true.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] public_subnet_filtering_ha_route_tables: Route tables whose associated public subnets are protected for the HA PSF gateway. Required when
               enable_public_subnet_filtering and peering_ha_subnet are set.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] public_subnet_filtering_route_tables: Route tables whose associated public subnets are protected. Required when `enable_public_subnet_filtering` attribute is
               true.
        :param pulumi.Input[int] renegotiation_interval: Typed value when modifying renegotiation_interval. If it's -1, this feature is disabled.
        :param pulumi.Input[str] rx_queue_size: Gateway ethernet interface RX queue size. Supported for AWS related clouds only.
        :param pulumi.Input[bool] saml_enabled: This field indicates whether to enable SAML or not.
        :param pulumi.Input[str] search_domains: A list of domain names that will use the NameServer when a specific name is not in the destination when Split Tunnel
               Mode is enabled.
        :param pulumi.Input[bool] single_az_ha: Set to true if this feature is desired.
        :param pulumi.Input[bool] single_ip_snat: Enable Source NAT for this container.
        :param pulumi.Input[str] software_version: software_version can be used to set the desired software version of the gateway. If set, we will attempt to update the
               gateway to the specified version. If left blank, the gateway software version will continue to be managed through the
               aviatrix_controller_config resource.
        :param pulumi.Input[bool] split_tunnel: Specify split tunnel mode.
        :param pulumi.Input[str] spot_price: Price for spot instance. NOT supported for production deployment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tag_lists: Instance tag of cloud provider.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the gateway.
        :param pulumi.Input[int] tunnel_detection_time: The IPSec tunnel down detection time for the Gateway.
        :param pulumi.Input[bool] vpn_access: Enable user access through VPN to this container.
        :param pulumi.Input[str] vpn_cidr: VPN CIDR block for the container.
        :param pulumi.Input[str] vpn_protocol: Elb protocol for VPN gateway with elb enabled. Only supports AWS provider. Valid values: 'TCP', 'UDP'. If not specified,
               'TCP'' will be used.
        :param pulumi.Input[str] zone: Availability Zone. Only available for Azure and Public Subnet Filtering gateway
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "cloud_type", cloud_type)
        pulumi.set(__self__, "gw_name", gw_name)
        pulumi.set(__self__, "gw_size", gw_size)
        pulumi.set(__self__, "subnet", subnet)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vpc_reg", vpc_reg)
        if additional_cidrs is not None:
            pulumi.set(__self__, "additional_cidrs", additional_cidrs)
        if additional_cidrs_designated_gateway is not None:
            pulumi.set(__self__, "additional_cidrs_designated_gateway", additional_cidrs_designated_gateway)
        if allocate_new_eip is not None:
            pulumi.set(__self__, "allocate_new_eip", allocate_new_eip)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if azure_eip_name_resource_group is not None:
            pulumi.set(__self__, "azure_eip_name_resource_group", azure_eip_name_resource_group)
        if customer_managed_keys is not None:
            pulumi.set(__self__, "customer_managed_keys", customer_managed_keys)
        if duo_api_hostname is not None:
            pulumi.set(__self__, "duo_api_hostname", duo_api_hostname)
        if duo_integration_key is not None:
            pulumi.set(__self__, "duo_integration_key", duo_integration_key)
        if duo_push_mode is not None:
            pulumi.set(__self__, "duo_push_mode", duo_push_mode)
        if duo_secret_key is not None:
            pulumi.set(__self__, "duo_secret_key", duo_secret_key)
        if eip is not None:
            pulumi.set(__self__, "eip", eip)
        if elb_name is not None:
            pulumi.set(__self__, "elb_name", elb_name)
        if enable_designated_gateway is not None:
            pulumi.set(__self__, "enable_designated_gateway", enable_designated_gateway)
        if enable_elb is not None:
            pulumi.set(__self__, "enable_elb", enable_elb)
        if enable_encrypt_volume is not None:
            pulumi.set(__self__, "enable_encrypt_volume", enable_encrypt_volume)
        if enable_jumbo_frame is not None:
            pulumi.set(__self__, "enable_jumbo_frame", enable_jumbo_frame)
        if enable_ldap is not None:
            pulumi.set(__self__, "enable_ldap", enable_ldap)
        if enable_monitor_gateway_subnets is not None:
            pulumi.set(__self__, "enable_monitor_gateway_subnets", enable_monitor_gateway_subnets)
        if enable_public_subnet_filtering is not None:
            pulumi.set(__self__, "enable_public_subnet_filtering", enable_public_subnet_filtering)
        if enable_spot_instance is not None:
            pulumi.set(__self__, "enable_spot_instance", enable_spot_instance)
        if enable_vpc_dns_server is not None:
            pulumi.set(__self__, "enable_vpc_dns_server", enable_vpc_dns_server)
        if enable_vpn_nat is not None:
            pulumi.set(__self__, "enable_vpn_nat", enable_vpn_nat)
        if fault_domain is not None:
            pulumi.set(__self__, "fault_domain", fault_domain)
        if fqdn_lan_cidr is not None:
            pulumi.set(__self__, "fqdn_lan_cidr", fqdn_lan_cidr)
        if fqdn_lan_vpc_id is not None:
            pulumi.set(__self__, "fqdn_lan_vpc_id", fqdn_lan_vpc_id)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if image_version is not None:
            pulumi.set(__self__, "image_version", image_version)
        if insane_mode is not None:
            pulumi.set(__self__, "insane_mode", insane_mode)
        if insane_mode_az is not None:
            pulumi.set(__self__, "insane_mode_az", insane_mode_az)
        if ldap_base_dn is not None:
            pulumi.set(__self__, "ldap_base_dn", ldap_base_dn)
        if ldap_bind_dn is not None:
            pulumi.set(__self__, "ldap_bind_dn", ldap_bind_dn)
        if ldap_password is not None:
            pulumi.set(__self__, "ldap_password", ldap_password)
        if ldap_server is not None:
            pulumi.set(__self__, "ldap_server", ldap_server)
        if ldap_username_attribute is not None:
            pulumi.set(__self__, "ldap_username_attribute", ldap_username_attribute)
        if max_vpn_conn is not None:
            pulumi.set(__self__, "max_vpn_conn", max_vpn_conn)
        if monitor_exclude_lists is not None:
            pulumi.set(__self__, "monitor_exclude_lists", monitor_exclude_lists)
        if name_servers is not None:
            pulumi.set(__self__, "name_servers", name_servers)
        if okta_token is not None:
            pulumi.set(__self__, "okta_token", okta_token)
        if okta_url is not None:
            pulumi.set(__self__, "okta_url", okta_url)
        if okta_username_suffix is not None:
            pulumi.set(__self__, "okta_username_suffix", okta_username_suffix)
        if otp_mode is not None:
            pulumi.set(__self__, "otp_mode", otp_mode)
        if peering_ha_availability_domain is not None:
            pulumi.set(__self__, "peering_ha_availability_domain", peering_ha_availability_domain)
        if peering_ha_azure_eip_name_resource_group is not None:
            pulumi.set(__self__, "peering_ha_azure_eip_name_resource_group", peering_ha_azure_eip_name_resource_group)
        if peering_ha_eip is not None:
            pulumi.set(__self__, "peering_ha_eip", peering_ha_eip)
        if peering_ha_fault_domain is not None:
            pulumi.set(__self__, "peering_ha_fault_domain", peering_ha_fault_domain)
        if peering_ha_gw_size is not None:
            pulumi.set(__self__, "peering_ha_gw_size", peering_ha_gw_size)
        if peering_ha_image_version is not None:
            pulumi.set(__self__, "peering_ha_image_version", peering_ha_image_version)
        if peering_ha_insane_mode_az is not None:
            pulumi.set(__self__, "peering_ha_insane_mode_az", peering_ha_insane_mode_az)
        if peering_ha_software_version is not None:
            pulumi.set(__self__, "peering_ha_software_version", peering_ha_software_version)
        if peering_ha_subnet is not None:
            pulumi.set(__self__, "peering_ha_subnet", peering_ha_subnet)
        if peering_ha_zone is not None:
            pulumi.set(__self__, "peering_ha_zone", peering_ha_zone)
        if public_subnet_filtering_guard_duty_enforced is not None:
            pulumi.set(__self__, "public_subnet_filtering_guard_duty_enforced", public_subnet_filtering_guard_duty_enforced)
        if public_subnet_filtering_ha_route_tables is not None:
            pulumi.set(__self__, "public_subnet_filtering_ha_route_tables", public_subnet_filtering_ha_route_tables)
        if public_subnet_filtering_route_tables is not None:
            pulumi.set(__self__, "public_subnet_filtering_route_tables", public_subnet_filtering_route_tables)
        if renegotiation_interval is not None:
            pulumi.set(__self__, "renegotiation_interval", renegotiation_interval)
        if rx_queue_size is not None:
            pulumi.set(__self__, "rx_queue_size", rx_queue_size)
        if saml_enabled is not None:
            pulumi.set(__self__, "saml_enabled", saml_enabled)
        if search_domains is not None:
            pulumi.set(__self__, "search_domains", search_domains)
        if single_az_ha is not None:
            pulumi.set(__self__, "single_az_ha", single_az_ha)
        if single_ip_snat is not None:
            pulumi.set(__self__, "single_ip_snat", single_ip_snat)
        if software_version is not None:
            pulumi.set(__self__, "software_version", software_version)
        if split_tunnel is not None:
            pulumi.set(__self__, "split_tunnel", split_tunnel)
        if spot_price is not None:
            pulumi.set(__self__, "spot_price", spot_price)
        if tag_lists is not None:
            warnings.warn("""Use tags instead.""", DeprecationWarning)
            pulumi.log.warn("""tag_lists is deprecated: Use tags instead.""")
        if tag_lists is not None:
            pulumi.set(__self__, "tag_lists", tag_lists)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tunnel_detection_time is not None:
            pulumi.set(__self__, "tunnel_detection_time", tunnel_detection_time)
        if vpn_access is not None:
            pulumi.set(__self__, "vpn_access", vpn_access)
        if vpn_cidr is not None:
            pulumi.set(__self__, "vpn_cidr", vpn_cidr)
        if vpn_protocol is not None:
            pulumi.set(__self__, "vpn_protocol", vpn_protocol)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[str]:
        """
        Account name. This account will be used to launch Aviatrix gateway.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> pulumi.Input[int]:
        """
        Type of cloud service provider.
        """
        return pulumi.get(self, "cloud_type")

    @cloud_type.setter
    def cloud_type(self, value: pulumi.Input[int]):
        pulumi.set(self, "cloud_type", value)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> pulumi.Input[str]:
        """
        Aviatrix gateway unique name.
        """
        return pulumi.get(self, "gw_name")

    @gw_name.setter
    def gw_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "gw_name", value)

    @property
    @pulumi.getter(name="gwSize")
    def gw_size(self) -> pulumi.Input[str]:
        """
        Size of Gateway Instance.
        """
        return pulumi.get(self, "gw_size")

    @gw_size.setter
    def gw_size(self, value: pulumi.Input[str]):
        pulumi.set(self, "gw_size", value)

    @property
    @pulumi.getter
    def subnet(self) -> pulumi.Input[str]:
        """
        A VPC Network address range selected from one of the available network ranges.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        ID of legacy VPC/Vnet to be connected.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vpcReg")
    def vpc_reg(self) -> pulumi.Input[str]:
        """
        Region where this gateway will be launched.
        """
        return pulumi.get(self, "vpc_reg")

    @vpc_reg.setter
    def vpc_reg(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_reg", value)

    @property
    @pulumi.getter(name="additionalCidrs")
    def additional_cidrs(self) -> Optional[pulumi.Input[str]]:
        """
        A list of destination CIDR ranges that will also go through the VPN tunnel when Split Tunnel Mode is enabled.
        """
        return pulumi.get(self, "additional_cidrs")

    @additional_cidrs.setter
    def additional_cidrs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "additional_cidrs", value)

    @property
    @pulumi.getter(name="additionalCidrsDesignatedGateway")
    def additional_cidrs_designated_gateway(self) -> Optional[pulumi.Input[str]]:
        """
        A list of CIDR ranges separated by comma to configure when 'designated_gateway' feature is enabled.
        """
        return pulumi.get(self, "additional_cidrs_designated_gateway")

    @additional_cidrs_designated_gateway.setter
    def additional_cidrs_designated_gateway(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "additional_cidrs_designated_gateway", value)

    @property
    @pulumi.getter(name="allocateNewEip")
    def allocate_new_eip(self) -> Optional[pulumi.Input[bool]]:
        """
        When value is false, reuse an idle address in Elastic IP pool for this gateway. Otherwise, allocate a new Elastic IP and
        use it for this gateway.
        """
        return pulumi.get(self, "allocate_new_eip")

    @allocate_new_eip.setter
    def allocate_new_eip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allocate_new_eip", value)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Availability domain for OCI.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="azureEipNameResourceGroup")
    def azure_eip_name_resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the public IP address and its resource group in Azure to assign to this Gateway.
        """
        return pulumi.get(self, "azure_eip_name_resource_group")

    @azure_eip_name_resource_group.setter
    def azure_eip_name_resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_eip_name_resource_group", value)

    @property
    @pulumi.getter(name="customerManagedKeys")
    def customer_managed_keys(self) -> Optional[pulumi.Input[str]]:
        """
        Customer managed key ID.
        """
        return pulumi.get(self, "customer_managed_keys")

    @customer_managed_keys.setter
    def customer_managed_keys(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_managed_keys", value)

    @property
    @pulumi.getter(name="duoApiHostname")
    def duo_api_hostname(self) -> Optional[pulumi.Input[str]]:
        """
        API hostname for DUO auth mode.
        """
        return pulumi.get(self, "duo_api_hostname")

    @duo_api_hostname.setter
    def duo_api_hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "duo_api_hostname", value)

    @property
    @pulumi.getter(name="duoIntegrationKey")
    def duo_integration_key(self) -> Optional[pulumi.Input[str]]:
        """
        Integration key for DUO auth mode.
        """
        return pulumi.get(self, "duo_integration_key")

    @duo_integration_key.setter
    def duo_integration_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "duo_integration_key", value)

    @property
    @pulumi.getter(name="duoPushMode")
    def duo_push_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Push mode for DUO auth.
        """
        return pulumi.get(self, "duo_push_mode")

    @duo_push_mode.setter
    def duo_push_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "duo_push_mode", value)

    @property
    @pulumi.getter(name="duoSecretKey")
    def duo_secret_key(self) -> Optional[pulumi.Input[str]]:
        """
        Secret key for DUO auth mode.
        """
        return pulumi.get(self, "duo_secret_key")

    @duo_secret_key.setter
    def duo_secret_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "duo_secret_key", value)

    @property
    @pulumi.getter
    def eip(self) -> Optional[pulumi.Input[str]]:
        """
        Required when allocate_new_eip is false. It uses specified EIP for this gateway.
        """
        return pulumi.get(self, "eip")

    @eip.setter
    def eip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip", value)

    @property
    @pulumi.getter(name="elbName")
    def elb_name(self) -> Optional[pulumi.Input[str]]:
        """
        A name for the ELB that is created.
        """
        return pulumi.get(self, "elb_name")

    @elb_name.setter
    def elb_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "elb_name", value)

    @property
    @pulumi.getter(name="enableDesignatedGateway")
    def enable_designated_gateway(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable 'designated_gateway' feature for Gateway. Valid values: true, false.
        """
        return pulumi.get(self, "enable_designated_gateway")

    @enable_designated_gateway.setter
    def enable_designated_gateway(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_designated_gateway", value)

    @property
    @pulumi.getter(name="enableElb")
    def enable_elb(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify whether to enable ELB or not.
        """
        return pulumi.get(self, "enable_elb")

    @enable_elb.setter
    def enable_elb(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_elb", value)

    @property
    @pulumi.getter(name="enableEncryptVolume")
    def enable_encrypt_volume(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable encrypt gateway EBS volume. Only supported for AWS provider. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_encrypt_volume")

    @enable_encrypt_volume.setter
    def enable_encrypt_volume(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_encrypt_volume", value)

    @property
    @pulumi.getter(name="enableJumboFrame")
    def enable_jumbo_frame(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable jumbo frame support for Gateway. Valid values: true or false. Default value: true.
        """
        return pulumi.get(self, "enable_jumbo_frame")

    @enable_jumbo_frame.setter
    def enable_jumbo_frame(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_jumbo_frame", value)

    @property
    @pulumi.getter(name="enableLdap")
    def enable_ldap(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify whether to enable LDAP or not. Supported values: 'yes' and 'no'.
        """
        return pulumi.get(self, "enable_ldap")

    @enable_ldap.setter
    def enable_ldap(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ldap", value)

    @property
    @pulumi.getter(name="enableMonitorGatewaySubnets")
    def enable_monitor_gateway_subnets(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable monitor gateway subnets. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_monitor_gateway_subnets")

    @enable_monitor_gateway_subnets.setter
    def enable_monitor_gateway_subnets(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_monitor_gateway_subnets", value)

    @property
    @pulumi.getter(name="enablePublicSubnetFiltering")
    def enable_public_subnet_filtering(self) -> Optional[pulumi.Input[bool]]:
        """
        Create a [Public Subnet Filtering gateway](https://docs.aviatrix.com/HowTos/public_subnet_filtering_faq.html).
        """
        return pulumi.get(self, "enable_public_subnet_filtering")

    @enable_public_subnet_filtering.setter
    def enable_public_subnet_filtering(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_public_subnet_filtering", value)

    @property
    @pulumi.getter(name="enableSpotInstance")
    def enable_spot_instance(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable spot instance. NOT supported for production deployment.
        """
        return pulumi.get(self, "enable_spot_instance")

    @enable_spot_instance.setter
    def enable_spot_instance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_spot_instance", value)

    @property
    @pulumi.getter(name="enableVpcDnsServer")
    def enable_vpc_dns_server(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable vpc_dns_server for Gateway. Valid values: true, false.
        """
        return pulumi.get(self, "enable_vpc_dns_server")

    @enable_vpc_dns_server.setter
    def enable_vpc_dns_server(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_vpc_dns_server", value)

    @property
    @pulumi.getter(name="enableVpnNat")
    def enable_vpn_nat(self) -> Optional[pulumi.Input[bool]]:
        """
        This field indicates whether to enable VPN NAT or not. Only supported for VPN gateway. Valid values: true, false.
        Default value: true.
        """
        return pulumi.get(self, "enable_vpn_nat")

    @enable_vpn_nat.setter
    def enable_vpn_nat(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_vpn_nat", value)

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Fault domain for OCI.
        """
        return pulumi.get(self, "fault_domain")

    @fault_domain.setter
    def fault_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fault_domain", value)

    @property
    @pulumi.getter(name="fqdnLanCidr")
    def fqdn_lan_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        FQDN gateway lan interface cidr.
        """
        return pulumi.get(self, "fqdn_lan_cidr")

    @fqdn_lan_cidr.setter
    def fqdn_lan_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fqdn_lan_cidr", value)

    @property
    @pulumi.getter(name="fqdnLanVpcId")
    def fqdn_lan_vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        LAN VPC ID. Only used for GCP FQDN Gateway.
        """
        return pulumi.get(self, "fqdn_lan_vpc_id")

    @fqdn_lan_vpc_id.setter
    def fqdn_lan_vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fqdn_lan_vpc_id", value)

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Typed value when modifying idle_timeout. If it's -1, this feature is disabled.
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_timeout", value)

    @property
    @pulumi.getter(name="imageVersion")
    def image_version(self) -> Optional[pulumi.Input[str]]:
        """
        image_version can be used to set the desired image version of the gateway. If set, we will attempt to update the gateway
        to the specified version.
        """
        return pulumi.get(self, "image_version")

    @image_version.setter
    def image_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_version", value)

    @property
    @pulumi.getter(name="insaneMode")
    def insane_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Insane Mode for Gateway. Valid values: true, false.
        """
        return pulumi.get(self, "insane_mode")

    @insane_mode.setter
    def insane_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "insane_mode", value)

    @property
    @pulumi.getter(name="insaneModeAz")
    def insane_mode_az(self) -> Optional[pulumi.Input[str]]:
        """
        AZ of subnet being created for Insane Mode Gateway. Required if insane_mode is set.
        """
        return pulumi.get(self, "insane_mode_az")

    @insane_mode_az.setter
    def insane_mode_az(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "insane_mode_az", value)

    @property
    @pulumi.getter(name="ldapBaseDn")
    def ldap_base_dn(self) -> Optional[pulumi.Input[str]]:
        """
        LDAP base DN. Required: Yes if enable_ldap is 'yes'.
        """
        return pulumi.get(self, "ldap_base_dn")

    @ldap_base_dn.setter
    def ldap_base_dn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ldap_base_dn", value)

    @property
    @pulumi.getter(name="ldapBindDn")
    def ldap_bind_dn(self) -> Optional[pulumi.Input[str]]:
        """
        LDAP bind DN. Required: Yes if enable_ldap is 'yes'.
        """
        return pulumi.get(self, "ldap_bind_dn")

    @ldap_bind_dn.setter
    def ldap_bind_dn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ldap_bind_dn", value)

    @property
    @pulumi.getter(name="ldapPassword")
    def ldap_password(self) -> Optional[pulumi.Input[str]]:
        """
        LDAP password. Required: Yes if enable_ldap is 'yes'.
        """
        return pulumi.get(self, "ldap_password")

    @ldap_password.setter
    def ldap_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ldap_password", value)

    @property
    @pulumi.getter(name="ldapServer")
    def ldap_server(self) -> Optional[pulumi.Input[str]]:
        """
        LDAP server address. Required: Yes if enable_ldap is 'yes'.
        """
        return pulumi.get(self, "ldap_server")

    @ldap_server.setter
    def ldap_server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ldap_server", value)

    @property
    @pulumi.getter(name="ldapUsernameAttribute")
    def ldap_username_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        LDAP user attribute. Required: Yes if enable_ldap is 'yes'.
        """
        return pulumi.get(self, "ldap_username_attribute")

    @ldap_username_attribute.setter
    def ldap_username_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ldap_username_attribute", value)

    @property
    @pulumi.getter(name="maxVpnConn")
    def max_vpn_conn(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum connection of VPN access.
        """
        return pulumi.get(self, "max_vpn_conn")

    @max_vpn_conn.setter
    def max_vpn_conn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_vpn_conn", value)

    @property
    @pulumi.getter(name="monitorExcludeLists")
    def monitor_exclude_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A set of monitored instance ids. Only valid when 'enable_monitor_gateway_subnets' = true.
        """
        return pulumi.get(self, "monitor_exclude_lists")

    @monitor_exclude_lists.setter
    def monitor_exclude_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "monitor_exclude_lists", value)

    @property
    @pulumi.getter(name="nameServers")
    def name_servers(self) -> Optional[pulumi.Input[str]]:
        """
        A list of DNS servers used to resolve domain names by a connected VPN user when Split Tunnel Mode is enabled.
        """
        return pulumi.get(self, "name_servers")

    @name_servers.setter
    def name_servers(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_servers", value)

    @property
    @pulumi.getter(name="oktaToken")
    def okta_token(self) -> Optional[pulumi.Input[str]]:
        """
        Token for Okta auth mode.
        """
        return pulumi.get(self, "okta_token")

    @okta_token.setter
    def okta_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "okta_token", value)

    @property
    @pulumi.getter(name="oktaUrl")
    def okta_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL for Okta auth mode.
        """
        return pulumi.get(self, "okta_url")

    @okta_url.setter
    def okta_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "okta_url", value)

    @property
    @pulumi.getter(name="oktaUsernameSuffix")
    def okta_username_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        Username suffix for Okta auth mode.
        """
        return pulumi.get(self, "okta_username_suffix")

    @okta_username_suffix.setter
    def okta_username_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "okta_username_suffix", value)

    @property
    @pulumi.getter(name="otpMode")
    def otp_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Two step authentication mode.
        """
        return pulumi.get(self, "otp_mode")

    @otp_mode.setter
    def otp_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "otp_mode", value)

    @property
    @pulumi.getter(name="peeringHaAvailabilityDomain")
    def peering_ha_availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Peering HA availability domain for OCI.
        """
        return pulumi.get(self, "peering_ha_availability_domain")

    @peering_ha_availability_domain.setter
    def peering_ha_availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_ha_availability_domain", value)

    @property
    @pulumi.getter(name="peeringHaAzureEipNameResourceGroup")
    def peering_ha_azure_eip_name_resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the public IP address and its resource group in Azure to assign to the Peering HA Gateway.
        """
        return pulumi.get(self, "peering_ha_azure_eip_name_resource_group")

    @peering_ha_azure_eip_name_resource_group.setter
    def peering_ha_azure_eip_name_resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_ha_azure_eip_name_resource_group", value)

    @property
    @pulumi.getter(name="peeringHaEip")
    def peering_ha_eip(self) -> Optional[pulumi.Input[str]]:
        """
        Public IP address that you want assigned to the HA peering instance.
        """
        return pulumi.get(self, "peering_ha_eip")

    @peering_ha_eip.setter
    def peering_ha_eip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_ha_eip", value)

    @property
    @pulumi.getter(name="peeringHaFaultDomain")
    def peering_ha_fault_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Peering HA fault domain for OCI.
        """
        return pulumi.get(self, "peering_ha_fault_domain")

    @peering_ha_fault_domain.setter
    def peering_ha_fault_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_ha_fault_domain", value)

    @property
    @pulumi.getter(name="peeringHaGwSize")
    def peering_ha_gw_size(self) -> Optional[pulumi.Input[str]]:
        """
        Peering HA Gateway Size.
        """
        return pulumi.get(self, "peering_ha_gw_size")

    @peering_ha_gw_size.setter
    def peering_ha_gw_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_ha_gw_size", value)

    @property
    @pulumi.getter(name="peeringHaImageVersion")
    def peering_ha_image_version(self) -> Optional[pulumi.Input[str]]:
        """
        peering_ha_image_version can be used to set the desired image version of the HA gateway. If set, we will attempt to
        update the gateway to the specified version.
        """
        return pulumi.get(self, "peering_ha_image_version")

    @peering_ha_image_version.setter
    def peering_ha_image_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_ha_image_version", value)

    @property
    @pulumi.getter(name="peeringHaInsaneModeAz")
    def peering_ha_insane_mode_az(self) -> Optional[pulumi.Input[str]]:
        """
        AZ of subnet being created for Insane Mode Peering HA Gateway. Required if insane_mode is set.
        """
        return pulumi.get(self, "peering_ha_insane_mode_az")

    @peering_ha_insane_mode_az.setter
    def peering_ha_insane_mode_az(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_ha_insane_mode_az", value)

    @property
    @pulumi.getter(name="peeringHaSoftwareVersion")
    def peering_ha_software_version(self) -> Optional[pulumi.Input[str]]:
        """
        peering_ha_software_version can be used to set the desired software version of the HA gateway. If set, we will attempt
        to update the gateway to the specified version. If left blank, the gateway software version will continue to be managed
        through the aviatrix_controller_config resource.
        """
        return pulumi.get(self, "peering_ha_software_version")

    @peering_ha_software_version.setter
    def peering_ha_software_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_ha_software_version", value)

    @property
    @pulumi.getter(name="peeringHaSubnet")
    def peering_ha_subnet(self) -> Optional[pulumi.Input[str]]:
        """
        Public Subnet Information while creating Peering HA Gateway, only subnet is accepted. Required to create peering ha
        gateway if cloud_type = 1 or 8 (AWS or Azure). Optional if cloud_type = 4 (GCP)
        """
        return pulumi.get(self, "peering_ha_subnet")

    @peering_ha_subnet.setter
    def peering_ha_subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_ha_subnet", value)

    @property
    @pulumi.getter(name="peeringHaZone")
    def peering_ha_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Zone information for creating Peering HA Gateway. Required to create peering ha gateway if cloud_type = 4 (GCP).
        Optional for cloud_type = 8 (Azure).
        """
        return pulumi.get(self, "peering_ha_zone")

    @peering_ha_zone.setter
    def peering_ha_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_ha_zone", value)

    @property
    @pulumi.getter(name="publicSubnetFilteringGuardDutyEnforced")
    def public_subnet_filtering_guard_duty_enforced(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enforce Guard Duty IP blocking. Required when `enable_public_subnet_filtering` attribute is true. Valid
        values: true or false. Default value: true.
        """
        return pulumi.get(self, "public_subnet_filtering_guard_duty_enforced")

    @public_subnet_filtering_guard_duty_enforced.setter
    def public_subnet_filtering_guard_duty_enforced(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "public_subnet_filtering_guard_duty_enforced", value)

    @property
    @pulumi.getter(name="publicSubnetFilteringHaRouteTables")
    def public_subnet_filtering_ha_route_tables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Route tables whose associated public subnets are protected for the HA PSF gateway. Required when
        enable_public_subnet_filtering and peering_ha_subnet are set.
        """
        return pulumi.get(self, "public_subnet_filtering_ha_route_tables")

    @public_subnet_filtering_ha_route_tables.setter
    def public_subnet_filtering_ha_route_tables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "public_subnet_filtering_ha_route_tables", value)

    @property
    @pulumi.getter(name="publicSubnetFilteringRouteTables")
    def public_subnet_filtering_route_tables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Route tables whose associated public subnets are protected. Required when `enable_public_subnet_filtering` attribute is
        true.
        """
        return pulumi.get(self, "public_subnet_filtering_route_tables")

    @public_subnet_filtering_route_tables.setter
    def public_subnet_filtering_route_tables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "public_subnet_filtering_route_tables", value)

    @property
    @pulumi.getter(name="renegotiationInterval")
    def renegotiation_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Typed value when modifying renegotiation_interval. If it's -1, this feature is disabled.
        """
        return pulumi.get(self, "renegotiation_interval")

    @renegotiation_interval.setter
    def renegotiation_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "renegotiation_interval", value)

    @property
    @pulumi.getter(name="rxQueueSize")
    def rx_queue_size(self) -> Optional[pulumi.Input[str]]:
        """
        Gateway ethernet interface RX queue size. Supported for AWS related clouds only.
        """
        return pulumi.get(self, "rx_queue_size")

    @rx_queue_size.setter
    def rx_queue_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rx_queue_size", value)

    @property
    @pulumi.getter(name="samlEnabled")
    def saml_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        This field indicates whether to enable SAML or not.
        """
        return pulumi.get(self, "saml_enabled")

    @saml_enabled.setter
    def saml_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "saml_enabled", value)

    @property
    @pulumi.getter(name="searchDomains")
    def search_domains(self) -> Optional[pulumi.Input[str]]:
        """
        A list of domain names that will use the NameServer when a specific name is not in the destination when Split Tunnel
        Mode is enabled.
        """
        return pulumi.get(self, "search_domains")

    @search_domains.setter
    def search_domains(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "search_domains", value)

    @property
    @pulumi.getter(name="singleAzHa")
    def single_az_ha(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true if this feature is desired.
        """
        return pulumi.get(self, "single_az_ha")

    @single_az_ha.setter
    def single_az_ha(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "single_az_ha", value)

    @property
    @pulumi.getter(name="singleIpSnat")
    def single_ip_snat(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Source NAT for this container.
        """
        return pulumi.get(self, "single_ip_snat")

    @single_ip_snat.setter
    def single_ip_snat(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "single_ip_snat", value)

    @property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> Optional[pulumi.Input[str]]:
        """
        software_version can be used to set the desired software version of the gateway. If set, we will attempt to update the
        gateway to the specified version. If left blank, the gateway software version will continue to be managed through the
        aviatrix_controller_config resource.
        """
        return pulumi.get(self, "software_version")

    @software_version.setter
    def software_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "software_version", value)

    @property
    @pulumi.getter(name="splitTunnel")
    def split_tunnel(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify split tunnel mode.
        """
        return pulumi.get(self, "split_tunnel")

    @split_tunnel.setter
    def split_tunnel(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "split_tunnel", value)

    @property
    @pulumi.getter(name="spotPrice")
    def spot_price(self) -> Optional[pulumi.Input[str]]:
        """
        Price for spot instance. NOT supported for production deployment.
        """
        return pulumi.get(self, "spot_price")

    @spot_price.setter
    def spot_price(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spot_price", value)

    @property
    @pulumi.getter(name="tagLists")
    def tag_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Instance tag of cloud provider.
        """
        return pulumi.get(self, "tag_lists")

    @tag_lists.setter
    def tag_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tag_lists", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the gateway.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tunnelDetectionTime")
    def tunnel_detection_time(self) -> Optional[pulumi.Input[int]]:
        """
        The IPSec tunnel down detection time for the Gateway.
        """
        return pulumi.get(self, "tunnel_detection_time")

    @tunnel_detection_time.setter
    def tunnel_detection_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tunnel_detection_time", value)

    @property
    @pulumi.getter(name="vpnAccess")
    def vpn_access(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable user access through VPN to this container.
        """
        return pulumi.get(self, "vpn_access")

    @vpn_access.setter
    def vpn_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vpn_access", value)

    @property
    @pulumi.getter(name="vpnCidr")
    def vpn_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        VPN CIDR block for the container.
        """
        return pulumi.get(self, "vpn_cidr")

    @vpn_cidr.setter
    def vpn_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpn_cidr", value)

    @property
    @pulumi.getter(name="vpnProtocol")
    def vpn_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Elb protocol for VPN gateway with elb enabled. Only supports AWS provider. Valid values: 'TCP', 'UDP'. If not specified,
        'TCP'' will be used.
        """
        return pulumi.get(self, "vpn_protocol")

    @vpn_protocol.setter
    def vpn_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpn_protocol", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        Availability Zone. Only available for Azure and Public Subnet Filtering gateway
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _AviatrixGatewayState:
    def __init__(__self__, *,
                 account_name: Optional[pulumi.Input[str]] = None,
                 additional_cidrs: Optional[pulumi.Input[str]] = None,
                 additional_cidrs_designated_gateway: Optional[pulumi.Input[str]] = None,
                 allocate_new_eip: Optional[pulumi.Input[bool]] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 azure_eip_name_resource_group: Optional[pulumi.Input[str]] = None,
                 cloud_instance_id: Optional[pulumi.Input[str]] = None,
                 cloud_type: Optional[pulumi.Input[int]] = None,
                 customer_managed_keys: Optional[pulumi.Input[str]] = None,
                 duo_api_hostname: Optional[pulumi.Input[str]] = None,
                 duo_integration_key: Optional[pulumi.Input[str]] = None,
                 duo_push_mode: Optional[pulumi.Input[str]] = None,
                 duo_secret_key: Optional[pulumi.Input[str]] = None,
                 eip: Optional[pulumi.Input[str]] = None,
                 elb_dns_name: Optional[pulumi.Input[str]] = None,
                 elb_name: Optional[pulumi.Input[str]] = None,
                 enable_designated_gateway: Optional[pulumi.Input[bool]] = None,
                 enable_elb: Optional[pulumi.Input[bool]] = None,
                 enable_encrypt_volume: Optional[pulumi.Input[bool]] = None,
                 enable_jumbo_frame: Optional[pulumi.Input[bool]] = None,
                 enable_ldap: Optional[pulumi.Input[bool]] = None,
                 enable_monitor_gateway_subnets: Optional[pulumi.Input[bool]] = None,
                 enable_public_subnet_filtering: Optional[pulumi.Input[bool]] = None,
                 enable_spot_instance: Optional[pulumi.Input[bool]] = None,
                 enable_vpc_dns_server: Optional[pulumi.Input[bool]] = None,
                 enable_vpn_nat: Optional[pulumi.Input[bool]] = None,
                 fault_domain: Optional[pulumi.Input[str]] = None,
                 fqdn_lan_cidr: Optional[pulumi.Input[str]] = None,
                 fqdn_lan_interface: Optional[pulumi.Input[str]] = None,
                 fqdn_lan_vpc_id: Optional[pulumi.Input[str]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 gw_size: Optional[pulumi.Input[str]] = None,
                 idle_timeout: Optional[pulumi.Input[int]] = None,
                 image_version: Optional[pulumi.Input[str]] = None,
                 insane_mode: Optional[pulumi.Input[bool]] = None,
                 insane_mode_az: Optional[pulumi.Input[str]] = None,
                 ldap_base_dn: Optional[pulumi.Input[str]] = None,
                 ldap_bind_dn: Optional[pulumi.Input[str]] = None,
                 ldap_password: Optional[pulumi.Input[str]] = None,
                 ldap_server: Optional[pulumi.Input[str]] = None,
                 ldap_username_attribute: Optional[pulumi.Input[str]] = None,
                 max_vpn_conn: Optional[pulumi.Input[str]] = None,
                 monitor_exclude_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name_servers: Optional[pulumi.Input[str]] = None,
                 okta_token: Optional[pulumi.Input[str]] = None,
                 okta_url: Optional[pulumi.Input[str]] = None,
                 okta_username_suffix: Optional[pulumi.Input[str]] = None,
                 otp_mode: Optional[pulumi.Input[str]] = None,
                 peering_ha_availability_domain: Optional[pulumi.Input[str]] = None,
                 peering_ha_azure_eip_name_resource_group: Optional[pulumi.Input[str]] = None,
                 peering_ha_cloud_instance_id: Optional[pulumi.Input[str]] = None,
                 peering_ha_eip: Optional[pulumi.Input[str]] = None,
                 peering_ha_fault_domain: Optional[pulumi.Input[str]] = None,
                 peering_ha_gw_name: Optional[pulumi.Input[str]] = None,
                 peering_ha_gw_size: Optional[pulumi.Input[str]] = None,
                 peering_ha_image_version: Optional[pulumi.Input[str]] = None,
                 peering_ha_insane_mode_az: Optional[pulumi.Input[str]] = None,
                 peering_ha_private_ip: Optional[pulumi.Input[str]] = None,
                 peering_ha_security_group_id: Optional[pulumi.Input[str]] = None,
                 peering_ha_software_version: Optional[pulumi.Input[str]] = None,
                 peering_ha_subnet: Optional[pulumi.Input[str]] = None,
                 peering_ha_zone: Optional[pulumi.Input[str]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None,
                 public_dns_server: Optional[pulumi.Input[str]] = None,
                 public_subnet_filtering_guard_duty_enforced: Optional[pulumi.Input[bool]] = None,
                 public_subnet_filtering_ha_route_tables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 public_subnet_filtering_route_tables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 renegotiation_interval: Optional[pulumi.Input[int]] = None,
                 rx_queue_size: Optional[pulumi.Input[str]] = None,
                 saml_enabled: Optional[pulumi.Input[bool]] = None,
                 search_domains: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 single_az_ha: Optional[pulumi.Input[bool]] = None,
                 single_ip_snat: Optional[pulumi.Input[bool]] = None,
                 software_version: Optional[pulumi.Input[str]] = None,
                 split_tunnel: Optional[pulumi.Input[bool]] = None,
                 spot_price: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 tag_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tunnel_detection_time: Optional[pulumi.Input[int]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vpc_reg: Optional[pulumi.Input[str]] = None,
                 vpn_access: Optional[pulumi.Input[bool]] = None,
                 vpn_cidr: Optional[pulumi.Input[str]] = None,
                 vpn_protocol: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixGateway resources.
        :param pulumi.Input[str] account_name: Account name. This account will be used to launch Aviatrix gateway.
        :param pulumi.Input[str] additional_cidrs: A list of destination CIDR ranges that will also go through the VPN tunnel when Split Tunnel Mode is enabled.
        :param pulumi.Input[str] additional_cidrs_designated_gateway: A list of CIDR ranges separated by comma to configure when 'designated_gateway' feature is enabled.
        :param pulumi.Input[bool] allocate_new_eip: When value is false, reuse an idle address in Elastic IP pool for this gateway. Otherwise, allocate a new Elastic IP and
               use it for this gateway.
        :param pulumi.Input[str] availability_domain: Availability domain for OCI.
        :param pulumi.Input[str] azure_eip_name_resource_group: The name of the public IP address and its resource group in Azure to assign to this Gateway.
        :param pulumi.Input[str] cloud_instance_id: Instance ID of the gateway.
        :param pulumi.Input[int] cloud_type: Type of cloud service provider.
        :param pulumi.Input[str] customer_managed_keys: Customer managed key ID.
        :param pulumi.Input[str] duo_api_hostname: API hostname for DUO auth mode.
        :param pulumi.Input[str] duo_integration_key: Integration key for DUO auth mode.
        :param pulumi.Input[str] duo_push_mode: Push mode for DUO auth.
        :param pulumi.Input[str] duo_secret_key: Secret key for DUO auth mode.
        :param pulumi.Input[str] eip: Required when allocate_new_eip is false. It uses specified EIP for this gateway.
        :param pulumi.Input[str] elb_dns_name: ELB DNS Name.
        :param pulumi.Input[str] elb_name: A name for the ELB that is created.
        :param pulumi.Input[bool] enable_designated_gateway: Enable 'designated_gateway' feature for Gateway. Valid values: true, false.
        :param pulumi.Input[bool] enable_elb: Specify whether to enable ELB or not.
        :param pulumi.Input[bool] enable_encrypt_volume: Enable encrypt gateway EBS volume. Only supported for AWS provider. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_jumbo_frame: Enable jumbo frame support for Gateway. Valid values: true or false. Default value: true.
        :param pulumi.Input[bool] enable_ldap: Specify whether to enable LDAP or not. Supported values: 'yes' and 'no'.
        :param pulumi.Input[bool] enable_monitor_gateway_subnets: Enable monitor gateway subnets. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_public_subnet_filtering: Create a [Public Subnet Filtering gateway](https://docs.aviatrix.com/HowTos/public_subnet_filtering_faq.html).
        :param pulumi.Input[bool] enable_spot_instance: Enable spot instance. NOT supported for production deployment.
        :param pulumi.Input[bool] enable_vpc_dns_server: Enable vpc_dns_server for Gateway. Valid values: true, false.
        :param pulumi.Input[bool] enable_vpn_nat: This field indicates whether to enable VPN NAT or not. Only supported for VPN gateway. Valid values: true, false.
               Default value: true.
        :param pulumi.Input[str] fault_domain: Fault domain for OCI.
        :param pulumi.Input[str] fqdn_lan_cidr: FQDN gateway lan interface cidr.
        :param pulumi.Input[str] fqdn_lan_interface: FQDN gateway lan interface id.
        :param pulumi.Input[str] fqdn_lan_vpc_id: LAN VPC ID. Only used for GCP FQDN Gateway.
        :param pulumi.Input[str] gw_name: Aviatrix gateway unique name.
        :param pulumi.Input[str] gw_size: Size of Gateway Instance.
        :param pulumi.Input[int] idle_timeout: Typed value when modifying idle_timeout. If it's -1, this feature is disabled.
        :param pulumi.Input[str] image_version: image_version can be used to set the desired image version of the gateway. If set, we will attempt to update the gateway
               to the specified version.
        :param pulumi.Input[bool] insane_mode: Enable Insane Mode for Gateway. Valid values: true, false.
        :param pulumi.Input[str] insane_mode_az: AZ of subnet being created for Insane Mode Gateway. Required if insane_mode is set.
        :param pulumi.Input[str] ldap_base_dn: LDAP base DN. Required: Yes if enable_ldap is 'yes'.
        :param pulumi.Input[str] ldap_bind_dn: LDAP bind DN. Required: Yes if enable_ldap is 'yes'.
        :param pulumi.Input[str] ldap_password: LDAP password. Required: Yes if enable_ldap is 'yes'.
        :param pulumi.Input[str] ldap_server: LDAP server address. Required: Yes if enable_ldap is 'yes'.
        :param pulumi.Input[str] ldap_username_attribute: LDAP user attribute. Required: Yes if enable_ldap is 'yes'.
        :param pulumi.Input[str] max_vpn_conn: Maximum connection of VPN access.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] monitor_exclude_lists: A set of monitored instance ids. Only valid when 'enable_monitor_gateway_subnets' = true.
        :param pulumi.Input[str] name_servers: A list of DNS servers used to resolve domain names by a connected VPN user when Split Tunnel Mode is enabled.
        :param pulumi.Input[str] okta_token: Token for Okta auth mode.
        :param pulumi.Input[str] okta_url: URL for Okta auth mode.
        :param pulumi.Input[str] okta_username_suffix: Username suffix for Okta auth mode.
        :param pulumi.Input[str] otp_mode: Two step authentication mode.
        :param pulumi.Input[str] peering_ha_availability_domain: Peering HA availability domain for OCI.
        :param pulumi.Input[str] peering_ha_azure_eip_name_resource_group: The name of the public IP address and its resource group in Azure to assign to the Peering HA Gateway.
        :param pulumi.Input[str] peering_ha_cloud_instance_id: Instance ID of the peering HA gateway.
        :param pulumi.Input[str] peering_ha_eip: Public IP address that you want assigned to the HA peering instance.
        :param pulumi.Input[str] peering_ha_fault_domain: Peering HA fault domain for OCI.
        :param pulumi.Input[str] peering_ha_gw_name: Aviatrix gateway unique name of HA gateway.
        :param pulumi.Input[str] peering_ha_gw_size: Peering HA Gateway Size.
        :param pulumi.Input[str] peering_ha_image_version: peering_ha_image_version can be used to set the desired image version of the HA gateway. If set, we will attempt to
               update the gateway to the specified version.
        :param pulumi.Input[str] peering_ha_insane_mode_az: AZ of subnet being created for Insane Mode Peering HA Gateway. Required if insane_mode is set.
        :param pulumi.Input[str] peering_ha_private_ip: Private IP address of HA gateway.
        :param pulumi.Input[str] peering_ha_security_group_id: Peering HA security group used for the gateway.
        :param pulumi.Input[str] peering_ha_software_version: peering_ha_software_version can be used to set the desired software version of the HA gateway. If set, we will attempt
               to update the gateway to the specified version. If left blank, the gateway software version will continue to be managed
               through the aviatrix_controller_config resource.
        :param pulumi.Input[str] peering_ha_subnet: Public Subnet Information while creating Peering HA Gateway, only subnet is accepted. Required to create peering ha
               gateway if cloud_type = 1 or 8 (AWS or Azure). Optional if cloud_type = 4 (GCP)
        :param pulumi.Input[str] peering_ha_zone: Zone information for creating Peering HA Gateway. Required to create peering ha gateway if cloud_type = 4 (GCP).
               Optional for cloud_type = 8 (Azure).
        :param pulumi.Input[str] private_ip: Private IP address of the Gateway created.
        :param pulumi.Input[str] public_dns_server: NS server used by the gateway.
        :param pulumi.Input[bool] public_subnet_filtering_guard_duty_enforced: Whether to enforce Guard Duty IP blocking. Required when `enable_public_subnet_filtering` attribute is true. Valid
               values: true or false. Default value: true.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] public_subnet_filtering_ha_route_tables: Route tables whose associated public subnets are protected for the HA PSF gateway. Required when
               enable_public_subnet_filtering and peering_ha_subnet are set.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] public_subnet_filtering_route_tables: Route tables whose associated public subnets are protected. Required when `enable_public_subnet_filtering` attribute is
               true.
        :param pulumi.Input[int] renegotiation_interval: Typed value when modifying renegotiation_interval. If it's -1, this feature is disabled.
        :param pulumi.Input[str] rx_queue_size: Gateway ethernet interface RX queue size. Supported for AWS related clouds only.
        :param pulumi.Input[bool] saml_enabled: This field indicates whether to enable SAML or not.
        :param pulumi.Input[str] search_domains: A list of domain names that will use the NameServer when a specific name is not in the destination when Split Tunnel
               Mode is enabled.
        :param pulumi.Input[str] security_group_id: Security group used for the gateway.
        :param pulumi.Input[bool] single_az_ha: Set to true if this feature is desired.
        :param pulumi.Input[bool] single_ip_snat: Enable Source NAT for this container.
        :param pulumi.Input[str] software_version: software_version can be used to set the desired software version of the gateway. If set, we will attempt to update the
               gateway to the specified version. If left blank, the gateway software version will continue to be managed through the
               aviatrix_controller_config resource.
        :param pulumi.Input[bool] split_tunnel: Specify split tunnel mode.
        :param pulumi.Input[str] spot_price: Price for spot instance. NOT supported for production deployment.
        :param pulumi.Input[str] subnet: A VPC Network address range selected from one of the available network ranges.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tag_lists: Instance tag of cloud provider.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the gateway.
        :param pulumi.Input[int] tunnel_detection_time: The IPSec tunnel down detection time for the Gateway.
        :param pulumi.Input[str] vpc_id: ID of legacy VPC/Vnet to be connected.
        :param pulumi.Input[str] vpc_reg: Region where this gateway will be launched.
        :param pulumi.Input[bool] vpn_access: Enable user access through VPN to this container.
        :param pulumi.Input[str] vpn_cidr: VPN CIDR block for the container.
        :param pulumi.Input[str] vpn_protocol: Elb protocol for VPN gateway with elb enabled. Only supports AWS provider. Valid values: 'TCP', 'UDP'. If not specified,
               'TCP'' will be used.
        :param pulumi.Input[str] zone: Availability Zone. Only available for Azure and Public Subnet Filtering gateway
        """
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if additional_cidrs is not None:
            pulumi.set(__self__, "additional_cidrs", additional_cidrs)
        if additional_cidrs_designated_gateway is not None:
            pulumi.set(__self__, "additional_cidrs_designated_gateway", additional_cidrs_designated_gateway)
        if allocate_new_eip is not None:
            pulumi.set(__self__, "allocate_new_eip", allocate_new_eip)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if azure_eip_name_resource_group is not None:
            pulumi.set(__self__, "azure_eip_name_resource_group", azure_eip_name_resource_group)
        if cloud_instance_id is not None:
            pulumi.set(__self__, "cloud_instance_id", cloud_instance_id)
        if cloud_type is not None:
            pulumi.set(__self__, "cloud_type", cloud_type)
        if customer_managed_keys is not None:
            pulumi.set(__self__, "customer_managed_keys", customer_managed_keys)
        if duo_api_hostname is not None:
            pulumi.set(__self__, "duo_api_hostname", duo_api_hostname)
        if duo_integration_key is not None:
            pulumi.set(__self__, "duo_integration_key", duo_integration_key)
        if duo_push_mode is not None:
            pulumi.set(__self__, "duo_push_mode", duo_push_mode)
        if duo_secret_key is not None:
            pulumi.set(__self__, "duo_secret_key", duo_secret_key)
        if eip is not None:
            pulumi.set(__self__, "eip", eip)
        if elb_dns_name is not None:
            pulumi.set(__self__, "elb_dns_name", elb_dns_name)
        if elb_name is not None:
            pulumi.set(__self__, "elb_name", elb_name)
        if enable_designated_gateway is not None:
            pulumi.set(__self__, "enable_designated_gateway", enable_designated_gateway)
        if enable_elb is not None:
            pulumi.set(__self__, "enable_elb", enable_elb)
        if enable_encrypt_volume is not None:
            pulumi.set(__self__, "enable_encrypt_volume", enable_encrypt_volume)
        if enable_jumbo_frame is not None:
            pulumi.set(__self__, "enable_jumbo_frame", enable_jumbo_frame)
        if enable_ldap is not None:
            pulumi.set(__self__, "enable_ldap", enable_ldap)
        if enable_monitor_gateway_subnets is not None:
            pulumi.set(__self__, "enable_monitor_gateway_subnets", enable_monitor_gateway_subnets)
        if enable_public_subnet_filtering is not None:
            pulumi.set(__self__, "enable_public_subnet_filtering", enable_public_subnet_filtering)
        if enable_spot_instance is not None:
            pulumi.set(__self__, "enable_spot_instance", enable_spot_instance)
        if enable_vpc_dns_server is not None:
            pulumi.set(__self__, "enable_vpc_dns_server", enable_vpc_dns_server)
        if enable_vpn_nat is not None:
            pulumi.set(__self__, "enable_vpn_nat", enable_vpn_nat)
        if fault_domain is not None:
            pulumi.set(__self__, "fault_domain", fault_domain)
        if fqdn_lan_cidr is not None:
            pulumi.set(__self__, "fqdn_lan_cidr", fqdn_lan_cidr)
        if fqdn_lan_interface is not None:
            pulumi.set(__self__, "fqdn_lan_interface", fqdn_lan_interface)
        if fqdn_lan_vpc_id is not None:
            pulumi.set(__self__, "fqdn_lan_vpc_id", fqdn_lan_vpc_id)
        if gw_name is not None:
            pulumi.set(__self__, "gw_name", gw_name)
        if gw_size is not None:
            pulumi.set(__self__, "gw_size", gw_size)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if image_version is not None:
            pulumi.set(__self__, "image_version", image_version)
        if insane_mode is not None:
            pulumi.set(__self__, "insane_mode", insane_mode)
        if insane_mode_az is not None:
            pulumi.set(__self__, "insane_mode_az", insane_mode_az)
        if ldap_base_dn is not None:
            pulumi.set(__self__, "ldap_base_dn", ldap_base_dn)
        if ldap_bind_dn is not None:
            pulumi.set(__self__, "ldap_bind_dn", ldap_bind_dn)
        if ldap_password is not None:
            pulumi.set(__self__, "ldap_password", ldap_password)
        if ldap_server is not None:
            pulumi.set(__self__, "ldap_server", ldap_server)
        if ldap_username_attribute is not None:
            pulumi.set(__self__, "ldap_username_attribute", ldap_username_attribute)
        if max_vpn_conn is not None:
            pulumi.set(__self__, "max_vpn_conn", max_vpn_conn)
        if monitor_exclude_lists is not None:
            pulumi.set(__self__, "monitor_exclude_lists", monitor_exclude_lists)
        if name_servers is not None:
            pulumi.set(__self__, "name_servers", name_servers)
        if okta_token is not None:
            pulumi.set(__self__, "okta_token", okta_token)
        if okta_url is not None:
            pulumi.set(__self__, "okta_url", okta_url)
        if okta_username_suffix is not None:
            pulumi.set(__self__, "okta_username_suffix", okta_username_suffix)
        if otp_mode is not None:
            pulumi.set(__self__, "otp_mode", otp_mode)
        if peering_ha_availability_domain is not None:
            pulumi.set(__self__, "peering_ha_availability_domain", peering_ha_availability_domain)
        if peering_ha_azure_eip_name_resource_group is not None:
            pulumi.set(__self__, "peering_ha_azure_eip_name_resource_group", peering_ha_azure_eip_name_resource_group)
        if peering_ha_cloud_instance_id is not None:
            pulumi.set(__self__, "peering_ha_cloud_instance_id", peering_ha_cloud_instance_id)
        if peering_ha_eip is not None:
            pulumi.set(__self__, "peering_ha_eip", peering_ha_eip)
        if peering_ha_fault_domain is not None:
            pulumi.set(__self__, "peering_ha_fault_domain", peering_ha_fault_domain)
        if peering_ha_gw_name is not None:
            pulumi.set(__self__, "peering_ha_gw_name", peering_ha_gw_name)
        if peering_ha_gw_size is not None:
            pulumi.set(__self__, "peering_ha_gw_size", peering_ha_gw_size)
        if peering_ha_image_version is not None:
            pulumi.set(__self__, "peering_ha_image_version", peering_ha_image_version)
        if peering_ha_insane_mode_az is not None:
            pulumi.set(__self__, "peering_ha_insane_mode_az", peering_ha_insane_mode_az)
        if peering_ha_private_ip is not None:
            pulumi.set(__self__, "peering_ha_private_ip", peering_ha_private_ip)
        if peering_ha_security_group_id is not None:
            pulumi.set(__self__, "peering_ha_security_group_id", peering_ha_security_group_id)
        if peering_ha_software_version is not None:
            pulumi.set(__self__, "peering_ha_software_version", peering_ha_software_version)
        if peering_ha_subnet is not None:
            pulumi.set(__self__, "peering_ha_subnet", peering_ha_subnet)
        if peering_ha_zone is not None:
            pulumi.set(__self__, "peering_ha_zone", peering_ha_zone)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if public_dns_server is not None:
            pulumi.set(__self__, "public_dns_server", public_dns_server)
        if public_subnet_filtering_guard_duty_enforced is not None:
            pulumi.set(__self__, "public_subnet_filtering_guard_duty_enforced", public_subnet_filtering_guard_duty_enforced)
        if public_subnet_filtering_ha_route_tables is not None:
            pulumi.set(__self__, "public_subnet_filtering_ha_route_tables", public_subnet_filtering_ha_route_tables)
        if public_subnet_filtering_route_tables is not None:
            pulumi.set(__self__, "public_subnet_filtering_route_tables", public_subnet_filtering_route_tables)
        if renegotiation_interval is not None:
            pulumi.set(__self__, "renegotiation_interval", renegotiation_interval)
        if rx_queue_size is not None:
            pulumi.set(__self__, "rx_queue_size", rx_queue_size)
        if saml_enabled is not None:
            pulumi.set(__self__, "saml_enabled", saml_enabled)
        if search_domains is not None:
            pulumi.set(__self__, "search_domains", search_domains)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if single_az_ha is not None:
            pulumi.set(__self__, "single_az_ha", single_az_ha)
        if single_ip_snat is not None:
            pulumi.set(__self__, "single_ip_snat", single_ip_snat)
        if software_version is not None:
            pulumi.set(__self__, "software_version", software_version)
        if split_tunnel is not None:
            pulumi.set(__self__, "split_tunnel", split_tunnel)
        if spot_price is not None:
            pulumi.set(__self__, "spot_price", spot_price)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if tag_lists is not None:
            warnings.warn("""Use tags instead.""", DeprecationWarning)
            pulumi.log.warn("""tag_lists is deprecated: Use tags instead.""")
        if tag_lists is not None:
            pulumi.set(__self__, "tag_lists", tag_lists)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tunnel_detection_time is not None:
            pulumi.set(__self__, "tunnel_detection_time", tunnel_detection_time)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vpc_reg is not None:
            pulumi.set(__self__, "vpc_reg", vpc_reg)
        if vpn_access is not None:
            pulumi.set(__self__, "vpn_access", vpn_access)
        if vpn_cidr is not None:
            pulumi.set(__self__, "vpn_cidr", vpn_cidr)
        if vpn_protocol is not None:
            pulumi.set(__self__, "vpn_protocol", vpn_protocol)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[str]]:
        """
        Account name. This account will be used to launch Aviatrix gateway.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="additionalCidrs")
    def additional_cidrs(self) -> Optional[pulumi.Input[str]]:
        """
        A list of destination CIDR ranges that will also go through the VPN tunnel when Split Tunnel Mode is enabled.
        """
        return pulumi.get(self, "additional_cidrs")

    @additional_cidrs.setter
    def additional_cidrs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "additional_cidrs", value)

    @property
    @pulumi.getter(name="additionalCidrsDesignatedGateway")
    def additional_cidrs_designated_gateway(self) -> Optional[pulumi.Input[str]]:
        """
        A list of CIDR ranges separated by comma to configure when 'designated_gateway' feature is enabled.
        """
        return pulumi.get(self, "additional_cidrs_designated_gateway")

    @additional_cidrs_designated_gateway.setter
    def additional_cidrs_designated_gateway(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "additional_cidrs_designated_gateway", value)

    @property
    @pulumi.getter(name="allocateNewEip")
    def allocate_new_eip(self) -> Optional[pulumi.Input[bool]]:
        """
        When value is false, reuse an idle address in Elastic IP pool for this gateway. Otherwise, allocate a new Elastic IP and
        use it for this gateway.
        """
        return pulumi.get(self, "allocate_new_eip")

    @allocate_new_eip.setter
    def allocate_new_eip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allocate_new_eip", value)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Availability domain for OCI.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="azureEipNameResourceGroup")
    def azure_eip_name_resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the public IP address and its resource group in Azure to assign to this Gateway.
        """
        return pulumi.get(self, "azure_eip_name_resource_group")

    @azure_eip_name_resource_group.setter
    def azure_eip_name_resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_eip_name_resource_group", value)

    @property
    @pulumi.getter(name="cloudInstanceId")
    def cloud_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Instance ID of the gateway.
        """
        return pulumi.get(self, "cloud_instance_id")

    @cloud_instance_id.setter
    def cloud_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_instance_id", value)

    @property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> Optional[pulumi.Input[int]]:
        """
        Type of cloud service provider.
        """
        return pulumi.get(self, "cloud_type")

    @cloud_type.setter
    def cloud_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cloud_type", value)

    @property
    @pulumi.getter(name="customerManagedKeys")
    def customer_managed_keys(self) -> Optional[pulumi.Input[str]]:
        """
        Customer managed key ID.
        """
        return pulumi.get(self, "customer_managed_keys")

    @customer_managed_keys.setter
    def customer_managed_keys(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_managed_keys", value)

    @property
    @pulumi.getter(name="duoApiHostname")
    def duo_api_hostname(self) -> Optional[pulumi.Input[str]]:
        """
        API hostname for DUO auth mode.
        """
        return pulumi.get(self, "duo_api_hostname")

    @duo_api_hostname.setter
    def duo_api_hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "duo_api_hostname", value)

    @property
    @pulumi.getter(name="duoIntegrationKey")
    def duo_integration_key(self) -> Optional[pulumi.Input[str]]:
        """
        Integration key for DUO auth mode.
        """
        return pulumi.get(self, "duo_integration_key")

    @duo_integration_key.setter
    def duo_integration_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "duo_integration_key", value)

    @property
    @pulumi.getter(name="duoPushMode")
    def duo_push_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Push mode for DUO auth.
        """
        return pulumi.get(self, "duo_push_mode")

    @duo_push_mode.setter
    def duo_push_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "duo_push_mode", value)

    @property
    @pulumi.getter(name="duoSecretKey")
    def duo_secret_key(self) -> Optional[pulumi.Input[str]]:
        """
        Secret key for DUO auth mode.
        """
        return pulumi.get(self, "duo_secret_key")

    @duo_secret_key.setter
    def duo_secret_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "duo_secret_key", value)

    @property
    @pulumi.getter
    def eip(self) -> Optional[pulumi.Input[str]]:
        """
        Required when allocate_new_eip is false. It uses specified EIP for this gateway.
        """
        return pulumi.get(self, "eip")

    @eip.setter
    def eip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip", value)

    @property
    @pulumi.getter(name="elbDnsName")
    def elb_dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        ELB DNS Name.
        """
        return pulumi.get(self, "elb_dns_name")

    @elb_dns_name.setter
    def elb_dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "elb_dns_name", value)

    @property
    @pulumi.getter(name="elbName")
    def elb_name(self) -> Optional[pulumi.Input[str]]:
        """
        A name for the ELB that is created.
        """
        return pulumi.get(self, "elb_name")

    @elb_name.setter
    def elb_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "elb_name", value)

    @property
    @pulumi.getter(name="enableDesignatedGateway")
    def enable_designated_gateway(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable 'designated_gateway' feature for Gateway. Valid values: true, false.
        """
        return pulumi.get(self, "enable_designated_gateway")

    @enable_designated_gateway.setter
    def enable_designated_gateway(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_designated_gateway", value)

    @property
    @pulumi.getter(name="enableElb")
    def enable_elb(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify whether to enable ELB or not.
        """
        return pulumi.get(self, "enable_elb")

    @enable_elb.setter
    def enable_elb(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_elb", value)

    @property
    @pulumi.getter(name="enableEncryptVolume")
    def enable_encrypt_volume(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable encrypt gateway EBS volume. Only supported for AWS provider. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_encrypt_volume")

    @enable_encrypt_volume.setter
    def enable_encrypt_volume(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_encrypt_volume", value)

    @property
    @pulumi.getter(name="enableJumboFrame")
    def enable_jumbo_frame(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable jumbo frame support for Gateway. Valid values: true or false. Default value: true.
        """
        return pulumi.get(self, "enable_jumbo_frame")

    @enable_jumbo_frame.setter
    def enable_jumbo_frame(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_jumbo_frame", value)

    @property
    @pulumi.getter(name="enableLdap")
    def enable_ldap(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify whether to enable LDAP or not. Supported values: 'yes' and 'no'.
        """
        return pulumi.get(self, "enable_ldap")

    @enable_ldap.setter
    def enable_ldap(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ldap", value)

    @property
    @pulumi.getter(name="enableMonitorGatewaySubnets")
    def enable_monitor_gateway_subnets(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable monitor gateway subnets. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_monitor_gateway_subnets")

    @enable_monitor_gateway_subnets.setter
    def enable_monitor_gateway_subnets(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_monitor_gateway_subnets", value)

    @property
    @pulumi.getter(name="enablePublicSubnetFiltering")
    def enable_public_subnet_filtering(self) -> Optional[pulumi.Input[bool]]:
        """
        Create a [Public Subnet Filtering gateway](https://docs.aviatrix.com/HowTos/public_subnet_filtering_faq.html).
        """
        return pulumi.get(self, "enable_public_subnet_filtering")

    @enable_public_subnet_filtering.setter
    def enable_public_subnet_filtering(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_public_subnet_filtering", value)

    @property
    @pulumi.getter(name="enableSpotInstance")
    def enable_spot_instance(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable spot instance. NOT supported for production deployment.
        """
        return pulumi.get(self, "enable_spot_instance")

    @enable_spot_instance.setter
    def enable_spot_instance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_spot_instance", value)

    @property
    @pulumi.getter(name="enableVpcDnsServer")
    def enable_vpc_dns_server(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable vpc_dns_server for Gateway. Valid values: true, false.
        """
        return pulumi.get(self, "enable_vpc_dns_server")

    @enable_vpc_dns_server.setter
    def enable_vpc_dns_server(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_vpc_dns_server", value)

    @property
    @pulumi.getter(name="enableVpnNat")
    def enable_vpn_nat(self) -> Optional[pulumi.Input[bool]]:
        """
        This field indicates whether to enable VPN NAT or not. Only supported for VPN gateway. Valid values: true, false.
        Default value: true.
        """
        return pulumi.get(self, "enable_vpn_nat")

    @enable_vpn_nat.setter
    def enable_vpn_nat(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_vpn_nat", value)

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Fault domain for OCI.
        """
        return pulumi.get(self, "fault_domain")

    @fault_domain.setter
    def fault_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fault_domain", value)

    @property
    @pulumi.getter(name="fqdnLanCidr")
    def fqdn_lan_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        FQDN gateway lan interface cidr.
        """
        return pulumi.get(self, "fqdn_lan_cidr")

    @fqdn_lan_cidr.setter
    def fqdn_lan_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fqdn_lan_cidr", value)

    @property
    @pulumi.getter(name="fqdnLanInterface")
    def fqdn_lan_interface(self) -> Optional[pulumi.Input[str]]:
        """
        FQDN gateway lan interface id.
        """
        return pulumi.get(self, "fqdn_lan_interface")

    @fqdn_lan_interface.setter
    def fqdn_lan_interface(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fqdn_lan_interface", value)

    @property
    @pulumi.getter(name="fqdnLanVpcId")
    def fqdn_lan_vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        LAN VPC ID. Only used for GCP FQDN Gateway.
        """
        return pulumi.get(self, "fqdn_lan_vpc_id")

    @fqdn_lan_vpc_id.setter
    def fqdn_lan_vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fqdn_lan_vpc_id", value)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> Optional[pulumi.Input[str]]:
        """
        Aviatrix gateway unique name.
        """
        return pulumi.get(self, "gw_name")

    @gw_name.setter
    def gw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gw_name", value)

    @property
    @pulumi.getter(name="gwSize")
    def gw_size(self) -> Optional[pulumi.Input[str]]:
        """
        Size of Gateway Instance.
        """
        return pulumi.get(self, "gw_size")

    @gw_size.setter
    def gw_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gw_size", value)

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Typed value when modifying idle_timeout. If it's -1, this feature is disabled.
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_timeout", value)

    @property
    @pulumi.getter(name="imageVersion")
    def image_version(self) -> Optional[pulumi.Input[str]]:
        """
        image_version can be used to set the desired image version of the gateway. If set, we will attempt to update the gateway
        to the specified version.
        """
        return pulumi.get(self, "image_version")

    @image_version.setter
    def image_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_version", value)

    @property
    @pulumi.getter(name="insaneMode")
    def insane_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Insane Mode for Gateway. Valid values: true, false.
        """
        return pulumi.get(self, "insane_mode")

    @insane_mode.setter
    def insane_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "insane_mode", value)

    @property
    @pulumi.getter(name="insaneModeAz")
    def insane_mode_az(self) -> Optional[pulumi.Input[str]]:
        """
        AZ of subnet being created for Insane Mode Gateway. Required if insane_mode is set.
        """
        return pulumi.get(self, "insane_mode_az")

    @insane_mode_az.setter
    def insane_mode_az(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "insane_mode_az", value)

    @property
    @pulumi.getter(name="ldapBaseDn")
    def ldap_base_dn(self) -> Optional[pulumi.Input[str]]:
        """
        LDAP base DN. Required: Yes if enable_ldap is 'yes'.
        """
        return pulumi.get(self, "ldap_base_dn")

    @ldap_base_dn.setter
    def ldap_base_dn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ldap_base_dn", value)

    @property
    @pulumi.getter(name="ldapBindDn")
    def ldap_bind_dn(self) -> Optional[pulumi.Input[str]]:
        """
        LDAP bind DN. Required: Yes if enable_ldap is 'yes'.
        """
        return pulumi.get(self, "ldap_bind_dn")

    @ldap_bind_dn.setter
    def ldap_bind_dn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ldap_bind_dn", value)

    @property
    @pulumi.getter(name="ldapPassword")
    def ldap_password(self) -> Optional[pulumi.Input[str]]:
        """
        LDAP password. Required: Yes if enable_ldap is 'yes'.
        """
        return pulumi.get(self, "ldap_password")

    @ldap_password.setter
    def ldap_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ldap_password", value)

    @property
    @pulumi.getter(name="ldapServer")
    def ldap_server(self) -> Optional[pulumi.Input[str]]:
        """
        LDAP server address. Required: Yes if enable_ldap is 'yes'.
        """
        return pulumi.get(self, "ldap_server")

    @ldap_server.setter
    def ldap_server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ldap_server", value)

    @property
    @pulumi.getter(name="ldapUsernameAttribute")
    def ldap_username_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        LDAP user attribute. Required: Yes if enable_ldap is 'yes'.
        """
        return pulumi.get(self, "ldap_username_attribute")

    @ldap_username_attribute.setter
    def ldap_username_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ldap_username_attribute", value)

    @property
    @pulumi.getter(name="maxVpnConn")
    def max_vpn_conn(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum connection of VPN access.
        """
        return pulumi.get(self, "max_vpn_conn")

    @max_vpn_conn.setter
    def max_vpn_conn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_vpn_conn", value)

    @property
    @pulumi.getter(name="monitorExcludeLists")
    def monitor_exclude_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A set of monitored instance ids. Only valid when 'enable_monitor_gateway_subnets' = true.
        """
        return pulumi.get(self, "monitor_exclude_lists")

    @monitor_exclude_lists.setter
    def monitor_exclude_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "monitor_exclude_lists", value)

    @property
    @pulumi.getter(name="nameServers")
    def name_servers(self) -> Optional[pulumi.Input[str]]:
        """
        A list of DNS servers used to resolve domain names by a connected VPN user when Split Tunnel Mode is enabled.
        """
        return pulumi.get(self, "name_servers")

    @name_servers.setter
    def name_servers(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_servers", value)

    @property
    @pulumi.getter(name="oktaToken")
    def okta_token(self) -> Optional[pulumi.Input[str]]:
        """
        Token for Okta auth mode.
        """
        return pulumi.get(self, "okta_token")

    @okta_token.setter
    def okta_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "okta_token", value)

    @property
    @pulumi.getter(name="oktaUrl")
    def okta_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL for Okta auth mode.
        """
        return pulumi.get(self, "okta_url")

    @okta_url.setter
    def okta_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "okta_url", value)

    @property
    @pulumi.getter(name="oktaUsernameSuffix")
    def okta_username_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        Username suffix for Okta auth mode.
        """
        return pulumi.get(self, "okta_username_suffix")

    @okta_username_suffix.setter
    def okta_username_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "okta_username_suffix", value)

    @property
    @pulumi.getter(name="otpMode")
    def otp_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Two step authentication mode.
        """
        return pulumi.get(self, "otp_mode")

    @otp_mode.setter
    def otp_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "otp_mode", value)

    @property
    @pulumi.getter(name="peeringHaAvailabilityDomain")
    def peering_ha_availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Peering HA availability domain for OCI.
        """
        return pulumi.get(self, "peering_ha_availability_domain")

    @peering_ha_availability_domain.setter
    def peering_ha_availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_ha_availability_domain", value)

    @property
    @pulumi.getter(name="peeringHaAzureEipNameResourceGroup")
    def peering_ha_azure_eip_name_resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the public IP address and its resource group in Azure to assign to the Peering HA Gateway.
        """
        return pulumi.get(self, "peering_ha_azure_eip_name_resource_group")

    @peering_ha_azure_eip_name_resource_group.setter
    def peering_ha_azure_eip_name_resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_ha_azure_eip_name_resource_group", value)

    @property
    @pulumi.getter(name="peeringHaCloudInstanceId")
    def peering_ha_cloud_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Instance ID of the peering HA gateway.
        """
        return pulumi.get(self, "peering_ha_cloud_instance_id")

    @peering_ha_cloud_instance_id.setter
    def peering_ha_cloud_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_ha_cloud_instance_id", value)

    @property
    @pulumi.getter(name="peeringHaEip")
    def peering_ha_eip(self) -> Optional[pulumi.Input[str]]:
        """
        Public IP address that you want assigned to the HA peering instance.
        """
        return pulumi.get(self, "peering_ha_eip")

    @peering_ha_eip.setter
    def peering_ha_eip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_ha_eip", value)

    @property
    @pulumi.getter(name="peeringHaFaultDomain")
    def peering_ha_fault_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Peering HA fault domain for OCI.
        """
        return pulumi.get(self, "peering_ha_fault_domain")

    @peering_ha_fault_domain.setter
    def peering_ha_fault_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_ha_fault_domain", value)

    @property
    @pulumi.getter(name="peeringHaGwName")
    def peering_ha_gw_name(self) -> Optional[pulumi.Input[str]]:
        """
        Aviatrix gateway unique name of HA gateway.
        """
        return pulumi.get(self, "peering_ha_gw_name")

    @peering_ha_gw_name.setter
    def peering_ha_gw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_ha_gw_name", value)

    @property
    @pulumi.getter(name="peeringHaGwSize")
    def peering_ha_gw_size(self) -> Optional[pulumi.Input[str]]:
        """
        Peering HA Gateway Size.
        """
        return pulumi.get(self, "peering_ha_gw_size")

    @peering_ha_gw_size.setter
    def peering_ha_gw_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_ha_gw_size", value)

    @property
    @pulumi.getter(name="peeringHaImageVersion")
    def peering_ha_image_version(self) -> Optional[pulumi.Input[str]]:
        """
        peering_ha_image_version can be used to set the desired image version of the HA gateway. If set, we will attempt to
        update the gateway to the specified version.
        """
        return pulumi.get(self, "peering_ha_image_version")

    @peering_ha_image_version.setter
    def peering_ha_image_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_ha_image_version", value)

    @property
    @pulumi.getter(name="peeringHaInsaneModeAz")
    def peering_ha_insane_mode_az(self) -> Optional[pulumi.Input[str]]:
        """
        AZ of subnet being created for Insane Mode Peering HA Gateway. Required if insane_mode is set.
        """
        return pulumi.get(self, "peering_ha_insane_mode_az")

    @peering_ha_insane_mode_az.setter
    def peering_ha_insane_mode_az(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_ha_insane_mode_az", value)

    @property
    @pulumi.getter(name="peeringHaPrivateIp")
    def peering_ha_private_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Private IP address of HA gateway.
        """
        return pulumi.get(self, "peering_ha_private_ip")

    @peering_ha_private_ip.setter
    def peering_ha_private_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_ha_private_ip", value)

    @property
    @pulumi.getter(name="peeringHaSecurityGroupId")
    def peering_ha_security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Peering HA security group used for the gateway.
        """
        return pulumi.get(self, "peering_ha_security_group_id")

    @peering_ha_security_group_id.setter
    def peering_ha_security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_ha_security_group_id", value)

    @property
    @pulumi.getter(name="peeringHaSoftwareVersion")
    def peering_ha_software_version(self) -> Optional[pulumi.Input[str]]:
        """
        peering_ha_software_version can be used to set the desired software version of the HA gateway. If set, we will attempt
        to update the gateway to the specified version. If left blank, the gateway software version will continue to be managed
        through the aviatrix_controller_config resource.
        """
        return pulumi.get(self, "peering_ha_software_version")

    @peering_ha_software_version.setter
    def peering_ha_software_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_ha_software_version", value)

    @property
    @pulumi.getter(name="peeringHaSubnet")
    def peering_ha_subnet(self) -> Optional[pulumi.Input[str]]:
        """
        Public Subnet Information while creating Peering HA Gateway, only subnet is accepted. Required to create peering ha
        gateway if cloud_type = 1 or 8 (AWS or Azure). Optional if cloud_type = 4 (GCP)
        """
        return pulumi.get(self, "peering_ha_subnet")

    @peering_ha_subnet.setter
    def peering_ha_subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_ha_subnet", value)

    @property
    @pulumi.getter(name="peeringHaZone")
    def peering_ha_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Zone information for creating Peering HA Gateway. Required to create peering ha gateway if cloud_type = 4 (GCP).
        Optional for cloud_type = 8 (Azure).
        """
        return pulumi.get(self, "peering_ha_zone")

    @peering_ha_zone.setter
    def peering_ha_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_ha_zone", value)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Private IP address of the Gateway created.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip", value)

    @property
    @pulumi.getter(name="publicDnsServer")
    def public_dns_server(self) -> Optional[pulumi.Input[str]]:
        """
        NS server used by the gateway.
        """
        return pulumi.get(self, "public_dns_server")

    @public_dns_server.setter
    def public_dns_server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_dns_server", value)

    @property
    @pulumi.getter(name="publicSubnetFilteringGuardDutyEnforced")
    def public_subnet_filtering_guard_duty_enforced(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enforce Guard Duty IP blocking. Required when `enable_public_subnet_filtering` attribute is true. Valid
        values: true or false. Default value: true.
        """
        return pulumi.get(self, "public_subnet_filtering_guard_duty_enforced")

    @public_subnet_filtering_guard_duty_enforced.setter
    def public_subnet_filtering_guard_duty_enforced(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "public_subnet_filtering_guard_duty_enforced", value)

    @property
    @pulumi.getter(name="publicSubnetFilteringHaRouteTables")
    def public_subnet_filtering_ha_route_tables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Route tables whose associated public subnets are protected for the HA PSF gateway. Required when
        enable_public_subnet_filtering and peering_ha_subnet are set.
        """
        return pulumi.get(self, "public_subnet_filtering_ha_route_tables")

    @public_subnet_filtering_ha_route_tables.setter
    def public_subnet_filtering_ha_route_tables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "public_subnet_filtering_ha_route_tables", value)

    @property
    @pulumi.getter(name="publicSubnetFilteringRouteTables")
    def public_subnet_filtering_route_tables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Route tables whose associated public subnets are protected. Required when `enable_public_subnet_filtering` attribute is
        true.
        """
        return pulumi.get(self, "public_subnet_filtering_route_tables")

    @public_subnet_filtering_route_tables.setter
    def public_subnet_filtering_route_tables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "public_subnet_filtering_route_tables", value)

    @property
    @pulumi.getter(name="renegotiationInterval")
    def renegotiation_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Typed value when modifying renegotiation_interval. If it's -1, this feature is disabled.
        """
        return pulumi.get(self, "renegotiation_interval")

    @renegotiation_interval.setter
    def renegotiation_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "renegotiation_interval", value)

    @property
    @pulumi.getter(name="rxQueueSize")
    def rx_queue_size(self) -> Optional[pulumi.Input[str]]:
        """
        Gateway ethernet interface RX queue size. Supported for AWS related clouds only.
        """
        return pulumi.get(self, "rx_queue_size")

    @rx_queue_size.setter
    def rx_queue_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rx_queue_size", value)

    @property
    @pulumi.getter(name="samlEnabled")
    def saml_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        This field indicates whether to enable SAML or not.
        """
        return pulumi.get(self, "saml_enabled")

    @saml_enabled.setter
    def saml_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "saml_enabled", value)

    @property
    @pulumi.getter(name="searchDomains")
    def search_domains(self) -> Optional[pulumi.Input[str]]:
        """
        A list of domain names that will use the NameServer when a specific name is not in the destination when Split Tunnel
        Mode is enabled.
        """
        return pulumi.get(self, "search_domains")

    @search_domains.setter
    def search_domains(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "search_domains", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Security group used for the gateway.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="singleAzHa")
    def single_az_ha(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true if this feature is desired.
        """
        return pulumi.get(self, "single_az_ha")

    @single_az_ha.setter
    def single_az_ha(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "single_az_ha", value)

    @property
    @pulumi.getter(name="singleIpSnat")
    def single_ip_snat(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Source NAT for this container.
        """
        return pulumi.get(self, "single_ip_snat")

    @single_ip_snat.setter
    def single_ip_snat(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "single_ip_snat", value)

    @property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> Optional[pulumi.Input[str]]:
        """
        software_version can be used to set the desired software version of the gateway. If set, we will attempt to update the
        gateway to the specified version. If left blank, the gateway software version will continue to be managed through the
        aviatrix_controller_config resource.
        """
        return pulumi.get(self, "software_version")

    @software_version.setter
    def software_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "software_version", value)

    @property
    @pulumi.getter(name="splitTunnel")
    def split_tunnel(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify split tunnel mode.
        """
        return pulumi.get(self, "split_tunnel")

    @split_tunnel.setter
    def split_tunnel(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "split_tunnel", value)

    @property
    @pulumi.getter(name="spotPrice")
    def spot_price(self) -> Optional[pulumi.Input[str]]:
        """
        Price for spot instance. NOT supported for production deployment.
        """
        return pulumi.get(self, "spot_price")

    @spot_price.setter
    def spot_price(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spot_price", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[str]]:
        """
        A VPC Network address range selected from one of the available network ranges.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter(name="tagLists")
    def tag_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Instance tag of cloud provider.
        """
        return pulumi.get(self, "tag_lists")

    @tag_lists.setter
    def tag_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tag_lists", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the gateway.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tunnelDetectionTime")
    def tunnel_detection_time(self) -> Optional[pulumi.Input[int]]:
        """
        The IPSec tunnel down detection time for the Gateway.
        """
        return pulumi.get(self, "tunnel_detection_time")

    @tunnel_detection_time.setter
    def tunnel_detection_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tunnel_detection_time", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of legacy VPC/Vnet to be connected.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vpcReg")
    def vpc_reg(self) -> Optional[pulumi.Input[str]]:
        """
        Region where this gateway will be launched.
        """
        return pulumi.get(self, "vpc_reg")

    @vpc_reg.setter
    def vpc_reg(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_reg", value)

    @property
    @pulumi.getter(name="vpnAccess")
    def vpn_access(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable user access through VPN to this container.
        """
        return pulumi.get(self, "vpn_access")

    @vpn_access.setter
    def vpn_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vpn_access", value)

    @property
    @pulumi.getter(name="vpnCidr")
    def vpn_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        VPN CIDR block for the container.
        """
        return pulumi.get(self, "vpn_cidr")

    @vpn_cidr.setter
    def vpn_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpn_cidr", value)

    @property
    @pulumi.getter(name="vpnProtocol")
    def vpn_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Elb protocol for VPN gateway with elb enabled. Only supports AWS provider. Valid values: 'TCP', 'UDP'. If not specified,
        'TCP'' will be used.
        """
        return pulumi.get(self, "vpn_protocol")

    @vpn_protocol.setter
    def vpn_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpn_protocol", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        Availability Zone. Only available for Azure and Public Subnet Filtering gateway
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


class AviatrixGateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 additional_cidrs: Optional[pulumi.Input[str]] = None,
                 additional_cidrs_designated_gateway: Optional[pulumi.Input[str]] = None,
                 allocate_new_eip: Optional[pulumi.Input[bool]] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 azure_eip_name_resource_group: Optional[pulumi.Input[str]] = None,
                 cloud_type: Optional[pulumi.Input[int]] = None,
                 customer_managed_keys: Optional[pulumi.Input[str]] = None,
                 duo_api_hostname: Optional[pulumi.Input[str]] = None,
                 duo_integration_key: Optional[pulumi.Input[str]] = None,
                 duo_push_mode: Optional[pulumi.Input[str]] = None,
                 duo_secret_key: Optional[pulumi.Input[str]] = None,
                 eip: Optional[pulumi.Input[str]] = None,
                 elb_name: Optional[pulumi.Input[str]] = None,
                 enable_designated_gateway: Optional[pulumi.Input[bool]] = None,
                 enable_elb: Optional[pulumi.Input[bool]] = None,
                 enable_encrypt_volume: Optional[pulumi.Input[bool]] = None,
                 enable_jumbo_frame: Optional[pulumi.Input[bool]] = None,
                 enable_ldap: Optional[pulumi.Input[bool]] = None,
                 enable_monitor_gateway_subnets: Optional[pulumi.Input[bool]] = None,
                 enable_public_subnet_filtering: Optional[pulumi.Input[bool]] = None,
                 enable_spot_instance: Optional[pulumi.Input[bool]] = None,
                 enable_vpc_dns_server: Optional[pulumi.Input[bool]] = None,
                 enable_vpn_nat: Optional[pulumi.Input[bool]] = None,
                 fault_domain: Optional[pulumi.Input[str]] = None,
                 fqdn_lan_cidr: Optional[pulumi.Input[str]] = None,
                 fqdn_lan_vpc_id: Optional[pulumi.Input[str]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 gw_size: Optional[pulumi.Input[str]] = None,
                 idle_timeout: Optional[pulumi.Input[int]] = None,
                 image_version: Optional[pulumi.Input[str]] = None,
                 insane_mode: Optional[pulumi.Input[bool]] = None,
                 insane_mode_az: Optional[pulumi.Input[str]] = None,
                 ldap_base_dn: Optional[pulumi.Input[str]] = None,
                 ldap_bind_dn: Optional[pulumi.Input[str]] = None,
                 ldap_password: Optional[pulumi.Input[str]] = None,
                 ldap_server: Optional[pulumi.Input[str]] = None,
                 ldap_username_attribute: Optional[pulumi.Input[str]] = None,
                 max_vpn_conn: Optional[pulumi.Input[str]] = None,
                 monitor_exclude_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name_servers: Optional[pulumi.Input[str]] = None,
                 okta_token: Optional[pulumi.Input[str]] = None,
                 okta_url: Optional[pulumi.Input[str]] = None,
                 okta_username_suffix: Optional[pulumi.Input[str]] = None,
                 otp_mode: Optional[pulumi.Input[str]] = None,
                 peering_ha_availability_domain: Optional[pulumi.Input[str]] = None,
                 peering_ha_azure_eip_name_resource_group: Optional[pulumi.Input[str]] = None,
                 peering_ha_eip: Optional[pulumi.Input[str]] = None,
                 peering_ha_fault_domain: Optional[pulumi.Input[str]] = None,
                 peering_ha_gw_size: Optional[pulumi.Input[str]] = None,
                 peering_ha_image_version: Optional[pulumi.Input[str]] = None,
                 peering_ha_insane_mode_az: Optional[pulumi.Input[str]] = None,
                 peering_ha_software_version: Optional[pulumi.Input[str]] = None,
                 peering_ha_subnet: Optional[pulumi.Input[str]] = None,
                 peering_ha_zone: Optional[pulumi.Input[str]] = None,
                 public_subnet_filtering_guard_duty_enforced: Optional[pulumi.Input[bool]] = None,
                 public_subnet_filtering_ha_route_tables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 public_subnet_filtering_route_tables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 renegotiation_interval: Optional[pulumi.Input[int]] = None,
                 rx_queue_size: Optional[pulumi.Input[str]] = None,
                 saml_enabled: Optional[pulumi.Input[bool]] = None,
                 search_domains: Optional[pulumi.Input[str]] = None,
                 single_az_ha: Optional[pulumi.Input[bool]] = None,
                 single_ip_snat: Optional[pulumi.Input[bool]] = None,
                 software_version: Optional[pulumi.Input[str]] = None,
                 split_tunnel: Optional[pulumi.Input[bool]] = None,
                 spot_price: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 tag_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tunnel_detection_time: Optional[pulumi.Input[int]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vpc_reg: Optional[pulumi.Input[str]] = None,
                 vpn_access: Optional[pulumi.Input[bool]] = None,
                 vpn_cidr: Optional[pulumi.Input[str]] = None,
                 vpn_protocol: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a AviatrixGateway resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_name: Account name. This account will be used to launch Aviatrix gateway.
        :param pulumi.Input[str] additional_cidrs: A list of destination CIDR ranges that will also go through the VPN tunnel when Split Tunnel Mode is enabled.
        :param pulumi.Input[str] additional_cidrs_designated_gateway: A list of CIDR ranges separated by comma to configure when 'designated_gateway' feature is enabled.
        :param pulumi.Input[bool] allocate_new_eip: When value is false, reuse an idle address in Elastic IP pool for this gateway. Otherwise, allocate a new Elastic IP and
               use it for this gateway.
        :param pulumi.Input[str] availability_domain: Availability domain for OCI.
        :param pulumi.Input[str] azure_eip_name_resource_group: The name of the public IP address and its resource group in Azure to assign to this Gateway.
        :param pulumi.Input[int] cloud_type: Type of cloud service provider.
        :param pulumi.Input[str] customer_managed_keys: Customer managed key ID.
        :param pulumi.Input[str] duo_api_hostname: API hostname for DUO auth mode.
        :param pulumi.Input[str] duo_integration_key: Integration key for DUO auth mode.
        :param pulumi.Input[str] duo_push_mode: Push mode for DUO auth.
        :param pulumi.Input[str] duo_secret_key: Secret key for DUO auth mode.
        :param pulumi.Input[str] eip: Required when allocate_new_eip is false. It uses specified EIP for this gateway.
        :param pulumi.Input[str] elb_name: A name for the ELB that is created.
        :param pulumi.Input[bool] enable_designated_gateway: Enable 'designated_gateway' feature for Gateway. Valid values: true, false.
        :param pulumi.Input[bool] enable_elb: Specify whether to enable ELB or not.
        :param pulumi.Input[bool] enable_encrypt_volume: Enable encrypt gateway EBS volume. Only supported for AWS provider. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_jumbo_frame: Enable jumbo frame support for Gateway. Valid values: true or false. Default value: true.
        :param pulumi.Input[bool] enable_ldap: Specify whether to enable LDAP or not. Supported values: 'yes' and 'no'.
        :param pulumi.Input[bool] enable_monitor_gateway_subnets: Enable monitor gateway subnets. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_public_subnet_filtering: Create a [Public Subnet Filtering gateway](https://docs.aviatrix.com/HowTos/public_subnet_filtering_faq.html).
        :param pulumi.Input[bool] enable_spot_instance: Enable spot instance. NOT supported for production deployment.
        :param pulumi.Input[bool] enable_vpc_dns_server: Enable vpc_dns_server for Gateway. Valid values: true, false.
        :param pulumi.Input[bool] enable_vpn_nat: This field indicates whether to enable VPN NAT or not. Only supported for VPN gateway. Valid values: true, false.
               Default value: true.
        :param pulumi.Input[str] fault_domain: Fault domain for OCI.
        :param pulumi.Input[str] fqdn_lan_cidr: FQDN gateway lan interface cidr.
        :param pulumi.Input[str] fqdn_lan_vpc_id: LAN VPC ID. Only used for GCP FQDN Gateway.
        :param pulumi.Input[str] gw_name: Aviatrix gateway unique name.
        :param pulumi.Input[str] gw_size: Size of Gateway Instance.
        :param pulumi.Input[int] idle_timeout: Typed value when modifying idle_timeout. If it's -1, this feature is disabled.
        :param pulumi.Input[str] image_version: image_version can be used to set the desired image version of the gateway. If set, we will attempt to update the gateway
               to the specified version.
        :param pulumi.Input[bool] insane_mode: Enable Insane Mode for Gateway. Valid values: true, false.
        :param pulumi.Input[str] insane_mode_az: AZ of subnet being created for Insane Mode Gateway. Required if insane_mode is set.
        :param pulumi.Input[str] ldap_base_dn: LDAP base DN. Required: Yes if enable_ldap is 'yes'.
        :param pulumi.Input[str] ldap_bind_dn: LDAP bind DN. Required: Yes if enable_ldap is 'yes'.
        :param pulumi.Input[str] ldap_password: LDAP password. Required: Yes if enable_ldap is 'yes'.
        :param pulumi.Input[str] ldap_server: LDAP server address. Required: Yes if enable_ldap is 'yes'.
        :param pulumi.Input[str] ldap_username_attribute: LDAP user attribute. Required: Yes if enable_ldap is 'yes'.
        :param pulumi.Input[str] max_vpn_conn: Maximum connection of VPN access.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] monitor_exclude_lists: A set of monitored instance ids. Only valid when 'enable_monitor_gateway_subnets' = true.
        :param pulumi.Input[str] name_servers: A list of DNS servers used to resolve domain names by a connected VPN user when Split Tunnel Mode is enabled.
        :param pulumi.Input[str] okta_token: Token for Okta auth mode.
        :param pulumi.Input[str] okta_url: URL for Okta auth mode.
        :param pulumi.Input[str] okta_username_suffix: Username suffix for Okta auth mode.
        :param pulumi.Input[str] otp_mode: Two step authentication mode.
        :param pulumi.Input[str] peering_ha_availability_domain: Peering HA availability domain for OCI.
        :param pulumi.Input[str] peering_ha_azure_eip_name_resource_group: The name of the public IP address and its resource group in Azure to assign to the Peering HA Gateway.
        :param pulumi.Input[str] peering_ha_eip: Public IP address that you want assigned to the HA peering instance.
        :param pulumi.Input[str] peering_ha_fault_domain: Peering HA fault domain for OCI.
        :param pulumi.Input[str] peering_ha_gw_size: Peering HA Gateway Size.
        :param pulumi.Input[str] peering_ha_image_version: peering_ha_image_version can be used to set the desired image version of the HA gateway. If set, we will attempt to
               update the gateway to the specified version.
        :param pulumi.Input[str] peering_ha_insane_mode_az: AZ of subnet being created for Insane Mode Peering HA Gateway. Required if insane_mode is set.
        :param pulumi.Input[str] peering_ha_software_version: peering_ha_software_version can be used to set the desired software version of the HA gateway. If set, we will attempt
               to update the gateway to the specified version. If left blank, the gateway software version will continue to be managed
               through the aviatrix_controller_config resource.
        :param pulumi.Input[str] peering_ha_subnet: Public Subnet Information while creating Peering HA Gateway, only subnet is accepted. Required to create peering ha
               gateway if cloud_type = 1 or 8 (AWS or Azure). Optional if cloud_type = 4 (GCP)
        :param pulumi.Input[str] peering_ha_zone: Zone information for creating Peering HA Gateway. Required to create peering ha gateway if cloud_type = 4 (GCP).
               Optional for cloud_type = 8 (Azure).
        :param pulumi.Input[bool] public_subnet_filtering_guard_duty_enforced: Whether to enforce Guard Duty IP blocking. Required when `enable_public_subnet_filtering` attribute is true. Valid
               values: true or false. Default value: true.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] public_subnet_filtering_ha_route_tables: Route tables whose associated public subnets are protected for the HA PSF gateway. Required when
               enable_public_subnet_filtering and peering_ha_subnet are set.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] public_subnet_filtering_route_tables: Route tables whose associated public subnets are protected. Required when `enable_public_subnet_filtering` attribute is
               true.
        :param pulumi.Input[int] renegotiation_interval: Typed value when modifying renegotiation_interval. If it's -1, this feature is disabled.
        :param pulumi.Input[str] rx_queue_size: Gateway ethernet interface RX queue size. Supported for AWS related clouds only.
        :param pulumi.Input[bool] saml_enabled: This field indicates whether to enable SAML or not.
        :param pulumi.Input[str] search_domains: A list of domain names that will use the NameServer when a specific name is not in the destination when Split Tunnel
               Mode is enabled.
        :param pulumi.Input[bool] single_az_ha: Set to true if this feature is desired.
        :param pulumi.Input[bool] single_ip_snat: Enable Source NAT for this container.
        :param pulumi.Input[str] software_version: software_version can be used to set the desired software version of the gateway. If set, we will attempt to update the
               gateway to the specified version. If left blank, the gateway software version will continue to be managed through the
               aviatrix_controller_config resource.
        :param pulumi.Input[bool] split_tunnel: Specify split tunnel mode.
        :param pulumi.Input[str] spot_price: Price for spot instance. NOT supported for production deployment.
        :param pulumi.Input[str] subnet: A VPC Network address range selected from one of the available network ranges.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tag_lists: Instance tag of cloud provider.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the gateway.
        :param pulumi.Input[int] tunnel_detection_time: The IPSec tunnel down detection time for the Gateway.
        :param pulumi.Input[str] vpc_id: ID of legacy VPC/Vnet to be connected.
        :param pulumi.Input[str] vpc_reg: Region where this gateway will be launched.
        :param pulumi.Input[bool] vpn_access: Enable user access through VPN to this container.
        :param pulumi.Input[str] vpn_cidr: VPN CIDR block for the container.
        :param pulumi.Input[str] vpn_protocol: Elb protocol for VPN gateway with elb enabled. Only supports AWS provider. Valid values: 'TCP', 'UDP'. If not specified,
               'TCP'' will be used.
        :param pulumi.Input[str] zone: Availability Zone. Only available for Azure and Public Subnet Filtering gateway
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixGatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AviatrixGateway resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AviatrixGatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixGatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 additional_cidrs: Optional[pulumi.Input[str]] = None,
                 additional_cidrs_designated_gateway: Optional[pulumi.Input[str]] = None,
                 allocate_new_eip: Optional[pulumi.Input[bool]] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 azure_eip_name_resource_group: Optional[pulumi.Input[str]] = None,
                 cloud_type: Optional[pulumi.Input[int]] = None,
                 customer_managed_keys: Optional[pulumi.Input[str]] = None,
                 duo_api_hostname: Optional[pulumi.Input[str]] = None,
                 duo_integration_key: Optional[pulumi.Input[str]] = None,
                 duo_push_mode: Optional[pulumi.Input[str]] = None,
                 duo_secret_key: Optional[pulumi.Input[str]] = None,
                 eip: Optional[pulumi.Input[str]] = None,
                 elb_name: Optional[pulumi.Input[str]] = None,
                 enable_designated_gateway: Optional[pulumi.Input[bool]] = None,
                 enable_elb: Optional[pulumi.Input[bool]] = None,
                 enable_encrypt_volume: Optional[pulumi.Input[bool]] = None,
                 enable_jumbo_frame: Optional[pulumi.Input[bool]] = None,
                 enable_ldap: Optional[pulumi.Input[bool]] = None,
                 enable_monitor_gateway_subnets: Optional[pulumi.Input[bool]] = None,
                 enable_public_subnet_filtering: Optional[pulumi.Input[bool]] = None,
                 enable_spot_instance: Optional[pulumi.Input[bool]] = None,
                 enable_vpc_dns_server: Optional[pulumi.Input[bool]] = None,
                 enable_vpn_nat: Optional[pulumi.Input[bool]] = None,
                 fault_domain: Optional[pulumi.Input[str]] = None,
                 fqdn_lan_cidr: Optional[pulumi.Input[str]] = None,
                 fqdn_lan_vpc_id: Optional[pulumi.Input[str]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 gw_size: Optional[pulumi.Input[str]] = None,
                 idle_timeout: Optional[pulumi.Input[int]] = None,
                 image_version: Optional[pulumi.Input[str]] = None,
                 insane_mode: Optional[pulumi.Input[bool]] = None,
                 insane_mode_az: Optional[pulumi.Input[str]] = None,
                 ldap_base_dn: Optional[pulumi.Input[str]] = None,
                 ldap_bind_dn: Optional[pulumi.Input[str]] = None,
                 ldap_password: Optional[pulumi.Input[str]] = None,
                 ldap_server: Optional[pulumi.Input[str]] = None,
                 ldap_username_attribute: Optional[pulumi.Input[str]] = None,
                 max_vpn_conn: Optional[pulumi.Input[str]] = None,
                 monitor_exclude_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name_servers: Optional[pulumi.Input[str]] = None,
                 okta_token: Optional[pulumi.Input[str]] = None,
                 okta_url: Optional[pulumi.Input[str]] = None,
                 okta_username_suffix: Optional[pulumi.Input[str]] = None,
                 otp_mode: Optional[pulumi.Input[str]] = None,
                 peering_ha_availability_domain: Optional[pulumi.Input[str]] = None,
                 peering_ha_azure_eip_name_resource_group: Optional[pulumi.Input[str]] = None,
                 peering_ha_eip: Optional[pulumi.Input[str]] = None,
                 peering_ha_fault_domain: Optional[pulumi.Input[str]] = None,
                 peering_ha_gw_size: Optional[pulumi.Input[str]] = None,
                 peering_ha_image_version: Optional[pulumi.Input[str]] = None,
                 peering_ha_insane_mode_az: Optional[pulumi.Input[str]] = None,
                 peering_ha_software_version: Optional[pulumi.Input[str]] = None,
                 peering_ha_subnet: Optional[pulumi.Input[str]] = None,
                 peering_ha_zone: Optional[pulumi.Input[str]] = None,
                 public_subnet_filtering_guard_duty_enforced: Optional[pulumi.Input[bool]] = None,
                 public_subnet_filtering_ha_route_tables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 public_subnet_filtering_route_tables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 renegotiation_interval: Optional[pulumi.Input[int]] = None,
                 rx_queue_size: Optional[pulumi.Input[str]] = None,
                 saml_enabled: Optional[pulumi.Input[bool]] = None,
                 search_domains: Optional[pulumi.Input[str]] = None,
                 single_az_ha: Optional[pulumi.Input[bool]] = None,
                 single_ip_snat: Optional[pulumi.Input[bool]] = None,
                 software_version: Optional[pulumi.Input[str]] = None,
                 split_tunnel: Optional[pulumi.Input[bool]] = None,
                 spot_price: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 tag_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tunnel_detection_time: Optional[pulumi.Input[int]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vpc_reg: Optional[pulumi.Input[str]] = None,
                 vpn_access: Optional[pulumi.Input[bool]] = None,
                 vpn_cidr: Optional[pulumi.Input[str]] = None,
                 vpn_protocol: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixGatewayArgs.__new__(AviatrixGatewayArgs)

            if account_name is None and not opts.urn:
                raise TypeError("Missing required property 'account_name'")
            __props__.__dict__["account_name"] = account_name
            __props__.__dict__["additional_cidrs"] = additional_cidrs
            __props__.__dict__["additional_cidrs_designated_gateway"] = additional_cidrs_designated_gateway
            __props__.__dict__["allocate_new_eip"] = allocate_new_eip
            __props__.__dict__["availability_domain"] = availability_domain
            __props__.__dict__["azure_eip_name_resource_group"] = azure_eip_name_resource_group
            if cloud_type is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_type'")
            __props__.__dict__["cloud_type"] = cloud_type
            __props__.__dict__["customer_managed_keys"] = customer_managed_keys
            __props__.__dict__["duo_api_hostname"] = duo_api_hostname
            __props__.__dict__["duo_integration_key"] = duo_integration_key
            __props__.__dict__["duo_push_mode"] = duo_push_mode
            __props__.__dict__["duo_secret_key"] = duo_secret_key
            __props__.__dict__["eip"] = eip
            __props__.__dict__["elb_name"] = elb_name
            __props__.__dict__["enable_designated_gateway"] = enable_designated_gateway
            __props__.__dict__["enable_elb"] = enable_elb
            __props__.__dict__["enable_encrypt_volume"] = enable_encrypt_volume
            __props__.__dict__["enable_jumbo_frame"] = enable_jumbo_frame
            __props__.__dict__["enable_ldap"] = enable_ldap
            __props__.__dict__["enable_monitor_gateway_subnets"] = enable_monitor_gateway_subnets
            __props__.__dict__["enable_public_subnet_filtering"] = enable_public_subnet_filtering
            __props__.__dict__["enable_spot_instance"] = enable_spot_instance
            __props__.__dict__["enable_vpc_dns_server"] = enable_vpc_dns_server
            __props__.__dict__["enable_vpn_nat"] = enable_vpn_nat
            __props__.__dict__["fault_domain"] = fault_domain
            __props__.__dict__["fqdn_lan_cidr"] = fqdn_lan_cidr
            __props__.__dict__["fqdn_lan_vpc_id"] = fqdn_lan_vpc_id
            if gw_name is None and not opts.urn:
                raise TypeError("Missing required property 'gw_name'")
            __props__.__dict__["gw_name"] = gw_name
            if gw_size is None and not opts.urn:
                raise TypeError("Missing required property 'gw_size'")
            __props__.__dict__["gw_size"] = gw_size
            __props__.__dict__["idle_timeout"] = idle_timeout
            __props__.__dict__["image_version"] = image_version
            __props__.__dict__["insane_mode"] = insane_mode
            __props__.__dict__["insane_mode_az"] = insane_mode_az
            __props__.__dict__["ldap_base_dn"] = ldap_base_dn
            __props__.__dict__["ldap_bind_dn"] = ldap_bind_dn
            __props__.__dict__["ldap_password"] = ldap_password
            __props__.__dict__["ldap_server"] = ldap_server
            __props__.__dict__["ldap_username_attribute"] = ldap_username_attribute
            __props__.__dict__["max_vpn_conn"] = max_vpn_conn
            __props__.__dict__["monitor_exclude_lists"] = monitor_exclude_lists
            __props__.__dict__["name_servers"] = name_servers
            __props__.__dict__["okta_token"] = okta_token
            __props__.__dict__["okta_url"] = okta_url
            __props__.__dict__["okta_username_suffix"] = okta_username_suffix
            __props__.__dict__["otp_mode"] = otp_mode
            __props__.__dict__["peering_ha_availability_domain"] = peering_ha_availability_domain
            __props__.__dict__["peering_ha_azure_eip_name_resource_group"] = peering_ha_azure_eip_name_resource_group
            __props__.__dict__["peering_ha_eip"] = peering_ha_eip
            __props__.__dict__["peering_ha_fault_domain"] = peering_ha_fault_domain
            __props__.__dict__["peering_ha_gw_size"] = peering_ha_gw_size
            __props__.__dict__["peering_ha_image_version"] = peering_ha_image_version
            __props__.__dict__["peering_ha_insane_mode_az"] = peering_ha_insane_mode_az
            __props__.__dict__["peering_ha_software_version"] = peering_ha_software_version
            __props__.__dict__["peering_ha_subnet"] = peering_ha_subnet
            __props__.__dict__["peering_ha_zone"] = peering_ha_zone
            __props__.__dict__["public_subnet_filtering_guard_duty_enforced"] = public_subnet_filtering_guard_duty_enforced
            __props__.__dict__["public_subnet_filtering_ha_route_tables"] = public_subnet_filtering_ha_route_tables
            __props__.__dict__["public_subnet_filtering_route_tables"] = public_subnet_filtering_route_tables
            __props__.__dict__["renegotiation_interval"] = renegotiation_interval
            __props__.__dict__["rx_queue_size"] = rx_queue_size
            __props__.__dict__["saml_enabled"] = saml_enabled
            __props__.__dict__["search_domains"] = search_domains
            __props__.__dict__["single_az_ha"] = single_az_ha
            __props__.__dict__["single_ip_snat"] = single_ip_snat
            __props__.__dict__["software_version"] = software_version
            __props__.__dict__["split_tunnel"] = split_tunnel
            __props__.__dict__["spot_price"] = spot_price
            if subnet is None and not opts.urn:
                raise TypeError("Missing required property 'subnet'")
            __props__.__dict__["subnet"] = subnet
            if tag_lists is not None and not opts.urn:
                warnings.warn("""Use tags instead.""", DeprecationWarning)
                pulumi.log.warn("""tag_lists is deprecated: Use tags instead.""")
            __props__.__dict__["tag_lists"] = tag_lists
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tunnel_detection_time"] = tunnel_detection_time
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            if vpc_reg is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_reg'")
            __props__.__dict__["vpc_reg"] = vpc_reg
            __props__.__dict__["vpn_access"] = vpn_access
            __props__.__dict__["vpn_cidr"] = vpn_cidr
            __props__.__dict__["vpn_protocol"] = vpn_protocol
            __props__.__dict__["zone"] = zone
            __props__.__dict__["cloud_instance_id"] = None
            __props__.__dict__["elb_dns_name"] = None
            __props__.__dict__["fqdn_lan_interface"] = None
            __props__.__dict__["peering_ha_cloud_instance_id"] = None
            __props__.__dict__["peering_ha_gw_name"] = None
            __props__.__dict__["peering_ha_private_ip"] = None
            __props__.__dict__["peering_ha_security_group_id"] = None
            __props__.__dict__["private_ip"] = None
            __props__.__dict__["public_dns_server"] = None
            __props__.__dict__["security_group_id"] = None
        super(AviatrixGateway, __self__).__init__(
            'aviatrix:index/aviatrixGateway:AviatrixGateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_name: Optional[pulumi.Input[str]] = None,
            additional_cidrs: Optional[pulumi.Input[str]] = None,
            additional_cidrs_designated_gateway: Optional[pulumi.Input[str]] = None,
            allocate_new_eip: Optional[pulumi.Input[bool]] = None,
            availability_domain: Optional[pulumi.Input[str]] = None,
            azure_eip_name_resource_group: Optional[pulumi.Input[str]] = None,
            cloud_instance_id: Optional[pulumi.Input[str]] = None,
            cloud_type: Optional[pulumi.Input[int]] = None,
            customer_managed_keys: Optional[pulumi.Input[str]] = None,
            duo_api_hostname: Optional[pulumi.Input[str]] = None,
            duo_integration_key: Optional[pulumi.Input[str]] = None,
            duo_push_mode: Optional[pulumi.Input[str]] = None,
            duo_secret_key: Optional[pulumi.Input[str]] = None,
            eip: Optional[pulumi.Input[str]] = None,
            elb_dns_name: Optional[pulumi.Input[str]] = None,
            elb_name: Optional[pulumi.Input[str]] = None,
            enable_designated_gateway: Optional[pulumi.Input[bool]] = None,
            enable_elb: Optional[pulumi.Input[bool]] = None,
            enable_encrypt_volume: Optional[pulumi.Input[bool]] = None,
            enable_jumbo_frame: Optional[pulumi.Input[bool]] = None,
            enable_ldap: Optional[pulumi.Input[bool]] = None,
            enable_monitor_gateway_subnets: Optional[pulumi.Input[bool]] = None,
            enable_public_subnet_filtering: Optional[pulumi.Input[bool]] = None,
            enable_spot_instance: Optional[pulumi.Input[bool]] = None,
            enable_vpc_dns_server: Optional[pulumi.Input[bool]] = None,
            enable_vpn_nat: Optional[pulumi.Input[bool]] = None,
            fault_domain: Optional[pulumi.Input[str]] = None,
            fqdn_lan_cidr: Optional[pulumi.Input[str]] = None,
            fqdn_lan_interface: Optional[pulumi.Input[str]] = None,
            fqdn_lan_vpc_id: Optional[pulumi.Input[str]] = None,
            gw_name: Optional[pulumi.Input[str]] = None,
            gw_size: Optional[pulumi.Input[str]] = None,
            idle_timeout: Optional[pulumi.Input[int]] = None,
            image_version: Optional[pulumi.Input[str]] = None,
            insane_mode: Optional[pulumi.Input[bool]] = None,
            insane_mode_az: Optional[pulumi.Input[str]] = None,
            ldap_base_dn: Optional[pulumi.Input[str]] = None,
            ldap_bind_dn: Optional[pulumi.Input[str]] = None,
            ldap_password: Optional[pulumi.Input[str]] = None,
            ldap_server: Optional[pulumi.Input[str]] = None,
            ldap_username_attribute: Optional[pulumi.Input[str]] = None,
            max_vpn_conn: Optional[pulumi.Input[str]] = None,
            monitor_exclude_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name_servers: Optional[pulumi.Input[str]] = None,
            okta_token: Optional[pulumi.Input[str]] = None,
            okta_url: Optional[pulumi.Input[str]] = None,
            okta_username_suffix: Optional[pulumi.Input[str]] = None,
            otp_mode: Optional[pulumi.Input[str]] = None,
            peering_ha_availability_domain: Optional[pulumi.Input[str]] = None,
            peering_ha_azure_eip_name_resource_group: Optional[pulumi.Input[str]] = None,
            peering_ha_cloud_instance_id: Optional[pulumi.Input[str]] = None,
            peering_ha_eip: Optional[pulumi.Input[str]] = None,
            peering_ha_fault_domain: Optional[pulumi.Input[str]] = None,
            peering_ha_gw_name: Optional[pulumi.Input[str]] = None,
            peering_ha_gw_size: Optional[pulumi.Input[str]] = None,
            peering_ha_image_version: Optional[pulumi.Input[str]] = None,
            peering_ha_insane_mode_az: Optional[pulumi.Input[str]] = None,
            peering_ha_private_ip: Optional[pulumi.Input[str]] = None,
            peering_ha_security_group_id: Optional[pulumi.Input[str]] = None,
            peering_ha_software_version: Optional[pulumi.Input[str]] = None,
            peering_ha_subnet: Optional[pulumi.Input[str]] = None,
            peering_ha_zone: Optional[pulumi.Input[str]] = None,
            private_ip: Optional[pulumi.Input[str]] = None,
            public_dns_server: Optional[pulumi.Input[str]] = None,
            public_subnet_filtering_guard_duty_enforced: Optional[pulumi.Input[bool]] = None,
            public_subnet_filtering_ha_route_tables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            public_subnet_filtering_route_tables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            renegotiation_interval: Optional[pulumi.Input[int]] = None,
            rx_queue_size: Optional[pulumi.Input[str]] = None,
            saml_enabled: Optional[pulumi.Input[bool]] = None,
            search_domains: Optional[pulumi.Input[str]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None,
            single_az_ha: Optional[pulumi.Input[bool]] = None,
            single_ip_snat: Optional[pulumi.Input[bool]] = None,
            software_version: Optional[pulumi.Input[str]] = None,
            split_tunnel: Optional[pulumi.Input[bool]] = None,
            spot_price: Optional[pulumi.Input[str]] = None,
            subnet: Optional[pulumi.Input[str]] = None,
            tag_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tunnel_detection_time: Optional[pulumi.Input[int]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            vpc_reg: Optional[pulumi.Input[str]] = None,
            vpn_access: Optional[pulumi.Input[bool]] = None,
            vpn_cidr: Optional[pulumi.Input[str]] = None,
            vpn_protocol: Optional[pulumi.Input[str]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'AviatrixGateway':
        """
        Get an existing AviatrixGateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_name: Account name. This account will be used to launch Aviatrix gateway.
        :param pulumi.Input[str] additional_cidrs: A list of destination CIDR ranges that will also go through the VPN tunnel when Split Tunnel Mode is enabled.
        :param pulumi.Input[str] additional_cidrs_designated_gateway: A list of CIDR ranges separated by comma to configure when 'designated_gateway' feature is enabled.
        :param pulumi.Input[bool] allocate_new_eip: When value is false, reuse an idle address in Elastic IP pool for this gateway. Otherwise, allocate a new Elastic IP and
               use it for this gateway.
        :param pulumi.Input[str] availability_domain: Availability domain for OCI.
        :param pulumi.Input[str] azure_eip_name_resource_group: The name of the public IP address and its resource group in Azure to assign to this Gateway.
        :param pulumi.Input[str] cloud_instance_id: Instance ID of the gateway.
        :param pulumi.Input[int] cloud_type: Type of cloud service provider.
        :param pulumi.Input[str] customer_managed_keys: Customer managed key ID.
        :param pulumi.Input[str] duo_api_hostname: API hostname for DUO auth mode.
        :param pulumi.Input[str] duo_integration_key: Integration key for DUO auth mode.
        :param pulumi.Input[str] duo_push_mode: Push mode for DUO auth.
        :param pulumi.Input[str] duo_secret_key: Secret key for DUO auth mode.
        :param pulumi.Input[str] eip: Required when allocate_new_eip is false. It uses specified EIP for this gateway.
        :param pulumi.Input[str] elb_dns_name: ELB DNS Name.
        :param pulumi.Input[str] elb_name: A name for the ELB that is created.
        :param pulumi.Input[bool] enable_designated_gateway: Enable 'designated_gateway' feature for Gateway. Valid values: true, false.
        :param pulumi.Input[bool] enable_elb: Specify whether to enable ELB or not.
        :param pulumi.Input[bool] enable_encrypt_volume: Enable encrypt gateway EBS volume. Only supported for AWS provider. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_jumbo_frame: Enable jumbo frame support for Gateway. Valid values: true or false. Default value: true.
        :param pulumi.Input[bool] enable_ldap: Specify whether to enable LDAP or not. Supported values: 'yes' and 'no'.
        :param pulumi.Input[bool] enable_monitor_gateway_subnets: Enable monitor gateway subnets. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_public_subnet_filtering: Create a [Public Subnet Filtering gateway](https://docs.aviatrix.com/HowTos/public_subnet_filtering_faq.html).
        :param pulumi.Input[bool] enable_spot_instance: Enable spot instance. NOT supported for production deployment.
        :param pulumi.Input[bool] enable_vpc_dns_server: Enable vpc_dns_server for Gateway. Valid values: true, false.
        :param pulumi.Input[bool] enable_vpn_nat: This field indicates whether to enable VPN NAT or not. Only supported for VPN gateway. Valid values: true, false.
               Default value: true.
        :param pulumi.Input[str] fault_domain: Fault domain for OCI.
        :param pulumi.Input[str] fqdn_lan_cidr: FQDN gateway lan interface cidr.
        :param pulumi.Input[str] fqdn_lan_interface: FQDN gateway lan interface id.
        :param pulumi.Input[str] fqdn_lan_vpc_id: LAN VPC ID. Only used for GCP FQDN Gateway.
        :param pulumi.Input[str] gw_name: Aviatrix gateway unique name.
        :param pulumi.Input[str] gw_size: Size of Gateway Instance.
        :param pulumi.Input[int] idle_timeout: Typed value when modifying idle_timeout. If it's -1, this feature is disabled.
        :param pulumi.Input[str] image_version: image_version can be used to set the desired image version of the gateway. If set, we will attempt to update the gateway
               to the specified version.
        :param pulumi.Input[bool] insane_mode: Enable Insane Mode for Gateway. Valid values: true, false.
        :param pulumi.Input[str] insane_mode_az: AZ of subnet being created for Insane Mode Gateway. Required if insane_mode is set.
        :param pulumi.Input[str] ldap_base_dn: LDAP base DN. Required: Yes if enable_ldap is 'yes'.
        :param pulumi.Input[str] ldap_bind_dn: LDAP bind DN. Required: Yes if enable_ldap is 'yes'.
        :param pulumi.Input[str] ldap_password: LDAP password. Required: Yes if enable_ldap is 'yes'.
        :param pulumi.Input[str] ldap_server: LDAP server address. Required: Yes if enable_ldap is 'yes'.
        :param pulumi.Input[str] ldap_username_attribute: LDAP user attribute. Required: Yes if enable_ldap is 'yes'.
        :param pulumi.Input[str] max_vpn_conn: Maximum connection of VPN access.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] monitor_exclude_lists: A set of monitored instance ids. Only valid when 'enable_monitor_gateway_subnets' = true.
        :param pulumi.Input[str] name_servers: A list of DNS servers used to resolve domain names by a connected VPN user when Split Tunnel Mode is enabled.
        :param pulumi.Input[str] okta_token: Token for Okta auth mode.
        :param pulumi.Input[str] okta_url: URL for Okta auth mode.
        :param pulumi.Input[str] okta_username_suffix: Username suffix for Okta auth mode.
        :param pulumi.Input[str] otp_mode: Two step authentication mode.
        :param pulumi.Input[str] peering_ha_availability_domain: Peering HA availability domain for OCI.
        :param pulumi.Input[str] peering_ha_azure_eip_name_resource_group: The name of the public IP address and its resource group in Azure to assign to the Peering HA Gateway.
        :param pulumi.Input[str] peering_ha_cloud_instance_id: Instance ID of the peering HA gateway.
        :param pulumi.Input[str] peering_ha_eip: Public IP address that you want assigned to the HA peering instance.
        :param pulumi.Input[str] peering_ha_fault_domain: Peering HA fault domain for OCI.
        :param pulumi.Input[str] peering_ha_gw_name: Aviatrix gateway unique name of HA gateway.
        :param pulumi.Input[str] peering_ha_gw_size: Peering HA Gateway Size.
        :param pulumi.Input[str] peering_ha_image_version: peering_ha_image_version can be used to set the desired image version of the HA gateway. If set, we will attempt to
               update the gateway to the specified version.
        :param pulumi.Input[str] peering_ha_insane_mode_az: AZ of subnet being created for Insane Mode Peering HA Gateway. Required if insane_mode is set.
        :param pulumi.Input[str] peering_ha_private_ip: Private IP address of HA gateway.
        :param pulumi.Input[str] peering_ha_security_group_id: Peering HA security group used for the gateway.
        :param pulumi.Input[str] peering_ha_software_version: peering_ha_software_version can be used to set the desired software version of the HA gateway. If set, we will attempt
               to update the gateway to the specified version. If left blank, the gateway software version will continue to be managed
               through the aviatrix_controller_config resource.
        :param pulumi.Input[str] peering_ha_subnet: Public Subnet Information while creating Peering HA Gateway, only subnet is accepted. Required to create peering ha
               gateway if cloud_type = 1 or 8 (AWS or Azure). Optional if cloud_type = 4 (GCP)
        :param pulumi.Input[str] peering_ha_zone: Zone information for creating Peering HA Gateway. Required to create peering ha gateway if cloud_type = 4 (GCP).
               Optional for cloud_type = 8 (Azure).
        :param pulumi.Input[str] private_ip: Private IP address of the Gateway created.
        :param pulumi.Input[str] public_dns_server: NS server used by the gateway.
        :param pulumi.Input[bool] public_subnet_filtering_guard_duty_enforced: Whether to enforce Guard Duty IP blocking. Required when `enable_public_subnet_filtering` attribute is true. Valid
               values: true or false. Default value: true.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] public_subnet_filtering_ha_route_tables: Route tables whose associated public subnets are protected for the HA PSF gateway. Required when
               enable_public_subnet_filtering and peering_ha_subnet are set.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] public_subnet_filtering_route_tables: Route tables whose associated public subnets are protected. Required when `enable_public_subnet_filtering` attribute is
               true.
        :param pulumi.Input[int] renegotiation_interval: Typed value when modifying renegotiation_interval. If it's -1, this feature is disabled.
        :param pulumi.Input[str] rx_queue_size: Gateway ethernet interface RX queue size. Supported for AWS related clouds only.
        :param pulumi.Input[bool] saml_enabled: This field indicates whether to enable SAML or not.
        :param pulumi.Input[str] search_domains: A list of domain names that will use the NameServer when a specific name is not in the destination when Split Tunnel
               Mode is enabled.
        :param pulumi.Input[str] security_group_id: Security group used for the gateway.
        :param pulumi.Input[bool] single_az_ha: Set to true if this feature is desired.
        :param pulumi.Input[bool] single_ip_snat: Enable Source NAT for this container.
        :param pulumi.Input[str] software_version: software_version can be used to set the desired software version of the gateway. If set, we will attempt to update the
               gateway to the specified version. If left blank, the gateway software version will continue to be managed through the
               aviatrix_controller_config resource.
        :param pulumi.Input[bool] split_tunnel: Specify split tunnel mode.
        :param pulumi.Input[str] spot_price: Price for spot instance. NOT supported for production deployment.
        :param pulumi.Input[str] subnet: A VPC Network address range selected from one of the available network ranges.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tag_lists: Instance tag of cloud provider.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the gateway.
        :param pulumi.Input[int] tunnel_detection_time: The IPSec tunnel down detection time for the Gateway.
        :param pulumi.Input[str] vpc_id: ID of legacy VPC/Vnet to be connected.
        :param pulumi.Input[str] vpc_reg: Region where this gateway will be launched.
        :param pulumi.Input[bool] vpn_access: Enable user access through VPN to this container.
        :param pulumi.Input[str] vpn_cidr: VPN CIDR block for the container.
        :param pulumi.Input[str] vpn_protocol: Elb protocol for VPN gateway with elb enabled. Only supports AWS provider. Valid values: 'TCP', 'UDP'. If not specified,
               'TCP'' will be used.
        :param pulumi.Input[str] zone: Availability Zone. Only available for Azure and Public Subnet Filtering gateway
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixGatewayState.__new__(_AviatrixGatewayState)

        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["additional_cidrs"] = additional_cidrs
        __props__.__dict__["additional_cidrs_designated_gateway"] = additional_cidrs_designated_gateway
        __props__.__dict__["allocate_new_eip"] = allocate_new_eip
        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["azure_eip_name_resource_group"] = azure_eip_name_resource_group
        __props__.__dict__["cloud_instance_id"] = cloud_instance_id
        __props__.__dict__["cloud_type"] = cloud_type
        __props__.__dict__["customer_managed_keys"] = customer_managed_keys
        __props__.__dict__["duo_api_hostname"] = duo_api_hostname
        __props__.__dict__["duo_integration_key"] = duo_integration_key
        __props__.__dict__["duo_push_mode"] = duo_push_mode
        __props__.__dict__["duo_secret_key"] = duo_secret_key
        __props__.__dict__["eip"] = eip
        __props__.__dict__["elb_dns_name"] = elb_dns_name
        __props__.__dict__["elb_name"] = elb_name
        __props__.__dict__["enable_designated_gateway"] = enable_designated_gateway
        __props__.__dict__["enable_elb"] = enable_elb
        __props__.__dict__["enable_encrypt_volume"] = enable_encrypt_volume
        __props__.__dict__["enable_jumbo_frame"] = enable_jumbo_frame
        __props__.__dict__["enable_ldap"] = enable_ldap
        __props__.__dict__["enable_monitor_gateway_subnets"] = enable_monitor_gateway_subnets
        __props__.__dict__["enable_public_subnet_filtering"] = enable_public_subnet_filtering
        __props__.__dict__["enable_spot_instance"] = enable_spot_instance
        __props__.__dict__["enable_vpc_dns_server"] = enable_vpc_dns_server
        __props__.__dict__["enable_vpn_nat"] = enable_vpn_nat
        __props__.__dict__["fault_domain"] = fault_domain
        __props__.__dict__["fqdn_lan_cidr"] = fqdn_lan_cidr
        __props__.__dict__["fqdn_lan_interface"] = fqdn_lan_interface
        __props__.__dict__["fqdn_lan_vpc_id"] = fqdn_lan_vpc_id
        __props__.__dict__["gw_name"] = gw_name
        __props__.__dict__["gw_size"] = gw_size
        __props__.__dict__["idle_timeout"] = idle_timeout
        __props__.__dict__["image_version"] = image_version
        __props__.__dict__["insane_mode"] = insane_mode
        __props__.__dict__["insane_mode_az"] = insane_mode_az
        __props__.__dict__["ldap_base_dn"] = ldap_base_dn
        __props__.__dict__["ldap_bind_dn"] = ldap_bind_dn
        __props__.__dict__["ldap_password"] = ldap_password
        __props__.__dict__["ldap_server"] = ldap_server
        __props__.__dict__["ldap_username_attribute"] = ldap_username_attribute
        __props__.__dict__["max_vpn_conn"] = max_vpn_conn
        __props__.__dict__["monitor_exclude_lists"] = monitor_exclude_lists
        __props__.__dict__["name_servers"] = name_servers
        __props__.__dict__["okta_token"] = okta_token
        __props__.__dict__["okta_url"] = okta_url
        __props__.__dict__["okta_username_suffix"] = okta_username_suffix
        __props__.__dict__["otp_mode"] = otp_mode
        __props__.__dict__["peering_ha_availability_domain"] = peering_ha_availability_domain
        __props__.__dict__["peering_ha_azure_eip_name_resource_group"] = peering_ha_azure_eip_name_resource_group
        __props__.__dict__["peering_ha_cloud_instance_id"] = peering_ha_cloud_instance_id
        __props__.__dict__["peering_ha_eip"] = peering_ha_eip
        __props__.__dict__["peering_ha_fault_domain"] = peering_ha_fault_domain
        __props__.__dict__["peering_ha_gw_name"] = peering_ha_gw_name
        __props__.__dict__["peering_ha_gw_size"] = peering_ha_gw_size
        __props__.__dict__["peering_ha_image_version"] = peering_ha_image_version
        __props__.__dict__["peering_ha_insane_mode_az"] = peering_ha_insane_mode_az
        __props__.__dict__["peering_ha_private_ip"] = peering_ha_private_ip
        __props__.__dict__["peering_ha_security_group_id"] = peering_ha_security_group_id
        __props__.__dict__["peering_ha_software_version"] = peering_ha_software_version
        __props__.__dict__["peering_ha_subnet"] = peering_ha_subnet
        __props__.__dict__["peering_ha_zone"] = peering_ha_zone
        __props__.__dict__["private_ip"] = private_ip
        __props__.__dict__["public_dns_server"] = public_dns_server
        __props__.__dict__["public_subnet_filtering_guard_duty_enforced"] = public_subnet_filtering_guard_duty_enforced
        __props__.__dict__["public_subnet_filtering_ha_route_tables"] = public_subnet_filtering_ha_route_tables
        __props__.__dict__["public_subnet_filtering_route_tables"] = public_subnet_filtering_route_tables
        __props__.__dict__["renegotiation_interval"] = renegotiation_interval
        __props__.__dict__["rx_queue_size"] = rx_queue_size
        __props__.__dict__["saml_enabled"] = saml_enabled
        __props__.__dict__["search_domains"] = search_domains
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["single_az_ha"] = single_az_ha
        __props__.__dict__["single_ip_snat"] = single_ip_snat
        __props__.__dict__["software_version"] = software_version
        __props__.__dict__["split_tunnel"] = split_tunnel
        __props__.__dict__["spot_price"] = spot_price
        __props__.__dict__["subnet"] = subnet
        __props__.__dict__["tag_lists"] = tag_lists
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tunnel_detection_time"] = tunnel_detection_time
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vpc_reg"] = vpc_reg
        __props__.__dict__["vpn_access"] = vpn_access
        __props__.__dict__["vpn_cidr"] = vpn_cidr
        __props__.__dict__["vpn_protocol"] = vpn_protocol
        __props__.__dict__["zone"] = zone
        return AviatrixGateway(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[str]:
        """
        Account name. This account will be used to launch Aviatrix gateway.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="additionalCidrs")
    def additional_cidrs(self) -> pulumi.Output[Optional[str]]:
        """
        A list of destination CIDR ranges that will also go through the VPN tunnel when Split Tunnel Mode is enabled.
        """
        return pulumi.get(self, "additional_cidrs")

    @property
    @pulumi.getter(name="additionalCidrsDesignatedGateway")
    def additional_cidrs_designated_gateway(self) -> pulumi.Output[Optional[str]]:
        """
        A list of CIDR ranges separated by comma to configure when 'designated_gateway' feature is enabled.
        """
        return pulumi.get(self, "additional_cidrs_designated_gateway")

    @property
    @pulumi.getter(name="allocateNewEip")
    def allocate_new_eip(self) -> pulumi.Output[Optional[bool]]:
        """
        When value is false, reuse an idle address in Elastic IP pool for this gateway. Otherwise, allocate a new Elastic IP and
        use it for this gateway.
        """
        return pulumi.get(self, "allocate_new_eip")

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[str]:
        """
        Availability domain for OCI.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="azureEipNameResourceGroup")
    def azure_eip_name_resource_group(self) -> pulumi.Output[str]:
        """
        The name of the public IP address and its resource group in Azure to assign to this Gateway.
        """
        return pulumi.get(self, "azure_eip_name_resource_group")

    @property
    @pulumi.getter(name="cloudInstanceId")
    def cloud_instance_id(self) -> pulumi.Output[str]:
        """
        Instance ID of the gateway.
        """
        return pulumi.get(self, "cloud_instance_id")

    @property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> pulumi.Output[int]:
        """
        Type of cloud service provider.
        """
        return pulumi.get(self, "cloud_type")

    @property
    @pulumi.getter(name="customerManagedKeys")
    def customer_managed_keys(self) -> pulumi.Output[Optional[str]]:
        """
        Customer managed key ID.
        """
        return pulumi.get(self, "customer_managed_keys")

    @property
    @pulumi.getter(name="duoApiHostname")
    def duo_api_hostname(self) -> pulumi.Output[Optional[str]]:
        """
        API hostname for DUO auth mode.
        """
        return pulumi.get(self, "duo_api_hostname")

    @property
    @pulumi.getter(name="duoIntegrationKey")
    def duo_integration_key(self) -> pulumi.Output[Optional[str]]:
        """
        Integration key for DUO auth mode.
        """
        return pulumi.get(self, "duo_integration_key")

    @property
    @pulumi.getter(name="duoPushMode")
    def duo_push_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Push mode for DUO auth.
        """
        return pulumi.get(self, "duo_push_mode")

    @property
    @pulumi.getter(name="duoSecretKey")
    def duo_secret_key(self) -> pulumi.Output[Optional[str]]:
        """
        Secret key for DUO auth mode.
        """
        return pulumi.get(self, "duo_secret_key")

    @property
    @pulumi.getter
    def eip(self) -> pulumi.Output[str]:
        """
        Required when allocate_new_eip is false. It uses specified EIP for this gateway.
        """
        return pulumi.get(self, "eip")

    @property
    @pulumi.getter(name="elbDnsName")
    def elb_dns_name(self) -> pulumi.Output[str]:
        """
        ELB DNS Name.
        """
        return pulumi.get(self, "elb_dns_name")

    @property
    @pulumi.getter(name="elbName")
    def elb_name(self) -> pulumi.Output[str]:
        """
        A name for the ELB that is created.
        """
        return pulumi.get(self, "elb_name")

    @property
    @pulumi.getter(name="enableDesignatedGateway")
    def enable_designated_gateway(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable 'designated_gateway' feature for Gateway. Valid values: true, false.
        """
        return pulumi.get(self, "enable_designated_gateway")

    @property
    @pulumi.getter(name="enableElb")
    def enable_elb(self) -> pulumi.Output[Optional[bool]]:
        """
        Specify whether to enable ELB or not.
        """
        return pulumi.get(self, "enable_elb")

    @property
    @pulumi.getter(name="enableEncryptVolume")
    def enable_encrypt_volume(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable encrypt gateway EBS volume. Only supported for AWS provider. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_encrypt_volume")

    @property
    @pulumi.getter(name="enableJumboFrame")
    def enable_jumbo_frame(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable jumbo frame support for Gateway. Valid values: true or false. Default value: true.
        """
        return pulumi.get(self, "enable_jumbo_frame")

    @property
    @pulumi.getter(name="enableLdap")
    def enable_ldap(self) -> pulumi.Output[Optional[bool]]:
        """
        Specify whether to enable LDAP or not. Supported values: 'yes' and 'no'.
        """
        return pulumi.get(self, "enable_ldap")

    @property
    @pulumi.getter(name="enableMonitorGatewaySubnets")
    def enable_monitor_gateway_subnets(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable monitor gateway subnets. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_monitor_gateway_subnets")

    @property
    @pulumi.getter(name="enablePublicSubnetFiltering")
    def enable_public_subnet_filtering(self) -> pulumi.Output[Optional[bool]]:
        """
        Create a [Public Subnet Filtering gateway](https://docs.aviatrix.com/HowTos/public_subnet_filtering_faq.html).
        """
        return pulumi.get(self, "enable_public_subnet_filtering")

    @property
    @pulumi.getter(name="enableSpotInstance")
    def enable_spot_instance(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable spot instance. NOT supported for production deployment.
        """
        return pulumi.get(self, "enable_spot_instance")

    @property
    @pulumi.getter(name="enableVpcDnsServer")
    def enable_vpc_dns_server(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable vpc_dns_server for Gateway. Valid values: true, false.
        """
        return pulumi.get(self, "enable_vpc_dns_server")

    @property
    @pulumi.getter(name="enableVpnNat")
    def enable_vpn_nat(self) -> pulumi.Output[Optional[bool]]:
        """
        This field indicates whether to enable VPN NAT or not. Only supported for VPN gateway. Valid values: true, false.
        Default value: true.
        """
        return pulumi.get(self, "enable_vpn_nat")

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> pulumi.Output[str]:
        """
        Fault domain for OCI.
        """
        return pulumi.get(self, "fault_domain")

    @property
    @pulumi.getter(name="fqdnLanCidr")
    def fqdn_lan_cidr(self) -> pulumi.Output[Optional[str]]:
        """
        FQDN gateway lan interface cidr.
        """
        return pulumi.get(self, "fqdn_lan_cidr")

    @property
    @pulumi.getter(name="fqdnLanInterface")
    def fqdn_lan_interface(self) -> pulumi.Output[str]:
        """
        FQDN gateway lan interface id.
        """
        return pulumi.get(self, "fqdn_lan_interface")

    @property
    @pulumi.getter(name="fqdnLanVpcId")
    def fqdn_lan_vpc_id(self) -> pulumi.Output[Optional[str]]:
        """
        LAN VPC ID. Only used for GCP FQDN Gateway.
        """
        return pulumi.get(self, "fqdn_lan_vpc_id")

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> pulumi.Output[str]:
        """
        Aviatrix gateway unique name.
        """
        return pulumi.get(self, "gw_name")

    @property
    @pulumi.getter(name="gwSize")
    def gw_size(self) -> pulumi.Output[str]:
        """
        Size of Gateway Instance.
        """
        return pulumi.get(self, "gw_size")

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> pulumi.Output[Optional[int]]:
        """
        Typed value when modifying idle_timeout. If it's -1, this feature is disabled.
        """
        return pulumi.get(self, "idle_timeout")

    @property
    @pulumi.getter(name="imageVersion")
    def image_version(self) -> pulumi.Output[str]:
        """
        image_version can be used to set the desired image version of the gateway. If set, we will attempt to update the gateway
        to the specified version.
        """
        return pulumi.get(self, "image_version")

    @property
    @pulumi.getter(name="insaneMode")
    def insane_mode(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable Insane Mode for Gateway. Valid values: true, false.
        """
        return pulumi.get(self, "insane_mode")

    @property
    @pulumi.getter(name="insaneModeAz")
    def insane_mode_az(self) -> pulumi.Output[Optional[str]]:
        """
        AZ of subnet being created for Insane Mode Gateway. Required if insane_mode is set.
        """
        return pulumi.get(self, "insane_mode_az")

    @property
    @pulumi.getter(name="ldapBaseDn")
    def ldap_base_dn(self) -> pulumi.Output[Optional[str]]:
        """
        LDAP base DN. Required: Yes if enable_ldap is 'yes'.
        """
        return pulumi.get(self, "ldap_base_dn")

    @property
    @pulumi.getter(name="ldapBindDn")
    def ldap_bind_dn(self) -> pulumi.Output[Optional[str]]:
        """
        LDAP bind DN. Required: Yes if enable_ldap is 'yes'.
        """
        return pulumi.get(self, "ldap_bind_dn")

    @property
    @pulumi.getter(name="ldapPassword")
    def ldap_password(self) -> pulumi.Output[Optional[str]]:
        """
        LDAP password. Required: Yes if enable_ldap is 'yes'.
        """
        return pulumi.get(self, "ldap_password")

    @property
    @pulumi.getter(name="ldapServer")
    def ldap_server(self) -> pulumi.Output[Optional[str]]:
        """
        LDAP server address. Required: Yes if enable_ldap is 'yes'.
        """
        return pulumi.get(self, "ldap_server")

    @property
    @pulumi.getter(name="ldapUsernameAttribute")
    def ldap_username_attribute(self) -> pulumi.Output[Optional[str]]:
        """
        LDAP user attribute. Required: Yes if enable_ldap is 'yes'.
        """
        return pulumi.get(self, "ldap_username_attribute")

    @property
    @pulumi.getter(name="maxVpnConn")
    def max_vpn_conn(self) -> pulumi.Output[Optional[str]]:
        """
        Maximum connection of VPN access.
        """
        return pulumi.get(self, "max_vpn_conn")

    @property
    @pulumi.getter(name="monitorExcludeLists")
    def monitor_exclude_lists(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A set of monitored instance ids. Only valid when 'enable_monitor_gateway_subnets' = true.
        """
        return pulumi.get(self, "monitor_exclude_lists")

    @property
    @pulumi.getter(name="nameServers")
    def name_servers(self) -> pulumi.Output[Optional[str]]:
        """
        A list of DNS servers used to resolve domain names by a connected VPN user when Split Tunnel Mode is enabled.
        """
        return pulumi.get(self, "name_servers")

    @property
    @pulumi.getter(name="oktaToken")
    def okta_token(self) -> pulumi.Output[Optional[str]]:
        """
        Token for Okta auth mode.
        """
        return pulumi.get(self, "okta_token")

    @property
    @pulumi.getter(name="oktaUrl")
    def okta_url(self) -> pulumi.Output[Optional[str]]:
        """
        URL for Okta auth mode.
        """
        return pulumi.get(self, "okta_url")

    @property
    @pulumi.getter(name="oktaUsernameSuffix")
    def okta_username_suffix(self) -> pulumi.Output[Optional[str]]:
        """
        Username suffix for Okta auth mode.
        """
        return pulumi.get(self, "okta_username_suffix")

    @property
    @pulumi.getter(name="otpMode")
    def otp_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Two step authentication mode.
        """
        return pulumi.get(self, "otp_mode")

    @property
    @pulumi.getter(name="peeringHaAvailabilityDomain")
    def peering_ha_availability_domain(self) -> pulumi.Output[str]:
        """
        Peering HA availability domain for OCI.
        """
        return pulumi.get(self, "peering_ha_availability_domain")

    @property
    @pulumi.getter(name="peeringHaAzureEipNameResourceGroup")
    def peering_ha_azure_eip_name_resource_group(self) -> pulumi.Output[str]:
        """
        The name of the public IP address and its resource group in Azure to assign to the Peering HA Gateway.
        """
        return pulumi.get(self, "peering_ha_azure_eip_name_resource_group")

    @property
    @pulumi.getter(name="peeringHaCloudInstanceId")
    def peering_ha_cloud_instance_id(self) -> pulumi.Output[str]:
        """
        Instance ID of the peering HA gateway.
        """
        return pulumi.get(self, "peering_ha_cloud_instance_id")

    @property
    @pulumi.getter(name="peeringHaEip")
    def peering_ha_eip(self) -> pulumi.Output[str]:
        """
        Public IP address that you want assigned to the HA peering instance.
        """
        return pulumi.get(self, "peering_ha_eip")

    @property
    @pulumi.getter(name="peeringHaFaultDomain")
    def peering_ha_fault_domain(self) -> pulumi.Output[str]:
        """
        Peering HA fault domain for OCI.
        """
        return pulumi.get(self, "peering_ha_fault_domain")

    @property
    @pulumi.getter(name="peeringHaGwName")
    def peering_ha_gw_name(self) -> pulumi.Output[str]:
        """
        Aviatrix gateway unique name of HA gateway.
        """
        return pulumi.get(self, "peering_ha_gw_name")

    @property
    @pulumi.getter(name="peeringHaGwSize")
    def peering_ha_gw_size(self) -> pulumi.Output[Optional[str]]:
        """
        Peering HA Gateway Size.
        """
        return pulumi.get(self, "peering_ha_gw_size")

    @property
    @pulumi.getter(name="peeringHaImageVersion")
    def peering_ha_image_version(self) -> pulumi.Output[str]:
        """
        peering_ha_image_version can be used to set the desired image version of the HA gateway. If set, we will attempt to
        update the gateway to the specified version.
        """
        return pulumi.get(self, "peering_ha_image_version")

    @property
    @pulumi.getter(name="peeringHaInsaneModeAz")
    def peering_ha_insane_mode_az(self) -> pulumi.Output[Optional[str]]:
        """
        AZ of subnet being created for Insane Mode Peering HA Gateway. Required if insane_mode is set.
        """
        return pulumi.get(self, "peering_ha_insane_mode_az")

    @property
    @pulumi.getter(name="peeringHaPrivateIp")
    def peering_ha_private_ip(self) -> pulumi.Output[str]:
        """
        Private IP address of HA gateway.
        """
        return pulumi.get(self, "peering_ha_private_ip")

    @property
    @pulumi.getter(name="peeringHaSecurityGroupId")
    def peering_ha_security_group_id(self) -> pulumi.Output[str]:
        """
        Peering HA security group used for the gateway.
        """
        return pulumi.get(self, "peering_ha_security_group_id")

    @property
    @pulumi.getter(name="peeringHaSoftwareVersion")
    def peering_ha_software_version(self) -> pulumi.Output[str]:
        """
        peering_ha_software_version can be used to set the desired software version of the HA gateway. If set, we will attempt
        to update the gateway to the specified version. If left blank, the gateway software version will continue to be managed
        through the aviatrix_controller_config resource.
        """
        return pulumi.get(self, "peering_ha_software_version")

    @property
    @pulumi.getter(name="peeringHaSubnet")
    def peering_ha_subnet(self) -> pulumi.Output[Optional[str]]:
        """
        Public Subnet Information while creating Peering HA Gateway, only subnet is accepted. Required to create peering ha
        gateway if cloud_type = 1 or 8 (AWS or Azure). Optional if cloud_type = 4 (GCP)
        """
        return pulumi.get(self, "peering_ha_subnet")

    @property
    @pulumi.getter(name="peeringHaZone")
    def peering_ha_zone(self) -> pulumi.Output[Optional[str]]:
        """
        Zone information for creating Peering HA Gateway. Required to create peering ha gateway if cloud_type = 4 (GCP).
        Optional for cloud_type = 8 (Azure).
        """
        return pulumi.get(self, "peering_ha_zone")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Output[str]:
        """
        Private IP address of the Gateway created.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="publicDnsServer")
    def public_dns_server(self) -> pulumi.Output[str]:
        """
        NS server used by the gateway.
        """
        return pulumi.get(self, "public_dns_server")

    @property
    @pulumi.getter(name="publicSubnetFilteringGuardDutyEnforced")
    def public_subnet_filtering_guard_duty_enforced(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enforce Guard Duty IP blocking. Required when `enable_public_subnet_filtering` attribute is true. Valid
        values: true or false. Default value: true.
        """
        return pulumi.get(self, "public_subnet_filtering_guard_duty_enforced")

    @property
    @pulumi.getter(name="publicSubnetFilteringHaRouteTables")
    def public_subnet_filtering_ha_route_tables(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Route tables whose associated public subnets are protected for the HA PSF gateway. Required when
        enable_public_subnet_filtering and peering_ha_subnet are set.
        """
        return pulumi.get(self, "public_subnet_filtering_ha_route_tables")

    @property
    @pulumi.getter(name="publicSubnetFilteringRouteTables")
    def public_subnet_filtering_route_tables(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Route tables whose associated public subnets are protected. Required when `enable_public_subnet_filtering` attribute is
        true.
        """
        return pulumi.get(self, "public_subnet_filtering_route_tables")

    @property
    @pulumi.getter(name="renegotiationInterval")
    def renegotiation_interval(self) -> pulumi.Output[Optional[int]]:
        """
        Typed value when modifying renegotiation_interval. If it's -1, this feature is disabled.
        """
        return pulumi.get(self, "renegotiation_interval")

    @property
    @pulumi.getter(name="rxQueueSize")
    def rx_queue_size(self) -> pulumi.Output[Optional[str]]:
        """
        Gateway ethernet interface RX queue size. Supported for AWS related clouds only.
        """
        return pulumi.get(self, "rx_queue_size")

    @property
    @pulumi.getter(name="samlEnabled")
    def saml_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        This field indicates whether to enable SAML or not.
        """
        return pulumi.get(self, "saml_enabled")

    @property
    @pulumi.getter(name="searchDomains")
    def search_domains(self) -> pulumi.Output[Optional[str]]:
        """
        A list of domain names that will use the NameServer when a specific name is not in the destination when Split Tunnel
        Mode is enabled.
        """
        return pulumi.get(self, "search_domains")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[str]:
        """
        Security group used for the gateway.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="singleAzHa")
    def single_az_ha(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to true if this feature is desired.
        """
        return pulumi.get(self, "single_az_ha")

    @property
    @pulumi.getter(name="singleIpSnat")
    def single_ip_snat(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable Source NAT for this container.
        """
        return pulumi.get(self, "single_ip_snat")

    @property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> pulumi.Output[str]:
        """
        software_version can be used to set the desired software version of the gateway. If set, we will attempt to update the
        gateway to the specified version. If left blank, the gateway software version will continue to be managed through the
        aviatrix_controller_config resource.
        """
        return pulumi.get(self, "software_version")

    @property
    @pulumi.getter(name="splitTunnel")
    def split_tunnel(self) -> pulumi.Output[Optional[bool]]:
        """
        Specify split tunnel mode.
        """
        return pulumi.get(self, "split_tunnel")

    @property
    @pulumi.getter(name="spotPrice")
    def spot_price(self) -> pulumi.Output[Optional[str]]:
        """
        Price for spot instance. NOT supported for production deployment.
        """
        return pulumi.get(self, "spot_price")

    @property
    @pulumi.getter
    def subnet(self) -> pulumi.Output[str]:
        """
        A VPC Network address range selected from one of the available network ranges.
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter(name="tagLists")
    def tag_lists(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Instance tag of cloud provider.
        """
        return pulumi.get(self, "tag_lists")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the gateway.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tunnelDetectionTime")
    def tunnel_detection_time(self) -> pulumi.Output[int]:
        """
        The IPSec tunnel down detection time for the Gateway.
        """
        return pulumi.get(self, "tunnel_detection_time")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        ID of legacy VPC/Vnet to be connected.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vpcReg")
    def vpc_reg(self) -> pulumi.Output[str]:
        """
        Region where this gateway will be launched.
        """
        return pulumi.get(self, "vpc_reg")

    @property
    @pulumi.getter(name="vpnAccess")
    def vpn_access(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable user access through VPN to this container.
        """
        return pulumi.get(self, "vpn_access")

    @property
    @pulumi.getter(name="vpnCidr")
    def vpn_cidr(self) -> pulumi.Output[Optional[str]]:
        """
        VPN CIDR block for the container.
        """
        return pulumi.get(self, "vpn_cidr")

    @property
    @pulumi.getter(name="vpnProtocol")
    def vpn_protocol(self) -> pulumi.Output[str]:
        """
        Elb protocol for VPN gateway with elb enabled. Only supports AWS provider. Valid values: 'TCP', 'UDP'. If not specified,
        'TCP'' will be used.
        """
        return pulumi.get(self, "vpn_protocol")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[Optional[str]]:
        """
        Availability Zone. Only available for Azure and Public Subnet Filtering gateway
        """
        return pulumi.get(self, "zone")

