# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixFilebeatForwarderArgs', 'AviatrixFilebeatForwarder']

@pulumi.input_type
class AviatrixFilebeatForwarderArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[int],
                 server: pulumi.Input[str],
                 config_file: Optional[pulumi.Input[str]] = None,
                 excluded_gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 trusted_ca_file: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AviatrixFilebeatForwarder resource.
        :param pulumi.Input[int] port: Port number.
        :param pulumi.Input[str] server: Server IP.
        :param pulumi.Input[str] config_file: Configuration file.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excluded_gateways: List of excluded gateways.
        :param pulumi.Input[str] trusted_ca_file: Trusted CA file.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server", server)
        if config_file is not None:
            pulumi.set(__self__, "config_file", config_file)
        if excluded_gateways is not None:
            pulumi.set(__self__, "excluded_gateways", excluded_gateways)
        if trusted_ca_file is not None:
            pulumi.set(__self__, "trusted_ca_file", trusted_ca_file)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        Port number.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def server(self) -> pulumi.Input[str]:
        """
        Server IP.
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: pulumi.Input[str]):
        pulumi.set(self, "server", value)

    @property
    @pulumi.getter(name="configFile")
    def config_file(self) -> Optional[pulumi.Input[str]]:
        """
        Configuration file.
        """
        return pulumi.get(self, "config_file")

    @config_file.setter
    def config_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_file", value)

    @property
    @pulumi.getter(name="excludedGateways")
    def excluded_gateways(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of excluded gateways.
        """
        return pulumi.get(self, "excluded_gateways")

    @excluded_gateways.setter
    def excluded_gateways(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excluded_gateways", value)

    @property
    @pulumi.getter(name="trustedCaFile")
    def trusted_ca_file(self) -> Optional[pulumi.Input[str]]:
        """
        Trusted CA file.
        """
        return pulumi.get(self, "trusted_ca_file")

    @trusted_ca_file.setter
    def trusted_ca_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trusted_ca_file", value)


@pulumi.input_type
class _AviatrixFilebeatForwarderState:
    def __init__(__self__, *,
                 config_file: Optional[pulumi.Input[str]] = None,
                 excluded_gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 server: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 trusted_ca_file: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixFilebeatForwarder resources.
        :param pulumi.Input[str] config_file: Configuration file.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excluded_gateways: List of excluded gateways.
        :param pulumi.Input[int] port: Port number.
        :param pulumi.Input[str] server: Server IP.
        :param pulumi.Input[str] status: Enabled or not.
        :param pulumi.Input[str] trusted_ca_file: Trusted CA file.
        """
        if config_file is not None:
            pulumi.set(__self__, "config_file", config_file)
        if excluded_gateways is not None:
            pulumi.set(__self__, "excluded_gateways", excluded_gateways)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if trusted_ca_file is not None:
            pulumi.set(__self__, "trusted_ca_file", trusted_ca_file)

    @property
    @pulumi.getter(name="configFile")
    def config_file(self) -> Optional[pulumi.Input[str]]:
        """
        Configuration file.
        """
        return pulumi.get(self, "config_file")

    @config_file.setter
    def config_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_file", value)

    @property
    @pulumi.getter(name="excludedGateways")
    def excluded_gateways(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of excluded gateways.
        """
        return pulumi.get(self, "excluded_gateways")

    @excluded_gateways.setter
    def excluded_gateways(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excluded_gateways", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port number.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def server(self) -> Optional[pulumi.Input[str]]:
        """
        Server IP.
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Enabled or not.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="trustedCaFile")
    def trusted_ca_file(self) -> Optional[pulumi.Input[str]]:
        """
        Trusted CA file.
        """
        return pulumi.get(self, "trusted_ca_file")

    @trusted_ca_file.setter
    def trusted_ca_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trusted_ca_file", value)


class AviatrixFilebeatForwarder(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_file: Optional[pulumi.Input[str]] = None,
                 excluded_gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 server: Optional[pulumi.Input[str]] = None,
                 trusted_ca_file: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a AviatrixFilebeatForwarder resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] config_file: Configuration file.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excluded_gateways: List of excluded gateways.
        :param pulumi.Input[int] port: Port number.
        :param pulumi.Input[str] server: Server IP.
        :param pulumi.Input[str] trusted_ca_file: Trusted CA file.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixFilebeatForwarderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AviatrixFilebeatForwarder resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AviatrixFilebeatForwarderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixFilebeatForwarderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_file: Optional[pulumi.Input[str]] = None,
                 excluded_gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 server: Optional[pulumi.Input[str]] = None,
                 trusted_ca_file: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixFilebeatForwarderArgs.__new__(AviatrixFilebeatForwarderArgs)

            __props__.__dict__["config_file"] = config_file
            __props__.__dict__["excluded_gateways"] = excluded_gateways
            if port is None and not opts.urn:
                raise TypeError("Missing required property 'port'")
            __props__.__dict__["port"] = port
            if server is None and not opts.urn:
                raise TypeError("Missing required property 'server'")
            __props__.__dict__["server"] = server
            __props__.__dict__["trusted_ca_file"] = trusted_ca_file
            __props__.__dict__["status"] = None
        super(AviatrixFilebeatForwarder, __self__).__init__(
            'aviatrix:index/aviatrixFilebeatForwarder:AviatrixFilebeatForwarder',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config_file: Optional[pulumi.Input[str]] = None,
            excluded_gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            port: Optional[pulumi.Input[int]] = None,
            server: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            trusted_ca_file: Optional[pulumi.Input[str]] = None) -> 'AviatrixFilebeatForwarder':
        """
        Get an existing AviatrixFilebeatForwarder resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] config_file: Configuration file.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excluded_gateways: List of excluded gateways.
        :param pulumi.Input[int] port: Port number.
        :param pulumi.Input[str] server: Server IP.
        :param pulumi.Input[str] status: Enabled or not.
        :param pulumi.Input[str] trusted_ca_file: Trusted CA file.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixFilebeatForwarderState.__new__(_AviatrixFilebeatForwarderState)

        __props__.__dict__["config_file"] = config_file
        __props__.__dict__["excluded_gateways"] = excluded_gateways
        __props__.__dict__["port"] = port
        __props__.__dict__["server"] = server
        __props__.__dict__["status"] = status
        __props__.__dict__["trusted_ca_file"] = trusted_ca_file
        return AviatrixFilebeatForwarder(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="configFile")
    def config_file(self) -> pulumi.Output[Optional[str]]:
        """
        Configuration file.
        """
        return pulumi.get(self, "config_file")

    @property
    @pulumi.getter(name="excludedGateways")
    def excluded_gateways(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of excluded gateways.
        """
        return pulumi.get(self, "excluded_gateways")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        Port number.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def server(self) -> pulumi.Output[str]:
        """
        Server IP.
        """
        return pulumi.get(self, "server")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Enabled or not.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="trustedCaFile")
    def trusted_ca_file(self) -> pulumi.Output[Optional[str]]:
        """
        Trusted CA file.
        """
        return pulumi.get(self, "trusted_ca_file")

