# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixDatadogAgentArgs', 'AviatrixDatadogAgent']

@pulumi.input_type
class AviatrixDatadogAgentArgs:
    def __init__(__self__, *,
                 api_key: pulumi.Input[str],
                 excluded_gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 metrics_only: Optional[pulumi.Input[bool]] = None,
                 site: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AviatrixDatadogAgent resource.
        :param pulumi.Input[str] api_key: API key.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excluded_gateways: List of excluded gateways.
        :param pulumi.Input[bool] metrics_only: Only export metrics without exporting logs.
        :param pulumi.Input[str] site: Site preference.
        """
        pulumi.set(__self__, "api_key", api_key)
        if excluded_gateways is not None:
            pulumi.set(__self__, "excluded_gateways", excluded_gateways)
        if metrics_only is not None:
            pulumi.set(__self__, "metrics_only", metrics_only)
        if site is not None:
            pulumi.set(__self__, "site", site)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Input[str]:
        """
        API key.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter(name="excludedGateways")
    def excluded_gateways(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of excluded gateways.
        """
        return pulumi.get(self, "excluded_gateways")

    @excluded_gateways.setter
    def excluded_gateways(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excluded_gateways", value)

    @property
    @pulumi.getter(name="metricsOnly")
    def metrics_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Only export metrics without exporting logs.
        """
        return pulumi.get(self, "metrics_only")

    @metrics_only.setter
    def metrics_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "metrics_only", value)

    @property
    @pulumi.getter
    def site(self) -> Optional[pulumi.Input[str]]:
        """
        Site preference.
        """
        return pulumi.get(self, "site")

    @site.setter
    def site(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "site", value)


@pulumi.input_type
class _AviatrixDatadogAgentState:
    def __init__(__self__, *,
                 api_key: Optional[pulumi.Input[str]] = None,
                 excluded_gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 metrics_only: Optional[pulumi.Input[bool]] = None,
                 site: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixDatadogAgent resources.
        :param pulumi.Input[str] api_key: API key.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excluded_gateways: List of excluded gateways.
        :param pulumi.Input[bool] metrics_only: Only export metrics without exporting logs.
        :param pulumi.Input[str] site: Site preference.
        :param pulumi.Input[str] status: Enabled or not.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if excluded_gateways is not None:
            pulumi.set(__self__, "excluded_gateways", excluded_gateways)
        if metrics_only is not None:
            pulumi.set(__self__, "metrics_only", metrics_only)
        if site is not None:
            pulumi.set(__self__, "site", site)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[str]]:
        """
        API key.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter(name="excludedGateways")
    def excluded_gateways(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of excluded gateways.
        """
        return pulumi.get(self, "excluded_gateways")

    @excluded_gateways.setter
    def excluded_gateways(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excluded_gateways", value)

    @property
    @pulumi.getter(name="metricsOnly")
    def metrics_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Only export metrics without exporting logs.
        """
        return pulumi.get(self, "metrics_only")

    @metrics_only.setter
    def metrics_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "metrics_only", value)

    @property
    @pulumi.getter
    def site(self) -> Optional[pulumi.Input[str]]:
        """
        Site preference.
        """
        return pulumi.get(self, "site")

    @site.setter
    def site(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "site", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Enabled or not.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class AviatrixDatadogAgent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[str]] = None,
                 excluded_gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 metrics_only: Optional[pulumi.Input[bool]] = None,
                 site: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a AviatrixDatadogAgent resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] api_key: API key.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excluded_gateways: List of excluded gateways.
        :param pulumi.Input[bool] metrics_only: Only export metrics without exporting logs.
        :param pulumi.Input[str] site: Site preference.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixDatadogAgentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AviatrixDatadogAgent resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AviatrixDatadogAgentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixDatadogAgentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[str]] = None,
                 excluded_gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 metrics_only: Optional[pulumi.Input[bool]] = None,
                 site: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixDatadogAgentArgs.__new__(AviatrixDatadogAgentArgs)

            if api_key is None and not opts.urn:
                raise TypeError("Missing required property 'api_key'")
            __props__.__dict__["api_key"] = api_key
            __props__.__dict__["excluded_gateways"] = excluded_gateways
            __props__.__dict__["metrics_only"] = metrics_only
            __props__.__dict__["site"] = site
            __props__.__dict__["status"] = None
        super(AviatrixDatadogAgent, __self__).__init__(
            'aviatrix:index/aviatrixDatadogAgent:AviatrixDatadogAgent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_key: Optional[pulumi.Input[str]] = None,
            excluded_gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            metrics_only: Optional[pulumi.Input[bool]] = None,
            site: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'AviatrixDatadogAgent':
        """
        Get an existing AviatrixDatadogAgent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] api_key: API key.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excluded_gateways: List of excluded gateways.
        :param pulumi.Input[bool] metrics_only: Only export metrics without exporting logs.
        :param pulumi.Input[str] site: Site preference.
        :param pulumi.Input[str] status: Enabled or not.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixDatadogAgentState.__new__(_AviatrixDatadogAgentState)

        __props__.__dict__["api_key"] = api_key
        __props__.__dict__["excluded_gateways"] = excluded_gateways
        __props__.__dict__["metrics_only"] = metrics_only
        __props__.__dict__["site"] = site
        __props__.__dict__["status"] = status
        return AviatrixDatadogAgent(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[str]:
        """
        API key.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="excludedGateways")
    def excluded_gateways(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of excluded gateways.
        """
        return pulumi.get(self, "excluded_gateways")

    @property
    @pulumi.getter(name="metricsOnly")
    def metrics_only(self) -> pulumi.Output[Optional[bool]]:
        """
        Only export metrics without exporting logs.
        """
        return pulumi.get(self, "metrics_only")

    @property
    @pulumi.getter
    def site(self) -> pulumi.Output[Optional[str]]:
        """
        Site preference.
        """
        return pulumi.get(self, "site")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Enabled or not.
        """
        return pulumi.get(self, "status")

