# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixCloudnTransitGatewayAttachmentArgs', 'AviatrixCloudnTransitGatewayAttachment']

@pulumi.input_type
class AviatrixCloudnTransitGatewayAttachmentArgs:
    def __init__(__self__, *,
                 cloudn_bgp_asn: pulumi.Input[str],
                 cloudn_lan_interface_neighbor_bgp_asn: pulumi.Input[str],
                 cloudn_lan_interface_neighbor_ip: pulumi.Input[str],
                 connection_name: pulumi.Input[str],
                 device_name: pulumi.Input[str],
                 transit_gateway_bgp_asn: pulumi.Input[str],
                 transit_gateway_name: pulumi.Input[str],
                 enable_jumbo_frame: Optional[pulumi.Input[bool]] = None,
                 enable_over_private_network: Optional[pulumi.Input[bool]] = None,
                 prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a AviatrixCloudnTransitGatewayAttachment resource.
        :param pulumi.Input[str] cloudn_bgp_asn: CloudN BGP AS Number.
        :param pulumi.Input[str] cloudn_lan_interface_neighbor_bgp_asn: CloudN LAN Interface Neighbor's BGP AS Number.
        :param pulumi.Input[str] cloudn_lan_interface_neighbor_ip: CloudN LAN Interface Neighbor's IP.
        :param pulumi.Input[str] connection_name: Connection name.
        :param pulumi.Input[str] device_name: Device name.
        :param pulumi.Input[str] transit_gateway_bgp_asn: Transit Gateway BGP AS Number.
        :param pulumi.Input[str] transit_gateway_name: Transit Gateway name.
        :param pulumi.Input[bool] enable_jumbo_frame: Enable jumbo frame.
        :param pulumi.Input[bool] enable_over_private_network: Enable over private network.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prepend_as_paths: AS path prepend.
        """
        pulumi.set(__self__, "cloudn_bgp_asn", cloudn_bgp_asn)
        pulumi.set(__self__, "cloudn_lan_interface_neighbor_bgp_asn", cloudn_lan_interface_neighbor_bgp_asn)
        pulumi.set(__self__, "cloudn_lan_interface_neighbor_ip", cloudn_lan_interface_neighbor_ip)
        pulumi.set(__self__, "connection_name", connection_name)
        pulumi.set(__self__, "device_name", device_name)
        pulumi.set(__self__, "transit_gateway_bgp_asn", transit_gateway_bgp_asn)
        pulumi.set(__self__, "transit_gateway_name", transit_gateway_name)
        if enable_jumbo_frame is not None:
            pulumi.set(__self__, "enable_jumbo_frame", enable_jumbo_frame)
        if enable_over_private_network is not None:
            pulumi.set(__self__, "enable_over_private_network", enable_over_private_network)
        if prepend_as_paths is not None:
            pulumi.set(__self__, "prepend_as_paths", prepend_as_paths)

    @property
    @pulumi.getter(name="cloudnBgpAsn")
    def cloudn_bgp_asn(self) -> pulumi.Input[str]:
        """
        CloudN BGP AS Number.
        """
        return pulumi.get(self, "cloudn_bgp_asn")

    @cloudn_bgp_asn.setter
    def cloudn_bgp_asn(self, value: pulumi.Input[str]):
        pulumi.set(self, "cloudn_bgp_asn", value)

    @property
    @pulumi.getter(name="cloudnLanInterfaceNeighborBgpAsn")
    def cloudn_lan_interface_neighbor_bgp_asn(self) -> pulumi.Input[str]:
        """
        CloudN LAN Interface Neighbor's BGP AS Number.
        """
        return pulumi.get(self, "cloudn_lan_interface_neighbor_bgp_asn")

    @cloudn_lan_interface_neighbor_bgp_asn.setter
    def cloudn_lan_interface_neighbor_bgp_asn(self, value: pulumi.Input[str]):
        pulumi.set(self, "cloudn_lan_interface_neighbor_bgp_asn", value)

    @property
    @pulumi.getter(name="cloudnLanInterfaceNeighborIp")
    def cloudn_lan_interface_neighbor_ip(self) -> pulumi.Input[str]:
        """
        CloudN LAN Interface Neighbor's IP.
        """
        return pulumi.get(self, "cloudn_lan_interface_neighbor_ip")

    @cloudn_lan_interface_neighbor_ip.setter
    def cloudn_lan_interface_neighbor_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "cloudn_lan_interface_neighbor_ip", value)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> pulumi.Input[str]:
        """
        Connection name.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_name", value)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> pulumi.Input[str]:
        """
        Device name.
        """
        return pulumi.get(self, "device_name")

    @device_name.setter
    def device_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "device_name", value)

    @property
    @pulumi.getter(name="transitGatewayBgpAsn")
    def transit_gateway_bgp_asn(self) -> pulumi.Input[str]:
        """
        Transit Gateway BGP AS Number.
        """
        return pulumi.get(self, "transit_gateway_bgp_asn")

    @transit_gateway_bgp_asn.setter
    def transit_gateway_bgp_asn(self, value: pulumi.Input[str]):
        pulumi.set(self, "transit_gateway_bgp_asn", value)

    @property
    @pulumi.getter(name="transitGatewayName")
    def transit_gateway_name(self) -> pulumi.Input[str]:
        """
        Transit Gateway name.
        """
        return pulumi.get(self, "transit_gateway_name")

    @transit_gateway_name.setter
    def transit_gateway_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "transit_gateway_name", value)

    @property
    @pulumi.getter(name="enableJumboFrame")
    def enable_jumbo_frame(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable jumbo frame.
        """
        return pulumi.get(self, "enable_jumbo_frame")

    @enable_jumbo_frame.setter
    def enable_jumbo_frame(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_jumbo_frame", value)

    @property
    @pulumi.getter(name="enableOverPrivateNetwork")
    def enable_over_private_network(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable over private network.
        """
        return pulumi.get(self, "enable_over_private_network")

    @enable_over_private_network.setter
    def enable_over_private_network(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_over_private_network", value)

    @property
    @pulumi.getter(name="prependAsPaths")
    def prepend_as_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        AS path prepend.
        """
        return pulumi.get(self, "prepend_as_paths")

    @prepend_as_paths.setter
    def prepend_as_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "prepend_as_paths", value)


@pulumi.input_type
class _AviatrixCloudnTransitGatewayAttachmentState:
    def __init__(__self__, *,
                 cloudn_bgp_asn: Optional[pulumi.Input[str]] = None,
                 cloudn_lan_interface_neighbor_bgp_asn: Optional[pulumi.Input[str]] = None,
                 cloudn_lan_interface_neighbor_ip: Optional[pulumi.Input[str]] = None,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 device_name: Optional[pulumi.Input[str]] = None,
                 enable_jumbo_frame: Optional[pulumi.Input[bool]] = None,
                 enable_over_private_network: Optional[pulumi.Input[bool]] = None,
                 prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 transit_gateway_bgp_asn: Optional[pulumi.Input[str]] = None,
                 transit_gateway_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixCloudnTransitGatewayAttachment resources.
        :param pulumi.Input[str] cloudn_bgp_asn: CloudN BGP AS Number.
        :param pulumi.Input[str] cloudn_lan_interface_neighbor_bgp_asn: CloudN LAN Interface Neighbor's BGP AS Number.
        :param pulumi.Input[str] cloudn_lan_interface_neighbor_ip: CloudN LAN Interface Neighbor's IP.
        :param pulumi.Input[str] connection_name: Connection name.
        :param pulumi.Input[str] device_name: Device name.
        :param pulumi.Input[bool] enable_jumbo_frame: Enable jumbo frame.
        :param pulumi.Input[bool] enable_over_private_network: Enable over private network.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prepend_as_paths: AS path prepend.
        :param pulumi.Input[str] transit_gateway_bgp_asn: Transit Gateway BGP AS Number.
        :param pulumi.Input[str] transit_gateway_name: Transit Gateway name.
        """
        if cloudn_bgp_asn is not None:
            pulumi.set(__self__, "cloudn_bgp_asn", cloudn_bgp_asn)
        if cloudn_lan_interface_neighbor_bgp_asn is not None:
            pulumi.set(__self__, "cloudn_lan_interface_neighbor_bgp_asn", cloudn_lan_interface_neighbor_bgp_asn)
        if cloudn_lan_interface_neighbor_ip is not None:
            pulumi.set(__self__, "cloudn_lan_interface_neighbor_ip", cloudn_lan_interface_neighbor_ip)
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)
        if device_name is not None:
            pulumi.set(__self__, "device_name", device_name)
        if enable_jumbo_frame is not None:
            pulumi.set(__self__, "enable_jumbo_frame", enable_jumbo_frame)
        if enable_over_private_network is not None:
            pulumi.set(__self__, "enable_over_private_network", enable_over_private_network)
        if prepend_as_paths is not None:
            pulumi.set(__self__, "prepend_as_paths", prepend_as_paths)
        if transit_gateway_bgp_asn is not None:
            pulumi.set(__self__, "transit_gateway_bgp_asn", transit_gateway_bgp_asn)
        if transit_gateway_name is not None:
            pulumi.set(__self__, "transit_gateway_name", transit_gateway_name)

    @property
    @pulumi.getter(name="cloudnBgpAsn")
    def cloudn_bgp_asn(self) -> Optional[pulumi.Input[str]]:
        """
        CloudN BGP AS Number.
        """
        return pulumi.get(self, "cloudn_bgp_asn")

    @cloudn_bgp_asn.setter
    def cloudn_bgp_asn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloudn_bgp_asn", value)

    @property
    @pulumi.getter(name="cloudnLanInterfaceNeighborBgpAsn")
    def cloudn_lan_interface_neighbor_bgp_asn(self) -> Optional[pulumi.Input[str]]:
        """
        CloudN LAN Interface Neighbor's BGP AS Number.
        """
        return pulumi.get(self, "cloudn_lan_interface_neighbor_bgp_asn")

    @cloudn_lan_interface_neighbor_bgp_asn.setter
    def cloudn_lan_interface_neighbor_bgp_asn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloudn_lan_interface_neighbor_bgp_asn", value)

    @property
    @pulumi.getter(name="cloudnLanInterfaceNeighborIp")
    def cloudn_lan_interface_neighbor_ip(self) -> Optional[pulumi.Input[str]]:
        """
        CloudN LAN Interface Neighbor's IP.
        """
        return pulumi.get(self, "cloudn_lan_interface_neighbor_ip")

    @cloudn_lan_interface_neighbor_ip.setter
    def cloudn_lan_interface_neighbor_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloudn_lan_interface_neighbor_ip", value)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[pulumi.Input[str]]:
        """
        Connection name.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_name", value)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> Optional[pulumi.Input[str]]:
        """
        Device name.
        """
        return pulumi.get(self, "device_name")

    @device_name.setter
    def device_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_name", value)

    @property
    @pulumi.getter(name="enableJumboFrame")
    def enable_jumbo_frame(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable jumbo frame.
        """
        return pulumi.get(self, "enable_jumbo_frame")

    @enable_jumbo_frame.setter
    def enable_jumbo_frame(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_jumbo_frame", value)

    @property
    @pulumi.getter(name="enableOverPrivateNetwork")
    def enable_over_private_network(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable over private network.
        """
        return pulumi.get(self, "enable_over_private_network")

    @enable_over_private_network.setter
    def enable_over_private_network(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_over_private_network", value)

    @property
    @pulumi.getter(name="prependAsPaths")
    def prepend_as_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        AS path prepend.
        """
        return pulumi.get(self, "prepend_as_paths")

    @prepend_as_paths.setter
    def prepend_as_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "prepend_as_paths", value)

    @property
    @pulumi.getter(name="transitGatewayBgpAsn")
    def transit_gateway_bgp_asn(self) -> Optional[pulumi.Input[str]]:
        """
        Transit Gateway BGP AS Number.
        """
        return pulumi.get(self, "transit_gateway_bgp_asn")

    @transit_gateway_bgp_asn.setter
    def transit_gateway_bgp_asn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_gateway_bgp_asn", value)

    @property
    @pulumi.getter(name="transitGatewayName")
    def transit_gateway_name(self) -> Optional[pulumi.Input[str]]:
        """
        Transit Gateway name.
        """
        return pulumi.get(self, "transit_gateway_name")

    @transit_gateway_name.setter
    def transit_gateway_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_gateway_name", value)


class AviatrixCloudnTransitGatewayAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloudn_bgp_asn: Optional[pulumi.Input[str]] = None,
                 cloudn_lan_interface_neighbor_bgp_asn: Optional[pulumi.Input[str]] = None,
                 cloudn_lan_interface_neighbor_ip: Optional[pulumi.Input[str]] = None,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 device_name: Optional[pulumi.Input[str]] = None,
                 enable_jumbo_frame: Optional[pulumi.Input[bool]] = None,
                 enable_over_private_network: Optional[pulumi.Input[bool]] = None,
                 prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 transit_gateway_bgp_asn: Optional[pulumi.Input[str]] = None,
                 transit_gateway_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a AviatrixCloudnTransitGatewayAttachment resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cloudn_bgp_asn: CloudN BGP AS Number.
        :param pulumi.Input[str] cloudn_lan_interface_neighbor_bgp_asn: CloudN LAN Interface Neighbor's BGP AS Number.
        :param pulumi.Input[str] cloudn_lan_interface_neighbor_ip: CloudN LAN Interface Neighbor's IP.
        :param pulumi.Input[str] connection_name: Connection name.
        :param pulumi.Input[str] device_name: Device name.
        :param pulumi.Input[bool] enable_jumbo_frame: Enable jumbo frame.
        :param pulumi.Input[bool] enable_over_private_network: Enable over private network.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prepend_as_paths: AS path prepend.
        :param pulumi.Input[str] transit_gateway_bgp_asn: Transit Gateway BGP AS Number.
        :param pulumi.Input[str] transit_gateway_name: Transit Gateway name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixCloudnTransitGatewayAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AviatrixCloudnTransitGatewayAttachment resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AviatrixCloudnTransitGatewayAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixCloudnTransitGatewayAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloudn_bgp_asn: Optional[pulumi.Input[str]] = None,
                 cloudn_lan_interface_neighbor_bgp_asn: Optional[pulumi.Input[str]] = None,
                 cloudn_lan_interface_neighbor_ip: Optional[pulumi.Input[str]] = None,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 device_name: Optional[pulumi.Input[str]] = None,
                 enable_jumbo_frame: Optional[pulumi.Input[bool]] = None,
                 enable_over_private_network: Optional[pulumi.Input[bool]] = None,
                 prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 transit_gateway_bgp_asn: Optional[pulumi.Input[str]] = None,
                 transit_gateway_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixCloudnTransitGatewayAttachmentArgs.__new__(AviatrixCloudnTransitGatewayAttachmentArgs)

            if cloudn_bgp_asn is None and not opts.urn:
                raise TypeError("Missing required property 'cloudn_bgp_asn'")
            __props__.__dict__["cloudn_bgp_asn"] = cloudn_bgp_asn
            if cloudn_lan_interface_neighbor_bgp_asn is None and not opts.urn:
                raise TypeError("Missing required property 'cloudn_lan_interface_neighbor_bgp_asn'")
            __props__.__dict__["cloudn_lan_interface_neighbor_bgp_asn"] = cloudn_lan_interface_neighbor_bgp_asn
            if cloudn_lan_interface_neighbor_ip is None and not opts.urn:
                raise TypeError("Missing required property 'cloudn_lan_interface_neighbor_ip'")
            __props__.__dict__["cloudn_lan_interface_neighbor_ip"] = cloudn_lan_interface_neighbor_ip
            if connection_name is None and not opts.urn:
                raise TypeError("Missing required property 'connection_name'")
            __props__.__dict__["connection_name"] = connection_name
            if device_name is None and not opts.urn:
                raise TypeError("Missing required property 'device_name'")
            __props__.__dict__["device_name"] = device_name
            __props__.__dict__["enable_jumbo_frame"] = enable_jumbo_frame
            __props__.__dict__["enable_over_private_network"] = enable_over_private_network
            __props__.__dict__["prepend_as_paths"] = prepend_as_paths
            if transit_gateway_bgp_asn is None and not opts.urn:
                raise TypeError("Missing required property 'transit_gateway_bgp_asn'")
            __props__.__dict__["transit_gateway_bgp_asn"] = transit_gateway_bgp_asn
            if transit_gateway_name is None and not opts.urn:
                raise TypeError("Missing required property 'transit_gateway_name'")
            __props__.__dict__["transit_gateway_name"] = transit_gateway_name
        super(AviatrixCloudnTransitGatewayAttachment, __self__).__init__(
            'aviatrix:index/aviatrixCloudnTransitGatewayAttachment:AviatrixCloudnTransitGatewayAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cloudn_bgp_asn: Optional[pulumi.Input[str]] = None,
            cloudn_lan_interface_neighbor_bgp_asn: Optional[pulumi.Input[str]] = None,
            cloudn_lan_interface_neighbor_ip: Optional[pulumi.Input[str]] = None,
            connection_name: Optional[pulumi.Input[str]] = None,
            device_name: Optional[pulumi.Input[str]] = None,
            enable_jumbo_frame: Optional[pulumi.Input[bool]] = None,
            enable_over_private_network: Optional[pulumi.Input[bool]] = None,
            prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            transit_gateway_bgp_asn: Optional[pulumi.Input[str]] = None,
            transit_gateway_name: Optional[pulumi.Input[str]] = None) -> 'AviatrixCloudnTransitGatewayAttachment':
        """
        Get an existing AviatrixCloudnTransitGatewayAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cloudn_bgp_asn: CloudN BGP AS Number.
        :param pulumi.Input[str] cloudn_lan_interface_neighbor_bgp_asn: CloudN LAN Interface Neighbor's BGP AS Number.
        :param pulumi.Input[str] cloudn_lan_interface_neighbor_ip: CloudN LAN Interface Neighbor's IP.
        :param pulumi.Input[str] connection_name: Connection name.
        :param pulumi.Input[str] device_name: Device name.
        :param pulumi.Input[bool] enable_jumbo_frame: Enable jumbo frame.
        :param pulumi.Input[bool] enable_over_private_network: Enable over private network.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prepend_as_paths: AS path prepend.
        :param pulumi.Input[str] transit_gateway_bgp_asn: Transit Gateway BGP AS Number.
        :param pulumi.Input[str] transit_gateway_name: Transit Gateway name.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixCloudnTransitGatewayAttachmentState.__new__(_AviatrixCloudnTransitGatewayAttachmentState)

        __props__.__dict__["cloudn_bgp_asn"] = cloudn_bgp_asn
        __props__.__dict__["cloudn_lan_interface_neighbor_bgp_asn"] = cloudn_lan_interface_neighbor_bgp_asn
        __props__.__dict__["cloudn_lan_interface_neighbor_ip"] = cloudn_lan_interface_neighbor_ip
        __props__.__dict__["connection_name"] = connection_name
        __props__.__dict__["device_name"] = device_name
        __props__.__dict__["enable_jumbo_frame"] = enable_jumbo_frame
        __props__.__dict__["enable_over_private_network"] = enable_over_private_network
        __props__.__dict__["prepend_as_paths"] = prepend_as_paths
        __props__.__dict__["transit_gateway_bgp_asn"] = transit_gateway_bgp_asn
        __props__.__dict__["transit_gateway_name"] = transit_gateway_name
        return AviatrixCloudnTransitGatewayAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cloudnBgpAsn")
    def cloudn_bgp_asn(self) -> pulumi.Output[str]:
        """
        CloudN BGP AS Number.
        """
        return pulumi.get(self, "cloudn_bgp_asn")

    @property
    @pulumi.getter(name="cloudnLanInterfaceNeighborBgpAsn")
    def cloudn_lan_interface_neighbor_bgp_asn(self) -> pulumi.Output[str]:
        """
        CloudN LAN Interface Neighbor's BGP AS Number.
        """
        return pulumi.get(self, "cloudn_lan_interface_neighbor_bgp_asn")

    @property
    @pulumi.getter(name="cloudnLanInterfaceNeighborIp")
    def cloudn_lan_interface_neighbor_ip(self) -> pulumi.Output[str]:
        """
        CloudN LAN Interface Neighbor's IP.
        """
        return pulumi.get(self, "cloudn_lan_interface_neighbor_ip")

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> pulumi.Output[str]:
        """
        Connection name.
        """
        return pulumi.get(self, "connection_name")

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> pulumi.Output[str]:
        """
        Device name.
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter(name="enableJumboFrame")
    def enable_jumbo_frame(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable jumbo frame.
        """
        return pulumi.get(self, "enable_jumbo_frame")

    @property
    @pulumi.getter(name="enableOverPrivateNetwork")
    def enable_over_private_network(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable over private network.
        """
        return pulumi.get(self, "enable_over_private_network")

    @property
    @pulumi.getter(name="prependAsPaths")
    def prepend_as_paths(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        AS path prepend.
        """
        return pulumi.get(self, "prepend_as_paths")

    @property
    @pulumi.getter(name="transitGatewayBgpAsn")
    def transit_gateway_bgp_asn(self) -> pulumi.Output[str]:
        """
        Transit Gateway BGP AS Number.
        """
        return pulumi.get(self, "transit_gateway_bgp_asn")

    @property
    @pulumi.getter(name="transitGatewayName")
    def transit_gateway_name(self) -> pulumi.Output[str]:
        """
        Transit Gateway name.
        """
        return pulumi.get(self, "transit_gateway_name")

