# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AviatrixAwsTgwVpnConnArgs', 'AviatrixAwsTgwVpnConn']

@pulumi.input_type
class AviatrixAwsTgwVpnConnArgs:
    def __init__(__self__, *,
                 connection_name: pulumi.Input[str],
                 public_ip: pulumi.Input[str],
                 route_domain_name: pulumi.Input[str],
                 tgw_name: pulumi.Input[str],
                 connection_type: Optional[pulumi.Input[str]] = None,
                 enable_global_acceleration: Optional[pulumi.Input[bool]] = None,
                 enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
                 inside_ip_cidr_tun1: Optional[pulumi.Input[str]] = None,
                 inside_ip_cidr_tun2: Optional[pulumi.Input[str]] = None,
                 pre_shared_key_tun1: Optional[pulumi.Input[str]] = None,
                 pre_shared_key_tun2: Optional[pulumi.Input[str]] = None,
                 remote_as_number: Optional[pulumi.Input[str]] = None,
                 remote_cidr: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AviatrixAwsTgwVpnConn resource.
        :param pulumi.Input[str] connection_name: Unique name of the connection.
        :param pulumi.Input[str] public_ip: Public IP address. Example: '40.0.0.0'.
        :param pulumi.Input[str] route_domain_name: The name of a route domain, to which the vpn will be attached.
        :param pulumi.Input[str] tgw_name: This parameter represents the name of an AWS TGW.
        :param pulumi.Input[str] connection_type: Connection type. Valid values: 'dynamic', 'static'. 'dynamic' stands for a BGP VPN connection; 'static' stands for a
               static VPN connection. Default value: 'dynamic'.
        :param pulumi.Input[bool] enable_global_acceleration: Enable Global Acceleration.
        :param pulumi.Input[bool] enable_learned_cidrs_approval: Switch to enable/disable encrypted transit approval for vpn connection. Valid values: true, false.
        :param pulumi.Input[str] inside_ip_cidr_tun1: Inside IP CIDR for Tunnel 1. A /30 CIDR in 169.254.0.0/16.
        :param pulumi.Input[str] inside_ip_cidr_tun2: Inside IP CIDR for Tunnel 2. A /30 CIDR in 169.254.0.0/16.
        :param pulumi.Input[str] pre_shared_key_tun1: Pre-Shared Key for Tunnel 1. A 8-64 character string with alphanumeric, underscore(_) and dot(.). It cannot start with 0
        :param pulumi.Input[str] pre_shared_key_tun2: Pre-Shared Key for Tunnel 2. A 8-64 character string with alphanumeric, underscore(_) and dot(.). It cannot start with 0
        :param pulumi.Input[str] remote_as_number: AWS side as a number. Integer between 1-4294967294. Example: '12'. Required for a dynamic VPN connection.
        :param pulumi.Input[str] remote_cidr: Remote CIDRs joined as a string with ','. Required for a static VPN connection.
        """
        pulumi.set(__self__, "connection_name", connection_name)
        pulumi.set(__self__, "public_ip", public_ip)
        pulumi.set(__self__, "route_domain_name", route_domain_name)
        pulumi.set(__self__, "tgw_name", tgw_name)
        if connection_type is not None:
            pulumi.set(__self__, "connection_type", connection_type)
        if enable_global_acceleration is not None:
            pulumi.set(__self__, "enable_global_acceleration", enable_global_acceleration)
        if enable_learned_cidrs_approval is not None:
            pulumi.set(__self__, "enable_learned_cidrs_approval", enable_learned_cidrs_approval)
        if inside_ip_cidr_tun1 is not None:
            pulumi.set(__self__, "inside_ip_cidr_tun1", inside_ip_cidr_tun1)
        if inside_ip_cidr_tun2 is not None:
            pulumi.set(__self__, "inside_ip_cidr_tun2", inside_ip_cidr_tun2)
        if pre_shared_key_tun1 is not None:
            pulumi.set(__self__, "pre_shared_key_tun1", pre_shared_key_tun1)
        if pre_shared_key_tun2 is not None:
            pulumi.set(__self__, "pre_shared_key_tun2", pre_shared_key_tun2)
        if remote_as_number is not None:
            pulumi.set(__self__, "remote_as_number", remote_as_number)
        if remote_cidr is not None:
            pulumi.set(__self__, "remote_cidr", remote_cidr)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> pulumi.Input[str]:
        """
        Unique name of the connection.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_name", value)

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Input[str]:
        """
        Public IP address. Example: '40.0.0.0'.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter(name="routeDomainName")
    def route_domain_name(self) -> pulumi.Input[str]:
        """
        The name of a route domain, to which the vpn will be attached.
        """
        return pulumi.get(self, "route_domain_name")

    @route_domain_name.setter
    def route_domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "route_domain_name", value)

    @property
    @pulumi.getter(name="tgwName")
    def tgw_name(self) -> pulumi.Input[str]:
        """
        This parameter represents the name of an AWS TGW.
        """
        return pulumi.get(self, "tgw_name")

    @tgw_name.setter
    def tgw_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "tgw_name", value)

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[pulumi.Input[str]]:
        """
        Connection type. Valid values: 'dynamic', 'static'. 'dynamic' stands for a BGP VPN connection; 'static' stands for a
        static VPN connection. Default value: 'dynamic'.
        """
        return pulumi.get(self, "connection_type")

    @connection_type.setter
    def connection_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_type", value)

    @property
    @pulumi.getter(name="enableGlobalAcceleration")
    def enable_global_acceleration(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Global Acceleration.
        """
        return pulumi.get(self, "enable_global_acceleration")

    @enable_global_acceleration.setter
    def enable_global_acceleration(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_global_acceleration", value)

    @property
    @pulumi.getter(name="enableLearnedCidrsApproval")
    def enable_learned_cidrs_approval(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable/disable encrypted transit approval for vpn connection. Valid values: true, false.
        """
        return pulumi.get(self, "enable_learned_cidrs_approval")

    @enable_learned_cidrs_approval.setter
    def enable_learned_cidrs_approval(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_learned_cidrs_approval", value)

    @property
    @pulumi.getter(name="insideIpCidrTun1")
    def inside_ip_cidr_tun1(self) -> Optional[pulumi.Input[str]]:
        """
        Inside IP CIDR for Tunnel 1. A /30 CIDR in 169.254.0.0/16.
        """
        return pulumi.get(self, "inside_ip_cidr_tun1")

    @inside_ip_cidr_tun1.setter
    def inside_ip_cidr_tun1(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inside_ip_cidr_tun1", value)

    @property
    @pulumi.getter(name="insideIpCidrTun2")
    def inside_ip_cidr_tun2(self) -> Optional[pulumi.Input[str]]:
        """
        Inside IP CIDR for Tunnel 2. A /30 CIDR in 169.254.0.0/16.
        """
        return pulumi.get(self, "inside_ip_cidr_tun2")

    @inside_ip_cidr_tun2.setter
    def inside_ip_cidr_tun2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inside_ip_cidr_tun2", value)

    @property
    @pulumi.getter(name="preSharedKeyTun1")
    def pre_shared_key_tun1(self) -> Optional[pulumi.Input[str]]:
        """
        Pre-Shared Key for Tunnel 1. A 8-64 character string with alphanumeric, underscore(_) and dot(.). It cannot start with 0
        """
        return pulumi.get(self, "pre_shared_key_tun1")

    @pre_shared_key_tun1.setter
    def pre_shared_key_tun1(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pre_shared_key_tun1", value)

    @property
    @pulumi.getter(name="preSharedKeyTun2")
    def pre_shared_key_tun2(self) -> Optional[pulumi.Input[str]]:
        """
        Pre-Shared Key for Tunnel 2. A 8-64 character string with alphanumeric, underscore(_) and dot(.). It cannot start with 0
        """
        return pulumi.get(self, "pre_shared_key_tun2")

    @pre_shared_key_tun2.setter
    def pre_shared_key_tun2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pre_shared_key_tun2", value)

    @property
    @pulumi.getter(name="remoteAsNumber")
    def remote_as_number(self) -> Optional[pulumi.Input[str]]:
        """
        AWS side as a number. Integer between 1-4294967294. Example: '12'. Required for a dynamic VPN connection.
        """
        return pulumi.get(self, "remote_as_number")

    @remote_as_number.setter
    def remote_as_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_as_number", value)

    @property
    @pulumi.getter(name="remoteCidr")
    def remote_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        Remote CIDRs joined as a string with ','. Required for a static VPN connection.
        """
        return pulumi.get(self, "remote_cidr")

    @remote_cidr.setter
    def remote_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_cidr", value)


@pulumi.input_type
class _AviatrixAwsTgwVpnConnState:
    def __init__(__self__, *,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 connection_type: Optional[pulumi.Input[str]] = None,
                 enable_global_acceleration: Optional[pulumi.Input[bool]] = None,
                 enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
                 inside_ip_cidr_tun1: Optional[pulumi.Input[str]] = None,
                 inside_ip_cidr_tun2: Optional[pulumi.Input[str]] = None,
                 pre_shared_key_tun1: Optional[pulumi.Input[str]] = None,
                 pre_shared_key_tun2: Optional[pulumi.Input[str]] = None,
                 public_ip: Optional[pulumi.Input[str]] = None,
                 remote_as_number: Optional[pulumi.Input[str]] = None,
                 remote_cidr: Optional[pulumi.Input[str]] = None,
                 route_domain_name: Optional[pulumi.Input[str]] = None,
                 tgw_name: Optional[pulumi.Input[str]] = None,
                 vpn_id: Optional[pulumi.Input[str]] = None,
                 vpn_tunnel_datas: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixAwsTgwVpnConnVpnTunnelDataArgs']]]] = None):
        """
        Input properties used for looking up and filtering AviatrixAwsTgwVpnConn resources.
        :param pulumi.Input[str] connection_name: Unique name of the connection.
        :param pulumi.Input[str] connection_type: Connection type. Valid values: 'dynamic', 'static'. 'dynamic' stands for a BGP VPN connection; 'static' stands for a
               static VPN connection. Default value: 'dynamic'.
        :param pulumi.Input[bool] enable_global_acceleration: Enable Global Acceleration.
        :param pulumi.Input[bool] enable_learned_cidrs_approval: Switch to enable/disable encrypted transit approval for vpn connection. Valid values: true, false.
        :param pulumi.Input[str] inside_ip_cidr_tun1: Inside IP CIDR for Tunnel 1. A /30 CIDR in 169.254.0.0/16.
        :param pulumi.Input[str] inside_ip_cidr_tun2: Inside IP CIDR for Tunnel 2. A /30 CIDR in 169.254.0.0/16.
        :param pulumi.Input[str] pre_shared_key_tun1: Pre-Shared Key for Tunnel 1. A 8-64 character string with alphanumeric, underscore(_) and dot(.). It cannot start with 0
        :param pulumi.Input[str] pre_shared_key_tun2: Pre-Shared Key for Tunnel 2. A 8-64 character string with alphanumeric, underscore(_) and dot(.). It cannot start with 0
        :param pulumi.Input[str] public_ip: Public IP address. Example: '40.0.0.0'.
        :param pulumi.Input[str] remote_as_number: AWS side as a number. Integer between 1-4294967294. Example: '12'. Required for a dynamic VPN connection.
        :param pulumi.Input[str] remote_cidr: Remote CIDRs joined as a string with ','. Required for a static VPN connection.
        :param pulumi.Input[str] route_domain_name: The name of a route domain, to which the vpn will be attached.
        :param pulumi.Input[str] tgw_name: This parameter represents the name of an AWS TGW.
        :param pulumi.Input[str] vpn_id: ID of the vpn connection.
        :param pulumi.Input[Sequence[pulumi.Input['AviatrixAwsTgwVpnConnVpnTunnelDataArgs']]] vpn_tunnel_datas: VPN tunnel data.
        """
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)
        if connection_type is not None:
            pulumi.set(__self__, "connection_type", connection_type)
        if enable_global_acceleration is not None:
            pulumi.set(__self__, "enable_global_acceleration", enable_global_acceleration)
        if enable_learned_cidrs_approval is not None:
            pulumi.set(__self__, "enable_learned_cidrs_approval", enable_learned_cidrs_approval)
        if inside_ip_cidr_tun1 is not None:
            pulumi.set(__self__, "inside_ip_cidr_tun1", inside_ip_cidr_tun1)
        if inside_ip_cidr_tun2 is not None:
            pulumi.set(__self__, "inside_ip_cidr_tun2", inside_ip_cidr_tun2)
        if pre_shared_key_tun1 is not None:
            pulumi.set(__self__, "pre_shared_key_tun1", pre_shared_key_tun1)
        if pre_shared_key_tun2 is not None:
            pulumi.set(__self__, "pre_shared_key_tun2", pre_shared_key_tun2)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if remote_as_number is not None:
            pulumi.set(__self__, "remote_as_number", remote_as_number)
        if remote_cidr is not None:
            pulumi.set(__self__, "remote_cidr", remote_cidr)
        if route_domain_name is not None:
            pulumi.set(__self__, "route_domain_name", route_domain_name)
        if tgw_name is not None:
            pulumi.set(__self__, "tgw_name", tgw_name)
        if vpn_id is not None:
            pulumi.set(__self__, "vpn_id", vpn_id)
        if vpn_tunnel_datas is not None:
            pulumi.set(__self__, "vpn_tunnel_datas", vpn_tunnel_datas)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of the connection.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_name", value)

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[pulumi.Input[str]]:
        """
        Connection type. Valid values: 'dynamic', 'static'. 'dynamic' stands for a BGP VPN connection; 'static' stands for a
        static VPN connection. Default value: 'dynamic'.
        """
        return pulumi.get(self, "connection_type")

    @connection_type.setter
    def connection_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_type", value)

    @property
    @pulumi.getter(name="enableGlobalAcceleration")
    def enable_global_acceleration(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Global Acceleration.
        """
        return pulumi.get(self, "enable_global_acceleration")

    @enable_global_acceleration.setter
    def enable_global_acceleration(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_global_acceleration", value)

    @property
    @pulumi.getter(name="enableLearnedCidrsApproval")
    def enable_learned_cidrs_approval(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable/disable encrypted transit approval for vpn connection. Valid values: true, false.
        """
        return pulumi.get(self, "enable_learned_cidrs_approval")

    @enable_learned_cidrs_approval.setter
    def enable_learned_cidrs_approval(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_learned_cidrs_approval", value)

    @property
    @pulumi.getter(name="insideIpCidrTun1")
    def inside_ip_cidr_tun1(self) -> Optional[pulumi.Input[str]]:
        """
        Inside IP CIDR for Tunnel 1. A /30 CIDR in 169.254.0.0/16.
        """
        return pulumi.get(self, "inside_ip_cidr_tun1")

    @inside_ip_cidr_tun1.setter
    def inside_ip_cidr_tun1(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inside_ip_cidr_tun1", value)

    @property
    @pulumi.getter(name="insideIpCidrTun2")
    def inside_ip_cidr_tun2(self) -> Optional[pulumi.Input[str]]:
        """
        Inside IP CIDR for Tunnel 2. A /30 CIDR in 169.254.0.0/16.
        """
        return pulumi.get(self, "inside_ip_cidr_tun2")

    @inside_ip_cidr_tun2.setter
    def inside_ip_cidr_tun2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inside_ip_cidr_tun2", value)

    @property
    @pulumi.getter(name="preSharedKeyTun1")
    def pre_shared_key_tun1(self) -> Optional[pulumi.Input[str]]:
        """
        Pre-Shared Key for Tunnel 1. A 8-64 character string with alphanumeric, underscore(_) and dot(.). It cannot start with 0
        """
        return pulumi.get(self, "pre_shared_key_tun1")

    @pre_shared_key_tun1.setter
    def pre_shared_key_tun1(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pre_shared_key_tun1", value)

    @property
    @pulumi.getter(name="preSharedKeyTun2")
    def pre_shared_key_tun2(self) -> Optional[pulumi.Input[str]]:
        """
        Pre-Shared Key for Tunnel 2. A 8-64 character string with alphanumeric, underscore(_) and dot(.). It cannot start with 0
        """
        return pulumi.get(self, "pre_shared_key_tun2")

    @pre_shared_key_tun2.setter
    def pre_shared_key_tun2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pre_shared_key_tun2", value)

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Public IP address. Example: '40.0.0.0'.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter(name="remoteAsNumber")
    def remote_as_number(self) -> Optional[pulumi.Input[str]]:
        """
        AWS side as a number. Integer between 1-4294967294. Example: '12'. Required for a dynamic VPN connection.
        """
        return pulumi.get(self, "remote_as_number")

    @remote_as_number.setter
    def remote_as_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_as_number", value)

    @property
    @pulumi.getter(name="remoteCidr")
    def remote_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        Remote CIDRs joined as a string with ','. Required for a static VPN connection.
        """
        return pulumi.get(self, "remote_cidr")

    @remote_cidr.setter
    def remote_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_cidr", value)

    @property
    @pulumi.getter(name="routeDomainName")
    def route_domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a route domain, to which the vpn will be attached.
        """
        return pulumi.get(self, "route_domain_name")

    @route_domain_name.setter
    def route_domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "route_domain_name", value)

    @property
    @pulumi.getter(name="tgwName")
    def tgw_name(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter represents the name of an AWS TGW.
        """
        return pulumi.get(self, "tgw_name")

    @tgw_name.setter
    def tgw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tgw_name", value)

    @property
    @pulumi.getter(name="vpnId")
    def vpn_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the vpn connection.
        """
        return pulumi.get(self, "vpn_id")

    @vpn_id.setter
    def vpn_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpn_id", value)

    @property
    @pulumi.getter(name="vpnTunnelDatas")
    def vpn_tunnel_datas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixAwsTgwVpnConnVpnTunnelDataArgs']]]]:
        """
        VPN tunnel data.
        """
        return pulumi.get(self, "vpn_tunnel_datas")

    @vpn_tunnel_datas.setter
    def vpn_tunnel_datas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixAwsTgwVpnConnVpnTunnelDataArgs']]]]):
        pulumi.set(self, "vpn_tunnel_datas", value)


class AviatrixAwsTgwVpnConn(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 connection_type: Optional[pulumi.Input[str]] = None,
                 enable_global_acceleration: Optional[pulumi.Input[bool]] = None,
                 enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
                 inside_ip_cidr_tun1: Optional[pulumi.Input[str]] = None,
                 inside_ip_cidr_tun2: Optional[pulumi.Input[str]] = None,
                 pre_shared_key_tun1: Optional[pulumi.Input[str]] = None,
                 pre_shared_key_tun2: Optional[pulumi.Input[str]] = None,
                 public_ip: Optional[pulumi.Input[str]] = None,
                 remote_as_number: Optional[pulumi.Input[str]] = None,
                 remote_cidr: Optional[pulumi.Input[str]] = None,
                 route_domain_name: Optional[pulumi.Input[str]] = None,
                 tgw_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a AviatrixAwsTgwVpnConn resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] connection_name: Unique name of the connection.
        :param pulumi.Input[str] connection_type: Connection type. Valid values: 'dynamic', 'static'. 'dynamic' stands for a BGP VPN connection; 'static' stands for a
               static VPN connection. Default value: 'dynamic'.
        :param pulumi.Input[bool] enable_global_acceleration: Enable Global Acceleration.
        :param pulumi.Input[bool] enable_learned_cidrs_approval: Switch to enable/disable encrypted transit approval for vpn connection. Valid values: true, false.
        :param pulumi.Input[str] inside_ip_cidr_tun1: Inside IP CIDR for Tunnel 1. A /30 CIDR in 169.254.0.0/16.
        :param pulumi.Input[str] inside_ip_cidr_tun2: Inside IP CIDR for Tunnel 2. A /30 CIDR in 169.254.0.0/16.
        :param pulumi.Input[str] pre_shared_key_tun1: Pre-Shared Key for Tunnel 1. A 8-64 character string with alphanumeric, underscore(_) and dot(.). It cannot start with 0
        :param pulumi.Input[str] pre_shared_key_tun2: Pre-Shared Key for Tunnel 2. A 8-64 character string with alphanumeric, underscore(_) and dot(.). It cannot start with 0
        :param pulumi.Input[str] public_ip: Public IP address. Example: '40.0.0.0'.
        :param pulumi.Input[str] remote_as_number: AWS side as a number. Integer between 1-4294967294. Example: '12'. Required for a dynamic VPN connection.
        :param pulumi.Input[str] remote_cidr: Remote CIDRs joined as a string with ','. Required for a static VPN connection.
        :param pulumi.Input[str] route_domain_name: The name of a route domain, to which the vpn will be attached.
        :param pulumi.Input[str] tgw_name: This parameter represents the name of an AWS TGW.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixAwsTgwVpnConnArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AviatrixAwsTgwVpnConn resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AviatrixAwsTgwVpnConnArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixAwsTgwVpnConnArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 connection_type: Optional[pulumi.Input[str]] = None,
                 enable_global_acceleration: Optional[pulumi.Input[bool]] = None,
                 enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
                 inside_ip_cidr_tun1: Optional[pulumi.Input[str]] = None,
                 inside_ip_cidr_tun2: Optional[pulumi.Input[str]] = None,
                 pre_shared_key_tun1: Optional[pulumi.Input[str]] = None,
                 pre_shared_key_tun2: Optional[pulumi.Input[str]] = None,
                 public_ip: Optional[pulumi.Input[str]] = None,
                 remote_as_number: Optional[pulumi.Input[str]] = None,
                 remote_cidr: Optional[pulumi.Input[str]] = None,
                 route_domain_name: Optional[pulumi.Input[str]] = None,
                 tgw_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixAwsTgwVpnConnArgs.__new__(AviatrixAwsTgwVpnConnArgs)

            if connection_name is None and not opts.urn:
                raise TypeError("Missing required property 'connection_name'")
            __props__.__dict__["connection_name"] = connection_name
            __props__.__dict__["connection_type"] = connection_type
            __props__.__dict__["enable_global_acceleration"] = enable_global_acceleration
            __props__.__dict__["enable_learned_cidrs_approval"] = enable_learned_cidrs_approval
            __props__.__dict__["inside_ip_cidr_tun1"] = inside_ip_cidr_tun1
            __props__.__dict__["inside_ip_cidr_tun2"] = inside_ip_cidr_tun2
            __props__.__dict__["pre_shared_key_tun1"] = pre_shared_key_tun1
            __props__.__dict__["pre_shared_key_tun2"] = pre_shared_key_tun2
            if public_ip is None and not opts.urn:
                raise TypeError("Missing required property 'public_ip'")
            __props__.__dict__["public_ip"] = public_ip
            __props__.__dict__["remote_as_number"] = remote_as_number
            __props__.__dict__["remote_cidr"] = remote_cidr
            if route_domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'route_domain_name'")
            __props__.__dict__["route_domain_name"] = route_domain_name
            if tgw_name is None and not opts.urn:
                raise TypeError("Missing required property 'tgw_name'")
            __props__.__dict__["tgw_name"] = tgw_name
            __props__.__dict__["vpn_id"] = None
            __props__.__dict__["vpn_tunnel_datas"] = None
        super(AviatrixAwsTgwVpnConn, __self__).__init__(
            'aviatrix:index/aviatrixAwsTgwVpnConn:AviatrixAwsTgwVpnConn',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connection_name: Optional[pulumi.Input[str]] = None,
            connection_type: Optional[pulumi.Input[str]] = None,
            enable_global_acceleration: Optional[pulumi.Input[bool]] = None,
            enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
            inside_ip_cidr_tun1: Optional[pulumi.Input[str]] = None,
            inside_ip_cidr_tun2: Optional[pulumi.Input[str]] = None,
            pre_shared_key_tun1: Optional[pulumi.Input[str]] = None,
            pre_shared_key_tun2: Optional[pulumi.Input[str]] = None,
            public_ip: Optional[pulumi.Input[str]] = None,
            remote_as_number: Optional[pulumi.Input[str]] = None,
            remote_cidr: Optional[pulumi.Input[str]] = None,
            route_domain_name: Optional[pulumi.Input[str]] = None,
            tgw_name: Optional[pulumi.Input[str]] = None,
            vpn_id: Optional[pulumi.Input[str]] = None,
            vpn_tunnel_datas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixAwsTgwVpnConnVpnTunnelDataArgs']]]]] = None) -> 'AviatrixAwsTgwVpnConn':
        """
        Get an existing AviatrixAwsTgwVpnConn resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] connection_name: Unique name of the connection.
        :param pulumi.Input[str] connection_type: Connection type. Valid values: 'dynamic', 'static'. 'dynamic' stands for a BGP VPN connection; 'static' stands for a
               static VPN connection. Default value: 'dynamic'.
        :param pulumi.Input[bool] enable_global_acceleration: Enable Global Acceleration.
        :param pulumi.Input[bool] enable_learned_cidrs_approval: Switch to enable/disable encrypted transit approval for vpn connection. Valid values: true, false.
        :param pulumi.Input[str] inside_ip_cidr_tun1: Inside IP CIDR for Tunnel 1. A /30 CIDR in 169.254.0.0/16.
        :param pulumi.Input[str] inside_ip_cidr_tun2: Inside IP CIDR for Tunnel 2. A /30 CIDR in 169.254.0.0/16.
        :param pulumi.Input[str] pre_shared_key_tun1: Pre-Shared Key for Tunnel 1. A 8-64 character string with alphanumeric, underscore(_) and dot(.). It cannot start with 0
        :param pulumi.Input[str] pre_shared_key_tun2: Pre-Shared Key for Tunnel 2. A 8-64 character string with alphanumeric, underscore(_) and dot(.). It cannot start with 0
        :param pulumi.Input[str] public_ip: Public IP address. Example: '40.0.0.0'.
        :param pulumi.Input[str] remote_as_number: AWS side as a number. Integer between 1-4294967294. Example: '12'. Required for a dynamic VPN connection.
        :param pulumi.Input[str] remote_cidr: Remote CIDRs joined as a string with ','. Required for a static VPN connection.
        :param pulumi.Input[str] route_domain_name: The name of a route domain, to which the vpn will be attached.
        :param pulumi.Input[str] tgw_name: This parameter represents the name of an AWS TGW.
        :param pulumi.Input[str] vpn_id: ID of the vpn connection.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixAwsTgwVpnConnVpnTunnelDataArgs']]]] vpn_tunnel_datas: VPN tunnel data.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixAwsTgwVpnConnState.__new__(_AviatrixAwsTgwVpnConnState)

        __props__.__dict__["connection_name"] = connection_name
        __props__.__dict__["connection_type"] = connection_type
        __props__.__dict__["enable_global_acceleration"] = enable_global_acceleration
        __props__.__dict__["enable_learned_cidrs_approval"] = enable_learned_cidrs_approval
        __props__.__dict__["inside_ip_cidr_tun1"] = inside_ip_cidr_tun1
        __props__.__dict__["inside_ip_cidr_tun2"] = inside_ip_cidr_tun2
        __props__.__dict__["pre_shared_key_tun1"] = pre_shared_key_tun1
        __props__.__dict__["pre_shared_key_tun2"] = pre_shared_key_tun2
        __props__.__dict__["public_ip"] = public_ip
        __props__.__dict__["remote_as_number"] = remote_as_number
        __props__.__dict__["remote_cidr"] = remote_cidr
        __props__.__dict__["route_domain_name"] = route_domain_name
        __props__.__dict__["tgw_name"] = tgw_name
        __props__.__dict__["vpn_id"] = vpn_id
        __props__.__dict__["vpn_tunnel_datas"] = vpn_tunnel_datas
        return AviatrixAwsTgwVpnConn(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> pulumi.Output[str]:
        """
        Unique name of the connection.
        """
        return pulumi.get(self, "connection_name")

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> pulumi.Output[Optional[str]]:
        """
        Connection type. Valid values: 'dynamic', 'static'. 'dynamic' stands for a BGP VPN connection; 'static' stands for a
        static VPN connection. Default value: 'dynamic'.
        """
        return pulumi.get(self, "connection_type")

    @property
    @pulumi.getter(name="enableGlobalAcceleration")
    def enable_global_acceleration(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable Global Acceleration.
        """
        return pulumi.get(self, "enable_global_acceleration")

    @property
    @pulumi.getter(name="enableLearnedCidrsApproval")
    def enable_learned_cidrs_approval(self) -> pulumi.Output[Optional[bool]]:
        """
        Switch to enable/disable encrypted transit approval for vpn connection. Valid values: true, false.
        """
        return pulumi.get(self, "enable_learned_cidrs_approval")

    @property
    @pulumi.getter(name="insideIpCidrTun1")
    def inside_ip_cidr_tun1(self) -> pulumi.Output[Optional[str]]:
        """
        Inside IP CIDR for Tunnel 1. A /30 CIDR in 169.254.0.0/16.
        """
        return pulumi.get(self, "inside_ip_cidr_tun1")

    @property
    @pulumi.getter(name="insideIpCidrTun2")
    def inside_ip_cidr_tun2(self) -> pulumi.Output[Optional[str]]:
        """
        Inside IP CIDR for Tunnel 2. A /30 CIDR in 169.254.0.0/16.
        """
        return pulumi.get(self, "inside_ip_cidr_tun2")

    @property
    @pulumi.getter(name="preSharedKeyTun1")
    def pre_shared_key_tun1(self) -> pulumi.Output[Optional[str]]:
        """
        Pre-Shared Key for Tunnel 1. A 8-64 character string with alphanumeric, underscore(_) and dot(.). It cannot start with 0
        """
        return pulumi.get(self, "pre_shared_key_tun1")

    @property
    @pulumi.getter(name="preSharedKeyTun2")
    def pre_shared_key_tun2(self) -> pulumi.Output[Optional[str]]:
        """
        Pre-Shared Key for Tunnel 2. A 8-64 character string with alphanumeric, underscore(_) and dot(.). It cannot start with 0
        """
        return pulumi.get(self, "pre_shared_key_tun2")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output[str]:
        """
        Public IP address. Example: '40.0.0.0'.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter(name="remoteAsNumber")
    def remote_as_number(self) -> pulumi.Output[Optional[str]]:
        """
        AWS side as a number. Integer between 1-4294967294. Example: '12'. Required for a dynamic VPN connection.
        """
        return pulumi.get(self, "remote_as_number")

    @property
    @pulumi.getter(name="remoteCidr")
    def remote_cidr(self) -> pulumi.Output[Optional[str]]:
        """
        Remote CIDRs joined as a string with ','. Required for a static VPN connection.
        """
        return pulumi.get(self, "remote_cidr")

    @property
    @pulumi.getter(name="routeDomainName")
    def route_domain_name(self) -> pulumi.Output[str]:
        """
        The name of a route domain, to which the vpn will be attached.
        """
        return pulumi.get(self, "route_domain_name")

    @property
    @pulumi.getter(name="tgwName")
    def tgw_name(self) -> pulumi.Output[str]:
        """
        This parameter represents the name of an AWS TGW.
        """
        return pulumi.get(self, "tgw_name")

    @property
    @pulumi.getter(name="vpnId")
    def vpn_id(self) -> pulumi.Output[str]:
        """
        ID of the vpn connection.
        """
        return pulumi.get(self, "vpn_id")

    @property
    @pulumi.getter(name="vpnTunnelDatas")
    def vpn_tunnel_datas(self) -> pulumi.Output[Sequence['outputs.AviatrixAwsTgwVpnConnVpnTunnelData']]:
        """
        VPN tunnel data.
        """
        return pulumi.get(self, "vpn_tunnel_datas")

