# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixAwsPeerArgs', 'AviatrixAwsPeer']

@pulumi.input_type
class AviatrixAwsPeerArgs:
    def __init__(__self__, *,
                 account_name1: pulumi.Input[str],
                 account_name2: pulumi.Input[str],
                 vpc_id1: pulumi.Input[str],
                 vpc_id2: pulumi.Input[str],
                 vpc_reg1: pulumi.Input[str],
                 vpc_reg2: pulumi.Input[str],
                 rtb_list1s: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rtb_list2s: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a AviatrixAwsPeer resource.
        :param pulumi.Input[str] account_name1: This parameter represents the name of an AWS Cloud-Account in Aviatrix controller.
        :param pulumi.Input[str] account_name2: This parameter represents the name of an AWS Cloud-Account in Aviatrix controller.
        :param pulumi.Input[str] vpc_id1: VPC-ID of AWS cloud.
        :param pulumi.Input[str] vpc_id2: VPC-ID of AWS cloud.
        :param pulumi.Input[str] vpc_reg1: Region of AWS cloud.
        :param pulumi.Input[str] vpc_reg2: Region of AWS cloud.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rtb_list1s: List of Route table ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rtb_list2s: List of Route table ID.
        """
        pulumi.set(__self__, "account_name1", account_name1)
        pulumi.set(__self__, "account_name2", account_name2)
        pulumi.set(__self__, "vpc_id1", vpc_id1)
        pulumi.set(__self__, "vpc_id2", vpc_id2)
        pulumi.set(__self__, "vpc_reg1", vpc_reg1)
        pulumi.set(__self__, "vpc_reg2", vpc_reg2)
        if rtb_list1s is not None:
            pulumi.set(__self__, "rtb_list1s", rtb_list1s)
        if rtb_list2s is not None:
            pulumi.set(__self__, "rtb_list2s", rtb_list2s)

    @property
    @pulumi.getter(name="accountName1")
    def account_name1(self) -> pulumi.Input[str]:
        """
        This parameter represents the name of an AWS Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "account_name1")

    @account_name1.setter
    def account_name1(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_name1", value)

    @property
    @pulumi.getter(name="accountName2")
    def account_name2(self) -> pulumi.Input[str]:
        """
        This parameter represents the name of an AWS Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "account_name2")

    @account_name2.setter
    def account_name2(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_name2", value)

    @property
    @pulumi.getter(name="vpcId1")
    def vpc_id1(self) -> pulumi.Input[str]:
        """
        VPC-ID of AWS cloud.
        """
        return pulumi.get(self, "vpc_id1")

    @vpc_id1.setter
    def vpc_id1(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id1", value)

    @property
    @pulumi.getter(name="vpcId2")
    def vpc_id2(self) -> pulumi.Input[str]:
        """
        VPC-ID of AWS cloud.
        """
        return pulumi.get(self, "vpc_id2")

    @vpc_id2.setter
    def vpc_id2(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id2", value)

    @property
    @pulumi.getter(name="vpcReg1")
    def vpc_reg1(self) -> pulumi.Input[str]:
        """
        Region of AWS cloud.
        """
        return pulumi.get(self, "vpc_reg1")

    @vpc_reg1.setter
    def vpc_reg1(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_reg1", value)

    @property
    @pulumi.getter(name="vpcReg2")
    def vpc_reg2(self) -> pulumi.Input[str]:
        """
        Region of AWS cloud.
        """
        return pulumi.get(self, "vpc_reg2")

    @vpc_reg2.setter
    def vpc_reg2(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_reg2", value)

    @property
    @pulumi.getter(name="rtbList1s")
    def rtb_list1s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Route table ID.
        """
        return pulumi.get(self, "rtb_list1s")

    @rtb_list1s.setter
    def rtb_list1s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "rtb_list1s", value)

    @property
    @pulumi.getter(name="rtbList2s")
    def rtb_list2s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Route table ID.
        """
        return pulumi.get(self, "rtb_list2s")

    @rtb_list2s.setter
    def rtb_list2s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "rtb_list2s", value)


@pulumi.input_type
class _AviatrixAwsPeerState:
    def __init__(__self__, *,
                 account_name1: Optional[pulumi.Input[str]] = None,
                 account_name2: Optional[pulumi.Input[str]] = None,
                 rtb_list1_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rtb_list1s: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rtb_list2_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rtb_list2s: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_id1: Optional[pulumi.Input[str]] = None,
                 vpc_id2: Optional[pulumi.Input[str]] = None,
                 vpc_reg1: Optional[pulumi.Input[str]] = None,
                 vpc_reg2: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixAwsPeer resources.
        :param pulumi.Input[str] account_name1: This parameter represents the name of an AWS Cloud-Account in Aviatrix controller.
        :param pulumi.Input[str] account_name2: This parameter represents the name of an AWS Cloud-Account in Aviatrix controller.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rtb_list1_outputs: List of route table ID of vpc_id1.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rtb_list1s: List of Route table ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rtb_list2_outputs: List of route table ID of vpc_id2.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rtb_list2s: List of Route table ID.
        :param pulumi.Input[str] vpc_id1: VPC-ID of AWS cloud.
        :param pulumi.Input[str] vpc_id2: VPC-ID of AWS cloud.
        :param pulumi.Input[str] vpc_reg1: Region of AWS cloud.
        :param pulumi.Input[str] vpc_reg2: Region of AWS cloud.
        """
        if account_name1 is not None:
            pulumi.set(__self__, "account_name1", account_name1)
        if account_name2 is not None:
            pulumi.set(__self__, "account_name2", account_name2)
        if rtb_list1_outputs is not None:
            pulumi.set(__self__, "rtb_list1_outputs", rtb_list1_outputs)
        if rtb_list1s is not None:
            pulumi.set(__self__, "rtb_list1s", rtb_list1s)
        if rtb_list2_outputs is not None:
            pulumi.set(__self__, "rtb_list2_outputs", rtb_list2_outputs)
        if rtb_list2s is not None:
            pulumi.set(__self__, "rtb_list2s", rtb_list2s)
        if vpc_id1 is not None:
            pulumi.set(__self__, "vpc_id1", vpc_id1)
        if vpc_id2 is not None:
            pulumi.set(__self__, "vpc_id2", vpc_id2)
        if vpc_reg1 is not None:
            pulumi.set(__self__, "vpc_reg1", vpc_reg1)
        if vpc_reg2 is not None:
            pulumi.set(__self__, "vpc_reg2", vpc_reg2)

    @property
    @pulumi.getter(name="accountName1")
    def account_name1(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter represents the name of an AWS Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "account_name1")

    @account_name1.setter
    def account_name1(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name1", value)

    @property
    @pulumi.getter(name="accountName2")
    def account_name2(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter represents the name of an AWS Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "account_name2")

    @account_name2.setter
    def account_name2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name2", value)

    @property
    @pulumi.getter(name="rtbList1Outputs")
    def rtb_list1_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of route table ID of vpc_id1.
        """
        return pulumi.get(self, "rtb_list1_outputs")

    @rtb_list1_outputs.setter
    def rtb_list1_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "rtb_list1_outputs", value)

    @property
    @pulumi.getter(name="rtbList1s")
    def rtb_list1s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Route table ID.
        """
        return pulumi.get(self, "rtb_list1s")

    @rtb_list1s.setter
    def rtb_list1s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "rtb_list1s", value)

    @property
    @pulumi.getter(name="rtbList2Outputs")
    def rtb_list2_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of route table ID of vpc_id2.
        """
        return pulumi.get(self, "rtb_list2_outputs")

    @rtb_list2_outputs.setter
    def rtb_list2_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "rtb_list2_outputs", value)

    @property
    @pulumi.getter(name="rtbList2s")
    def rtb_list2s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Route table ID.
        """
        return pulumi.get(self, "rtb_list2s")

    @rtb_list2s.setter
    def rtb_list2s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "rtb_list2s", value)

    @property
    @pulumi.getter(name="vpcId1")
    def vpc_id1(self) -> Optional[pulumi.Input[str]]:
        """
        VPC-ID of AWS cloud.
        """
        return pulumi.get(self, "vpc_id1")

    @vpc_id1.setter
    def vpc_id1(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id1", value)

    @property
    @pulumi.getter(name="vpcId2")
    def vpc_id2(self) -> Optional[pulumi.Input[str]]:
        """
        VPC-ID of AWS cloud.
        """
        return pulumi.get(self, "vpc_id2")

    @vpc_id2.setter
    def vpc_id2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id2", value)

    @property
    @pulumi.getter(name="vpcReg1")
    def vpc_reg1(self) -> Optional[pulumi.Input[str]]:
        """
        Region of AWS cloud.
        """
        return pulumi.get(self, "vpc_reg1")

    @vpc_reg1.setter
    def vpc_reg1(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_reg1", value)

    @property
    @pulumi.getter(name="vpcReg2")
    def vpc_reg2(self) -> Optional[pulumi.Input[str]]:
        """
        Region of AWS cloud.
        """
        return pulumi.get(self, "vpc_reg2")

    @vpc_reg2.setter
    def vpc_reg2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_reg2", value)


class AviatrixAwsPeer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name1: Optional[pulumi.Input[str]] = None,
                 account_name2: Optional[pulumi.Input[str]] = None,
                 rtb_list1s: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rtb_list2s: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_id1: Optional[pulumi.Input[str]] = None,
                 vpc_id2: Optional[pulumi.Input[str]] = None,
                 vpc_reg1: Optional[pulumi.Input[str]] = None,
                 vpc_reg2: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a AviatrixAwsPeer resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_name1: This parameter represents the name of an AWS Cloud-Account in Aviatrix controller.
        :param pulumi.Input[str] account_name2: This parameter represents the name of an AWS Cloud-Account in Aviatrix controller.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rtb_list1s: List of Route table ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rtb_list2s: List of Route table ID.
        :param pulumi.Input[str] vpc_id1: VPC-ID of AWS cloud.
        :param pulumi.Input[str] vpc_id2: VPC-ID of AWS cloud.
        :param pulumi.Input[str] vpc_reg1: Region of AWS cloud.
        :param pulumi.Input[str] vpc_reg2: Region of AWS cloud.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixAwsPeerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AviatrixAwsPeer resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AviatrixAwsPeerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixAwsPeerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name1: Optional[pulumi.Input[str]] = None,
                 account_name2: Optional[pulumi.Input[str]] = None,
                 rtb_list1s: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rtb_list2s: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_id1: Optional[pulumi.Input[str]] = None,
                 vpc_id2: Optional[pulumi.Input[str]] = None,
                 vpc_reg1: Optional[pulumi.Input[str]] = None,
                 vpc_reg2: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixAwsPeerArgs.__new__(AviatrixAwsPeerArgs)

            if account_name1 is None and not opts.urn:
                raise TypeError("Missing required property 'account_name1'")
            __props__.__dict__["account_name1"] = account_name1
            if account_name2 is None and not opts.urn:
                raise TypeError("Missing required property 'account_name2'")
            __props__.__dict__["account_name2"] = account_name2
            __props__.__dict__["rtb_list1s"] = rtb_list1s
            __props__.__dict__["rtb_list2s"] = rtb_list2s
            if vpc_id1 is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id1'")
            __props__.__dict__["vpc_id1"] = vpc_id1
            if vpc_id2 is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id2'")
            __props__.__dict__["vpc_id2"] = vpc_id2
            if vpc_reg1 is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_reg1'")
            __props__.__dict__["vpc_reg1"] = vpc_reg1
            if vpc_reg2 is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_reg2'")
            __props__.__dict__["vpc_reg2"] = vpc_reg2
            __props__.__dict__["rtb_list1_outputs"] = None
            __props__.__dict__["rtb_list2_outputs"] = None
        super(AviatrixAwsPeer, __self__).__init__(
            'aviatrix:index/aviatrixAwsPeer:AviatrixAwsPeer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_name1: Optional[pulumi.Input[str]] = None,
            account_name2: Optional[pulumi.Input[str]] = None,
            rtb_list1_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            rtb_list1s: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            rtb_list2_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            rtb_list2s: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            vpc_id1: Optional[pulumi.Input[str]] = None,
            vpc_id2: Optional[pulumi.Input[str]] = None,
            vpc_reg1: Optional[pulumi.Input[str]] = None,
            vpc_reg2: Optional[pulumi.Input[str]] = None) -> 'AviatrixAwsPeer':
        """
        Get an existing AviatrixAwsPeer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_name1: This parameter represents the name of an AWS Cloud-Account in Aviatrix controller.
        :param pulumi.Input[str] account_name2: This parameter represents the name of an AWS Cloud-Account in Aviatrix controller.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rtb_list1_outputs: List of route table ID of vpc_id1.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rtb_list1s: List of Route table ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rtb_list2_outputs: List of route table ID of vpc_id2.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rtb_list2s: List of Route table ID.
        :param pulumi.Input[str] vpc_id1: VPC-ID of AWS cloud.
        :param pulumi.Input[str] vpc_id2: VPC-ID of AWS cloud.
        :param pulumi.Input[str] vpc_reg1: Region of AWS cloud.
        :param pulumi.Input[str] vpc_reg2: Region of AWS cloud.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixAwsPeerState.__new__(_AviatrixAwsPeerState)

        __props__.__dict__["account_name1"] = account_name1
        __props__.__dict__["account_name2"] = account_name2
        __props__.__dict__["rtb_list1_outputs"] = rtb_list1_outputs
        __props__.__dict__["rtb_list1s"] = rtb_list1s
        __props__.__dict__["rtb_list2_outputs"] = rtb_list2_outputs
        __props__.__dict__["rtb_list2s"] = rtb_list2s
        __props__.__dict__["vpc_id1"] = vpc_id1
        __props__.__dict__["vpc_id2"] = vpc_id2
        __props__.__dict__["vpc_reg1"] = vpc_reg1
        __props__.__dict__["vpc_reg2"] = vpc_reg2
        return AviatrixAwsPeer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountName1")
    def account_name1(self) -> pulumi.Output[str]:
        """
        This parameter represents the name of an AWS Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "account_name1")

    @property
    @pulumi.getter(name="accountName2")
    def account_name2(self) -> pulumi.Output[str]:
        """
        This parameter represents the name of an AWS Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "account_name2")

    @property
    @pulumi.getter(name="rtbList1Outputs")
    def rtb_list1_outputs(self) -> pulumi.Output[Sequence[str]]:
        """
        List of route table ID of vpc_id1.
        """
        return pulumi.get(self, "rtb_list1_outputs")

    @property
    @pulumi.getter(name="rtbList1s")
    def rtb_list1s(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of Route table ID.
        """
        return pulumi.get(self, "rtb_list1s")

    @property
    @pulumi.getter(name="rtbList2Outputs")
    def rtb_list2_outputs(self) -> pulumi.Output[Sequence[str]]:
        """
        List of route table ID of vpc_id2.
        """
        return pulumi.get(self, "rtb_list2_outputs")

    @property
    @pulumi.getter(name="rtbList2s")
    def rtb_list2s(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of Route table ID.
        """
        return pulumi.get(self, "rtb_list2s")

    @property
    @pulumi.getter(name="vpcId1")
    def vpc_id1(self) -> pulumi.Output[str]:
        """
        VPC-ID of AWS cloud.
        """
        return pulumi.get(self, "vpc_id1")

    @property
    @pulumi.getter(name="vpcId2")
    def vpc_id2(self) -> pulumi.Output[str]:
        """
        VPC-ID of AWS cloud.
        """
        return pulumi.get(self, "vpc_id2")

    @property
    @pulumi.getter(name="vpcReg1")
    def vpc_reg1(self) -> pulumi.Output[str]:
        """
        Region of AWS cloud.
        """
        return pulumi.get(self, "vpc_reg1")

    @property
    @pulumi.getter(name="vpcReg2")
    def vpc_reg2(self) -> pulumi.Output[str]:
        """
        Region of AWS cloud.
        """
        return pulumi.get(self, "vpc_reg2")

