# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Optional, TYPE_CHECKING

from azure.core.pipeline.transport import AsyncHttpResponse, HttpRequest
from azure.mgmt.core import AsyncARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential

from ._configuration import ServiceFabricManagementClientConfiguration
from .operations import ClustersOperations
from .operations import ClusterVersionsOperations
from .operations import Operations
from .operations import ApplicationOperations
from .operations import ApplicationTypesOperations
from .operations import ApplicationTypeVersionsOperations
from .operations import ApplicationsOperations
from .operations import ServicesOperations
from .operations import ManagedClustersOperations
from .operations import ManagedclusterOperations
from .operations import ManagedClusterVersionsOperations
from .operations import NodetypeOperations
from .operations import NodeTypesOperations
from .. import models


class ServiceFabricManagementClient(object):
    """Service Fabric Management Client.

    :ivar clusters: ClustersOperations operations
    :vartype clusters: azure.mgmt.servicefabric.aio.operations.ClustersOperations
    :ivar cluster_versions: ClusterVersionsOperations operations
    :vartype cluster_versions: azure.mgmt.servicefabric.aio.operations.ClusterVersionsOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.servicefabric.aio.operations.Operations
    :ivar application: ApplicationOperations operations
    :vartype application: azure.mgmt.servicefabric.aio.operations.ApplicationOperations
    :ivar application_types: ApplicationTypesOperations operations
    :vartype application_types: azure.mgmt.servicefabric.aio.operations.ApplicationTypesOperations
    :ivar application_type_versions: ApplicationTypeVersionsOperations operations
    :vartype application_type_versions: azure.mgmt.servicefabric.aio.operations.ApplicationTypeVersionsOperations
    :ivar applications: ApplicationsOperations operations
    :vartype applications: azure.mgmt.servicefabric.aio.operations.ApplicationsOperations
    :ivar services: ServicesOperations operations
    :vartype services: azure.mgmt.servicefabric.aio.operations.ServicesOperations
    :ivar managed_clusters: ManagedClustersOperations operations
    :vartype managed_clusters: azure.mgmt.servicefabric.aio.operations.ManagedClustersOperations
    :ivar managedcluster: ManagedclusterOperations operations
    :vartype managedcluster: azure.mgmt.servicefabric.aio.operations.ManagedclusterOperations
    :ivar managed_cluster_versions: ManagedClusterVersionsOperations operations
    :vartype managed_cluster_versions: azure.mgmt.servicefabric.aio.operations.ManagedClusterVersionsOperations
    :ivar nodetype: NodetypeOperations operations
    :vartype nodetype: azure.mgmt.servicefabric.aio.operations.NodetypeOperations
    :ivar node_types: NodeTypesOperations operations
    :vartype node_types: azure.mgmt.servicefabric.aio.operations.NodeTypesOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The customer subscription identifier.
    :type subscription_id: str
    :param str base_url: Service URL
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = ServiceFabricManagementClientConfiguration(credential, subscription_id, **kwargs)
        self._client = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._serialize.client_side_validation = False
        self._deserialize = Deserializer(client_models)

        self.clusters = ClustersOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.cluster_versions = ClusterVersionsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.operations = Operations(
            self._client, self._config, self._serialize, self._deserialize)
        self.application = ApplicationOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.application_types = ApplicationTypesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.application_type_versions = ApplicationTypeVersionsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.applications = ApplicationsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.services = ServicesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.managed_clusters = ManagedClustersOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.managedcluster = ManagedclusterOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.managed_cluster_versions = ManagedClusterVersionsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.nodetype = NodetypeOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.node_types = NodeTypesOperations(
            self._client, self._config, self._serialize, self._deserialize)

    async def _send_request(self, http_request: HttpRequest, **kwargs: Any) -> AsyncHttpResponse:
        """Runs the network request through the client's chained policies.

        :param http_request: The network request you want to make. Required.
        :type http_request: ~azure.core.pipeline.transport.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to True.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.pipeline.transport.AsyncHttpResponse
        """
        path_format_arguments = {
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str'),
        }
        http_request.url = self._client.format_url(http_request.url, **path_format_arguments)
        stream = kwargs.pop("stream", True)
        pipeline_response = await self._client._pipeline.run(http_request, stream=stream, **kwargs)
        return pipeline_response.http_response

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "ServiceFabricManagementClient":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details) -> None:
        await self._client.__aexit__(*exc_details)
