# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/39_Legionella_parser.ipynb.

# %% auto 0
__all__ = ['extract_legionella_sbt', 'legionella_summary', 'legionella_parser']

# %% ../nbs/39_Legionella_parser.ipynb 3
# standard libs
import os
import re

# Common to template
# add into settings.ini, requirements, package name is python-dotenv, for conda build ensure `conda config --add channels conda-forge`
import dotenv  # for loading config from .env files, https://pypi.org/project/python-dotenv/
import envyaml  # Allows to loads env vars into a yaml file, https://github.com/thesimj/envyaml
import fastcore  # To add functionality related to nbdev development, https://github.com/fastai/fastcore/
from fastcore import (
    test,
)
from fastcore.script import (
    call_parse,
)  # for @call_parse, https://fastcore.fast.ai/script
import json  # for nicely printing json and yaml

# import functions from core module (optional, but most likely needed).
from ssi_analysis_result_parsers import (
    core,
)
from .blast_parser import extract_presence_absence

# Project specific libraries
from pathlib import Path
import pandas
import sys

# %% ../nbs/39_Legionella_parser.ipynb 6
def extract_legionella_sbt(legionella_sbt_results_tsv: Path) -> dict:
    """
    Returns dictionary of results found in the Legionella SBT summary output
    """
    if os.path.exists(legionella_sbt_results_tsv):
        df = pandas.read_csv(legionella_sbt_results_tsv, sep="\t")
        df.set_index("sample", inplace=True, drop=True)
        d = df.to_dict(orient="index")
        fname = next(iter(d))
        return d[fname]
    else:
        print(
            f"No Legionella SBT output found at {legionella_sbt_results_tsv}",
            file=sys.stderr,
        )
        return None


def legionella_summary(legionella_sbt_results_tsv: Path, lag1_blast_tsv: Path) -> dict:
    sbt_results_dict = extract_legionella_sbt(
        legionella_sbt_results_tsv=legionella_sbt_results_tsv
    )
    lag1_blast_dict = extract_presence_absence(
        blast_output_tsv=lag1_blast_tsv,
        hits_as_string=False,
        include_match_stats=False,
        gene_names=["lag-1"],
    )
    results_dict = core.update_results_dict(
        sbt_results_dict, lag1_blast_dict, old_duplicate_key_prefix="SBT: "
    )
    return results_dict

# %% ../nbs/39_Legionella_parser.ipynb 9
@call_parse
def legionella_parser(
    legionella_sbt_file: Path = None,  # Path "*.sbt.tsv from legionella_sbt program"
    lag_1_blast_output: Path = None,  #  Path to output from lag1_blast. Generated with blastn -query lag-1.fasta -subject assembly.fasta -outfmt "6 qseqid sseqid pident length qlen qstart qend sstart send sseq evalue bitscore"
    output_file: Path = None,  # Path to output tsv
    sample_name: str = None,
    config_file: str = None,  # config file to set env vars from
) -> None:
    """ """
    # config = core.get_config(config_file)  # Set env vars and get config variables
    legionella_summary_dict = legionella_summary(
        legionella_sbt_results_tsv=legionella_sbt_file,
        lag1_blast_tsv=lag_1_blast_output,
    )
    core.print_results_dict_to_tsv(
        results_dict=legionella_summary_dict,
        output_file=output_file,
        sample_name=sample_name,
    )
