# coding: utf-8

"""
    Lilt REST API

    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests. ## Authentication Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.   # noqa: E501

    The version of the OpenAPI document: v2.0
    Contact: support@lilt.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from lilt.configuration import Configuration


class MemoryInsertResponse(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'num_updates': 'int'
    }

    attribute_map = {
        'id': 'id',
        'num_updates': 'num_updates'
    }

    def __init__(self, id=None, num_updates=None, local_vars_configuration=None):  # noqa: E501
        """MemoryInsertResponse - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._num_updates = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if num_updates is not None:
            self.num_updates = num_updates

    @property
    def id(self):
        """Gets the id of this MemoryInsertResponse.  # noqa: E501

        A unique Memory identifier.  # noqa: E501

        :return: The id of this MemoryInsertResponse.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this MemoryInsertResponse.

        A unique Memory identifier.  # noqa: E501

        :param id: The id of this MemoryInsertResponse.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def num_updates(self):
        """Gets the num_updates of this MemoryInsertResponse.  # noqa: E501

        The number of updates to the Memory.  # noqa: E501

        :return: The num_updates of this MemoryInsertResponse.  # noqa: E501
        :rtype: int
        """
        return self._num_updates

    @num_updates.setter
    def num_updates(self, num_updates):
        """Sets the num_updates of this MemoryInsertResponse.

        The number of updates to the Memory.  # noqa: E501

        :param num_updates: The num_updates of this MemoryInsertResponse.  # noqa: E501
        :type: int
        """

        self._num_updates = num_updates

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MemoryInsertResponse):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MemoryInsertResponse):
            return True

        return self.to_dict() != other.to_dict()
