# coding: utf-8

"""
    Lilt REST API

    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests. ## Authentication Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.   # noqa: E501

    The version of the OpenAPI document: v2.0
    Contact: support@lilt.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from lilt.configuration import Configuration


class JobCreateParameters(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'src_lang': 'str',
        'src_locale': 'str',
        'due': 'str',
        'language_pairs': 'list[LanguagePair]',
        'file_ids': 'list[int]'
    }

    attribute_map = {
        'name': 'name',
        'src_lang': 'srcLang',
        'src_locale': 'srcLocale',
        'due': 'due',
        'language_pairs': 'languagePairs',
        'file_ids': 'fileIds'
    }

    def __init__(self, name=None, src_lang=None, src_locale=None, due=None, language_pairs=None, file_ids=None, local_vars_configuration=None):  # noqa: E501
        """JobCreateParameters - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._src_lang = None
        self._src_locale = None
        self._due = None
        self._language_pairs = None
        self._file_ids = None
        self.discriminator = None

        self.name = name
        self.src_lang = src_lang
        if src_locale is not None:
            self.src_locale = src_locale
        if due is not None:
            self.due = due
        self.language_pairs = language_pairs
        self.file_ids = file_ids

    @property
    def name(self):
        """Gets the name of this JobCreateParameters.  # noqa: E501

        A name for the Job.  # noqa: E501

        :return: The name of this JobCreateParameters.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this JobCreateParameters.

        A name for the Job.  # noqa: E501

        :param name: The name of this JobCreateParameters.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def src_lang(self):
        """Gets the src_lang of this JobCreateParameters.  # noqa: E501

        The source language for the job.  # noqa: E501

        :return: The src_lang of this JobCreateParameters.  # noqa: E501
        :rtype: str
        """
        return self._src_lang

    @src_lang.setter
    def src_lang(self, src_lang):
        """Sets the src_lang of this JobCreateParameters.

        The source language for the job.  # noqa: E501

        :param src_lang: The src_lang of this JobCreateParameters.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and src_lang is None:  # noqa: E501
            raise ValueError("Invalid value for `src_lang`, must not be `None`")  # noqa: E501

        self._src_lang = src_lang

    @property
    def src_locale(self):
        """Gets the src_locale of this JobCreateParameters.  # noqa: E501

        The source locale for the job.  # noqa: E501

        :return: The src_locale of this JobCreateParameters.  # noqa: E501
        :rtype: str
        """
        return self._src_locale

    @src_locale.setter
    def src_locale(self, src_locale):
        """Sets the src_locale of this JobCreateParameters.

        The source locale for the job.  # noqa: E501

        :param src_locale: The src_locale of this JobCreateParameters.  # noqa: E501
        :type: str
        """

        self._src_locale = src_locale

    @property
    def due(self):
        """Gets the due of this JobCreateParameters.  # noqa: E501

        An ISO string date.  # noqa: E501

        :return: The due of this JobCreateParameters.  # noqa: E501
        :rtype: str
        """
        return self._due

    @due.setter
    def due(self, due):
        """Sets the due of this JobCreateParameters.

        An ISO string date.  # noqa: E501

        :param due: The due of this JobCreateParameters.  # noqa: E501
        :type: str
        """

        self._due = due

    @property
    def language_pairs(self):
        """Gets the language_pairs of this JobCreateParameters.  # noqa: E501

        Language pairs is a set of one or more pairs that includes source language, source locale(optional), target language, target locale(optional), and memoryId.  # noqa: E501

        :return: The language_pairs of this JobCreateParameters.  # noqa: E501
        :rtype: list[LanguagePair]
        """
        return self._language_pairs

    @language_pairs.setter
    def language_pairs(self, language_pairs):
        """Sets the language_pairs of this JobCreateParameters.

        Language pairs is a set of one or more pairs that includes source language, source locale(optional), target language, target locale(optional), and memoryId.  # noqa: E501

        :param language_pairs: The language_pairs of this JobCreateParameters.  # noqa: E501
        :type: list[LanguagePair]
        """
        if self.local_vars_configuration.client_side_validation and language_pairs is None:  # noqa: E501
            raise ValueError("Invalid value for `language_pairs`, must not be `None`")  # noqa: E501

        self._language_pairs = language_pairs

    @property
    def file_ids(self):
        """Gets the file_ids of this JobCreateParameters.  # noqa: E501

        A list of file ids to upload to job creation.  # noqa: E501

        :return: The file_ids of this JobCreateParameters.  # noqa: E501
        :rtype: list[int]
        """
        return self._file_ids

    @file_ids.setter
    def file_ids(self, file_ids):
        """Sets the file_ids of this JobCreateParameters.

        A list of file ids to upload to job creation.  # noqa: E501

        :param file_ids: The file_ids of this JobCreateParameters.  # noqa: E501
        :type: list[int]
        """
        if self.local_vars_configuration.client_side_validation and file_ids is None:  # noqa: E501
            raise ValueError("Invalid value for `file_ids`, must not be `None`")  # noqa: E501

        self._file_ids = file_ids

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, JobCreateParameters):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, JobCreateParameters):
            return True

        return self.to_dict() != other.to_dict()
