/* Modified by Ian Hunt-Isaak 2021-10-13 */

/* This program is Copyright © 2011-2013 Charo I. Del Genio */

/* Licensed under the Academic Free License version 3.0

1) Grant of Copyright License. Licensor grants You a worldwide, royalty-free,
   non-exclusive, sublicensable license, for the duration of the copyright,
   to do the following:
    a) to reproduce the Original Work in copies, either alone or as part
       of a collective work;
    b) to translate, adapt, alter, transform, modify, or arrange the Original
       Work, thereby creating derivative works ("Derivative Works") based
       upon the Original Work;
    c) to distribute or communicate copies of the Original Work and
       Derivative Works to the public, under any license of your choice that
       does not contradict the terms and conditions, including Licensor's
       reserved rights and remedies, in this Academic Free License;
    d) to perform the Original Work publicly; and
    e) to display the Original Work publicly.

2) Grant of Patent License. Licensor grants You a worldwide, royalty-free,
   non-exclusive, sublicensable license, under patent claims owned or
   controlled by the Licensor that are embodied in the Original Work as
   furnished by the Licensor, for the duration of the patents, to make, use,
   sell, offer for sale, have made, and import the Original Work and
   Derivative Works.

3) Grant of Source Code License. The term "Source Code" means the preferred
   form of the Original Work for making modifications to it and all available
   documentation describing how to modify
   the Original Work. Licensor agrees to provide a machine-readable copy of
   the Source Code of the Original Work along with each copy of the Original
   Work that Licensor distributes. Licensor reserves the right to satisfy
   this obligation by placing a machine-readable copy of the Source Code in
   an information repository reasonably calculated to permit inexpensive
   and convenient access by You for as long as Licensor continues to
   distribute the Original Work.

4) Exclusions From License Grant. Neither the names of Licensor, nor the names
   of any contributors to the Original Work, nor any of their trademarks or
   service marks, may be used to endorse or promote products derived from this
   Original Work without express prior permission of the Licensor. Except as
   expressly stated herein, nothing in this License grants any license to
   Licensor's trademarks, copyrights, patents, trade secrets or any other
   intellectual property. No patent license is granted to make, use, sell,
   offer for sale, have made, or import embodiments of any patent claims other
   than the licensed claims defined in Section 2. No license is granted to the
   trademarks of Licensor even if such marks are included in the Original Work.
   Nothing in this License shall be interpreted to prohibit Licensor from
   licensing under terms different from this License any Original Work that
   Licensor otherwise would have a right to license.

5) External Deployment. The term "External Deployment" means the use,
   distribution, or communication of the Original Work or Derivative Works in
   any way such that the Original Work or Derivative Works may be used by
   anyone other than You, whether those works are distributed or communicated
   to those persons or made available as an application intended for use over
   a network. As an express condition for the grants of license hereunder, You
   must treat any External Deployment by You of the Original Work or a
   Derivative Work as a distribution under section 1(c).

6) Attribution Rights. You must retain, in the Source Code of any Derivative
   Works that You create, all copyright, patent, or trademark notices from the
   Source Code of the Original Work, as well as any notices of licensing and
   any descriptive text identified therein as an "Attribution Notice." You
   must cause the Source Code for any Derivative Works that You create to
   carry a prominent Attribution Notice reasonably calculated to inform
   recipients that You have modified the Original Work.

7) Warranty of Provenance and Disclaimer of Warranty. Licensor warrants that
   the copyright in and to the Original Work and the patent rights granted
   herein by Licensor are owned by the Licensor or are sublicensed to You
   under the terms of this License with the permission of the contributor(s)
   of those copyrights and patent rights. Except as expressly stated in the
   immediately preceding sentence, the Original Work is provided under this
   License on an "AS IS" BASIS and WITHOUT WARRANTY, either express or
   implied, including, without limitation, the warranties of non-infringement,
   merchantability or fitness for a particular purpose. THE ENTIRE RISK AS TO
   THE QUALITY OF THE ORIGINAL WORK IS WITH YOU. This DISCLAIMER OF WARRANTY
   constitutes an essential part of this License. No license to the Original
   Work is granted by this License except under this disclaimer.

8) Limitation of Liability. Under no circumstances and under no legal theory,
   whether in tort (including negligence), contract, or otherwise, shall the
   Licensor be liable to anyone for any indirect, special, incidental, or
   consequential damages of any character arising as a result of this License
   or the use of the Original Work including, without limitation, damages for
   loss of goodwill, work stoppage, computer failure or malfunction, or any and
   all other commercial damages or losses. This limitation of liability shall
   not apply to the extent applicable law prohibits such limitation.

9) Acceptance and Termination. If, at any time, You expressly assented to this
   License, that assent indicates your clear and irrevocable acceptance of this
   License and all of its terms and conditions. If You distribute or
   communicate copies of the Original Work or a Derivative Work, You must make
   a reasonable effort under the circumstances to obtain the express assent of
   recipients to the terms of this License. This License conditions your rights
   to undertake the activities listed in Section 1, including your right to
   create Derivative Works based upon the Original Work, and doing so without
   honoring these terms and conditions is prohibited by copyright law and
   international treaty. Nothing in this License is intended to affect
   copyright exceptions and limitations (including "fair use" or "fair
   dealing"). This License shall terminate immediately and You may no longer
   exercise any of the rights granted to You by this License upon your failure
   to honor the conditions in Section 1(c).

10) Termination for Patent Action. This License shall terminate automatically
    and You may no longer exercise any of the rights granted to You by this
    License as of the date You commence an action, including a cross-claim or
    counterclaim, against Licensor or any licensee alleging that the Original
    Work infringes a patent. This termination provision shall not apply for an
    action alleging patent infringement by combinations of the Original Work
    with other software or hardware.

11) Jurisdiction, Venue and Governing Law. Any action or suit relating to this
    License may be brought only in the courts of a jurisdiction wherein the
    Licensor resides or in which Licensor conducts its primary business, and
    under the laws of that jurisdiction excluding its conflict-of-law
    provisions. The application of the United Nations Convention on Contracts
    for the International Sale of Goods is expressly excluded. Any use of the
    Original Work outside the scope of this License or after its termination
    shall be subject to the requirements and penalties of copyright or patent
    law in the appropriate jurisdiction. This section shall survive the
    termination of this License.

12) Attorneys' Fees. In any action to enforce the terms of this License or
    seeking damages relating thereto, the prevailing party shall be entitled to
    recover its costs and expenses, including, without limitation, reasonable
    attorneys' fees and costs incurred in connection with such action,
    including any appeal of such action. This section shall survive the
    termination of this License.

13) Miscellaneous. If any provision of this License is held to be
    unenforceable, such provision shall be reformed only to the extent
    necessary to make it enforceable.

14) Definition of "You" in This License. "You" throughout this License, whether
    in upper or lower case, means an individual or a legal entity exercising
    rights under, and complying with all of the terms of, this License. For
    legal entities, "You" includes any entity that controls, is controlled by,
    or is under common control with you. For purposes of this definition,
    "control" means (i) the power, direct or indirect, to cause the direction
    or management of such entity, whether by contract or otherwise, or (ii)
    ownership of fifty percent (50%) or more of the outstanding shares, or
    (iii) beneficial ownership of such entity.

15) Right to Use. You may use the Original Work in all ways not otherwise
    restricted or conditioned by this License or by law, and Licensor promises
    not to interfere with or be responsible for such uses by You.

16) Modification of This License. This License is Copyright © 2005 Lawrence
    Rosen. Permission is granted to copy, distribute, or communicate this
    License without modification. Nothing in this License permits You to modify
    this License as applied to the Original Work or to Derivative Works.
    However, You may modify the text of this License and copy, distribute or
    communicate your modified version (the "Modified License") and apply it to
    other original works of authorship subject to the following conditions: (i)
    You may not indicate in any way that your Modified License is the "Academic
    Free License" or "AFL" and you may not use those names in the name of your
    Modified License; (ii) You must replace the notice specified in the first
    paragraph above with the notice "Licensed under <insert your license name
    here>" or with a notice of your own that is not confusingly similar to the
    notice in this License; and (iii) You may not claim that your original
    works are open source software unless your Modified License has been
    approved by Open Source Initiative (OSI) and You comply with its license
    review and certification process.
*/

#include"DiGSampler.h"
#include"stdlib.h"
#include"stdio.h"


/* Graph sampler initializer */
void digsaminit(int **seq, const int n)
{
	int i, j;
	unsigned long int outstubs = 0;
	
	/* Memory allocations */
	orig.indegree    = calloc(n,sizeof(int));						// Original sequence in-degree
	orig.outdegree   = calloc(n,sizeof(int));						// Original sequence out-degree
	orig.label       = calloc(n,sizeof(int));						// Original node labels
	orig.forbidden   = calloc(n,sizeof(int));						// Original forbidden status labels
	indseq.indegree  = calloc(n,sizeof(int));						// Work sequence in-degree
	indseq.outdegree = calloc(n,sizeof(int));						// Work sequence out-degree
	indseq.label     = calloc(n,sizeof(int));						// Work sequence labels
	indseq.forbidden = calloc(n,sizeof(int));						// Work sequence forbidden status labels
	newbds.indegree  = calloc(n,sizeof(int));						// Derivative bi-degree sequence
	newbds.outdegree = calloc(n,sizeof(int));
	newbds.label     = calloc(n,sizeof(int));
	newbds.forbidden = calloc(n,sizeof(int));
	auxbds.indegree  = calloc(n,sizeof(int));						// Auxiliary bi-degree sequence
	auxbds.outdegree = calloc(n,sizeof(int));
	auxbds.label     = calloc(n,sizeof(int));
	auxbds.forbidden = calloc(n,sizeof(int));
	allowed          = calloc(n,sizeof(int));						// Allowed nodes
	G                = calloc(n+1,sizeof(int));
	S                = calloc(n+1,sizeof(int));
	
	/* Initializations of sequences */
	for (i=0; i<n; i++) {
		orig.indegree[i]  = seq[i][0];
		orig.outdegree[i] = seq[i][1];
		orig.label[i]     = i;
		orig.forbidden[i] = 0;
		outstubs         += seq[i][1];
	}
	
	/* Initialization of sample */
	sample.list    = malloc(n*sizeof(int*));						// Adjacency list
	sample.list[0] = calloc(outstubs,sizeof(int));
	for (j=0; j<orig.outdegree[0]; j++) sample.list[0][j] = -1;
	for (i=1; i<n; i++) {
		sample.list[i] = sample.list[i-1]+orig.outdegree[i-1];
		for (j=0; j<orig.outdegree[i]; j++) sample.list[i][j] = -1;
	}
	
	len = n;
	
	return;
}




/* Digraph sampler cleanup */
void digsamclean(void)
{
	
	free(orig.indegree);
	free(orig.outdegree);
	free(orig.label);
	free(orig.forbidden);
	free(indseq.indegree);
	free(indseq.outdegree);
	free(indseq.label);
	free(indseq.forbidden);
	free(allowed);
	free(newbds.indegree);
	free(newbds.outdegree);
	free(newbds.label);
	free(newbds.forbidden);
	free(auxbds.indegree);
	free(auxbds.outdegree);
	free(auxbds.label);
	free(auxbds.forbidden);
	free(G);
	free(S);
	free(sample.list[0]);
	free(sample.list);
	
	return;
}



/* Digraph sampler */
digraph digsam(double (*rng)(void), const int stfl)
{
	int i;
	
	for (i=0; i<len; i++) {
		indseq.indegree[i] = orig.indegree[i];
		indseq.outdegree[i] = orig.outdegree[i];
		indseq.label[i] = i;
		indseq.forbidden[i] = 0;
	}
	sample.weight=0.0;								// Sample weight
	
	dirbuild(rng,stfl);								// Build the digraph
	
	return sample;//.list;
}



/* Recursively places all the possible links in the graph */
static void dirbuild(double (*rng)(void), const int stfl)
{
	int work, target, alll, i;
	unsigned long int ext, count, restubs;
	
	work = 0;																													// Find the first work node
	while (!indseq.outdegree[work] && work<len) work++;
	
	while (work<len) {																											// If there are still nodes with out-stubs
		indseq.forbidden[work] = 1;																								// Mark the work node as forbidden
		while (indseq.outdegree[work]) {																						// If the work node still has out-stubs
			alll=0;																												// Reset the size of the allowed nodes set
			restubs=0;																											// Reset the count of the stubs in the allowed set
			dirallow(&work,&alll,&restubs);																						// Build the set of allowed nodes
			if (stfl) {																											// If we choose proportionally to the residual in-degree
				i = -1;																											// then reset the selector,
				ext = restubs*rng();																							// extract an in-stub,
				count = 0;																										// reset the counter,
				do {
					i++;
					count += indseq.indegree[allowed[i]];																		// and count the in-stubs
				} while (count<=ext);																							// until the correct in-stub is found,
				target = allowed[i];																							// then identify the target node
				sample.weight += log(restubs) - log(indseq.indegree[target]);													// and update the sample weight accordingly.
			} else {																											// If instead we are choosing uniformly on the allowed nodes,
				sample.weight += log(alll);																						// update the weight accordingly,
				target = *(allowed+((int) (alll*rng())));																		// and extract a random allowed node.
			}
			sample.list[indseq.label[work]][orig.outdegree[indseq.label[work]]-indseq.outdegree[work]] = indseq.label[target];	// Connect the work node to the target
			indseq.outdegree[work]--;																							// Reduce the outdegree of the work node
			indseq.indegree[target]--;																	 						// Reduce the indegree of the target node
			lexisort(&work,target);																								// Reorder the sequence if needed.
		}
		for (i=0; i<len; i++) indseq.forbidden[i] = 0;																			// Reset the forbidden flags
		work = 0;																												// Find the new work node
		while (!indseq.outdegree[work] && work<len) work++;
	}
	
	return;
}



/* Builds the set of the nodes which we are allowed to connect to */
static void dirallow(int *work, int *alll, unsigned long int *restubs)
{
	int index=0, count=0, curdeg=-1, firstdeg, dumdeg, check, degchk, ind2, oripos, moven=0, tarpos, t, wlab, nw, wstin, wstfb;
	long int lhs, rhs, gtilde;
	
	/* Start making a copy of the sequence.
	   Add the leftmost adjacency set to the allowed node set.
	   Also decrease the in-degrees of the nodes in the copy sequence
	   which are added to the set and make them forbidden */
	wlab = indseq.label[*work];
	while (count<indseq.outdegree[*work] && index<len) {
		newbds.indegree[index]  = indseq.indegree[index];
		newbds.outdegree[index] = indseq.outdegree[index];
		newbds.label[index]     = indseq.label[index];
		newbds.forbidden[index] = 1;
		if (!indseq.forbidden[index] && indseq.indegree[index]) {
			newbds.indegree[index]--;
			(*alll)++;
			*(allowed+(*alll)-1) = index;
			(*restubs) += indseq.indegree[index];
			count++;
			if (curdeg!=newbds.indegree[index]) {
				curdeg = newbds.indegree[index];
				firstdeg = index;
			}
		} else {
			if (index) {
				if (newbds.indegree[index]>newbds.indegree[index-1]) {
					dumdeg = newbds.indegree[firstdeg];
					newbds.indegree[firstdeg] = newbds.indegree[index];
					newbds.indegree[index] = dumdeg;
					dumdeg = newbds.outdegree[firstdeg];
					newbds.outdegree[firstdeg] = newbds.outdegree[index];
					newbds.outdegree[index] = dumdeg;
					dumdeg = newbds.label[firstdeg];
					newbds.label[firstdeg] = newbds.label[index];
					newbds.label[index] = dumdeg;
					firstdeg++;
				}
			} else {
				firstdeg = 0;
				curdeg = newbds.indegree[0];
			}
		}
		index++;
	}
	
	/* In the copy sequence, revert the in-degree of the last node added to the set. */
	check = (*(allowed+(*alll)-1));
	newbds.indegree[check]++;
	if (check) degchk = newbds.indegree[check-1];
	else degchk = -1;
	oripos = check;
	
	if (index<len) {																			// If there are more nodes left
		for (ind2=index; ind2<len; ind2++) {													// Finish copying the sequence
			newbds.indegree[ind2]  = indseq.indegree[ind2];
			newbds.outdegree[ind2] = indseq.outdegree[ind2];
			newbds.label[ind2]     = indseq.label[ind2];
			newbds.forbidden[ind2] = indseq.forbidden[ind2];
		}
		
		nw = 0;
		while (newbds.label[nw]!=wlab) nw++;
		if (nw>=oripos) {
			wstin = newbds.indegree[nw];
			wstfb = newbds.forbidden[nw];
			while (nw<len-1 && newbds.indegree[nw+1]==wstin && newbds.outdegree[nw+1]) {
				newbds.indegree[nw]  = newbds.indegree[nw+1];
				newbds.outdegree[nw] = newbds.outdegree[nw+1];
				newbds.label[nw]     = newbds.label[nw+1];
				newbds.forbidden[nw] = newbds.forbidden[nw+1];
				nw++;
			}
		}
		newbds.label[nw] = wlab;
		newbds.forbidden[nw] = wstfb;
		newbds.outdegree[nw] = 1;																// Set to 1 the out-degree of the work node
		
		/* If needed, quickly reorder the sequence */
		if (degchk!=-1) {
			while (check<len && degchk<newbds.indegree[check]) {
				auxbds.indegree[moven]  = newbds.indegree[check];
				auxbds.outdegree[moven] = newbds.outdegree[check];
				auxbds.label[moven]     = newbds.label[check];
				auxbds.forbidden[moven] = newbds.forbidden[check];
				moven++;
				check++;
			}
			if (moven>0) {
				degchk = newbds.indegree[oripos];
				tarpos = oripos-1;
				while (tarpos>=0 && degchk>newbds.indegree[tarpos]) tarpos--;
				tarpos++;
				for (t=oripos-1; t>=tarpos; t--) {
					newbds.indegree[t+moven]  = newbds.indegree[t];
					newbds.outdegree[t+moven] = newbds.outdegree[t];
					newbds.label[t+moven]     = newbds.label[t];
					newbds.forbidden[t+moven] = newbds.forbidden[t];
				}
				for (t=0; t<moven; t++) {
					newbds.indegree[tarpos+t]  = auxbds.indegree[t];
					newbds.outdegree[tarpos+t] = auxbds.outdegree[t];
					newbds.label[tarpos+t]     = auxbds.label[t];
					newbds.forbidden[tarpos+t] = auxbds.forbidden[t];
				}
			}
		}
		
		/* Build G and S for our digraphicality test */
		for (t=0; t<=len; t++) S[t] = G[t] = 0;
		G[newbds.outdegree[0]+1] = 1;
		for (t=1; t<len; t++) {
			G[newbds.outdegree[t]]++;
			if (newbds.outdegree[t] >= t+1)  S[newbds.outdegree[t]]--;
			if (newbds.outdegree[t]+1 > t+1) S[newbds.outdegree[t]+1]++;
		}
		
		/* Find the last good node */
		lhs = newbds.indegree[0];
		rhs = len-1-G[0];
		gtilde = G[0]+G[1];
		t = 1;
		if (nw==0) {
			t++;
			lhs += newbds.indegree[t-1];
			rhs += len-gtilde;
			if (newbds.outdegree[t-1]>=t) rhs--;
			gtilde += G[t]+S[t];
		}
		
		while (t<len && lhs!=rhs) {
			t++;
			lhs += newbds.indegree[t-1];
			rhs += len-gtilde;
			if (newbds.outdegree[t-1]>=t) rhs--;
			gtilde += G[t]+S[t];
		}
		
		if (lhs!=rhs) t = -1;		// No fail node
		else if (t==len) t = -1;
		else {
			while (t<len && newbds.forbidden[t]) t++;
			if (t==len) t = -1;
		}
		if (t!=-1) t = newbds.label[t];
		
		/* Add to the allowed set all the non-forbidden nodes
		   to the left of the fail node */
		index = oripos+1;
		while (index<len && indseq.label[index]!=t) {
			if ( !indseq.forbidden[index] && indseq.indegree[index]) {
				(*alll)++;
				*(allowed+(*alll)-1) = index;
				(*restubs) += indseq.indegree[index];
			}
			index++;
		}
	}
	
	return;
}

