# AUTOGENERATED! DO NOT EDIT! File to edit: 03_streamlit.ipynb (unless otherwise specified).

__all__ = ['uploaded_file']

# Cell
#from core import *
#from blurry.core import *
import blurry.core as bl
import streamlit as st
import numpy as np
from PIL import Image

# Cell
st.title("Blurry");
st.write("Upload any photo with people in it, and this tool will pixelate the faces.")
uploaded_file = st.file_uploader("Upload a photo:", type=['png', 'jpg', 'jpeg'], accept_multiple_files=False)

# Cell
if uploaded_file is not None:
    st.write("File uploaded, processing...")
    img = Image.open(uploaded_file)
    img_array = np.array(img)
    anon_img = bl.anonymize(img_array, mode='pixelate')
    st.image(anon_img, caption=" ", use_column_width=True)