"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.addCdkConstructVersionTag = exports.Datadog = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const loglevel_1 = require("loglevel");
const transport_1 = require("./common/transport");
const index_1 = require("./index");
const versionJson = require("../version.json");
/**
 * @stability stable
 */
class Datadog extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        if (((_b = process.env.DD_CONSTRUCT_DEBUG_LOGS) === null || _b === void 0 ? void 0 : _b.toLowerCase()) == "true") {
            loglevel_1.default.setLevel("debug");
        }
        super(scope, id);
        this.scope = scope;
        this.props = props;
        index_1.validateProps(this.props);
        this.transport = new transport_1.Transport(this.props.flushMetricsToLogs, this.props.site, this.props.apiKey, this.props.apiKeySecretArn, this.props.apiKmsKey, this.props.extensionLayerVersion);
    }
    /**
     * @stability stable
     */
    addLambdaFunctions(lambdaFunctions) {
        const baseProps = index_1.handleSettingPropDefaults(this.props);
        if (this.props !== undefined && lambdaFunctions.length > 0) {
            const region = `${lambdaFunctions[0].env.region}`;
            loglevel_1.default.debug(`Using region: ${region}`);
            index_1.applyLayers(this.scope, region, lambdaFunctions, this.props.pythonLayerVersion, this.props.nodeLayerVersion, this.props.extensionLayerVersion);
            index_1.redirectHandlers(lambdaFunctions, baseProps.addLayers);
            if (this.props.forwarderArn !== undefined) {
                if (this.props.extensionLayerVersion !== undefined) {
                    loglevel_1.default.debug(`Skipping adding subscriptions to the lambda log groups since the extension is enabled`);
                }
                else {
                    loglevel_1.default.debug(`Adding log subscriptions using provided Forwarder ARN: ${this.props.forwarderArn}`);
                    index_1.addForwarder(this.scope, lambdaFunctions, this.props.forwarderArn);
                }
            }
            else {
                loglevel_1.default.debug("Forwarder ARN not provided, no log group subscriptions will be added");
            }
            addCdkConstructVersionTag(lambdaFunctions);
            index_1.applyEnvVariables(lambdaFunctions, baseProps);
            index_1.setDDEnvVariables(lambdaFunctions, this.props);
            setTags(lambdaFunctions, this.props);
            this.transport.applyEnvVars(lambdaFunctions);
        }
    }
    /**
     * @stability stable
     */
    addGitCommitMetadata(lambdaFunctions, gitCommitSha) {
        index_1.setGitCommitHashEnvironmentVariable(lambdaFunctions, gitCommitSha);
    }
    /**
     * @stability stable
     */
    addForwarderToNonLambdaLogGroups(logGroups) {
        if (this.props.forwarderArn !== undefined) {
            index_1.addForwarderToLogGroups(this.scope, logGroups, this.props.forwarderArn);
        }
        else {
            loglevel_1.default.debug("Forwarder ARN not provided, no non lambda log group subscriptions will be added");
        }
    }
}
exports.Datadog = Datadog;
_a = JSII_RTTI_SYMBOL_1;
Datadog[_a] = { fqn: "datadog-cdk-constructs.Datadog", version: "0.8.1" };
function addCdkConstructVersionTag(lambdaFunctions) {
    loglevel_1.default.debug(`Adding CDK Construct version tag: ${versionJson.version}`);
    lambdaFunctions.forEach((functionName) => {
        cdk.Tags.of(functionName).add(index_1.TagKeys.CDK, `v${versionJson.version}`, {
            includeResourceTypes: ["AWS::Lambda::Function"],
        });
    });
}
exports.addCdkConstructVersionTag = addCdkConstructVersionTag;
function setTags(lambdaFunctions, props) {
    loglevel_1.default.debug(`Adding datadog tags`);
    lambdaFunctions.forEach((functionName) => {
        if (props.forwarderArn) {
            if (props.env) {
                cdk.Tags.of(functionName).add(index_1.TagKeys.ENV, props.env);
            }
            if (props.service) {
                cdk.Tags.of(functionName).add(index_1.TagKeys.SERVICE, props.service);
            }
            if (props.version) {
                cdk.Tags.of(functionName).add(index_1.TagKeys.VERSION, props.version);
            }
            if (props.tags) {
                const tagsArray = props.tags.split(",");
                tagsArray.forEach((tag) => {
                    const [key, value] = tag.split(":");
                    if (key && value) {
                        cdk.Tags.of(functionName).add(key, value);
                    }
                });
            }
        }
    });
}
//# sourceMappingURL=data:application/json;base64,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