"use strict";
/*
 * Unless explicitly stated otherwise all files in this repository are licensed
 * under the Apache License Version 2.0.
 *
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2021 Datadog, Inc.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.setDDEnvVariables = exports.applyEnvVariables = exports.setGitCommitHashEnvironmentVariable = exports.DD_TAGS = exports.DD_VERSION_ENV_VAR = exports.DD_SERVICE_ENV_VAR = exports.DD_ENV_ENV_VAR = exports.CAPTURE_LAMBDA_PAYLOAD_ENV_VAR = exports.ENABLE_DD_LOGS_ENV_VAR = exports.LOG_LEVEL_ENV_VAR = exports.INJECT_LOG_CONTEXT_ENV_VAR = exports.ENABLE_DD_TRACING_ENV_VAR = void 0;
const loglevel_1 = require("loglevel");
exports.ENABLE_DD_TRACING_ENV_VAR = "DD_TRACE_ENABLED";
exports.INJECT_LOG_CONTEXT_ENV_VAR = "DD_LOGS_INJECTION";
exports.LOG_LEVEL_ENV_VAR = "DD_LOG_LEVEL";
exports.ENABLE_DD_LOGS_ENV_VAR = "DD_SERVERLESS_LOGS_ENABLED";
exports.CAPTURE_LAMBDA_PAYLOAD_ENV_VAR = "DD_CAPTURE_LAMBDA_PAYLOAD";
exports.DD_ENV_ENV_VAR = "DD_ENV";
exports.DD_SERVICE_ENV_VAR = "DD_SERVICE";
exports.DD_VERSION_ENV_VAR = "DD_VERSION";
exports.DD_TAGS = "DD_TAGS";
function setGitCommitHashEnvironmentVariable(lambdas, hash) {
    // We're using an any type here because AWS does not expose the `environment` field in their type
    lambdas.forEach((lambda) => {
        if (lambda.environment[exports.DD_TAGS] !== undefined) {
            lambda.environment[exports.DD_TAGS].value += `,git.commit.sha:${hash}`;
        }
        else {
            lambda.addEnvironment(exports.DD_TAGS, `git.commit.sha:${hash}`);
        }
    });
}
exports.setGitCommitHashEnvironmentVariable = setGitCommitHashEnvironmentVariable;
function applyEnvVariables(lambdas, baseProps) {
    loglevel_1.default.debug(`Setting environment variables...`);
    lambdas.forEach((lam) => {
        lam.addEnvironment(exports.ENABLE_DD_TRACING_ENV_VAR, baseProps.enableDatadogTracing.toString().toLowerCase());
        lam.addEnvironment(exports.INJECT_LOG_CONTEXT_ENV_VAR, baseProps.injectLogContext.toString().toLowerCase());
        lam.addEnvironment(exports.ENABLE_DD_LOGS_ENV_VAR, baseProps.enableDatadogLogs.toString().toLowerCase());
        lam.addEnvironment(exports.CAPTURE_LAMBDA_PAYLOAD_ENV_VAR, baseProps.captureLambdaPayload.toString().toLowerCase());
        if (baseProps.logLevel) {
            lam.addEnvironment(exports.LOG_LEVEL_ENV_VAR, baseProps.logLevel);
        }
    });
}
exports.applyEnvVariables = applyEnvVariables;
function setDDEnvVariables(lambdas, props) {
    lambdas.forEach((lam) => {
        if (props.extensionLayerVersion) {
            if (props.env) {
                lam.addEnvironment(exports.DD_ENV_ENV_VAR, props.env);
            }
            if (props.service) {
                lam.addEnvironment(exports.DD_SERVICE_ENV_VAR, props.service);
            }
            if (props.version) {
                lam.addEnvironment(exports.DD_VERSION_ENV_VAR, props.version);
            }
            if (props.tags) {
                lam.addEnvironment(exports.DD_TAGS, props.tags);
            }
        }
    });
}
exports.setDDEnvVariables = setDDEnvVariables;
//# sourceMappingURL=data:application/json;base64,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