from setuptools import setup
from setuptools import find_packages

setup(
    name="chebai",
    version="0.0.1.dev0",
    packages=find_packages("chebai"),
    package_dir={'chebai': 'chebai'},
    data_files=[("chebai", ["chebai/preprocessing/bin/tokens.txt",
                            "chebai/preprocessing/bin/selfies.txt",
                            "chebai/preprocessing/bin/BPE_SWJ/merges.txt",
                            "chebai/preprocessing/bin/BPE_SWJ/vocab.json"])],
    url="",
    license="",
    author="MGlauer",
    author_email="martin.glauer@ovgu.de",
    description="",
    install_requires=[
        "certifi",
        "idna",
        "joblib",
        "networkx",
        "numpy",
        "pandas",
        "python-dateutil",
        "pytz",
        "requests",
        "scikit-learn",
        "scipy",
        "six",
        "threadpoolctl",
        "torch",
        "typing-extensions",
        "urllib3",
        "pytorch_lightning",
        "torch-scatter",
        "torch-sparse",
        "torch-cluster",
        "torch-spline-conv",
        "torch-geometric>=1.9.0",
        "transformers==4.24.0",
        "fastobo",
        "pysmiles",
        "click",
        "scikit-network",
        "svgutils",
        "matplotlib",
        "rdkit",
        "selfies"
    ],
    extras_require={"dev": ["black", "isort", "pre-commit"]},
)
