import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VirtualNetworkGatewayConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/virtual_network_gateway_connection#authorization_key VirtualNetworkGatewayConnection#authorization_key}
    */
    readonly authorizationKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/virtual_network_gateway_connection#enable_bgp VirtualNetworkGatewayConnection#enable_bgp}
    */
    readonly enableBgp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/virtual_network_gateway_connection#express_route_circuit_id VirtualNetworkGatewayConnection#express_route_circuit_id}
    */
    readonly expressRouteCircuitId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/virtual_network_gateway_connection#id VirtualNetworkGatewayConnection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/virtual_network_gateway_connection#local_network_gateway_id VirtualNetworkGatewayConnection#local_network_gateway_id}
    */
    readonly localNetworkGatewayId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/virtual_network_gateway_connection#location VirtualNetworkGatewayConnection#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/virtual_network_gateway_connection#name VirtualNetworkGatewayConnection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/virtual_network_gateway_connection#peer_virtual_network_gateway_id VirtualNetworkGatewayConnection#peer_virtual_network_gateway_id}
    */
    readonly peerVirtualNetworkGatewayId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/virtual_network_gateway_connection#resource_group_name VirtualNetworkGatewayConnection#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/virtual_network_gateway_connection#routing_weight VirtualNetworkGatewayConnection#routing_weight}
    */
    readonly routingWeight?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/virtual_network_gateway_connection#shared_key VirtualNetworkGatewayConnection#shared_key}
    */
    readonly sharedKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/virtual_network_gateway_connection#tags VirtualNetworkGatewayConnection#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/virtual_network_gateway_connection#type VirtualNetworkGatewayConnection#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/virtual_network_gateway_connection#use_policy_based_traffic_selectors VirtualNetworkGatewayConnection#use_policy_based_traffic_selectors}
    */
    readonly usePolicyBasedTrafficSelectors?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/virtual_network_gateway_connection#virtual_network_gateway_id VirtualNetworkGatewayConnection#virtual_network_gateway_id}
    */
    readonly virtualNetworkGatewayId: string;
    /**
    * ipsec_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/virtual_network_gateway_connection#ipsec_policy VirtualNetworkGatewayConnection#ipsec_policy}
    */
    readonly ipsecPolicy?: VirtualNetworkGatewayConnectionIpsecPolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/virtual_network_gateway_connection#timeouts VirtualNetworkGatewayConnection#timeouts}
    */
    readonly timeouts?: VirtualNetworkGatewayConnectionTimeouts;
}
export interface VirtualNetworkGatewayConnectionIpsecPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/virtual_network_gateway_connection#dh_group VirtualNetworkGatewayConnection#dh_group}
    */
    readonly dhGroup: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/virtual_network_gateway_connection#ike_encryption VirtualNetworkGatewayConnection#ike_encryption}
    */
    readonly ikeEncryption: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/virtual_network_gateway_connection#ike_integrity VirtualNetworkGatewayConnection#ike_integrity}
    */
    readonly ikeIntegrity: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/virtual_network_gateway_connection#ipsec_encryption VirtualNetworkGatewayConnection#ipsec_encryption}
    */
    readonly ipsecEncryption: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/virtual_network_gateway_connection#ipsec_integrity VirtualNetworkGatewayConnection#ipsec_integrity}
    */
    readonly ipsecIntegrity: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/virtual_network_gateway_connection#pfs_group VirtualNetworkGatewayConnection#pfs_group}
    */
    readonly pfsGroup: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/virtual_network_gateway_connection#sa_datasize VirtualNetworkGatewayConnection#sa_datasize}
    */
    readonly saDatasize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/virtual_network_gateway_connection#sa_lifetime VirtualNetworkGatewayConnection#sa_lifetime}
    */
    readonly saLifetime?: number;
}
export declare function virtualNetworkGatewayConnectionIpsecPolicyToTerraform(struct?: VirtualNetworkGatewayConnectionIpsecPolicyOutputReference | VirtualNetworkGatewayConnectionIpsecPolicy): any;
export declare class VirtualNetworkGatewayConnectionIpsecPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualNetworkGatewayConnectionIpsecPolicy | undefined;
    set internalValue(value: VirtualNetworkGatewayConnectionIpsecPolicy | undefined);
    private _dhGroup?;
    get dhGroup(): string;
    set dhGroup(value: string);
    get dhGroupInput(): string | undefined;
    private _ikeEncryption?;
    get ikeEncryption(): string;
    set ikeEncryption(value: string);
    get ikeEncryptionInput(): string | undefined;
    private _ikeIntegrity?;
    get ikeIntegrity(): string;
    set ikeIntegrity(value: string);
    get ikeIntegrityInput(): string | undefined;
    private _ipsecEncryption?;
    get ipsecEncryption(): string;
    set ipsecEncryption(value: string);
    get ipsecEncryptionInput(): string | undefined;
    private _ipsecIntegrity?;
    get ipsecIntegrity(): string;
    set ipsecIntegrity(value: string);
    get ipsecIntegrityInput(): string | undefined;
    private _pfsGroup?;
    get pfsGroup(): string;
    set pfsGroup(value: string);
    get pfsGroupInput(): string | undefined;
    private _saDatasize?;
    get saDatasize(): number;
    set saDatasize(value: number);
    resetSaDatasize(): void;
    get saDatasizeInput(): number | undefined;
    private _saLifetime?;
    get saLifetime(): number;
    set saLifetime(value: number);
    resetSaLifetime(): void;
    get saLifetimeInput(): number | undefined;
}
export interface VirtualNetworkGatewayConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/virtual_network_gateway_connection#create VirtualNetworkGatewayConnection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/virtual_network_gateway_connection#delete VirtualNetworkGatewayConnection#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/virtual_network_gateway_connection#read VirtualNetworkGatewayConnection#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/virtual_network_gateway_connection#update VirtualNetworkGatewayConnection#update}
    */
    readonly update?: string;
}
export declare function virtualNetworkGatewayConnectionTimeoutsToTerraform(struct?: VirtualNetworkGatewayConnectionTimeoutsOutputReference | VirtualNetworkGatewayConnectionTimeouts | cdktf.IResolvable): any;
export declare class VirtualNetworkGatewayConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualNetworkGatewayConnectionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualNetworkGatewayConnectionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurestack/r/virtual_network_gateway_connection azurestack_virtual_network_gateway_connection}
*/
export declare class VirtualNetworkGatewayConnection extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurestack_virtual_network_gateway_connection";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurestack/r/virtual_network_gateway_connection azurestack_virtual_network_gateway_connection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VirtualNetworkGatewayConnectionConfig
    */
    constructor(scope: Construct, id: string, config: VirtualNetworkGatewayConnectionConfig);
    private _authorizationKey?;
    get authorizationKey(): string;
    set authorizationKey(value: string);
    resetAuthorizationKey(): void;
    get authorizationKeyInput(): string | undefined;
    private _enableBgp?;
    get enableBgp(): boolean | cdktf.IResolvable;
    set enableBgp(value: boolean | cdktf.IResolvable);
    resetEnableBgp(): void;
    get enableBgpInput(): boolean | cdktf.IResolvable | undefined;
    private _expressRouteCircuitId?;
    get expressRouteCircuitId(): string;
    set expressRouteCircuitId(value: string);
    resetExpressRouteCircuitId(): void;
    get expressRouteCircuitIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _localNetworkGatewayId?;
    get localNetworkGatewayId(): string;
    set localNetworkGatewayId(value: string);
    resetLocalNetworkGatewayId(): void;
    get localNetworkGatewayIdInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _peerVirtualNetworkGatewayId?;
    get peerVirtualNetworkGatewayId(): string;
    set peerVirtualNetworkGatewayId(value: string);
    resetPeerVirtualNetworkGatewayId(): void;
    get peerVirtualNetworkGatewayIdInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _routingWeight?;
    get routingWeight(): number;
    set routingWeight(value: number);
    resetRoutingWeight(): void;
    get routingWeightInput(): number | undefined;
    private _sharedKey?;
    get sharedKey(): string;
    set sharedKey(value: string);
    resetSharedKey(): void;
    get sharedKeyInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _usePolicyBasedTrafficSelectors?;
    get usePolicyBasedTrafficSelectors(): boolean | cdktf.IResolvable;
    set usePolicyBasedTrafficSelectors(value: boolean | cdktf.IResolvable);
    resetUsePolicyBasedTrafficSelectors(): void;
    get usePolicyBasedTrafficSelectorsInput(): boolean | cdktf.IResolvable | undefined;
    private _virtualNetworkGatewayId?;
    get virtualNetworkGatewayId(): string;
    set virtualNetworkGatewayId(value: string);
    get virtualNetworkGatewayIdInput(): string | undefined;
    private _ipsecPolicy;
    get ipsecPolicy(): VirtualNetworkGatewayConnectionIpsecPolicyOutputReference;
    putIpsecPolicy(value: VirtualNetworkGatewayConnectionIpsecPolicy): void;
    resetIpsecPolicy(): void;
    get ipsecPolicyInput(): VirtualNetworkGatewayConnectionIpsecPolicy | undefined;
    private _timeouts;
    get timeouts(): VirtualNetworkGatewayConnectionTimeoutsOutputReference;
    putTimeouts(value: VirtualNetworkGatewayConnectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VirtualNetworkGatewayConnectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
